/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.system.calendar;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.sys.model.SysCalendar;
import com.jxdinfo.hussar.core.sys.service.ISysCalendarService;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/calendarFront"})
public class WorkCalendarFrontController
extends BaseController {
    @Resource
    private ISysCalendarService sysCalendarService;

    @RequiresPermissions(value={"calendar:list"})
    @RequestMapping(value={"/list"})
    public ApiResponse<List<SysCalendar>> eventsList() {
        String startTime = super.getPara("startTime").trim();
        String endTime = super.getPara("endTime").trim();
        Date start = ToolUtil.isEmpty((Object)startTime) ? null : DateUtil.parse((String)startTime, (String)"yyyy-MM-dd");
        Date end = ToolUtil.isEmpty((Object)startTime) ? null : DateUtil.parse((String)endTime, (String)"yyyy-MM-dd");
        return ApiResponse.data((Object)this.sysCalendarService.getEventsBetweenDate(start, end));
    }

    @RequestMapping(value={"/addEvent"})
    @BussinessLog(key="/calendar/addEvent", type="01", value="\u5de5\u4f5c\u65e5\u5386\u6279\u91cf\u65b0\u589e")
    @RequiresPermissions(value={"calendar:addEvent"})
    public ApiResponse<?> addEvent(SysCalendar sysCalendar) {
        List calendarList = this.sysCalendarService.getEventsBetweenDate(sysCalendar.getStartTime(), sysCalendar.getEndTime());
        if (ToolUtil.isNotEmpty((Object)calendarList)) {
            return ApiResponse.fail((int)HttpCode.CONFLICT.value(), (String)"\u4fdd\u5b58\u5931\u8d25\uff01\uff08\u8be5\u65f6\u95f4\u8303\u56f4\u5185\u5df2\u5b58\u5728\u4e8b\u4ef6\uff01\uff09");
        }
        List<Date> list = this.getBetweenDates(sysCalendar.getStartTime(), sysCalendar.getEndTime());
        if (list.size() > 31) {
            return ApiResponse.fail((int)HttpCode.CONFLICT.value(), (String)"\u4fdd\u5b58\u5931\u8d25\uff01\uff08\u65b0\u589e\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc7\u4e00\u4e2a\u6708\uff09");
        }
        Date createTime = new Date();
        String creator = ShiroKit.getUser().getAccount();
        ArrayList<SysCalendar> sysCalendarList = new ArrayList<SysCalendar>();
        for (Date start : list) {
            SysCalendar cal = new SysCalendar();
            cal.setTitle(sysCalendar.getTitle());
            cal.setClassName(sysCalendar.getClassName());
            cal.setRemark(sysCalendar.getRemark());
            cal.setCreator(creator);
            cal.setCreateTime(createTime);
            cal.setStartTime(start);
            sysCalendarList.add(cal);
        }
        if (ToolUtil.isNotEmpty(sysCalendarList)) {
            this.sysCalendarService.insertBatch(sysCalendarList, sysCalendarList.size());
        }
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/addOneEvent"})
    @BussinessLog(key="/calendar/addOneEvent", type="01", value="\u5de5\u4f5c\u65e5\u5386\u5355\u65e5\u65b0\u589e")
    @RequiresPermissions(value={"calendar:addOneEvent"})
    public ApiResponse<?> addOneEvent(SysCalendar sysCalendar) {
        Date createTime = new Date();
        String creator = ShiroKit.getUser().getAccount();
        sysCalendar.setCreator(creator);
        sysCalendar.setCreateTime(createTime);
        this.sysCalendarService.insert((Object)sysCalendar);
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/editEvent"})
    @BussinessLog(key="/calendar/editEvent", type="03", value="\u5de5\u4f5c\u65e5\u5386\u4fee\u6539")
    @RequiresPermissions(value={"calendar:editEvent"})
    public ApiResponse<?> editEvent(SysCalendar sysCalendar) {
        this.sysCalendarService.updateById((Object)sysCalendar);
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/dayEvent"})
    public ApiResponse<SysCalendar> dayEvent(@RequestParam(value="startTime") String startTime) {
        Date start = ToolUtil.isEmpty((Object)startTime) ? null : DateUtil.parse((String)startTime, (String)"yyyy-MM-dd");
        SysCalendar sysCalendar = (SysCalendar)this.sysCalendarService.selectOne(new EntityWrapper().eq("start_time", (Object)start));
        return ApiResponse.data((Object)sysCalendar);
    }

    @RequestMapping(value={"/delEvent"})
    @BussinessLog(key="/calendar/delEvent", type="02", value="\u5de5\u4f5c\u65e5\u5386\u6279\u91cf\u5220\u9664")
    @RequiresPermissions(value={"calendar:delEvent"})
    public ApiResponse<?> delEvent(SysCalendar sysCalendar) {
        this.sysCalendarService.delete(new EntityWrapper().ge("start_time", (Object)sysCalendar.getStartTime()).le("start_time", (Object)sysCalendar.getEndTime()).in("class_name", sysCalendar.getClassName()));
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/delOneEvent"})
    @BussinessLog(key="/calendar/delOneEvent", type="02", value="\u5de5\u4f5c\u65e5\u5386\u5355\u65e5\u5220\u9664")
    @RequiresPermissions(value={"calendar:delOneEvent"})
    public ApiResponse<?> delOneEvent(String id) {
        this.sysCalendarService.deleteById((Serializable)((Object)id));
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    private List<Date> getBetweenDates(Date startDate, Date endDate) {
        ArrayList<Date> result = new ArrayList<Date>();
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(startDate);
        while (startDate.getTime() <= endDate.getTime()) {
            result.add(tempStart.getTime());
            tempStart.add(6, 1);
            startDate = tempStart.getTime();
        }
        return result;
    }
}

