/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.system.cache;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.plugins.Page;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.ForestNodeMerger;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.config.front.common.response.IResultCode;
import com.jxdinfo.hussar.config.front.common.response.ResultCode;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.cache.HussarEhcacheManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import net.sf.ehcache.search.Result;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ehcacheFront"})
@ConditionalOnProperty(prefix="hussar", name={"stand-alone"}, havingValue="true", matchIfMissing=false)
public class EhcacheFrontController
extends BaseController {
    @Resource
    private HussarCacheManager hussarCacheManager;

    @RequestMapping(value={"/list"})
    @RequiresPermissions(value={"ehcache:list"})
    @BussinessLog(key="/ehcache/list", type="04", value="\u83b7\u53d6\u7f13\u5b58\u5217\u8868")
    public ApiResponse<Map<String, Object>> getCacheTableList() {
        String pageNum = super.getPara("current") == null ? "" : super.getPara("current").trim();
        String limitNum = super.getPara("size") == null ? "" : super.getPara("size").trim();
        String cacheName = super.getPara("cacheName") == null ? "" : super.getPara("cacheName").trim();
        String key = super.getPara("userName") == null ? "" : super.getPara("userName").trim();
        Page page = new Page(Integer.valueOf(pageNum).intValue(), Integer.valueOf(limitNum).intValue());
        List records = ((HussarEhcacheManager)this.hussarCacheManager).getEhCaches(cacheName, key);
        ArrayList list = new ArrayList();
        for (Result result : records) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("key", result.getKey());
            map.put("value", result.getValue());
            list.add(map);
        }
        page.setRecords(list);
        page.setTotal(list.size());
        HashMap<String, Object> result = new HashMap<String, Object>(10);
        result.put("code", "0");
        result.put("msg", "");
        result.put("count", page.getTotal());
        result.put("data", page.getRecords());
        return ApiResponse.data(result);
    }

    @RequestMapping(value={"/deleteByKeys"})
    @RequiresPermissions(value={"ehcache:deleteByKeys"})
    @BussinessLog(key="/ehcache/deleteByKeys", type="02", value="\u5220\u9664\u7f13\u5b58")
    public ApiResponse<?> deleteByKeys() {
        String cacheName = super.getPara("cacheName").trim();
        String keys = super.getPara("keys").trim();
        JSONArray arr = JSON.parseArray((String)keys);
        ((HussarEhcacheManager)this.hussarCacheManager).delcache(cacheName, (List)arr);
        return ApiResponse.success((IResultCode)ResultCode.SUCCESS);
    }

    @RequestMapping(value={"/getAllCacheName"})
    public ApiResponse<List<JSTreeModel>> getAllCacheName() {
        Collection cacheNamesList = ((HussarEhcacheManager)this.hussarCacheManager).getCacheNames();
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId("1");
        root.setText("\u7f13\u5b58\u540d\u79f0");
        root.setParent("#");
        root.setType("root");
        result.add(root);
        for (String cacheName : cacheNamesList) {
            JSTreeModel name = new JSTreeModel();
            name.setId(cacheName);
            name.setText(cacheName);
            name.setParent("1");
            name.setType("name");
            result.add(name);
        }
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }
}

