/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.controller;

import com.jxdinfo.hussar.bsp.permit.service.ISysUserroleAuditService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.sys.model.DicSingle;
import com.jxdinfo.hussar.core.sys.service.ISysDicRefService;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/userRoleReviewFront"})
public class UserRoleReviewFrontController
extends BaseController {
    @Resource
    private ISysUserroleAuditService iSysUserroleAuditService;
    @Resource
    private ISysDicRefService iSysDicRefService;

    @RequestMapping(value={"/list"})
    @RequiresPermissions(value={"userRoleReview:list"})
    @BussinessLog(key="/userRoleReview/list", type="04", value="\u7528\u6237\u89d2\u8272\u5ba1\u6838\u5217\u8868")
    public ApiResponse<Map<String, Object>> list() {
        String userAccount = super.getPara("account");
        String userName = super.getPara("name");
        String type = super.getPara("status");
        String page = super.getPara("current");
        String limit = super.getPara("size");
        Map result = this.iSysUserroleAuditService.getUserRoleReviewList(page, limit, userAccount, userName, type);
        return ApiResponse.data((Object)result);
    }

    @RequestMapping(value={"/reviewSubmit"})
    @RequiresPermissions(value={"userRoleReview:reviewSubmit"})
    @BussinessLog(key="/userRoleReview/reviewSubmit", type="03", value="\u7528\u6237\u89d2\u8272\u5ba1\u6838\u901a\u8fc7")
    public ApiResponse<?> reviewSubmit() {
        String userId = this.getPara("userId").trim();
        String roleId = this.getPara("roleId").trim();
        String opsTypeId = this.getPara("opsTypeId").trim();
        this.iSysUserroleAuditService.reviewSubmit(userId, roleId, opsTypeId);
        return ApiResponse.success((String)"\u901a\u8fc7\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/refuseSubmit"})
    @RequiresPermissions(value={"userRoleReview:refuseSubmit"})
    @BussinessLog(key="/userRoleReview/refuseSubmit", type="03", value="\u7528\u6237\u89d2\u8272\u5ba1\u6838\u9a73\u56de")
    public ApiResponse<?> refuseSubmit() {
        String userId = this.getPara("userId");
        String roleId = this.getPara("roleId");
        String opsTypeId = this.getPara("opsTypeId");
        this.iSysUserroleAuditService.refuseSubmit(userId, roleId, opsTypeId);
        return ApiResponse.success((String)"\u9a73\u56de\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/statusOption"})
    @ResponseBody
    public List<DicSingle> statusOption() {
        return this.iSysDicRefService.getDictByType("user_role_review");
    }
}

