/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.jxdinfo.hussar.bsp.audit.service.ISysUsersAuditService;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.organ.vo.ProxyTreeVo;
import com.jxdinfo.hussar.bsp.permit.model.SysPasswordHist;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysConfRolesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.constant.dictmap.UserDict;
import com.jxdinfo.hussar.common.constant.enums.Whether;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.ForestNodeMerger;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.config.properties.HussarProperties;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.encrypt.CryptoUtil;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.shiro.encrypt.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/userFront"})
public class SysUsersFrontController
extends BaseController {
    @Resource
    private SysOrgManageService sysOrgManageService;
    @Resource
    private ISysConfRolesService iSysConfRolesService;
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    @Resource
    private HussarProperties hussarProperties;
    @Resource
    private ISysUsersAuditService iSysUsersAuditService;

    @RequestMapping(value={"/gradeRole"})
    public ApiResponse<Boolean> gradeRole() {
        ShiroUser shiroUser = ShiroKit.getUser();
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        return ApiResponse.data((Object)isGradeAdmin);
    }

    @RequiresPermissions(value={"user:userTree"})
    @RequestMapping(value={"/userTree"})
    public ApiResponse<List<JSTreeModel>> userTree() {
        String isExport = super.getPara("isExport");
        String parentId = super.getPara("parentId");
        List result = this.iSysUsersService.getUserTree(isExport, parentId);
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @Deprecated
    public List<ProxyTreeVo> doRecursive(List<ProxyTreeVo> list) {
        ArrayList<ProxyTreeVo> result = new ArrayList<ProxyTreeVo>();
        this.recursive(list, result, "");
        if (result.size() == 0) {
            for (ProxyTreeVo proxyTreeVo : list) {
                if (!"#".equals(proxyTreeVo.getParent())) continue;
                result.add(proxyTreeVo);
            }
        }
        return result;
    }

    @Deprecated
    public void recursive(List<ProxyTreeVo> list, List<ProxyTreeVo> result, String parentId) {
        for (int i = list.size() - 1; i >= 0; --i) {
            ProxyTreeVo proxyTreeVo;
            if (i > list.size() - 1) {
                i = list.size() - 1;
            }
            if (!"USER".equals((proxyTreeVo = list.get(i)).getCode()) && !parentId.equals(proxyTreeVo.getId())) continue;
            parentId = proxyTreeVo.getParent();
            result.add(proxyTreeVo);
            list.remove(i);
            this.recursive(list, result, parentId);
        }
    }

    @RequiresPermissions(value={"user:orderTree"})
    @RequestMapping(value={"/orderTree"})
    public ApiResponse<List<JSTreeModel>> orderTree() {
        String orgId = super.getPara("orgId") == null ? "" : super.getPara("orgId").trim();
        List result = this.sysOrgManageService.getUserOrderTree(orgId);
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @BussinessLog(key="/user/saveUserOrder", type="03", value="\u7528\u6237\u6392\u5e8f")
    @RequiresPermissions(value={"user:saveUserOrder"})
    @RequestMapping(value={"/saveUserOrder"})
    public ApiResponse<Map<String, Object>> saveUserOrder() {
        String treeInfo = super.getPara("treeInfo").trim();
        JSONArray treeArr = JSONArray.parseArray((String)treeInfo);
        if (ToolUtil.isNotEmpty((Object)treeArr)) {
            this.iSysUsersService.saveUserOrder(treeArr);
            return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u6392\u5e8f\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u6ca1\u6709\u9700\u8981\u4fdd\u5b58\u6392\u5e8f\u7684\u7528\u6237\uff01");
    }

    @BussinessLog(key="/user/add", type="01", value="\u65b0\u589e\u7528\u6237")
    @RequiresPermissions(value={"user:add"})
    @RequestMapping(value={"/add"})
    @ResponseBody
    @CacheEvict(value={"user_ip"}, allEntries=true)
    public ApiResponse<Object> addUser(SysUsers sysUsers) {
        String roleIds = super.getPara("roleIds") == null ? "" : super.getPara("roleIds").trim();
        Tip result = this.iSysUsersService.addUser(sysUsers, roleIds);
        if (result.getCode() != HttpCode.OK.value().intValue()) {
            return ApiResponse.fail((int)result.getCode(), (String)result.getMessage());
        }
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    @BussinessLog(key="/user/edit", type="03", value="\u4fee\u6539\u7528\u6237", pk="userId", dict=UserDict.class)
    @RequiresPermissions(value={"user:edit"})
    @RequestMapping(value={"/edit"})
    @CacheEvict(value={"user_ip"}, allEntries=true)
    public ApiResponse<Map<String, Object>> editUser(SysUsers sysUsers) {
        String userId = sysUsers.getUserId();
        String roleIds = super.getPara("roleIds").trim();
        if (!this.hussarProperties.getLoginUpperOpen().booleanValue()) {
            sysUsers.setUserAccount(sysUsers.getUserAccount().toUpperCase());
        }
        String[] ids = roleIds.split(",");
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 0; i < ids.length; ++i) {
            if (list.contains(ids[i])) continue;
            list.add(ids[i]);
        }
        ids = list.toArray(new String[list.size()]);
        if (this.iSysConfRolesService.isIncludeConfRole(ids)) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u4fee\u6539\u5931\u8d25\uff01\uff08\u6240\u9009\u89d2\u8272\u4e0d\u5141\u8bb8\u8d85\u8fc7\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6\u7684\u57fa\u6570\uff01\uff09");
        }
        if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isUserAudit() && this.iSysUsersAuditService.adjustEdit(sysUsers.getUserId())) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u4fee\u6539\uff01");
        }
        sysUsers.setDepartmentId(sysUsers.getCorporationId());
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("userId", userId);
        map.put("roleIds", ids);
        map.put("sysUsers", sysUsers);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)this.iSysUsersService.editUser(map).getMessage());
    }

    @RequestMapping(value={"/userInfo"})
    @BussinessLog(key="/user/userInfo", type="04", value="\u7528\u6237\u8be6\u60c5")
    @RequiresPermissions(value={"user:userInfo"})
    public ApiResponse<ArrayList<Object>> userInfo() {
        String id = super.getPara("id") == null ? "" : super.getPara("id").trim();
        ArrayList list = this.iSysUsersService.getUserInfo(id);
        LogObjectHolder.me().set(list.get(0));
        return ApiResponse.data((Object)list);
    }

    @RequestMapping(value={"/currentUserInfo"})
    public ApiResponse<ArrayList<Object>> currentUserInfo() {
        String userId = ShiroKit.getUser().getId();
        ArrayList list = this.iSysUsersService.getUserInfo(userId);
        return ApiResponse.data((Object)list);
    }

    @BussinessLog(key="/user/delete", type="02", value="\u5220\u9664\u7528\u6237")
    @RequiresPermissions(value={"user:delete"})
    @RequestMapping(value={"/delete"})
    public ApiResponse<Map<String, Object>> delUser() {
        String userId;
        String string = userId = super.getPara("userId") == null ? "" : super.getPara("userId").trim();
        if (ToolUtil.isEmpty((Object)userId)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        ShiroUser shiroUser = ShiroKit.getUser();
        SysUsers sysUser = this.iSysUsersService.getUser(userId);
        if (Whether.YES.getValue().equals(sysUser.getIsSys())) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5220\u9664\u5931\u8d25\uff01\uff08\u4e0d\u80fd\u5220\u9664\u7ba1\u7406\u5458\u7528\u6237\uff01\uff09");
        }
        if (shiroUser.getId().equals(userId)) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5220\u9664\u5931\u8d25\uff01\uff08\u4e0d\u80fd\u5220\u9664\u5f53\u524d\u7528\u6237\uff01\uff09");
        }
        if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isUserAudit() && this.iSysUsersAuditService.adjustEdit(userId)) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u5220\u9664\uff01");
        }
        Tip tip = this.iSysUsersService.delUser(sysUser);
        if (ToolUtil.isNotEmpty((Object)tip.getCode())) {
            return ApiResponse.fail((int)tip.getCode(), (String)tip.getMessage());
        }
        return ApiResponse.success((int)HttpCode.OK.value(), (String)tip.getMessage());
    }

    @BussinessLog(key="/user/cancelUser", type="02", value="\u6ce8\u9500\u7528\u6237")
    @RequiresPermissions(value={"user:cancelUser"})
    @RequestMapping(value={"/cancelUser"})
    public ApiResponse<Map<String, Object>> cancelUser() {
        String userId;
        String string = userId = super.getPara("userId") == null ? "" : super.getPara("userId").trim();
        if (ToolUtil.isEmpty((Object)userId)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        ShiroUser shiroUser = ShiroKit.getUser();
        SysUsers sysUser = this.iSysUsersService.getUser(userId);
        if (Whether.YES.getValue().equals(sysUser.getIsSys())) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u6ce8\u9500\u5931\u8d25\uff01\uff08\u4e0d\u80fd\u6ce8\u9500\u7ba1\u7406\u5458\u7528\u6237\uff01\uff09");
        }
        if (shiroUser.getId().equals(userId)) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u6ce8\u9500\u5931\u8d25\uff01\uff08\u4e0d\u80fd\u6ce8\u9500\u5f53\u524d\u7528\u6237\uff01\uff09");
        }
        if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isUserAudit() && this.iSysUsersAuditService.adjustEdit(userId)) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u6ce8\u9500\uff01");
        }
        Tip tip = this.iSysUsersService.cancelUser(sysUser);
        if (ToolUtil.isNotEmpty((Object)tip.getCode())) {
            return ApiResponse.fail((int)tip.getCode(), (String)tip.getMessage());
        }
        return ApiResponse.success((int)HttpCode.OK.value(), (String)tip.getMessage());
    }

    @RequestMapping(value={"/updatePwd"})
    @BussinessLog(key="/user/updatePwd", type="03", value="\u4fee\u6539\u7528\u6237\u5bc6\u7801")
    @RequiresPermissions(value={"user:updatePwd"})
    public ApiResponse<Map<String, Object>> updatePwd() {
        String oldPwd = super.getPara("oldPwd") == null ? "" : super.getPara("oldPwd");
        String newPwd = super.getPara("newPwd") == null ? "" : super.getPara("newPwd");
        String cPwd = super.getPara("confirmPwd") == null ? "" : super.getPara("confirmPwd");
        oldPwd = CryptoUtil.decode((String)oldPwd);
        newPwd = CryptoUtil.decode((String)newPwd);
        cPwd = CryptoUtil.decode((String)cPwd);
        String regular = this.globalProperties.getPwdComplexityRegular().replaceAll("/", "");
        String hint = this.globalProperties.getUnmatchedHint();
        if (!newPwd.matches(regular)) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)hint);
        }
        if (!newPwd.equals(cPwd)) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u4fee\u6539\u5931\u8d25\uff01\uff08\u4e24\u6b21\u8f93\u5165\u7684\u5bc6\u7801\u4e0d\u4e00\u81f4\uff01\uff09");
        }
        String oPwd = this.credentialsMatcher.passwordEncode(oldPwd.getBytes());
        String nPwd = this.credentialsMatcher.passwordEncode(newPwd.getBytes());
        String userId = ShiroKit.getUser().getId();
        SysUsers user = this.iSysUsersService.getUser(userId);
        String userAccount = user.getUserAccount();
        if (newPwd.toLowerCase().contains(userAccount.toLowerCase())) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u4fee\u6539\u5931\u8d25\uff01\uff08\u5bc6\u7801\u5305\u542b\u7528\u6237\u540d\uff01\uff09");
        }
        if (!oPwd.equals(user.getPassword())) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u4fee\u6539\u5931\u8d25\uff01\uff08\u539f\u5bc6\u7801\u8f93\u5165\u9519\u8bef\uff01\uff09");
        }
        List list = this.iSysUsersService.getPwdHist(userId);
        if (ToolUtil.isEmpty((Object)list) && this.globalProperties.getDefaultPassword().equals(newPwd)) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u4fee\u6539\u5931\u8d25\uff01\uff08\u65b0\u5bc6\u7801\u4e0d\u80fd\u548c\u9ed8\u8ba4\u5bc6\u7801\u76f8\u540c\uff01\uff09");
        }
        for (SysPasswordHist sysPasswordHist : list) {
            if (!nPwd.equals(sysPasswordHist.getPassword())) continue;
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)("\u4fee\u6539\u5931\u8d25\uff01\uff08\u65b0\u5bc6\u7801\u4e0d\u80fd\u548c\u524d" + this.globalProperties.getPwdRepeatTime() + "\u6b21\u7684\u5bc6\u7801\u76f8\u540c\uff09"));
        }
        user.setPassword(nPwd);
        this.iSysUsersService.updatePwd(user);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/resetAllPwd"})
    @RequiresPermissions(value={"user:resetAllPwd"})
    @BussinessLog(key="/user/resetAllPwd", type="11", value="\u91cd\u7f6e\u5bc6\u7801")
    public ApiResponse<Map<String, Object>> resetAllPwd() {
        String userId;
        SysUsers user;
        Object[] userIds = super.getPara("userIds") == null ? "".split(",") : super.getPara("userIds").split(",");
        String adminPwd = super.getPara("superPws") == null ? "" : super.getPara("superPws");
        String newPwd = super.getPara("password") == null ? "" : super.getPara("password");
        String cPwd = super.getPara("passwordRepeat") == null ? "" : super.getPara("passwordRepeat");
        adminPwd = CryptoUtil.decode((String)adminPwd);
        newPwd = CryptoUtil.decode((String)newPwd);
        cPwd = CryptoUtil.decode((String)cPwd);
        String aPwd = this.credentialsMatcher.passwordEncode(adminPwd.getBytes());
        if (!aPwd.equals((user = this.iSysUsersService.getUser(userId = ShiroKit.getUser().getId())).getPassword())) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u91cd\u7f6e\u5931\u8d25\uff01\uff08\u60a8\u7684\u5bc6\u7801\u8f93\u5165\u9519\u8bef\uff09");
        }
        if (!newPwd.equals(cPwd)) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u91cd\u7f6e\u5931\u8d25\uff01\uff08\u4e24\u6b21\u8f93\u5165\u7684\u5bc6\u7801\u4e0d\u4e00\u81f4\uff01\uff09");
        }
        String regular = this.globalProperties.getPwdComplexityRegular().replaceAll("/", "");
        String hint = this.globalProperties.getUnmatchedHint();
        if (!newPwd.matches(regular)) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)hint);
        }
        List sysUsers = this.iSysUsersService.selectList(new EntityWrapper().in("user_id", userIds));
        for (SysUsers users : sysUsers) {
            if (!newPwd.toLowerCase().contains(users.getUserAccount().toLowerCase())) continue;
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)("\u4fee\u6539\u5931\u8d25\uff01\uff08" + users.getUserName() + "\u5bc6\u7801\u5305\u542b\u7528\u6237\u540d\uff09"));
        }
        String nPwd = this.credentialsMatcher.passwordEncode(newPwd.getBytes());
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("newPwd", nPwd);
        map.put("userIds", userIds);
        long count = this.iSysUsersService.resetAllPwd(map);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)("\u91cd\u7f6e\u6210\u529f\uff0c" + count + "\u4e2a\u7528\u6237\u7684\u5bc6\u7801\u5df2\u88ab\u91cd\u7f6e\uff01"));
    }

    @RequestMapping(value={"/setGetBackPwd"})
    public ApiResponse<Map<String, Object>> setGetBackPwd(@RequestBody Map<String, String> param) {
        String ques = param.get("ques") == null ? "" : param.get("ques").trim();
        String key = param.get("key") == null ? "" : param.get("key").trim();
        String userId = ShiroKit.getUser().getId();
        HashMap<String, String> map = new HashMap<String, String>(5);
        map.put("userId", userId);
        map.put("ques", ques);
        map.put("key", key);
        if (this.iSysUsersService.setGetBackPwd(map)) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u8bbe\u7f6e\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u8bbe\u7f6e\u5931\u8d25\uff01");
    }

    @BussinessLog(key="/user/copyRole", type="03", value="\u590d\u5236\u89d2\u8272")
    @RequiresPermissions(value={"user:copyRole"})
    @RequestMapping(value={"/copyRole"})
    public ApiResponse<Map<String, Object>> copyRole() {
        String[] copyTos;
        String copyFrom = super.getPara("copyFrom") == null ? "" : super.getPara("copyFrom").trim();
        for (String copyTo : copyTos = super.getPara("copyTo") == null ? "".split(",") : super.getPara("copyTo").trim().split(",")) {
            boolean result = this.iSysUsersService.copyRole(copyFrom, copyTo);
            if (result) continue;
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u89d2\u8272\u590d\u5236\u5931\u8d25\uff01\uff08\u590d\u5236\u7684\u89d2\u8272\u4e0e\u539f\u89d2\u8272\u4e2d\u6709\u4e0d\u76f8\u5bb9\u89d2\u8272\uff01\uff09");
        }
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u89d2\u8272\u590d\u5236\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/userList"})
    @BussinessLog(key="/user/userList", type="04", value="\u91cd\u7f6e\u5bc6\u7801\u7528\u6237\u5217\u8868")
    @RequiresPermissions(value={"user:userList"})
    public ApiResponse<Object> userTableList() {
        String userName;
        String pageNum = super.getPara("current") == null ? "" : super.getPara("current").trim();
        String limitNum = super.getPara("size") == null ? "" : super.getPara("size").trim();
        String userAccount = super.getPara("userAccount") == null ? "" : super.getPara("userAccount").trim();
        String string = userName = super.getPara("userName") == null ? "" : super.getPara("userName").trim();
        if (ToolUtil.isNotEmpty((Object)userAccount)) {
            userAccount = userAccount.replaceAll("%", "\\\\%").replaceAll("_", "\\\\_");
        }
        if (ToolUtil.isNotEmpty((Object)userName)) {
            userName = userName.replaceAll("%", "\\\\%").replaceAll("_", "\\\\_");
        }
        Page page = new Page(Integer.valueOf(pageNum).intValue(), Integer.valueOf(limitNum).intValue());
        page = this.iSysUsersService.getUserList(page, userAccount, userName);
        JSONObject json = new JSONObject();
        json.put("data", (Object)page.getRecords());
        json.put("code", (Object)"0");
        json.put("msg", (Object)"");
        json.put("count", (Object)page.getTotal());
        return ApiResponse.data((Object)json);
    }

    @RequestMapping(value={"/saveSelfInfo"})
    public ApiResponse<Map<String, Object>> saveSelfInfo() {
        String shiroUserId = ShiroKit.getUser().getId();
        String userId = super.getPara("userId") == null ? "" : super.getPara("userId").trim();
        userId = CryptoUtil.decode((String)userId);
        if (shiroUserId != null && shiroUserId.equals(userId)) {
            String eMail = super.getPara("eMail") == null ? "" : super.getPara("eMail").trim();
            eMail = CryptoUtil.decode((String)eMail);
            String weChat = super.getPara("weChat") == null ? "" : super.getPara("weChat").trim();
            weChat = CryptoUtil.decode((String)weChat);
            String mobile = super.getPara("mobile") == null ? "" : super.getPara("mobile").trim();
            mobile = CryptoUtil.decode((String)mobile);
            String telephone = super.getPara("telephone") == null ? "" : super.getPara("telephone").trim();
            telephone = CryptoUtil.decode((String)telephone);
            SysUsers user = (SysUsers)this.iSysUsersService.selectById((Serializable)((Object)userId));
            user.setEMail(eMail);
            user.setWeChat(weChat);
            user.setMobile(mobile);
            user.setTelephone(telephone);
            user.updateById();
            return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u4fee\u6539\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u975e\u6cd5\u8bf7\u6c42\uff01");
    }

    @RequestMapping(value={"/exportData"})
    @RequiresPermissions(value={"user:exportData"})
    @BussinessLog(key="/user/exportData", type="04", value="\u7528\u6237\u6570\u636e\u5bfc\u51fa")
    public void exportData(HttpServletResponse response) {
        String ids = super.getPara("ids");
        List<String> idList = Arrays.asList(ids.split(","));
        this.iSysUsersService.exportData(idList, response);
    }
}

