/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.jxdinfo.hussar.bsp.organ.model.SysStru;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.organ.vo.RoleOrgUserVo;
import com.jxdinfo.hussar.bsp.permit.dao.SysRoleGroupMapper;
import com.jxdinfo.hussar.bsp.permit.dictmap.RoleGroupDict;
import com.jxdinfo.hussar.bsp.permit.dictmap.RoleManagerDict;
import com.jxdinfo.hussar.bsp.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.bsp.permit.model.SysRoleResource;
import com.jxdinfo.hussar.bsp.permit.model.SysRoles;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysConfRolesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysResTypeService;
import com.jxdinfo.hussar.bsp.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.bsp.permit.service.ISysRolesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUserroleAuditService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.userutil.UserUtil;
import com.jxdinfo.hussar.common.utils.ForestNodeMerger;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/roleManagerFront"})
public class RoleManagerFrontController
extends BaseController {
    @Resource
    private UserUtil userUtil;
    @Resource
    private SysOrgManageService sysOrgManageService;
    @Resource
    private ISysResTypeService iSysResTypeService;
    @Resource
    private ISysRolesService iSysRolesService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysRoleResourceService iSysRoleResourceService;
    @Resource
    private ISysConfRolesService isConfRolesService;
    @Resource
    private ISysUserRoleService iSysUserRoleService;
    @Resource
    private ISysUserroleAuditService isAuditService;
    @Resource
    private SysRoleGroupMapper sysRoleGroupMapper;

    @RequiresPermissions(value={"roleManager:roleTree"})
    @RequestMapping(value={"/roleTree"})
    public ApiResponse<List<JSTreeModel>> roleTree() {
        String nodeId = super.getPara("nodeId");
        String userId = super.getPara("userId");
        String functionType = super.getPara("functionType");
        return ApiResponse.data(ForestNodeMerger.merge(this.iSysRolesService.getRoleTree(nodeId, userId, functionType)));
    }

    @RequestMapping(value={"/getUserRole"})
    public ApiResponse<List<String>> getUserRole() {
        String userId = super.getPara("userId") == null ? "" : super.getPara("userId");
        return ApiResponse.data((Object)this.iSysRolesService.getUserRoleList(userId));
    }

    @RequestMapping(value={"/lazyRoleTree"})
    public ApiResponse<List<JSTreeModel>> lazyRoleTree() {
        String nodeId = super.getPara("nodeId");
        ShiroUser shiroUser = ShiroKit.getUser();
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            String isExport = super.getPara("isExport");
            return ApiResponse.data(ForestNodeMerger.merge(this.iSysRolesService.getLazyOrganRoleTree(nodeId, Boolean.parseBoolean(isExport))));
        }
        return ApiResponse.data(ForestNodeMerger.merge(this.iSysRolesService.getLazyRoleTree(nodeId)));
    }

    @RequestMapping(value={"/selfRoleTree"})
    public ApiResponse<List<JSTreeModel>> selfRoleTree() {
        String roleId = super.getPara("roleIds") == null ? "" : super.getPara("roleIds").trim();
        String[] roleIds = roleId.split(",");
        return ApiResponse.data(ForestNodeMerger.merge(this.iSysRolesService.getSelfRoleTree(roleIds)));
    }

    @RequestMapping(value={"/resourceTree"})
    public ApiResponse<List<Map<String, Object>>> resourceTree() {
        return ApiResponse.data((Object)this.iSysResTypeService.getResourceTree());
    }

    @RequestMapping(value={"/getOrganAlias"})
    @BussinessLog(key="/roleManager/getOrganAlias", type="01", value="\u65b0\u589e\u89d2\u8272", pk="roleId", dict=RoleManagerDict.class)
    public ApiResponse<Object> getOrganAlias() {
        String nodeId = super.getPara("nodeId");
        SysStru stru = (SysStru)this.sysOrgManageService.selectById((Serializable)((Object)nodeId));
        String organAlias = stru.getOrganAlias();
        return ApiResponse.data((Object)organAlias);
    }

    @RequestMapping(value={"/addRole"})
    @RequiresPermissions(value={"roleManager:addRole"})
    @BussinessLog(key="/roleManager/addRole", type="01", value="\u65b0\u589e\u89d2\u8272", pk="roleId", dict=RoleManagerDict.class)
    public ApiResponse<Object> addRole(@RequestBody Map<String, String> param) {
        ShiroUser currentUser = ShiroKit.getUser();
        String roleType = param.get("roleType");
        String roleName = param.get("roleName");
        String roleYw = param.get("roleAlias");
        String checkNodeId = param.get("groupId");
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("roleName", roleName);
        map.put("roleYw", roleYw);
        map.put("checkNodeId", checkNodeId);
        if (currentUser.isGradeadmin() && "organRoleAdd".equals(roleType)) {
            map.put("isOrganRoleAdd", "true");
        } else {
            map.put("isOrganRoleAdd", "false");
        }
        String roleId = this.iSysRolesService.addRole(map);
        JSONObject result = new JSONObject();
        result.put("roleId", (Object)roleId);
        return ApiResponse.data((Object)result, (String)"\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/editRole"})
    @RequiresPermissions(value={"roleManager:editRole"})
    @BussinessLog(key="/roleManager/editRole", type="03", value="\u4fee\u6539\u89d2\u8272", pk="roleId", dict=RoleManagerDict.class)
    public ApiResponse<Tip> editRole(@RequestBody Map<String, String> param) {
        String roleId = param.get("roleId") == null ? "" : param.get("roleId").trim();
        String roleName = param.get("roleName") == null ? "" : param.get("roleName").trim();
        String roleYw = param.get("roleAlias") == null ? "" : param.get("roleAlias").trim();
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("roleId", roleId);
        map.put("roleName", roleName);
        map.put("roleYw", roleYw);
        Wrapper entityWrapper = new EntityWrapper().eq("role_id", (Object)roleId);
        List roleList = this.iSysRolesService.selectList(entityWrapper);
        LogObjectHolder.me().set(roleList.get(0));
        boolean flag = this.iSysRolesService.editRole(map);
        if (flag) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u4fdd\u5b58\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/roleView"})
    public ApiResponse<Map<String, Object>> roleView() {
        String id = super.getPara("id") == null ? "" : super.getPara("id").trim();
        Map map = this.iSysRolesService.getRoleViewMap(id);
        return ApiResponse.data((Object)map);
    }

    @RequestMapping(value={"/roleResourceView"})
    public ApiResponse<List<SysRoleResource>> getRoleResourceView() {
        String roleId = super.getPara("id") == null ? "" : super.getPara("id").trim();
        List resourceList = this.iSysRolesService.getRoleResource(roleId);
        return ApiResponse.data((Object)resourceList);
    }

    @RequestMapping(value={"/delRole"})
    @RequiresPermissions(value={"roleManager:delRole"})
    @BussinessLog(key="/roleManager/delRole", type="02", value="\u5220\u9664\u89d2\u8272")
    public ApiResponse<Tip> delRole(@RequestBody Map<String, String> map) {
        String id = map.get("id") == null ? "" : map.get("id").trim();
        List list = this.isConfRolesService.selectList(new EntityWrapper().eq("role_id", (Object)id));
        if (list.size() > 0) {
            return ApiResponse.fail((int)HttpCode.CONFLICT.value(), (String)"\u65e0\u6cd5\u5220\u9664\uff01\uff08\u89d2\u8272\u5df2\u5173\u8054\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6\uff01\uff09");
        }
        int num = this.isAuditService.isDelete(id);
        if (num > 0) {
            return ApiResponse.fail((int)HttpCode.CONFLICT.value(), (String)"\u65e0\u6cd5\u5220\u9664\uff01\uff08\u89d2\u8272\u5df2\u5173\u8054\u7528\u6237\uff01\uff09");
        }
        boolean flag = this.iSysRolesService.delRole(id);
        if (flag) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u5220\u9664\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5220\u9664\u5931\u8d25\uff01");
    }

    @RequiresPermissions(value={"roleManager:saveResource"})
    @RequestMapping(value={"/saveResource"})
    public ApiResponse<Tip> saveResource(@RequestBody Map<String, String> map) {
        String ids = map.get("resourceIds");
        String roId = map.get("roleId");
        this.iSysRoleResourceService.saveResource(ids, roId);
        List userIds = this.iSysRolesService.delCacheAuthInfo(roId);
        for (String userId : userIds) {
            this.iSysRolesService.delRedisAuthInfo(userId);
        }
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u89d2\u8272\u5173\u8054\u8d44\u6e90\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/reclaimPerm"})
    @RequiresPermissions(value={"roleManager:reclaimPerm"})
    @BussinessLog(key="/roleManager/reclaimPerm", type="02", value="\u89d2\u8272\u56de\u6536\u6743\u9650")
    public ApiResponse<Tip> reclaimPerm(@RequestBody Map<String, String> map) {
        String id = map.get("id") == null ? "" : map.get("id").trim();
        this.iSysRoleResourceService.reclaimPerm(id);
        List userIds = this.iSysRolesService.delCacheAuthInfo(id);
        for (String userId : userIds) {
            this.iSysRolesService.delRedisAuthInfo(userId);
        }
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u56de\u6536\u6743\u9650\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryPerm"})
    public ApiResponse<List<SysRoleResource>> queryPerm() {
        String id = super.getPara("id") == null ? "" : super.getPara("id").trim();
        return ApiResponse.data((Object)this.iSysRoleResourceService.queryPerm(id));
    }

    @RequestMapping(value={"/saveGroup"})
    @RequiresPermissions(value={"roleManager:saveGroup"})
    @BussinessLog(key="/roleManager/saveGroup", type="01", value="\u65b0\u589e\u89d2\u8272\u5206\u7ec4", pk="groupId", dict=RoleGroupDict.class)
    public ApiResponse<Tip> saveGroup(@RequestBody Map<String, String> map) {
        String groupName = map.get("groupName");
        String groupAlias = map.get("groupAlias");
        String checkId = map.get("checkId");
        Integer count = this.iSysRolesService.saveGroup(groupName, checkId, groupAlias);
        if (count == 1) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u4fdd\u5b58\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/editGroup"})
    @RequiresPermissions(value={"roleManager:editGroup"})
    @BussinessLog(key="/roleManager/editGroup", type="03", value="\u4fee\u6539\u89d2\u8272\u5206\u7ec4", pk="groupId", dict=RoleGroupDict.class)
    public ApiResponse<Tip> editGroup(@RequestBody Map<String, String> param) {
        String groupName = param.get("groupName");
        String groupAlias = param.get("groupAlias");
        String checkId = param.get("checkId");
        Integer count = this.iSysRolesService.editGroup(groupName, checkId, groupAlias);
        SysRoleGroup group = (SysRoleGroup)this.sysRoleGroupMapper.selectById((Serializable)((Object)checkId));
        groupName = group.getGroupName();
        groupAlias = group.getGroupAlias();
        HashMap<String, String> map = new HashMap<String, String>(10);
        map.put("groupName", groupName);
        map.put("groupAlias", groupAlias);
        LogObjectHolder.me().set(map);
        if (count == 1) {
            return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u4fee\u6539\u5931\u8d25\uff01");
    }

    @RequiresPermissions(value={"roleManager:sameRoleName"})
    @RequestMapping(value={"/sameRoleName"})
    public ApiResponse<List<SysRoles>> sameRoleName() {
        String name = super.getPara("sameRoleName");
        return ApiResponse.data((Object)this.iSysRolesService.selectList(new EntityWrapper().eq("ROLE_NAME", (Object)name)));
    }

    @RequiresPermissions(value={"roleManager:sameGroupName"})
    @RequestMapping(value={"/sameGroupName"})
    public ApiResponse<List<SysRoleGroup>> sameGroupName() {
        String name = super.getPara("sameGroupName");
        List list = this.sysRoleGroupMapper.selectList(new EntityWrapper().eq("GROUP_NAME", (Object)name));
        return ApiResponse.data((Object)list);
    }

    @RequiresPermissions(value={"roleManager:searchRoleToGroup"})
    @RequestMapping(value={"/searchRoleToGroup"})
    @ResponseBody
    public ApiResponse<List<SysRoles>> searchRoleToGroup() {
        String id = super.getPara("id");
        return ApiResponse.data((Object)this.iSysRolesService.selectList(new EntityWrapper().eq("GROUP_ID", (Object)id)));
    }

    @RequestMapping(value={"/delGroup"})
    @RequiresPermissions(value={"roleManager:delGroup"})
    @BussinessLog(key="/roleManager/delGroup", type="02", value="\u5220\u9664\u89d2\u8272\u5206\u7ec4")
    public ApiResponse<Tip> delGroup(@RequestBody Map<String, String> map) {
        String id = map.get("id");
        Integer count = this.sysRoleGroupMapper.deleteById((Serializable)((Object)id));
        if (count == 1) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u5220\u9664\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5220\u9664\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/roleGroupViewPage"})
    @BussinessLog(key="/roleManager/roleGroupViewPage", type="04", value="\u67e5\u770b\u89d2\u8272\u5206\u7ec4\u4fe1\u606f")
    @RequiresPermissions(value={"roleManager:roleGroupViewPage"})
    public ApiResponse<SysRoleGroup> roleGroupViewPage() {
        String nodeId = super.getPara("id");
        SysRoleGroup group = (SysRoleGroup)this.sysRoleGroupMapper.selectById((Serializable)((Object)nodeId));
        return ApiResponse.data((Object)group);
    }

    @RequiresPermissions(value={"roleManager:roleUserTreeView"})
    @RequestMapping(value={"/roleUserTreeView"})
    public ApiResponse<List<JSTreeModel>> getRoleUserTreeView() {
        String roleId = super.getPara("roleId");
        List result = this.userUtil.getUserByRole(roleId);
        JSTreeModel root = new JSTreeModel();
        root.setId("11");
        root.setCode("11");
        root.setText("\u5173\u8054\u7528\u6237");
        root.setParent("#");
        root.setType("isRoot");
        result.add(root);
        for (JSTreeModel model : result) {
            if ("USER".equals(model.getType())) {
                model.setState(true, false, true);
                continue;
            }
            model.setState(false, false, true);
        }
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequestMapping(value={"/lazyRoleUserTreeView"})
    public ApiResponse<List<JSTreeModel>> getLazyRoleUserTreeView() {
        String roleId = super.getPara("roleId");
        String nodeId = super.getPara("nodeId");
        return ApiResponse.data(ForestNodeMerger.merge(this.userUtil.getLazyUserByRole(roleId, nodeId)));
    }

    @RequestMapping(value={"/getRoleOrgUser"})
    public ApiResponse<JSONObject> getRoleOrgUser() {
        String roleId = super.getPara("roleId");
        String orgId = super.getPara("orgId");
        int pageNo = super.getPara("pageNo") == null ? 1 : Integer.parseInt(super.getPara("pageNo"));
        int limit = super.getPara("limit") == null ? 20 : Integer.parseInt(super.getPara("limit"));
        String name = super.getPara("name");
        String account = super.getPara("account");
        Page page = new Page(pageNo, limit);
        List list = ToolUtil.isEmpty((Object)roleId) ? new ArrayList() : this.sysOrgManageService.getRoleOrgUser(page, roleId, orgId, name, account);
        JSONObject json = new JSONObject();
        json.put("data", list);
        json.put("code", (Object)"0");
        json.put("msg", (Object)"");
        json.put("count", (Object)page.getTotal());
        return ApiResponse.data((Object)json);
    }

    @RequestMapping(value={"/addOrDelUserRole"})
    public ApiResponse<Tip> getRoleOrgUser(@RequestBody Map<String, String> map) {
        String adds = map.get("adds");
        String dels = map.get("dels");
        String roleId = map.get("roleId");
        List addList = JSONObject.parseArray((String)adds, RoleOrgUserVo.class);
        List delList = JSONObject.parseArray((String)dels, RoleOrgUserVo.class);
        Tip result = this.iSysUserRoleService.addOrDelUserRole(addList, delList, roleId);
        return ApiResponse.success((int)result.getCode(), (String)result.getMessage());
    }

    @RequiresPermissions(value={"roleManager:roleUserTreeEdit"})
    @RequestMapping(value={"/roleUserTreeEdit"})
    public ApiResponse<List<JSTreeModel>> getRoleUserTreeEdit() {
        String roleId = super.getPara("roleId");
        boolean isSysRole = false;
        String sysRoleGroup = "sys_role_group";
        SysRoles role = (SysRoles)this.iSysRolesService.selectById((Serializable)((Object)roleId));
        if (sysRoleGroup.equals(role.getGroupId())) {
            isSysRole = true;
        }
        List result = this.sysOrgManageService.getUserTree();
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setId("11");
        jsTreeModel.setCode("11");
        jsTreeModel.setText("\u5173\u8054\u7528\u6237");
        jsTreeModel.setParent("#");
        jsTreeModel.setType("isRoot");
        result.add(jsTreeModel);
        List userRoles = this.iSysUserRoleService.selectUserIdByRoleId(roleId);
        for (JSTreeModel model : result) {
            model.setState(false, false, false);
            if (userRoles.contains(model.getId())) {
                model.setState(true, true, false);
            }
            if (isSysRole) {
                model.setState(((Boolean)model.getState().get("selected")).booleanValue(), ((Boolean)model.getState().get("checked")).booleanValue(), true);
                continue;
            }
            if (!"USER".equals(model.getType()) || !"11".equals(model.getParent())) continue;
            model.setState(((Boolean)model.getState().get("selected")).booleanValue(), ((Boolean)model.getState().get("checked")).booleanValue(), true);
        }
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequiresPermissions(value={"roleManager:roleUserTreeAdd"})
    @RequestMapping(value={"/roleUserTreeAdd"})
    public ApiResponse<List<JSTreeModel>> getRoleUserTreeAdd() {
        List result = this.sysOrgManageService.getUserTree();
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setId("11");
        jsTreeModel.setCode("11");
        jsTreeModel.setText("\u5173\u8054\u7528\u6237");
        jsTreeModel.setParent("#");
        jsTreeModel.setType("isRoot");
        result.add(jsTreeModel);
        for (JSTreeModel model : result) {
            model.setState(false, false, false);
            if (!"USER".equals(model.getType()) || !"11".equals(model.getParent())) continue;
            model.setState(((Boolean)model.getState().get("selected")).booleanValue(), ((Boolean)model.getState().get("checked")).booleanValue(), true);
        }
        return ApiResponse.data((Object)result);
    }

    @RequiresPermissions(value={"roleManager:saveRoleUserAdd"})
    @RequestMapping(value={"/saveRoleUserAdd"})
    public ApiResponse<Tip> saveRoleUsersAdd(@RequestBody Map<String, String> map) {
        String roleId = map.get("roleId");
        String userIds = map.get("userIds");
        List<Object> ids = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)userIds)) {
            ids = Arrays.asList(userIds.split(","));
        }
        this.iSysRoleResourceService.saveRoleUserAdd(ids, roleId);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u89d2\u8272\u5173\u8054\u7528\u6237\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"roleManager:saveRoleUserEdit"})
    @RequestMapping(value={"/saveRoleUserEdit"})
    public ApiResponse<Tip> saveRoleUsersEdit(@RequestBody Map<String, String> map) {
        List confRolesList;
        String roleId = map.get("roleId");
        String userIds = map.get("userIds");
        List<Object> ids = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)userIds)) {
            ids = Arrays.asList(userIds.split(","));
        }
        if (ToolUtil.isNotEmpty((Object)(confRolesList = this.isConfRolesService.selectList(new EntityWrapper().eq("ROLE_ID", (Object)roleId))))) {
            for (String string : ids) {
                List rolesList = this.iSysUserRoleService.getRolesByUserId(string);
                if (!rolesList.contains(roleId)) {
                    rolesList.add(roleId);
                }
                if (!this.isConfRolesService.isIncludeConfRole(rolesList.toArray(new String[rolesList.size()]))) continue;
                SysUsers user = (SysUsers)this.sysUsersService.selectById((Serializable)((Object)string));
                return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)("\u4fee\u6539\u5931\u8d25\uff01\uff08" + user.getUserName() + " \u8fdd\u53cd\u4e86\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6\u89c4\u5219\uff09"));
            }
        }
        this.iSysRoleResourceService.saveRoleUserEdit(ids, roleId);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u89d2\u8272\u5173\u8054\u7528\u6237\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"roleManager:groupOrderTree"})
    @RequestMapping(value={"/groupOrderTree"})
    public ApiResponse<List<JSTreeModel>> groupOrderTree() {
        return ApiResponse.data(ForestNodeMerger.merge(this.iSysRolesService.getGroupOrderTree()));
    }

    @RequestMapping(value={"/saveGroupOrder"})
    @RequiresPermissions(value={"roleManager:saveGroupOrder"})
    @BussinessLog(key="/roleManager/saveGroupOrder", type="03", value="\u89d2\u8272\u5206\u7ec4\u6392\u5e8f")
    public ApiResponse<Tip> saveGroupOrder(@RequestBody Map<String, String> map) {
        String info = map.get("info");
        JSONArray treeArr = JSONArray.parseArray((String)info);
        this.iSysRolesService.saveGroupOrder(treeArr);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u6392\u5e8f\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"roleManager:roleOrderTree"})
    @RequestMapping(value={"/roleOrderTree"})
    @ResponseBody
    public ApiResponse<List<JSTreeModel>> roleOrderTree() {
        String parent = super.getPara("parentId");
        return ApiResponse.data(ForestNodeMerger.merge(this.iSysRolesService.getRoleOrderTree(parent)));
    }

    @RequestMapping(value={"/saveRoleOrder"})
    @RequiresPermissions(value={"roleManager:saveRoleOrder"})
    @BussinessLog(key="/roleManager/saveRoleOrder", type="03", value="\u89d2\u8272\u6392\u5e8f")
    public ApiResponse<Tip> saveRoleOrder(@RequestBody Map<String, Object> map) {
        String info = map.get("info") == null ? "" : map.get("info").toString();
        JSONArray treeArr = JSONArray.parseArray((String)info);
        this.iSysRolesService.saveRoleOrder(treeArr);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u6392\u5e8f\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/exportData"})
    @RequiresPermissions(value={"roleManager:exportData"})
    @BussinessLog(key="/roleManager/exportData", type="04", value="\u89d2\u8272\u6570\u636e\u5bfc\u51fa")
    public void exportData(HttpServletResponse response) {
        String ids = super.getPara("ids") == null ? "" : super.getPara("ids");
        List<String> idList = Arrays.asList(ids.split(","));
        this.iSysRolesService.exportData(idList, response);
    }
}

