/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.controller;

import com.alibaba.druid.util.StringUtils;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.jxdinfo.hussar.bsp.permit.dictmap.IncompatibleRolesDict;
import com.jxdinfo.hussar.bsp.permit.model.SysConfRoles;
import com.jxdinfo.hussar.bsp.permit.model.SysConfRoleset;
import com.jxdinfo.hussar.bsp.permit.model.SysRoles;
import com.jxdinfo.hussar.bsp.permit.service.ISysConfRolesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysConfRolesetService;
import com.jxdinfo.hussar.bsp.permit.vo.SysConfRolesVo;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/incompatibleRolesFront"})
public class IncompatibleRolesFrontController
extends BaseController {
    @Resource
    private ISysConfRolesetService isConfRolesetService;
    @Resource
    private ISysConfRolesService isConfRolesService;

    @RequestMapping(value={"/list"})
    @RequiresPermissions(value={"incompatibleRoles:list"})
    @BussinessLog(key="/incompatibleRoles/list", type="04", value="\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6\u5217\u8868")
    public ApiResponse<Map<String, Object>> list(Map<String, String> map) {
        String org = super.getPara("orgId");
        String name = super.getPara("setName");
        String page = super.getPara("current");
        String limit = super.getPara("size");
        if (!StringUtils.isEmpty((String)name)) {
            name = name.replaceAll("%", "\\\\%").replaceAll("_", "\\\\_");
        }
        Map result = this.isConfRolesetService.getRolesList(page, limit, name, org);
        return ApiResponse.data((Object)result);
    }

    @RequiresPermissions(value={"incompatibleRoles:selectInRoles"})
    @RequestMapping(value={"/selectInRoles"})
    public ApiResponse<List<Map<String, String>>> selectInRoles() {
        List list = this.isConfRolesService.getSelectInRoles("");
        ArrayList result = new ArrayList();
        for (SysRoles sysRoles : list) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", sysRoles.getRoleId());
            map.put("name", sysRoles.getRoleName());
            result.add(map);
        }
        return ApiResponse.data(result);
    }

    @RequestMapping(value={"/addRole"})
    @RequiresPermissions(value={"incompatibleRoles:addRole"})
    @BussinessLog(key="/incompatibleRoles/addRole", type="01", pk="setId", value="\u6dfb\u52a0\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6", dict=IncompatibleRolesDict.class)
    public ApiResponse<?> addRole() {
        String rolesName = super.getPara("setName").trim();
        String count = super.getPara("cardinality").trim();
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("rolesName", rolesName);
        map.put("count", count);
        List<SysConfRoleset> list = this.sameRoleName(rolesName);
        if (list != null && list.size() > 0) {
            return ApiResponse.fail((int)HttpCode.BAD_REQUEST.value(), (String)"\u89d2\u8272\u96c6\u540d\u79f0\u5df2\u5b58\u5728");
        }
        boolean flag = this.isConfRolesetService.addRole(map);
        if (flag) {
            return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.CONFLICT.value(), (String)"\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @RequiresPermissions(value={"incompatibleRoles:selectInRole"})
    @RequestMapping(value={"selectInRole"})
    public SysConfRoleset selectInRole() {
        String rolesId = super.getPara("setId");
        return (SysConfRoleset)this.isConfRolesetService.selectById((Serializable)((Object)rolesId));
    }

    @RequestMapping(value={"/editRole"})
    @RequiresPermissions(value={"incompatibleRoles:editRole"})
    @BussinessLog(key="/incompatibleRoles/editRole", type="03", pk="setId", value="\u4fee\u6539\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6", dict=IncompatibleRolesDict.class)
    public ApiResponse<?> editRole(@RequestBody Map<String, String> param) {
        String id = param.get("setId");
        String rolesName = param.get("setName").trim();
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("rolesName", rolesName);
        map.put("id", id);
        List<SysConfRoleset> list = this.sameRoleName(rolesName);
        if (list != null && list.size() > 0 && rolesName.equals(list.get(0).getSetName())) {
            return ApiResponse.fail((int)HttpCode.BAD_REQUEST.value(), (String)"\u89d2\u8272\u96c6\u540d\u79f0\u5df2\u5b58\u5728");
        }
        boolean flag = this.isConfRolesetService.editRole(map);
        if (flag) {
            return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
        }
        return ApiResponse.fail((String)"\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/delRole"})
    @RequiresPermissions(value={"incompatibleRoles:delRole"})
    @BussinessLog(key="/incompatibleRoles/delRole", type="02", value="\u5220\u9664\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6")
    public ApiResponse<String> delRole() {
        String id = super.getPara("setIds").trim();
        this.isConfRolesetService.delRole(id);
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"incompatibleRoles:roleView"})
    @RequestMapping(value={"/roleView"})
    public ApiResponse<List<String>> roleView() {
        String id = super.getPara("setId").trim();
        ArrayList<String> result = new ArrayList<String>();
        List roleList = this.isConfRolesetService.getSelectInRoles(id);
        if (roleList != null && roleList.size() > 0) {
            for (SysConfRolesVo sysConfRolesVo : roleList) {
                result.add(sysConfRolesVo.getRoleId());
            }
        }
        return ApiResponse.data(result);
    }

    @RequestMapping(value={"/transferData"})
    public ApiResponse<List<Map<String, Object>>> getTransferData() {
        return ApiResponse.data((Object)this.isConfRolesetService.getTransferData());
    }

    @RequestMapping(value={"/saveInRoles"})
    @RequiresPermissions(value={"incompatibleRoles:saveInRoles"})
    @BussinessLog(key="/incompatibleRoles/saveInRoles", type="01", value="\u589e\u52a0\u4e0d\u76f8\u5bb9\u89d2\u8272")
    public ApiResponse<?> saveInRoles(@RequestBody Map<String, String> param) {
        String roIds = param.get("roleIds");
        String setId = param.get("setId");
        String[] ids = roIds.split(",");
        this.isConfRolesService.delete(new EntityWrapper().eq("SET_ID", (Object)setId));
        ArrayList<SysConfRoles> list = new ArrayList<SysConfRoles>();
        for (String id : ids) {
            SysConfRoles sysConfRoles = new SysConfRoles();
            sysConfRoles.setSetId(setId);
            sysConfRoles.setRoleId(id);
            list.add(sysConfRoles);
        }
        if (ToolUtil.isNotEmpty(list)) {
            this.isConfRolesService.insertBatch(list, list.size());
        }
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    private List<SysConfRoleset> sameRoleName(String name) {
        return this.isConfRolesetService.selectList(new EntityWrapper().eq("SET_NAME", (Object)name));
    }
}

