/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.controller;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.jxdinfo.hussar.bsp.permit.model.SysGetBackPassword;
import com.jxdinfo.hussar.bsp.permit.model.SysPasswordHist;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysGetBackPasswordService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.encrypt.CryptoUtil;
import com.jxdinfo.hussar.core.shiro.encrypt.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/getBackPwdFront"})
public class GetBackPasswordFrontController
extends BaseController {
    @Resource
    private ISysGetBackPasswordService iSysGetBackPasswordService;
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;

    @RequestMapping(value={"/getQues"})
    public ApiResponse<?> getUserQues() {
        String userAccount = super.getPara("userAccount").trim();
        if (!this.iSysUsersService.isExistAccount(userAccount)) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u8be5\u7528\u6237\u540d\u4e0d\u5b58\u5728\uff01");
        }
        SysUsers user = (SysUsers)this.iSysUsersService.selectOne(new EntityWrapper().eq("user_account", (Object)userAccount).ne("account_status", (Object)"2"));
        SysGetBackPassword sysGetBackPassword = (SysGetBackPassword)this.iSysGetBackPasswordService.selectById((Serializable)((Object)user.getUserId()));
        if (ToolUtil.isEmpty((Object)sysGetBackPassword)) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u60a8\u6ca1\u6709\u8bbe\u7f6e\u5bc6\u4fdd\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u627e\u56de\u60a8\u7684\u5bc6\u7801\uff01");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("question", sysGetBackPassword.getpQues());
        map.put("userId", userAccount);
        return ApiResponse.data(map);
    }

    @RequestMapping(value={"/validateKey"})
    public ApiResponse<?> validateKey(@RequestBody Map<String, String> param) {
        String userAccount = param.get("userId") == null ? "" : param.get("userId").trim();
        String pQues = param.get("question") == null ? "" : param.get("question").trim();
        String pKey = param.get("answer") == null ? "" : param.get("answer").trim();
        SysUsers user = (SysUsers)this.iSysUsersService.selectOne(new EntityWrapper().eq("user_account", (Object)userAccount).ne("account_status", (Object)"2"));
        SysGetBackPassword sysGetBackPassword = (SysGetBackPassword)this.iSysGetBackPasswordService.selectById((Serializable)((Object)user.getUserId()));
        if (ToolUtil.isNotEmpty((Object)sysGetBackPassword)) {
            if (pQues.equals(sysGetBackPassword.getpQues()) && pKey.equals(sysGetBackPassword.getpKey())) {
                return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u9a8c\u8bc1\u901a\u8fc7\uff0c\u8bf7\u8bbe\u7f6e\u60a8\u7684\u65b0\u5bc6\u7801\uff01");
            }
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u60a8\u8f93\u5165\u7684\u7b54\u6848\u4e0d\u6b63\u786e\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u60a8\u6ca1\u6709\u8bbe\u7f6e\u5bc6\u4fdd\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u627e\u56de\u60a8\u7684\u5bc6\u7801\uff01");
    }

    @RequestMapping(value={"/setNewPwd"})
    @BussinessLog(key="/getBackPwd/setNewPwd", type="11", value="\u4fee\u6539\u5bc6\u7801")
    public ApiResponse<?> setNewPwd(@RequestBody Map<String, String> param) {
        String userAccount = param.get("userAccount") == null ? "" : param.get("userAccount").trim();
        String newPwd = param.get("newPwd") == null ? "" : param.get("newPwd").trim();
        String cPwd = param.get("checkPwd") == null ? "" : param.get("checkPwd").trim();
        userAccount = CryptoUtil.decode((String)userAccount);
        newPwd = CryptoUtil.decode((String)newPwd);
        cPwd = CryptoUtil.decode((String)cPwd);
        SysUsers user = (SysUsers)this.iSysUsersService.selectOne(new EntityWrapper().eq("USER_ACCOUNT", (Object)userAccount).ne("ACCOUNT_STATUS", (Object)"2"));
        String userId = user.getUserId();
        String regular = this.globalProperties.getPwdComplexityRegular().replaceAll("/", "");
        String hint = this.globalProperties.getUnmatchedHint();
        if (!newPwd.matches(regular)) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)hint);
        }
        if (newPwd.toLowerCase().contains(userAccount.toLowerCase())) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u4fee\u6539\u5931\u8d25\uff01\uff08\u5bc6\u7801\u5305\u542b\u7528\u6237\u540d\uff01\uff09");
        }
        if (!newPwd.equals(cPwd)) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u4e24\u6b21\u8f93\u5165\u7684\u5bc6\u7801\u4e0d\u4e00\u81f4\uff01");
        }
        String nPwd = this.credentialsMatcher.passwordEncode(newPwd.getBytes());
        List list = this.iSysUsersService.getPwdHist(userId);
        for (SysPasswordHist sysPasswordHist : list) {
            if (!nPwd.equals(sysPasswordHist.getPassword())) continue;
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)("\u65b0\u5bc6\u7801\u4e0d\u80fd\u548c\u524d" + this.globalProperties.getPwdRepeatTime() + "\u6b21\u7684\u5bc6\u7801\u4e00\u6837\uff01"));
        }
        user.setPassword(nPwd);
        this.iSysUsersService.updatePwd(user);
        return ApiResponse.success((String)"\u5bc6\u7801\u91cd\u7f6e\u6210\u529f\uff01");
    }
}

