/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.organ.controller;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.jxdinfo.hussar.bsp.organ.dictmap.SysOrganRuleDict;
import com.jxdinfo.hussar.bsp.organ.model.SysOrganType;
import com.jxdinfo.hussar.bsp.organ.model.SysStruRule;
import com.jxdinfo.hussar.bsp.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.bsp.organ.service.ISysStruRuleService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/orgRuleFront"})
public class SysOrganRuleFrontController
extends BaseController {
    @Resource
    private ISysStruRuleService iSysStruRuleService;
    @Resource
    private ISysOrganTypeService iSysOrganTypeService;

    @RequestMapping(value={"/list"})
    @RequiresPermissions(value={"orgRule:search"})
    public ApiResponse<Map<String, Object>> list() {
        String pageNum = super.getPara("curr");
        String limitNum = super.getPara("nums");
        String parentType = super.getPara("parentType");
        String lowerType = super.getPara("lowerType");
        Page page = new Page(Integer.valueOf(pageNum).intValue(), Integer.valueOf(limitNum).intValue());
        page = this.iSysStruRuleService.getOrganRuleList(page, parentType, lowerType);
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("count", page.getTotal());
        map.put("data", page.getRecords());
        map.put("code", 0);
        return ApiResponse.data(map);
    }

    @RequestMapping(value={"/detail"})
    @RequiresPermissions(value={"orgRule:edit"})
    public ApiResponse<SysStruRule> getDetail(String ruleId) {
        SysStruRule sysStruRule = (SysStruRule)this.iSysStruRuleService.selectById((Serializable)((Object)ruleId));
        return ApiResponse.data((Object)sysStruRule);
    }

    @BussinessLog(key="/orgRule/add", type="01", value="\u65b0\u589e\u7ec4\u7ec7\u89c4\u5219", pk="ruleId", dict=SysOrganRuleDict.class)
    @RequiresPermissions(value={"orgRule:add"})
    @RequestMapping(value={"/add"})
    public ApiResponse<Tip> add(@RequestBody Map<String, String> param) {
        String parentOrg = param.get("higherTypeCode");
        String sonOrg = param.get("lowerTypeCode");
        String ruleNote = param.get("description");
        if ("9".equals(parentOrg) && !"9".equals(sonOrg)) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u65b0\u589e\u5931\u8d25\uff01\uff08\u5f53\u524d\u89c4\u5219\u4e0d\u7b26\u5408\u7ec4\u7ec7\u7c7b\u578b\u4e0a\u4e0b\u7ea7\u5173\u7cfb\u5b9a\u4e49\uff09");
        }
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("parentOrg", parentOrg);
        map.put("sonOrg", sonOrg);
        List result = this.iSysStruRuleService.getRuleExist(map);
        if (result.size() > 0) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u65b0\u589e\u5931\u8d25\uff01\uff08\u5f53\u524d\u7ec4\u7ec7\u89c4\u5219\u5df2\u5b58\u5728\uff09");
        }
        if (!"9".equals(sonOrg)) {
            List allType = this.iSysOrganTypeService.selectList((Wrapper)new EntityWrapper());
            String pType = ((SysOrganType)this.iSysOrganTypeService.selectOne(new EntityWrapper().eq("organ_type", (Object)parentOrg))).getOrganType();
            String sType = ((SysOrganType)this.iSysOrganTypeService.selectOne(new EntityWrapper().eq("organ_type", (Object)sonOrg))).getOrganType();
            ArrayList<String> resultType = new ArrayList<String>();
            this.recursive(allType, resultType, pType);
            resultType.add(parentOrg);
            if (!resultType.contains(sonOrg)) {
                ArrayList<String> newResultType = new ArrayList<String>();
                this.recursive(allType, newResultType, sType);
                newResultType.add(sonOrg);
                if (newResultType.contains(parentOrg)) {
                    return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u65b0\u589e\u5931\u8d25\uff01\uff08\u5f53\u524d\u89c4\u5219\u4e0d\u7b26\u5408\u7ec4\u7ec7\u7c7b\u578b\u4e0a\u4e0b\u7ea7\u5173\u7cfb\u5b9a\u4e49\uff09");
                }
            }
        }
        SysStruRule sysStruRule = new SysStruRule();
        sysStruRule.setRuleId(null);
        sysStruRule.setSysOrganType(parentOrg);
        sysStruRule.setOrganType(sonOrg);
        sysStruRule.setRuleNote(ruleNote);
        sysStruRule.setCreator(ShiroKit.getUser().getId());
        sysStruRule.setCreateTime(new Date());
        boolean flag = this.iSysStruRuleService.insert(sysStruRule);
        if (flag) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u4fdd\u5b58\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @BussinessLog(key="/orgRule/edit", type="03", value="\u4fee\u6539\u7ec4\u7ec7\u89c4\u5219", pk="ruleId", dict=SysOrganRuleDict.class)
    @RequiresPermissions(value={"orgRule:edit"})
    @RequestMapping(value={"/edit"})
    public ApiResponse<Object> edit(@RequestBody Map<String, String> param) {
        String ruleId = param.get("ruleId");
        String parentOrg = param.get("higherTypeCode");
        String sonOrg = param.get("lowerTypeCode");
        String ruleNote = param.get("description");
        SysStruRule sysStruRule = new SysStruRule();
        sysStruRule.setRuleId(ruleId);
        sysStruRule.setSysOrganType(parentOrg);
        sysStruRule.setOrganType(sonOrg);
        sysStruRule.setRuleNote(ruleNote);
        sysStruRule.setLastEditor(ShiroKit.getUser().getId());
        sysStruRule.setLastTime(new Date());
        SysStruRule sysStruRule1 = (SysStruRule)this.iSysStruRuleService.selectById((Serializable)((Object)ruleId));
        LogObjectHolder.me().set((Object)sysStruRule1);
        boolean flag = this.iSysStruRuleService.update(sysStruRule);
        if (flag) {
            return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @BussinessLog(key="/orgRule/delete", type="02", value="\u7ec4\u7ec7\u673a\u6784\u89c4\u5219\u5220\u9664")
    @RequiresPermissions(value={"orgRule:delete"})
    @RequestMapping(value={"/delete"})
    public ApiResponse<Object> delete(@RequestBody Map<String, String> map) {
        String eId = map.get("eId");
        String[] ids = eId.split(",");
        ArrayList<String> idList = new ArrayList<String>();
        List banList = this.iSysStruRuleService.getBanDelRule();
        for (String id : ids) {
            if (banList.contains(id) && ids.length == 1) {
                return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5220\u9664\u5931\u8d25\uff01\uff08\u6b64\u7ec4\u7ec7\u89c4\u5219\u4e0d\u5141\u8bb8\u5220\u9664\uff09");
            }
            if (banList.contains(id) && ids.length > 1) {
                return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5220\u9664\u5931\u8d25\uff01\uff08\u5b58\u5728\u4e0d\u5141\u8bb8\u5220\u9664\u7684\u7ec4\u7ec7\u89c4\u5219\uff09");
            }
            if (ids.length == 1 && this.iSysStruRuleService.isInUse(id)) {
                return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5220\u9664\u5931\u8d25\uff01\uff08\u6b64\u7ec4\u7ec7\u89c4\u5219\u6b63\u5728\u4f7f\u7528\uff09");
            }
            if (ids.length > 1 && this.iSysStruRuleService.isInUse(id)) {
                return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5220\u9664\u5931\u8d25\uff01\uff08\u5b58\u5728\u6b63\u5728\u4f7f\u7528\u7684\u7ec4\u7ec7\u89c4\u5219\uff09");
            }
            idList.add(id);
        }
        boolean flag = this.iSysStruRuleService.delete(idList);
        if (flag) {
            return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5220\u9664\u5931\u8d25\uff01");
    }

    private void recursive(List<SysOrganType> allType, List<String> resultType, String pType) {
        for (int i = allType.size() - 1; i >= 0; --i) {
            SysOrganType iType;
            if (i > allType.size() - 1) {
                i = allType.size() - 1;
            }
            if (!pType.equals((iType = allType.get(i)).getParentType())) continue;
            allType.remove(i);
            resultType.add(iType.getOrganType());
            String newpType = iType.getOrganType();
            this.recursive(allType, resultType, newpType);
        }
    }
}

