/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.organ.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.plugins.Page;
import com.jxdinfo.hussar.bsp.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.bsp.organ.dictmap.StruDict;
import com.jxdinfo.hussar.bsp.organ.model.SysOffice;
import com.jxdinfo.hussar.bsp.organ.model.SysOrgan;
import com.jxdinfo.hussar.bsp.organ.model.SysStru;
import com.jxdinfo.hussar.bsp.organ.model.SysStruRule;
import com.jxdinfo.hussar.bsp.organ.service.ISysOrgService;
import com.jxdinfo.hussar.bsp.organ.service.ISysOrganService;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.bsp.permit.service.ISysIdtableService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.ForestNodeMerger;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/orgMainFront"})
public class SysOrgManageFrontController
extends BaseController {
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private ISysOrganService iSysOrganService;
    @Autowired
    ISysStruAuditService iSysStruAuditService;
    @Resource
    private ISysOrgService iSysOrgService;

    @RequiresPermissions(value={"orgMain:orgTree"})
    @RequestMapping(value={"/orgTree"})
    @ResponseBody
    public ApiResponse<List<JSTreeModel>> orgTree() {
        String isEmployee = super.getPara("isEmployee");
        String isExport = super.getPara("isExport");
        String resourceId = super.getPara("resourceId");
        String type = super.getPara("type");
        String handle = super.getPara("handle");
        String parentId = super.getPara("parentId");
        return ApiResponse.data(ForestNodeMerger.merge(this.iSysOrgService.getOrgTree(isEmployee, isExport, resourceId, type, handle, parentId)));
    }

    @RequestMapping(value={"/getDelegateRetrieveTree"})
    @ResponseBody
    public ApiResponse<List<JSTreeModel>> getStruParentId() {
        String isEmployee = super.getPara("isEmployee");
        String isExport = super.getPara("isExport");
        String resourceId = super.getPara("resourceId");
        String type = super.getPara("type");
        String handle = super.getPara("handle");
        String parentId = super.getPara("parentId");
        List list = this.iSysOrgService.getOrgTree(isEmployee, isExport, resourceId, type, handle, parentId);
        List idList = this.iSysOrgService.getAllParentId();
        if (ToolUtil.isNotEmpty((Object)idList)) {
            for (JSTreeModel jsTreeModel : list) {
                String treeId = jsTreeModel.getId();
                if (!idList.contains(treeId)) continue;
                jsTreeModel.setState(false, false, true);
            }
        }
        return ApiResponse.data(ForestNodeMerger.merge(list));
    }

    @RequiresPermissions(value={"orgMain:orgTree"})
    @RequestMapping(value={"/orgResourceStruId"})
    @ResponseBody
    public ApiResponse<List<String>> orgResourceStruId() {
        String resourceId = super.getPara("resourceId") == null ? "" : super.getPara("resourceId");
        String type = super.getPara("type") == null ? "" : super.getPara("type");
        return ApiResponse.data((Object)this.iSysOrgService.getResourceStruId(resourceId, type));
    }

    @RequiresPermissions(value={"orgMain:orgTreeById"})
    @RequestMapping(value={"/orgTreeById"})
    @ResponseBody
    public ApiResponse<List<JSTreeModel>> orgTreeById(HttpServletRequest request) {
        String orgId = request.getParameter("orgId");
        String isEmployee = request.getParameter("isEmployee");
        String isHead = request.getParameter("isRoot");
        List result = this.orgMaintenanceService.getOrgTreeById(orgId, isEmployee, isHead);
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequestMapping(value={"/orgInfo"})
    @RequiresPermissions(value={"orgMain:orgInfo"})
    @BussinessLog(key="/orgMain/orgInfo", type="04", value="\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u67e5\u770b")
    @ResponseBody
    public ApiResponse<SysOrganVo> orgInfo(String struId) {
        SysOrganVo orgInfo = this.orgMaintenanceService.getOrgInfoById(struId);
        return ApiResponse.data((Object)orgInfo);
    }

    @RequestMapping(value={"/orgInfoAdd"})
    @RequiresPermissions(value={"orgMain:add"})
    @ResponseBody
    public ApiResponse<Map<String, Object>> orgInfoAdd() {
        String orgParentId = super.getPara("orgParentId");
        String orgType = super.getPara("orgType");
        String orgTypeName = super.getPara("orgTypeName");
        String childNum = super.getPara("childNum");
        SysOrganVo orgInfo = this.orgMaintenanceService.getOrgInfoById(orgParentId);
        String orgParentCode = "";
        String orgParentName = "";
        String parentTypeCode = "";
        if (ToolUtil.isNotEmpty((Object)orgInfo)) {
            orgParentCode = orgInfo.getOrganCode();
            if (ToolUtil.isEmpty((Object)orgParentCode)) {
                orgParentCode = "";
            }
            orgParentName = orgInfo.getOrganName();
            parentTypeCode = orgInfo.getParentTypeCode();
            if (ToolUtil.isEmpty((Object)parentTypeCode)) {
                parentTypeCode = "";
            }
        }
        String businessName = "STRU_CODE";
        String tableName = "sys_stru";
        String currentCode = this.sysIdtableService.getCurrentCode(businessName, tableName, orgParentCode);
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("currentCode", currentCode);
        dataMap.put("orgInfo", null);
        dataMap.put("orgType", orgType);
        dataMap.put("orgParentId", orgParentId);
        dataMap.put("orgParentCode", orgParentCode);
        dataMap.put("orgParentName", orgParentName);
        if (ToolUtil.isNotEmpty((Object)orgInfo)) {
            dataMap.put("struLevel", orgInfo.getStruLevel());
        } else {
            dataMap.put("struLevel", "0");
        }
        dataMap.put("childNum", childNum);
        dataMap.put("orgTypeName", orgTypeName);
        dataMap.put("parentTypeCode", parentTypeCode);
        return ApiResponse.data(dataMap);
    }

    @RequiresPermissions(value={"orgMain:edit"})
    @RequestMapping(value={"/orgInfoEdit"})
    @ResponseBody
    public ApiResponse<SysOrganVo> orgInfoEdit(String orgId) {
        SysOrganVo orgInfo = this.orgMaintenanceService.getOrgInfoById(orgId);
        return ApiResponse.data((Object)orgInfo);
    }

    @RequiresPermissions(value={"orgMain:getOrgRoleByCode"})
    @RequestMapping(value={"/getOrgRoleByCode"})
    @ResponseBody
    public ApiResponse<Object> getOrgRoleByCode() {
        String orgType = super.getPara("orgType");
        String isRoot = super.getPara("isRoot");
        return ApiResponse.data((Object)this.orgMaintenanceService.getOrgRoleByCode(orgType, isRoot));
    }

    @RequestMapping(value={"/getExitOrgRoleByCode"})
    @ResponseBody
    public ApiResponse<Boolean> getExitOrgRoleByCode() {
        String orgType = super.getPara("orgType");
        String isRoot = super.getPara("isRoot");
        List ruleList = this.orgMaintenanceService.getOrgRoleByCode(orgType, isRoot);
        boolean result = true;
        boolean isEmpl = false;
        if (ruleList != null && ruleList.size() == 1) {
            SysStruRule sysStruRule = (SysStruRule)ruleList.get(0);
            if ("9".equals(sysStruRule.getSysOrganType())) {
                // empty if block
            }
            isEmpl = true;
        }
        if (ruleList != null && ruleList.size() == 0 || isEmpl) {
            result = false;
        }
        return ApiResponse.data((Object)result);
    }

    @RequestMapping(value={"/orgInfoSave"})
    @RequiresPermissions(value={"orgMain:orgInfoSave"})
    @BussinessLog(key="/orgMain/orgInfoSave", type="01", value="\u7ec4\u7ec7\u673a\u6784\u65b0\u589e")
    @ResponseBody
    public ApiResponse<JSONObject> orgInfoSave(SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        sysStru.setStruId(null);
        if (ToolUtil.isEmpty((Object)sysStru.getOrganAlias())) {
            sysStru.setOrganAlias(sysOrgan.getOrganName());
        }
        sysStru.setOrganId(null);
        sysStru.setIsLeaf("0");
        sysStru.setInUse("1");
        sysStru.setStruPath("");
        sysOrgan.setOrganId(null);
        sysOrgan.setInUse("1");
        sysStru.setStruLevel(sysStru.getStruLevel().add(new BigDecimal(1)));
        Long orderTree = 1L;
        Long maxOrder = this.orgMaintenanceService.getMaxOrderById(sysStru.getParentId());
        orderTree = ToolUtil.isNotEmpty((Object)maxOrder) ? Long.valueOf(maxOrder + 1L) : Long.valueOf(1L);
        BigDecimal struOrder = BigDecimal.valueOf(orderTree);
        sysStru.setStruOrder(struOrder);
        return ApiResponse.data((Object)this.orgMaintenanceService.orgInfoSave(sysStru, sysOrgan, null, sysOffice, Boolean.valueOf(true)));
    }

    @RequestMapping(value={"/orgInfoEditSave"})
    @RequiresPermissions(value={"orgMain:orgInfoEditSave"})
    @BussinessLog(key="/orgMain/orgInfoEditSave", type="03", value="\u7ec4\u7ec7\u673a\u6784\u4fee\u6539", pk="struId,organId", dict=StruDict.class)
    @ResponseBody
    public ApiResponse<JSONObject> orgInfoEditSave(SysOrgan sysOrgan, SysStru sysStru, SysOffice sysOffice) {
        if (!this.iSysStruAuditService.checkCanOperate(sysStru.getStruId())) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("code", (Object)HttpCode.INTERNAL_SERVER_ERROR.value());
            jsonObject.put("message", (Object)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u4fee\u6539\uff01");
            return ApiResponse.data((Object)jsonObject);
        }
        SysOrgan sysOrgan1 = (SysOrgan)this.iSysOrganService.selectById((Serializable)((Object)sysOrgan.getOrganId()));
        LogObjectHolder.me().set((Object)sysOrgan1);
        return ApiResponse.data((Object)this.orgMaintenanceService.orgInfoSave(sysStru, sysOrgan, null, sysOffice, Boolean.valueOf(false)));
    }

    @RequestMapping(value={"/orgTreeOrder"})
    @ResponseBody
    @BussinessLog(key="/orgMain/orgTreeOrder", type="03", value="\u7ec4\u7ec7\u673a\u6784\u6392\u5e8f")
    @RequiresPermissions(value={"orgMain:orgTreeOrder"})
    public ApiResponse<Object> orgTreeOrder(String treeInfo) {
        JSONArray treeArr = JSON.parseArray((String)treeInfo);
        this.orgMaintenanceService.saveOrgTreeOrder(treeArr);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u6392\u5e8f\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"orgMain:del"})
    @RequestMapping(value={"/delOrgById"})
    @BussinessLog(key="/orgMain/delOrgById", type="02", value="\u7ec4\u7ec7\u673a\u6784\u5220\u9664", dict=StruDict.class)
    @ResponseBody
    public ApiResponse<JSONObject> delOrgById(String struId) {
        JSONObject result = this.orgMaintenanceService.delOrgById(struId);
        if (result.getBoolean("success").booleanValue()) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)result.getString("msg"));
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)result.getString("msg"));
    }

    @RequestMapping(value={"principalSelect"})
    @ResponseBody
    public ApiResponse<JSONObject> principalSelect(@RequestParam(value="curr", defaultValue="1") int curr, @RequestParam(value="nums", defaultValue="10") int nums) {
        ShiroUser shiroUser = ShiroKit.getUser();
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        String userName = super.getPara("userName");
        String departmentName = super.getPara("departmentName");
        if (ToolUtil.isNotEmpty((Object)curr) && ToolUtil.isNotEmpty((Object)nums)) {
            Page page = new Page(curr, nums);
            page = isGradeAdmin ? this.orgMaintenanceService.getPrincipalSelectList(page, userName, departmentName, shiroUser.getDeptId()) : this.orgMaintenanceService.getPrincipalSelectList(page, userName, departmentName);
            JSONObject json = new JSONObject();
            json.put("data", (Object)page.getRecords());
            json.put("code", (Object)"0");
            json.put("msg", (Object)"");
            json.put("count", (Object)page.getTotal());
            return ApiResponse.data((Object)json);
        }
        JSONObject json = new JSONObject();
        json.put("data", null);
        json.put("code", (Object)"500");
        json.put("msg", (Object)"\u53c2\u6570\u4e0d\u7b26\uff01");
        json.put("count", null);
        return ApiResponse.data((Object)json);
    }

    @RequiresPermissions(value={"orgMain:orgChangeById"})
    @RequestMapping(value={"/orgChangeById"})
    @ResponseBody
    public ApiResponse<List<JSTreeModel>> orgChangeById(HttpServletRequest request) {
        String isEmployee = request.getParameter("isEmployee");
        String isExport = request.getParameter("isExport");
        String resourceId = super.getPara("resourceId");
        String type = super.getPara("type");
        String handle = super.getPara("handle");
        String parentId = super.getPara("parentId");
        List<JSTreeModel> result = new ArrayList();
        result = this.iSysOrgService.getOrgTree(isEmployee, isExport, resourceId, type, handle, parentId);
        for (JSTreeModel jsTreeModel : result) {
            jsTreeModel.setChildren("false");
        }
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequestMapping(value={"/orgTreeChange"})
    @ResponseBody
    @BussinessLog(key="/orgMain/orgTreeChange", type="03", value="\u7ec4\u7ec7\u673a\u6784\u8f6c\u79fb")
    @RequiresPermissions(value={"orgMain:orgTreeChange"})
    public ApiResponse<JSONObject> orgTreeChange() {
        String changeLevel;
        String isRoot;
        String orgType;
        String parentId;
        String orgId = super.getPara("orgId");
        JSONObject result = this.orgMaintenanceService.orgTreeChange(orgId, parentId = super.getPara("parentId"), orgType = super.getPara("orgType"), isRoot = super.getPara("isRoot"), changeLevel = super.getPara("changeLevel"));
        if (result.getBoolean("success").booleanValue()) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)result.getString("msg"));
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)result.getString("msg"));
    }

    @RequestMapping(value={"/singleMove"})
    @ResponseBody
    @BussinessLog(key="/orgMain/singleMove", type="03", value="\u7ec4\u7ec7\u673a\u6784\u4e0a\u79fb/\u4e0b\u79fb")
    @RequiresPermissions(value={"orgMain:singleMove"})
    public ApiResponse<Tip> updateMoveNode(String orgId, boolean isUp) {
        if (ToolUtil.isEmpty((Object)orgId)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        this.orgMaintenanceService.updateMoveNode(orgId, isUp);
        return ApiResponse.success((String)"\u79fb\u52a8\u6210\u529f");
    }

    @RequestMapping(value={"/exportData"})
    @RequiresPermissions(value={"orgMain:exportData"})
    @BussinessLog(key="/orgMain/exportData", type="04", value="\u7ec4\u7ec7\u673a\u6784\u6570\u636e\u5bfc\u51fa")
    public void exportData(HttpServletResponse response) {
        String ids = super.getPara("ids");
        List<String> idList = Arrays.asList(ids.split(","));
        this.orgMaintenanceService.exportData(idList, response);
    }
}

