/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.organ.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.jxdinfo.hussar.bsp.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.bsp.organ.dictmap.StruDict;
import com.jxdinfo.hussar.bsp.organ.model.SysOrgan;
import com.jxdinfo.hussar.bsp.organ.model.SysStaff;
import com.jxdinfo.hussar.bsp.organ.model.SysStru;
import com.jxdinfo.hussar.bsp.organ.service.IStaffUserService;
import com.jxdinfo.hussar.bsp.organ.service.ISysEmployeeService;
import com.jxdinfo.hussar.bsp.organ.service.ISysStaffService;
import com.jxdinfo.hussar.bsp.organ.service.ISysStruRuleService;
import com.jxdinfo.hussar.bsp.organ.service.ISysStruService;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.bsp.permit.service.ISysIdtableService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.ForestNodeMerger;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.sys.service.ISysDicRefService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/employeeFront"})
public class SysEmployeeFrontController
extends BaseController {
    @Resource
    private ISysEmployeeService sysEmployeeService;
    @Resource
    private IStaffUserService staffUserService;
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private ISysDicRefService iSysDicRefService;
    @Resource
    private ISysStaffService sysStaffService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private GlobalProperties globalProperties;
    @Autowired
    ISysStruAuditService iSysStruAuditService;
    @Autowired
    ISysStruService iSysStruService;
    @Autowired
    ISysStruRuleService iSysStruRuleService;

    @RequiresPermissions(value={"employee:employeeTree"})
    @RequestMapping(value={"/employeeTree"})
    @ResponseBody
    public ApiResponse<List<JSTreeModel>> employeeTree() {
        String isEmployee = super.getPara("isEmployee");
        String parentId = super.getPara("parentId");
        String isExport = super.getPara("isExport");
        return ApiResponse.data(ForestNodeMerger.merge(this.sysEmployeeService.getEmployeeTree(isEmployee, parentId, isExport)));
    }

    @RequestMapping(value={"/employeeAdd"})
    @RequiresPermissions(value={"employee:add"})
    @ResponseBody
    public ApiResponse<Map<String, Object>> orgInfoAdd() {
        String parentType = super.getPara("parentType");
        String parentTypeCode = "";
        String orgType = super.getPara("orgType");
        String orgParentCode = super.getPara("orgParentCode");
        String filedName = "ORGAN_CODE_" + orgType;
        String currentCode = this.sysIdtableService.getCurrentCode(filedName, "sys_stru");
        if (ToolUtil.isEmpty((Object)currentCode)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.NOHAS_IDTABLE);
        }
        if (parentType.equals(orgType)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.EMPLOYEE_CANNOT_HAVE_SUBORDINATES);
        }
        currentCode = orgParentCode + currentCode;
        parentTypeCode = orgParentCode;
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("operation", this.iSysDicRefService.getDicListByType("staff_position"));
        dataMap.put("currentCode", currentCode);
        dataMap.put("parentTypeCode", parentTypeCode);
        dataMap.put("orgInfo", null);
        return ApiResponse.data(dataMap);
    }

    @RequiresPermissions(value={"employee:view"})
    @RequestMapping(value={"/employeeInfo"})
    @BussinessLog(key="/employee/employeeInfo", type="04", value="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u67e5\u770b")
    @ResponseBody
    public ApiResponse<Map<String, Object>> employeeInfo(String struId) {
        SysOrganVo orgInfo = this.orgMaintenanceService.getOrgInfoById(struId);
        SysStaff staff = (SysStaff)this.sysStaffService.selectOne(new EntityWrapper().eq("stru_id", (Object)struId));
        if (ToolUtil.isEmpty((Object)staff)) {
            staff = new SysStaff();
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("orgInfo", orgInfo);
        dataMap.put("staff", staff);
        return ApiResponse.data(dataMap);
    }

    @RequiresPermissions(value={"employee:edit"})
    @RequestMapping(value={"/employeeEdit"})
    @ResponseBody
    public ApiResponse<Map<String, Object>> employeeEdit(String orgId) {
        SysOrganVo orgInfo = this.orgMaintenanceService.getOrgInfoById(orgId);
        SysStaff staff = (SysStaff)this.sysStaffService.selectOne(new EntityWrapper().eq("stru_id", (Object)orgId));
        if (ToolUtil.isEmpty((Object)staff)) {
            staff = new SysStaff();
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("orgInfo", orgInfo);
        dataMap.put("staff", staff);
        dataMap.put("operation", this.iSysDicRefService.getDicListByType("staff_position"));
        return ApiResponse.data(dataMap);
    }

    @RequiresPermissions(value={"employee:save"})
    @RequestMapping(value={"/emplInfoSave"})
    @BussinessLog(key="/employee/employeeAdd", type="01", value="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u65b0\u589e", dict=StruDict.class)
    @ResponseBody
    public ApiResponse<Object> emplInfoSave(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff) {
        SysStru parent = (SysStru)this.iSysStruService.selectById((Serializable)((Object)sysStru.getParentId()));
        List sysStruRules = this.iSysStruRuleService.selectList(new EntityWrapper().eq("sys_organ_type", (Object)parent.getStruType()).eq("organ_type", (Object)"9"));
        if (sysStruRules == null || sysStruRules.size() < 1) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u65b0\u589e\u4e0d\u7b26\u5408\u7ec4\u7ec7\u673a\u6784\u89c4\u5219\uff09");
        }
        if (this.globalProperties.isOperateStaffWithUser()) {
            if (this.sysUsersService.isExistAccount(sysOrgan.getOrganName())) {
                return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u7528\u6237\u540d\u5df2\u5b58\u5728\uff01\uff09");
            }
            this.staffUserService.addStaffUser(sysStru, sysOrgan, sysStaff);
        } else {
            this.sysEmployeeService.addStaff(sysStru, sysOrgan, sysStaff);
        }
        return ApiResponse.success((int)SUCCESS_TIP.getCode(), (String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/judgeAddRules"})
    @ResponseBody
    public ApiResponse<Boolean> judgeAddRules(String parentId) {
        SysStru parent = (SysStru)this.iSysStruService.selectById((Serializable)((Object)parentId));
        List sysStruRules = this.iSysStruRuleService.selectList(new EntityWrapper().eq("sys_organ_type", (Object)parent.getStruType()).eq("organ_type", (Object)"9"));
        if (sysStruRules == null || sysStruRules.size() < 1) {
            return ApiResponse.data((Object)false);
        }
        return ApiResponse.data((Object)true);
    }

    @RequiresPermissions(value={"employee:editSave"})
    @RequestMapping(value={"/emplInfoEditSave"})
    @BussinessLog(key="/employee/employeeEdit", type="03", value="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u4fee\u6539", pk="struId,organId", dict=StruDict.class)
    @ResponseBody
    public ApiResponse<Object> emplInfoEditSave(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff) {
        if (!this.iSysStruAuditService.checkCanOperate(sysStru.getStruId())) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u4fee\u6539\uff01");
        }
        if (!this.globalProperties.isOperateStaffWithUser()) {
            Tip tip = this.sysEmployeeService.editStaff(sysStru, sysOrgan, sysStaff);
            return ApiResponse.fail((int)tip.getCode(), (String)tip.getMessage());
        }
        this.staffUserService.editStaffUser(sysStru, sysOrgan, sysStaff);
        SysOrganVo orgInfo = this.orgMaintenanceService.getOrgInfoById(sysStru.getStruId());
        LogObjectHolder.me().set((Object)orgInfo);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"employee:del"})
    @RequestMapping(value={"/delEmployeeById"})
    @ResponseBody
    @BussinessLog(key="/employee/delEmployeeById", type="02", value="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u5220\u9664")
    public ApiResponse<Object> delEmployeeById(String orgId) {
        if (this.globalProperties.isOperateStaffWithUser()) {
            JSONObject result = this.staffUserService.deleteStaffUser(orgId);
            if (result.getBoolean("success").booleanValue()) {
                return ApiResponse.success((int)HttpCode.OK.value(), (String)result.getString("msg"));
            }
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)result.getString("msg"));
        }
        JSONObject result = this.orgMaintenanceService.delOrgById(orgId);
        if (result.getBoolean("success").booleanValue()) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)result.getString("msg"));
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)result.getString("msg"));
    }

    @RequestMapping(value={"/staffTransfer"})
    @ResponseBody
    @RequiresPermissions(value={"employee:staffTransfer"})
    @BussinessLog(key="/employee/staffTransfer", type="03", value="\u4eba\u5458\u8f6c\u79fb")
    public ApiResponse<Object> orgTreeChange() {
        String changeLevel;
        String isRoot;
        String orgType;
        String parentId;
        String struId = super.getPara("orgId");
        JSONObject result = this.orgMaintenanceService.orgTreeChange(struId, parentId = super.getPara("parentId"), orgType = super.getPara("orgType"), isRoot = super.getPara("isRoot"), changeLevel = super.getPara("changeLevel"));
        if (result.getBoolean("success").booleanValue()) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)result.getString("msg"));
        }
        return ApiResponse.success((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)result.getString("msg"));
    }

    @RequiresPermissions(value={"employee:employeeTreeById"})
    @RequestMapping(value={"/employeeTreeById"})
    @ResponseBody
    public ApiResponse<List<JSTreeModel>> employeeTreeById() {
        String orgId;
        String string = orgId = super.getPara("orgId") == null ? "" : super.getPara("orgId").trim();
        if (this.globalProperties.isUserOnOneEmp()) {
            return ApiResponse.data(ForestNodeMerger.merge(this.sysEmployeeService.getEmployeeTreeById(orgId, true)));
        }
        return ApiResponse.data(ForestNodeMerger.merge(this.sysEmployeeService.getEmployeeTreeById(orgId)));
    }

    @RequestMapping(value={"/exportData"})
    @RequiresPermissions(value={"employee:exportData"})
    @BussinessLog(key="/employee/exportData", type="04", value="\u4eba\u5458\u6570\u636e\u5bfc\u51fa")
    public void exportData(HttpServletResponse response) {
        String ids = super.getPara("ids");
        List<String> idList = Arrays.asList(ids.split(","));
        this.sysEmployeeService.exportData(idList, response);
    }
}

