/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.view.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganVo;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.view.dao.HussarViewManagementMapper;
import com.jxdinfo.hussar.view.dto.HussarViewDTO;
import com.jxdinfo.hussar.view.dto.ViewSchemaDTO;
import com.jxdinfo.hussar.view.model.HussarComponentView;
import com.jxdinfo.hussar.view.model.HussarView;
import com.jxdinfo.hussar.view.model.HussarViewOrder;
import com.jxdinfo.hussar.view.service.IHussarViewManagementService;
import com.jxdinfo.hussar.view.service.IHussarViewOrderService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class HussarViewManagementServiceImpl
extends HussarServiceImpl<HussarViewManagementMapper, HussarComponentView>
implements IHussarViewManagementService {
    @Resource
    private HussarViewManagementMapper hussarViewManagementMapper;
    @Resource
    private IHussarViewOrderService iHussarViewOrderService;
    @Resource
    private IHussarBaseOrganizationBoService iHussarBaseOrganizationBoService;
    private static final Logger logger = LoggerFactory.getLogger(HussarViewManagementServiceImpl.class);

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> saveViewSysAndPub(ViewSchemaDTO viewSchemaDTO) {
        String componentId;
        String pageId;
        List views = viewSchemaDTO.getViews();
        String appId = viewSchemaDTO.getAppId();
        List<HussarView> oldViews = this.hussarViewManagementMapper.getSysAndPub(appId, pageId = viewSchemaDTO.getPageId(), componentId = viewSchemaDTO.getComponentId(), "private");
        if (HussarUtils.isNotEmpty(oldViews)) {
            ArrayList<Long> delIds = new ArrayList<Long>();
            for (HussarView oldView : oldViews) {
                if (!views.stream().noneMatch(e -> HussarUtils.equals((Object)e.getViewIdSys(), (Object)oldView.getViewIdSys()))) continue;
                delIds.add(oldView.getViewId());
            }
            views.forEach(view -> {
                HussarView matchingOldView = oldViews.stream().filter(oldView -> HussarUtils.equals((Object)oldView.getViewIdSys(), (Object)view.getViewIdSys())).findFirst().orElse(null);
                if (matchingOldView != null) {
                    view.setViewId(matchingOldView.getViewId());
                }
            });
            if (HussarUtils.isNotEmpty(delIds)) {
                this.removeByIds(delIds);
            }
        }
        if (HussarUtils.isEmpty((Object)views)) {
            return ApiResponse.fail((String)"\u89c6\u56fe\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        ArrayList<HussarComponentView> hussarComponentViews = new ArrayList<HussarComponentView>();
        for (HussarView view2 : views) {
            hussarComponentViews.add(this.dealHussarView(view2));
        }
        boolean saveOrUpdateBatch = this.saveOrUpdateBatch(hussarComponentViews);
        this.iHussarViewOrderService.handleViewDefaultOrder(appId, pageId, componentId, hussarComponentViews, viewSchemaDTO.getViewOrder());
        return ApiResponse.success((Object)saveOrUpdateBatch);
    }

    private HussarComponentView dealHussarView(HussarView hussarView) {
        HussarComponentView hussarComponentView = (HussarComponentView)HussarUtils.copyProperties((Object)hussarView, HussarComponentView.class);
        if (hussarView.getVisible().booleanValue()) {
            hussarComponentView.setVisible("1");
        } else {
            hussarComponentView.setVisible("0");
        }
        return hussarComponentView;
    }

    public ApiResponse<List<HussarView>> getViewSysAndPub(String pageId, String componentId, String appId) {
        List<HussarView> views = this.hussarViewManagementMapper.getSysAndPub(appId, pageId, componentId, "private");
        return ApiResponse.success(views);
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> deleteViewByComponent(String appId, String pageId, List<String> componentIds) {
        List<String> oldComponentIds = this.hussarViewManagementMapper.selectAllComponentIds(pageId, appId);
        if (HussarUtils.isNotEmpty(oldComponentIds) && HussarUtils.isNotEmpty(componentIds)) {
            oldComponentIds.removeAll(componentIds);
        }
        if (HussarUtils.isEmpty(oldComponentIds)) {
            return ApiResponse.success((Object)true);
        }
        return ApiResponse.success((Object)this.hussarViewManagementMapper.deleteByComponentIds(pageId, appId, oldComponentIds));
    }

    public ApiResponse<Boolean> deleteViewByPage(String appId, String pageId) {
        return ApiResponse.success((Object)this.hussarViewManagementMapper.deleteByPageId(pageId, appId));
    }

    public ApiResponse<Boolean> deleteViewByApp(String appId) {
        return ApiResponse.success((Object)this.hussarViewManagementMapper.deleteByAppId(appId));
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Long> saveViewReturnId(HussarView view) {
        Long userId = BaseSecurityUtil.getUser().getId();
        ArrayList<String> authority = new ArrayList<String>();
        authority.add(String.valueOf(userId));
        view.setViewPermission(JSON.toJSONString(authority));
        try {
            this.hussarViewManagementMapper.insert(this.dealHussarView(view));
        }
        catch (Exception e) {
            return ApiResponse.fail((String)"\u4fdd\u5b58\u89c6\u56fe\u5931\u8d25");
        }
        String pageId = view.getPageId();
        String componentId = view.getComponentId();
        String appId = view.getAppId();
        HussarViewOrder oldOrder = (HussarViewOrder)this.iHussarViewOrderService.getOrderByUser(appId, pageId, componentId, userId).getData();
        HussarViewOrder newOrder = new HussarViewOrder();
        if (HussarUtils.isEmpty((Object)oldOrder)) {
            HussarViewOrder defaultOrder = (HussarViewOrder)this.iHussarViewOrderService.getDefaultOrder(appId, pageId, componentId).getData();
            if (HussarUtils.isNotEmpty((Object)defaultOrder)) {
                HussarUtils.copy((Object)defaultOrder, (Object)newOrder);
                List order = JSON.parseArray((String)newOrder.getViewOrder(), String.class);
                HashMap hide = (HashMap)JSON.parseObject((String)newOrder.getViewHide(), (TypeReference)new TypeReference<HashMap<String, Object>>(){}, (Feature[])new Feature[0]);
                order.add(0, view.getViewId().toString());
                hide.put(view.getViewId().toString(), "true");
                newOrder.setOrderId(null);
                newOrder.setAppId(appId);
                newOrder.setPageId(pageId);
                newOrder.setComponentId(componentId);
                newOrder.setUserId(userId);
                newOrder.setViewOrder(JSON.toJSONString((Object)order));
                newOrder.setViewHide(JSON.toJSONString((Object)hide));
                this.iHussarViewOrderService.insert(newOrder);
            } else {
                List<HussarView> views = this.hussarViewManagementMapper.getByPageId(pageId, String.valueOf(userId), componentId, appId);
                ArrayList<String> viewOrders = new ArrayList<String>();
                HashMap<String, String> viewHide = new HashMap<String, String>();
                for (HussarView oldView : views) {
                    viewOrders.add(String.valueOf(oldView.getViewId()));
                    viewHide.put(String.valueOf(oldView.getViewId()), "true");
                }
                viewOrders.add(0, view.getViewId().toString());
                viewHide.put(view.getViewId().toString(), "true");
                newOrder.setAppId(view.getAppId());
                newOrder.setPageId(view.getPageId());
                newOrder.setComponentId(view.getComponentId());
                newOrder.setUserId(userId);
                newOrder.setViewOrder(JSON.toJSONString(viewOrders));
                newOrder.setViewHide(JSON.toJSONString(viewHide));
                this.iHussarViewOrderService.insert(newOrder);
            }
        } else {
            HussarUtils.copy((Object)oldOrder, (Object)newOrder);
            List order = JSON.parseArray((String)newOrder.getViewOrder(), String.class);
            HashMap hide = (HashMap)JSON.parseObject((String)newOrder.getViewHide(), (TypeReference)new TypeReference<HashMap<String, Object>>(){}, (Feature[])new Feature[0]);
            order.add(0, String.valueOf(view.getViewId()));
            hide.put(String.valueOf(view.getViewId()), "true");
            newOrder.setViewOrder(JSON.toJSONString((Object)order));
            newOrder.setViewHide(JSON.toJSONString((Object)hide));
            this.iHussarViewOrderService.update(newOrder);
        }
        return ApiResponse.success((Object)view.getViewId());
    }

    public ApiResponse<List<HussarView>> get(String pageId, String componentId, String appId) {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)user)) {
            logger.error("\u81ea\u5b9a\u4e49\u89c6\u56fe\u67e5\u8be2\u5931\u8d25\uff0c\u7528\u6237\u4fe1\u606f\u5f02\u5e38");
            return ApiResponse.fail((String)"\u65e0\u7528\u6237\u4fe1\u606f");
        }
        List<HussarView> views = this.hussarViewManagementMapper.getByPageId(pageId, String.valueOf(user.getId()), componentId, appId);
        this.publicViewPermission(views, user);
        views = this.handleViewOrder(appId, pageId, componentId, views);
        return ApiResponse.success(views);
    }

    private List<HussarView> publicViewPermission(List<HussarView> views, SecurityUser user) {
        List publicViews = views.stream().filter(x -> HussarUtils.equals((Object)x.getViewType(), (Object)"public")).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(publicViews)) {
            boolean superAdmin;
            Long userId = user.getId();
            Long deptId = user.getDeptId();
            boolean isTenantAdmin = false;
            if (HussarUtils.isNotEmpty((Object)user.getRolesList())) {
                isTenantAdmin = user.getRolesList().contains(TenantConstant.ADMIN_ROLE);
            }
            boolean bl = superAdmin = user.isSuperAdmin() || isTenantAdmin;
            if (!superAdmin) {
                ArrayList<HussarView> delPublic = new ArrayList<HussarView>();
                for (HussarView publicView : publicViews) {
                    List userIds;
                    Map viewPermission = (Map)JSON.parseObject((String)publicView.getViewPermission(), Map.class);
                    if (!HussarUtils.equals(viewPermission.get("type"), (Object)"some")) continue;
                    if (HussarUtils.isEmpty(viewPermission.get("config"))) {
                        delPublic.add(publicView);
                        continue;
                    }
                    Map config = (Map)JSON.parseObject((String)JSON.toJSONString(viewPermission.get("config")), Map.class);
                    List organs = JSON.parseArray((String)JSON.toJSONString(config.get("organs")), OrganVo.class);
                    List staffs = JSON.parseArray((String)JSON.toJSONString(config.get("staffs")), OrganVo.class);
                    if (HussarUtils.isNotEmpty((Object)staffs) && HussarUtils.contains((userIds = staffs.stream().map(OrganVo::getId).collect(Collectors.toList())).iterator(), (Object)userId.toString())) continue;
                    if (HussarUtils.isNotEmpty((Object)organs)) {
                        ArrayList allSubOrgan = new ArrayList();
                        Boolean containSub = (Boolean)JSON.parseObject((String)JSON.toJSONString(config.get("containSub")), Boolean.class);
                        if (containSub.booleanValue()) {
                            List deptIds = organs.stream().map(OrganVo::getId).collect(Collectors.toList());
                            for (String id : deptIds) {
                                allSubOrgan.addAll(this.iHussarBaseOrganizationBoService.getAllSubOrgan(Long.valueOf(id)));
                            }
                        } else {
                            allSubOrgan.addAll(organs);
                        }
                        List deptIdsWithChildren = allSubOrgan.stream().map(OrganVo::getId).collect(Collectors.toList());
                        if (HussarUtils.contains(deptIdsWithChildren.iterator(), (Object)deptId.toString())) continue;
                    }
                    delPublic.add(publicView);
                }
                views.removeAll(delPublic);
            }
        }
        return views;
    }

    private List<HussarView> handleViewOrder(String appId, String pageId, String componentId, List<HussarView> allViews) {
        ArrayList<HussarView> orderView = new ArrayList<HussarView>();
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        Long userId = shiroUser.getId();
        HussarViewOrder customOrder = (HussarViewOrder)this.iHussarViewOrderService.getOrderByUser(appId, pageId, componentId, userId).getData();
        if (HussarUtils.isNotEmpty((Object)customOrder)) {
            List viewOrders = JSON.parseArray((String)customOrder.getViewOrder(), String.class);
            List viewOrder = viewOrders.stream().distinct().collect(Collectors.toList());
            ArrayList<Object> newViewOrder = new ArrayList<Object>();
            newViewOrder.addAll(viewOrder);
            Map viewHide = (Map)JSON.parseObject((String)customOrder.getViewHide(), HashMap.class);
            HashMap<String, String> newViewHide = new HashMap<String, String>();
            HussarUtils.copy((Object)viewHide, newViewHide);
            for (HussarView allView : allViews) {
                Optional<String> first = viewOrder.stream().filter(v -> HussarUtils.equals((Object)v, (Object)allView.getViewId())).findFirst();
                if (first.isPresent() || HussarUtils.equals((Object)allView.getViewType(), (Object)"private") || newViewOrder.contains(String.valueOf(allView.getViewId()))) continue;
                newViewOrder.add(String.valueOf(allView.getViewId()));
                newViewHide.put(String.valueOf(allView.getViewId()), "true");
            }
            List newDistinctViewOrder = newViewOrder.stream().distinct().collect(Collectors.toList());
            customOrder.setViewOrder(JSON.toJSONString(newDistinctViewOrder));
            customOrder.setViewHide(JSON.toJSONString(newViewHide));
            this.iHussarViewOrderService.update(customOrder);
            for (String viewId : newDistinctViewOrder) {
                Optional<HussarView> first = allViews.stream().filter(view -> HussarUtils.equals((Object)String.valueOf(view.getViewId()), (Object)viewId)).findFirst();
                if (!first.isPresent()) continue;
                HussarView view2 = first.get();
                String hide = (String)newViewHide.get(viewId);
                if (HussarUtils.isNotEmpty((Object)hide)) {
                    view2.setVisible(Boolean.valueOf(Boolean.parseBoolean(hide)));
                }
                orderView.add(view2);
            }
            return orderView;
        }
        HussarViewOrder defaultOrder = (HussarViewOrder)this.iHussarViewOrderService.getDefaultOrder(appId, pageId, componentId).getData();
        if (HussarUtils.isEmpty((Object)defaultOrder)) {
            for (HussarView view3 : allViews) {
                view3.setVisible(Boolean.valueOf(true));
                orderView.add(view3);
            }
        } else {
            List viewOrders = JSON.parseArray((String)defaultOrder.getViewOrder(), String.class);
            for (String viewId : viewOrders) {
                Optional<HussarView> any = allViews.stream().filter(x -> HussarUtils.equals((Object)String.valueOf(x.getViewId()), (Object)viewId)).findAny();
                if (!any.isPresent()) continue;
                HussarView view4 = any.get();
                view4.setVisible(Boolean.valueOf(true));
                orderView.add(view4);
            }
        }
        return orderView;
    }

    public ApiResponse<HussarView> getById(Long viewId) {
        HussarComponentView view = (HussarComponentView)this.hussarViewManagementMapper.selectById(viewId);
        try {
            return ApiResponse.success((Object)this.dealHussarComponentView(view));
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u81ea\u5b9a\u4e49\u89c6\u56fe\u5f02\u5e38\uff1a{}\uff0cviewId\uff1a{}", (Object)e.getMessage(), (Object)viewId);
            return ApiResponse.fail((String)"\u83b7\u53d6\u89c6\u56fe ==> \u83b7\u53d6\u5931\u8d25");
        }
    }

    private HussarView dealHussarComponentView(HussarComponentView hussarComponentView) {
        HussarView hussarView = (HussarView)HussarUtils.copyProperties((Object)hussarComponentView, HussarView.class);
        if (HussarUtils.equals((Object)hussarComponentView.getVisible(), (Object)"1")) {
            hussarView.setVisible(Boolean.valueOf(true));
        } else {
            hussarView.setVisible(Boolean.valueOf(false));
        }
        return hussarView;
    }

    public ApiResponse<Boolean> deleteById(String viewId) {
        try {
            this.hussarViewManagementMapper.deleteById(Long.valueOf(viewId));
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u81ea\u5b9a\u4e49\u89c6\u56fe\u5f02\u5e38\uff1a{}\uff0cviewId\uff1a{}", (Object)e.getMessage(), (Object)viewId);
            return ApiResponse.fail((String)"\u5220\u9664\u89c6\u56fe ==> \u5220\u9664\u5931\u8d25");
        }
        return ApiResponse.success((Object)true);
    }

    public ApiResponse<Boolean> update(HussarView view) {
        try {
            this.hussarViewManagementMapper.updateById(this.dealHussarView(view));
        }
        catch (Exception e) {
            return ApiResponse.fail((String)"\u66f4\u65b0\u81ea\u5b9a\u4e49\u89c6\u56fe ==> \u66f4\u65b0\u5931\u8d25");
        }
        return ApiResponse.success((Object)true);
    }

    public ApiResponse<Long> copyView(HussarView view) {
        return this.saveViewReturnId(view);
    }

    public ApiResponse<Boolean> updateBatch(HussarViewDTO hussarViewDTO) {
        List views = hussarViewDTO.getViews();
        ArrayList<HussarComponentView> hussarComponentViews = new ArrayList<HussarComponentView>();
        for (HussarView view : views) {
            hussarComponentViews.add(this.dealHussarView(view));
        }
        try {
            this.saveOrUpdateBatch(hussarComponentViews);
        }
        catch (Exception e) {
            return ApiResponse.fail((String)"\u6279\u91cf\u5220\u9664\u89c6\u56fe\u5931\u8d25");
        }
        return ApiResponse.success((Object)true);
    }

    public ApiResponse<Boolean> deleteBatch(String pageId) {
        try {
            this.hussarViewManagementMapper.delete((Wrapper)new QueryWrapper().lambda().eq(HussarComponentView::getPageId, (Object)pageId));
        }
        catch (Exception e) {
            return ApiResponse.fail((String)"\u6279\u91cf\u5220\u9664\u89c6\u56fe\u5931\u8d25");
        }
        return ApiResponse.success((Object)true);
    }
}

