/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unifiedtodo.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.unifiedtodo.dao.UnifiedToDoMapper;
import com.jxdinfo.hussar.unifiedtodo.dto.QueryToDoDto;
import com.jxdinfo.hussar.unifiedtodo.dto.SaveProcessDto;
import com.jxdinfo.hussar.unifiedtodo.dto.SaveToDoDto;
import com.jxdinfo.hussar.unifiedtodo.dto.TransferTaskDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UpdateTaskUserToDoDto;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedStartTask;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedSystemInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskUser;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedStartTaskService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedSystemInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskUserService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedToDoService;
import com.jxdinfo.hussar.unifiedtodo.vo.ToDoVo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnifiedToDoServiceImpl
implements IUnifiedToDoService {
    @Resource
    private UnifiedToDoMapper unifiedToDoMapper;
    @Autowired
    private IUnifiedSystemInfoService unifiedSystemInfoServiceImpl;
    @Autowired
    private IUnifiedTaskInfoService unifiedTaskInfoServiceImpl;
    @Autowired
    private IUnifiedTaskUserService unifiedTaskUserServiceImpl;
    @Autowired
    private IUnifiedTaskUserService unifiedTaskUserService;
    @Autowired
    private IUnifiedStartTaskService unifiedStartTaskServiceImpl;
    private static final Logger logger = LoggerFactory.getLogger(UnifiedToDoServiceImpl.class);

    public ApiResponse<Long> getCountTotal(String systemId, String userId, String executeStatus) {
        LambdaQueryWrapper wrapperInfo = new LambdaQueryWrapper();
        LambdaQueryWrapper wrapperUser = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)systemId)) {
            wrapperInfo.eq(UnifiedTaskInfo::getSystemId, (Object)Long.parseLong(systemId));
            wrapperUser.eq(UnifiedTaskUser::getSystemId, (Object)Long.parseLong(systemId));
        }
        if (ToolUtil.isNotEmpty((Object)executeStatus)) {
            wrapperUser.eq(UnifiedTaskUser::getExecuteStatus, (Object)executeStatus);
            wrapperInfo.eq(UnifiedTaskInfo::getTaskStatus, (Object)executeStatus);
        }
        if (ToolUtil.isNotEmpty((Object)userId)) {
            wrapperUser.eq(UnifiedTaskUser::getUserId, (Object)userId);
            return ApiResponse.success((Object)this.unifiedTaskUserServiceImpl.count((Wrapper)wrapperUser));
        }
        return ApiResponse.success((Object)this.unifiedTaskInfoServiceImpl.count((Wrapper)wrapperInfo));
    }

    public ApiResponse<JSONObject> countAllTotal(String systemId, String userId) {
        LambdaQueryWrapper wrapperUser = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)systemId)) {
            wrapperUser.eq(UnifiedTaskUser::getSystemId, (Object)Long.valueOf(systemId));
        }
        wrapperUser.eq(UnifiedTaskUser::getUserId, (Object)userId);
        wrapperUser.eq(UnifiedTaskUser::getExecuteStatus, (Object)"0");
        wrapperUser.eq(UnifiedTaskUser::getUserType, (Object)"1");
        long todoCount = this.unifiedTaskUserServiceImpl.count((Wrapper)wrapperUser);
        wrapperUser.clear();
        if (HussarUtils.isNotEmpty((Object)systemId)) {
            wrapperUser.eq(UnifiedTaskUser::getSystemId, (Object)Long.valueOf(systemId));
        }
        wrapperUser.eq(UnifiedTaskUser::getUserId, (Object)userId);
        wrapperUser.eq(UnifiedTaskUser::getExecuteStatus, (Object)"1");
        wrapperUser.eq(UnifiedTaskUser::getUserType, (Object)"1");
        long doneCount = this.unifiedTaskUserServiceImpl.count((Wrapper)wrapperUser);
        wrapperUser.clear();
        if (HussarUtils.isNotEmpty((Object)systemId)) {
            wrapperUser.eq(UnifiedTaskUser::getSystemId, (Object)Long.valueOf(systemId));
        }
        wrapperUser.eq(UnifiedTaskUser::getUserId, (Object)userId);
        wrapperUser.eq(UnifiedTaskUser::getUserType, (Object)"0");
        long ccCount = this.unifiedTaskUserServiceImpl.count((Wrapper)wrapperUser);
        wrapperUser.clear();
        if (HussarUtils.isNotEmpty((Object)systemId)) {
            wrapperUser.eq(UnifiedTaskUser::getSystemId, (Object)Long.valueOf(systemId));
        }
        wrapperUser.eq(UnifiedTaskUser::getUserId, (Object)userId);
        wrapperUser.eq(UnifiedTaskUser::getUserType, (Object)"1");
        wrapperUser.eq(UnifiedTaskUser::getUrgeStatus, (Object)"1");
        long urgeCount = this.unifiedTaskUserServiceImpl.count((Wrapper)wrapperUser);
        LambdaQueryWrapper wrapperStart = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)systemId)) {
            wrapperStart.eq(UnifiedStartTask::getSystemId, (Object)Long.valueOf(systemId));
        }
        wrapperStart.eq(UnifiedStartTask::getCreateUserId, (Object)userId);
        long startCount = this.unifiedStartTaskServiceImpl.count((Wrapper)wrapperStart);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("todo", (Object)todoCount);
        jsonObject.put("done", (Object)doneCount);
        jsonObject.put("cc", (Object)ccCount);
        jsonObject.put("urge", (Object)urgeCount);
        jsonObject.put("start", (Object)startCount);
        return ApiResponse.success((Object)jsonObject);
    }

    public ApiResponse<String> saveTask(SaveToDoDto saveToDoDto) {
        List executors = saveToDoDto.getExecutors();
        List followers = saveToDoDto.getFollowers();
        String taskStatus = ToolUtil.isNotEmpty((Object)saveToDoDto.getTaskStatus()) ? saveToDoDto.getTaskStatus() : "0";
        saveToDoDto.setTaskStatus(taskStatus);
        this.unifiedTaskInfoServiceImpl.save((Object)saveToDoDto);
        for (UnifiedTaskUser unifiedTaskUser : executors) {
            unifiedTaskUser.setSystemId(saveToDoDto.getSystemId());
            unifiedTaskUser.setTaskId(saveToDoDto.getTaskId());
            unifiedTaskUser.setTodoId(saveToDoDto.getTodoId());
            unifiedTaskUser.setExecuteStatus(taskStatus);
            unifiedTaskUser.setUserType("1");
        }
        if (ToolUtil.isNotEmpty((Object)followers)) {
            for (UnifiedTaskUser unifiedTaskUser : followers) {
                unifiedTaskUser.setSystemId(saveToDoDto.getSystemId());
                unifiedTaskUser.setTaskId(saveToDoDto.getTaskId());
                unifiedTaskUser.setTodoId(saveToDoDto.getTodoId());
                unifiedTaskUser.setExecuteStatus(taskStatus);
                unifiedTaskUser.setUserType("0");
            }
            executors.addAll(followers);
        }
        this.unifiedTaskUserServiceImpl.saveBatch((Collection)executors);
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> updateTask(SaveToDoDto saveToDoDto) {
        saveToDoDto.setLastTime(ToolUtil.isNotEmpty((Object)saveToDoDto.getLastTime()) ? saveToDoDto.getLastTime() : new Date());
        LambdaQueryWrapper wrapperInfo = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)saveToDoDto.getSystemId())) {
            wrapperInfo.eq(UnifiedTaskInfo::getSystemId, (Object)saveToDoDto.getSystemId());
        }
        wrapperInfo.eq(UnifiedTaskInfo::getTaskId, (Object)saveToDoDto.getTaskId());
        UnifiedTaskInfo s = (UnifiedTaskInfo)this.unifiedTaskInfoServiceImpl.getOne((Wrapper)wrapperInfo);
        if (ToolUtil.isEmpty((Object)s)) {
            this.unifiedTaskInfoServiceImpl.save((Object)saveToDoDto);
        } else {
            this.unifiedTaskInfoServiceImpl.updateById((Object)saveToDoDto);
        }
        List executors = saveToDoDto.getExecutors();
        List followers = saveToDoDto.getFollowers();
        if (ToolUtil.isNotEmpty((Object)executors)) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper.eq(UnifiedTaskUser::getSystemId, (Object)saveToDoDto.getSystemId())).eq(UnifiedTaskUser::getTaskId, (Object)saveToDoDto.getTaskId());
            this.unifiedTaskUserServiceImpl.remove((Wrapper)wrapper);
            for (UnifiedTaskUser unifiedTaskUser : executors) {
                unifiedTaskUser.setSystemId(saveToDoDto.getSystemId());
                unifiedTaskUser.setTaskId(saveToDoDto.getTaskId());
                unifiedTaskUser.setTodoId(saveToDoDto.getTodoId());
                unifiedTaskUser.setExecuteStatus("0");
                unifiedTaskUser.setUserType("1");
            }
            if (ToolUtil.isNotEmpty((Object)followers)) {
                for (UnifiedTaskUser unifiedTaskUser : followers) {
                    unifiedTaskUser.setSystemId(saveToDoDto.getSystemId());
                    unifiedTaskUser.setTaskId(saveToDoDto.getTaskId());
                    unifiedTaskUser.setTodoId(saveToDoDto.getTodoId());
                    unifiedTaskUser.setExecuteStatus("0");
                    unifiedTaskUser.setUserType("0");
                }
                executors.addAll(followers);
            }
        }
        this.unifiedTaskUserServiceImpl.saveBatch((Collection)executors);
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<Page<SaveToDoDto>> getListTask(Page<SaveToDoDto> page, QueryToDoDto queryToDoDto) {
        Page<SaveToDoDto> saveToDoDtoPage;
        List<Object> saveToDoDtoList = new ArrayList();
        if ("3".equals(queryToDoDto.getUserType())) {
            Page pageProcess = new Page();
            pageProcess.setCurrent(page.getCurrent());
            pageProcess.setSize(page.getSize());
            saveToDoDtoPage = this.unifiedToDoMapper.queryProcessList((Page<SaveProcessDto>)pageProcess, queryToDoDto);
            saveToDoDtoList = saveToDoDtoPage.getRecords();
        } else {
            saveToDoDtoPage = this.unifiedToDoMapper.queryTaskList(page, queryToDoDto);
            saveToDoDtoList = saveToDoDtoPage.getRecords();
            for (Object saveToDoDto2 : saveToDoDtoList) {
                if (!"0".equals(saveToDoDto2.getSystemSource())) continue;
                if (saveToDoDto2.getMandator() != null && saveToDoDto2.getWebLinkurl() != null) {
                    saveToDoDto2.setWebLinkurl(saveToDoDto2.getWebLinkurl().replaceFirst("&taskId=" + saveToDoDto2.getTaskId(), "&taskId=" + saveToDoDto2.getTaskId() + ":" + saveToDoDto2.getMandator()));
                }
                if (saveToDoDto2.getCcMoment() == null) continue;
                saveToDoDto2.setTaskId(saveToDoDto2.getTaskId() + ":" + saveToDoDto2.getCcMoment());
            }
        }
        if ("3".equals(queryToDoDto.getUserType())) {
            ArrayList<String> processInstIdList = new ArrayList<String>();
            for (SaveToDoDto saveToDoDto2 : saveToDoDtoList) {
                if ("1".equals(saveToDoDto2.getProcessState())) {
                    saveToDoDto2.setCurrentNodeName("\u7ed3\u675f");
                    continue;
                }
                processInstIdList.add(saveToDoDto2.getProcessInstanceid());
            }
            if (HussarUtils.isNotEmpty(processInstIdList)) {
                List<SaveToDoDto> nodeNameList = this.unifiedToDoMapper.getNodeNames(processInstIdList);
                HashMap<String, Set> hashMap = new HashMap<String, Set>();
                for (SaveToDoDto saveToDoDto3 : nodeNameList) {
                    String procInstId = saveToDoDto3.getProcessInstanceid();
                    Set set = (Set)hashMap.get(procInstId);
                    set = set == null ? new HashSet() : set;
                    set.add(saveToDoDto3.getTaskName());
                    hashMap.put(procInstId, set);
                }
                for (SaveToDoDto saveToDoDto4 : saveToDoDtoList) {
                    Set nodeNames = (Set)hashMap.get(saveToDoDto4.getProcessInstanceid());
                    if (!HussarUtils.isNotEmpty((Object)nodeNames)) continue;
                    saveToDoDto4.setCurrentNodeName(String.join((CharSequence)",", nodeNames));
                }
            }
            saveToDoDtoList = saveToDoDtoList.stream().filter(saveToDoDto -> Objects.nonNull(saveToDoDto.getCurrentNodeName())).collect(Collectors.toList());
            saveToDoDtoPage.setRecords(saveToDoDtoList);
        }
        return ApiResponse.success(saveToDoDtoPage);
    }

    public ApiResponse<ToDoVo> getToDoByTaskId(String todoId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(UnifiedTaskInfo::getTodoId, (Object)Long.parseLong(todoId));
        UnifiedTaskInfo unifiedTaskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoServiceImpl.getOne((Wrapper)wrapper);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UnifiedTaskUser::getTodoId, (Object)todoId);
        List users = this.unifiedTaskUserServiceImpl.list((Wrapper)queryWrapper);
        ArrayList<UnifiedTaskUser> executors = new ArrayList<UnifiedTaskUser>();
        ArrayList<UnifiedTaskUser> followers = new ArrayList<UnifiedTaskUser>();
        for (UnifiedTaskUser unifiedTaskUser : users) {
            if ("1".equals(unifiedTaskUser.getUserType())) {
                executors.add(unifiedTaskUser);
                continue;
            }
            followers.add(unifiedTaskUser);
        }
        ToDoVo toDoVo = (ToDoVo)JSON.parseObject((String)JSON.toJSONString((Object)unifiedTaskInfo), ToDoVo.class);
        toDoVo.setExecutors(executors);
        toDoVo.setFollowers(followers);
        LambdaQueryWrapper wrapperSystem = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)unifiedTaskInfo.getSystemId())) {
            wrapperSystem.eq(UnifiedSystemInfo::getSystemId, (Object)unifiedTaskInfo.getSystemId());
            toDoVo.setSystemAddress(((UnifiedSystemInfo)this.unifiedSystemInfoServiceImpl.getOne((Wrapper)wrapperSystem)).getSystemAddress());
        }
        return ApiResponse.success((Object)toDoVo);
    }

    public ApiResponse<String> deleteTask(String taskIds, String systemId, String processInstId) {
        ArrayList<String> taskId = null;
        if (ToolUtil.isNotEmpty((Object)taskIds)) {
            taskId = new ArrayList<String>(Arrays.asList(taskIds.split(",")));
        }
        LambdaQueryWrapper wrapperInfo = new LambdaQueryWrapper();
        LambdaQueryWrapper wrapperUser = new LambdaQueryWrapper();
        if (ToolUtil.isNotEmpty(taskId)) {
            wrapperInfo.in(UnifiedTaskInfo::getTaskId, taskId);
            wrapperUser.in(UnifiedTaskUser::getTaskId, taskId);
        }
        if (ToolUtil.isNotEmpty((Object)systemId)) {
            wrapperInfo.eq(UnifiedTaskInfo::getSystemId, (Object)Long.parseLong(systemId));
            wrapperUser.eq(UnifiedTaskUser::getSystemId, (Object)Long.parseLong(systemId));
        }
        if (ToolUtil.isNotEmpty((Object)processInstId)) {
            ArrayList<String> processInstIdList = new ArrayList<String>(Arrays.asList(processInstId.split(",")));
            wrapperInfo.in(UnifiedTaskInfo::getProcessInstanceid, processInstIdList);
            LambdaQueryWrapper wrapperInfoByProcessInstId = new LambdaQueryWrapper();
            wrapperInfoByProcessInstId.in(UnifiedTaskInfo::getProcessInstanceid, processInstIdList);
            List list = this.unifiedTaskInfoServiceImpl.list((Wrapper)wrapperInfoByProcessInstId).stream().map(UnifiedTaskInfo::getTodoId).collect(Collectors.toList());
            wrapperUser.in(HussarUtils.isNotEmpty(list), UnifiedTaskUser::getTodoId, list);
        }
        this.unifiedTaskInfoServiceImpl.remove((Wrapper)wrapperInfo);
        this.unifiedTaskUserServiceImpl.remove((Wrapper)wrapperUser);
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> updateTaskStatus(String taskId, String systemId, String processInstId, String taskStatus, String webLinkurl, String mobileLinkurl, String lastTime) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = ToolUtil.isNotEmpty((Object)lastTime) ? formatter.parse(lastTime) : new Date();
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        taskStatus = ToolUtil.isNotEmpty((Object)taskStatus) ? taskStatus : "1";
        LambdaUpdateWrapper wrapperInfo = new LambdaUpdateWrapper();
        if (ToolUtil.isNotEmpty((Object)taskId)) {
            wrapperInfo.eq(UnifiedTaskInfo::getTaskId, (Object)taskId);
        }
        if (ToolUtil.isNotEmpty((Object)systemId)) {
            wrapperInfo.eq(UnifiedTaskInfo::getSystemId, (Object)Long.parseLong(systemId));
        }
        List userByProcessInstId = null;
        if (ToolUtil.isNotEmpty((Object)processInstId)) {
            wrapperInfo.eq(UnifiedTaskInfo::getProcessInstanceid, (Object)processInstId);
            LambdaUpdateWrapper wrapperByProcessInstId = new LambdaUpdateWrapper();
            wrapperByProcessInstId.eq(UnifiedTaskInfo::getProcessInstanceid, (Object)processInstId);
            userByProcessInstId = this.unifiedTaskInfoServiceImpl.list((Wrapper)wrapperByProcessInstId).stream().map(UnifiedTaskInfo::getTodoId).collect(Collectors.toList());
        }
        if (ToolUtil.isNotEmpty((Object)mobileLinkurl)) {
            wrapperInfo.set(UnifiedTaskInfo::getMobileLinkurl, (Object)mobileLinkurl);
        }
        if (ToolUtil.isNotEmpty((Object)webLinkurl)) {
            wrapperInfo.set(UnifiedTaskInfo::getWebLinkurl, (Object)webLinkurl);
        }
        wrapperInfo.set(UnifiedTaskInfo::getTaskStatus, (Object)taskStatus);
        wrapperInfo.set(UnifiedTaskInfo::getLastTime, (Object)date);
        this.unifiedTaskInfoServiceImpl.update((Wrapper)wrapperInfo);
        LambdaUpdateWrapper wrapperUser = new LambdaUpdateWrapper();
        if (ToolUtil.isNotEmpty((Object)systemId)) {
            wrapperUser.eq(UnifiedTaskUser::getSystemId, (Object)Long.parseLong(systemId));
        }
        if (ToolUtil.isNotEmpty((Object)taskId)) {
            wrapperUser.eq(UnifiedTaskUser::getTaskId, (Object)taskId);
        }
        if (ToolUtil.isNotEmpty(userByProcessInstId)) {
            wrapperUser.in(UnifiedTaskUser::getTodoId, userByProcessInstId);
        }
        wrapperUser.set(UnifiedTaskUser::getExecuteStatus, (Object)taskStatus);
        if ("1".equals(taskStatus)) {
            wrapperUser.set(UnifiedTaskUser::getCompleteTime, (Object)date);
        } else {
            wrapperUser.set(UnifiedTaskUser::getCompleteTime, null);
        }
        this.unifiedTaskUserServiceImpl.update((Wrapper)wrapperUser);
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> updateTaskStatusWithOutFollowers(String taskId, String systemId, String processInstId, String taskStatus, String webLinkurl, String mobileLinkurl, String lastTime) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = ToolUtil.isNotEmpty((Object)lastTime) ? formatter.parse(lastTime) : new Date();
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        taskStatus = ToolUtil.isNotEmpty((Object)taskStatus) ? taskStatus : "1";
        LambdaUpdateWrapper wrapperInfo = new LambdaUpdateWrapper();
        if (ToolUtil.isNotEmpty((Object)taskId)) {
            wrapperInfo.eq(UnifiedTaskInfo::getTaskId, (Object)taskId);
        }
        if (ToolUtil.isNotEmpty((Object)systemId)) {
            wrapperInfo.eq(UnifiedTaskInfo::getSystemId, (Object)Long.parseLong(systemId));
        }
        List userByProcessInstId = null;
        if (ToolUtil.isNotEmpty((Object)processInstId)) {
            wrapperInfo.eq(UnifiedTaskInfo::getProcessInstanceid, (Object)processInstId);
            LambdaUpdateWrapper wrapperByProcessInstId = new LambdaUpdateWrapper();
            wrapperByProcessInstId.eq(UnifiedTaskInfo::getProcessInstanceid, (Object)processInstId);
            if ("1".equals(taskStatus)) {
                wrapperInfo.eq(UnifiedTaskInfo::getTaskStatus, (Object)"0");
                wrapperByProcessInstId.eq(UnifiedTaskInfo::getTaskStatus, (Object)"0");
            }
            userByProcessInstId = this.unifiedTaskInfoServiceImpl.list((Wrapper)wrapperByProcessInstId).stream().map(UnifiedTaskInfo::getTodoId).collect(Collectors.toList());
        }
        if (ToolUtil.isNotEmpty((Object)mobileLinkurl)) {
            wrapperInfo.set(UnifiedTaskInfo::getMobileLinkurl, (Object)mobileLinkurl);
        }
        if (ToolUtil.isNotEmpty((Object)webLinkurl)) {
            wrapperInfo.set(UnifiedTaskInfo::getWebLinkurl, (Object)webLinkurl);
        }
        wrapperInfo.set(UnifiedTaskInfo::getTaskStatus, (Object)taskStatus);
        wrapperInfo.set(UnifiedTaskInfo::getLastTime, (Object)date);
        this.unifiedTaskInfoServiceImpl.update((Wrapper)wrapperInfo);
        LambdaUpdateWrapper wrapperUser = new LambdaUpdateWrapper();
        wrapperUser.eq(UnifiedTaskUser::getUserType, (Object)"1");
        if (ToolUtil.isNotEmpty((Object)systemId)) {
            wrapperUser.eq(UnifiedTaskUser::getSystemId, (Object)Long.parseLong(systemId));
        }
        if (ToolUtil.isNotEmpty((Object)taskId)) {
            wrapperUser.eq(UnifiedTaskUser::getTaskId, (Object)taskId);
        }
        if (ToolUtil.isNotEmpty(userByProcessInstId)) {
            wrapperUser.in(UnifiedTaskUser::getTodoId, userByProcessInstId);
        }
        wrapperUser.set(UnifiedTaskUser::getExecuteStatus, (Object)taskStatus);
        if ("1".equals(taskStatus)) {
            wrapperUser.set(UnifiedTaskUser::getCompleteTime, (Object)date);
        } else {
            wrapperUser.set(UnifiedTaskUser::getCompleteTime, null);
        }
        this.unifiedTaskUserServiceImpl.update((Wrapper)wrapperUser);
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> updateUserStatus(UnifiedTaskUser unifiedTaskUser) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        if (HussarUtils.isNotEmpty((Object)unifiedTaskUser.getSystemId())) {
            wrapper.eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskUser.getSystemId());
        }
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskUser.getTaskId())).eq(UnifiedTaskUser::getUserId, (Object)unifiedTaskUser.getUserId())).eq(UnifiedTaskUser::getUserType, (Object)unifiedTaskUser.getUserType())).eq(HussarUtils.isNotEmpty((Object)unifiedTaskUser.getCcMoment()), UnifiedTaskUser::getCcMoment, (Object)unifiedTaskUser.getCcMoment());
        ((LambdaUpdateWrapper)wrapper.set(UnifiedTaskUser::getExecuteStatus, (Object)unifiedTaskUser.getExecuteStatus())).set(UnifiedTaskUser::getCompleteTime, (Object)(ToolUtil.isNotEmpty((Object)unifiedTaskUser.getCompleteTime()) ? unifiedTaskUser.getCompleteTime() : new Date()));
        this.unifiedTaskUserServiceImpl.update((Wrapper)wrapper);
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> updateTaskUser(String taskId, String systemId, String executeStatus, List<UnifiedTaskUser> executors, List<UnifiedTaskUser> followers) {
        LambdaQueryWrapper wrapperInfo = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)systemId)) {
            wrapperInfo.eq(UnifiedTaskInfo::getSystemId, (Object)Long.parseLong(systemId));
        }
        wrapperInfo.eq(UnifiedTaskInfo::getTaskId, (Object)taskId);
        Long todoId = ((UnifiedTaskInfo)this.unifiedTaskInfoServiceImpl.getOne((Wrapper)wrapperInfo)).getTodoId();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)systemId)) {
            wrapper.eq(UnifiedTaskUser::getSystemId, (Object)Long.parseLong(systemId));
        }
        ((LambdaQueryWrapper)wrapper.eq(UnifiedTaskUser::getTaskId, (Object)taskId)).eq(UnifiedTaskUser::getUserType, (Object)"1");
        this.unifiedTaskUserServiceImpl.remove((Wrapper)wrapper);
        for (UnifiedTaskUser unifiedTaskUser : executors) {
            unifiedTaskUser.setUnifiedId(null);
            unifiedTaskUser.setSystemId(Long.valueOf(Long.parseLong(systemId)));
            unifiedTaskUser.setTaskId(taskId);
            unifiedTaskUser.setTodoId(todoId);
            unifiedTaskUser.setExecuteStatus(ToolUtil.isNotEmpty((Object)executeStatus) ? executeStatus : "0");
            unifiedTaskUser.setUserType("1");
        }
        if (followers != null) {
            LambdaQueryWrapper wrapperFollower = new LambdaQueryWrapper();
            if (HussarUtils.isNotEmpty((Object)systemId)) {
                wrapperFollower.eq(UnifiedTaskUser::getSystemId, (Object)Long.parseLong(systemId));
            }
            ((LambdaQueryWrapper)wrapperFollower.eq(UnifiedTaskUser::getTaskId, (Object)taskId)).eq(UnifiedTaskUser::getUserType, (Object)"0");
            this.unifiedTaskUserServiceImpl.remove((Wrapper)wrapperFollower);
            for (UnifiedTaskUser unifiedTaskUser : followers) {
                unifiedTaskUser.setUnifiedId(null);
                unifiedTaskUser.setSystemId(Long.valueOf(Long.parseLong(systemId)));
                unifiedTaskUser.setTaskId(taskId);
                unifiedTaskUser.setTodoId(todoId);
                unifiedTaskUser.setExecuteStatus(ToolUtil.isNotEmpty((Object)executeStatus) ? executeStatus : "0");
                unifiedTaskUser.setUserType("0");
            }
            executors.addAll(followers);
        }
        this.unifiedTaskUserServiceImpl.saveBatch(executors);
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> addTaskUser(List<UnifiedTaskUser> unifiedTaskUsers) {
        for (UnifiedTaskUser unifiedTaskUser : unifiedTaskUsers) {
            LambdaQueryWrapper wrapperInfo = new LambdaQueryWrapper();
            if (HussarUtils.isNotEmpty((Object)unifiedTaskUser.getSystemId())) {
                wrapperInfo.eq(UnifiedTaskInfo::getSystemId, (Object)unifiedTaskUser.getSystemId());
            }
            wrapperInfo.eq(UnifiedTaskInfo::getTaskId, (Object)unifiedTaskUser.getTaskId());
            unifiedTaskUser.setTodoId(((UnifiedTaskInfo)this.unifiedTaskInfoServiceImpl.getOne((Wrapper)wrapperInfo)).getTodoId());
            unifiedTaskUser.setExecuteStatus(ToolUtil.isNotEmpty((Object)unifiedTaskUser.getExecuteStatus()) ? unifiedTaskUser.getExecuteStatus() : "0");
        }
        this.unifiedTaskUserServiceImpl.saveBatch(unifiedTaskUsers);
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> deleteTaskUser(List<UnifiedTaskUser> unifiedTaskUsers) {
        for (UnifiedTaskUser unifiedTaskUser : unifiedTaskUsers) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            if (HussarUtils.isNotEmpty((Object)unifiedTaskUser.getSystemId())) {
                wrapper.eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskUser.getSystemId());
            }
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskUser.getTaskId())).eq(UnifiedTaskUser::getUserType, (Object)unifiedTaskUser.getUserType())).eq(HussarUtils.isNotEmpty((Object)unifiedTaskUser.getCcMoment()), UnifiedTaskUser::getCcMoment, (Object)unifiedTaskUser.getCcMoment());
            if (ToolUtil.isNotEmpty((Object)unifiedTaskUser.getUserId())) {
                wrapper.eq(UnifiedTaskUser::getUserId, (Object)unifiedTaskUser.getUserId());
            }
            if (HussarUtils.isNotEmpty((Object)unifiedTaskUser.getMandator())) {
                wrapper.eq(UnifiedTaskUser::getMandator, (Object)unifiedTaskUser.getMandator());
            } else if ("".equals(unifiedTaskUser.getMandator())) {
                wrapper.isNull(UnifiedTaskUser::getMandator);
            }
            this.unifiedTaskUserServiceImpl.remove((Wrapper)wrapper);
        }
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> updateTaskUser(String taskId, String systemId, String executeStatus, UpdateTaskUserToDoDto updateTaskUserToDoDto) {
        return this.updateTaskUser(taskId, systemId, executeStatus, updateTaskUserToDoDto.getExecutors(), updateTaskUserToDoDto.getFollowers());
    }

    public ApiResponse<String> transferTaskDeleteTaskUser(List<UnifiedTaskUser> unifiedTaskUsers) {
        for (UnifiedTaskUser unifiedTaskUser : unifiedTaskUsers) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            if (HussarUtils.isNotEmpty((Object)unifiedTaskUser.getSystemId())) {
                wrapper.eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskUser.getSystemId());
            }
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskUser.getTaskId())).eq(UnifiedTaskUser::getUserType, (Object)unifiedTaskUser.getUserType())).eq(UnifiedTaskUser::getTaskState, (Object)unifiedTaskUser.getTaskState());
            if (ToolUtil.isNotEmpty((Object)unifiedTaskUser.getUserId())) {
                wrapper.eq(UnifiedTaskUser::getUserId, (Object)unifiedTaskUser.getUserId());
            }
            this.unifiedTaskUserServiceImpl.remove((Wrapper)wrapper);
        }
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> transferUserTask(TransferTaskDto transferTaskDto) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        if (HussarUtils.isNotEmpty((Object)transferTaskDto.getSystemId())) {
            wrapper.eq(UnifiedTaskUser::getSystemId, (Object)transferTaskDto.getSystemId());
        }
        ((LambdaUpdateWrapper)wrapper.eq(UnifiedTaskUser::getTaskId, (Object)transferTaskDto.getTaskId())).eq(UnifiedTaskUser::getUserType, (Object)"1");
        List unifiedTaskUsers = this.unifiedTaskUserService.list((Wrapper)wrapper);
        if (HussarUtils.isNotEmpty((Object)unifiedTaskUsers)) {
            for (UnifiedTaskUser unifiedTaskUser : unifiedTaskUsers) {
                if ((!HussarUtils.isEmpty((Object)unifiedTaskUser.getMandator()) || !unifiedTaskUser.getUserId().equals(transferTaskDto.getConsignor())) && (!HussarUtils.isNotEmpty((Object)unifiedTaskUser.getMandator()) || !unifiedTaskUser.getMandator().equals(transferTaskDto.getConsignor()))) continue;
                unifiedTaskUser.setUserId(transferTaskDto.getUserId());
                unifiedTaskUser.setMandator(transferTaskDto.getConsignor());
                unifiedTaskUser.setTaskState("2");
                unifiedTaskUser.setUserName((String)transferTaskDto.getMap().get(transferTaskDto.getUserId()));
                unifiedTaskUser.setMandatorName((String)transferTaskDto.getMap().get(transferTaskDto.getConsignor()));
                this.unifiedTaskUserService.updateById((Object)unifiedTaskUser);
            }
        }
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> addUrgeTask(SaveToDoDto saveToDoDto) {
        LambdaUpdateWrapper wrapperInfo = new LambdaUpdateWrapper();
        if (HussarUtils.isAllEmpty((Object[])new Object[]{saveToDoDto.getTaskId(), saveToDoDto.getBusinessid(), saveToDoDto.getProcessInstanceid()})) {
            return ApiResponse.fail((String)"\u53c2\u6570\u4e0d\u53ef\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        if (HussarUtils.isNotEmpty((Object)saveToDoDto.getBusinessid())) {
            wrapperInfo.eq(UnifiedTaskInfo::getBusinessid, (Object)saveToDoDto.getBusinessid());
        }
        if (HussarUtils.isNotEmpty((Object)saveToDoDto.getProcessInstanceid())) {
            wrapperInfo.eq(UnifiedTaskInfo::getProcessInstanceid, (Object)saveToDoDto.getProcessInstanceid());
        }
        if (HussarUtils.isNotEmpty((Object)saveToDoDto.getSystemId())) {
            wrapperInfo.eq(UnifiedTaskInfo::getSystemId, (Object)saveToDoDto.getSystemId());
        }
        wrapperInfo.eq(UnifiedTaskInfo::getTaskStatus, (Object)"0");
        List taskInfoList = this.unifiedTaskInfoServiceImpl.list((Wrapper)wrapperInfo);
        wrapperInfo.set(UnifiedTaskInfo::getUrgeUserId, (Object)saveToDoDto.getUrgeUserId());
        if (HussarUtils.isNotEmpty((Object)saveToDoDto.getUrgeUserName())) {
            wrapperInfo.set(UnifiedTaskInfo::getUrgeUserName, (Object)saveToDoDto.getUrgeUserName());
        }
        this.unifiedTaskInfoServiceImpl.update((Wrapper)wrapperInfo);
        ArrayList<Long> todoIdList = new ArrayList<Long>();
        for (UnifiedTaskInfo unifiedTaskInfo : taskInfoList) {
            Long todoId = unifiedTaskInfo.getTodoId();
            todoIdList.add(todoId);
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        if (HussarUtils.isNotEmpty(todoIdList)) {
            wrapper.in(UnifiedTaskUser::getTodoId, todoIdList);
        }
        if (HussarUtils.isNotEmpty((Object)saveToDoDto.getSystemId())) {
            wrapper.eq(UnifiedTaskUser::getSystemId, (Object)saveToDoDto.getSystemId());
        }
        wrapper.eq(UnifiedTaskUser::getUserType, (Object)Character.valueOf('1'));
        ((LambdaUpdateWrapper)wrapper.set(UnifiedTaskUser::getUrgeStatus, (Object)Character.valueOf('1'))).set(UnifiedTaskUser::getUrgeTime, (Object)saveToDoDto.getUrgeTime());
        this.unifiedTaskUserServiceImpl.update((Wrapper)wrapper);
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> addStartProcess(SaveProcessDto saveProcessDto) {
        this.unifiedStartTaskServiceImpl.save((Object)saveProcessDto);
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> updateStartProcess(SaveProcessDto saveProcessDto) {
        try {
            String businessId = saveProcessDto.getBusinessId();
            String processInstanceId = saveProcessDto.getProcInstId();
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            if (HussarUtils.isNotEmpty((Object)businessId)) {
                wrapper.eq(UnifiedStartTask::getBusinessId, (Object)businessId);
            }
            if (HussarUtils.isNotEmpty((Object)processInstanceId)) {
                wrapper.eq(UnifiedStartTask::getProcInstId, (Object)processInstanceId);
            }
            wrapper.set(UnifiedStartTask::getEndTime, (Object)saveProcessDto.getEndTime());
            wrapper.set(UnifiedStartTask::getProcessState, (Object)saveProcessDto.getProcessState());
            if (HussarUtils.isNotEmpty((Object)saveProcessDto.getProcessTitle())) {
                wrapper.set(UnifiedStartTask::getProcessTitle, (Object)saveProcessDto.getProcessTitle());
            }
            if (HussarUtils.isNotEmpty((Object)saveProcessDto.getDataDetail())) {
                wrapper.set(UnifiedStartTask::getDataDetail, (Object)saveProcessDto.getDataDetail());
            }
            this.unifiedStartTaskServiceImpl.update((Wrapper)wrapper);
            return ApiResponse.success((Object)"", null);
        }
        catch (Exception e) {
            return ApiResponse.fail((String)"\u4fee\u6539\u6d41\u7a0b\u72b6\u6001\u5931\u8d25\uff01");
        }
    }

    public ApiResponse<String> deleteStartProcess(SaveProcessDto saveProcessDto) {
        try {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            if (HussarUtils.isNotEmpty((Object)saveProcessDto.getBusinessId())) {
                wrapper.eq(UnifiedStartTask::getBusinessId, (Object)saveProcessDto.getBusinessId());
            }
            if (HussarUtils.isNotEmpty((Object)saveProcessDto.getProcInstId())) {
                String processInstanceIds = saveProcessDto.getProcInstId();
                List<String> processInstanceIdList = Arrays.asList(processInstanceIds.split(","));
                wrapper.in(UnifiedStartTask::getProcInstId, processInstanceIdList);
            }
            this.unifiedStartTaskServiceImpl.remove((Wrapper)wrapper);
            return ApiResponse.success((Object)"", null);
        }
        catch (Exception e) {
            return ApiResponse.fail((String)"\u5220\u9664\u6d41\u7a0b\u5931\u8d25\uff01");
        }
    }

    public ApiResponse<String> updateBusinessInfo(SaveToDoDto saveToDoDto) {
        try {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            if (HussarUtils.isNotEmpty((Object)saveToDoDto.getProcessInstanceid())) {
                wrapper.eq(UnifiedTaskInfo::getProcessInstanceid, (Object)saveToDoDto.getProcessInstanceid());
            }
            if (HussarUtils.isNotEmpty((Object)saveToDoDto.getBusinessid())) {
                wrapper.eq(UnifiedTaskInfo::getBusinessid, (Object)saveToDoDto.getBusinessid());
            }
            if (HussarUtils.isNotEmpty((Object)saveToDoDto.getProcessTitle())) {
                wrapper.set(UnifiedTaskInfo::getProcessTitle, (Object)saveToDoDto.getProcessTitle());
            }
            if (HussarUtils.isNotEmpty((Object)saveToDoDto.getDataDetail())) {
                wrapper.set(UnifiedTaskInfo::getDataDetail, (Object)saveToDoDto.getDataDetail());
            }
            this.unifiedTaskInfoServiceImpl.update((Wrapper)wrapper);
            return ApiResponse.success((Object)"", null);
        }
        catch (Exception e) {
            return ApiResponse.fail((String)"\u66f4\u65b0\u5931\u8d25\uff01");
        }
    }
}

