/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unifiedtodo.intercept;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedSystemInfo;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedSystemInfoService;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class UnifiedToDoRequestInterceptor
implements HandlerInterceptor {
    @Autowired
    private IUnifiedSystemInfoService unifiedSystemInfoServiceImpl;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String systemIdKey = "systemId";
        String systemCipherKey = "systemCipher";
        String systemId = request.getHeader(systemIdKey);
        String systemCipher = request.getHeader(systemCipherKey);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(UnifiedSystemInfo::getSystemId, (Object)Long.parseLong(systemId))).eq(UnifiedSystemInfo::getSystemCipher, (Object)systemCipher);
        if (this.unifiedSystemInfoServiceImpl.getOne((Wrapper)wrapper) != null) {
            return true;
        }
        this.writeResponse((ServletResponse)response, this.errorResponse(ResultCode.REQ_REJECT.getCode(), ResultCode.UN_AUTHORIZED.getMessage()));
        return false;
    }

    private Map<String, Object> errorResponse(int code, String msg) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("code", code);
        resultMap.put("msg", msg);
        return resultMap;
    }

    private void writeResponse(ServletResponse response, Map<String, Object> resultMap) throws IOException {
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        PrintWriter out = response.getWriter();
        out.println(JSON.toJSONString(resultMap));
        out.flush();
        out.close();
    }
}

