/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unifiedtodo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.unifiedtodo.constant.UnifiedtodoExceptionEnum;
import com.jxdinfo.hussar.unifiedtodo.dao.UnifiedSystemInfoMapper;
import com.jxdinfo.hussar.unifiedtodo.dao.UnifiedTaskInfoMapper;
import com.jxdinfo.hussar.unifiedtodo.dao.UnifiedTaskUserMapper;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedSystemInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskUser;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedSystemInfoService;
import com.jxdinfo.hussar.unifiedtodo.vo.SystemInfoVo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class UnifiedSystemInfoServiceImpl
extends HussarServiceImpl<UnifiedSystemInfoMapper, UnifiedSystemInfo>
implements IUnifiedSystemInfoService {
    @Resource
    UnifiedSystemInfoMapper unifiedSystemInfoMapper;
    @Resource
    UnifiedTaskInfoMapper unifiedTaskInfoMapper;
    @Resource
    UnifiedTaskUserMapper unifiedTaskUserMapper;

    public ApiResponse<Page<UnifiedSystemInfo>> list(Page<UnifiedSystemInfo> page, String systemName) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)systemName)) {
            wrapper.like(UnifiedSystemInfo::getSystemName, (Object)systemName);
        }
        return ApiResponse.success((Object)this.unifiedSystemInfoMapper.selectPage((IPage)page, (Wrapper)wrapper));
    }

    public ApiResponse<String> saveSystem(UnifiedSystemInfo systemInfo) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(UnifiedSystemInfo::getSystemName, (Object)systemInfo.getSystemName());
        if (this.unifiedSystemInfoMapper.selectOne((Wrapper)wrapper) != null) {
            return ApiResponse.fail((String)UnifiedtodoExceptionEnum.UNIFIEDTODO_ADD_FAILED.getMessage());
        }
        systemInfo.setSystemCipher(IdWorker.get32UUID());
        systemInfo.setCreateTime(new Date());
        int insert = this.unifiedSystemInfoMapper.insert(systemInfo);
        if (insert != 1) {
            return ApiResponse.fail((String)UnifiedtodoExceptionEnum.UNIFIEDTODO_APPLICATION_REGISTRATION_FAILED.getMessage());
        }
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> update(UnifiedSystemInfo unifiedSystemInfo) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(UnifiedSystemInfo::getSystemName, (Object)unifiedSystemInfo.getSystemName())).ne(UnifiedSystemInfo::getSystemId, (Object)unifiedSystemInfo.getSystemId());
        UnifiedSystemInfo unifiedSystem = (UnifiedSystemInfo)this.unifiedSystemInfoMapper.selectOne((Wrapper)wrapper);
        if (unifiedSystem != null) {
            return ApiResponse.fail((String)UnifiedtodoExceptionEnum.UNIFIEDTODO_ADD_FAILED.getMessage());
        }
        int update = this.unifiedSystemInfoMapper.updateById(unifiedSystemInfo);
        if (update != 1) {
            return ApiResponse.fail((String)UnifiedtodoExceptionEnum.UNIFIEDTODO_APPLICATION_MODIFICATION_FAILED.getMessage());
        }
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<UnifiedSystemInfo> detail(String systemId) {
        UnifiedSystemInfo systemInfo = (UnifiedSystemInfo)this.unifiedSystemInfoMapper.selectById(Long.valueOf(Long.parseLong(systemId)));
        if (systemInfo == null) {
            return ApiResponse.fail((String)UnifiedtodoExceptionEnum.UNIFIEDTODO_APPLICATION_DETAILS_GET_FAILED.getMessage());
        }
        return ApiResponse.success((Object)systemInfo);
    }

    public ApiResponse<String> resetCipher(Long systemId) {
        UnifiedSystemInfo systemInfo = (UnifiedSystemInfo)this.unifiedSystemInfoMapper.selectById(systemId);
        systemInfo.setSystemCipher(IdWorker.get32UUID());
        int update = this.unifiedSystemInfoMapper.updateById(systemInfo);
        if (update != 1) {
            return ApiResponse.fail((String)UnifiedtodoExceptionEnum.UNIFIEDTODO_RESET_KEY_FAILED.getMessage());
        }
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> resetCipher(String systemId) {
        return this.resetCipher(Long.parseLong(systemId));
    }

    public ApiResponse<String> delete(String systemId) {
        LambdaQueryWrapper taskWrapper = new LambdaQueryWrapper();
        taskWrapper.eq(UnifiedTaskInfo::getSystemId, (Object)Long.parseLong(systemId));
        this.unifiedTaskInfoMapper.delete((Wrapper)taskWrapper);
        LambdaQueryWrapper userMapper = new LambdaQueryWrapper();
        userMapper.eq(UnifiedTaskUser::getSystemId, (Object)Long.parseLong(systemId));
        this.unifiedTaskUserMapper.delete((Wrapper)userMapper);
        int delete = this.unifiedSystemInfoMapper.deleteById(Long.valueOf(Long.parseLong(systemId)));
        if (delete != 1) {
            return ApiResponse.fail((String)UnifiedtodoExceptionEnum.UNIFIEDTODO_APPLICATION_DELETE_FAILED.getMessage());
        }
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<List<Map<String, Object>>> querySystemNameList() {
        List<SystemInfoVo> systemInfoVos = this.unifiedSystemInfoMapper.querySystemName();
        ArrayList systemInfoMapList = new ArrayList();
        for (SystemInfoVo systemInfoVo : systemInfoVos) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("systemId", systemInfoVo.getSystemId());
            map.put("systemName", systemInfoVo.getSystemName());
            systemInfoMapList.add(map);
        }
        return ApiResponse.success(systemInfoMapList);
    }
}

