/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unifiedtodo.utils;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import java.util.HashMap;
import java.util.Map;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.ExchangeBuilder;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;

public class UnifiedRabbitMQUtil {
    private static final AmqpAdmin amqpAdmin = (AmqpAdmin)SpringContextHolder.getBean(AmqpAdmin.class);
    private static final RabbitTemplate rabbitTemplate = (RabbitTemplate)SpringContextHolder.getBean(RabbitTemplate.class);
    private static final String ROUTING_KEY = "IntelligentAssistantQueue";
    private static final String DIRECT_EXCHANGE = "bpmDirectExchange";

    public static void bindQueueToExchange() {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("x-queue-type", "classic");
        Queue queue = new Queue(ROUTING_KEY, true, false, false, arguments);
        amqpAdmin.declareQueue(queue);
        Binding bindingBuilder = BindingBuilder.bind((Queue)queue).to(UnifiedRabbitMQUtil.direct()).with(ROUTING_KEY);
        amqpAdmin.declareBinding(bindingBuilder);
    }

    private static DirectExchange direct() {
        return (DirectExchange)ExchangeBuilder.directExchange((String)DIRECT_EXCHANGE).durable(true).build();
    }

    public static void send(Map<String, Object> map) {
        UnifiedRabbitMQUtil.bindQueueToExchange();
        rabbitTemplate.setMessageConverter((MessageConverter)new Jackson2JsonMessageConverter());
        rabbitTemplate.convertAndSend(DIRECT_EXCHANGE, ROUTING_KEY, map);
    }
}

