/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unifiedtodo.service.impl;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskInfoService;
import com.jxdinfo.hussar.unifiedtodo.utils.UnifiedRabbitMQUtil;
import com.jxdinfo.hussar.unifiedtodo.vo.UnifiedTaskPushVo;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class MessageCenterPushJob
implements BasicProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MessageCenterPushJob.class);
    private final IUnifiedTaskInfoService unifiedTaskInfoService = (IUnifiedTaskInfoService)SpringContextHolder.getBean(IUnifiedTaskInfoService.class);
    @Value(value="${hussar.approval-center-pc}")
    String approvalCenterPc;
    @Value(value="${hussar.approval-center-mobile}")
    String approvalCenterMobile;

    public ProcessResult process(TaskContext taskContext) throws Exception {
        logger.info("\u6bcf\u65e5\u63d0\u9192\u63a8\u9001\u5f00\u59cb");
        try {
            List numByUserId = this.unifiedTaskInfoService.getNumByUserId();
            logger.info("\u6bcf\u65e5\u63d0\u9192\u63a8\u9001\u5171{}\u6761", (Object)numByUserId.size());
            for (UnifiedTaskPushVo unifiedTaskPushVo : numByUserId) {
                HashMap<String, Object> pushParam = new HashMap<String, Object>(8);
                pushParam.put("title", "\u6bcf\u65e5\u9700\u5ba1\u63d0\u9192");
                pushParam.put("content", "\u60a8\u6709" + unifiedTaskPushVo.getNum() + "\u6761\u5ba1\u6279\u9700\u8981\u5904\u7406\uff0c\u8bf7\u53ca\u65f6\u5ba1\u6279\u3002");
                pushParam.put("actions", "\u67e5\u770b\u8be6\u60c5");
                pushParam.put("urlMobile", this.approvalCenterMobile + "#/unifiedtodoToDoTask");
                pushParam.put("urlPc", this.approvalCenterPc + "#/external/unifiedtodoToBeReviewedTask?auth_token=[pm_token]&isPortal=0&appflag=xs");
                pushParam.put("userAccountNew", unifiedTaskPushVo.getUserAccount());
                pushParam.put("assistantId", "0028100");
                UnifiedRabbitMQUtil.send(pushParam);
                logger.info("\u8d26\u53f7{}\u6bcf\u65e5\u63d0\u9192\u63a8\u9001\u6210\u529f", (Object)unifiedTaskPushVo.getUserAccount());
            }
            logger.info("\u6bcf\u65e5\u63d0\u9192\u63a8\u9001\u7ed3\u675f");
            return new ProcessResult(true, "success");
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return new ProcessResult(false, e.getMessage());
        }
    }
}

