/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unifiedtodo.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.unifiedtodo.dao.UnifiedExpiredMapper;
import com.jxdinfo.hussar.unifiedtodo.dto.ExpireAllListDto;
import com.jxdinfo.hussar.unifiedtodo.dto.ExpireListDto;
import com.jxdinfo.hussar.unifiedtodo.dto.QueryExpireAllListDto;
import com.jxdinfo.hussar.unifiedtodo.dto.QueryExpireListDto;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedExpiredQueryService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnifiedExpiredQueryServiceImpl
implements IUnifiedExpiredQueryService {
    @Autowired
    private UnifiedExpiredMapper unifiedExpiredMapper;

    public ApiResponse<Page<ExpireAllListDto>> queryExpireAllList(Page<ExpireAllListDto> page, QueryExpireAllListDto queryExpireAllListDto) {
        queryExpireAllListDto.setNowTime(LocalDateTime.now());
        return ApiResponse.success(this.unifiedExpiredMapper.queryExpireAllList(page, queryExpireAllListDto));
    }

    public ApiResponse<Page<ExpireListDto>> queryExpireList(Page<ExpireListDto> page, QueryExpireListDto queryExpireListDto) {
        queryExpireListDto.setNowTime(LocalDateTime.now());
        Page<ExpireListDto> expireListDtoPage = this.unifiedExpiredMapper.queryExpireList(page, queryExpireListDto);
        expireListDtoPage.getRecords().forEach(expireListDto -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("0", "\u6b63\u5e38\u5ba1\u6279");
            map.put("1", "\u5ba1\u6279\u901a\u8fc7");
            map.put("2", "\u5ba1\u6279\u672a\u901a\u8fc7");
            map.put("3", "\u8fd4\u56de\u6574\u6539");
            map.put("4", "\u5f3a\u884c\u7ec8\u6b62");
            map.put("5", "\u5f52\u6863");
            map.put("6", "\u505c\u6b62\u5ba1\u6279");
            map.put("7", "\u4f5c\u5e9f");
            map.put("8", "\u5ba1\u6279\u8d85\u671f");
            map.put("?", "\u672a\u77e5\u539f\u56e0\u7ed3\u675f");
            expireListDto.setProcessStateName((String)map.get(expireListDto.getProcessState()));
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            LocalDateTime createTime = expireListDto.getCreateTime();
            LocalDateTime time = LocalDateTime.now();
            LocalDateTime deadLine = expireListDto.getDeadLine();
            Long dayDif = ChronoUnit.DAYS.between(createTime, deadLine);
            dayDif = ChronoUnit.MILLIS.between(createTime, deadLine) % 24L * 60L * 60L > 0L ? dayDif + 1L : dayDif;
            expireListDto.setDayDif(dayDif.toString());
            if (expireListDto.getCompleteTime() == null) {
                Long hourDiff = ChronoUnit.HOURS.between(deadLine, time);
                hourDiff = ChronoUnit.MINUTES.between(deadLine, time) % 60L > 0L || ChronoUnit.MILLIS.between(deadLine, time) % 60L > 0L ? hourDiff + 1L : hourDiff;
                expireListDto.setHourDif(hourDiff.toString());
            } else {
                LocalDateTime completeTime = expireListDto.getCompleteTime();
                Long hourDiff = ChronoUnit.HOURS.between(deadLine, completeTime);
                hourDiff = ChronoUnit.MINUTES.between(deadLine, completeTime) % 60L > 0L || ChronoUnit.MILLIS.between(deadLine, time) % 60L > 0L ? hourDiff + 1L : hourDiff;
                expireListDto.setHourDif(hourDiff.toString());
            }
        });
        return ApiResponse.success(expireListDtoPage);
    }
}

