/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unifiedtodo.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.NumberUtil;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.audit.core.support.dto.AuditLogModel;
import com.jxdinfo.hussar.support.audit.core.util.AuditLogUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.unifiedtodo.config.UnifiedTodoGLDProperties;
import com.jxdinfo.hussar.unifiedtodo.config.UnifiedTodoProperties;
import com.jxdinfo.hussar.unifiedtodo.constant.ProcessState;
import com.jxdinfo.hussar.unifiedtodo.constant.UnifiedConstants;
import com.jxdinfo.hussar.unifiedtodo.dao.UnifiedToDoMapper;
import com.jxdinfo.hussar.unifiedtodo.dto.TaskNumber;
import com.jxdinfo.hussar.unifiedtodo.dto.UnifiedDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UnifiedParamDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UnifiedTaskQueryDto;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedDeleteProcessInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedDoneTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedPendingTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedProcessInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedReadedTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskUser;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTodoTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedUnReadTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.response.UnifiedResponse;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedDeleteProcessInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedDoneTaskInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedPendingTaskInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedProcessInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedProcessRectificationService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedReadedTaskInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskUserService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTodoTaskInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedUnReadTaskInfoService;
import com.jxdinfo.hussar.unifiedtodo.utils.HttpClientUtil;
import com.jxdinfo.hussar.unifiedtodo.vo.UnifiedTaskQueryVo;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTransactional
public class UnifiedServiceImpl
implements IUnifiedService {
    @Resource
    private ISysDicRefService sysDicRefService;
    @Autowired
    private IUnifiedTaskInfoService unifiedTaskInfoService;
    @Autowired
    private IUnifiedTaskUserService unifiedTaskUserService;
    @Autowired
    private IUnifiedProcessInfoService unifiedProcessInfoService;
    @Autowired
    private IUnifiedProcessRectificationService unifiedProcessRectificationService;
    @Autowired
    private IUnifiedTodoTaskInfoService unifiedTodoTaskInfoService;
    @Autowired
    private IUnifiedUnReadTaskInfoService unifiedUnReadTaskInfoService;
    @Autowired
    private IUnifiedPendingTaskInfoService unifiedPendingTaskInfoService;
    @Autowired
    private IUnifiedDoneTaskInfoService unifiedDoneTaskInfoService;
    @Autowired
    IUnifiedReadedTaskInfoService unifiedReadedTaskInfoService;
    @Resource
    private UnifiedToDoMapper unifiedToDoMapper;
    @Resource
    private IUnifiedTodoTaskInfoService iUnifiedTodoTaskInfoService;
    @Resource
    private IUnifiedDoneTaskInfoService iUnifiedDoneTaskInfoService;
    @Resource
    private IUnifiedPendingTaskInfoService iUnifiedPendingTaskInfoService;
    @Resource
    private IUnifiedUnReadTaskInfoService iUnifiedUnReadTaskInfoService;
    @Resource
    private IUnifiedReadedTaskInfoService iUnifiedReadedTaskInfoService;
    @Resource
    private IUnifiedDeleteProcessInfoService iUnifiedDeleteProcessInfoService;
    @Resource
    private ISysUsersService usersService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private UnifiedTodoProperties unifiedTodoProperties;
    @Resource
    private UnifiedTodoGLDProperties unifiedTodoGLDProperties;
    @Resource
    private ISysDicRefService iSysDicRefService;
    private static final Logger logger = LoggerFactory.getLogger(UnifiedServiceImpl.class);
    private static final String MODULE_NAME = "OA-\u6570\u636e\u63a8\u9001";
    private final Consumer<UnifiedParamDto> update = unifiedParamDto -> {
        long deleteStart;
        long end;
        long start;
        logger.info("\u66f4\u65b0\u7684\u6570\u636e\u5185\u5bb9\uff1a" + JSON.toJSONString((Object)unifiedParamDto));
        UnifiedProcessInfo unifiedProcessInfo = unifiedParamDto.buildProcessInfo();
        UnifiedTaskInfo unifiedTaskInfo = unifiedParamDto.buildTaskInfo();
        UnifiedTaskUser unifiedTaskUser = unifiedParamDto.buildUserInfo();
        if (HussarUtils.isAllEmpty((Object[])new Object[]{unifiedProcessInfo, unifiedTaskInfo, unifiedTaskUser})) {
            return;
        }
        if (unifiedProcessInfo != null) {
            start = System.currentTimeMillis();
            logger.info("\u66f4\u65b0\u6d41\u7a0b\u4fe1\u606f\u5f00\u59cb\uff1a" + start);
            List processInfos = this.unifiedProcessInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getSystemId, (Object)unifiedProcessInfo.getSystemId())).eq(UnifiedProcessInfo::getProcInstId, (Object)unifiedProcessInfo.getProcInstId()));
            if (HussarUtils.isNotEmpty((Object)processInfos)) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.unifiedProcessInfoService.lambdaUpdate().eq(UnifiedProcessInfo::getSystemId, (Object)unifiedProcessInfo.getSystemId())).eq(UnifiedProcessInfo::getProcInstId, (Object)unifiedProcessInfo.getProcInstId())).update((Object)unifiedProcessInfo);
                ArrayList<UnifiedProcessInfo> unifiedProcessInfos = new ArrayList<UnifiedProcessInfo>();
                unifiedProcessInfos.add(unifiedProcessInfo);
                this.updateTaskInfo(unifiedProcessInfos);
            } else {
                long deleteStart2 = System.currentTimeMillis();
                logger.info("\u5386\u53f2\u4efb\u52a1\u65b0\u589e\u3001\u5220\u9664\u5f00\u59cb\uff1a" + deleteStart2);
                this.unifiedProcessInfoService.save((Object)unifiedProcessInfo);
                if (!HussarUtils.isNull((Object)unifiedProcessInfo.getStartTime())) {
                    String year = DateUtil.getYear((Date)unifiedProcessInfo.getStartTime());
                    String tableName = UnifiedConstants.HISTORY_TABLE_PROCESS_PREFIX + year;
                    if (HussarUtils.isNotEmpty((Object)unifiedProcessInfo.getProcInstId()) && this.checkTableExist(tableName)) {
                        this.unifiedToDoMapper.deleteProcess(Integer.valueOf(year), unifiedProcessInfo.getProcInstId(), unifiedProcessInfo.getSystemId());
                    }
                }
                long deleteEnd = System.currentTimeMillis();
                logger.info("\u5386\u53f2\u4efb\u52a1\u65b0\u589e\u3001\u5220\u9664\u7ed3\u675f\uff1a" + deleteEnd);
            }
            end = System.currentTimeMillis();
            logger.info("\u66f4\u65b0\u6d41\u7a0b\u4fe1\u606f\u5f00\u59cb\uff1a" + end);
            logger.info("\u66f4\u65b0\u6d41\u7a0b\u4fe1\u606f\u603b\u65f6\u95f4\uff1a" + (end - start));
        }
        if (unifiedTaskInfo != null) {
            start = System.currentTimeMillis();
            logger.info("\u66f4\u65b0\u4efb\u52a1\u4fe1\u606f\u5f00\u59cb\uff1a" + start);
            List taskInfos = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getSystemId, (Object)unifiedTaskInfo.getSystemId())).eq(UnifiedTaskInfo::getTaskId, (Object)unifiedTaskInfo.getTaskId()));
            if (HussarUtils.isNotEmpty((Object)taskInfos)) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.unifiedTaskInfoService.lambdaUpdate().eq(UnifiedTaskInfo::getSystemId, (Object)unifiedTaskUser.getSystemId())).eq(UnifiedTaskInfo::getTaskId, (Object)unifiedTaskInfo.getTaskId())).update((Object)unifiedTaskInfo);
            } else {
                deleteStart = System.currentTimeMillis();
                logger.info("\u5386\u53f2\u6d41\u7a0b\u65b0\u589e\u3001\u5220\u9664\u5f00\u59cb\uff1a" + deleteStart);
                this.unifiedTaskInfoService.save((Object)unifiedTaskInfo);
                List processInfos = this.unifiedProcessInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getSystemId, (Object)unifiedTaskInfo.getSystemId())).eq(UnifiedProcessInfo::getProcInstId, (Object)unifiedTaskInfo.getProcessInstanceid()));
                this.updateTaskInfo(processInfos);
                if (HussarUtils.isNotEmpty((Object)processInfos)) {
                    UnifiedProcessInfo processInfo = (UnifiedProcessInfo)processInfos.get(0);
                    String year = DateUtil.getYear((Date)processInfo.getStartTime());
                    String tableName = UnifiedConstants.HISTORY_TABLE_TASK_PREFIX + year;
                    if (HussarUtils.isNotEmpty((Object)year) && this.checkTableExist(tableName)) {
                        this.unifiedToDoMapper.deleteTask(Integer.valueOf(year), unifiedTaskInfo.getTaskId(), unifiedTaskInfo.getSystemId());
                    }
                }
                long deleteEnd = System.currentTimeMillis();
                logger.info("\u5386\u53f2\u6d41\u7a0b\u65b0\u589e\u3001\u5220\u9664\u7ed3\u675f\uff1a" + deleteEnd);
            }
            end = System.currentTimeMillis();
            logger.info("\u66f4\u65b0\u4efb\u52a1\u4fe1\u606f\u7ed3\u675f\uff1a" + end);
            logger.info("\u66f4\u65b0\u6d41\u7a0b\u4fe1\u606f\u603b\u65f6\u95f4\uff1a" + (end - start));
        }
        if (unifiedTaskUser != null) {
            start = System.currentTimeMillis();
            logger.info("\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u5f00\u59cb\uff1a" + start);
            List unifiedTaskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskUser.getSystemId())).eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskUser.getTaskId()));
            if (HussarUtils.isNotEmpty((Object)unifiedTaskUsers)) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.unifiedTaskUserService.lambdaUpdate().eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskUser.getSystemId())).eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskUser.getTaskId())).update((Object)unifiedTaskUser);
            } else {
                List processInfos;
                deleteStart = System.currentTimeMillis();
                logger.info("\u5386\u53f2\u7528\u6237\u4fe1\u606f\u65b0\u589e\u3001\u5220\u9664\u5f00\u59cb\uff1a" + deleteStart);
                this.unifiedTaskUserService.save((Object)unifiedTaskUser);
                UnifiedTaskInfo taskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getSystemId, (Object)unifiedTaskUser.getSystemId())).eq(UnifiedTaskInfo::getTaskId, (Object)unifiedTaskUser.getTaskId()));
                if (!HussarUtils.isNull((Object)taskInfo) && HussarUtils.isNotEmpty((Object)(processInfos = this.unifiedProcessInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getSystemId, (Object)taskInfo.getSystemId())).eq(UnifiedProcessInfo::getProcInstId, (Object)taskInfo.getProcessInstanceid()))))) {
                    UnifiedProcessInfo processInfo = (UnifiedProcessInfo)processInfos.get(0);
                    String year = DateUtil.getYear((Date)processInfo.getStartTime());
                    String tableName = UnifiedConstants.HISTORY_TABLE_TASK_USER_PREFIX + year;
                    if (HussarUtils.isNotEmpty((Object)year) && this.checkTableExist(tableName)) {
                        this.unifiedToDoMapper.deleteTaskUser(Integer.valueOf(year), unifiedTaskUser.getTaskId(), unifiedTaskUser.getSystemId());
                    }
                }
                long deleteEnd = System.currentTimeMillis();
                logger.info("\u5386\u53f2\u7528\u6237\u4fe1\u606f\u65b0\u589e\u3001\u5220\u9664\u7ed3\u675f\uff1a" + deleteEnd);
            }
            this.updateTaskUsers(unifiedTaskUser);
            end = System.currentTimeMillis();
            logger.info("\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u7ed3\u675f\uff1a" + end);
            logger.info("\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u603b\u65f6\u95f4\uff1a" + (end - start));
        }
    };

    public UnifiedResponse unifiedPush(UnifiedDto unifiedDto, Long systemId) {
        long start = System.currentTimeMillis();
        logger.info("\u63a5\u6536\u63a8\u9001\u6570\u636e\u5f00\u59cb\uff1a" + start);
        if (systemId == null) {
            return UnifiedResponse.paramFail();
        }
        ArrayList<UnifiedParamDto> add = new ArrayList<UnifiedParamDto>();
        ArrayList<UnifiedParamDto> update = new ArrayList<UnifiedParamDto>();
        ArrayList<UnifiedParamDto> delete = new ArrayList<UnifiedParamDto>();
        for (UnifiedParamDto unifiedParamDto : unifiedDto.getDataList()) {
            unifiedParamDto.systemId(systemId);
            if (UnifiedParamDto.optTypeEnum.ADD.strCode.equals(unifiedParamDto.getOptType())) {
                add.add(unifiedParamDto);
                continue;
            }
            if (UnifiedParamDto.optTypeEnum.UPDATE.strCode.equals(unifiedParamDto.getOptType())) {
                update.add(unifiedParamDto);
                continue;
            }
            if (UnifiedParamDto.optTypeEnum.DELETE.strCode.equals(unifiedParamDto.getOptType())) {
                delete.add(unifiedParamDto);
                continue;
            }
            return UnifiedResponse.paramFail();
        }
        this.addUnified(add);
        this.updateUnified(update);
        this.deleteUnified(delete, systemId);
        if (this.unifiedTodoGLDProperties.isOpen()) {
            this.pushToGld(add, update, systemId.toString());
        }
        if (this.unifiedTodoProperties.getOpen()) {
            this.pushToOa(add, update, systemId.toString());
        }
        long end = System.currentTimeMillis();
        logger.info("\u63a5\u6536\u63a8\u9001\u6570\u636e\u7ed3\u675f\uff1a" + end);
        logger.info("\u63a5\u6536\u63a8\u9001\u603b\u65f6\u95f4\uff1a" + (end - start));
        return UnifiedResponse.success();
    }

    private void pushToGld(List<UnifiedParamDto> add, List<UnifiedParamDto> update, String systemId) {
        block20: {
            SimpleDateFormat sf;
            ArrayList<UnifiedTaskUser> taskUserList;
            block19: {
                JSONObject jsonObject;
                String resp;
                Iterator resultData;
                HashMap<String, Object> data;
                ArrayList resultList;
                HashMap<String, String> headers;
                ArrayList<UnifiedParamDto> pushList = new ArrayList<UnifiedParamDto>();
                if (HussarUtils.isNotEmpty(update)) {
                    pushList.addAll(update);
                }
                if (HussarUtils.isNotEmpty(add)) {
                    pushList.addAll(add);
                }
                if (HussarUtils.isEmpty(pushList)) {
                    return;
                }
                ArrayList<UnifiedProcessInfo> processInfoList = new ArrayList<UnifiedProcessInfo>();
                ArrayList<UnifiedTaskInfo> taskInfoList = new ArrayList<UnifiedTaskInfo>();
                taskUserList = new ArrayList<UnifiedTaskUser>();
                for (UnifiedParamDto dto : pushList) {
                    UnifiedProcessInfo processInfo = dto.buildProcessInfo();
                    UnifiedTaskInfo taskInfo = dto.buildTaskInfo();
                    UnifiedTaskUser taskUser = dto.buildUserInfo();
                    if (!HussarUtils.isNull((Object)processInfo)) {
                        processInfoList.add(processInfo);
                    }
                    if (!HussarUtils.isNull((Object)taskInfo)) {
                        taskInfoList.add(taskInfo);
                    }
                    if (HussarUtils.isNull((Object)taskUser)) continue;
                    taskUserList.add(taskUser);
                }
                sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                if (HussarUtils.isNotEmpty(processInfoList)) {
                    headers = new HashMap<String, String>();
                    headers.put("Authorization", "Basic ZDE5Njc4YTQ4YjczZDdhOTM4NTdmNTZiMDA2NTAyZTg6NmRkZmI4ZGEzNw==");
                    for (UnifiedProcessInfo processInfo : processInfoList) {
                        resultList = new ArrayList();
                        data = new HashMap<String, Object>();
                        data.put("id", processInfo.getProcInstId());
                        data.put("approvalStatus", Integer.valueOf(this.getProcessStatus(processInfo.getProcessState())));
                        data.put("deleted", "false");
                        if (this.getProcessStatus(processInfo.getProcessState()).equals(ProcessState.RUNNING.getValue())) {
                            SysUsers sysUsers = this.usersService.getUserByOutOriginId(processInfo.getStartUserId());
                            if (!HussarUtils.isNull((Object)sysUsers)) {
                                String outOriginId = this.sysStruService.getByStruId(String.valueOf(sysUsers.getDepartmentId()));
                                data.put("promoterId", sysUsers.getOutOriginId());
                                data.put("projectId", HussarUtils.isNull((Object)outOriginId) ? "" : this.getOaProjectId(outOriginId));
                            } else {
                                data.put("promoterId", "");
                                data.put("projectId", "");
                            }
                            data.put("projectName", processInfo.getDeptName());
                            data.put("flowName", processInfo.getProcessName());
                            data.put("promoterNo", processInfo.getStartUserNumber());
                            data.put("promoterName", processInfo.getStartUserName());
                            data.put("promotionTime", HussarUtils.isNotEmpty((Object)processInfo.getStartTime()) ? sf.format(processInfo.getStartTime()) : "");
                        }
                        resultList.add(data);
                        resultData = JSON.toJSONString(resultList);
                        logger.info("requestParamJsonToGLD:" + (String)((Object)resultData));
                        resp = HttpClientUtil.httpPost(this.unifiedTodoGLDProperties.getApproveRecord(), (String)((Object)resultData), headers);
                        logger.info("responseParamToGLD:" + resp);
                        jsonObject = JSON.parseObject((String)resp);
                        if (!HussarUtils.isNotEmpty((Object)jsonObject.get((Object)"returnCode")) || String.valueOf(jsonObject.get((Object)"returnCode")).equals("0")) continue;
                        logger.info("\u63a8\u9001\u6d41\u7a0b\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a " + jsonObject.get((Object)"errorString"));
                    }
                }
                if (!HussarUtils.isNotEmpty(taskInfoList)) break block19;
                headers = new HashMap();
                headers.put("Authorization", "Basic ZDE5Njc4YTQ4YjczZDdhOTM4NTdmNTZiMDA2NTAyZTg6NmRkZmI4ZGEzNw==");
                for (UnifiedTaskInfo taskInfo : taskInfoList) {
                    resultList = new ArrayList();
                    data = new HashMap();
                    if ("1".equals(taskInfo.getTaskStatus())) {
                        data.put("flowId", taskInfo.getProcessInstanceid());
                        data.put("id", taskInfo.getTaskId());
                        data.put("name", taskInfo.getTaskName());
                        data.put("deadlineTime", !HussarUtils.isNull((Object)taskInfo.getDeadLine()) ? sf.format(taskInfo.getDeadLine()) : "");
                        data.put("approvalStatus", Integer.valueOf("1"));
                        data.put("approveTime", "");
                        data.put("deleted", "false");
                        data.put("jumpUrl", this.getJumpUrl("1", taskInfo.getTaskId()));
                        if (HussarUtils.isNotEmpty(taskUserList)) {
                            for (UnifiedTaskUser unifiedTaskUser : taskUserList) {
                                if (!unifiedTaskUser.getTaskId().equals(taskInfo.getTaskId())) continue;
                                SysUsers sysUsers = this.usersService.getUserByOutOriginId(unifiedTaskUser.getUserId());
                                data.put("promoterId", HussarUtils.isNull((Object)sysUsers) ? "" : sysUsers.getOutOriginId());
                                data.put("promoterNo", unifiedTaskUser.getUserNumber());
                                data.put("promoterName", unifiedTaskUser.getUserName());
                                data.put("deptName", unifiedTaskUser.getDeptName());
                                data.put("postName", unifiedTaskUser.getPostName());
                            }
                        }
                    } else {
                        if (!"3".equals(taskInfo.getTaskStatus())) continue;
                        data.put("flowId", taskInfo.getProcessInstanceid());
                        data.put("id", taskInfo.getTaskId());
                        data.put("approveTime", "");
                        data.put("approvalStatus", "2");
                        data.put("deleted", "false");
                        data.put("jumpUrl", this.getJumpUrl("3", taskInfo.getProcessInstanceid()));
                        if (HussarUtils.isNotEmpty(taskUserList)) {
                            for (UnifiedTaskUser unifiedTaskUser : taskUserList) {
                                if (!unifiedTaskUser.getTaskId().equals(taskInfo.getTaskId())) continue;
                                data.put("approveTime", !HussarUtils.isNull((Object)unifiedTaskUser.getCompleteTime()) ? sf.format(unifiedTaskUser.getCompleteTime()) : "");
                            }
                        }
                    }
                    resultList.add(data);
                    resultData = JSON.toJSONString(resultList);
                    logger.info("requestParamJsonToGLD:" + resultData);
                    resp = HttpClientUtil.httpPost(this.unifiedTodoGLDProperties.getApproveNode(), resultData, headers);
                    logger.info("responseParamToGLD:" + resp);
                    jsonObject = JSON.parseObject((String)resp);
                    if (!HussarUtils.isNotEmpty((Object)jsonObject.get((Object)"returnCode")) || String.valueOf(jsonObject.get((Object)"returnCode")).equals("0")) continue;
                    logger.info("\u63a8\u9001\u8282\u70b9\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a " + jsonObject.get((Object)"errorString"));
                }
                break block20;
            }
            if (!HussarUtils.isNotEmpty(taskUserList)) break block20;
            for (UnifiedTaskUser unifiedTaskUser : taskUserList) {
                ArrayList resultList = new ArrayList();
                HashMap<String, Object> data = new HashMap<String, Object>();
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Authorization", "Basic ZDE5Njc4YTQ4YjczZDdhOTM4NTdmNTZiMDA2NTAyZTg6NmRkZmI4ZGEzNw==");
                UnifiedTaskInfo taskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)unifiedTaskUser.getTaskId())).eq(UnifiedTaskInfo::getSystemId, (Object)systemId));
                if (HussarUtils.isNull((Object)taskInfo)) continue;
                data.put("flowId", taskInfo.getProcessInstanceid());
                data.put("id", taskInfo.getTaskId());
                data.put("name", taskInfo.getTaskName());
                data.put("deadlineTime", !HussarUtils.isNull((Object)taskInfo.getDeadLine()) ? sf.format(taskInfo.getDeadLine()) : "");
                data.put("approvalStatus", Integer.valueOf("1"));
                data.put("approveTime", "");
                SysUsers sysUsers = this.usersService.getUserByOutOriginId(unifiedTaskUser.getUserId());
                data.put("promoterId", HussarUtils.isNull((Object)sysUsers) ? "" : sysUsers.getOutOriginId());
                data.put("promoterNo", unifiedTaskUser.getUserNumber());
                data.put("promoterName", unifiedTaskUser.getUserName());
                data.put("deptName", unifiedTaskUser.getDeptName());
                data.put("postName", unifiedTaskUser.getPostName());
                data.put("jumpUrl", this.getJumpUrl("1", taskInfo.getTaskId()));
                data.put("deleted", "false");
                resultList.add(data);
                String resultData = JSON.toJSONString(resultList);
                logger.info("requestParamJsonToGLD:" + resultData);
                String resp = HttpClientUtil.httpPost(this.unifiedTodoGLDProperties.getApproveNode(), resultData, headers);
                logger.info("responseParamToGLD:" + resp);
                JSONObject jsonObject = JSON.parseObject((String)resp);
                if (!HussarUtils.isNotEmpty((Object)jsonObject.get((Object)"returnCode")) || String.valueOf(jsonObject.get((Object)"returnCode")).equals("0")) continue;
                logger.info("\u63a8\u9001\u8282\u70b9\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a " + jsonObject.get((Object)"errorString"));
            }
        }
    }

    private Object getOaProjectId(String outOriginId) {
        List<String> fillPrefix = this.unifiedTodoGLDProperties.getFilterPrefix();
        if (HussarUtils.isEmpty((Object)outOriginId)) {
            return outOriginId;
        }
        for (String prefix : fillPrefix) {
            if (!outOriginId.contains(prefix)) continue;
            String[] split = outOriginId.split(prefix);
            return HussarUtils.isEmpty((Object)split[1]) ? outOriginId : split[1];
        }
        return outOriginId;
    }

    private String getJumpUrl(String taskStatus, String taskId) {
        if ("1".equals(taskStatus)) {
            return this.unifiedTodoGLDProperties.getToBe() + "%2526taskId=" + taskId;
        }
        if ("3".equals(taskStatus)) {
            return this.unifiedTodoGLDProperties.getToDo() + "?runflowid=" + taskId;
        }
        return "";
    }

    private String getProcessStatus(String processState) {
        if (ProcessState.DONE_RECTIFICATION.getValue().equals(processState)) {
            return ProcessState.RECTIFICATION.getValue();
        }
        return processState;
    }

    private void pushToOa(List<UnifiedParamDto> add, List<UnifiedParamDto> update, String systemId) {
        ArrayList<UnifiedParamDto> pushList = new ArrayList<UnifiedParamDto>();
        if (HussarUtils.isNotEmpty(update)) {
            pushList.addAll(update);
        }
        if (HussarUtils.isNotEmpty(add)) {
            pushList.addAll(add);
        }
        if (HussarUtils.isEmpty(pushList)) {
            return;
        }
        pushList.sort(Comparator.comparing(UnifiedParamDto::getTypeid).reversed());
        logger.info("addList" + add.toString());
        logger.info("updateList" + update.toString());
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (UnifiedParamDto unifiedParamDto : pushList) {
            if ("4".equals(unifiedParamDto.getTypeid()) || "5".equals(unifiedParamDto.getTypeid())) {
                List doneTaskInfoList;
                List pendingTaskInfoList;
                logger.info("unifiedParamDto\u672a\u8bfb/\u5df2\u8bfb" + JSON.toJSONString((Object)unifiedParamDto));
                long count = pushList.stream().filter(u -> u.getUserId().equals(unifiedParamDto.getUserId()) && !u.getApprovalId().equals(unifiedParamDto.getApprovalId())).count();
                if (count > 0L) continue;
                List todoTaskInfoList = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getProcessInstanceid, (Object)unifiedParamDto.getFlowID())).ne(UnifiedTaskInfo::getTaskId, (Object)unifiedParamDto.getApprovalId())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"1")).eq(UnifiedTaskInfo::getProcessState, (Object)Character.valueOf('0'))).eq(UnifiedTaskInfo::getProcessDeleteFlag, (Object)Character.valueOf('0')));
                if (CollectionUtil.isNotEmpty((Collection)todoTaskInfoList)) {
                    long countNew;
                    logger.info("todoTaskInfoList\u957f\u5ea6\uff1a" + todoTaskInfoList.size());
                    List todoIdList = todoTaskInfoList.stream().map(UnifiedTaskInfo::getTaskId).collect(Collectors.toList());
                    List todoUserList = this.unifiedTaskUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskUser::getTaskId, todoIdList)).eq(UnifiedTaskUser::getSystemId, (Object)unifiedParamDto.getSystemId()));
                    if (CollectionUtil.isNotEmpty((Collection)todoUserList) && (countNew = todoUserList.stream().filter(u -> u.getUserId().equals(unifiedParamDto.getUserId())).count()) > 0L) continue;
                }
                if (CollectionUtil.isNotEmpty((Collection)(pendingTaskInfoList = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getProcessInstanceid, (Object)unifiedParamDto.getFlowID())).ne(UnifiedTaskInfo::getTaskId, (Object)unifiedParamDto.getApprovalId())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"2")).eq(UnifiedTaskInfo::getProcessState, (Object)Character.valueOf('0'))).eq(UnifiedTaskInfo::getProcessDeleteFlag, (Object)Character.valueOf('0')))))) {
                    long countNew;
                    logger.info("pendingTaskInfoList\u957f\u5ea6\uff1a" + pendingTaskInfoList.size());
                    List pendingIdList = pendingTaskInfoList.stream().map(UnifiedTaskInfo::getTaskId).collect(Collectors.toList());
                    List pendingUserList = this.unifiedTaskUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskUser::getTaskId, pendingIdList)).eq(UnifiedTaskUser::getSystemId, (Object)unifiedParamDto.getSystemId()));
                    if (CollectionUtil.isNotEmpty((Collection)pendingUserList) && (countNew = pendingUserList.stream().filter(u -> u.getUserId().equals(unifiedParamDto.getUserId())).count()) > 0L) continue;
                }
                if (CollectionUtil.isNotEmpty((Collection)(doneTaskInfoList = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getProcessInstanceid, (Object)unifiedParamDto.getFlowID())).ne(UnifiedTaskInfo::getTaskId, (Object)unifiedParamDto.getApprovalId())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"3")).eq(UnifiedTaskInfo::getProcessDeleteFlag, (Object)Character.valueOf('0')))))) {
                    long countNew;
                    logger.info("doneTaskInfoList\u957f\u5ea6\uff1a" + doneTaskInfoList.size());
                    List doneIdList = doneTaskInfoList.stream().map(UnifiedTaskInfo::getTaskId).collect(Collectors.toList());
                    List doneUserList = this.unifiedTaskUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskUser::getTaskId, doneIdList)).eq(UnifiedTaskUser::getSystemId, (Object)unifiedParamDto.getSystemId()));
                    if (CollectionUtil.isNotEmpty((Collection)doneUserList) && (countNew = doneUserList.stream().filter(u -> u.getUserId().equals(unifiedParamDto.getUserId())).count()) > 0L) continue;
                }
            }
            logger.info("unifiedParamDto" + JSON.toJSONString((Object)unifiedParamDto));
            SysUsers sendUser = null;
            if (HussarUtils.isEmpty((Object)unifiedParamDto.getUserId())) continue;
            SysUsers receiver = this.usersService.getUserByOutOriginId(unifiedParamDto.getUserId());
            if (HussarUtils.isNull((Object)receiver)) {
                this.HandlerLog(unifiedParamDto.getRunnerId(), unifiedParamDto.getRunnerName());
                continue;
            }
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("syscode", this.unifiedTodoProperties.getOaThirdCode());
            if (HussarUtils.isEmpty((Object)unifiedParamDto.getFlowIdName())) {
                UnifiedProcessInfo unifiedProcessInfo;
                logger.info("\u6d41\u7a0b\u5b9e\u4f8bid\uff1a" + unifiedParamDto.getFlowID());
                if (HussarUtils.isEmpty((Object)unifiedParamDto.getFlowID())) {
                    String processInstId = "";
                    switch (unifiedParamDto.getTypeid()) {
                        case "1": {
                            UnifiedTaskInfo todoTaskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)unifiedParamDto.getApprovalId()));
                            if (Objects.isNull(todoTaskInfo)) break;
                            processInstId = todoTaskInfo.getProcessInstanceid();
                            break;
                        }
                        case "2": {
                            UnifiedTaskInfo pendingTaskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)unifiedParamDto.getApprovalId()));
                            if (Objects.isNull(pendingTaskInfo)) break;
                            processInstId = pendingTaskInfo.getProcessInstanceid();
                            break;
                        }
                        case "3": {
                            UnifiedTaskInfo doneTaskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)unifiedParamDto.getApprovalId()));
                            if (Objects.isNull(doneTaskInfo)) break;
                            processInstId = doneTaskInfo.getProcessInstanceid();
                            break;
                        }
                        case "4": {
                            UnifiedTaskInfo unReadTaskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)unifiedParamDto.getApprovalId()));
                            if (Objects.isNull(unReadTaskInfo)) break;
                            processInstId = unReadTaskInfo.getProcessInstanceid();
                            break;
                        }
                        case "5": {
                            UnifiedTaskInfo readTaskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)unifiedParamDto.getApprovalId()));
                            if (Objects.isNull(readTaskInfo)) break;
                            processInstId = readTaskInfo.getProcessInstanceid();
                            break;
                        }
                    }
                    unifiedProcessInfo = (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)processInstId));
                    logger.info("\u6d41\u7a0b\u5b9e\u4f8bid\uff1a" + processInstId);
                    data.put("flowid", processInstId);
                } else {
                    data.put("flowid", unifiedParamDto.getFlowID());
                    unifiedProcessInfo = (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)unifiedParamDto.getFlowID()));
                }
                if (!HussarUtils.isNull((Object)unifiedProcessInfo)) {
                    sendUser = this.usersService.getUserByOutOriginId(unifiedProcessInfo.getStartUserId());
                    data.put("requestname", unifiedProcessInfo.getProcessName());
                    data.put("workflowname", unifiedProcessInfo.getProcessName());
                    unifiedParamDto.setFlag4(unifiedProcessInfo.getProcessState());
                }
                if (!"0".equals(unifiedProcessInfo.getProcessState()) && "1".equals(unifiedParamDto.getTypeid())) {
                    unifiedParamDto.setTypeid("3");
                }
            } else {
                data.put("flowid", unifiedParamDto.getFlowID());
                data.put("requestname", unifiedParamDto.getFlowIdName());
                data.put("workflowname", unifiedParamDto.getFlowIdName());
            }
            logger.info("workflowname:" + unifiedParamDto.getFlowIdName());
            data.put("nodename", unifiedParamDto.getKey2());
            data.put("appurl", unifiedParamDto.getParam10());
            String flowState = this.getFlowState(unifiedParamDto, data, systemId);
            if (HussarUtils.isNull((Object)flowState)) continue;
            data.put("isremark", flowState);
            data.put("viewtype", this.getReadState(unifiedParamDto.getTypeid()));
            if (HussarUtils.isNull((Object)sendUser)) continue;
            data.put("creator", sendUser.getUserAccount());
            data.put("createdatetime", HussarUtils.isEmpty((Object)unifiedParamDto.getCreateTime()) ? sf.format(new Date()) : sf.format(Long.valueOf(unifiedParamDto.getCreateTime())));
            data.put("receiver", receiver.getUserAccount());
            data.put("receivedatetime", HussarUtils.isEmpty((Object)unifiedParamDto.getTime1()) ? sf.format(new Date()) : sf.format(Long.valueOf(unifiedParamDto.getTime1())));
            data.put("receivets", String.valueOf(System.currentTimeMillis()));
            try {
                logger.info("requestParam:" + unifiedParamDto.getFlowIdName());
                String resultData = JSON.toJSONString(data);
                logger.info("requestParamJson:" + resultData);
                String resp = HttpClientUtil.httpPost(this.unifiedTodoProperties.getReceiveDataUrl(), resultData, null);
                logger.info("responseParam:" + resp);
                JSONObject jsonObject = JSON.parseObject((String)resp);
                if (!jsonObject.get((Object)"operResult").equals("0")) continue;
                this.HandlerLog(unifiedParamDto.getRunnerId(), unifiedParamDto.getRunnerName());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.HandlerLog(unifiedParamDto.getRunnerId(), unifiedParamDto.getRunnerName());
            }
        }
    }

    private void HandlerLog(String userId, String userName) {
        UserDetails userDetails = new UserDetails();
        AuditLogModel auditLogModel = new AuditLogModel();
        auditLogModel.setModuleName(MODULE_NAME);
        auditLogModel.setEventGrade(AuditEventGrade.SERVICE_LOG_TYPE);
        auditLogModel.setEventType(AuditEventType.EXCEPTION);
        auditLogModel.setEventDesc("\u7528\u6237\u8bbf\u95eeOA-\u6570\u636e\u63a8\u9001");
        userDetails.setUserIdStr(userId);
        userDetails.setUserName(userName);
        auditLogModel.setUserDetails(userDetails);
        AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
    }

    private String getReadState(String readState) {
        if ("4".equals(readState)) {
            return "0";
        }
        if ("5".equals(readState)) {
            return "1";
        }
        return "0";
    }

    private String getFlowState(UnifiedParamDto dto, Map<String, String> data, String systemId) {
        if ("1".equals(dto.getTypeid())) {
            data.put("pcurl", this.unifiedTodoProperties.getToBe() + "%2526taskId=" + dto.getApprovalId());
            logger.info("pcurl:" + data.get("pcurl"));
            return "0";
        }
        if ("3".equals(dto.getTypeid()) && ProcessState.RUNNING.getValue().equals(dto.getFlag4()) || "5".equals(dto.getTypeid())) {
            data.put("pcurl", this.unifiedTodoProperties.getToDo() + "?runflowid=" + dto.getFlowID());
            logger.info("pcurl:" + data.get("pcurl"));
            return "2";
        }
        if ("3".equals(dto.getTypeid())) {
            data.put("pcurl", this.unifiedTodoProperties.getToDo() + "?runflowid=" + dto.getFlowID());
            return "4";
        }
        if ("4".equals(dto.getTypeid())) {
            data.put("pcurl", this.unifiedTodoProperties.getToUnRead() + "%2526taskId=" + dto.getApprovalId());
            logger.info("pcurl:" + data.get("pcurl"));
            return "8";
        }
        return null;
    }

    private void addUnified(List<UnifiedParamDto> unifiedParamDtoList) {
        if (unifiedParamDtoList.isEmpty()) {
            return;
        }
        ArrayList<UnifiedProcessInfo> unifiedProcessInfos = new ArrayList<UnifiedProcessInfo>();
        ArrayList<UnifiedTaskInfo> unifiedTaskInfos = new ArrayList<UnifiedTaskInfo>();
        ArrayList<UnifiedTaskUser> unifiedTaskUsers = new ArrayList<UnifiedTaskUser>();
        for (UnifiedParamDto unifiedParamDto : unifiedParamDtoList) {
            logger.info("\u6dfb\u52a0\u7684\u63a8\u9001\u6570\u636e\uff1a" + JSON.toJSONString((Object)unifiedParamDto));
            UnifiedProcessInfo unifiedProcessInfo = unifiedParamDto.buildProcessInfo();
            UnifiedTaskInfo unifiedTaskInfo = unifiedParamDto.buildTaskInfo();
            UnifiedTaskUser unifiedTaskUser = unifiedParamDto.buildUserInfo();
            if (unifiedProcessInfo != null) {
                unifiedProcessInfos.add(unifiedProcessInfo.setDeleteFlag("0"));
            }
            if (unifiedTaskInfo != null) {
                unifiedTaskInfos.add(unifiedTaskInfo);
            }
            if (unifiedTaskUser == null) continue;
            unifiedTaskUsers.add(unifiedTaskUser);
        }
        if (!unifiedProcessInfos.isEmpty()) {
            this.unifiedProcessInfoService.saveBatch(unifiedProcessInfos);
            this.updateTaskInfo(unifiedProcessInfos);
        }
        if (!unifiedTaskInfos.isEmpty()) {
            this.unifiedTaskInfoService.saveBatch(unifiedTaskInfos);
            this.saveBatchTaskInfos(unifiedTaskInfos, unifiedTaskUsers);
        }
        if (!unifiedTaskUsers.isEmpty()) {
            this.unifiedTaskUserService.saveBatch(unifiedTaskUsers);
        }
    }

    private void saveBatchTaskInfos(List<UnifiedTaskInfo> unifiedTaskInfos, List<UnifiedTaskUser> unifiedTaskUsers) {
        if (HussarUtils.isEmpty(unifiedTaskInfos)) {
            return;
        }
        ArrayList<UnifiedTaskInfo> unifiedTaskInfoList = new ArrayList<UnifiedTaskInfo>();
        for (UnifiedTaskInfo unifiedTaskInfo : unifiedTaskInfos) {
            UnifiedTaskInfo taskInfo = new UnifiedTaskInfo();
            BeanUtil.copyProperties((Object)unifiedTaskInfo, (Object)taskInfo);
            UnifiedProcessInfo unifiedProcessInfo = (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)unifiedTaskInfo.getProcessInstanceid())).eq(UnifiedProcessInfo::getSystemId, (Object)unifiedTaskInfo.getSystemId()));
            taskInfo = taskInfo.buildTaskInfo(unifiedProcessInfo);
            for (UnifiedTaskUser unifiedTaskUser : unifiedTaskUsers) {
                if (!unifiedTaskUser.getTaskId().equals(unifiedTaskInfo.getTaskId())) continue;
                taskInfo = taskInfo.buildTaskInfo(unifiedProcessInfo, unifiedTaskUser);
            }
            unifiedTaskInfoList.add(taskInfo);
        }
        if (HussarUtils.isNotEmpty(unifiedTaskInfoList)) {
            this.unifiedTaskInfoService.saveOrUpdateBatch(unifiedTaskInfoList);
        }
    }

    private void updateTaskInfo(List<UnifiedProcessInfo> unifiedProcessInfos) {
        for (UnifiedProcessInfo unifiedProcessInfo : unifiedProcessInfos) {
            List unifiedTaskInfos = this.unifiedTaskInfoService.list((Wrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getProcessInstanceid, (Object)unifiedProcessInfo.getProcInstId()));
            if (unifiedTaskInfos == null || unifiedTaskInfos.isEmpty()) continue;
            for (int i = 0; i < unifiedTaskInfos.size(); ++i) {
                ((UnifiedTaskInfo)unifiedTaskInfos.get(i)).setProcessName(unifiedProcessInfo.getProcessName());
                ((UnifiedTaskInfo)unifiedTaskInfos.get(i)).setBusinessId(unifiedProcessInfo.getBusinessId());
                ((UnifiedTaskInfo)unifiedTaskInfos.get(i)).setProcDefId(unifiedProcessInfo.getProcDefId());
                ((UnifiedTaskInfo)unifiedTaskInfos.get(i)).setStartUserId(unifiedProcessInfo.getStartUserId());
                ((UnifiedTaskInfo)unifiedTaskInfos.get(i)).setStartUserName(unifiedProcessInfo.getStartUserName());
                ((UnifiedTaskInfo)unifiedTaskInfos.get(i)).setStartUserNumber(unifiedProcessInfo.getStartUserNumber());
                ((UnifiedTaskInfo)unifiedTaskInfos.get(i)).setStartTime(unifiedProcessInfo.getStartTime());
                ((UnifiedTaskInfo)unifiedTaskInfos.get(i)).setEndTime(unifiedProcessInfo.getEndTime());
                ((UnifiedTaskInfo)unifiedTaskInfos.get(i)).setProcessState(unifiedProcessInfo.getProcessState());
                ((UnifiedTaskInfo)unifiedTaskInfos.get(i)).setProcessDeptId(unifiedProcessInfo.getDeptId());
                ((UnifiedTaskInfo)unifiedTaskInfos.get(i)).setProcessUnitId(unifiedProcessInfo.getUnitId());
                ((UnifiedTaskInfo)unifiedTaskInfos.get(i)).setProcessDeptName(unifiedProcessInfo.getDeptName());
                ((UnifiedTaskInfo)unifiedTaskInfos.get(i)).setProcessUnitName(unifiedProcessInfo.getUnitName());
                ((UnifiedTaskInfo)unifiedTaskInfos.get(i)).setProcessDeleteFlag(unifiedProcessInfo.getDeleteFlag());
                ((UnifiedTaskInfo)unifiedTaskInfos.get(i)).setBusinessModelId(unifiedProcessInfo.getBusinessModelId());
                ((UnifiedTaskInfo)unifiedTaskInfos.get(i)).setBusinessModelName(unifiedProcessInfo.getBusinessModelName());
                ((UnifiedTaskInfo)unifiedTaskInfos.get(i)).setProcessWebLinkUrl(unifiedProcessInfo.getWebLinkurl());
                ((UnifiedTaskInfo)unifiedTaskInfos.get(i)).setProcessMobileLinkUrl(unifiedProcessInfo.getMobileLinkurl());
                ((UnifiedTaskInfo)unifiedTaskInfos.get(i)).setFormId(unifiedProcessInfo.getFormId());
                ((UnifiedTaskInfo)unifiedTaskInfos.get(i)).setRunName(unifiedProcessInfo.getRunName());
                ((UnifiedTaskInfo)unifiedTaskInfos.get(i)).setVerSys(unifiedProcessInfo.getVerSys());
                ((UnifiedTaskInfo)unifiedTaskInfos.get(i)).setTenantCode(unifiedProcessInfo.getTenantCode());
                ((UnifiedTaskInfo)unifiedTaskInfos.get(i)).setProcessNameExtra(unifiedProcessInfo.getProcessNameExtra());
            }
            this.unifiedTaskInfoService.saveOrUpdateBatch((Collection)unifiedTaskInfos);
        }
    }

    private void updateUnified(List<UnifiedParamDto> unifiedParamDtoList) {
        if (unifiedParamDtoList.isEmpty()) {
            return;
        }
        long start = System.currentTimeMillis();
        logger.info("\u66f4\u65b0\u63a8\u9001\u6570\u636e\u5f00\u59cb\uff1a" + start);
        logger.info("\u66f4\u65b0\u6570\u636e\u957f\u5ea6\uff1a" + unifiedParamDtoList.size());
        unifiedParamDtoList.forEach(this.update);
        long end = System.currentTimeMillis();
        logger.info("\u66f4\u65b0\u63a8\u9001\u6570\u636e\u7ed3\u675f\uff1a" + end);
        logger.info("\u66f4\u65b0\u6570\u636e\u4f7f\u7528\u7684\u65f6\u95f4\u662f\uff1a" + (end - start));
    }

    private void updateTaskUsers(UnifiedTaskUser unifiedTaskUser) {
        UnifiedTaskInfo unifiedTaskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)unifiedTaskUser.getTaskId()));
        if (!HussarUtils.isNull((Object)unifiedTaskInfo)) {
            UnifiedProcessInfo unifiedProcessInfo = (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)unifiedTaskInfo.getProcessInstanceid())).eq(UnifiedProcessInfo::getSystemId, (Object)unifiedTaskInfo.getSystemId()));
            UnifiedTaskInfo taskInfo = unifiedTaskInfo.buildTaskInfo(unifiedProcessInfo, unifiedTaskUser);
            ((LambdaUpdateChainWrapper)this.unifiedTaskInfoService.lambdaUpdate().eq(UnifiedTaskInfo::getTaskId, (Object)taskInfo.getTaskId())).update((Object)taskInfo);
        }
    }

    private void updateTaskStatus(UnifiedTaskInfo unifiedTaskInfo, UnifiedTaskUser unifiedTaskUser) {
        ArrayList<UnifiedTaskInfo> unifiedTaskInfos = new ArrayList<UnifiedTaskInfo>();
        ArrayList<UnifiedTaskUser> unifiedTaskUsers = new ArrayList<UnifiedTaskUser>();
        switch (unifiedTaskInfo.getTaskStatus()) {
            case "1": {
                this.unifiedPendingTaskInfoService.remove((Wrapper)new LambdaQueryWrapper().eq(UnifiedPendingTaskInfo::getTaskId, (Object)unifiedTaskInfo.getTaskId()));
                this.unifiedTodoTaskInfoService.remove((Wrapper)new LambdaQueryWrapper().eq(UnifiedTodoTaskInfo::getTaskId, (Object)unifiedTaskInfo.getTaskId()));
                break;
            }
            case "2": {
                return;
            }
            case "4": {
                return;
            }
            case "3": {
                this.unifiedTodoTaskInfoService.remove((Wrapper)new LambdaQueryWrapper().eq(UnifiedTodoTaskInfo::getTaskId, (Object)unifiedTaskInfo.getTaskId()));
                this.unifiedDoneTaskInfoService.remove((Wrapper)new LambdaQueryWrapper().eq(UnifiedDoneTaskInfo::getTaskId, (Object)unifiedTaskInfo.getTaskId()));
                break;
            }
            case "5": {
                UnifiedUnReadTaskInfo unifiedUnReadTaskInfoServiceOne = (UnifiedUnReadTaskInfo)this.unifiedUnReadTaskInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedUnReadTaskInfo::getTaskId, (Object)unifiedTaskInfo.getTaskId()));
                logger.info("\u672a\u8bfb\u6570\u636e\uff1a" + JSON.toJSONString((Object)unifiedUnReadTaskInfoServiceOne));
                if (unifiedUnReadTaskInfoServiceOne != null) {
                    String taskId = this.unifiedUnReadTaskInfoService.selectTaskId(unifiedUnReadTaskInfoServiceOne.getTodoId().toString());
                    logger.info("taskId\uff1a" + taskId);
                    if (taskId != null && !taskId.equals("")) {
                        logger.info("\u9501\u8868\u540e\u67e5\u8be2\u5230\u672a\u8bfb\u53ef\u8fdb\u5165\uff1a" + taskId);
                        this.unifiedUnReadTaskInfoService.remove((Wrapper)new LambdaQueryWrapper().eq(UnifiedUnReadTaskInfo::getTodoId, (Object)unifiedUnReadTaskInfoServiceOne.getTodoId()));
                        this.unifiedReadedTaskInfoService.remove((Wrapper)new LambdaQueryWrapper().eq(UnifiedReadedTaskInfo::getTaskId, (Object)unifiedTaskInfo.getTaskId()));
                        break;
                    }
                    logger.info("\u9501\u8868\u540e\u67e5\u8be2\u672a\u8bfb\u4e3a\u7a7a\u8fdb\u5165");
                    return;
                }
                return;
            }
        }
        unifiedTaskInfos.add(unifiedTaskInfo);
        unifiedTaskUsers.add(unifiedTaskUser);
        this.saveBatchTaskInfos(unifiedTaskInfos, unifiedTaskUsers);
    }

    private void deleteUnified(List<UnifiedParamDto> unifiedParamDtoList, Long systemId) {
        if (unifiedParamDtoList.isEmpty()) {
            return;
        }
        if (this.unifiedTodoProperties.getOpen()) {
            List todoTaskInfoList;
            logger.info("\u4fee\u6539\u8282\u70b9\u5ba1\u6279\u4eba\u63a8\u9001\u5f00\u59cb");
            ArrayList unifiedParamDtoListNew = new ArrayList();
            ArrayList<UnifiedParamDto> unifiedParamTodoDtoListNew = new ArrayList<UnifiedParamDto>();
            List taskIds = unifiedParamDtoList.stream().map(UnifiedParamDto::getApprovalId).filter(HussarUtils::isNotEmpty).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(taskIds) && CollectionUtil.isNotEmpty((Collection)(todoTaskInfoList = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskInfo::getTaskId, taskIds)).eq(UnifiedTaskInfo::getTaskStatus, (Object)"1")).eq(UnifiedTaskInfo::getProcessState, (Object)Character.valueOf('0'))).eq(UnifiedTaskInfo::getProcessDeleteFlag, (Object)Character.valueOf('0')))))) {
                logger.info("taskSize:" + todoTaskInfoList.size());
                for (UnifiedParamDto unifiedParamDto : unifiedParamDtoList) {
                    logger.info("deleteTaskInfo:" + JSON.toJSONString((Object)unifiedParamDto));
                    List partList = todoTaskInfoList.stream().filter(t -> t.getTaskId().equals(unifiedParamDto.getApprovalId())).collect(Collectors.toList());
                    if (CollectionUtil.isEmpty(partList)) continue;
                    UnifiedTaskInfo taskInfo = (UnifiedTaskInfo)partList.get(0);
                    List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskUser::getTaskId, (Object)unifiedParamDto.getApprovalId())).eq(UnifiedTaskUser::getSystemId, (Object)systemId));
                    logger.info("taskUserSize:" + taskUsers.size());
                    if (!CollectionUtil.isNotEmpty((Collection)taskUsers)) continue;
                    Iterator iterator = taskUsers.iterator();
                    while (iterator.hasNext()) {
                        UnifiedTaskUser taskUser = (UnifiedTaskUser)iterator.next();
                        UnifiedParamDto dto = new UnifiedParamDto();
                        BeanUtil.copyProperties((Object)unifiedParamDto, (Object)dto);
                        dto.setKey2(taskInfo.getTaskName());
                        dto.setFlowID(taskInfo.getProcessInstanceid());
                        dto.setUserId(taskUser.getUserId());
                        dto.setTypeid("3");
                        logger.info("taskNewInfo:" + JSON.toJSONString((Object)dto));
                        unifiedParamDtoListNew.add(dto);
                    }
                }
                List todoOldTaskInfoList = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getProcessInstanceid, (Object)((UnifiedTaskInfo)todoTaskInfoList.get(0)).getProcessInstanceid())).notIn(UnifiedTaskInfo::getTaskId, taskIds)).eq(UnifiedTaskInfo::getTaskStatus, (Object)"1")).eq(UnifiedTaskInfo::getProcessState, (Object)Character.valueOf('0'))).eq(UnifiedTaskInfo::getProcessDeleteFlag, (Object)Character.valueOf('0')));
                if (HussarUtils.isNotEmpty((Object)todoOldTaskInfoList)) {
                    for (UnifiedTaskInfo unifiedTodoTaskInfo : todoOldTaskInfoList) {
                        logger.info("taskTodoNewInfo:" + JSON.toJSONString((Object)unifiedTodoTaskInfo));
                        List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskUser::getTaskId, (Object)unifiedTodoTaskInfo.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)systemId));
                        logger.info("taskTodoUserSize:" + taskUsers.size());
                        if (!CollectionUtil.isNotEmpty((Collection)taskUsers)) continue;
                        for (UnifiedTaskUser taskUser : taskUsers) {
                            UnifiedParamDto dto = new UnifiedParamDto();
                            dto.setApprovalId(unifiedTodoTaskInfo.getTaskId());
                            dto.setKey2(unifiedTodoTaskInfo.getTaskName());
                            dto.setParam10(unifiedTodoTaskInfo.getMobileLinkurl());
                            dto.setFlowID(unifiedTodoTaskInfo.getProcessInstanceid());
                            dto.setUserId(taskUser.getUserId());
                            dto.setTypeid(unifiedTodoTaskInfo.getTaskStatus());
                            dto.setCreateTime(HussarUtils.isNull((Object)unifiedTodoTaskInfo.getCreateTime()) ? "" : String.valueOf(unifiedTodoTaskInfo.getCreateTime().getTime()));
                            logger.info("taskTodoNewInfo:" + JSON.toJSONString((Object)dto));
                            unifiedParamTodoDtoListNew.add(dto);
                        }
                    }
                }
            }
            this.pushToOa(unifiedParamDtoListNew, new ArrayList<UnifiedParamDto>(), String.valueOf(systemId));
            this.pushToOa(unifiedParamTodoDtoListNew, new ArrayList<UnifiedParamDto>(), String.valueOf(systemId));
        }
        if (this.unifiedTodoGLDProperties.isOpen()) {
            for (UnifiedParamDto dto : unifiedParamDtoList) {
                JSONObject jsonObject;
                String resp;
                String resultData;
                HashMap<String, Object> data;
                ArrayList resultList;
                String procInstId = dto.procInstId();
                String taskId = dto.taskId();
                if (HussarUtils.isNotEmpty((Object)procInstId)) {
                    UnifiedProcessInfo unifiedProcessInfo = (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)procInstId)).eq(UnifiedProcessInfo::getSystemId, (Object)systemId));
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("Authorization", "Basic ZDE5Njc4YTQ4YjczZDdhOTM4NTdmNTZiMDA2NTAyZTg6NmRkZmI4ZGEzNw==");
                    resultList = new ArrayList();
                    data = new HashMap<String, Object>();
                    data.put("id", unifiedProcessInfo.getProcInstId());
                    data.put("approvalStatus", Integer.valueOf(this.getProcessStatus(unifiedProcessInfo.getProcessState())));
                    data.put("deleted", "true");
                    resultList.add(data);
                    resultData = JSON.toJSONString(resultList);
                    logger.info("requestParamJsonToGLD:" + resultData);
                    resp = HttpClientUtil.httpPost(this.unifiedTodoGLDProperties.getApproveRecord(), resultData, hashMap);
                    logger.info("responseParamToGLD:" + resp);
                    jsonObject = JSON.parseObject((String)resp);
                    if (HussarUtils.isNotEmpty((Object)jsonObject.get((Object)"returnCode")) && !String.valueOf(jsonObject.get((Object)"returnCode")).equals("0")) {
                        logger.info("\u63a8\u9001\u6d41\u7a0b\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a " + jsonObject.get((Object)"errorString"));
                    }
                }
                if (!HussarUtils.isNotEmpty((Object)taskId)) continue;
                UnifiedTaskInfo unifiedTaskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)taskId)).eq(UnifiedTaskInfo::getSystemId, (Object)systemId));
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("Authorization", "Basic ZDE5Njc4YTQ4YjczZDdhOTM4NTdmNTZiMDA2NTAyZTg6NmRkZmI4ZGEzNw==");
                resultList = new ArrayList();
                data = new HashMap();
                data.put("flowId", unifiedTaskInfo.getProcessInstanceid());
                data.put("id", unifiedTaskInfo.getTaskId());
                data.put("approveTime", "");
                data.put("approvalStatus", "2");
                data.put("deleted", "true");
                data.put("jumpUrl", this.getJumpUrl("3", unifiedTaskInfo.getProcessInstanceid()));
                resultList.add(data);
                resultData = JSON.toJSONString(resultList);
                logger.info("requestParamJsonToGLD:" + resultData);
                resp = HttpClientUtil.httpPost(this.unifiedTodoGLDProperties.getApproveNode(), resultData, hashMap);
                logger.info("responseParamToGLD:" + resp);
                jsonObject = JSON.parseObject((String)resp);
                if (!HussarUtils.isNotEmpty((Object)jsonObject.get((Object)"returnCode")) || String.valueOf(jsonObject.get((Object)"returnCode")).equals("0")) continue;
                logger.info("\u63a8\u9001\u8282\u70b9\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a " + jsonObject.get((Object)"errorString"));
            }
        }
        HashSet<String> procInstIds = new HashSet<String>();
        HashSet<String> taskIds = new HashSet<String>();
        for (UnifiedParamDto unifiedParamDto : unifiedParamDtoList) {
            String procInstId = unifiedParamDto.procInstId();
            String string = unifiedParamDto.taskId();
            if (HussarUtils.isNotEmpty((Object)procInstId)) {
                procInstIds.add(procInstId);
            }
            if (!HussarUtils.isNotEmpty((Object)string)) continue;
            taskIds.add(string);
        }
        if (!HussarUtils.isEmpty(procInstIds)) {
            ((LambdaUpdateChainWrapper)this.unifiedProcessInfoService.lambdaUpdate().in(UnifiedProcessInfo::getProcInstId, procInstIds)).remove();
            ArrayList<UnifiedDeleteProcessInfo> deleteProcessInfoList = new ArrayList<UnifiedDeleteProcessInfo>();
            for (String procInstId : procInstIds) {
                UnifiedDeleteProcessInfo unifiedDeleteProcessInfo = new UnifiedDeleteProcessInfo();
                unifiedDeleteProcessInfo.setProcessInstanceId(procInstId);
                deleteProcessInfoList.add(unifiedDeleteProcessInfo);
            }
            this.iUnifiedDeleteProcessInfoService.saveBatch(deleteProcessInfoList);
        }
        if (!HussarUtils.isEmpty(taskIds)) {
            ((LambdaUpdateChainWrapper)this.unifiedTaskInfoService.lambdaUpdate().in(UnifiedTaskInfo::getTaskId, taskIds)).remove();
            ((LambdaUpdateChainWrapper)this.unifiedTaskUserService.lambdaUpdate().in(UnifiedTaskUser::getTaskId, taskIds)).remove();
        }
    }

    public ApiResponse<Page<UnifiedTaskQueryVo>> queryUnifiedTask(Page<UnifiedTaskQueryVo> page, UnifiedTaskQueryDto unifiedTaskQueryDto) {
        if (unifiedTaskQueryDto.isOnlyQueryProcess()) {
            this.unifiedToDoMapper.queryUnifiedProcess(page, unifiedTaskQueryDto);
            if (unifiedTaskQueryDto.isCountDueDays()) {
                Date now = new Date();
                for (UnifiedTaskQueryVo record : page.getRecords()) {
                    LocalDateTime dueTime = record.getDeadLine();
                    if (dueTime == null) continue;
                    long days = (dueTime.toInstant(ZoneOffset.of("+8")).toEpochMilli() - now.getTime()) / 86400000L;
                    record.setNumberOfDaysBeforeTimeout(Long.valueOf(days));
                }
            }
        } else {
            this.unifiedToDoMapper.queryUnifiedTask(page, unifiedTaskQueryDto);
        }
        for (UnifiedTaskQueryVo record : page.getRecords()) {
            if (!HussarUtils.isNotEmpty((Object)record.getProcessState())) continue;
            record.setProcessStateStr(ProcessState.getProcessState((String)record.getProcessState()));
        }
        if (page.getRecords() != null && !page.getRecords().isEmpty()) {
            this.getFormAuth(page.getRecords(), "1");
        }
        return ApiResponse.success(page);
    }

    public ApiResponse<Page<UnifiedTaskQueryVo>> queryDoneCcTask(Page<UnifiedTaskQueryVo> page, UnifiedTaskQueryDto unifiedTaskQueryDto) {
        this.unifiedToDoMapper.queryDoneCcTask(page, unifiedTaskQueryDto);
        for (UnifiedTaskQueryVo record : page.getRecords()) {
            if (!HussarUtils.isNotEmpty((Object)record.getProcessState())) continue;
            record.setProcessStateStr(ProcessState.getProcessState((String)record.getProcessState()));
        }
        if (page.getRecords() != null && !page.getRecords().isEmpty()) {
            this.getFormAuth(page.getRecords(), "0");
        }
        return ApiResponse.success(page);
    }

    public ApiResponse<Page<UnifiedTaskQueryVo>> queryDoneTask(Page<UnifiedTaskQueryVo> page, UnifiedTaskQueryDto unifiedTaskQueryDto) {
        this.unifiedToDoMapper.queryDoneTaskNew(page, unifiedTaskQueryDto);
        for (UnifiedTaskQueryVo record : page.getRecords()) {
            if (!HussarUtils.isNotEmpty((Object)record.getProcessState())) continue;
            record.setProcessStateStr(ProcessState.getProcessState((String)record.getProcessState()));
        }
        if (page.getRecords() != null && !page.getRecords().isEmpty()) {
            this.getFormAuth(page.getRecords(), "0");
        }
        return ApiResponse.success(page);
    }

    public ApiResponse<Page<UnifiedTaskQueryVo>> queryUnifiedTasks(Page<UnifiedTaskQueryVo> page, UnifiedTaskQueryDto unifiedTaskQueryDto) {
        List<UnifiedTaskQueryVo> unifiedTaskQueryVos = this.unifiedToDoMapper.queryUnifiedTaskList(unifiedTaskQueryDto);
        if (HussarUtils.isNotEmpty(unifiedTaskQueryVos)) {
            for (UnifiedTaskQueryVo unifiedTaskQueryVo : unifiedTaskQueryVos) {
                if (!HussarUtils.isNull((Object)unifiedTaskQueryVo.getDeadLine())) {
                    long dateLine = Timestamp.valueOf(unifiedTaskQueryVo.getDeadLine()).getTime();
                    long now = System.currentTimeMillis();
                    double housr = (double)(dateLine - now) * 1.0 / 1000.0 / 3600.0;
                    double result = Math.floor(housr);
                    long numberOfDaysBeforeTimeout = Double.valueOf(result).longValue();
                    unifiedTaskQueryVo.setNumberOfDaysBeforeTimeout(Long.valueOf(numberOfDaysBeforeTimeout));
                }
                if (unifiedTaskQueryDto.getTaskType().equals("4")) {
                    this.getFormAuth(unifiedTaskQueryVos, "1");
                    continue;
                }
                this.getFormAuth(unifiedTaskQueryVos, "0");
            }
        }
        return ApiResponse.success((Object)page.setRecords(unifiedTaskQueryVos));
    }

    public ApiResponse<Long> queryUnifiedTaskNumber(UnifiedTaskQueryDto unifiedTaskQueryDto) {
        if (unifiedTaskQueryDto.isOnlyQueryProcess()) {
            return ApiResponse.success((Object)this.unifiedToDoMapper.queryUnifiedProcessNumber(unifiedTaskQueryDto));
        }
        return ApiResponse.success((Object)this.unifiedToDoMapper.queryUnifiedTaskNumber(unifiedTaskQueryDto));
    }

    public ApiResponse<Page<UnifiedTaskQueryVo>> queryUnifiedMyTask(Page<UnifiedTaskQueryVo> page, UnifiedTaskQueryDto unifiedTaskQueryDto) {
        unifiedTaskQueryDto.setStartUserId(unifiedTaskQueryDto.getUserId());
        this.unifiedToDoMapper.queryUnifiedMyTask(page, unifiedTaskQueryDto);
        for (UnifiedTaskQueryVo record : page.getRecords()) {
            if (!HussarUtils.isNotEmpty((Object)record.getProcessState())) continue;
            record.setProcessStateStr(ProcessState.getProcessState((String)record.getProcessState()));
            record.setTaskDefKey("");
        }
        if (page.getRecords() != null && !page.getRecords().isEmpty()) {
            this.getFormAuth(page.getRecords(), "1");
        }
        return ApiResponse.success(page);
    }

    public void getFormAuth(List<UnifiedTaskQueryVo> unifiedTaskQueryVos, String formAuth) {
        for (int i = 0; i < unifiedTaskQueryVos.size(); ++i) {
            String[] type;
            String disabled = "";
            String hidden = "";
            String mobileDisable = "";
            String mobileHidden = "";
            for (String s : type = new String[]{"web", "mobile"}) {
                String[] formAll;
                if (s.equals("web")) {
                    String webUrlProps = "";
                    if (formAuth.equals("0")) {
                        webUrlProps = unifiedTaskQueryVos.get(i).getWebUrlProps();
                    } else if (formAuth.equals("1")) {
                        webUrlProps = unifiedTaskQueryVos.get(i).getProcessWebUrlProps();
                    }
                    if (webUrlProps == null || webUrlProps.equals("")) continue;
                    formAll = webUrlProps.split(";");
                    disabled = formAll[0].replace("[", "").replace("]", "").trim();
                    hidden = formAll[1].replace("[", "").replace("]", "").trim();
                    continue;
                }
                String mobileUrlProps = "";
                if (formAuth.equals("0")) {
                    mobileUrlProps = unifiedTaskQueryVos.get(i).getMobileUrlProps();
                } else if (formAuth.equals("1")) {
                    mobileUrlProps = unifiedTaskQueryVos.get(i).getProcessMobileUrlProps();
                }
                if (mobileUrlProps == null || mobileUrlProps.equals("")) continue;
                formAll = mobileUrlProps.split(";");
                mobileDisable = formAll[1].replace("[", "").replace("]", "").trim();
                mobileHidden = formAll[1].replace("[", "").replace("]", "").trim();
            }
            unifiedTaskQueryVos.get(i).setDisabled(disabled);
            unifiedTaskQueryVos.get(i).setHidden(hidden);
            unifiedTaskQueryVos.get(i).setMobileDisable(mobileDisable);
            unifiedTaskQueryVos.get(i).setMobileHidden(mobileHidden);
        }
    }

    public ApiResponse<Page<UnifiedTaskQueryVo>> queryRectification(Page<UnifiedTaskQueryVo> page, UnifiedTaskQueryDto unifiedTaskQueryDto) {
        List<UnifiedTaskQueryVo> taskQueryVos = this.unifiedToDoMapper.queryRectification(unifiedTaskQueryDto);
        return ApiResponse.success((Object)page.setRecords(taskQueryVos));
    }

    public ApiResponse<Long> queryRectificationNumberExtend(String userId, String processStatus) {
        long count = this.unifiedProcessInfoService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getStartUserId, (Object)userId)).eq(UnifiedProcessInfo::getProcessState, (Object)processStatus));
        return ApiResponse.success((Object)count);
    }

    public ApiResponse<TaskNumber> queryTaskNumber(String userId) {
        TaskNumber taskNumber = new TaskNumber();
        taskNumber.setCcTask(Long.valueOf(this.unifiedTaskInfoService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getUserId, (Object)userId)).eq(UnifiedTaskInfo::getTaskStatus, (Object)"4"))));
        taskNumber.setRectificationTask(Long.valueOf(this.unifiedProcessInfoService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getStartUserId, (Object)userId)).eq(UnifiedProcessInfo::getProcessState, (Object)ProcessState.RECTIFICATION.getValue()))));
        taskNumber.setMyTask(Long.valueOf(this.unifiedProcessInfoService.count((Wrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getStartUserId, (Object)userId))));
        taskNumber.setTodoTask(Long.valueOf(this.unifiedTaskInfoService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getUserId, (Object)userId)).eq(UnifiedTaskInfo::getTaskStatus, (Object)"1")).eq(UnifiedTaskInfo::getProcessState, (Object)ProcessState.RUNNING.getValue()))));
        taskNumber.setPendingTask(Long.valueOf(this.unifiedTaskInfoService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getUserId, (Object)userId)).eq(UnifiedTaskInfo::getTaskStatus, (Object)"2")).eq(UnifiedTaskInfo::getProcessState, (Object)ProcessState.RUNNING.getValue()))));
        return ApiResponse.success((Object)taskNumber);
    }

    public ApiResponse<Page<UnifiedTaskQueryVo>> queryFromHistory(Page<UnifiedTaskQueryVo> page, UnifiedTaskQueryDto unifiedTaskQueryDto) {
        unifiedTaskQueryDto.setStartUserId(unifiedTaskQueryDto.getUserId());
        if (!NumberUtil.isNumber((CharSequence)unifiedTaskQueryDto.getYear())) {
            return ApiResponse.success(page);
        }
        String tableName = UnifiedConstants.HISTORY_TABLE_TASK_PREFIX + unifiedTaskQueryDto.getYear();
        logger.info("tableName: " + tableName);
        if (!this.checkTableExist(tableName)) {
            return ApiResponse.success(page);
        }
        unifiedTaskQueryDto.setTableName(tableName);
        this.unifiedToDoMapper.queryFromHistory(page, unifiedTaskQueryDto);
        for (UnifiedTaskQueryVo record : page.getRecords()) {
            if (!HussarUtils.isNotEmpty((Object)record.getProcessState())) continue;
            record.setProcessStateStr(ProcessState.getProcessState((String)record.getProcessState()));
            record.setTaskDefKey("");
        }
        if (page.getRecords() != null && !page.getRecords().isEmpty()) {
            this.getFormAuth(page.getRecords(), "1");
        }
        return ApiResponse.success(page);
    }

    public ApiResponse<List<String>> queryHistoryYearList() {
        List<String> tableNameList = this.unifiedToDoMapper.queryHistoryTableList();
        if (HussarUtils.isEmpty(tableNameList)) {
            return ApiResponse.success(new ArrayList());
        }
        List yearList = tableNameList.stream().map(value -> {
            String[] split = value.split("_");
            return split[split.length - 1];
        }).collect(Collectors.toList());
        if (HussarUtils.isEmpty(yearList)) {
            return ApiResponse.success(new ArrayList());
        }
        List years = yearList.stream().distinct().sorted(Comparator.comparingInt(Integer::parseInt)).collect(Collectors.toList());
        return ApiResponse.success(years);
    }

    private boolean checkTableExist(String tableName) {
        return this.unifiedToDoMapper.checkTableExist(tableName) > 0L;
    }

    public void creatTable(String name, String type) {
        this.unifiedToDoMapper.creatTable(name, type);
    }

    public void dataArchiving() {
        Map<String, Date> dataArchivingTime = this.getDataArchivingTime();
        logger.info(String.valueOf(dataArchivingTime.get("filingTime")));
        logger.info(String.valueOf(dataArchivingTime.get("archivebufferTime")));
        logger.info(String.valueOf(dataArchivingTime.get("rectificationBufferTime")));
        ArrayList<String> processState = new ArrayList<String>(Arrays.asList("0", "3", "9"));
        ArrayList<String> rectificationState = new ArrayList<String>(Arrays.asList("3", "9"));
        logger.info("\u5f00\u59cb\u5f52\u6863\u666e\u901a\u6d41\u7a0b\u4efb\u52a1");
        this.dealProcessInfos(dataArchivingTime, processState, "archivebufferTime");
        logger.info("\u5f52\u6863\u666e\u901a\u6d41\u7a0b\u4efb\u52a1\u7ed3\u675f");
        logger.info("\u5f00\u59cb\u5f52\u6863\u8fd4\u56de\u6574\u6539\u6d41\u7a0b\u4efb\u52a1");
        this.dealProcessInfos(dataArchivingTime, rectificationState, "rectificationBufferTime");
        logger.info("\u5f52\u6863\u8fd4\u56de\u6574\u6539\u6d41\u7a0b\u4efb\u52a1\u7ed3\u675f");
    }

    private void dealProcessInfos(Map<String, Date> dataArchivingTime, List<String> processState, String type) {
        if (type.equals("archivebufferTime")) {
            while (true) {
                List processInfos;
                if (HussarUtils.isEmpty((Object)(processInfos = this.unifiedProcessInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().le(UnifiedProcessInfo::getStartTime, (Object)dataArchivingTime.get("filingTime"))).le(UnifiedProcessInfo::getEndTime, (Object)dataArchivingTime.get("archivebufferTime"))).notIn(UnifiedProcessInfo::getProcessState, processState)).last("limit 1000000"))))) {
                    return;
                }
                this.archiveProcessInfos(processInfos);
            }
        }
        if (type.equals("rectificationBufferTime")) {
            while (true) {
                List processInfos;
                if (HussarUtils.isEmpty((Object)(processInfos = this.unifiedProcessInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().le(UnifiedProcessInfo::getStartTime, (Object)dataArchivingTime.get("filingTime"))).le(UnifiedProcessInfo::getEndTime, (Object)dataArchivingTime.get("rectificationBufferTime"))).in(UnifiedProcessInfo::getProcessState, processState)).last("limit 1000000"))))) {
                    return;
                }
                this.archiveProcessInfos(processInfos);
            }
        }
    }

    public void archiveProcessInfos(List<UnifiedProcessInfo> processInfos) {
        Map<String, List<UnifiedProcessInfo>> processGroup = processInfos.stream().collect(Collectors.groupingBy(o -> String.valueOf(o.getStartTime().toInstant().atZone(ZoneId.systemDefault()).getYear())));
        for (Map.Entry<String, List<UnifiedProcessInfo>> process : processGroup.entrySet()) {
            List<UnifiedProcessInfo> unifiedProcessInfos = process.getValue();
            ArrayList<Long> delProcessIds = new ArrayList<Long>();
            ArrayList<String> procInstIds = new ArrayList<String>();
            ArrayList<UnifiedProcessInfo> addProcessInfoList = new ArrayList<UnifiedProcessInfo>();
            String year = process.getKey();
            logger.info("\u5f00\u59cb\u5f52\u6863" + year + "\u5e74\u7684\u6570\u636e");
            this.judgeYear(year);
            for (UnifiedProcessInfo unifiedProcessInfo : unifiedProcessInfos) {
                addProcessInfoList.add(unifiedProcessInfo);
                delProcessIds.add(unifiedProcessInfo.getProcInfoId());
                procInstIds.add(unifiedProcessInfo.getProcInstId());
                if (delProcessIds.size() < 100000) continue;
                this.addAndDeleteInfo(addProcessInfoList, delProcessIds, procInstIds, year);
                addProcessInfoList.clear();
                delProcessIds.clear();
                procInstIds.clear();
            }
            if (HussarUtils.isEmpty(delProcessIds)) continue;
            this.addAndDeleteInfo(addProcessInfoList, delProcessIds, procInstIds, year);
            logger.info("\u5f52\u6863" + year + "\u5e74\u7684\u6570\u636e\u7ed3\u675f");
        }
    }

    public void judgeYear(String year) {
        String taskTable;
        String userTable;
        logger.info("\u5f00\u59cb\u5904\u7406" + year + "\u5e74\u4efd\u7684\u8868\u7ed3\u6784");
        String processTable = this.unifiedToDoMapper.getTableName("SYS_UNIFIED_PROCESS_INFO_" + year);
        if (HussarUtils.isEmpty((Object)processTable)) {
            this.unifiedToDoMapper.creatTable("SYS_UNIFIED_PROCESS_INFO_" + year, "process");
        }
        if (HussarUtils.isEmpty((Object)(userTable = this.unifiedToDoMapper.getTableName("SYS_UNIFIED_TASK_USER_" + year)))) {
            this.unifiedToDoMapper.creatTable("SYS_UNIFIED_TASK_USER_" + year, "user");
        }
        if (HussarUtils.isEmpty((Object)(taskTable = this.unifiedToDoMapper.getTableName("SYS_UNIFIED_TASK_INFO_" + year)))) {
            this.unifiedToDoMapper.creatTable("SYS_UNIFIED_TASK_INFO_" + year, "task");
        }
        logger.info("\u5904\u7406" + year + "\u5e74\u4efd\u7684\u8868\u7ed3\u6784\u5b8c\u6210");
    }

    public void addAndDeleteInfo(List<UnifiedProcessInfo> addProcessInfos, List<Long> delProcessIds, List<String> procInstIds, String year) {
        ArrayList<Long> delTaskId = new ArrayList<Long>();
        ArrayList<String> taskIds = new ArrayList<String>();
        ArrayList<Long> delUserId = new ArrayList<Long>();
        logger.info("\u5f00\u59cb\u67e5\u8be2\u4efb\u52a1\u6570\u636e");
        List taskInfos = this.unifiedTaskInfoService.list((Wrapper)new LambdaQueryWrapper().in(UnifiedTaskInfo::getProcessInstanceid, procInstIds));
        logger.info("\u67e5\u8be2\u4efb\u52a1\u6570\u636e\u7ed3\u675f");
        for (UnifiedTaskInfo taskInfo : taskInfos) {
            taskIds.add(taskInfo.getTaskId());
        }
        logger.info("\u5f00\u59cb\u67e5\u8be2\u4eba\u5458\u4efb\u52a1\u6570\u636e");
        List taskUsers = this.unifiedTaskUserService.list((Wrapper)new LambdaUpdateWrapper().in(UnifiedTaskUser::getTaskId, taskIds));
        logger.info("\u67e5\u8be2\u4eba\u5458\u4efb\u52a1\u6570\u636e\u7ed3\u675f");
        ArrayList<UnifiedProcessInfo> processInfoList = new ArrayList<UnifiedProcessInfo>();
        ArrayList<Long> delProcess = new ArrayList<Long>();
        ArrayList<UnifiedTaskInfo> unifiedTaskInfos = new ArrayList<UnifiedTaskInfo>();
        ArrayList<UnifiedTaskUser> unifiedTaskUsers = new ArrayList<UnifiedTaskUser>();
        for (UnifiedProcessInfo addProcessInfo : addProcessInfos) {
            processInfoList.add(addProcessInfo);
            delProcess.add(addProcessInfo.getProcInfoId());
            if (delProcess.size() <= 5000) continue;
            logger.info("\u5f00\u59cb\u5f80SYS_UNIFIED_PROCESS_INFO_" + year + "\u8868\u4e2d\u6dfb\u52a0\u6570\u636e");
            this.unifiedToDoMapper.insertProcessBatch(processInfoList, "SYS_UNIFIED_PROCESS_INFO_" + year);
            logger.info("\u5f80SYS_UNIFIED_PROCESS_INFO_" + year + "\u8868\u4e2d\u6dfb\u52a0\u6570\u636e\u7ed3\u675f");
            logger.info("\u5f00\u59cb\u5f80SYS_UNIFIED_PROCESS_INFO\u8868\u4e2d\u5220\u9664\u6570\u636e");
            this.unifiedProcessInfoService.removeByIds(delProcess);
            logger.info("\u5f80SYS_UNIFIED_PROCESS_INFO\u8868\u4e2d\u5220\u9664\u6570\u636e\u5b8c\u6210");
            processInfoList.clear();
            delProcess.clear();
        }
        if (delProcess.size() > 0) {
            logger.info("\u5f00\u59cb\u5f80SYS_UNIFIED_PROCESS_INFO_" + year + "\u8868\u4e2d\u6dfb\u52a0\u6570\u636e");
            this.unifiedToDoMapper.insertProcessBatch(processInfoList, "SYS_UNIFIED_PROCESS_INFO_" + year);
            logger.info("\u5f80SYS_UNIFIED_PROCESS_INFO_" + year + "\u8868\u4e2d\u6dfb\u52a0\u6570\u636e\u7ed3\u675f");
            logger.info("\u5f00\u59cb\u5f80SYS_UNIFIED_PROCESS_INFO\u8868\u4e2d\u5220\u9664\u6570\u636e");
            this.unifiedProcessInfoService.removeByIds(delProcess);
            logger.info("\u5f80SYS_UNIFIED_PROCESS_INFO\u8868\u4e2d\u5220\u9664\u6570\u636e\u5b8c\u6210");
        }
        for (UnifiedTaskInfo taskInfo : taskInfos) {
            unifiedTaskInfos.add(taskInfo);
            delTaskId.add(taskInfo.getTodoId());
            if (delTaskId.size() <= 5000) continue;
            logger.info("\u5f00\u59cb\u5f80SYS_UNIFIED_TASK_INFO_" + year + "\u8868\u4e2d\u6dfb\u52a0\u6570\u636e");
            this.unifiedToDoMapper.insertTaskBatch(unifiedTaskInfos, "SYS_UNIFIED_TASK_INFO_" + year);
            logger.info("\u5f80SYS_UNIFIED_TASK_INFO_" + year + "\u8868\u4e2d\u6dfb\u52a0\u6570\u636e\u7ed3\u675f");
            logger.info("\u5f00\u59cb\u5f80SYS_UNIFIED_TASK_INFO\u8868\u4e2d\u5220\u9664\u6570\u636e");
            this.unifiedTaskInfoService.removeByIds(delTaskId);
            logger.info("\u5f80SYS_UNIFIED_TASK_INFO\u8868\u4e2d\u5220\u9664\u6570\u636e\u5b8c\u6210");
            unifiedTaskInfos.clear();
            delTaskId.clear();
        }
        if (delTaskId.size() > 0) {
            logger.info("\u5f00\u59cb\u5f80SYS_UNIFIED_TASK_INFO_" + year + "\u8868\u4e2d\u6dfb\u52a0\u6570\u636e");
            this.unifiedToDoMapper.insertTaskBatch(unifiedTaskInfos, "SYS_UNIFIED_TASK_INFO_" + year);
            logger.info("\u5f80SYS_UNIFIED_TASK_INFO_" + year + "\u8868\u4e2d\u6dfb\u52a0\u6570\u636e\u7ed3\u675f");
            logger.info("\u5f00\u59cb\u5f80SYS_UNIFIED_TASK_INFO\u8868\u4e2d\u5220\u9664\u6570\u636e");
            this.unifiedTaskInfoService.removeByIds(delTaskId);
            logger.info("\u5f80SYS_UNIFIED_TASK_INFO\u8868\u4e2d\u5220\u9664\u6570\u636e\u5b8c\u6210");
        }
        for (UnifiedTaskUser taskUser : taskUsers) {
            unifiedTaskUsers.add(taskUser);
            delUserId.add(taskUser.getUnifiedId());
            if (delUserId.size() <= 5000) continue;
            logger.info("\u5f00\u59cb\u5f80SYS_UNIFIED_TASK_USER_" + year + "\u8868\u4e2d\u6dfb\u52a0\u6570\u636e");
            this.unifiedToDoMapper.insertUserBatch(unifiedTaskUsers, "SYS_UNIFIED_TASK_USER_" + year);
            logger.info("\u5f80SYS_UNIFIED_TASK_USER_" + year + "\u8868\u4e2d\u6dfb\u52a0\u6570\u636e\u7ed3\u675f");
            logger.info("\u5f00\u59cb\u5f80SYS_UNIFIED_TASK_USER\u8868\u4e2d\u5220\u9664\u6570\u636e");
            this.unifiedTaskUserService.removeByIds(delUserId);
            logger.info("\u5f80SYS_UNIFIED_TASK_USER\u8868\u4e2d\u5220\u9664\u6570\u636e\u5b8c\u6210");
            unifiedTaskUsers.clear();
            delUserId.clear();
        }
        if (delUserId.size() > 0) {
            logger.info("\u5f00\u59cb\u5f80SYS_UNIFIED_TASK_USER_" + year + "\u8868\u4e2d\u6dfb\u52a0\u6570\u636e");
            this.unifiedToDoMapper.insertUserBatch(unifiedTaskUsers, "SYS_UNIFIED_TASK_USER_" + year);
            logger.info("\u5f80SYS_UNIFIED_TASK_USER_" + year + "\u8868\u4e2d\u6dfb\u52a0\u6570\u636e\u7ed3\u675f");
            logger.info("\u5f00\u59cb\u5f80SYS_UNIFIED_TASK_USER\u8868\u4e2d\u5220\u9664\u6570\u636e");
            this.unifiedTaskUserService.removeByIds(delUserId);
            logger.info("\u5f80SYS_UNIFIED_TASK_USER\u8868\u4e2d\u5220\u9664\u6570\u636e\u5b8c\u6210");
        }
    }

    public Map<String, Date> getDataArchivingTime() {
        logger.info("\u5f00\u59cb\u83b7\u53d6\u5f52\u6863\u5b57\u5178\u65e5\u671f");
        List dataArchiving = this.iSysDicRefService.getDictByType("dataArchiving");
        HashMap<String, String> map = new HashMap<String, String>();
        if (HussarUtils.isNotEmpty((Object)dataArchiving)) {
            for (DicSingle dicSingle : dataArchiving) {
                map.put(dicSingle.getLabel(), dicSingle.getValue());
            }
        }
        if (HussarUtils.isEmpty(map.get("filingTime"))) {
            throw new HussarException("\u5f52\u6863\u672a\u8bbe\u7f6e\u622a\u6b62\u65f6\u95f4");
        }
        if (HussarUtils.isEmpty(map.get("archivebufferTime"))) {
            throw new HussarException("\u5f52\u6863\u672a\u8bbe\u7f6e\u7f13\u51b2\u65f6\u95f4");
        }
        if (HussarUtils.isEmpty(map.get("rectificationBufferTime"))) {
            throw new HussarException("\u5f52\u6863\u672a\u8bbe\u7f6e\u8fd4\u56de\u6574\u6539\u7f13\u51b2\u65f6\u95f4");
        }
        Calendar filing = Calendar.getInstance();
        Calendar archiveBufferTime = Calendar.getInstance();
        Calendar rectificationBufferTime = Calendar.getInstance();
        filing.add(5, -Integer.parseInt((String)map.get("filingTime")));
        archiveBufferTime.add(5, -Integer.parseInt((String)map.get("archivebufferTime")));
        rectificationBufferTime.add(5, -Integer.parseInt((String)map.get("rectificationBufferTime")));
        HashMap<String, Date> dateMap = new HashMap<String, Date>();
        dateMap.put("filingTime", filing.getTime());
        dateMap.put("archivebufferTime", archiveBufferTime.getTime());
        dateMap.put("rectificationBufferTime", rectificationBufferTime.getTime());
        logger.info("\u5f52\u6863\u5b57\u5178\u65e5\u671f\u5904\u7406\u7ed3\u675f");
        return dateMap;
    }
}

