/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unifiedtodo.controller;

import com.jxdinfo.hussar.unifiedtodo.constant.DataPushResponse;
import com.jxdinfo.hussar.unifiedtodo.dto.ProcessDeleteDto;
import com.jxdinfo.hussar.unifiedtodo.dto.TaskAddBatchDto;
import com.jxdinfo.hussar.unifiedtodo.dto.TaskDeleteDto;
import com.jxdinfo.hussar.unifiedtodo.dto.TaskOrUserChangeDto;
import com.jxdinfo.hussar.unifiedtodo.dto.TaskUpdateDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UserAddBatchDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UserDeleteDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UserUpdateDto;
import com.jxdinfo.hussar.unifiedtodo.model.TaskInfoWithUser;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedProcessInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskUser;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/remoteUnified"})
@Api(tags={"\u7edf\u4e00\u5f85\u529e\u63a5\u53e3-\u5fae\u670d\u52a1"})
public class RemoteUnifiedTaskAndProcessController {
    @Autowired
    private IUnifiedTaskService unifiedTaskService;

    @PostMapping(value={"/taskChange"})
    public DataPushResponse<Object> taskChange(@RequestBody TaskOrUserChangeDto taskOrUserChangeDto) {
        this.unifiedTaskService.taskChangeClassify(taskOrUserChangeDto.getTaskChangeDto(), taskOrUserChangeDto.getTaskChangedDto());
        return DataPushResponse.success((String)"success");
    }

    @PostMapping(value={"/taskDeleteAndAdd"})
    public DataPushResponse<Object> taskDeleteAndAdd(@RequestBody TaskOrUserChangeDto taskOrUserChangeDto) {
        this.unifiedTaskService.taskChangeClassify(taskOrUserChangeDto.getTaskDeleteDto(), taskOrUserChangeDto.getTaskAddBatchDto());
        return DataPushResponse.success((String)"success");
    }

    @PostMapping(value={"/userChange"})
    public DataPushResponse<Object> userChange(@RequestBody TaskOrUserChangeDto taskOrUserChangeDto) {
        this.unifiedTaskService.userChangeClassify(taskOrUserChangeDto.getUserChangeDto(), taskOrUserChangeDto.getUnifiedTaskUser());
        return DataPushResponse.success((String)"success");
    }

    @PostMapping(value={"/userDeleteAndAdd"})
    public DataPushResponse<Object> userDeleteAndAdd(@RequestBody TaskOrUserChangeDto taskOrUserChangeDto) {
        this.unifiedTaskService.userChangeClassify(taskOrUserChangeDto.getUserDeleteDto(), taskOrUserChangeDto.getUserAddBatchDto());
        return DataPushResponse.success((String)"success");
    }

    @PostMapping(value={"/taskAddBatch"})
    public DataPushResponse<Object> taskAddBatch(@RequestBody TaskAddBatchDto taskAddBatchDto) {
        this.unifiedTaskService.taskAddBatchClassify(taskAddBatchDto);
        return DataPushResponse.success((String)"success");
    }

    @PostMapping(value={"/taskAdd"})
    public DataPushResponse<Object> taskAdd(@RequestBody TaskInfoWithUser taskInfoWithUser) {
        this.unifiedTaskService.taskAddClassify(taskInfoWithUser);
        return DataPushResponse.success((String)"success");
    }

    @PostMapping(value={"/taskDelete"})
    public DataPushResponse<Object> taskDelete(@RequestBody TaskDeleteDto taskDeleteDto) {
        this.unifiedTaskService.taskDeleteClassify(taskDeleteDto);
        return DataPushResponse.success((String)"success");
    }

    @PostMapping(value={"/taskUpdate"})
    public DataPushResponse<Object> taskUpdate(@RequestBody TaskUpdateDto taskUpdateDto) {
        this.unifiedTaskService.taskUpdateClassify(taskUpdateDto);
        return DataPushResponse.success((String)"success");
    }

    @PostMapping(value={"/userAddBatch"})
    public DataPushResponse<Object> userAddBatch(@RequestBody UserAddBatchDto userAddBatchDto) {
        this.unifiedTaskService.userAddBatchClassify(userAddBatchDto);
        return DataPushResponse.success((String)"success");
    }

    @PostMapping(value={"/userAdd"})
    public DataPushResponse<Object> userAdd(@RequestBody UnifiedTaskUser unifiedTaskUser) {
        this.unifiedTaskService.userAddClassify(unifiedTaskUser);
        return DataPushResponse.success((String)"success");
    }

    @PostMapping(value={"/userDelete"})
    public DataPushResponse<Object> userDelete(@RequestBody UserDeleteDto userDeleteDto) {
        this.unifiedTaskService.userDeleteClassify(userDeleteDto);
        return DataPushResponse.success((String)"success");
    }

    @PostMapping(value={"/userUpdate"})
    public DataPushResponse<Object> userUpdate(@RequestBody UserUpdateDto userUpdateDto) {
        this.unifiedTaskService.userUpdateClassify(userUpdateDto);
        return DataPushResponse.success((String)"success");
    }

    @PostMapping(value={"/processAdd"})
    public DataPushResponse<Object> processAdd(@RequestBody UnifiedProcessInfo processInfo) {
        this.unifiedTaskService.processAddClassify(processInfo);
        return DataPushResponse.success((String)"success");
    }

    @PostMapping(value={"/processUpdate"})
    public DataPushResponse<Object> processUpdate(@RequestBody UnifiedProcessInfo processInfo) {
        this.unifiedTaskService.processUpdateClassify(processInfo);
        return DataPushResponse.success((String)"success");
    }

    @PostMapping(value={"/processDelete"})
    public DataPushResponse<Object> processDelete(@RequestBody ProcessDeleteDto processInfo) {
        this.unifiedTaskService.processDeleteClassify(processInfo);
        return DataPushResponse.success((String)"success");
    }
}

