/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unifiedtodo.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.unifiedtodo.constant.ProcessState;
import com.jxdinfo.hussar.unifiedtodo.constant.UnifiedToDoConfigure;
import com.jxdinfo.hussar.unifiedtodo.dto.TaskNumber;
import com.jxdinfo.hussar.unifiedtodo.dto.UnifiedDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UnifiedTaskQueryDto;
import com.jxdinfo.hussar.unifiedtodo.response.UnifiedResponse;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedService;
import com.jxdinfo.hussar.unifiedtodo.vo.UnifiedTaskQueryVo;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/unified/unifiedtodo"})
public class UnifiedTaskController {
    @Autowired
    private IUnifiedService unifiedService;
    @Autowired
    private UnifiedToDoConfigure unifiedToDoConfigure;

    private String getOutUserId() {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user == null) {
            return null;
        }
        Object outUserId = null;
        if (this.unifiedToDoConfigure.getUserIdType().equals("outOriginId")) {
            outUserId = user.getExtendUserMap("outOriginId");
        } else if (this.unifiedToDoConfigure.getUserIdType().equals("outUserId")) {
            outUserId = user.getExtendUserMap("outUserId");
        }
        if (outUserId == null) {
            return null;
        }
        return String.valueOf(outUserId);
    }

    @PostMapping(value={"/unifiedPush"})
    public UnifiedResponse unifiedPush(@RequestBody UnifiedDto unifiedDto) {
        try {
            if (unifiedDto.getDataList() == null || Integer.parseInt(unifiedDto.getDataSize()) != unifiedDto.getDataList().size()) {
                return UnifiedResponse.paramFail();
            }
            HttpServletRequest request = HttpKit.getRequest();
            Long systemId = null;
            if (HussarUtils.isNotEmpty((Object)request)) {
                systemId = request.getHeader("systemId") != null ? Long.valueOf(request.getHeader("systemId")) : null;
            }
            return this.unifiedService.unifiedPush(unifiedDto, systemId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return UnifiedResponse.fail((String)e.getMessage());
        }
    }

    @GetMapping(value={"/queryTodoTask"})
    public ApiResponse<Page<UnifiedTaskQueryVo>> queryTodoTask(String sortColumn, String sortOrder, @RequestParam(required=false) String sendUserName, @RequestParam(required=false) String projectName, @RequestParam(required=false) String days) {
        int sortBy = "0".equals(sortColumn) ? 1 : ("1".equals(sortColumn) ? 2 : 3);
        String user = this.getOutUserId();
        if (user == null) {
            return ApiResponse.fail((String)"\u65e0\u767b\u5f55\u4eba");
        }
        return this.unifiedService.queryUnifiedTasks(new Page().setSize(-1L), new UnifiedTaskQueryDto().setUserId(user).setTaskType("1").setSortBy(sortBy).setAsc(Boolean.valueOf("asc".equals(sortOrder))).setCountDueDays(true).setDays(HussarUtils.isEmpty((Object)days) ? null : Integer.valueOf(days)).setSendUserName(sendUserName).setProjectName(projectName));
    }

    @GetMapping(value={"/queryTodoTaskNumber"})
    public ApiResponse<Long> queryTodoTaskNumber() {
        String user = this.getOutUserId();
        if (user == null) {
            return ApiResponse.fail((String)"\u65e0\u767b\u5f55\u4eba");
        }
        return this.unifiedService.queryUnifiedTaskNumber(new UnifiedTaskQueryDto().setUserId(user).setTaskType("1"));
    }

    @GetMapping(value={"/queryTodoTaskNumberExtend"})
    public ApiResponse<Long> queryTodoTaskNumberExtend(String userId) {
        if (userId == null || userId.equals("")) {
            return ApiResponse.fail((String)"\u65e0\u767b\u5f55\u4eba");
        }
        return this.unifiedService.queryUnifiedTaskNumber(new UnifiedTaskQueryDto().setUserId(userId).setTaskType("1"));
    }

    @GetMapping(value={"/queryPendingTask"})
    public ApiResponse<Page<UnifiedTaskQueryVo>> queryPendingTask() {
        String user = this.getOutUserId();
        if (user == null) {
            return ApiResponse.fail((String)"\u65e0\u767b\u5f55\u4eba");
        }
        return this.unifiedService.queryUnifiedTasks(new Page().setSize(-1L), new UnifiedTaskQueryDto().setUserId(user).setTaskType("2").setSortBy(1).setAsc(Boolean.valueOf(false)));
    }

    @GetMapping(value={"/queryPendingTaskNumber"})
    public ApiResponse<Long> queryPendingTaskNumber() {
        String user = this.getOutUserId();
        if (user == null) {
            return ApiResponse.fail((String)"\u65e0\u767b\u5f55\u4eba");
        }
        return this.unifiedService.queryUnifiedTaskNumber(new UnifiedTaskQueryDto().setUserId(user).setTaskType("2"));
    }

    @GetMapping(value={"/queryPendingTaskNumberExtend"})
    public ApiResponse<Long> queryPendingTaskNumberExtend(String userId) {
        if (userId == null || userId.equals("")) {
            return ApiResponse.fail((String)"\u65e0\u767b\u5f55\u4eba");
        }
        return this.unifiedService.queryUnifiedTaskNumber(new UnifiedTaskQueryDto().setUserId(userId).setTaskType("2"));
    }

    @GetMapping(value={"/queryTaskNumber"})
    public ApiResponse<TaskNumber> queryTaskNumber(String userId) {
        if (userId == null || userId.equals("")) {
            return ApiResponse.fail((String)"\u65e0\u767b\u5f55\u4eba");
        }
        return this.unifiedService.queryTaskNumber(userId);
    }

    @GetMapping(value={"/queryOverDueTask"})
    public ApiResponse<Page<UnifiedTaskQueryVo>> queryOverDueTask() {
        String user = this.getOutUserId();
        if (user == null) {
            return ApiResponse.fail((String)"\u65e0\u767b\u5f55\u4eba");
        }
        return this.unifiedService.queryUnifiedTasks(new Page().setSize(-1L), new UnifiedTaskQueryDto().setUserId(user).setTaskType("1").setSortBy(1).setAsc(Boolean.valueOf(false)).setOverDue(LocalDateTime.now()));
    }

    @GetMapping(value={"/queryUndoCcTask"})
    public ApiResponse<Page<UnifiedTaskQueryVo>> queryUndoCcTask() {
        String user = this.getOutUserId();
        if (user == null) {
            return ApiResponse.fail((String)"\u65e0\u767b\u5f55\u4eba");
        }
        return this.unifiedService.queryUnifiedTasks(new Page().setSize(-1L), new UnifiedTaskQueryDto().setUserId(user).setTaskType("4").setSortBy(2).setAsc(Boolean.valueOf(false)));
    }

    @GetMapping(value={"/queryUndoCcTaskNumber"})
    public ApiResponse<Long> queryUndoCcTaskNumber() {
        String user = this.getOutUserId();
        if (user == null) {
            return ApiResponse.fail((String)"\u65e0\u767b\u5f55\u4eba");
        }
        return this.unifiedService.queryUnifiedTaskNumber(new UnifiedTaskQueryDto().setUserId(user).setTaskType("5"));
    }

    @GetMapping(value={"/queryUndoCcTaskNumberExtend"})
    public ApiResponse<Long> queryUndoCcTaskNumberExtend(String userId) {
        if (userId == null || userId.equals("")) {
            return ApiResponse.fail((String)"\u65e0\u767b\u5f55\u4eba");
        }
        return this.unifiedService.queryUnifiedTaskNumber(new UnifiedTaskQueryDto().setUserId(userId).setTaskType("5"));
    }

    @GetMapping(value={"/queryRectificationNumberExtend"})
    public ApiResponse<Long> queryRectificationNumberExtend(String userId) {
        if (userId == null || userId.equals("")) {
            return ApiResponse.fail((String)"\u65e0\u767b\u5f55\u4eba");
        }
        return this.unifiedService.queryRectificationNumberExtend(userId, ProcessState.RECTIFICATION.getValue());
    }

    @GetMapping(value={"/queryDoneCcTask"})
    public ApiResponse<Page<UnifiedTaskQueryVo>> queryDoneCcTask(@RequestParam Long current, @RequestParam Long size, @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") LocalDateTime startTime, @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") LocalDateTime endTime, @RequestParam(required=false) HashSet<String> unitId, @RequestParam(required=false) HashSet<String> processState, @RequestParam(required=false) String sendUserName, @RequestParam(required=false) String projectName, String deptName, String processName) {
        String user = this.getOutUserId();
        if (user == null) {
            return ApiResponse.fail((String)"\u65e0\u767b\u5f55\u4eba");
        }
        UnifiedTaskQueryDto unifiedTaskQueryDto = new UnifiedTaskQueryDto().setUserId(user).setTaskType("5").setSortBy(2).setAsc(Boolean.valueOf(false));
        if (HussarUtils.isNotEmpty((Object)startTime)) {
            unifiedTaskQueryDto.setTaskCompleteTimeStart(startTime);
        }
        if (HussarUtils.isNotEmpty((Object)endTime)) {
            unifiedTaskQueryDto.setTaskCompleteTimeEnd(endTime);
        }
        if (HussarUtils.isNotEmpty(unitId)) {
            unifiedTaskQueryDto.setUnitIds(unitId);
        }
        if (HussarUtils.isNotEmpty(processState)) {
            for (String s : processState) {
                if (!s.equals("3")) continue;
                processState.add("9");
                break;
            }
            unifiedTaskQueryDto.setProcessStates(processState);
        }
        if (HussarUtils.isNotEmpty((Object)deptName)) {
            unifiedTaskQueryDto.setProcessDeptName(deptName);
        }
        if (HussarUtils.isNotEmpty((Object)processName)) {
            unifiedTaskQueryDto.setProcessName(processName);
        }
        if (HussarUtils.isNotEmpty((Object)projectName)) {
            unifiedTaskQueryDto.setProjectName(projectName);
        }
        if (HussarUtils.isNotEmpty((Object)sendUserName)) {
            unifiedTaskQueryDto.setSendUserName(sendUserName);
        }
        return this.unifiedService.queryDoneCcTask(new Page().setCurrent(current.longValue()).setSize(size.longValue()), unifiedTaskQueryDto);
    }

    @GetMapping(value={"/queryDoneTask"})
    public ApiResponse<Page<UnifiedTaskQueryVo>> queryDoneTask(@RequestParam Long current, @RequestParam Long size, @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") LocalDateTime startTime, @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") LocalDateTime endTime, @RequestParam(required=false) HashSet<String> unitId, @RequestParam(required=false) HashSet<String> processState, @RequestParam(required=false) String processInstId, @RequestParam(required=false) String sendUserName, @RequestParam(required=false) String projectName, String deptName, String processName) {
        String user = this.getOutUserId();
        if (user == null) {
            return ApiResponse.fail((String)"\u65e0\u767b\u5f55\u4eba");
        }
        UnifiedTaskQueryDto unifiedTaskQueryDto = new UnifiedTaskQueryDto().setUserId(user).setTaskType("3").setSortBy(2).setAsc(Boolean.valueOf(false));
        if (HussarUtils.isNotEmpty((Object)startTime)) {
            unifiedTaskQueryDto.setTaskCompleteTimeStart(startTime);
        }
        if (HussarUtils.isNotEmpty((Object)processInstId)) {
            unifiedTaskQueryDto.setProcessInstId(processInstId);
        }
        if (HussarUtils.isNotEmpty((Object)endTime)) {
            unifiedTaskQueryDto.setTaskCompleteTimeEnd(endTime);
        }
        if (HussarUtils.isNotEmpty(unitId)) {
            unifiedTaskQueryDto.setUnitIds(unitId);
        }
        if (HussarUtils.isNotEmpty(processState)) {
            for (String s : processState) {
                if (!s.equals("3")) continue;
                processState.add("9");
                break;
            }
            unifiedTaskQueryDto.setProcessStates(processState);
        }
        if (HussarUtils.isNotEmpty((Object)deptName)) {
            unifiedTaskQueryDto.setProcessDeptName(deptName);
        }
        if (HussarUtils.isNotEmpty((Object)processName)) {
            unifiedTaskQueryDto.setProcessName(processName);
        }
        if (HussarUtils.isNotEmpty((Object)projectName)) {
            unifiedTaskQueryDto.setProjectName(projectName);
        }
        if (HussarUtils.isNotEmpty((Object)sendUserName)) {
            unifiedTaskQueryDto.setSendUserName(sendUserName);
        }
        return this.unifiedService.queryDoneTask(new Page().setCurrent(current.longValue()).setSize(size.longValue()), unifiedTaskQueryDto);
    }

    @GetMapping(value={"/queryMyTask"})
    public ApiResponse<Page<UnifiedTaskQueryVo>> queryMyTask(@RequestParam Long current, @RequestParam Long size, @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") LocalDateTime startTime, @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") LocalDateTime endTime, @RequestParam(required=false) HashSet<String> unitId, @RequestParam(required=false) HashSet<String> processState, @RequestParam(required=false) String sendUserName, @RequestParam(required=false) String projectName, String deptName, String processName) {
        String user = this.getOutUserId();
        if (user == null) {
            return ApiResponse.fail((String)"\u65e0\u767b\u5f55\u4eba");
        }
        UnifiedTaskQueryDto unifiedTaskQueryDto = new UnifiedTaskQueryDto().setUserId(user).setSortBy(1).setAsc(Boolean.valueOf(false));
        if (HussarUtils.isNotEmpty((Object)startTime)) {
            unifiedTaskQueryDto.setTaskCompleteTimeStart(startTime);
        }
        if (HussarUtils.isNotEmpty((Object)endTime)) {
            unifiedTaskQueryDto.setTaskCompleteTimeEnd(endTime);
        }
        if (HussarUtils.isNotEmpty(unitId)) {
            unifiedTaskQueryDto.setUnitIds(unitId);
        }
        if (HussarUtils.isNotEmpty(processState)) {
            for (String s : processState) {
                if (!s.equals("3")) continue;
                processState.add("9");
                break;
            }
            unifiedTaskQueryDto.setProcessStates(processState);
        }
        if (HussarUtils.isNotEmpty((Object)deptName)) {
            unifiedTaskQueryDto.setProcessDeptName(deptName);
        }
        if (HussarUtils.isNotEmpty((Object)processName)) {
            unifiedTaskQueryDto.setProcessName(processName);
        }
        if (HussarUtils.isNotEmpty((Object)projectName)) {
            unifiedTaskQueryDto.setProjectName(projectName);
        }
        if (HussarUtils.isNotEmpty((Object)sendUserName)) {
            unifiedTaskQueryDto.setSendUserName(sendUserName);
        }
        return this.unifiedService.queryUnifiedMyTask(new Page().setCurrent(current.longValue()).setSize(size.longValue()), unifiedTaskQueryDto);
    }

    @GetMapping(value={"/queryAllTask"})
    public ApiResponse<Page<UnifiedTaskQueryVo>> queryAllTask(@RequestParam Long current, @RequestParam Long size, @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") LocalDateTime startTime, @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") LocalDateTime endTime, @RequestParam(required=false) HashSet<String> unitId, @RequestParam(required=false) HashSet<String> processState, String deptName, String processName) {
        UnifiedTaskQueryDto unifiedTaskQueryDto = new UnifiedTaskQueryDto().setSortBy(1).setAsc(Boolean.valueOf(false));
        if (HussarUtils.isNotEmpty((Object)startTime)) {
            unifiedTaskQueryDto.setTaskCompleteTimeStart(startTime);
        }
        if (HussarUtils.isNotEmpty((Object)endTime)) {
            unifiedTaskQueryDto.setTaskCompleteTimeEnd(endTime);
        }
        if (HussarUtils.isNotEmpty(unitId)) {
            unifiedTaskQueryDto.setUnitIds(unitId);
        }
        if (HussarUtils.isNotEmpty(processState)) {
            unifiedTaskQueryDto.setProcessStates(processState);
        }
        if (HussarUtils.isNotEmpty((Object)deptName)) {
            unifiedTaskQueryDto.setProcessDeptName(deptName);
        }
        if (HussarUtils.isNotEmpty((Object)processName)) {
            unifiedTaskQueryDto.setProcessName(processName);
        }
        return this.unifiedService.queryUnifiedTask(new Page().setCurrent(current.longValue()).setSize(size.longValue()), unifiedTaskQueryDto);
    }

    @GetMapping(value={"/queryRectification"})
    public ApiResponse<Page<UnifiedTaskQueryVo>> queryRectification() {
        String user = this.getOutUserId();
        if (user == null) {
            return ApiResponse.fail((String)"\u65e0\u767b\u5f55\u4eba");
        }
        return this.unifiedService.queryRectification(new Page().setSize(-1L), new UnifiedTaskQueryDto().setStartUserId(user).setProcessStates(Collections.singleton(ProcessState.RECTIFICATION.getValue())).setAsc(Boolean.valueOf(false)).setOnlyQueryProcess(true));
    }

    @GetMapping(value={"/queryRectificationNumber"})
    public ApiResponse<Long> queryRectificationNumber() {
        String user = this.getOutUserId();
        if (user == null) {
            return ApiResponse.fail((String)"\u65e0\u767b\u5f55\u4eba");
        }
        return this.unifiedService.queryUnifiedTaskNumber(new UnifiedTaskQueryDto().setStartUserId(user).setProcessStates(Collections.singleton(ProcessState.RECTIFICATION.getValue())).setOnlyQueryProcess(true));
    }
}

