/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unifiedtodo.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.AbstractLambdaWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.audit.core.support.dto.AuditLogModel;
import com.jxdinfo.hussar.support.audit.core.util.AuditLogUtils;
import com.jxdinfo.hussar.unifiedtodo.config.UnifiedTodoProperties;
import com.jxdinfo.hussar.unifiedtodo.constant.ProcessState;
import com.jxdinfo.hussar.unifiedtodo.dto.ProcessDeleteDto;
import com.jxdinfo.hussar.unifiedtodo.dto.TaskAddBatchDto;
import com.jxdinfo.hussar.unifiedtodo.dto.TaskChangeDto;
import com.jxdinfo.hussar.unifiedtodo.dto.TaskChangedDto;
import com.jxdinfo.hussar.unifiedtodo.dto.TaskDeleteDto;
import com.jxdinfo.hussar.unifiedtodo.dto.TaskUpdateDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UserAddBatchDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UserChangeDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UserDeleteDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UserUpdateDto;
import com.jxdinfo.hussar.unifiedtodo.model.TaskInfoWithUser;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedProcessInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskUser;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedProcessInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedSystemInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskUserService;
import com.jxdinfo.hussar.unifiedtodo.utils.HttpClientUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnifiedTaskServiceImpl
implements IUnifiedTaskService {
    @Autowired
    private IUnifiedSystemInfoService unifiedSystemInfoService;
    @Autowired
    private IUnifiedTaskInfoService unifiedTaskInfoService;
    @Autowired
    private IUnifiedTaskUserService unifiedTaskUserService;
    @Autowired
    private IUnifiedProcessInfoService unifiedProcessInfoService;
    private static final String MODULE_NAME = "OA-\u6570\u636e\u63a8\u9001";
    @Resource
    private UnifiedTodoProperties unifiedTodoProperties;
    @Resource
    private ISysUsersService usersService;
    private static final Logger logger = LoggerFactory.getLogger(UnifiedTaskServiceImpl.class);

    public ApiResponse<String> taskChange(TaskChangeDto taskChangeDto, TaskChangedDto taskChangedDto) {
        LambdaQueryWrapper wrapper;
        ApiResponse isBuildSuccess = taskChangeDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        if (taskChangedDto == null) {
            wrapper = new LambdaQueryWrapper();
            taskChangeDto.buildWrapper((AbstractLambdaWrapper)wrapper);
            this.unifiedTaskInfoService.remove((Wrapper)wrapper);
        } else {
            wrapper = new LambdaUpdateWrapper();
            taskChangeDto.buildWrapper((AbstractLambdaWrapper)wrapper);
            taskChangedDto.buildWrapper((LambdaUpdateWrapper)wrapper);
            this.unifiedTaskInfoService.update((Wrapper)wrapper);
        }
        if (this.unifiedTodoProperties.getOpen()) {
            logger.info("taskIds" + taskChangeDto.getTaskIds());
            List taskInfoList = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskInfo::getTaskId, (Collection)taskChangeDto.getTaskIds())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"3"));
            if (CollectionUtil.isEmpty((Collection)taskInfoList)) {
                taskInfoList = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskInfo::getTaskId, (Collection)taskChangeDto.getTaskIds())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"5"));
                logger.info("readSize" + taskInfoList.size());
            }
            logger.info("taskSize:" + taskInfoList.size());
            if (CollectionUtil.isNotEmpty((Collection)taskInfoList)) {
                for (UnifiedTaskInfo unifiedTaskInfo : taskInfoList) {
                    logger.info("taskInfo:" + JSON.toJSONString((Object)unifiedTaskInfo));
                    List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskInfo.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskInfo.getSystemId()));
                    this.pushTaskToOa(unifiedTaskInfo, taskUsers, null);
                }
            }
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> taskChange(TaskDeleteDto taskDeleteDto, TaskAddBatchDto taskAddBatchDto) {
        ApiResponse<String> isDeleteSuccess;
        if (taskDeleteDto != null && !(isDeleteSuccess = this.taskDelete(taskDeleteDto)).isSuccess()) {
            return isDeleteSuccess;
        }
        if (taskAddBatchDto != null) {
            return this.taskAddBatch(taskAddBatchDto);
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> userChange(UserChangeDto userChangeDto, UnifiedTaskUser unifiedTaskUser) {
        ApiResponse isBuildSuccess = userChangeDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        if (unifiedTaskUser == null) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            userChangeDto.buildWrapper((AbstractLambdaWrapper)wrapper);
            this.unifiedTaskUserService.remove((Wrapper)wrapper);
        } else {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            userChangeDto.buildWrapper((AbstractLambdaWrapper)wrapper);
            this.unifiedTaskUserService.update((Object)unifiedTaskUser, (Wrapper)wrapper);
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> userChange(UserDeleteDto userDeleteDto, UserAddBatchDto userAddBatchDto) {
        ApiResponse<String> isDeleteSuccess;
        if (userDeleteDto != null && !(isDeleteSuccess = this.userDelete(userDeleteDto)).isSuccess()) {
            return isDeleteSuccess;
        }
        if (userAddBatchDto != null) {
            return this.userAddBatch(userAddBatchDto);
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> taskAddBatch(TaskAddBatchDto taskAddBatchDto) {
        ApiResponse isBuildSuccess = taskAddBatchDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        ArrayList taskInfos = new ArrayList();
        ArrayList taskUsers = new ArrayList();
        taskAddBatchDto.getTaskInfos().forEach(taskInfoWithUser -> {
            taskInfos.add(taskInfoWithUser.getTaskInfo());
            if (taskInfoWithUser.getTaskUsers() != null) {
                taskUsers.addAll(taskInfoWithUser.getTaskUsers());
            }
        });
        this.unifiedTaskInfoService.saveBatch(taskInfos);
        if (HussarUtils.isNotEmpty(taskUsers)) {
            this.unifiedTaskUserService.saveBatch(taskUsers);
        }
        if (this.unifiedTodoProperties.getOpen() && CollectionUtil.isNotEmpty(taskInfos)) {
            logger.info("\u6284\u9001\u63a8\u9001\u5f00\u59cb");
            for (UnifiedTaskInfo taskInfo : taskInfos) {
                List<Object> resultList;
                List<UnifiedTaskUser> partList = taskUsers.stream().filter(u -> u.getTaskId().equals(taskInfo.getTaskId())).collect(Collectors.toList());
                if ("4".equals(taskInfo.getTaskStatus())) {
                    List allIdList;
                    List allUserList;
                    List allList = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getProcessInstanceid, (Object)taskInfo.getProcessInstanceid())).ne(UnifiedTaskInfo::getTaskId, (Object)taskInfo.getTaskId()));
                    if (!CollectionUtil.isNotEmpty((Collection)allList) || !CollectionUtil.isNotEmpty((Collection)(allUserList = this.unifiedTaskUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskUser::getTaskId, allIdList = allList.stream().map(UnifiedTaskInfo::getTaskId).collect(Collectors.toList()))).eq(UnifiedTaskUser::getSystemId, (Object)taskInfo.getSystemId()))))) continue;
                    List allUserIds = allUserList.stream().map(UnifiedTaskUser::getUserId).collect(Collectors.toList());
                    resultList = partList.stream().filter(u -> !allUserIds.contains(u.getUserId())).collect(Collectors.toList());
                } else {
                    resultList = partList;
                }
                this.pushTaskToOa(taskInfo, resultList, null);
            }
            if ("2".equals(((UnifiedTaskInfo)taskInfos.get(0)).getTaskStatus())) {
                logger.info("\u5f85\u5ba1\u63a8\u9001\u5f00\u59cb");
                List taskInfoList = this.unifiedTaskInfoService.list((Wrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getProcessInstanceid, (Object)((UnifiedTaskInfo)taskInfos.get(0)).getProcessInstanceid()));
                List ccList = taskInfoList.stream().filter(t -> "4".equals(t.getTaskStatus())).collect(Collectors.toList());
                List unCcList = taskInfoList.stream().filter(t -> !"4".equals(t.getTaskStatus())).collect(Collectors.toList());
                if (CollectionUtil.isEmpty(ccList)) {
                    return ApiResponse.success((Object)"", null);
                }
                List taskIdList = taskInfoList.stream().map(UnifiedTaskInfo::getTaskId).collect(Collectors.toList());
                List taskUserList = this.unifiedTaskUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskUser::getTaskId, taskIdList)).eq(UnifiedTaskUser::getSystemId, (Object)((UnifiedTaskInfo)taskInfos.get(0)).getSystemId()));
                if (CollectionUtil.isEmpty((Collection)taskUserList)) {
                    return ApiResponse.success((Object)"", null);
                }
                List ccTaskIdList = ccList.stream().map(UnifiedTaskInfo::getTaskId).collect(Collectors.toList());
                List unCcTaskIdList = unCcList.stream().map(UnifiedTaskInfo::getTaskId).collect(Collectors.toList());
                List ccUserList = taskUserList.stream().filter(t -> ccTaskIdList.contains(t.getTaskId())).collect(Collectors.toList());
                List unCcUserIdList = taskUserList.stream().filter(t -> unCcTaskIdList.contains(t.getTaskId())).map(UnifiedTaskUser::getUserId).collect(Collectors.toList());
                for (UnifiedTaskInfo unifiedTaskInfo : ccList) {
                    logger.info("\u6d41\u7a0b\u914d\u7f6e\u7684\u6284\u9001\u6570\u636e:" + JSON.toJSONString((Object)unifiedTaskInfo));
                    List partUserList = ccUserList.stream().filter(c -> c.getTaskId().equals(unifiedTaskInfo.getTaskId())).collect(Collectors.toList());
                    if (CollectionUtil.isEmpty(partUserList)) continue;
                    List<UnifiedTaskUser> unifiedTaskUsers = partUserList.stream().filter(p -> !unCcUserIdList.contains(p.getUserId())).collect(Collectors.toList());
                    this.pushTaskToOa(unifiedTaskInfo, unifiedTaskUsers, null);
                }
            }
        }
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> taskAdd(TaskInfoWithUser taskInfoWithUser) {
        ApiResponse isBuildSuccess = taskInfoWithUser.buildAllInfoForTaskAdd();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        this.unifiedTaskInfoService.save((Object)taskInfoWithUser.getTaskInfo());
        if (HussarUtils.isNotEmpty((Object)taskInfoWithUser.getTaskUsers())) {
            this.unifiedTaskUserService.saveBatch((Collection)taskInfoWithUser.getTaskUsers());
        }
        if (this.unifiedTodoProperties.getOpen()) {
            UnifiedTaskInfo taskInfo = taskInfoWithUser.getTaskInfo();
            List taskUsers = taskInfoWithUser.getTaskUsers();
            this.pushTaskToOa(taskInfo, taskUsers, null);
        }
        return ApiResponse.success((Object)"", null);
    }

    private void pushTaskToOa(UnifiedTaskInfo taskInfo, List<UnifiedTaskUser> taskUsers, UnifiedProcessInfo unifiedProcessInfo) {
        if (CollectionUtil.isEmpty(taskUsers)) {
            return;
        }
        logger.info("taskInfo:" + JSON.toJSONString((Object)taskInfo));
        for (UnifiedTaskUser taskUser : taskUsers) {
            logger.info("taskUser:" + JSON.toJSONString((Object)taskUser));
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            UnifiedProcessInfo processInfo = !HussarUtils.isNull((Object)unifiedProcessInfo) ? unifiedProcessInfo : (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)taskInfo.getProcessInstanceid()));
            if (HussarUtils.isNull((Object)processInfo)) {
                return;
            }
            String sendUserString = processInfo.getStartUserId();
            SysUsers sendUser = this.usersService.getUserByOutOriginId(sendUserString);
            SysUsers receiver = this.usersService.getUserByOutOriginId(taskUser.getUserId());
            if (HussarUtils.isNull((Object)sendUser) || HussarUtils.isNull((Object)receiver)) {
                this.HandlerLog(sendUserString, taskInfo.getCreateUserId());
                return;
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("syscode", this.unifiedTodoProperties.getOaThirdCode());
            data.put("flowid", taskInfo.getProcessInstanceid());
            data.put("requestname", processInfo.getProcessName());
            data.put("workflowname", processInfo.getProcessName());
            data.put("nodename", taskInfo.getTaskName());
            data.put("appurl", taskInfo.getMobileLinkurl());
            String flowState = this.getFlowState(processInfo, data, taskInfo);
            if (HussarUtils.isNull((Object)flowState)) {
                return;
            }
            data.put("isremark", flowState);
            data.put("viewtype", this.getReadState(taskInfo.getTaskStatus()));
            data.put("creator", sendUser.getUserAccount());
            data.put("createdatetime", sf.format(processInfo.getStartTime()));
            data.put("receiver", receiver.getUserAccount());
            data.put("receivedatetime", sf.format(taskInfo.getCreateTime()));
            data.put("receivets", String.valueOf(System.currentTimeMillis()));
            try {
                String resultData = JSON.toJSONString(data);
                logger.info("requestParam:" + resultData);
                String resp = HttpClientUtil.httpPost(this.unifiedTodoProperties.getReceiveDataUrl(), resultData, null);
                logger.info("responseParam:" + resp);
                JSONObject jsonObject = JSON.parseObject((String)resp);
                if (!jsonObject.get((Object)"operResult").equals("0")) continue;
                this.HandlerLog(sendUserString, taskInfo.getCreateUserId());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.HandlerLog(sendUserString, taskInfo.getCreateUserId());
            }
        }
    }

    private void HandlerLog(String userId, String userName) {
        UserDetails userDetails = new UserDetails();
        AuditLogModel auditLogModel = new AuditLogModel();
        auditLogModel.setModuleName(MODULE_NAME);
        auditLogModel.setEventGrade(AuditEventGrade.SERVICE_LOG_TYPE);
        auditLogModel.setEventType(AuditEventType.EXCEPTION);
        auditLogModel.setEventDesc("\u7528\u6237\u8bbf\u95eeOA-\u6570\u636e\u63a8\u9001");
        userDetails.setUserIdStr(userId);
        userDetails.setUserName(userName);
        auditLogModel.setUserDetails(userDetails);
        AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
    }

    private String getFlowState(UnifiedProcessInfo processInfo, Map<String, Object> data, UnifiedTaskInfo taskInfo) {
        if ("1".equals(taskInfo.getTaskStatus())) {
            data.put("pcurl", this.unifiedTodoProperties.getToBe() + "%2526taskId=" + taskInfo.getTaskId());
            logger.info("pcurl:" + data.get("pcurl"));
            return "0";
        }
        if ("3".equals(taskInfo.getTaskStatus()) && ProcessState.RUNNING.getValue().equals(processInfo.getProcessState()) || "5".equals(taskInfo.getTaskStatus())) {
            data.put("pcurl", this.unifiedTodoProperties.getToDoList() + "%2526processInstId=" + taskInfo.getProcessInstanceid());
            logger.info("pcurl:" + data.get("pcurl"));
            return "2";
        }
        if ("3".equals(taskInfo.getTaskStatus())) {
            data.put("pcurl", this.unifiedTodoProperties.getToDoList() + "%2526processInstId=" + taskInfo.getProcessInstanceid());
            logger.info("pcurl:" + data.get("pcurl"));
            return "4";
        }
        if ("4".equals(taskInfo.getTaskStatus())) {
            data.put("pcurl", this.unifiedTodoProperties.getToUnRead() + "%2526taskId=" + taskInfo.getTaskId());
            logger.info("pcurl:" + data.get("pcurl"));
            return "8";
        }
        return null;
    }

    private String getReadState(String readState) {
        if ("4".equals(readState)) {
            return "0";
        }
        if ("5".equals(readState)) {
            return "1";
        }
        return "0";
    }

    public ApiResponse<String> taskDelete(TaskDeleteDto taskDeleteDto) {
        List taskInfos;
        ApiResponse isBuildSuccess = taskDeleteDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        LambdaQueryWrapper unifiedTaskInfoQuery = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)taskDeleteDto.getProcInstId()), UnifiedTaskInfo::getProcessInstanceid, (Object)taskDeleteDto.getProcInstId())).in(HussarUtils.isNotEmpty((Object)taskDeleteDto.getTaskIds()), UnifiedTaskInfo::getTaskId, (Collection)taskDeleteDto.getTaskIds())).in(HussarUtils.isNotEmpty((Object)taskDeleteDto.getTaskTypes()), UnifiedTaskInfo::getTaskStatus, (Collection)taskDeleteDto.getTaskTypes())).eq(UnifiedTaskInfo::getSystemId, (Object)taskDeleteDto.getSystemId());
        if (taskDeleteDto.isCascade() && !(taskInfos = this.unifiedTaskInfoService.list((Wrapper)unifiedTaskInfoQuery)).isEmpty()) {
            this.unifiedTaskUserService.remove((Wrapper)new LambdaQueryWrapper().in(UnifiedTaskUser::getTaskId, (Collection)taskInfos.stream().map(UnifiedTaskInfo::getTaskId).collect(Collectors.toSet())));
        }
        this.unifiedTaskInfoService.remove((Wrapper)unifiedTaskInfoQuery);
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> taskUpdate(TaskUpdateDto taskUpdateDto) {
        ApiResponse isBuildSuccess = taskUpdateDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        String taskId = taskUpdateDto.getTaskId();
        if (taskUpdateDto.getUpdateCompleteTime() != null) {
            this.unifiedTaskUserService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)taskId)).eq(UnifiedTaskUser::getSystemId, (Object)taskUpdateDto.getSystemId())).set(UnifiedTaskUser::getCompleteTime, (Object)taskUpdateDto.getUpdateCompleteTime()));
        }
        if (!HussarUtils.isAllEmpty((Object[])new Object[]{taskUpdateDto.getUpdateTaskType(), taskUpdateDto.getUpdateDeadLine()})) {
            this.unifiedTaskInfoService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)taskId)).eq(UnifiedTaskInfo::getSystemId, (Object)taskUpdateDto.getSystemId())).set(HussarUtils.isNotEmpty((Object)taskUpdateDto.getUpdateTaskType()), UnifiedTaskInfo::getTaskStatus, (Object)taskUpdateDto.getUpdateTaskType())).set(HussarUtils.isNotEmpty((Object)taskUpdateDto.getUpdateDeadLine()), UnifiedTaskInfo::getDeadLine, (Object)taskUpdateDto.getUpdateDeadLine()));
        }
        if (this.unifiedTodoProperties.getOpen()) {
            List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)taskId)).eq(UnifiedTaskUser::getSystemId, (Object)taskUpdateDto.getSystemId()));
            UnifiedTaskInfo taskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)taskId));
            this.pushTaskToOa(taskInfo, taskUsers, null);
        }
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> userAddBatch(UserAddBatchDto userAddBatchDto) {
        List taskUsers;
        List taskIdList;
        List taskInfoList;
        ApiResponse isBuildSuccess = userAddBatchDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        this.unifiedTaskUserService.saveBatch((Collection)userAddBatchDto.getTaskUsers());
        if (this.unifiedTodoProperties.getOpen() && CollectionUtil.isNotEmpty((Collection)(taskInfoList = this.unifiedTaskInfoService.list((Wrapper)new LambdaQueryWrapper().in(UnifiedTaskInfo::getTaskId, taskIdList = (taskUsers = userAddBatchDto.getTaskUsers()).stream().map(UnifiedTaskUser::getTaskId).collect(Collectors.toList())))))) {
            for (UnifiedTaskInfo unifiedTaskInfo : taskInfoList) {
                List<UnifiedTaskUser> partList = taskUsers.stream().filter(t -> t.getTaskId().equals(unifiedTaskInfo.getTaskId())).collect(Collectors.toList());
                unifiedTaskInfo.setTaskStatus("1");
                this.pushTaskToOa(unifiedTaskInfo, partList, null);
            }
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> userAdd(UnifiedTaskUser unifiedTaskUser) {
        ApiResponse isBuildSuccess = unifiedTaskUser.buildAllInfoForUserAdd();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        this.unifiedTaskUserService.save((Object)unifiedTaskUser);
        return ApiResponse.success();
    }

    public ApiResponse<String> userDelete(UserDeleteDto userDeleteDto) {
        ApiResponse isBuildSuccess = userDeleteDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        if (this.unifiedTodoProperties.getOpen()) {
            logger.info("\u6d41\u7a0b\u5e73\u53f0\u5207\u6362\u8282\u70b9\u5ba1\u6279\u4eba\u6570\u636e\u63a8\u9001\u5f00\u59cb");
            if (CollectionUtil.isNotEmpty((Collection)userDeleteDto.getTaskIds())) {
                List unifiedTaskInfoList = this.unifiedTaskInfoService.list((Wrapper)new LambdaQueryWrapper().in(UnifiedTaskInfo::getTaskId, (Collection)userDeleteDto.getTaskIds()));
                logger.info("taskInfoSize:" + unifiedTaskInfoList.size());
                if (CollectionUtil.isNotEmpty((Collection)unifiedTaskInfoList)) {
                    UnifiedTaskInfo unifiedTaskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)userDeleteDto.getTaskId()));
                    if (!Objects.isNull(unifiedTaskInfo)) {
                        unifiedTaskInfoList.add(unifiedTaskInfo);
                    }
                    for (UnifiedTaskInfo taskInfo : unifiedTaskInfoList) {
                        List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)taskInfo.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)taskInfo.getSystemId()));
                        taskInfo.setTaskStatus("3");
                        this.pushTaskToOa(taskInfo, taskUsers, null);
                    }
                } else {
                    UnifiedTaskInfo unifiedTaskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)userDeleteDto.getTaskId()));
                    if (!Objects.isNull(unifiedTaskInfo)) {
                        List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskInfo.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskInfo.getSystemId()));
                        unifiedTaskInfo.setTaskStatus("3");
                        this.pushTaskToOa(unifiedTaskInfo, taskUsers, null);
                    }
                }
            } else {
                UnifiedTaskInfo unifiedTaskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)userDeleteDto.getTaskId()));
                if (!Objects.isNull(unifiedTaskInfo)) {
                    List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskInfo.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskInfo.getSystemId()));
                    unifiedTaskInfo.setTaskStatus("3");
                    this.pushTaskToOa(unifiedTaskInfo, taskUsers, null);
                }
            }
        }
        this.unifiedTaskUserService.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)userDeleteDto.getTaskId()), UnifiedTaskUser::getTaskId, (Object)userDeleteDto.getTaskId())).in(HussarUtils.isNotEmpty((Object)userDeleteDto.getTaskIds()), UnifiedTaskUser::getTaskId, (Collection)userDeleteDto.getTaskIds())).in(HussarUtils.isNotEmpty((Object)userDeleteDto.getDeleteUserIds()), UnifiedTaskUser::getUserId, (Collection)userDeleteDto.getDeleteUserIds())).notIn(HussarUtils.isNotEmpty((Object)userDeleteDto.getReserveUserIds()), UnifiedTaskUser::getUserId, (Collection)userDeleteDto.getReserveUserIds())).eq(HussarUtils.isNotEmpty((Object)userDeleteDto.getTaskTypes()), UnifiedTaskUser::getTaskStatus, (Object)userDeleteDto.getTaskTypes()));
        return ApiResponse.success();
    }

    public ApiResponse<String> userUpdate(UserUpdateDto userUpdateDto) {
        ApiResponse isBuildSuccess = userUpdateDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        this.unifiedTaskUserService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getSystemId, (Object)userUpdateDto.getSystemId())).eq(UnifiedTaskUser::getTaskId, (Object)userUpdateDto.getTaskId())).eq(HussarUtils.isNotEmpty((Object)userUpdateDto.getTaskType()), UnifiedTaskUser::getTaskStatus, (Object)userUpdateDto.getTaskType())).eq(HussarUtils.isNotEmpty((Object)userUpdateDto.getUserId()), UnifiedTaskUser::getUserId, (Object)userUpdateDto.getUserId())).set(HussarUtils.isNotEmpty((Object)userUpdateDto.getUpdateUser()), UnifiedTaskUser::getUserId, (Object)userUpdateDto.getUpdateUser())).set(HussarUtils.isNotEmpty((Object)userUpdateDto.getUpdateTaskType()), UnifiedTaskUser::getTaskStatus, (Object)userUpdateDto.getUpdateTaskType())).set(HussarUtils.isNotEmpty((Object)userUpdateDto.getUpdateCompleteTime()), UnifiedTaskUser::getCompleteTime, (Object)userUpdateDto.getUpdateCompleteTime()));
        return ApiResponse.success();
    }

    public ApiResponse<String> processAdd(UnifiedProcessInfo processInfo) {
        List list;
        ApiResponse isBuildSuccess = processInfo.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        this.unifiedProcessInfoService.save((Object)processInfo);
        if (this.unifiedTodoProperties.getOpen() && HussarUtils.isNotEmpty((Object)(list = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getProcessInstanceid, (Object)processInfo.getProcInstId())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"1"))))) {
            for (UnifiedTaskInfo unifiedTaskInfo : list) {
                List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskInfo.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskInfo.getSystemId()));
                this.pushTaskToOa(unifiedTaskInfo, taskUsers, processInfo);
            }
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> processUpdate(UnifiedProcessInfo processInfo) {
        ApiResponse isBuildSuccess = processInfo.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        this.unifiedProcessInfoService.update((Object)processInfo, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedProcessInfo::getSystemId, (Object)processInfo.getSystemId())).eq(UnifiedProcessInfo::getProcInstId, (Object)processInfo.getProcInstId()));
        return ApiResponse.success();
    }

    public ApiResponse<String> processDelete(ProcessDeleteDto processInfo) {
        ApiResponse<String> isBuildSuccess = processInfo.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        if (processInfo.isTombstone()) {
            this.unifiedProcessInfoService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedProcessInfo::getSystemId, (Object)processInfo.getSystemId())).in(UnifiedProcessInfo::getProcInstId, Arrays.asList(processInfo.getProcInstId().split(",")))).set(UnifiedProcessInfo::getDeleteFlag, (Object)"1"));
        } else {
            if (processInfo.isCascade() && !(isBuildSuccess = this.taskDelete(new TaskDeleteDto().setSystemId(processInfo.getSystemId()).setProcInstId(processInfo.getProcInstId()))).isSuccess()) {
                return isBuildSuccess;
            }
            this.unifiedProcessInfoService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getSystemId, (Object)processInfo.getSystemId())).in(UnifiedProcessInfo::getProcInstId, Arrays.asList(processInfo.getProcInstId().split(","))));
        }
        return ApiResponse.success();
    }
}

