/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unifiedtodo.service.impl;

import com.baomidou.mybatisplus.core.conditions.AbstractLambdaWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.unifiedtodo.dto.ProcessDeleteDto;
import com.jxdinfo.hussar.unifiedtodo.dto.TaskAddBatchDto;
import com.jxdinfo.hussar.unifiedtodo.dto.TaskChangeDto;
import com.jxdinfo.hussar.unifiedtodo.dto.TaskChangedDto;
import com.jxdinfo.hussar.unifiedtodo.dto.TaskDeleteDto;
import com.jxdinfo.hussar.unifiedtodo.dto.TaskUpdateDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UserAddBatchDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UserChangeDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UserDeleteDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UserUpdateDto;
import com.jxdinfo.hussar.unifiedtodo.model.TaskInfoWithUser;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedProcessInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskUser;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedProcessInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedSystemInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskUserService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnifiedTaskServiceImpl
implements IUnifiedTaskService {
    @Autowired
    private IUnifiedSystemInfoService unifiedSystemInfoService;
    @Autowired
    private IUnifiedTaskInfoService unifiedTaskInfoService;
    @Autowired
    private IUnifiedTaskUserService unifiedTaskUserService;
    @Autowired
    private IUnifiedProcessInfoService unifiedProcessInfoService;
    private static final Logger logger = LoggerFactory.getLogger(UnifiedTaskServiceImpl.class);

    public ApiResponse<String> taskChange(TaskChangeDto taskChangeDto, TaskChangedDto taskChangedDto) {
        ApiResponse isBuildSuccess = taskChangeDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        if (taskChangedDto == null) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            taskChangeDto.buildWrapper((AbstractLambdaWrapper)wrapper);
            this.unifiedTaskInfoService.remove((Wrapper)wrapper);
        } else {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            taskChangeDto.buildWrapper((AbstractLambdaWrapper)wrapper);
            taskChangedDto.buildWrapper(wrapper);
            this.unifiedTaskInfoService.update((Wrapper)wrapper);
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> taskChange(TaskDeleteDto taskDeleteDto, TaskAddBatchDto taskAddBatchDto) {
        ApiResponse<String> isDeleteSuccess;
        if (taskDeleteDto != null && !(isDeleteSuccess = this.taskDelete(taskDeleteDto)).isSuccess()) {
            return isDeleteSuccess;
        }
        if (taskAddBatchDto != null) {
            return this.taskAddBatch(taskAddBatchDto);
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> userChange(UserChangeDto userChangeDto, UnifiedTaskUser unifiedTaskUser) {
        ApiResponse isBuildSuccess = userChangeDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        if (unifiedTaskUser == null) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            userChangeDto.buildWrapper((AbstractLambdaWrapper)wrapper);
            this.unifiedTaskUserService.remove((Wrapper)wrapper);
        } else {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            userChangeDto.buildWrapper((AbstractLambdaWrapper)wrapper);
            this.unifiedTaskUserService.update((Object)unifiedTaskUser, (Wrapper)wrapper);
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> userChange(UserDeleteDto userDeleteDto, UserAddBatchDto userAddBatchDto) {
        ApiResponse<String> isDeleteSuccess;
        if (userDeleteDto != null && !(isDeleteSuccess = this.userDelete(userDeleteDto)).isSuccess()) {
            return isDeleteSuccess;
        }
        if (userAddBatchDto != null) {
            return this.userAddBatch(userAddBatchDto);
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> taskAddBatch(TaskAddBatchDto taskAddBatchDto) {
        ApiResponse isBuildSuccess = taskAddBatchDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        ArrayList taskInfos = new ArrayList();
        ArrayList taskUsers = new ArrayList();
        taskAddBatchDto.getTaskInfos().forEach(taskInfoWithUser -> {
            taskInfos.add(taskInfoWithUser.getTaskInfo());
            if (taskInfoWithUser.getTaskUsers() != null) {
                taskUsers.addAll(taskInfoWithUser.getTaskUsers());
            }
        });
        this.unifiedTaskInfoService.saveBatch(taskInfos);
        if (HussarUtils.isNotEmpty(taskUsers)) {
            this.unifiedTaskUserService.saveBatch(taskUsers);
        }
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> taskAdd(TaskInfoWithUser taskInfoWithUser) {
        ApiResponse isBuildSuccess = taskInfoWithUser.buildAllInfoForTaskAdd();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        this.unifiedTaskInfoService.save((Object)taskInfoWithUser.getTaskInfo());
        if (HussarUtils.isNotEmpty((Object)taskInfoWithUser.getTaskUsers())) {
            this.unifiedTaskUserService.saveBatch((Collection)taskInfoWithUser.getTaskUsers());
        }
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> taskDelete(TaskDeleteDto taskDeleteDto) {
        List taskInfos;
        ApiResponse isBuildSuccess = taskDeleteDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        LambdaQueryWrapper unifiedTaskInfoQuery = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)taskDeleteDto.getProcInstId()), UnifiedTaskInfo::getProcessInstanceid, (Object)taskDeleteDto.getProcInstId())).in(HussarUtils.isNotEmpty((Object)taskDeleteDto.getTaskIds()), UnifiedTaskInfo::getTaskId, (Collection)taskDeleteDto.getTaskIds())).in(HussarUtils.isNotEmpty((Object)taskDeleteDto.getTaskTypes()), UnifiedTaskInfo::getTaskStatus, (Collection)taskDeleteDto.getTaskTypes())).eq(UnifiedTaskInfo::getSystemId, (Object)taskDeleteDto.getSystemId());
        if (taskDeleteDto.isCascade() && !(taskInfos = this.unifiedTaskInfoService.list((Wrapper)unifiedTaskInfoQuery)).isEmpty()) {
            this.unifiedTaskUserService.remove((Wrapper)new LambdaQueryWrapper().in(UnifiedTaskUser::getTaskId, (Collection)taskInfos.stream().map(UnifiedTaskInfo::getTaskId).collect(Collectors.toSet())));
        }
        this.unifiedTaskInfoService.remove((Wrapper)unifiedTaskInfoQuery);
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> taskUpdate(TaskUpdateDto taskUpdateDto) {
        ApiResponse isBuildSuccess = taskUpdateDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        String taskId = taskUpdateDto.getTaskId();
        if (taskUpdateDto.getUpdateCompleteTime() != null) {
            this.unifiedTaskUserService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)taskId)).eq(UnifiedTaskUser::getSystemId, (Object)taskUpdateDto.getSystemId())).set(UnifiedTaskUser::getCompleteTime, (Object)taskUpdateDto.getUpdateCompleteTime()));
        }
        if (!HussarUtils.isAllEmpty((Object[])new Object[]{taskUpdateDto.getUpdateTaskType(), taskUpdateDto.getUpdateDeadLine()})) {
            this.unifiedTaskInfoService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)taskId)).eq(UnifiedTaskInfo::getSystemId, (Object)taskUpdateDto.getSystemId())).set(HussarUtils.isNotEmpty((Object)taskUpdateDto.getUpdateTaskType()), UnifiedTaskInfo::getTaskStatus, (Object)taskUpdateDto.getUpdateTaskType())).set(HussarUtils.isNotEmpty((Object)taskUpdateDto.getUpdateDeadLine()), UnifiedTaskInfo::getDeadLine, (Object)taskUpdateDto.getUpdateDeadLine()));
        }
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> userAddBatch(UserAddBatchDto userAddBatchDto) {
        ApiResponse isBuildSuccess = userAddBatchDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        this.unifiedTaskUserService.saveBatch((Collection)userAddBatchDto.getTaskUsers());
        return ApiResponse.success();
    }

    public ApiResponse<String> userAdd(UnifiedTaskUser unifiedTaskUser) {
        ApiResponse isBuildSuccess = unifiedTaskUser.buildAllInfoForUserAdd();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        this.unifiedTaskUserService.save((Object)unifiedTaskUser);
        return ApiResponse.success();
    }

    public ApiResponse<String> userDelete(UserDeleteDto userDeleteDto) {
        ApiResponse isBuildSuccess = userDeleteDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        this.unifiedTaskUserService.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)userDeleteDto.getTaskId()), UnifiedTaskUser::getTaskId, (Object)userDeleteDto.getTaskId())).in(HussarUtils.isNotEmpty((Object)userDeleteDto.getTaskIds()), UnifiedTaskUser::getTaskId, (Collection)userDeleteDto.getTaskIds())).in(HussarUtils.isNotEmpty((Object)userDeleteDto.getDeleteUserIds()), UnifiedTaskUser::getUserId, (Collection)userDeleteDto.getDeleteUserIds())).notIn(HussarUtils.isNotEmpty((Object)userDeleteDto.getReserveUserIds()), UnifiedTaskUser::getUserId, (Collection)userDeleteDto.getReserveUserIds())).eq(HussarUtils.isNotEmpty((Object)userDeleteDto.getTaskTypes()), UnifiedTaskUser::getTaskStatus, (Object)userDeleteDto.getTaskTypes()));
        return ApiResponse.success();
    }

    public ApiResponse<String> userUpdate(UserUpdateDto userUpdateDto) {
        ApiResponse isBuildSuccess = userUpdateDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        this.unifiedTaskUserService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getSystemId, (Object)userUpdateDto.getSystemId())).eq(UnifiedTaskUser::getTaskId, (Object)userUpdateDto.getTaskId())).eq(HussarUtils.isNotEmpty((Object)userUpdateDto.getTaskType()), UnifiedTaskUser::getTaskStatus, (Object)userUpdateDto.getTaskType())).eq(HussarUtils.isNotEmpty((Object)userUpdateDto.getUserId()), UnifiedTaskUser::getUserId, (Object)userUpdateDto.getUserId())).set(HussarUtils.isNotEmpty((Object)userUpdateDto.getUpdateUser()), UnifiedTaskUser::getUserId, (Object)userUpdateDto.getUpdateUser())).set(HussarUtils.isNotEmpty((Object)userUpdateDto.getUpdateTaskType()), UnifiedTaskUser::getTaskStatus, (Object)userUpdateDto.getUpdateTaskType())).set(HussarUtils.isNotEmpty((Object)userUpdateDto.getUpdateCompleteTime()), UnifiedTaskUser::getCompleteTime, (Object)userUpdateDto.getUpdateCompleteTime()));
        return ApiResponse.success();
    }

    public ApiResponse<String> processAdd(UnifiedProcessInfo processInfo) {
        ApiResponse isBuildSuccess = processInfo.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        this.unifiedProcessInfoService.save((Object)processInfo);
        return ApiResponse.success();
    }

    public ApiResponse<String> processUpdate(UnifiedProcessInfo processInfo) {
        ApiResponse isBuildSuccess = processInfo.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        this.unifiedProcessInfoService.update((Object)processInfo, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedProcessInfo::getSystemId, (Object)processInfo.getSystemId())).eq(UnifiedProcessInfo::getProcInstId, (Object)processInfo.getProcInstId()));
        return ApiResponse.success();
    }

    public ApiResponse<String> processDelete(ProcessDeleteDto processInfo) {
        ApiResponse<String> isBuildSuccess = processInfo.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        if (processInfo.isTombstone()) {
            this.unifiedProcessInfoService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedProcessInfo::getSystemId, (Object)processInfo.getSystemId())).in(UnifiedProcessInfo::getProcInstId, Arrays.asList(processInfo.getProcInstId().split(",")))).set(UnifiedProcessInfo::getDeleteFlag, (Object)"1"));
        } else {
            if (processInfo.isCascade() && !(isBuildSuccess = this.taskDelete(new TaskDeleteDto().setSystemId(processInfo.getSystemId()).setProcInstId(processInfo.getProcInstId()))).isSuccess()) {
                return isBuildSuccess;
            }
            this.unifiedProcessInfoService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getSystemId, (Object)processInfo.getSystemId())).in(UnifiedProcessInfo::getProcInstId, Arrays.asList(processInfo.getProcInstId().split(","))));
        }
        return ApiResponse.success();
    }
}

