/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unifiedtodo.service.impl;

import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.unifiedtodo.constant.ProcessState;
import com.jxdinfo.hussar.unifiedtodo.dao.UnifiedToDoMapper;
import com.jxdinfo.hussar.unifiedtodo.dto.UnifiedDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UnifiedParamDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UnifiedTaskQueryDto;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedProcessInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskUser;
import com.jxdinfo.hussar.unifiedtodo.response.UnifiedResponse;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedProcessInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskUserService;
import com.jxdinfo.hussar.unifiedtodo.vo.UnifiedTaskQueryVo;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnifiedServiceImpl
implements IUnifiedService {
    @Autowired
    private IUnifiedTaskInfoService unifiedTaskInfoService;
    @Autowired
    private IUnifiedTaskUserService unifiedTaskUserService;
    @Autowired
    private IUnifiedProcessInfoService unifiedProcessInfoService;
    @Resource
    private UnifiedToDoMapper unifiedToDoMapper;
    private final Consumer<UnifiedParamDto> update = unifiedParamDto -> {
        UnifiedProcessInfo unifiedProcessInfo = unifiedParamDto.buildProcessInfo();
        UnifiedTaskInfo unifiedTaskInfo = unifiedParamDto.buildTaskInfo();
        UnifiedTaskUser unifiedTaskUser = unifiedParamDto.buildUserInfo();
        if (HussarUtils.isAllEmpty((Object[])new Object[]{unifiedProcessInfo, unifiedTaskInfo, unifiedTaskUser})) {
            return;
        }
        if (unifiedProcessInfo != null) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.unifiedProcessInfoService.lambdaUpdate().eq(UnifiedProcessInfo::getSystemId, (Object)unifiedProcessInfo.getSystemId())).eq(UnifiedProcessInfo::getProcInstId, (Object)unifiedProcessInfo.getProcInstId())).update((Object)unifiedProcessInfo);
        }
        if (unifiedTaskInfo != null) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.unifiedTaskInfoService.lambdaUpdate().eq(UnifiedTaskInfo::getSystemId, (Object)unifiedTaskInfo.getSystemId())).eq(UnifiedTaskInfo::getTaskId, (Object)unifiedTaskInfo.getTaskId())).update((Object)unifiedTaskInfo);
        }
        if (unifiedTaskUser != null) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.unifiedTaskUserService.lambdaUpdate().eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskUser.getSystemId())).eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskUser.getTaskId())).update((Object)unifiedTaskUser);
        }
    };

    public UnifiedResponse unifiedPush(UnifiedDto unifiedDto, Long systemId) {
        if (systemId == null) {
            return UnifiedResponse.paramFail();
        }
        ArrayList<UnifiedParamDto> add = new ArrayList<UnifiedParamDto>();
        ArrayList<UnifiedParamDto> update = new ArrayList<UnifiedParamDto>();
        ArrayList<UnifiedParamDto> delete = new ArrayList<UnifiedParamDto>();
        for (UnifiedParamDto unifiedParamDto : unifiedDto.getDataList()) {
            unifiedParamDto.systemId(systemId);
            if (UnifiedParamDto.optTypeEnum.ADD.strCode.equals(unifiedParamDto.getOptType())) {
                add.add(unifiedParamDto);
                continue;
            }
            if (UnifiedParamDto.optTypeEnum.UPDATE.strCode.equals(unifiedParamDto.getOptType())) {
                update.add(unifiedParamDto);
                continue;
            }
            if (UnifiedParamDto.optTypeEnum.DELETE.strCode.equals(unifiedParamDto.getOptType())) {
                delete.add(unifiedParamDto);
                continue;
            }
            return UnifiedResponse.paramFail();
        }
        this.addUnified(add);
        this.updateUnified(update);
        this.deleteUnified(delete, systemId);
        return UnifiedResponse.success();
    }

    private void addUnified(List<UnifiedParamDto> unifiedParamDtoList) {
        if (unifiedParamDtoList.isEmpty()) {
            return;
        }
        ArrayList<UnifiedProcessInfo> unifiedProcessInfos = new ArrayList<UnifiedProcessInfo>();
        ArrayList<UnifiedTaskInfo> unifiedTaskInfos = new ArrayList<UnifiedTaskInfo>();
        ArrayList<UnifiedTaskUser> unifiedTaskUsers = new ArrayList<UnifiedTaskUser>();
        for (UnifiedParamDto unifiedParamDto : unifiedParamDtoList) {
            UnifiedProcessInfo unifiedProcessInfo = unifiedParamDto.buildProcessInfo();
            UnifiedTaskInfo unifiedTaskInfo = unifiedParamDto.buildTaskInfo();
            UnifiedTaskUser unifiedTaskUser = unifiedParamDto.buildUserInfo();
            if (unifiedProcessInfo != null) {
                unifiedProcessInfos.add(unifiedProcessInfo.setDeleteFlag("0"));
            }
            if (unifiedTaskInfo != null) {
                unifiedTaskInfos.add(unifiedTaskInfo);
            }
            if (unifiedTaskUser == null) continue;
            unifiedTaskUsers.add(unifiedTaskUser);
        }
        if (!unifiedProcessInfos.isEmpty()) {
            this.unifiedProcessInfoService.saveBatch(unifiedProcessInfos);
        }
        if (!unifiedTaskInfos.isEmpty()) {
            this.unifiedTaskInfoService.saveBatch(unifiedTaskInfos);
        }
        if (!unifiedTaskUsers.isEmpty()) {
            this.unifiedTaskUserService.saveBatch(unifiedTaskUsers);
        }
    }

    private void updateUnified(List<UnifiedParamDto> unifiedParamDtoList) {
        if (unifiedParamDtoList.isEmpty()) {
            return;
        }
        unifiedParamDtoList.forEach(this.update);
    }

    private void deleteUnified(List<UnifiedParamDto> unifiedParamDtoList, Long systemId) {
        if (unifiedParamDtoList.isEmpty()) {
            return;
        }
        HashSet<String> procInstIds = new HashSet<String>();
        HashSet<String> taskIds = new HashSet<String>();
        for (UnifiedParamDto unifiedParamDto : unifiedParamDtoList) {
            String procInstId = unifiedParamDto.procInstId();
            String taskId = unifiedParamDto.taskId();
            if (HussarUtils.isNotEmpty((Object)procInstId)) {
                procInstIds.add(procInstId);
            }
            if (!HussarUtils.isNotEmpty((Object)taskId)) continue;
            taskIds.add(taskId);
        }
        if (!HussarUtils.isEmpty(procInstIds)) {
            ((LambdaUpdateChainWrapper)this.unifiedProcessInfoService.lambdaUpdate().in(UnifiedProcessInfo::getProcInstId, procInstIds)).remove();
        }
        if (!HussarUtils.isEmpty(taskIds)) {
            ((LambdaUpdateChainWrapper)this.unifiedTaskInfoService.lambdaUpdate().in(UnifiedTaskInfo::getTaskId, taskIds)).remove();
            ((LambdaUpdateChainWrapper)this.unifiedTaskUserService.lambdaUpdate().in(UnifiedTaskUser::getTaskId, taskIds)).remove();
        }
    }

    public ApiResponse<Page<UnifiedTaskQueryVo>> queryUnifiedTask(Page<UnifiedTaskQueryVo> page, UnifiedTaskQueryDto unifiedTaskQueryDto) {
        if (unifiedTaskQueryDto.isOnlyQueryProcess()) {
            this.unifiedToDoMapper.queryUnifiedProcess(page, unifiedTaskQueryDto);
            if (unifiedTaskQueryDto.isCountDueDays()) {
                Date now = new Date();
                for (UnifiedTaskQueryVo record : page.getRecords()) {
                    LocalDateTime dueTime = record.getDeadLine();
                    if (dueTime == null) continue;
                    long days = (dueTime.toInstant(ZoneOffset.of("+8")).toEpochMilli() - now.getTime()) / 86400000L;
                    record.setNumberOfDaysBeforeTimeout(Long.valueOf(days));
                }
            }
        } else {
            this.unifiedToDoMapper.queryUnifiedTask(page, unifiedTaskQueryDto);
        }
        for (UnifiedTaskQueryVo record : page.getRecords()) {
            if (!HussarUtils.isNotEmpty((Object)record.getProcessState())) continue;
            record.setProcessStateStr(ProcessState.getProcessState((String)record.getProcessState()));
        }
        return ApiResponse.success(page);
    }

    public ApiResponse<Long> queryUnifiedTaskNumber(UnifiedTaskQueryDto unifiedTaskQueryDto) {
        if (unifiedTaskQueryDto.isOnlyQueryProcess()) {
            return ApiResponse.success((Object)this.unifiedToDoMapper.queryUnifiedProcessNumber(unifiedTaskQueryDto));
        }
        return ApiResponse.success((Object)this.unifiedToDoMapper.queryUnifiedTaskNumber(unifiedTaskQueryDto));
    }
}

