/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unifiedtodo.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.AbstractLambdaWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.ObjectUtil;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.audit.core.support.dto.AuditLogModel;
import com.jxdinfo.hussar.support.audit.core.util.AuditLogUtils;
import com.jxdinfo.hussar.unifiedtodo.config.UnifiedTodoGLDProperties;
import com.jxdinfo.hussar.unifiedtodo.config.UnifiedTodoProperties;
import com.jxdinfo.hussar.unifiedtodo.constant.ProcessState;
import com.jxdinfo.hussar.unifiedtodo.dto.GlodonMainDataDto;
import com.jxdinfo.hussar.unifiedtodo.dto.GlodonNodeDataDto;
import com.jxdinfo.hussar.unifiedtodo.dto.GlodonResponse;
import com.jxdinfo.hussar.unifiedtodo.dto.ProcessDeleteDto;
import com.jxdinfo.hussar.unifiedtodo.dto.TaskAddBatchDto;
import com.jxdinfo.hussar.unifiedtodo.dto.TaskChangeDto;
import com.jxdinfo.hussar.unifiedtodo.dto.TaskChangedDto;
import com.jxdinfo.hussar.unifiedtodo.dto.TaskDeleteDto;
import com.jxdinfo.hussar.unifiedtodo.dto.TaskUpdateDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UserAddBatchDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UserChangeDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UserDeleteDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UserUpdateDto;
import com.jxdinfo.hussar.unifiedtodo.model.TaskInfoWithUser;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedDoneTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedPendingTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedProcessInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedProcessRectificationInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedReadedTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskUser;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTodoTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedUnReadTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedDoneTaskInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedPendingTaskInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedProcessInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedProcessRectificationService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedReadedTaskInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedSystemInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskUserService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTodoTaskInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedUnReadTaskInfoService;
import com.jxdinfo.hussar.unifiedtodo.utils.HttpClientUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnifiedTaskServiceImpl
implements IUnifiedTaskService {
    @Autowired
    private IUnifiedSystemInfoService unifiedSystemInfoService;
    @Autowired
    private IUnifiedTaskInfoService unifiedTaskInfoService;
    @Autowired
    private IUnifiedTaskUserService unifiedTaskUserService;
    @Autowired
    private IUnifiedProcessInfoService unifiedProcessInfoService;
    private static final String MODULE_NAME = "OA-\u6570\u636e\u63a8\u9001";
    @Resource
    private UnifiedTodoProperties unifiedTodoProperties;
    @Resource
    private UnifiedTodoGLDProperties unifiedTodoGLDProperties;
    @Resource
    private ISysUsersService usersService;
    private static final Logger logger = LoggerFactory.getLogger(UnifiedTaskServiceImpl.class);
    @Autowired
    private IUnifiedDoneTaskInfoService iUnifiedDoneTaskInfoService;
    @Autowired
    private IUnifiedPendingTaskInfoService iUnifiedPendingTaskInfoService;
    @Autowired
    private IUnifiedReadedTaskInfoService iUnifiedReadedTaskInfoService;
    @Autowired
    private IUnifiedTodoTaskInfoService iUnifiedTodoTaskInfoService;
    @Autowired
    private IUnifiedUnReadTaskInfoService iUnifiedUnReadTaskInfoService;
    @Autowired
    private IUnifiedProcessRectificationService iUnifiedProcessRectificationService;

    public ApiResponse<String> taskChange(TaskChangeDto taskChangeDto, TaskChangedDto taskChangedDto) {
        LambdaQueryWrapper wrapper;
        ApiResponse isBuildSuccess = taskChangeDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        if (taskChangedDto == null) {
            wrapper = new LambdaQueryWrapper();
            taskChangeDto.buildWrapper((AbstractLambdaWrapper)wrapper);
            this.unifiedTaskInfoService.remove((Wrapper)wrapper);
        } else {
            wrapper = new LambdaUpdateWrapper();
            taskChangeDto.buildWrapper((AbstractLambdaWrapper)wrapper);
            taskChangedDto.buildWrapper((LambdaUpdateWrapper)wrapper);
            this.unifiedTaskInfoService.update((Wrapper)wrapper);
        }
        if (this.unifiedTodoProperties.getOpen()) {
            logger.info("taskIds" + taskChangeDto.getTaskIds());
            List taskInfoList = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskInfo::getTaskId, (Collection)taskChangeDto.getTaskIds())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"3"));
            if (CollectionUtil.isEmpty((Collection)taskInfoList)) {
                taskInfoList = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskInfo::getTaskId, (Collection)taskChangeDto.getTaskIds())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"5"));
                logger.info("readSize" + taskInfoList.size());
            }
            logger.info("taskSize:" + taskInfoList.size());
            if (CollectionUtil.isNotEmpty((Collection)taskInfoList)) {
                for (UnifiedTaskInfo unifiedTaskInfo : taskInfoList) {
                    logger.info("taskInfo:" + JSON.toJSONString((Object)unifiedTaskInfo));
                    List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskInfo.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskInfo.getSystemId()));
                    this.pushTaskToOa(unifiedTaskInfo, taskUsers, null);
                }
            }
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> taskChangeClassify(TaskChangeDto taskChangeDto, TaskChangedDto taskChangedDto) {
        block39: {
            List doneTaskInfoList;
            block40: {
                ApiResponse isBuildSuccess = taskChangeDto.buildAllInfo();
                if (!isBuildSuccess.isSuccess()) {
                    return isBuildSuccess;
                }
                LambdaQueryWrapper todoWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)todoWrapper.eq(UnifiedTodoTaskInfo::getSystemId, (Object)taskChangeDto.getSystemId())).in(HussarUtils.isNotEmpty((Object)taskChangeDto.getTaskIds()), UnifiedTodoTaskInfo::getTaskId, (Collection)taskChangeDto.getTaskIds())).in(HussarUtils.isNotEmpty((Object)taskChangeDto.getProcInstIds()), UnifiedTodoTaskInfo::getProcessInstanceid, (Collection)taskChangeDto.getProcInstIds())).in(HussarUtils.isNotEmpty((Object)taskChangeDto.getTaskTypes()), UnifiedTodoTaskInfo::getTaskStatus, (Collection)taskChangeDto.getTaskTypes())).in(HussarUtils.isNotEmpty((Object)taskChangeDto.getTaskDefKeys()), UnifiedTodoTaskInfo::getTaskDefinitionkey, (Collection)taskChangeDto.getTaskDefKeys())).like(HussarUtils.isNotEmpty((Object)taskChangeDto.getTaskNameLike()), UnifiedTodoTaskInfo::getTaskName, (Object)taskChangeDto.getTaskNameLike())).isNull((1 & taskChangeDto.getOtherQueryCondition()) != 0, UnifiedTodoTaskInfo::getTaskStatus);
                if (taskChangeDto.getCreateTimeFrame() != null) {
                    taskChangeDto.getCreateTimeFrame().buildWrapper((AbstractLambdaWrapper)todoWrapper, UnifiedTodoTaskInfo::getCreateTime);
                }
                if (taskChangeDto.getLastTimeFrame() != null) {
                    taskChangeDto.getLastTimeFrame().buildWrapper((AbstractLambdaWrapper)todoWrapper, UnifiedTodoTaskInfo::getLastTime);
                }
                if (taskChangeDto.getDeadLineFrame() != null) {
                    taskChangeDto.getDeadLineFrame().buildWrapper((AbstractLambdaWrapper)todoWrapper, UnifiedTodoTaskInfo::getDeadLine);
                }
                LambdaQueryWrapper doneWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)doneWrapper.eq(UnifiedDoneTaskInfo::getSystemId, (Object)taskChangeDto.getSystemId())).in(HussarUtils.isNotEmpty((Object)taskChangeDto.getTaskIds()), UnifiedDoneTaskInfo::getTaskId, (Collection)taskChangeDto.getTaskIds())).in(HussarUtils.isNotEmpty((Object)taskChangeDto.getProcInstIds()), UnifiedDoneTaskInfo::getProcessInstanceid, (Collection)taskChangeDto.getProcInstIds())).in(HussarUtils.isNotEmpty((Object)taskChangeDto.getTaskTypes()), UnifiedDoneTaskInfo::getTaskStatus, (Collection)taskChangeDto.getTaskTypes())).in(HussarUtils.isNotEmpty((Object)taskChangeDto.getTaskDefKeys()), UnifiedDoneTaskInfo::getTaskDefinitionkey, (Collection)taskChangeDto.getTaskDefKeys())).like(HussarUtils.isNotEmpty((Object)taskChangeDto.getTaskNameLike()), UnifiedDoneTaskInfo::getTaskName, (Object)taskChangeDto.getTaskNameLike())).isNull((1 & taskChangeDto.getOtherQueryCondition()) != 0, UnifiedDoneTaskInfo::getTaskStatus);
                if (taskChangeDto.getCreateTimeFrame() != null) {
                    taskChangeDto.getCreateTimeFrame().buildWrapper((AbstractLambdaWrapper)doneWrapper, UnifiedDoneTaskInfo::getCreateTime);
                }
                if (taskChangeDto.getLastTimeFrame() != null) {
                    taskChangeDto.getLastTimeFrame().buildWrapper((AbstractLambdaWrapper)doneWrapper, UnifiedDoneTaskInfo::getLastTime);
                }
                if (taskChangeDto.getDeadLineFrame() != null) {
                    taskChangeDto.getDeadLineFrame().buildWrapper((AbstractLambdaWrapper)doneWrapper, UnifiedDoneTaskInfo::getDeadLine);
                }
                LambdaQueryWrapper unReadWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)unReadWrapper.eq(UnifiedUnReadTaskInfo::getSystemId, (Object)taskChangeDto.getSystemId())).in(HussarUtils.isNotEmpty((Object)taskChangeDto.getTaskIds()), UnifiedUnReadTaskInfo::getTaskId, (Collection)taskChangeDto.getTaskIds())).in(HussarUtils.isNotEmpty((Object)taskChangeDto.getProcInstIds()), UnifiedUnReadTaskInfo::getProcessInstanceid, (Collection)taskChangeDto.getProcInstIds())).in(HussarUtils.isNotEmpty((Object)taskChangeDto.getTaskTypes()), UnifiedUnReadTaskInfo::getTaskStatus, (Collection)taskChangeDto.getTaskTypes())).in(HussarUtils.isNotEmpty((Object)taskChangeDto.getTaskDefKeys()), UnifiedUnReadTaskInfo::getTaskDefinitionkey, (Collection)taskChangeDto.getTaskDefKeys())).like(HussarUtils.isNotEmpty((Object)taskChangeDto.getTaskNameLike()), UnifiedUnReadTaskInfo::getTaskName, (Object)taskChangeDto.getTaskNameLike())).isNull((1 & taskChangeDto.getOtherQueryCondition()) != 0, UnifiedUnReadTaskInfo::getTaskStatus);
                if (taskChangeDto.getCreateTimeFrame() != null) {
                    taskChangeDto.getCreateTimeFrame().buildWrapper((AbstractLambdaWrapper)unReadWrapper, UnifiedUnReadTaskInfo::getCreateTime);
                }
                if (taskChangeDto.getLastTimeFrame() != null) {
                    taskChangeDto.getLastTimeFrame().buildWrapper((AbstractLambdaWrapper)unReadWrapper, UnifiedUnReadTaskInfo::getLastTime);
                }
                if (taskChangeDto.getDeadLineFrame() != null) {
                    taskChangeDto.getDeadLineFrame().buildWrapper((AbstractLambdaWrapper)unReadWrapper, UnifiedUnReadTaskInfo::getDeadLine);
                }
                LambdaQueryWrapper readedWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)readedWrapper.eq(UnifiedReadedTaskInfo::getSystemId, (Object)taskChangeDto.getSystemId())).in(HussarUtils.isNotEmpty((Object)taskChangeDto.getTaskIds()), UnifiedReadedTaskInfo::getTaskId, (Collection)taskChangeDto.getTaskIds())).in(HussarUtils.isNotEmpty((Object)taskChangeDto.getProcInstIds()), UnifiedReadedTaskInfo::getProcessInstanceid, (Collection)taskChangeDto.getProcInstIds())).in(HussarUtils.isNotEmpty((Object)taskChangeDto.getTaskTypes()), UnifiedReadedTaskInfo::getTaskStatus, (Collection)taskChangeDto.getTaskTypes())).in(HussarUtils.isNotEmpty((Object)taskChangeDto.getTaskDefKeys()), UnifiedReadedTaskInfo::getTaskDefinitionkey, (Collection)taskChangeDto.getTaskDefKeys())).like(HussarUtils.isNotEmpty((Object)taskChangeDto.getTaskNameLike()), UnifiedReadedTaskInfo::getTaskName, (Object)taskChangeDto.getTaskNameLike())).isNull((1 & taskChangeDto.getOtherQueryCondition()) != 0, UnifiedReadedTaskInfo::getTaskStatus);
                if (taskChangeDto.getCreateTimeFrame() != null) {
                    taskChangeDto.getCreateTimeFrame().buildWrapper((AbstractLambdaWrapper)readedWrapper, UnifiedReadedTaskInfo::getCreateTime);
                }
                if (taskChangeDto.getLastTimeFrame() != null) {
                    taskChangeDto.getLastTimeFrame().buildWrapper((AbstractLambdaWrapper)readedWrapper, UnifiedReadedTaskInfo::getLastTime);
                }
                if (taskChangeDto.getDeadLineFrame() != null) {
                    taskChangeDto.getDeadLineFrame().buildWrapper((AbstractLambdaWrapper)readedWrapper, UnifiedReadedTaskInfo::getDeadLine);
                }
                LambdaQueryWrapper pendingWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)pendingWrapper.eq(UnifiedPendingTaskInfo::getSystemId, (Object)taskChangeDto.getSystemId())).in(HussarUtils.isNotEmpty((Object)taskChangeDto.getTaskIds()), UnifiedPendingTaskInfo::getTaskId, (Collection)taskChangeDto.getTaskIds())).in(HussarUtils.isNotEmpty((Object)taskChangeDto.getProcInstIds()), UnifiedPendingTaskInfo::getProcessInstanceid, (Collection)taskChangeDto.getProcInstIds())).in(HussarUtils.isNotEmpty((Object)taskChangeDto.getTaskTypes()), UnifiedPendingTaskInfo::getTaskStatus, (Collection)taskChangeDto.getTaskTypes())).in(HussarUtils.isNotEmpty((Object)taskChangeDto.getTaskDefKeys()), UnifiedPendingTaskInfo::getTaskDefinitionkey, (Collection)taskChangeDto.getTaskDefKeys())).like(HussarUtils.isNotEmpty((Object)taskChangeDto.getTaskNameLike()), UnifiedPendingTaskInfo::getTaskName, (Object)taskChangeDto.getTaskNameLike())).isNull((1 & taskChangeDto.getOtherQueryCondition()) != 0, UnifiedPendingTaskInfo::getTaskStatus);
                if (taskChangeDto.getCreateTimeFrame() != null) {
                    taskChangeDto.getCreateTimeFrame().buildWrapper((AbstractLambdaWrapper)pendingWrapper, UnifiedPendingTaskInfo::getCreateTime);
                }
                if (taskChangeDto.getLastTimeFrame() != null) {
                    taskChangeDto.getLastTimeFrame().buildWrapper((AbstractLambdaWrapper)pendingWrapper, UnifiedPendingTaskInfo::getLastTime);
                }
                if (taskChangeDto.getDeadLineFrame() != null) {
                    taskChangeDto.getDeadLineFrame().buildWrapper((AbstractLambdaWrapper)pendingWrapper, UnifiedPendingTaskInfo::getDeadLine);
                }
                if (taskChangedDto == null) {
                    this.iUnifiedTodoTaskInfoService.remove((Wrapper)todoWrapper);
                    this.iUnifiedDoneTaskInfoService.remove((Wrapper)doneWrapper);
                    this.iUnifiedReadedTaskInfoService.remove((Wrapper)readedWrapper);
                    this.iUnifiedPendingTaskInfoService.remove((Wrapper)pendingWrapper);
                    this.iUnifiedUnReadTaskInfoService.remove((Wrapper)unReadWrapper);
                } else {
                    List unifiedUnReadTaskInfos = this.iUnifiedUnReadTaskInfoService.list((Wrapper)unReadWrapper);
                    List unifiedDoneTaskInfos = this.iUnifiedDoneTaskInfoService.list((Wrapper)doneWrapper);
                    List unifiedPendingTaskInfos = this.iUnifiedPendingTaskInfoService.list((Wrapper)pendingWrapper);
                    List unifiedTodoTaskInfos = this.iUnifiedTodoTaskInfoService.list((Wrapper)todoWrapper);
                    List unifiedReadedTaskInfos = this.iUnifiedReadedTaskInfoService.list((Wrapper)readedWrapper);
                    ArrayList unifiedUnReadTaskInfoNews = new ArrayList();
                    ArrayList<UnifiedDoneTaskInfo> unifiedDoneTaskInfoNews = new ArrayList<UnifiedDoneTaskInfo>();
                    ArrayList<UnifiedPendingTaskInfo> unifiedPendingTaskInfoNews = new ArrayList<UnifiedPendingTaskInfo>();
                    ArrayList<UnifiedTodoTaskInfo> unifiedTodoTaskInfoNews = new ArrayList<UnifiedTodoTaskInfo>();
                    ArrayList<UnifiedReadedTaskInfo> unifiedReadedTaskInfoNews = new ArrayList<UnifiedReadedTaskInfo>();
                    if (HussarUtils.isNotEmpty((Object)unifiedReadedTaskInfos)) {
                        for (UnifiedReadedTaskInfo unifiedReadedTaskInfo : unifiedReadedTaskInfos) {
                            unifiedReadedTaskInfo.setCreateTime(taskChangedDto.getCreateTime());
                            unifiedReadedTaskInfo.setLastTime(taskChangedDto.getLastTime());
                            unifiedReadedTaskInfo.setDeadLine(taskChangedDto.getDeadLine());
                            unifiedReadedTaskInfo.setSendUserId(taskChangedDto.getSendUserId());
                            unifiedReadedTaskInfo.setWebLinkurl(taskChangedDto.getWebLinkurl());
                            unifiedReadedTaskInfo.setMobileLinkurl(taskChangedDto.getMobileLinkurl());
                            unifiedReadedTaskInfo.setTaskDefinitionkey(taskChangedDto.getTaskDefinitionkey());
                            unifiedReadedTaskInfo.setTaskName(taskChangedDto.getTaskName());
                            unifiedReadedTaskInfo.setWebUrlProps(taskChangedDto.getWebUrlProps());
                            unifiedReadedTaskInfo.setMobileUrlProps(taskChangedDto.getMobileUrlProps());
                            unifiedReadedTaskInfoNews.add(unifiedReadedTaskInfo);
                        }
                        this.iUnifiedReadedTaskInfoService.saveOrUpdateBatch(unifiedReadedTaskInfoNews);
                    }
                    if (HussarUtils.isNotEmpty((Object)unifiedUnReadTaskInfos)) {
                        unifiedReadedTaskInfoNews = new ArrayList();
                        for (UnifiedUnReadTaskInfo unifiedUnReadTaskInfo : unifiedUnReadTaskInfos) {
                            UnifiedReadedTaskInfo unifiedReadedTaskInfo = new UnifiedReadedTaskInfo();
                            BeanUtils.copyProperties((Object)unifiedUnReadTaskInfo, (Object)unifiedReadedTaskInfo);
                            unifiedReadedTaskInfo.setTaskStatus("5");
                            unifiedReadedTaskInfoNews.add(unifiedReadedTaskInfo);
                        }
                        this.iUnifiedUnReadTaskInfoService.remove((Wrapper)unReadWrapper);
                        this.iUnifiedReadedTaskInfoService.saveOrUpdateBatch(unifiedReadedTaskInfoNews);
                    }
                    if (HussarUtils.isNotEmpty((Object)unifiedDoneTaskInfos)) {
                        for (UnifiedDoneTaskInfo unifiedDoneTaskInfo : unifiedDoneTaskInfos) {
                            unifiedDoneTaskInfo.setCreateTime(taskChangedDto.getCreateTime());
                            unifiedDoneTaskInfo.setLastTime(taskChangedDto.getLastTime());
                            unifiedDoneTaskInfo.setDeadLine(taskChangedDto.getDeadLine());
                            unifiedDoneTaskInfo.setSendUserId(taskChangedDto.getSendUserId());
                            unifiedDoneTaskInfo.setWebLinkurl(taskChangedDto.getWebLinkurl());
                            unifiedDoneTaskInfo.setMobileLinkurl(taskChangedDto.getMobileLinkurl());
                            unifiedDoneTaskInfo.setTaskDefinitionkey(taskChangedDto.getTaskDefinitionkey());
                            unifiedDoneTaskInfo.setTaskName(taskChangedDto.getTaskName());
                            unifiedDoneTaskInfo.setWebUrlProps(taskChangedDto.getWebUrlProps());
                            unifiedDoneTaskInfo.setMobileUrlProps(taskChangedDto.getMobileUrlProps());
                            unifiedDoneTaskInfoNews.add(unifiedDoneTaskInfo);
                            if (!this.unifiedTodoGLDProperties.isOpen()) continue;
                            GlodonNodeDataDto nodeDataDto = new GlodonNodeDataDto();
                            nodeDataDto.setId(unifiedDoneTaskInfo.getTaskId());
                            nodeDataDto.setFlowId(unifiedDoneTaskInfo.getProcessInstanceid());
                            nodeDataDto.setDeleted(Boolean.valueOf(false));
                            nodeDataDto.setPromoterId(unifiedDoneTaskInfo.getUserId());
                            nodeDataDto.setPromoterNo(unifiedDoneTaskInfo.getAssigneeUserNumber());
                            nodeDataDto.setPromoterName(unifiedDoneTaskInfo.getAssigneeUserName());
                            nodeDataDto.setDeptName(unifiedDoneTaskInfo.getDeptName());
                            nodeDataDto.setPostName(unifiedDoneTaskInfo.getPostName());
                            nodeDataDto.setJumpUrl(this.unifiedTodoGLDProperties.getToDoList());
                            if (null != unifiedDoneTaskInfo.getCompleteTime()) {
                                nodeDataDto.setApproveTime(DateUtil.format((Date)unifiedDoneTaskInfo.getCompleteTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                            }
                            nodeDataDto.setApprovalStatus(Integer.valueOf(2));
                            this.pushGldNode(nodeDataDto);
                        }
                        this.iUnifiedDoneTaskInfoService.saveOrUpdateBatch(unifiedDoneTaskInfoNews);
                    }
                    if (HussarUtils.isNotEmpty((Object)unifiedPendingTaskInfos)) {
                        Iterator iterator = unifiedPendingTaskInfos.iterator();
                        while (iterator.hasNext()) {
                            UnifiedPendingTaskInfo unifiedPendingTaskInfo = (UnifiedPendingTaskInfo)iterator.next();
                            unifiedPendingTaskInfo.setCreateTime(taskChangedDto.getCreateTime());
                            unifiedPendingTaskInfo.setLastTime(taskChangedDto.getLastTime());
                            unifiedPendingTaskInfo.setDeadLine(taskChangedDto.getDeadLine());
                            unifiedPendingTaskInfo.setSendUserId(taskChangedDto.getSendUserId());
                            unifiedPendingTaskInfo.setWebLinkurl(taskChangedDto.getWebLinkurl());
                            unifiedPendingTaskInfo.setMobileLinkurl(taskChangedDto.getMobileLinkurl());
                            unifiedPendingTaskInfo.setTaskDefinitionkey(taskChangedDto.getTaskDefinitionkey());
                            unifiedPendingTaskInfo.setTaskName(taskChangedDto.getTaskName());
                            unifiedPendingTaskInfo.setWebUrlProps(taskChangedDto.getWebUrlProps());
                            unifiedPendingTaskInfo.setMobileUrlProps(taskChangedDto.getMobileUrlProps());
                            unifiedPendingTaskInfoNews.add(unifiedPendingTaskInfo);
                        }
                        this.iUnifiedPendingTaskInfoService.saveOrUpdateBatch(unifiedPendingTaskInfoNews);
                    }
                    if (HussarUtils.isNotEmpty((Object)unifiedTodoTaskInfos)) {
                        for (UnifiedTodoTaskInfo unifiedTodoTaskInfo : unifiedTodoTaskInfos) {
                            unifiedTodoTaskInfo.setCreateTime(taskChangedDto.getCreateTime());
                            unifiedTodoTaskInfo.setLastTime(taskChangedDto.getLastTime());
                            unifiedTodoTaskInfo.setDeadLine(taskChangedDto.getDeadLine());
                            unifiedTodoTaskInfo.setSendUserId(taskChangedDto.getSendUserId());
                            unifiedTodoTaskInfo.setWebLinkurl(taskChangedDto.getWebLinkurl());
                            unifiedTodoTaskInfo.setMobileLinkurl(taskChangedDto.getMobileLinkurl());
                            unifiedTodoTaskInfo.setTaskDefinitionkey(taskChangedDto.getTaskDefinitionkey());
                            unifiedTodoTaskInfo.setTaskName(taskChangedDto.getTaskName());
                            unifiedTodoTaskInfo.setWebUrlProps(taskChangedDto.getWebUrlProps());
                            unifiedTodoTaskInfo.setMobileUrlProps(taskChangedDto.getMobileUrlProps());
                            if (this.unifiedTodoGLDProperties.isOpen()) {
                                GlodonNodeDataDto requestBody = new GlodonNodeDataDto();
                                requestBody.setFlowId(unifiedTodoTaskInfo.getProcessInstanceid());
                                requestBody.setId(unifiedTodoTaskInfo.getTaskId());
                                requestBody.setPromoterId(unifiedTodoTaskInfo.getUserId());
                                requestBody.setPromoterNo(unifiedTodoTaskInfo.getAssigneeUserNumber());
                                requestBody.setPromoterName(unifiedTodoTaskInfo.getAssigneeUserName());
                                requestBody.setDeptName(unifiedTodoTaskInfo.getDeptName());
                                requestBody.setPostName(unifiedTodoTaskInfo.getPostName());
                                requestBody.setDeleted(Boolean.valueOf(false));
                                requestBody.setJumpUrl(this.unifiedTodoGLDProperties.getToBe());
                                if (null != unifiedTodoTaskInfo.getDeadLine()) {
                                    requestBody.setDeadlineTime(DateUtil.format((Date)unifiedTodoTaskInfo.getDeadLine(), (String)"yyyy-MM-dd HH:mm:ss"));
                                }
                                if ("1".equals(unifiedTodoTaskInfo.getTaskStatus())) {
                                    requestBody.setApprovalStatus(Integer.valueOf(1));
                                } else if ("3".equals(unifiedTodoTaskInfo.getTaskStatus())) {
                                    requestBody.setApprovalStatus(Integer.valueOf(2));
                                }
                                this.pushGldNode(requestBody);
                            }
                            unifiedTodoTaskInfoNews.add(unifiedTodoTaskInfo);
                        }
                        if ("3".equals(taskChangedDto.getTaskType())) {
                            List<UnifiedDoneTaskInfo> unifiedDoneTaskInfoList = unifiedTodoTaskInfoNews.stream().map(todo -> {
                                UnifiedDoneTaskInfo doneTaskInfo = new UnifiedDoneTaskInfo();
                                BeanUtils.copyProperties((Object)todo, (Object)doneTaskInfo);
                                doneTaskInfo.setTaskStatus("3");
                                return doneTaskInfo;
                            }).collect(Collectors.toList());
                            this.iUnifiedTodoTaskInfoService.remove((Wrapper)todoWrapper);
                            logger.info("\u5df2\u529e\u63d2\u5165\u6570\u636e\uff1a" + unifiedDoneTaskInfoNews.size());
                            if (this.unifiedTodoGLDProperties.isOpen()) {
                                unifiedDoneTaskInfoList.forEach(doneTaskInfo -> {
                                    GlodonNodeDataDto nodeDataDto = new GlodonNodeDataDto();
                                    nodeDataDto.setFlowId(doneTaskInfo.getProcessInstanceid());
                                    nodeDataDto.setId(doneTaskInfo.getTaskId());
                                    nodeDataDto.setDeleted(Boolean.valueOf(false));
                                    nodeDataDto.setPromoterId(doneTaskInfo.getUserId());
                                    nodeDataDto.setPromoterNo(doneTaskInfo.getAssigneeUserNumber());
                                    nodeDataDto.setPromoterName(doneTaskInfo.getAssigneeUserName());
                                    nodeDataDto.setDeptName(doneTaskInfo.getDeptName());
                                    nodeDataDto.setPostName(doneTaskInfo.getPostName());
                                    nodeDataDto.setJumpUrl(this.unifiedTodoGLDProperties.getToDoList());
                                    if (null != doneTaskInfo.getCompleteTime()) {
                                        nodeDataDto.setApproveTime(DateUtil.format((Date)doneTaskInfo.getCompleteTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                                    }
                                    nodeDataDto.setApprovalStatus(Integer.valueOf(2));
                                    this.pushGldNode(nodeDataDto);
                                });
                            }
                            this.iUnifiedDoneTaskInfoService.saveOrUpdateBatch(unifiedDoneTaskInfoList);
                        } else {
                            this.iUnifiedTodoTaskInfoService.saveOrUpdateBatch(unifiedTodoTaskInfoNews);
                        }
                    }
                }
                if (!this.unifiedTodoProperties.getOpen()) break block39;
                logger.info("taskIds" + taskChangeDto.getTaskIds());
                doneTaskInfoList = this.iUnifiedDoneTaskInfoService.list((Wrapper)new LambdaQueryWrapper().in(UnifiedDoneTaskInfo::getTaskId, (Collection)taskChangeDto.getTaskIds()));
                if (!CollectionUtil.isEmpty((Collection)doneTaskInfoList)) break block40;
                List readTaskInfoList = this.iUnifiedReadedTaskInfoService.list((Wrapper)new LambdaQueryWrapper().in(UnifiedReadedTaskInfo::getTaskId, (Collection)taskChangeDto.getTaskIds()));
                logger.info("readTaskInfoSize:" + readTaskInfoList.size());
                if (!CollectionUtil.isNotEmpty((Collection)readTaskInfoList)) break block39;
                for (UnifiedReadedTaskInfo readTaskInfo : readTaskInfoList) {
                    logger.info("readTaskInfo:" + JSON.toJSONString((Object)readTaskInfo));
                    List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)readTaskInfo.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)readTaskInfo.getSystemId()));
                    this.pushTaskToOa(null, null, null, null, readTaskInfo, taskUsers, null);
                }
                break block39;
            }
            logger.info("doneTaskInfoSize:" + doneTaskInfoList.size());
            for (UnifiedDoneTaskInfo doneTaskInfo2 : doneTaskInfoList) {
                logger.info("doneTaskInfo:" + JSON.toJSONString((Object)doneTaskInfo2));
                List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)doneTaskInfo2.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)doneTaskInfo2.getSystemId()));
                this.pushTaskToOa(null, null, doneTaskInfo2, null, null, taskUsers, null);
            }
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> taskChange(TaskDeleteDto taskDeleteDto, TaskAddBatchDto taskAddBatchDto) {
        ApiResponse<String> isDeleteSuccess;
        if (taskDeleteDto != null && !(isDeleteSuccess = this.taskDelete(taskDeleteDto)).isSuccess()) {
            return isDeleteSuccess;
        }
        if (taskAddBatchDto != null) {
            return this.taskAddBatch(taskAddBatchDto);
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> taskChangeClassify(TaskDeleteDto taskDeleteDto, TaskAddBatchDto taskAddBatchDto) {
        ApiResponse<String> isDeleteSuccess;
        if (taskDeleteDto != null && !(isDeleteSuccess = this.taskDeleteClassify(taskDeleteDto)).isSuccess()) {
            return isDeleteSuccess;
        }
        if (taskAddBatchDto != null) {
            return this.taskAddBatchClassify(taskAddBatchDto);
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> userChange(UserChangeDto userChangeDto, UnifiedTaskUser unifiedTaskUser) {
        ApiResponse isBuildSuccess = userChangeDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        if (unifiedTaskUser == null) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            userChangeDto.buildWrapper((AbstractLambdaWrapper)wrapper);
            this.unifiedTaskUserService.remove((Wrapper)wrapper);
        } else {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            userChangeDto.buildWrapper((AbstractLambdaWrapper)wrapper);
            this.unifiedTaskUserService.update((Object)unifiedTaskUser, (Wrapper)wrapper);
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> userChangeClassify(UserChangeDto userChangeDto, UnifiedTaskUser unifiedTaskUser) {
        ApiResponse isBuildSuccess = userChangeDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        LambdaQueryWrapper todoWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)todoWrapper.eq(UnifiedTodoTaskInfo::getSystemId, (Object)userChangeDto.getSystemId())).in(HussarUtils.isNotEmpty((Object)userChangeDto.getTaskIds()), UnifiedTodoTaskInfo::getTaskId, (Collection)userChangeDto.getTaskIds());
        if (this.isComply(userChangeDto.getOtherQueryCondition(), 1)) {
            todoWrapper.notIn(HussarUtils.isNotEmpty((Object)userChangeDto.getUserIds()), UnifiedTodoTaskInfo::getUserId, (Collection)userChangeDto.getUserIds());
        } else {
            todoWrapper.in(HussarUtils.isNotEmpty((Object)userChangeDto.getUserIds()), UnifiedTodoTaskInfo::getUserId, (Collection)userChangeDto.getUserIds());
        }
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)todoWrapper.in(HussarUtils.isNotEmpty((Object)userChangeDto.getMandators()), UnifiedTodoTaskInfo::getMandators, (Collection)userChangeDto.getMandators())).in(HussarUtils.isNotEmpty((Object)userChangeDto.getUserTypes()), UnifiedTodoTaskInfo::getUserTypes, (Collection)userChangeDto.getUserTypes())).isNull(this.isComply(userChangeDto.getOtherQueryCondition(), 1), UnifiedTodoTaskInfo::getTaskStatus)).isNull(this.isComply(userChangeDto.getOtherQueryCondition(), 1), UnifiedTodoTaskInfo::getTaskStatus);
        if (userChangeDto.getCompleteTime() != null) {
            userChangeDto.getCompleteTime().buildWrapper((AbstractLambdaWrapper)todoWrapper, UnifiedTodoTaskInfo::getCompleteTime);
        }
        LambdaQueryWrapper doneWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)doneWrapper.eq(UnifiedDoneTaskInfo::getSystemId, (Object)userChangeDto.getSystemId())).in(HussarUtils.isNotEmpty((Object)userChangeDto.getTaskIds()), UnifiedDoneTaskInfo::getTaskId, (Collection)userChangeDto.getTaskIds());
        if (this.isComply(userChangeDto.getOtherQueryCondition(), 1)) {
            doneWrapper.notIn(HussarUtils.isNotEmpty((Object)userChangeDto.getUserIds()), UnifiedDoneTaskInfo::getUserId, (Collection)userChangeDto.getUserIds());
        } else {
            doneWrapper.in(HussarUtils.isNotEmpty((Object)userChangeDto.getUserIds()), UnifiedDoneTaskInfo::getUserId, (Collection)userChangeDto.getUserIds());
        }
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)doneWrapper.in(HussarUtils.isNotEmpty((Object)userChangeDto.getMandators()), UnifiedDoneTaskInfo::getMandators, (Collection)userChangeDto.getMandators())).in(HussarUtils.isNotEmpty((Object)userChangeDto.getUserTypes()), UnifiedDoneTaskInfo::getUserTypes, (Collection)userChangeDto.getUserTypes())).isNull(this.isComply(userChangeDto.getOtherQueryCondition(), 1), UnifiedDoneTaskInfo::getTaskStatus)).isNull(this.isComply(userChangeDto.getOtherQueryCondition(), 1), UnifiedDoneTaskInfo::getTaskStatus);
        if (userChangeDto.getCompleteTime() != null) {
            userChangeDto.getCompleteTime().buildWrapper((AbstractLambdaWrapper)doneWrapper, UnifiedDoneTaskInfo::getCompleteTime);
        }
        LambdaQueryWrapper unReadWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)unReadWrapper.eq(UnifiedUnReadTaskInfo::getSystemId, (Object)userChangeDto.getSystemId())).in(HussarUtils.isNotEmpty((Object)userChangeDto.getTaskIds()), UnifiedUnReadTaskInfo::getTaskId, (Collection)userChangeDto.getTaskIds());
        if (this.isComply(userChangeDto.getOtherQueryCondition(), 1)) {
            unReadWrapper.notIn(HussarUtils.isNotEmpty((Object)userChangeDto.getUserIds()), UnifiedUnReadTaskInfo::getUserId, (Collection)userChangeDto.getUserIds());
        } else {
            unReadWrapper.in(HussarUtils.isNotEmpty((Object)userChangeDto.getUserIds()), UnifiedUnReadTaskInfo::getUserId, (Collection)userChangeDto.getUserIds());
        }
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)unReadWrapper.in(HussarUtils.isNotEmpty((Object)userChangeDto.getMandators()), UnifiedUnReadTaskInfo::getMandators, (Collection)userChangeDto.getMandators())).in(HussarUtils.isNotEmpty((Object)userChangeDto.getUserTypes()), UnifiedUnReadTaskInfo::getUserTypes, (Collection)userChangeDto.getUserTypes())).isNull(this.isComply(userChangeDto.getOtherQueryCondition(), 1), UnifiedUnReadTaskInfo::getTaskStatus)).isNull(this.isComply(userChangeDto.getOtherQueryCondition(), 1), UnifiedUnReadTaskInfo::getTaskStatus);
        if (userChangeDto.getCompleteTime() != null) {
            userChangeDto.getCompleteTime().buildWrapper((AbstractLambdaWrapper)unReadWrapper, UnifiedUnReadTaskInfo::getCompleteTime);
        }
        LambdaQueryWrapper readedWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)readedWrapper.eq(UnifiedReadedTaskInfo::getSystemId, (Object)userChangeDto.getSystemId())).in(HussarUtils.isNotEmpty((Object)userChangeDto.getTaskIds()), UnifiedReadedTaskInfo::getTaskId, (Collection)userChangeDto.getTaskIds());
        if (this.isComply(userChangeDto.getOtherQueryCondition(), 1)) {
            readedWrapper.notIn(HussarUtils.isNotEmpty((Object)userChangeDto.getUserIds()), UnifiedReadedTaskInfo::getUserId, (Collection)userChangeDto.getUserIds());
        } else {
            readedWrapper.in(HussarUtils.isNotEmpty((Object)userChangeDto.getUserIds()), UnifiedReadedTaskInfo::getUserId, (Collection)userChangeDto.getUserIds());
        }
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)readedWrapper.in(HussarUtils.isNotEmpty((Object)userChangeDto.getMandators()), UnifiedReadedTaskInfo::getMandators, (Collection)userChangeDto.getMandators())).in(HussarUtils.isNotEmpty((Object)userChangeDto.getUserTypes()), UnifiedReadedTaskInfo::getUserTypes, (Collection)userChangeDto.getUserTypes())).isNull(this.isComply(userChangeDto.getOtherQueryCondition(), 1), UnifiedReadedTaskInfo::getTaskStatus)).isNull(this.isComply(userChangeDto.getOtherQueryCondition(), 1), UnifiedReadedTaskInfo::getTaskStatus);
        if (userChangeDto.getCompleteTime() != null) {
            userChangeDto.getCompleteTime().buildWrapper((AbstractLambdaWrapper)readedWrapper, UnifiedReadedTaskInfo::getCompleteTime);
        }
        LambdaQueryWrapper pendingWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)pendingWrapper.eq(UnifiedPendingTaskInfo::getSystemId, (Object)userChangeDto.getSystemId())).in(HussarUtils.isNotEmpty((Object)userChangeDto.getTaskIds()), UnifiedPendingTaskInfo::getTaskId, (Collection)userChangeDto.getTaskIds());
        if (this.isComply(userChangeDto.getOtherQueryCondition(), 1)) {
            pendingWrapper.notIn(HussarUtils.isNotEmpty((Object)userChangeDto.getUserIds()), UnifiedPendingTaskInfo::getUserId, (Collection)userChangeDto.getUserIds());
        } else {
            pendingWrapper.in(HussarUtils.isNotEmpty((Object)userChangeDto.getUserIds()), UnifiedPendingTaskInfo::getUserId, (Collection)userChangeDto.getUserIds());
        }
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)pendingWrapper.in(HussarUtils.isNotEmpty((Object)userChangeDto.getMandators()), UnifiedPendingTaskInfo::getMandators, (Collection)userChangeDto.getMandators())).in(HussarUtils.isNotEmpty((Object)userChangeDto.getUserTypes()), UnifiedPendingTaskInfo::getUserTypes, (Collection)userChangeDto.getUserTypes())).isNull(this.isComply(userChangeDto.getOtherQueryCondition(), 1), UnifiedPendingTaskInfo::getTaskStatus)).isNull(this.isComply(userChangeDto.getOtherQueryCondition(), 1), UnifiedPendingTaskInfo::getTaskStatus);
        if (userChangeDto.getCompleteTime() != null) {
            userChangeDto.getCompleteTime().buildWrapper((AbstractLambdaWrapper)pendingWrapper, UnifiedPendingTaskInfo::getCompleteTime);
        }
        if (unifiedTaskUser == null) {
            this.iUnifiedTodoTaskInfoService.remove((Wrapper)todoWrapper);
            this.iUnifiedDoneTaskInfoService.remove((Wrapper)doneWrapper);
            this.iUnifiedReadedTaskInfoService.remove((Wrapper)readedWrapper);
            this.iUnifiedPendingTaskInfoService.remove((Wrapper)pendingWrapper);
            this.iUnifiedUnReadTaskInfoService.remove((Wrapper)unReadWrapper);
        } else {
            List unifiedUnReadTaskInfos = this.iUnifiedUnReadTaskInfoService.list((Wrapper)unReadWrapper);
            List unifiedDoneTaskInfos = this.iUnifiedDoneTaskInfoService.list((Wrapper)doneWrapper);
            List unifiedPendingTaskInfos = this.iUnifiedPendingTaskInfoService.list((Wrapper)pendingWrapper);
            List unifiedTodoTaskInfos = this.iUnifiedTodoTaskInfoService.list((Wrapper)todoWrapper);
            List unifiedReadedTaskInfos = this.iUnifiedReadedTaskInfoService.list((Wrapper)readedWrapper);
            ArrayList<UnifiedUnReadTaskInfo> unifiedUnReadTaskInfoNews = new ArrayList<UnifiedUnReadTaskInfo>();
            ArrayList<UnifiedDoneTaskInfo> unifiedDoneTaskInfoNews = new ArrayList<UnifiedDoneTaskInfo>();
            ArrayList<UnifiedPendingTaskInfo> unifiedPendingTaskInfoNews = new ArrayList<UnifiedPendingTaskInfo>();
            ArrayList<UnifiedTodoTaskInfo> unifiedTodoTaskInfoNews = new ArrayList<UnifiedTodoTaskInfo>();
            ArrayList<UnifiedReadedTaskInfo> unifiedReadedTaskInfoNews = new ArrayList<UnifiedReadedTaskInfo>();
            if (HussarUtils.isNotEmpty((Object)unifiedReadedTaskInfos)) {
                for (UnifiedReadedTaskInfo unifiedReadedTaskInfo : unifiedReadedTaskInfos) {
                    unifiedReadedTaskInfo.setDeptId(unifiedTaskUser.getDeptId());
                    unifiedReadedTaskInfo.setDeptName(unifiedTaskUser.getDeptName());
                    unifiedReadedTaskInfo.setUnitId(unifiedTaskUser.getUnitId());
                    unifiedReadedTaskInfo.setUnitName(unifiedTaskUser.getUnitName());
                    unifiedReadedTaskInfo.setPostId(unifiedTaskUser.getPostId());
                    unifiedReadedTaskInfo.setPostName(unifiedTaskUser.getPostName());
                    unifiedReadedTaskInfo.setUserId(unifiedTaskUser.getUserId());
                    unifiedReadedTaskInfo.setMandators(unifiedTaskUser.getMandator());
                    unifiedReadedTaskInfo.setUserTypes(unifiedTaskUser.getUserType());
                    unifiedReadedTaskInfo.setCompleteTime(unifiedTaskUser.getCompleteTime());
                    unifiedReadedTaskInfoNews.add(unifiedReadedTaskInfo);
                }
                this.iUnifiedReadedTaskInfoService.saveOrUpdateBatch(unifiedReadedTaskInfoNews);
            }
            if (HussarUtils.isNotEmpty((Object)unifiedUnReadTaskInfos)) {
                for (UnifiedUnReadTaskInfo unifiedUnReadTaskInfo : unifiedUnReadTaskInfos) {
                    unifiedUnReadTaskInfo.setDeptId(unifiedTaskUser.getDeptId());
                    unifiedUnReadTaskInfo.setDeptName(unifiedTaskUser.getDeptName());
                    unifiedUnReadTaskInfo.setUnitId(unifiedTaskUser.getUnitId());
                    unifiedUnReadTaskInfo.setUnitName(unifiedTaskUser.getUnitName());
                    unifiedUnReadTaskInfo.setPostId(unifiedTaskUser.getPostId());
                    unifiedUnReadTaskInfo.setPostName(unifiedTaskUser.getPostName());
                    unifiedUnReadTaskInfo.setUserId(unifiedTaskUser.getUserId());
                    unifiedUnReadTaskInfo.setMandators(unifiedTaskUser.getMandator());
                    unifiedUnReadTaskInfo.setUserTypes(unifiedTaskUser.getUserType());
                    unifiedUnReadTaskInfo.setCompleteTime(unifiedTaskUser.getCompleteTime());
                    unifiedUnReadTaskInfoNews.add(unifiedUnReadTaskInfo);
                }
                this.iUnifiedUnReadTaskInfoService.saveOrUpdateBatch(unifiedUnReadTaskInfoNews);
            }
            if (HussarUtils.isNotEmpty((Object)unifiedDoneTaskInfos)) {
                for (UnifiedDoneTaskInfo unifiedDoneTaskInfo : unifiedDoneTaskInfos) {
                    unifiedDoneTaskInfo.setDeptId(unifiedTaskUser.getDeptId());
                    unifiedDoneTaskInfo.setDeptName(unifiedTaskUser.getDeptName());
                    unifiedDoneTaskInfo.setUnitId(unifiedTaskUser.getUnitId());
                    unifiedDoneTaskInfo.setUnitName(unifiedTaskUser.getUnitName());
                    unifiedDoneTaskInfo.setPostId(unifiedTaskUser.getPostId());
                    unifiedDoneTaskInfo.setPostName(unifiedTaskUser.getPostName());
                    unifiedDoneTaskInfo.setUserId(unifiedTaskUser.getUserId());
                    unifiedDoneTaskInfo.setAssigneeUserName(unifiedTaskUser.getUserName());
                    unifiedDoneTaskInfo.setAssigneeUserNumber(unifiedTaskUser.getUserNumber());
                    unifiedDoneTaskInfo.setAssigneeDeptId(unifiedTaskUser.getDeptId());
                    unifiedDoneTaskInfo.setAssigneeDeptName(unifiedTaskUser.getDeptName());
                    unifiedDoneTaskInfo.setAssigneeUnitId(unifiedTaskUser.getUnitId());
                    unifiedDoneTaskInfo.setAssigneeUnitName(unifiedTaskUser.getUnitName());
                    unifiedDoneTaskInfo.setAssigneeMainDeptId(unifiedTaskUser.getMainDeptId());
                    unifiedDoneTaskInfo.setAssigneeMainDeptName(unifiedTaskUser.getMainDeptName());
                    unifiedDoneTaskInfo.setAssigneeMainUnitId(unifiedTaskUser.getMainUnitId());
                    unifiedDoneTaskInfo.setAssigneeMainUnitName(unifiedTaskUser.getMainUnitName());
                    unifiedDoneTaskInfo.setMandators(unifiedTaskUser.getMandator());
                    unifiedDoneTaskInfo.setUserTypes(unifiedTaskUser.getUserType());
                    unifiedDoneTaskInfo.setCompleteTime(unifiedTaskUser.getCompleteTime());
                    unifiedDoneTaskInfoNews.add(unifiedDoneTaskInfo);
                }
                this.iUnifiedDoneTaskInfoService.saveOrUpdateBatch(unifiedDoneTaskInfoNews);
            }
            if (HussarUtils.isNotEmpty((Object)unifiedPendingTaskInfos)) {
                for (UnifiedPendingTaskInfo unifiedPendingTaskInfo : unifiedPendingTaskInfos) {
                    unifiedPendingTaskInfo.setDeptId(unifiedTaskUser.getDeptId());
                    unifiedPendingTaskInfo.setDeptName(unifiedTaskUser.getDeptName());
                    unifiedPendingTaskInfo.setUnitId(unifiedTaskUser.getUnitId());
                    unifiedPendingTaskInfo.setUnitName(unifiedTaskUser.getUnitName());
                    unifiedPendingTaskInfo.setPostId(unifiedTaskUser.getPostId());
                    unifiedPendingTaskInfo.setPostName(unifiedTaskUser.getPostName());
                    unifiedPendingTaskInfo.setUserId(unifiedTaskUser.getUserId());
                    unifiedPendingTaskInfo.setMandators(unifiedTaskUser.getMandator());
                    unifiedPendingTaskInfo.setUserTypes(unifiedTaskUser.getUserType());
                    unifiedPendingTaskInfo.setCompleteTime(unifiedTaskUser.getCompleteTime());
                    unifiedPendingTaskInfoNews.add(unifiedPendingTaskInfo);
                }
                this.iUnifiedPendingTaskInfoService.saveOrUpdateBatch(unifiedPendingTaskInfoNews);
            }
            if (HussarUtils.isNotEmpty((Object)unifiedTodoTaskInfos)) {
                for (UnifiedTodoTaskInfo unifiedTodoTaskInfo : unifiedTodoTaskInfos) {
                    unifiedTodoTaskInfo.setDeptId(unifiedTaskUser.getDeptId());
                    unifiedTodoTaskInfo.setDeptName(unifiedTaskUser.getDeptName());
                    unifiedTodoTaskInfo.setUnitId(unifiedTaskUser.getUnitId());
                    unifiedTodoTaskInfo.setUnitName(unifiedTaskUser.getUnitName());
                    unifiedTodoTaskInfo.setPostId(unifiedTaskUser.getPostId());
                    unifiedTodoTaskInfo.setPostName(unifiedTaskUser.getPostName());
                    unifiedTodoTaskInfo.setUserId(unifiedTaskUser.getUserId());
                    unifiedTodoTaskInfo.setAssigneeUserName(unifiedTaskUser.getUserName());
                    unifiedTodoTaskInfo.setAssigneeUserNumber(unifiedTaskUser.getUserNumber());
                    unifiedTodoTaskInfo.setAssigneeDeptId(unifiedTaskUser.getDeptId());
                    unifiedTodoTaskInfo.setAssigneeDeptName(unifiedTaskUser.getDeptName());
                    unifiedTodoTaskInfo.setAssigneeUnitId(unifiedTaskUser.getUnitId());
                    unifiedTodoTaskInfo.setAssigneeUnitName(unifiedTaskUser.getUnitName());
                    unifiedTodoTaskInfo.setAssigneeMainDeptId(unifiedTaskUser.getMainDeptId());
                    unifiedTodoTaskInfo.setAssigneeMainDeptName(unifiedTaskUser.getMainDeptName());
                    unifiedTodoTaskInfo.setAssigneeMainUnitId(unifiedTaskUser.getMainUnitId());
                    unifiedTodoTaskInfo.setAssigneeMainUnitName(unifiedTaskUser.getMainUnitName());
                    unifiedTodoTaskInfo.setMandators(unifiedTaskUser.getMandator());
                    unifiedTodoTaskInfo.setUserTypes(unifiedTaskUser.getUserType());
                    unifiedTodoTaskInfo.setCompleteTime(unifiedTaskUser.getCompleteTime());
                    unifiedTodoTaskInfoNews.add(unifiedTodoTaskInfo);
                }
                this.iUnifiedTodoTaskInfoService.saveOrUpdateBatch(unifiedTodoTaskInfoNews);
            }
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> userChange(UserDeleteDto userDeleteDto, UserAddBatchDto userAddBatchDto) {
        ApiResponse<String> isDeleteSuccess;
        if (userDeleteDto != null && !(isDeleteSuccess = this.userDelete(userDeleteDto)).isSuccess()) {
            return isDeleteSuccess;
        }
        if (userAddBatchDto != null) {
            return this.userAddBatch(userAddBatchDto);
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> userChangeClassify(UserDeleteDto userDeleteDto, UserAddBatchDto userAddBatchDto) {
        ApiResponse<String> isDeleteSuccess;
        if (userDeleteDto != null && !(isDeleteSuccess = this.userDeleteClassify(userDeleteDto)).isSuccess()) {
            return isDeleteSuccess;
        }
        if (userAddBatchDto != null) {
            return this.userAddBatchClassify(userAddBatchDto);
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> taskAddBatch(TaskAddBatchDto taskAddBatchDto) {
        ApiResponse isBuildSuccess = taskAddBatchDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        ArrayList taskInfos = new ArrayList();
        ArrayList taskUsers = new ArrayList();
        taskAddBatchDto.getTaskInfos().forEach(taskInfoWithUser -> {
            taskInfos.add(taskInfoWithUser.getTaskInfo());
            if (taskInfoWithUser.getTaskUsers() != null) {
                taskUsers.addAll(taskInfoWithUser.getTaskUsers());
            }
        });
        this.unifiedTaskInfoService.saveBatch(taskInfos);
        if (HussarUtils.isNotEmpty(taskUsers)) {
            this.unifiedTaskUserService.saveBatch(taskUsers);
        }
        if (this.unifiedTodoProperties.getOpen() && CollectionUtil.isNotEmpty(taskInfos)) {
            logger.info("\u6284\u9001\u63a8\u9001\u5f00\u59cb");
            for (UnifiedTaskInfo taskInfo : taskInfos) {
                List<Object> resultList;
                List<UnifiedTaskUser> partList = taskUsers.stream().filter(u -> u.getTaskId().equals(taskInfo.getTaskId())).collect(Collectors.toList());
                if ("4".equals(taskInfo.getTaskStatus())) {
                    List allIdList;
                    List allUserList;
                    List allList = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getProcessInstanceid, (Object)taskInfo.getProcessInstanceid())).ne(UnifiedTaskInfo::getTaskId, (Object)taskInfo.getTaskId()));
                    if (!CollectionUtil.isNotEmpty((Collection)allList) || !CollectionUtil.isNotEmpty((Collection)(allUserList = this.unifiedTaskUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskUser::getTaskId, allIdList = allList.stream().map(UnifiedTaskInfo::getTaskId).collect(Collectors.toList()))).eq(UnifiedTaskUser::getSystemId, (Object)taskInfo.getSystemId()))))) continue;
                    List allUserIds = allUserList.stream().map(UnifiedTaskUser::getUserId).collect(Collectors.toList());
                    resultList = partList.stream().filter(u -> !allUserIds.contains(u.getUserId())).collect(Collectors.toList());
                } else {
                    resultList = partList;
                }
                this.pushTaskToOa(taskInfo, resultList, null);
            }
            if ("2".equals(((UnifiedTaskInfo)taskInfos.get(0)).getTaskStatus())) {
                logger.info("\u5f85\u5ba1\u63a8\u9001\u5f00\u59cb");
                List taskInfoList = this.unifiedTaskInfoService.list((Wrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getProcessInstanceid, (Object)((UnifiedTaskInfo)taskInfos.get(0)).getProcessInstanceid()));
                List ccList = taskInfoList.stream().filter(t -> "4".equals(t.getTaskStatus())).collect(Collectors.toList());
                List unCcList = taskInfoList.stream().filter(t -> !"4".equals(t.getTaskStatus())).collect(Collectors.toList());
                if (CollectionUtil.isEmpty(ccList)) {
                    return ApiResponse.success((Object)"", null);
                }
                List taskIdList = taskInfoList.stream().map(UnifiedTaskInfo::getTaskId).collect(Collectors.toList());
                List taskUserList = this.unifiedTaskUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskUser::getTaskId, taskIdList)).eq(UnifiedTaskUser::getSystemId, (Object)((UnifiedTaskInfo)taskInfos.get(0)).getSystemId()));
                if (CollectionUtil.isEmpty((Collection)taskUserList)) {
                    return ApiResponse.success((Object)"", null);
                }
                List ccTaskIdList = ccList.stream().map(UnifiedTaskInfo::getTaskId).collect(Collectors.toList());
                List unCcTaskIdList = unCcList.stream().map(UnifiedTaskInfo::getTaskId).collect(Collectors.toList());
                List ccUserList = taskUserList.stream().filter(t -> ccTaskIdList.contains(t.getTaskId())).collect(Collectors.toList());
                List unCcUserIdList = taskUserList.stream().filter(t -> unCcTaskIdList.contains(t.getTaskId())).map(UnifiedTaskUser::getUserId).collect(Collectors.toList());
                for (UnifiedTaskInfo unifiedTaskInfo : ccList) {
                    logger.info("\u6d41\u7a0b\u914d\u7f6e\u7684\u6284\u9001\u6570\u636e:" + JSON.toJSONString((Object)unifiedTaskInfo));
                    List partUserList = ccUserList.stream().filter(c -> c.getTaskId().equals(unifiedTaskInfo.getTaskId())).collect(Collectors.toList());
                    if (CollectionUtil.isEmpty(partUserList)) continue;
                    List<UnifiedTaskUser> unifiedTaskUsers = partUserList.stream().filter(p -> !unCcUserIdList.contains(p.getUserId())).collect(Collectors.toList());
                    this.pushTaskToOa(unifiedTaskInfo, unifiedTaskUsers, null);
                }
            }
        }
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> taskAddBatchClassify(TaskAddBatchDto taskAddBatchDto) {
        ApiResponse isBuildSuccess = taskAddBatchDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        ArrayList taskInfos = new ArrayList();
        ArrayList taskUsers = new ArrayList();
        ArrayList doneTaskInfos = new ArrayList();
        ArrayList pendingTaskInfos = new ArrayList();
        ArrayList readedTaskInfos = new ArrayList();
        ArrayList todoTaskInfos = new ArrayList();
        ArrayList unReadTaskInfos = new ArrayList();
        taskAddBatchDto.getTaskInfos().forEach(taskInfoWithUser -> {
            if (HussarUtils.isNotEmpty((Object)taskInfoWithUser.getTaskInfo())) {
                switch (taskInfoWithUser.getTaskInfo().getTaskStatus()) {
                    case "1": {
                        todoTaskInfos.addAll(this.encapsulationDataTodo(taskInfoWithUser.getTaskInfo(), taskInfoWithUser.getTaskUsers()));
                        break;
                    }
                    case "2": {
                        pendingTaskInfos.addAll(this.encapsulationDataPending(taskInfoWithUser.getTaskInfo(), taskInfoWithUser.getTaskUsers()));
                        break;
                    }
                    case "4": {
                        unReadTaskInfos.addAll(this.encapsulationDataUnRead(taskInfoWithUser.getTaskInfo(), taskInfoWithUser.getTaskUsers()));
                        break;
                    }
                    case "5": {
                        readedTaskInfos.addAll(this.encapsulationDataRead(taskInfoWithUser.getTaskInfo(), taskInfoWithUser.getTaskUsers()));
                        break;
                    }
                    default: {
                        doneTaskInfos.addAll(this.encapsulationDataDone(taskInfoWithUser.getTaskInfo(), taskInfoWithUser.getTaskUsers()));
                    }
                }
            }
            if (taskInfoWithUser.getTaskUsers() != null) {
                taskUsers.addAll(taskInfoWithUser.getTaskUsers());
            }
        });
        if (HussarUtils.isNotEmpty(doneTaskInfos)) {
            this.iUnifiedDoneTaskInfoService.saveBatch(doneTaskInfos);
        }
        if (HussarUtils.isNotEmpty(pendingTaskInfos)) {
            this.iUnifiedPendingTaskInfoService.saveBatch(pendingTaskInfos);
        }
        if (HussarUtils.isNotEmpty(readedTaskInfos)) {
            this.iUnifiedReadedTaskInfoService.saveBatch(readedTaskInfos);
        }
        if (HussarUtils.isNotEmpty(todoTaskInfos)) {
            this.iUnifiedTodoTaskInfoService.saveBatch(todoTaskInfos);
        }
        if (HussarUtils.isNotEmpty(unReadTaskInfos)) {
            this.iUnifiedUnReadTaskInfoService.saveBatch(unReadTaskInfos);
        }
        if (HussarUtils.isNotEmpty(taskUsers)) {
            this.unifiedTaskUserService.saveBatch(taskUsers);
        }
        if (this.unifiedTodoProperties.getOpen()) {
            List<UnifiedTaskUser> partList;
            if (CollectionUtil.isNotEmpty(unReadTaskInfos)) {
                logger.info("\u6284\u9001\u63a8\u9001\u5f00\u59cb");
                for (UnifiedUnReadTaskInfo unReadTaskInfo : unReadTaskInfos) {
                    List allUserList;
                    List readTaskInfoList;
                    List doneTaskInfoList;
                    List pendingTaskInfoList;
                    logger.info("unReadTaskInfo\u672a\u8bfb\uff1a" + JSON.toJSONString((Object)unReadTaskInfo));
                    partList = taskUsers.stream().filter(u -> u.getTaskId().equals(unReadTaskInfo.getTaskId())).collect(Collectors.toList());
                    List<Object> resultList = new ArrayList<UnifiedTaskUser>();
                    ArrayList allIdList = new ArrayList();
                    List todoTaskInfoList = this.iUnifiedTodoTaskInfoService.list((Wrapper)new LambdaQueryWrapper().eq(UnifiedTodoTaskInfo::getProcessInstanceid, (Object)unReadTaskInfo.getProcessInstanceid()));
                    if (CollectionUtil.isNotEmpty((Collection)todoTaskInfoList)) {
                        todoTaskInfoList.forEach(t -> allIdList.add(t.getTaskId()));
                    }
                    if (CollectionUtil.isNotEmpty((Collection)(pendingTaskInfoList = this.iUnifiedPendingTaskInfoService.list((Wrapper)new LambdaQueryWrapper().eq(UnifiedPendingTaskInfo::getProcessInstanceid, (Object)unReadTaskInfo.getProcessInstanceid()))))) {
                        pendingTaskInfoList.forEach(t -> allIdList.add(t.getTaskId()));
                    }
                    if (CollectionUtil.isNotEmpty((Collection)(doneTaskInfoList = this.iUnifiedDoneTaskInfoService.list((Wrapper)new LambdaQueryWrapper().eq(UnifiedDoneTaskInfo::getProcessInstanceid, (Object)unReadTaskInfo.getProcessInstanceid()))))) {
                        doneTaskInfoList.forEach(t -> allIdList.add(t.getTaskId()));
                    }
                    if (CollectionUtil.isNotEmpty((Collection)(readTaskInfoList = this.iUnifiedReadedTaskInfoService.list((Wrapper)new LambdaQueryWrapper().eq(UnifiedReadedTaskInfo::getProcessInstanceid, (Object)unReadTaskInfo.getProcessInstanceid()))))) {
                        readTaskInfoList.forEach(t -> allIdList.add(t.getTaskId()));
                    }
                    if (CollectionUtil.isNotEmpty(allIdList) && CollectionUtil.isNotEmpty((Collection)(allUserList = this.unifiedTaskUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskUser::getTaskId, allIdList)).eq(UnifiedTaskUser::getSystemId, (Object)unReadTaskInfo.getSystemId()))))) {
                        List allUserIds = allUserList.stream().map(UnifiedTaskUser::getUserId).collect(Collectors.toList());
                        resultList = partList.stream().filter(u -> !allUserIds.contains(u.getUserId())).collect(Collectors.toList());
                    }
                    this.pushTaskToOa(null, null, null, unReadTaskInfo, null, resultList, null);
                }
            }
            if (CollectionUtil.isNotEmpty(pendingTaskInfos)) {
                List unReadTaskInfoList;
                List readTaskInfoList;
                List doneTaskInfoList;
                List pendingTaskInfoList;
                logger.info("\u5f85\u5ba1\u63a8\u9001\u5f00\u59cb");
                ArrayList ccIdList = new ArrayList();
                ArrayList unCcIdList = new ArrayList();
                List todoTaskInfoList = this.iUnifiedTodoTaskInfoService.list((Wrapper)new LambdaQueryWrapper().eq(UnifiedTodoTaskInfo::getProcessInstanceid, (Object)((UnifiedPendingTaskInfo)pendingTaskInfos.get(0)).getProcessInstanceid()));
                if (CollectionUtil.isNotEmpty((Collection)todoTaskInfoList)) {
                    todoTaskInfoList.forEach(t -> unCcIdList.add(t.getTaskId()));
                }
                if (CollectionUtil.isNotEmpty((Collection)(pendingTaskInfoList = this.iUnifiedPendingTaskInfoService.list((Wrapper)new LambdaQueryWrapper().eq(UnifiedPendingTaskInfo::getProcessInstanceid, (Object)((UnifiedPendingTaskInfo)pendingTaskInfos.get(0)).getProcessInstanceid()))))) {
                    pendingTaskInfoList.forEach(t -> unCcIdList.add(t.getTaskId()));
                }
                if (CollectionUtil.isNotEmpty((Collection)(doneTaskInfoList = this.iUnifiedDoneTaskInfoService.list((Wrapper)new LambdaQueryWrapper().eq(UnifiedDoneTaskInfo::getProcessInstanceid, (Object)((UnifiedPendingTaskInfo)pendingTaskInfos.get(0)).getProcessInstanceid()))))) {
                    doneTaskInfoList.forEach(t -> unCcIdList.add(t.getTaskId()));
                }
                if (CollectionUtil.isNotEmpty((Collection)(readTaskInfoList = this.iUnifiedReadedTaskInfoService.list((Wrapper)new LambdaQueryWrapper().eq(UnifiedReadedTaskInfo::getProcessInstanceid, (Object)((UnifiedPendingTaskInfo)pendingTaskInfos.get(0)).getProcessInstanceid()))))) {
                    readTaskInfoList.forEach(t -> unCcIdList.add(t.getTaskId()));
                }
                if (CollectionUtil.isEmpty((Collection)(unReadTaskInfoList = this.iUnifiedUnReadTaskInfoService.list((Wrapper)new LambdaQueryWrapper().eq(UnifiedUnReadTaskInfo::getProcessInstanceid, (Object)((UnifiedPendingTaskInfo)pendingTaskInfos.get(0)).getProcessInstanceid()))))) {
                    return ApiResponse.success((Object)"", null);
                }
                unReadTaskInfoList.forEach(t -> ccIdList.add(t.getTaskId()));
                List ccTaskUserList = this.unifiedTaskUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskUser::getTaskId, ccIdList)).eq(UnifiedTaskUser::getSystemId, (Object)((UnifiedTaskInfo)taskInfos.get(0)).getSystemId()));
                List unCcTaskUserList = this.unifiedTaskUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskUser::getTaskId, unCcIdList)).eq(UnifiedTaskUser::getSystemId, (Object)((UnifiedTaskInfo)taskInfos.get(0)).getSystemId()));
                if (CollectionUtil.isEmpty((Collection)ccTaskUserList)) {
                    return ApiResponse.success((Object)"", null);
                }
                ArrayList unCcUserIdList = CollectionUtil.isEmpty((Collection)unCcTaskUserList) ? new ArrayList() : unCcTaskUserList.stream().map(UnifiedTaskUser::getUserId).collect(Collectors.toList());
                for (UnifiedUnReadTaskInfo unReadTaskInfo : unReadTaskInfoList) {
                    logger.info("\u6d41\u7a0b\u914d\u7f6e\u7684\u6284\u9001\u6570\u636e:" + JSON.toJSONString((Object)unReadTaskInfo));
                    List partUserList = ccTaskUserList.stream().filter(c -> c.getTaskId().equals(unReadTaskInfo.getTaskId())).collect(Collectors.toList());
                    if (CollectionUtil.isEmpty(partUserList)) continue;
                    List<UnifiedTaskUser> unifiedTaskUsers = partUserList.stream().filter(p -> !unCcUserIdList.contains(p.getUserId())).collect(Collectors.toList());
                    this.pushTaskToOa(null, null, null, unReadTaskInfo, null, unifiedTaskUsers, null);
                }
            }
            if (HussarUtils.isNotEmpty(todoTaskInfos)) {
                for (UnifiedTodoTaskInfo todoTaskInfo : todoTaskInfos) {
                    logger.info("todoTaskInfo\u9700\u5ba1\uff1a" + JSON.toJSONString((Object)todoTaskInfo));
                    partList = taskUsers.stream().filter(u -> u.getTaskId().equals(todoTaskInfo.getTaskId())).collect(Collectors.toList());
                    this.pushTaskToOa(todoTaskInfo, null, null, null, null, partList, null);
                }
            }
            if (HussarUtils.isNotEmpty(doneTaskInfos)) {
                for (UnifiedDoneTaskInfo doneTaskInfo : doneTaskInfos) {
                    logger.info("doneTaskInfo\u5df2\u5ba1\uff1a" + JSON.toJSONString((Object)doneTaskInfo));
                    partList = taskUsers.stream().filter(u -> u.getTaskId().equals(doneTaskInfo.getTaskId())).collect(Collectors.toList());
                    this.pushTaskToOa(null, null, doneTaskInfo, null, null, partList, null);
                }
            }
            if (HussarUtils.isNotEmpty(readedTaskInfos)) {
                for (UnifiedReadedTaskInfo readTaskInfo : readedTaskInfos) {
                    logger.info("readTaskInfo\u6284\u9001\u5df2\u8bfb\uff1a" + JSON.toJSONString((Object)readTaskInfo));
                    partList = taskUsers.stream().filter(u -> u.getTaskId().equals(readTaskInfo.getTaskId())).collect(Collectors.toList());
                    this.pushTaskToOa(null, null, null, null, readTaskInfo, partList, null);
                }
            }
        }
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> taskAdd(TaskInfoWithUser taskInfoWithUser) {
        ApiResponse isBuildSuccess = taskInfoWithUser.buildAllInfoForTaskAdd();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        this.unifiedTaskInfoService.save((Object)taskInfoWithUser.getTaskInfo());
        if (HussarUtils.isNotEmpty((Object)taskInfoWithUser.getTaskUsers())) {
            this.unifiedTaskUserService.saveBatch((Collection)taskInfoWithUser.getTaskUsers());
        }
        if (this.unifiedTodoProperties.getOpen()) {
            UnifiedTaskInfo taskInfo = taskInfoWithUser.getTaskInfo();
            List taskUsers = taskInfoWithUser.getTaskUsers();
            this.pushTaskToOa(taskInfo, taskUsers, null);
        }
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> taskAddClassify(TaskInfoWithUser taskInfoWithUser) {
        ApiResponse isBuildSuccess = taskInfoWithUser.buildAllInfoForTaskAdd();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        ArrayList<UnifiedDoneTaskInfo> doneTaskInfos = new ArrayList<UnifiedDoneTaskInfo>();
        ArrayList<UnifiedPendingTaskInfo> pendingTaskInfos = new ArrayList<UnifiedPendingTaskInfo>();
        ArrayList<UnifiedReadedTaskInfo> readedTaskInfos = new ArrayList<UnifiedReadedTaskInfo>();
        ArrayList<UnifiedTodoTaskInfo> todoTaskInfos = new ArrayList<UnifiedTodoTaskInfo>();
        ArrayList<UnifiedUnReadTaskInfo> unReadTaskInfos = new ArrayList<UnifiedUnReadTaskInfo>();
        if (HussarUtils.isNotEmpty((Object)taskInfoWithUser.getTaskInfo())) {
            switch (taskInfoWithUser.getTaskInfo().getTaskStatus()) {
                case "1": {
                    todoTaskInfos.addAll(this.encapsulationDataTodo(taskInfoWithUser.getTaskInfo(), taskInfoWithUser.getTaskUsers()));
                    break;
                }
                case "2": {
                    pendingTaskInfos.addAll(this.encapsulationDataPending(taskInfoWithUser.getTaskInfo(), taskInfoWithUser.getTaskUsers()));
                    break;
                }
                case "4": {
                    unReadTaskInfos.addAll(this.encapsulationDataUnRead(taskInfoWithUser.getTaskInfo(), taskInfoWithUser.getTaskUsers()));
                    break;
                }
                case "5": {
                    readedTaskInfos.addAll(this.encapsulationDataRead(taskInfoWithUser.getTaskInfo(), taskInfoWithUser.getTaskUsers()));
                    break;
                }
                default: {
                    doneTaskInfos.addAll(this.encapsulationDataDone(taskInfoWithUser.getTaskInfo(), taskInfoWithUser.getTaskUsers()));
                }
            }
        }
        if (HussarUtils.isNotEmpty(doneTaskInfos)) {
            this.iUnifiedDoneTaskInfoService.saveBatch(doneTaskInfos);
        }
        if (HussarUtils.isNotEmpty(pendingTaskInfos)) {
            this.iUnifiedPendingTaskInfoService.saveBatch(pendingTaskInfos);
        }
        if (HussarUtils.isNotEmpty(readedTaskInfos)) {
            this.iUnifiedReadedTaskInfoService.saveBatch(readedTaskInfos);
        }
        if (HussarUtils.isNotEmpty(todoTaskInfos)) {
            this.iUnifiedTodoTaskInfoService.saveBatch(todoTaskInfos);
        }
        if (HussarUtils.isNotEmpty(unReadTaskInfos)) {
            this.iUnifiedUnReadTaskInfoService.saveBatch(unReadTaskInfos);
        }
        if (HussarUtils.isNotEmpty((Object)taskInfoWithUser.getTaskUsers())) {
            this.unifiedTaskUserService.saveBatch((Collection)taskInfoWithUser.getTaskUsers());
        }
        if (this.unifiedTodoProperties.getOpen()) {
            List taskUsers = taskInfoWithUser.getTaskUsers();
            switch (taskInfoWithUser.getTaskInfo().getTaskStatus()) {
                case "1": {
                    this.pushTaskToOa(CollectionUtil.isEmpty(todoTaskInfos) ? null : (UnifiedTodoTaskInfo)todoTaskInfos.get(0), null, null, null, null, taskUsers, null);
                    break;
                }
                case "2": {
                    this.pushTaskToOa(null, CollectionUtil.isEmpty(pendingTaskInfos) ? null : (UnifiedPendingTaskInfo)pendingTaskInfos.get(0), null, null, null, taskUsers, null);
                    break;
                }
                case "4": {
                    this.pushTaskToOa(null, null, null, CollectionUtil.isEmpty(unReadTaskInfos) ? null : (UnifiedUnReadTaskInfo)unReadTaskInfos.get(0), null, taskUsers, null);
                    break;
                }
                case "5": {
                    this.pushTaskToOa(null, null, null, null, CollectionUtil.isEmpty(readedTaskInfos) ? null : (UnifiedReadedTaskInfo)readedTaskInfos.get(0), taskUsers, null);
                    break;
                }
                default: {
                    this.pushTaskToOa(null, null, CollectionUtil.isEmpty(doneTaskInfos) ? null : (UnifiedDoneTaskInfo)doneTaskInfos.get(0), null, null, taskUsers, null);
                }
            }
        }
        return ApiResponse.success((Object)"", null);
    }

    private void pushTaskToOa(UnifiedTodoTaskInfo todoTaskInfo, UnifiedPendingTaskInfo pendingTaskInfo, UnifiedDoneTaskInfo doneTaskInfo, UnifiedUnReadTaskInfo unReadTaskInfo, UnifiedReadedTaskInfo readTaskInfo, List<UnifiedTaskUser> taskUsers, UnifiedProcessInfo unifiedProcessInfo) {
        if (CollectionUtil.isEmpty(taskUsers)) {
            return;
        }
        if (ObjectUtil.isNotNull((Object)todoTaskInfo)) {
            logger.info("\u9700\u5ba1todoTaskInfo:" + JSON.toJSONString((Object)todoTaskInfo));
            this.pushOfContent(todoTaskInfo.getProcessInstanceid(), todoTaskInfo.getTaskId(), todoTaskInfo.getCreateUserId(), todoTaskInfo.getTaskName(), todoTaskInfo.getMobileLinkurl(), todoTaskInfo.getTaskStatus(), todoTaskInfo.getCreateTime(), taskUsers, unifiedProcessInfo);
            return;
        }
        if (ObjectUtil.isNotNull((Object)pendingTaskInfo)) {
            logger.info("\u5f85\u5ba1pendingTaskInfo:" + JSON.toJSONString((Object)pendingTaskInfo));
            this.pushOfContent(pendingTaskInfo.getProcessInstanceid(), pendingTaskInfo.getTaskId(), pendingTaskInfo.getCreateUserId(), pendingTaskInfo.getTaskName(), pendingTaskInfo.getMobileLinkurl(), pendingTaskInfo.getTaskStatus(), pendingTaskInfo.getCreateTime(), taskUsers, unifiedProcessInfo);
            return;
        }
        if (ObjectUtil.isNotNull((Object)doneTaskInfo)) {
            logger.info("\u5df2\u5ba1doneTaskInfo:" + JSON.toJSONString((Object)doneTaskInfo));
            this.pushOfContent(doneTaskInfo.getProcessInstanceid(), doneTaskInfo.getTaskId(), doneTaskInfo.getCreateUserId(), doneTaskInfo.getTaskName(), doneTaskInfo.getMobileLinkurl(), doneTaskInfo.getTaskStatus(), doneTaskInfo.getCreateTime(), taskUsers, unifiedProcessInfo);
            return;
        }
        if (ObjectUtil.isNotNull((Object)unReadTaskInfo)) {
            logger.info("\u672a\u8bfbunReadTaskInfo:" + JSON.toJSONString((Object)unReadTaskInfo));
            this.pushOfContent(unReadTaskInfo.getProcessInstanceid(), unReadTaskInfo.getTaskId(), unReadTaskInfo.getCreateUserId(), unReadTaskInfo.getTaskName(), unReadTaskInfo.getMobileLinkurl(), unReadTaskInfo.getTaskStatus(), unReadTaskInfo.getCreateTime(), taskUsers, unifiedProcessInfo);
            return;
        }
        if (ObjectUtil.isNotNull((Object)readTaskInfo)) {
            logger.info("\u5df2\u8bfbreadTaskInfo:" + JSON.toJSONString((Object)readTaskInfo));
            this.pushOfContent(readTaskInfo.getProcessInstanceid(), readTaskInfo.getTaskId(), readTaskInfo.getCreateUserId(), readTaskInfo.getTaskName(), readTaskInfo.getMobileLinkurl(), readTaskInfo.getTaskStatus(), readTaskInfo.getCreateTime(), taskUsers, unifiedProcessInfo);
        }
    }

    private void pushOfContent(String processInstanceId, String taskId, String createUserId, String taskName, String mobileLinkUrl, String taskStatus, Date createTime, List<UnifiedTaskUser> taskUsers, UnifiedProcessInfo unifiedProcessInfo) {
        for (UnifiedTaskUser taskUser : taskUsers) {
            logger.info("taskUser:" + JSON.toJSONString((Object)taskUser));
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            UnifiedProcessInfo processInfo = !HussarUtils.isNull((Object)unifiedProcessInfo) ? unifiedProcessInfo : (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)processInstanceId));
            if (HussarUtils.isNull((Object)processInfo)) {
                return;
            }
            String sendUserString = processInfo.getStartUserId();
            SysUsers sendUser = this.usersService.getUserByOutOriginId(sendUserString);
            SysUsers receiver = this.usersService.getUserByOutOriginId(taskUser.getUserId());
            if (HussarUtils.isNull((Object)sendUser) || HussarUtils.isNull((Object)receiver)) {
                this.HandlerLog(sendUserString, createUserId);
                return;
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("syscode", this.unifiedTodoProperties.getOaThirdCode());
            data.put("flowid", processInstanceId);
            data.put("requestname", processInfo.getProcessName());
            data.put("workflowname", processInfo.getProcessName());
            data.put("nodename", taskName);
            data.put("appurl", mobileLinkUrl);
            String flowState = this.getFlowState(processInfo, data, processInstanceId, taskId, taskStatus);
            if (HussarUtils.isNull((Object)flowState)) {
                return;
            }
            data.put("isremark", flowState);
            data.put("viewtype", this.getReadState(taskStatus));
            data.put("creator", sendUser.getUserAccount());
            data.put("createdatetime", HussarUtils.isNull((Object)processInfo.getStartTime()) ? sf.format(DateUtil.now()) : sf.format(processInfo.getStartTime()));
            data.put("receiver", receiver.getUserAccount());
            data.put("receivedatetime", HussarUtils.isNull((Object)createTime) ? sf.format(DateUtil.now()) : sf.format(createTime));
            data.put("receivets", String.valueOf(System.currentTimeMillis()));
            try {
                String resultData = JSON.toJSONString(data);
                logger.info("requestParam:" + resultData);
                String resp = HttpClientUtil.httpPost(this.unifiedTodoProperties.getReceiveDataUrl(), resultData, null);
                logger.info("responseParam:" + resp);
                JSONObject jsonObject = JSON.parseObject((String)resp);
                if (!jsonObject.get((Object)"operResult").equals("0")) continue;
                this.HandlerLog(sendUserString, createUserId);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.HandlerLog(sendUserString, createUserId);
            }
        }
    }

    private void pushTaskToOa(UnifiedTaskInfo taskInfo, List<UnifiedTaskUser> taskUsers, UnifiedProcessInfo unifiedProcessInfo) {
        if (CollectionUtil.isEmpty(taskUsers)) {
            return;
        }
        logger.info("taskInfo:" + JSON.toJSONString((Object)taskInfo));
        for (UnifiedTaskUser taskUser : taskUsers) {
            logger.info("taskUser:" + JSON.toJSONString((Object)taskUser));
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            UnifiedProcessInfo processInfo = !HussarUtils.isNull((Object)unifiedProcessInfo) ? unifiedProcessInfo : (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)taskInfo.getProcessInstanceid()));
            if (HussarUtils.isNull((Object)processInfo)) {
                return;
            }
            String sendUserString = processInfo.getStartUserId();
            SysUsers sendUser = this.usersService.getUserByOutOriginId(sendUserString);
            SysUsers receiver = this.usersService.getUserByOutOriginId(taskUser.getUserId());
            if (HussarUtils.isNull((Object)sendUser) || HussarUtils.isNull((Object)receiver)) {
                this.HandlerLog(sendUserString, taskInfo.getCreateUserId());
                return;
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("syscode", this.unifiedTodoProperties.getOaThirdCode());
            data.put("flowid", taskInfo.getProcessInstanceid());
            data.put("requestname", processInfo.getProcessName());
            data.put("workflowname", processInfo.getProcessName());
            data.put("nodename", taskInfo.getTaskName());
            data.put("appurl", taskInfo.getMobileLinkurl());
            String flowState = this.getFlowState(processInfo, data, taskInfo);
            if (HussarUtils.isNull((Object)flowState)) {
                return;
            }
            data.put("isremark", flowState);
            data.put("viewtype", this.getReadState(taskInfo.getTaskStatus()));
            data.put("creator", sendUser.getUserAccount());
            data.put("createdatetime", HussarUtils.isNull((Object)processInfo.getStartTime()) ? sf.format(DateUtil.now()) : sf.format(processInfo.getStartTime()));
            data.put("receiver", receiver.getUserAccount());
            data.put("receivedatetime", HussarUtils.isNull((Object)taskInfo.getCreateTime()) ? sf.format(DateUtil.now()) : sf.format(taskInfo.getCreateTime()));
            data.put("receivets", String.valueOf(System.currentTimeMillis()));
            try {
                String resultData = JSON.toJSONString(data);
                logger.info("requestParam:" + resultData);
                String resp = HttpClientUtil.httpPost(this.unifiedTodoProperties.getReceiveDataUrl(), resultData, null);
                logger.info("responseParam:" + resp);
                JSONObject jsonObject = JSON.parseObject((String)resp);
                if (!jsonObject.get((Object)"operResult").equals("0")) continue;
                this.HandlerLog(sendUserString, taskInfo.getCreateUserId());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.HandlerLog(sendUserString, taskInfo.getCreateUserId());
            }
        }
    }

    private void HandlerLog(String userId, String userName) {
        UserDetails userDetails = new UserDetails();
        AuditLogModel auditLogModel = new AuditLogModel();
        auditLogModel.setModuleName(MODULE_NAME);
        auditLogModel.setEventGrade(AuditEventGrade.SERVICE_LOG_TYPE);
        auditLogModel.setEventType(AuditEventType.EXCEPTION);
        auditLogModel.setEventDesc("\u7528\u6237\u8bbf\u95eeOA-\u6570\u636e\u63a8\u9001");
        userDetails.setUserIdStr(userId);
        userDetails.setUserName(userName);
        auditLogModel.setUserDetails(userDetails);
        AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
    }

    private String getFlowState(UnifiedProcessInfo processInfo, Map<String, Object> data, String processInstanceId, String taskId, String taskStatus) {
        if ("1".equals(taskStatus)) {
            data.put("pcurl", this.unifiedTodoProperties.getToBe() + "%2526taskId=" + taskId);
            logger.info("pcurl:" + data.get("pcurl"));
            return "0";
        }
        if ("3".equals(taskStatus) && ProcessState.RUNNING.getValue().equals(processInfo.getProcessState()) || "5".equals(taskStatus)) {
            data.put("pcurl", this.unifiedTodoProperties.getToDoList() + "%2526processInstId=" + processInstanceId);
            logger.info("pcurl:" + data.get("pcurl"));
            return "2";
        }
        if ("3".equals(taskStatus)) {
            data.put("pcurl", this.unifiedTodoProperties.getToDoList() + "%2526processInstId=" + processInstanceId);
            logger.info("pcurl:" + data.get("pcurl"));
            return "4";
        }
        if ("4".equals(taskStatus)) {
            data.put("pcurl", this.unifiedTodoProperties.getToUnRead() + "%2526taskId=" + taskId);
            logger.info("pcurl:" + data.get("pcurl"));
            return "8";
        }
        return null;
    }

    private String getFlowState(UnifiedProcessInfo processInfo, Map<String, Object> data, UnifiedTaskInfo taskInfo) {
        if ("1".equals(taskInfo.getTaskStatus())) {
            data.put("pcurl", this.unifiedTodoProperties.getToBe() + "%2526taskId=" + taskInfo.getTaskId());
            logger.info("pcurl:" + data.get("pcurl"));
            return "0";
        }
        if ("3".equals(taskInfo.getTaskStatus()) && ProcessState.RUNNING.getValue().equals(processInfo.getProcessState()) || "5".equals(taskInfo.getTaskStatus())) {
            data.put("pcurl", this.unifiedTodoProperties.getToDoList() + "%2526processInstId=" + taskInfo.getProcessInstanceid());
            logger.info("pcurl:" + data.get("pcurl"));
            return "2";
        }
        if ("3".equals(taskInfo.getTaskStatus())) {
            data.put("pcurl", this.unifiedTodoProperties.getToDoList() + "%2526processInstId=" + taskInfo.getProcessInstanceid());
            logger.info("pcurl:" + data.get("pcurl"));
            return "4";
        }
        if ("4".equals(taskInfo.getTaskStatus())) {
            data.put("pcurl", this.unifiedTodoProperties.getToUnRead() + "%2526taskId=" + taskInfo.getTaskId());
            logger.info("pcurl:" + data.get("pcurl"));
            return "8";
        }
        return null;
    }

    private String getReadState(String readState) {
        if ("4".equals(readState)) {
            return "0";
        }
        if ("5".equals(readState)) {
            return "1";
        }
        return "0";
    }

    public ApiResponse<String> taskDelete(TaskDeleteDto taskDeleteDto) {
        List taskInfos;
        ApiResponse isBuildSuccess = taskDeleteDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        LambdaQueryWrapper unifiedTaskInfoQuery = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)taskDeleteDto.getProcInstId()), UnifiedTaskInfo::getProcessInstanceid, (Object)taskDeleteDto.getProcInstId())).in(HussarUtils.isNotEmpty((Object)taskDeleteDto.getTaskIds()), UnifiedTaskInfo::getTaskId, (Collection)taskDeleteDto.getTaskIds())).in(HussarUtils.isNotEmpty((Object)taskDeleteDto.getTaskTypes()), UnifiedTaskInfo::getTaskStatus, (Collection)taskDeleteDto.getTaskTypes())).eq(UnifiedTaskInfo::getSystemId, (Object)taskDeleteDto.getSystemId());
        if (taskDeleteDto.isCascade() && !(taskInfos = this.unifiedTaskInfoService.list((Wrapper)unifiedTaskInfoQuery)).isEmpty()) {
            this.unifiedTaskUserService.remove((Wrapper)new LambdaQueryWrapper().in(UnifiedTaskUser::getTaskId, (Collection)taskInfos.stream().map(UnifiedTaskInfo::getTaskId).collect(Collectors.toSet())));
        }
        this.unifiedTaskInfoService.remove((Wrapper)unifiedTaskInfoQuery);
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> taskDeleteClassify(TaskDeleteDto taskDeleteDto) {
        LambdaQueryWrapper unifiedTodoTaskInfoQuery;
        List taskInfos;
        ApiResponse isBuildSuccess = taskDeleteDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        if (this.unifiedTodoProperties.getOpen() && HussarUtils.isNotEmpty((Object)(taskInfos = this.iUnifiedTodoTaskInfoService.list((Wrapper)(unifiedTodoTaskInfoQuery = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)taskDeleteDto.getProcInstId()), UnifiedTodoTaskInfo::getProcessInstanceid, (Object)taskDeleteDto.getProcInstId())).in(HussarUtils.isNotEmpty((Object)taskDeleteDto.getTaskIds()), UnifiedTodoTaskInfo::getTaskId, (Collection)taskDeleteDto.getTaskIds())).eq(UnifiedTodoTaskInfo::getSystemId, (Object)taskDeleteDto.getSystemId())))))) {
            logger.info("\u8fd4\u56de\u6574\u6539/\u505c\u6b62\u6d41\u7a0b \u5c06\u6d41\u7a0b\u6240\u6709\u9700\u5ba1\u53d8\u6210\u5df2\u529e");
            for (UnifiedTodoTaskInfo taskInfo : taskInfos) {
                logger.info("taskInfo\uff1a" + JSON.toJSONString((Object)taskInfo));
                List todoTaskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)taskInfo.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)taskInfo.getSystemId()));
                taskInfo.setTaskStatus("3");
                this.pushTaskToOa(taskInfo, null, null, null, null, todoTaskUsers, null);
            }
        }
        if (HussarUtils.isNotEmpty((Object)taskDeleteDto.getTaskTypes())) {
            block13: for (String type : taskDeleteDto.getTaskTypes()) {
                List taskInfos2;
                switch (type) {
                    case "1": {
                        List taskInfos3;
                        LambdaQueryWrapper unifiedTodoTaskInfoQuery2 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)taskDeleteDto.getProcInstId()), UnifiedTodoTaskInfo::getProcessInstanceid, (Object)taskDeleteDto.getProcInstId())).in(HussarUtils.isNotEmpty((Object)taskDeleteDto.getTaskIds()), UnifiedTodoTaskInfo::getTaskId, (Collection)taskDeleteDto.getTaskIds())).eq(UnifiedTodoTaskInfo::getSystemId, (Object)taskDeleteDto.getSystemId());
                        if (taskDeleteDto.isCascade() && !(taskInfos3 = this.iUnifiedTodoTaskInfoService.list((Wrapper)unifiedTodoTaskInfoQuery2)).isEmpty()) {
                            this.unifiedTaskUserService.remove((Wrapper)new LambdaQueryWrapper().in(UnifiedTaskUser::getTaskId, (Collection)taskInfos3.stream().map(UnifiedTodoTaskInfo::getTaskId).collect(Collectors.toSet())));
                            if (this.unifiedTodoGLDProperties.isOpen()) {
                                taskInfos3.forEach(task -> {
                                    GlodonNodeDataDto nodeData = new GlodonNodeDataDto();
                                    nodeData.setFlowId(task.getProcessInstanceid());
                                    nodeData.setId(task.getTaskId());
                                    nodeData.setDeleted(Boolean.valueOf(true));
                                    nodeData.setPromoterId(task.getUserId());
                                    nodeData.setPromoterNo(task.getAssigneeUserNumber());
                                    nodeData.setPromoterName(task.getAssigneeUserName());
                                    nodeData.setDeptName(task.getDeptName());
                                    nodeData.setPostName(task.getPostName());
                                    this.pushGldNode(nodeData);
                                });
                            }
                        }
                        this.iUnifiedTodoTaskInfoService.remove((Wrapper)unifiedTodoTaskInfoQuery2);
                        continue block13;
                    }
                    case "2": {
                        List taskInfos4;
                        LambdaQueryWrapper unifiedPendingTaskInfoQuery = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)taskDeleteDto.getProcInstId()), UnifiedPendingTaskInfo::getProcessInstanceid, (Object)taskDeleteDto.getProcInstId())).in(HussarUtils.isNotEmpty((Object)taskDeleteDto.getTaskIds()), UnifiedPendingTaskInfo::getTaskId, (Collection)taskDeleteDto.getTaskIds())).eq(UnifiedPendingTaskInfo::getSystemId, (Object)taskDeleteDto.getSystemId());
                        if (taskDeleteDto.isCascade() && !(taskInfos4 = this.iUnifiedPendingTaskInfoService.list((Wrapper)unifiedPendingTaskInfoQuery)).isEmpty()) {
                            this.unifiedTaskUserService.remove((Wrapper)new LambdaQueryWrapper().in(UnifiedTaskUser::getTaskId, (Collection)taskInfos4.stream().map(UnifiedPendingTaskInfo::getTaskId).collect(Collectors.toSet())));
                        }
                        this.iUnifiedPendingTaskInfoService.remove((Wrapper)unifiedPendingTaskInfoQuery);
                        continue block13;
                    }
                    case "4": {
                        List taskInfos5;
                        LambdaQueryWrapper unifiedUnReadTaskInfoQuery = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)taskDeleteDto.getProcInstId()), UnifiedUnReadTaskInfo::getProcessInstanceid, (Object)taskDeleteDto.getProcInstId())).in(HussarUtils.isNotEmpty((Object)taskDeleteDto.getTaskIds()), UnifiedUnReadTaskInfo::getTaskId, (Collection)taskDeleteDto.getTaskIds())).eq(UnifiedUnReadTaskInfo::getSystemId, (Object)taskDeleteDto.getSystemId());
                        if (taskDeleteDto.isCascade() && !(taskInfos5 = this.iUnifiedUnReadTaskInfoService.list((Wrapper)unifiedUnReadTaskInfoQuery)).isEmpty()) {
                            this.unifiedTaskUserService.remove((Wrapper)new LambdaQueryWrapper().in(UnifiedTaskUser::getTaskId, (Collection)taskInfos5.stream().map(UnifiedUnReadTaskInfo::getTaskId).collect(Collectors.toSet())));
                        }
                        this.iUnifiedUnReadTaskInfoService.remove((Wrapper)unifiedUnReadTaskInfoQuery);
                        continue block13;
                    }
                    case "5": {
                        List taskInfos6;
                        LambdaQueryWrapper unifiedReadedTaskInfoQuery = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)taskDeleteDto.getProcInstId()), UnifiedReadedTaskInfo::getProcessInstanceid, (Object)taskDeleteDto.getProcInstId())).in(HussarUtils.isNotEmpty((Object)taskDeleteDto.getTaskIds()), UnifiedReadedTaskInfo::getTaskId, (Collection)taskDeleteDto.getTaskIds())).eq(UnifiedReadedTaskInfo::getSystemId, (Object)taskDeleteDto.getSystemId());
                        if (taskDeleteDto.isCascade() && !(taskInfos6 = this.iUnifiedReadedTaskInfoService.list((Wrapper)unifiedReadedTaskInfoQuery)).isEmpty()) {
                            this.unifiedTaskUserService.remove((Wrapper)new LambdaQueryWrapper().in(UnifiedTaskUser::getTaskId, (Collection)taskInfos6.stream().map(UnifiedReadedTaskInfo::getTaskId).collect(Collectors.toSet())));
                        }
                        this.iUnifiedReadedTaskInfoService.remove((Wrapper)unifiedReadedTaskInfoQuery);
                        continue block13;
                    }
                }
                LambdaQueryWrapper unifiedDoneTaskInfoQuery = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)taskDeleteDto.getProcInstId()), UnifiedDoneTaskInfo::getProcessInstanceid, (Object)taskDeleteDto.getProcInstId())).in(HussarUtils.isNotEmpty((Object)taskDeleteDto.getTaskIds()), UnifiedDoneTaskInfo::getTaskId, (Collection)taskDeleteDto.getTaskIds())).eq(UnifiedDoneTaskInfo::getSystemId, (Object)taskDeleteDto.getSystemId());
                if (taskDeleteDto.isCascade() && !(taskInfos2 = this.iUnifiedDoneTaskInfoService.list((Wrapper)unifiedDoneTaskInfoQuery)).isEmpty()) {
                    this.unifiedTaskUserService.remove((Wrapper)new LambdaQueryWrapper().in(UnifiedTaskUser::getTaskId, (Collection)taskInfos2.stream().map(UnifiedDoneTaskInfo::getTaskId).collect(Collectors.toSet())));
                    if (this.unifiedTodoGLDProperties.isOpen()) {
                        taskInfos2.forEach(task -> {
                            GlodonNodeDataDto nodeData = new GlodonNodeDataDto();
                            nodeData.setFlowId(task.getProcessInstanceid());
                            nodeData.setId(task.getTaskId());
                            nodeData.setDeleted(Boolean.valueOf(true));
                            nodeData.setPromoterId(task.getUserId());
                            nodeData.setPromoterNo(task.getAssigneeUserNumber());
                            nodeData.setPromoterName(task.getAssigneeUserName());
                            nodeData.setDeptName(task.getDeptName());
                            nodeData.setPostName(task.getPostName());
                            this.pushGldNode(nodeData);
                        });
                    }
                }
                this.iUnifiedDoneTaskInfoService.remove((Wrapper)unifiedDoneTaskInfoQuery);
            }
        }
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> taskUpdate(TaskUpdateDto taskUpdateDto) {
        ApiResponse isBuildSuccess = taskUpdateDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        String taskId = taskUpdateDto.getTaskId();
        if (taskUpdateDto.getUpdateCompleteTime() != null) {
            this.unifiedTaskUserService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)taskId)).eq(UnifiedTaskUser::getSystemId, (Object)taskUpdateDto.getSystemId())).set(UnifiedTaskUser::getCompleteTime, (Object)taskUpdateDto.getUpdateCompleteTime()));
        }
        if (!HussarUtils.isAllEmpty((Object[])new Object[]{taskUpdateDto.getUpdateTaskType(), taskUpdateDto.getUpdateDeadLine()})) {
            this.unifiedTaskInfoService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)taskId)).eq(UnifiedTaskInfo::getSystemId, (Object)taskUpdateDto.getSystemId())).set(HussarUtils.isNotEmpty((Object)taskUpdateDto.getUpdateTaskType()), UnifiedTaskInfo::getTaskStatus, (Object)taskUpdateDto.getUpdateTaskType())).set(HussarUtils.isNotEmpty((Object)taskUpdateDto.getUpdateDeadLine()), UnifiedTaskInfo::getDeadLine, (Object)taskUpdateDto.getUpdateDeadLine()));
        }
        if (this.unifiedTodoProperties.getOpen()) {
            List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)taskId)).eq(UnifiedTaskUser::getSystemId, (Object)taskUpdateDto.getSystemId()));
            UnifiedTaskInfo taskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)taskId));
            this.pushTaskToOa(taskInfo, taskUsers, null);
        }
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> taskUpdateClassify(TaskUpdateDto taskUpdateDto) {
        ApiResponse isBuildSuccess = taskUpdateDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        String taskId = taskUpdateDto.getTaskId();
        if (taskUpdateDto.getUpdateCompleteTime() != null) {
            this.unifiedTaskUserService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)taskId)).eq(UnifiedTaskUser::getSystemId, (Object)taskUpdateDto.getSystemId())).set(UnifiedTaskUser::getCompleteTime, (Object)taskUpdateDto.getUpdateCompleteTime()));
        }
        if (!HussarUtils.isAllEmpty((Object[])new Object[]{taskUpdateDto.getUpdateTaskType(), taskUpdateDto.getUpdateDeadLine()})) {
            switch (taskUpdateDto.getUpdateTaskType()) {
                case "5": {
                    List unReadList = this.iUnifiedUnReadTaskInfoService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedUnReadTaskInfo::getTaskId, (Object)taskId)).eq(UnifiedUnReadTaskInfo::getSystemId, (Object)taskUpdateDto.getSystemId()));
                    this.iUnifiedUnReadTaskInfoService.remove((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedUnReadTaskInfo::getTaskId, (Object)taskId)).eq(UnifiedUnReadTaskInfo::getSystemId, (Object)taskUpdateDto.getSystemId()));
                    ArrayList<UnifiedReadedTaskInfo> readedList = new ArrayList<UnifiedReadedTaskInfo>();
                    for (UnifiedUnReadTaskInfo unifiedUnReadTaskInfo : unReadList) {
                        UnifiedReadedTaskInfo unifiedReadedTaskInfo = new UnifiedReadedTaskInfo();
                        BeanUtils.copyProperties((Object)unifiedUnReadTaskInfo, (Object)unifiedReadedTaskInfo);
                        unifiedReadedTaskInfo.setTaskStatus("5");
                        unifiedReadedTaskInfo.setDeadLine(taskUpdateDto.getUpdateDeadLine());
                        unifiedReadedTaskInfo.setCompleteTime(taskUpdateDto.getUpdateCompleteTime());
                        readedList.add(unifiedReadedTaskInfo);
                    }
                    this.iUnifiedReadedTaskInfoService.saveBatch(readedList);
                    break;
                }
                case "3": {
                    List todoList = this.iUnifiedTodoTaskInfoService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTodoTaskInfo::getTaskId, (Object)taskId)).eq(UnifiedTodoTaskInfo::getSystemId, (Object)taskUpdateDto.getSystemId()));
                    this.iUnifiedTodoTaskInfoService.remove((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTodoTaskInfo::getTaskId, (Object)taskId)).eq(UnifiedTodoTaskInfo::getSystemId, (Object)taskUpdateDto.getSystemId()));
                    ArrayList<UnifiedDoneTaskInfo> doneList = new ArrayList<UnifiedDoneTaskInfo>();
                    for (UnifiedTodoTaskInfo unifiedTodoTaskInfo : todoList) {
                        UnifiedDoneTaskInfo unifiedDoneTaskInfo = new UnifiedDoneTaskInfo();
                        BeanUtils.copyProperties((Object)unifiedTodoTaskInfo, (Object)unifiedDoneTaskInfo);
                        unifiedDoneTaskInfo.setTaskStatus("5");
                        unifiedDoneTaskInfo.setCompleteTime(taskUpdateDto.getUpdateCompleteTime());
                        if (this.unifiedTodoGLDProperties.isOpen()) {
                            GlodonNodeDataDto nodeDataDto = new GlodonNodeDataDto();
                            nodeDataDto.setFlowId(unifiedDoneTaskInfo.getProcessInstanceid());
                            nodeDataDto.setId(unifiedDoneTaskInfo.getTaskId());
                            nodeDataDto.setDeleted(Boolean.valueOf(false));
                            nodeDataDto.setPromoterId(unifiedDoneTaskInfo.getUserId());
                            nodeDataDto.setPromoterNo(unifiedDoneTaskInfo.getAssigneeUserNumber());
                            nodeDataDto.setPromoterName(unifiedDoneTaskInfo.getAssigneeUserName());
                            nodeDataDto.setDeptName(unifiedDoneTaskInfo.getDeptName());
                            nodeDataDto.setPostName(unifiedDoneTaskInfo.getPostName());
                            nodeDataDto.setJumpUrl(this.unifiedTodoGLDProperties.getToDoList());
                            if (null != unifiedTodoTaskInfo.getCompleteTime()) {
                                nodeDataDto.setApproveTime(DateUtil.format((Date)unifiedDoneTaskInfo.getCompleteTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                            }
                            nodeDataDto.setApprovalStatus(Integer.valueOf(2));
                            this.pushGldNode(nodeDataDto);
                        }
                        doneList.add(unifiedDoneTaskInfo);
                    }
                    this.iUnifiedDoneTaskInfoService.saveBatch(doneList);
                    break;
                }
            }
        }
        if (this.unifiedTodoProperties.getOpen()) {
            List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)taskId)).eq(UnifiedTaskUser::getSystemId, (Object)taskUpdateDto.getSystemId()));
            UnifiedReadedTaskInfo readTaskInfo = (UnifiedReadedTaskInfo)this.iUnifiedReadedTaskInfoService.getOne((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedReadedTaskInfo::getTaskId, (Object)taskId)).eq(UnifiedReadedTaskInfo::getSystemId, (Object)taskUpdateDto.getSystemId()));
            if (!ObjectUtil.isNull((Object)readTaskInfo)) {
                this.pushTaskToOa(null, null, null, null, readTaskInfo, taskUsers, null);
            } else {
                UnifiedDoneTaskInfo doneTaskInfo = (UnifiedDoneTaskInfo)this.iUnifiedDoneTaskInfoService.getOne((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedDoneTaskInfo::getTaskId, (Object)taskId)).eq(UnifiedDoneTaskInfo::getSystemId, (Object)taskUpdateDto.getSystemId()));
                this.pushTaskToOa(null, null, doneTaskInfo, null, null, taskUsers, null);
            }
        }
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> userAddBatch(UserAddBatchDto userAddBatchDto) {
        List taskUsers;
        List taskIdList;
        List taskInfoList;
        ApiResponse isBuildSuccess = userAddBatchDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        this.unifiedTaskUserService.saveBatch((Collection)userAddBatchDto.getTaskUsers());
        if (this.unifiedTodoProperties.getOpen() && CollectionUtil.isNotEmpty((Collection)(taskInfoList = this.unifiedTaskInfoService.list((Wrapper)new LambdaQueryWrapper().in(UnifiedTaskInfo::getTaskId, taskIdList = (taskUsers = userAddBatchDto.getTaskUsers()).stream().map(UnifiedTaskUser::getTaskId).collect(Collectors.toList())))))) {
            for (UnifiedTaskInfo unifiedTaskInfo : taskInfoList) {
                List<UnifiedTaskUser> partList = taskUsers.stream().filter(t -> t.getTaskId().equals(unifiedTaskInfo.getTaskId())).collect(Collectors.toList());
                unifiedTaskInfo.setTaskStatus("1");
                this.pushTaskToOa(unifiedTaskInfo, partList, null);
            }
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> userAddBatchClassify(UserAddBatchDto userAddBatchDto) {
        ApiResponse isBuildSuccess = userAddBatchDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        this.unifiedTaskUserService.saveBatch((Collection)userAddBatchDto.getTaskUsers());
        this.addTaskUser(userAddBatchDto);
        if (this.unifiedTodoProperties.getOpen()) {
            List readTaskInfoList;
            List unReadTaskInfoList;
            List doneTaskInfoList;
            List pendingTaskInfoList;
            List taskUsers = userAddBatchDto.getTaskUsers();
            List taskIdList = taskUsers.stream().map(UnifiedTaskUser::getTaskId).collect(Collectors.toList());
            List todoTaskInfoList = this.iUnifiedTodoTaskInfoService.list((Wrapper)new LambdaQueryWrapper().in(UnifiedTodoTaskInfo::getTaskId, taskIdList));
            if (CollectionUtil.isNotEmpty((Collection)todoTaskInfoList)) {
                for (Object todoTaskInfo : todoTaskInfoList) {
                    List<UnifiedTaskUser> partList = taskUsers.stream().filter(arg_0 -> UnifiedTaskServiceImpl.lambda$userAddBatchClassify$31((UnifiedTodoTaskInfo)todoTaskInfo, arg_0)).collect(Collectors.toList());
                    todoTaskInfo.setTaskStatus("1");
                    logger.info("userAddBatchClassify \u9700\u5ba1\uff1a" + JSON.toJSONString((Object)todoTaskInfo));
                    this.pushTaskToOa((UnifiedTodoTaskInfo)todoTaskInfo, null, null, null, null, partList, null);
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)(pendingTaskInfoList = this.iUnifiedPendingTaskInfoService.list((Wrapper)new LambdaQueryWrapper().in(UnifiedPendingTaskInfo::getTaskId, taskIdList))))) {
                for (Object pendingTaskInfo : pendingTaskInfoList) {
                    List<UnifiedTaskUser> partList = taskUsers.stream().filter(arg_0 -> UnifiedTaskServiceImpl.lambda$userAddBatchClassify$32((UnifiedPendingTaskInfo)pendingTaskInfo, arg_0)).collect(Collectors.toList());
                    pendingTaskInfo.setTaskStatus("1");
                    logger.info("userAddBatchClassify \u5f85\u5ba1\uff1a" + JSON.toJSONString((Object)pendingTaskInfo));
                    this.pushTaskToOa(null, (UnifiedPendingTaskInfo)pendingTaskInfo, null, null, null, partList, null);
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)(doneTaskInfoList = this.iUnifiedDoneTaskInfoService.list((Wrapper)new LambdaQueryWrapper().in(UnifiedDoneTaskInfo::getTaskId, taskIdList))))) {
                for (Object doneTaskInfo : doneTaskInfoList) {
                    List<UnifiedTaskUser> partList = taskUsers.stream().filter(arg_0 -> UnifiedTaskServiceImpl.lambda$userAddBatchClassify$33((UnifiedDoneTaskInfo)doneTaskInfo, arg_0)).collect(Collectors.toList());
                    doneTaskInfo.setTaskStatus("1");
                    logger.info("userAddBatchClassify \u5df2\u5ba1\uff1a" + JSON.toJSONString((Object)doneTaskInfo));
                    this.pushTaskToOa(null, null, (UnifiedDoneTaskInfo)doneTaskInfo, null, null, partList, null);
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)(unReadTaskInfoList = this.iUnifiedUnReadTaskInfoService.list((Wrapper)new LambdaQueryWrapper().in(UnifiedUnReadTaskInfo::getTaskId, taskIdList))))) {
                for (UnifiedUnReadTaskInfo unReadTaskInfo : unReadTaskInfoList) {
                    List<UnifiedTaskUser> partList = taskUsers.stream().filter(t -> t.getTaskId().equals(unReadTaskInfo.getTaskId())).collect(Collectors.toList());
                    unReadTaskInfo.setTaskStatus("1");
                    logger.info("userAddBatchClassify \u672a\u8bfb\uff1a" + JSON.toJSONString((Object)unReadTaskInfo));
                    this.pushTaskToOa(null, null, null, unReadTaskInfo, null, partList, null);
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)(readTaskInfoList = this.iUnifiedReadedTaskInfoService.list((Wrapper)new LambdaQueryWrapper().in(UnifiedReadedTaskInfo::getTaskId, taskIdList))))) {
                for (UnifiedReadedTaskInfo readTaskInfo : readTaskInfoList) {
                    List<UnifiedTaskUser> partList = taskUsers.stream().filter(t -> t.getTaskId().equals(readTaskInfo.getTaskId())).collect(Collectors.toList());
                    readTaskInfo.setTaskStatus("1");
                    logger.info("userAddBatchClassify \u5df2\u8bfb\uff1a" + JSON.toJSONString((Object)readTaskInfo));
                    this.pushTaskToOa(null, null, null, null, readTaskInfo, partList, null);
                }
            }
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> userAdd(UnifiedTaskUser unifiedTaskUser) {
        ApiResponse isBuildSuccess = unifiedTaskUser.buildAllInfoForUserAdd();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        this.unifiedTaskUserService.save((Object)unifiedTaskUser);
        return ApiResponse.success();
    }

    public ApiResponse<String> userAddClassify(UnifiedTaskUser unifiedTaskUser) {
        ApiResponse isBuildSuccess = unifiedTaskUser.buildAllInfoForUserAdd();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        this.unifiedTaskUserService.save((Object)unifiedTaskUser);
        ArrayList<UnifiedTaskUser> list = new ArrayList<UnifiedTaskUser>();
        list.add(unifiedTaskUser);
        UserAddBatchDto userAddBatchDto = new UserAddBatchDto();
        userAddBatchDto.setTaskId(unifiedTaskUser.getTaskId());
        userAddBatchDto.setSystemId(userAddBatchDto.getSystemId());
        userAddBatchDto.setTaskUsers(list);
        this.addTaskUser(userAddBatchDto);
        return ApiResponse.success();
    }

    public ApiResponse<String> userDelete(UserDeleteDto userDeleteDto) {
        ApiResponse isBuildSuccess = userDeleteDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        if (this.unifiedTodoProperties.getOpen()) {
            logger.info("\u6d41\u7a0b\u5e73\u53f0\u5207\u6362\u8282\u70b9\u5ba1\u6279\u4eba\u6570\u636e\u63a8\u9001\u5f00\u59cb");
            if (CollectionUtil.isNotEmpty((Collection)userDeleteDto.getTaskIds())) {
                List unifiedTaskInfoList = this.unifiedTaskInfoService.list((Wrapper)new LambdaQueryWrapper().in(UnifiedTaskInfo::getTaskId, (Collection)userDeleteDto.getTaskIds()));
                logger.info("taskInfoSize:" + unifiedTaskInfoList.size());
                if (CollectionUtil.isNotEmpty((Collection)unifiedTaskInfoList)) {
                    UnifiedTaskInfo unifiedTaskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)userDeleteDto.getTaskId()));
                    if (!Objects.isNull(unifiedTaskInfo)) {
                        unifiedTaskInfoList.add(unifiedTaskInfo);
                    }
                    for (UnifiedTaskInfo taskInfo : unifiedTaskInfoList) {
                        List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)taskInfo.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)taskInfo.getSystemId()));
                        taskInfo.setTaskStatus("3");
                        this.pushTaskToOa(taskInfo, taskUsers, null);
                    }
                } else {
                    UnifiedTaskInfo unifiedTaskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)userDeleteDto.getTaskId()));
                    if (!Objects.isNull(unifiedTaskInfo)) {
                        List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskInfo.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskInfo.getSystemId()));
                        unifiedTaskInfo.setTaskStatus("3");
                        this.pushTaskToOa(unifiedTaskInfo, taskUsers, null);
                    }
                }
            } else {
                UnifiedTaskInfo unifiedTaskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)userDeleteDto.getTaskId()));
                if (!Objects.isNull(unifiedTaskInfo)) {
                    List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskInfo.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskInfo.getSystemId()));
                    unifiedTaskInfo.setTaskStatus("3");
                    this.pushTaskToOa(unifiedTaskInfo, taskUsers, null);
                }
            }
        }
        this.unifiedTaskUserService.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)userDeleteDto.getTaskId()), UnifiedTaskUser::getTaskId, (Object)userDeleteDto.getTaskId())).in(HussarUtils.isNotEmpty((Object)userDeleteDto.getTaskIds()), UnifiedTaskUser::getTaskId, (Collection)userDeleteDto.getTaskIds())).in(HussarUtils.isNotEmpty((Object)userDeleteDto.getDeleteUserIds()), UnifiedTaskUser::getUserId, (Collection)userDeleteDto.getDeleteUserIds())).notIn(HussarUtils.isNotEmpty((Object)userDeleteDto.getReserveUserIds()), UnifiedTaskUser::getUserId, (Collection)userDeleteDto.getReserveUserIds())).eq(HussarUtils.isNotEmpty((Object)userDeleteDto.getTaskTypes()), UnifiedTaskUser::getTaskStatus, (Object)userDeleteDto.getTaskTypes()));
        return ApiResponse.success();
    }

    public ApiResponse<String> userDeleteClassify(UserDeleteDto userDeleteDto) {
        ApiResponse isBuildSuccess = userDeleteDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        if (this.unifiedTodoProperties.getOpen()) {
            logger.info("\u6d41\u7a0b\u5e73\u53f0\u5207\u6362\u8282\u70b9\u5ba1\u6279\u4eba\u6570\u636e\u63a8\u9001\u5f00\u59cb");
            if (CollectionUtil.isNotEmpty((Collection)userDeleteDto.getTaskIds())) {
                UnifiedTodoTaskInfo unifiedTaskInfo;
                List unifiedTaskInfoList = this.iUnifiedTodoTaskInfoService.list((Wrapper)new LambdaQueryWrapper().in(UnifiedTodoTaskInfo::getTaskId, (Collection)userDeleteDto.getTaskIds()));
                logger.info("taskInfoSize:" + unifiedTaskInfoList.size());
                if (CollectionUtil.isNotEmpty((Collection)unifiedTaskInfoList)) {
                    unifiedTaskInfo = (UnifiedTodoTaskInfo)this.iUnifiedTodoTaskInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedTodoTaskInfo::getTaskId, (Object)userDeleteDto.getTaskId()));
                    if (!Objects.isNull(unifiedTaskInfo)) {
                        unifiedTaskInfoList.add(unifiedTaskInfo);
                    }
                    for (UnifiedTodoTaskInfo taskInfo : unifiedTaskInfoList) {
                        List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)taskInfo.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)taskInfo.getSystemId()));
                        taskInfo.setTaskStatus("3");
                        this.pushTaskToOa(taskInfo, null, null, null, null, taskUsers, null);
                    }
                } else {
                    unifiedTaskInfo = (UnifiedTodoTaskInfo)this.iUnifiedTodoTaskInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedTodoTaskInfo::getTaskId, (Object)userDeleteDto.getTaskId()));
                    if (!Objects.isNull(unifiedTaskInfo)) {
                        List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskInfo.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskInfo.getSystemId()));
                        unifiedTaskInfo.setTaskStatus("3");
                        this.pushTaskToOa(unifiedTaskInfo, null, null, null, null, taskUsers, null);
                    }
                }
            } else {
                UnifiedTodoTaskInfo unifiedTaskInfo = (UnifiedTodoTaskInfo)this.iUnifiedTodoTaskInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedTodoTaskInfo::getTaskId, (Object)userDeleteDto.getTaskId()));
                if (!Objects.isNull(unifiedTaskInfo)) {
                    List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskInfo.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskInfo.getSystemId()));
                    unifiedTaskInfo.setTaskStatus("3");
                    this.pushTaskToOa(unifiedTaskInfo, null, null, null, null, taskUsers, null);
                    List unifiedTodoTaskInfoList = this.iUnifiedTodoTaskInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ne(UnifiedTodoTaskInfo::getTaskId, (Object)userDeleteDto.getTaskId())).eq(UnifiedTodoTaskInfo::getProcessInstanceid, (Object)unifiedTaskInfo.getProcessInstanceid()));
                    if (HussarUtils.isNotEmpty((Object)unifiedTodoTaskInfoList)) {
                        logger.info("\u83b7\u53d6\u5269\u4f59\u9700\u5ba1\u6570\u636e\uff0c\u63a8\u9001\u5230oa\uff0c\u9632\u6b62\u591a\u4e2a\u8282\u70b9\u662f\u540c\u4e00\u4e2a\u4eba\u5ba1\u6279\uff0c\u4e00\u4e2a\u8282\u70b9\u5207\u6362\u5ba1\u6279\u4eba\u540e\uff0coa\u7cfb\u7edf\u91cc\u6ca1\u6709\u5f85\u529e\u6570\u636e");
                        for (UnifiedTodoTaskInfo todoTaskInfo : unifiedTodoTaskInfoList) {
                            logger.info("todoTaskInfo\uff1a" + JSON.toJSONString((Object)todoTaskInfo));
                            List todoTaskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)todoTaskInfo.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)todoTaskInfo.getSystemId()));
                            this.pushTaskToOa(todoTaskInfo, null, null, null, null, todoTaskUsers, null);
                        }
                    }
                }
            }
        }
        this.unifiedTaskUserService.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)userDeleteDto.getTaskId()), UnifiedTaskUser::getTaskId, (Object)userDeleteDto.getTaskId())).in(HussarUtils.isNotEmpty((Object)userDeleteDto.getTaskIds()), UnifiedTaskUser::getTaskId, (Collection)userDeleteDto.getTaskIds())).in(HussarUtils.isNotEmpty((Object)userDeleteDto.getDeleteUserIds()), UnifiedTaskUser::getUserId, (Collection)userDeleteDto.getDeleteUserIds())).notIn(HussarUtils.isNotEmpty((Object)userDeleteDto.getReserveUserIds()), UnifiedTaskUser::getUserId, (Collection)userDeleteDto.getReserveUserIds())).eq(HussarUtils.isNotEmpty((Object)userDeleteDto.getTaskTypes()), UnifiedTaskUser::getTaskStatus, (Object)userDeleteDto.getTaskTypes()));
        if (HussarUtils.isNotEmpty((Object)userDeleteDto.getTaskTypes())) {
            for (String type : userDeleteDto.getTaskTypes()) {
                switch (type) {
                    case "1": {
                        this.iUnifiedTodoTaskInfoService.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)userDeleteDto.getTaskId()), UnifiedTodoTaskInfo::getTaskId, (Object)userDeleteDto.getTaskId())).in(HussarUtils.isNotEmpty((Object)userDeleteDto.getTaskIds()), UnifiedTodoTaskInfo::getTaskId, (Collection)userDeleteDto.getTaskIds())).in(HussarUtils.isNotEmpty((Object)userDeleteDto.getDeleteUserIds()), UnifiedTodoTaskInfo::getUserId, (Collection)userDeleteDto.getDeleteUserIds())).notIn(HussarUtils.isNotEmpty((Object)userDeleteDto.getReserveUserIds()), UnifiedTodoTaskInfo::getUserId, (Collection)userDeleteDto.getReserveUserIds()));
                        break;
                    }
                    case "2": {
                        this.iUnifiedPendingTaskInfoService.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)userDeleteDto.getTaskId()), UnifiedPendingTaskInfo::getTaskId, (Object)userDeleteDto.getTaskId())).in(HussarUtils.isNotEmpty((Object)userDeleteDto.getTaskIds()), UnifiedPendingTaskInfo::getTaskId, (Collection)userDeleteDto.getTaskIds())).in(HussarUtils.isNotEmpty((Object)userDeleteDto.getDeleteUserIds()), UnifiedPendingTaskInfo::getUserId, (Collection)userDeleteDto.getDeleteUserIds())).notIn(HussarUtils.isNotEmpty((Object)userDeleteDto.getReserveUserIds()), UnifiedPendingTaskInfo::getUserId, (Collection)userDeleteDto.getReserveUserIds()));
                        break;
                    }
                    case "4": {
                        this.iUnifiedUnReadTaskInfoService.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)userDeleteDto.getTaskId()), UnifiedUnReadTaskInfo::getTaskId, (Object)userDeleteDto.getTaskId())).in(HussarUtils.isNotEmpty((Object)userDeleteDto.getTaskIds()), UnifiedUnReadTaskInfo::getTaskId, (Collection)userDeleteDto.getTaskIds())).in(HussarUtils.isNotEmpty((Object)userDeleteDto.getDeleteUserIds()), UnifiedUnReadTaskInfo::getUserId, (Collection)userDeleteDto.getDeleteUserIds())).notIn(HussarUtils.isNotEmpty((Object)userDeleteDto.getReserveUserIds()), UnifiedUnReadTaskInfo::getUserId, (Collection)userDeleteDto.getReserveUserIds()));
                        break;
                    }
                    case "5": {
                        this.iUnifiedReadedTaskInfoService.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)userDeleteDto.getTaskId()), UnifiedReadedTaskInfo::getTaskId, (Object)userDeleteDto.getTaskId())).in(HussarUtils.isNotEmpty((Object)userDeleteDto.getTaskIds()), UnifiedReadedTaskInfo::getTaskId, (Collection)userDeleteDto.getTaskIds())).in(HussarUtils.isNotEmpty((Object)userDeleteDto.getDeleteUserIds()), UnifiedReadedTaskInfo::getUserId, (Collection)userDeleteDto.getDeleteUserIds())).notIn(HussarUtils.isNotEmpty((Object)userDeleteDto.getReserveUserIds()), UnifiedReadedTaskInfo::getUserId, (Collection)userDeleteDto.getReserveUserIds()));
                        break;
                    }
                    case "3": {
                        this.iUnifiedDoneTaskInfoService.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)userDeleteDto.getTaskId()), UnifiedDoneTaskInfo::getTaskId, (Object)userDeleteDto.getTaskId())).in(HussarUtils.isNotEmpty((Object)userDeleteDto.getTaskIds()), UnifiedDoneTaskInfo::getTaskId, (Collection)userDeleteDto.getTaskIds())).in(HussarUtils.isNotEmpty((Object)userDeleteDto.getDeleteUserIds()), UnifiedDoneTaskInfo::getUserId, (Collection)userDeleteDto.getDeleteUserIds())).notIn(HussarUtils.isNotEmpty((Object)userDeleteDto.getReserveUserIds()), UnifiedDoneTaskInfo::getUserId, (Collection)userDeleteDto.getReserveUserIds()));
                        break;
                    }
                }
            }
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> userUpdate(UserUpdateDto userUpdateDto) {
        ApiResponse isBuildSuccess = userUpdateDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        this.unifiedTaskUserService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getSystemId, (Object)userUpdateDto.getSystemId())).eq(UnifiedTaskUser::getTaskId, (Object)userUpdateDto.getTaskId())).eq(HussarUtils.isNotEmpty((Object)userUpdateDto.getTaskType()), UnifiedTaskUser::getTaskStatus, (Object)userUpdateDto.getTaskType())).eq(HussarUtils.isNotEmpty((Object)userUpdateDto.getUserId()), UnifiedTaskUser::getUserId, (Object)userUpdateDto.getUserId())).set(HussarUtils.isNotEmpty((Object)userUpdateDto.getUpdateUser()), UnifiedTaskUser::getUserId, (Object)userUpdateDto.getUpdateUser())).set(HussarUtils.isNotEmpty((Object)userUpdateDto.getUpdateTaskType()), UnifiedTaskUser::getTaskStatus, (Object)userUpdateDto.getUpdateTaskType())).set(HussarUtils.isNotEmpty((Object)userUpdateDto.getUpdateCompleteTime()), UnifiedTaskUser::getCompleteTime, (Object)userUpdateDto.getUpdateCompleteTime()));
        return ApiResponse.success();
    }

    public ApiResponse<String> userUpdateClassify(UserUpdateDto userUpdateDto) {
        ApiResponse isBuildSuccess = userUpdateDto.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        if (HussarUtils.isNotEmpty((Object)userUpdateDto.getUpdateTaskType())) {
            if (HussarUtils.isNotEmpty((Object)userUpdateDto.getUpdateTaskType())) {
                switch (userUpdateDto.getUpdateTaskType()) {
                    case "5": {
                        List unReadList = this.iUnifiedUnReadTaskInfoService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedUnReadTaskInfo::getTaskId, (Object)userUpdateDto.getUserId())).eq(UnifiedUnReadTaskInfo::getSystemId, (Object)userUpdateDto.getSystemId()));
                        this.iUnifiedUnReadTaskInfoService.remove((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedUnReadTaskInfo::getTaskId, (Object)userUpdateDto.getUserId())).eq(UnifiedUnReadTaskInfo::getSystemId, (Object)userUpdateDto.getSystemId()));
                        ArrayList<UnifiedReadedTaskInfo> readedList = new ArrayList<UnifiedReadedTaskInfo>();
                        for (UnifiedUnReadTaskInfo unifiedUnReadTaskInfo : unReadList) {
                            UnifiedReadedTaskInfo unifiedReadedTaskInfo = new UnifiedReadedTaskInfo();
                            BeanUtils.copyProperties((Object)unifiedUnReadTaskInfo, (Object)unifiedReadedTaskInfo);
                            unifiedReadedTaskInfo.setTaskStatus("5");
                            unifiedReadedTaskInfo.setCompleteTime(userUpdateDto.getUpdateCompleteTime());
                            readedList.add(unifiedReadedTaskInfo);
                        }
                        this.iUnifiedReadedTaskInfoService.saveBatch(readedList);
                        break;
                    }
                    case "3": {
                        List todoList = this.iUnifiedTodoTaskInfoService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTodoTaskInfo::getTaskId, (Object)userUpdateDto.getUserId())).eq(UnifiedTodoTaskInfo::getSystemId, (Object)userUpdateDto.getSystemId()));
                        this.iUnifiedTodoTaskInfoService.remove((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTodoTaskInfo::getTaskId, (Object)userUpdateDto.getUserId())).eq(UnifiedTodoTaskInfo::getSystemId, (Object)userUpdateDto.getSystemId()));
                        ArrayList<UnifiedDoneTaskInfo> doneList = new ArrayList<UnifiedDoneTaskInfo>();
                        for (UnifiedTodoTaskInfo unifiedTodoTaskInfo : todoList) {
                            UnifiedDoneTaskInfo unifiedDoneTaskInfo = new UnifiedDoneTaskInfo();
                            BeanUtils.copyProperties((Object)unifiedTodoTaskInfo, (Object)unifiedDoneTaskInfo);
                            unifiedDoneTaskInfo.setTaskStatus("5");
                            unifiedDoneTaskInfo.setCompleteTime(userUpdateDto.getUpdateCompleteTime());
                            if (this.unifiedTodoGLDProperties.isOpen()) {
                                GlodonNodeDataDto nodeDataDto = new GlodonNodeDataDto();
                                nodeDataDto.setFlowId(unifiedDoneTaskInfo.getProcessInstanceid());
                                nodeDataDto.setId(unifiedDoneTaskInfo.getTaskId());
                                nodeDataDto.setDeleted(Boolean.valueOf(false));
                                nodeDataDto.setPromoterId(unifiedDoneTaskInfo.getUserId());
                                nodeDataDto.setPromoterNo(unifiedDoneTaskInfo.getAssigneeUserNumber());
                                nodeDataDto.setPromoterName(unifiedDoneTaskInfo.getAssigneeUserName());
                                nodeDataDto.setDeptName(unifiedDoneTaskInfo.getDeptName());
                                nodeDataDto.setPostName(unifiedDoneTaskInfo.getPostName());
                                nodeDataDto.setJumpUrl(this.unifiedTodoGLDProperties.getToDoList());
                                if (null != unifiedDoneTaskInfo.getCompleteTime()) {
                                    nodeDataDto.setApproveTime(DateUtil.format((Date)unifiedDoneTaskInfo.getCompleteTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                                }
                                nodeDataDto.setApprovalStatus(Integer.valueOf(2));
                                this.pushGldNode(nodeDataDto);
                            }
                            doneList.add(unifiedDoneTaskInfo);
                        }
                        this.iUnifiedDoneTaskInfoService.saveBatch(doneList);
                        break;
                    }
                }
            } else {
                switch (userUpdateDto.getTaskType()) {
                    case "1": {
                        this.iUnifiedTodoTaskInfoService.remove((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTodoTaskInfo::getSystemId, (Object)userUpdateDto.getSystemId())).eq(UnifiedTodoTaskInfo::getTaskId, (Object)userUpdateDto.getTaskId())).eq(HussarUtils.isNotEmpty((Object)userUpdateDto.getUserId()), UnifiedTodoTaskInfo::getUserId, (Object)userUpdateDto.getUserId())).set(HussarUtils.isNotEmpty((Object)userUpdateDto.getUpdateUser()), UnifiedTodoTaskInfo::getUserId, (Object)userUpdateDto.getUpdateUser())).set(HussarUtils.isNotEmpty((Object)userUpdateDto.getUpdateCompleteTime()), UnifiedTodoTaskInfo::getCompleteTime, (Object)userUpdateDto.getUpdateCompleteTime()));
                        break;
                    }
                    case "2": {
                        this.iUnifiedPendingTaskInfoService.remove((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedPendingTaskInfo::getSystemId, (Object)userUpdateDto.getSystemId())).eq(UnifiedPendingTaskInfo::getTaskId, (Object)userUpdateDto.getTaskId())).eq(HussarUtils.isNotEmpty((Object)userUpdateDto.getUserId()), UnifiedPendingTaskInfo::getUserId, (Object)userUpdateDto.getUserId())).set(HussarUtils.isNotEmpty((Object)userUpdateDto.getUpdateUser()), UnifiedPendingTaskInfo::getUserId, (Object)userUpdateDto.getUpdateUser())).set(HussarUtils.isNotEmpty((Object)userUpdateDto.getUpdateCompleteTime()), UnifiedPendingTaskInfo::getCompleteTime, (Object)userUpdateDto.getUpdateCompleteTime()));
                        break;
                    }
                    case "4": {
                        this.iUnifiedUnReadTaskInfoService.remove((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedUnReadTaskInfo::getSystemId, (Object)userUpdateDto.getSystemId())).eq(UnifiedUnReadTaskInfo::getTaskId, (Object)userUpdateDto.getTaskId())).eq(HussarUtils.isNotEmpty((Object)userUpdateDto.getUserId()), UnifiedUnReadTaskInfo::getUserId, (Object)userUpdateDto.getUserId())).set(HussarUtils.isNotEmpty((Object)userUpdateDto.getUpdateUser()), UnifiedUnReadTaskInfo::getUserId, (Object)userUpdateDto.getUpdateUser())).set(HussarUtils.isNotEmpty((Object)userUpdateDto.getUpdateCompleteTime()), UnifiedUnReadTaskInfo::getCompleteTime, (Object)userUpdateDto.getUpdateCompleteTime()));
                        break;
                    }
                    case "5": {
                        this.iUnifiedReadedTaskInfoService.remove((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedReadedTaskInfo::getSystemId, (Object)userUpdateDto.getSystemId())).eq(UnifiedReadedTaskInfo::getTaskId, (Object)userUpdateDto.getTaskId())).eq(HussarUtils.isNotEmpty((Object)userUpdateDto.getUserId()), UnifiedReadedTaskInfo::getUserId, (Object)userUpdateDto.getUserId())).set(HussarUtils.isNotEmpty((Object)userUpdateDto.getUpdateUser()), UnifiedReadedTaskInfo::getUserId, (Object)userUpdateDto.getUpdateUser())).set(HussarUtils.isNotEmpty((Object)userUpdateDto.getUpdateCompleteTime()), UnifiedReadedTaskInfo::getCompleteTime, (Object)userUpdateDto.getUpdateCompleteTime()));
                        break;
                    }
                    case "3": {
                        this.iUnifiedDoneTaskInfoService.remove((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedDoneTaskInfo::getSystemId, (Object)userUpdateDto.getSystemId())).eq(UnifiedDoneTaskInfo::getTaskId, (Object)userUpdateDto.getTaskId())).eq(HussarUtils.isNotEmpty((Object)userUpdateDto.getUserId()), UnifiedDoneTaskInfo::getUserId, (Object)userUpdateDto.getUserId())).set(HussarUtils.isNotEmpty((Object)userUpdateDto.getUpdateUser()), UnifiedDoneTaskInfo::getUserId, (Object)userUpdateDto.getUpdateUser())).set(HussarUtils.isNotEmpty((Object)userUpdateDto.getUpdateCompleteTime()), UnifiedDoneTaskInfo::getCompleteTime, (Object)userUpdateDto.getUpdateCompleteTime()));
                        break;
                    }
                }
            }
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> processAdd(UnifiedProcessInfo processInfo) {
        List list;
        ApiResponse isBuildSuccess = processInfo.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        this.unifiedProcessInfoService.save((Object)processInfo);
        if (this.unifiedTodoProperties.getOpen() && HussarUtils.isNotEmpty((Object)(list = this.unifiedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getProcessInstanceid, (Object)processInfo.getProcInstId())).eq(UnifiedTaskInfo::getTaskStatus, (Object)"1"))))) {
            for (UnifiedTaskInfo unifiedTaskInfo : list) {
                List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskInfo.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskInfo.getSystemId()));
                this.pushTaskToOa(unifiedTaskInfo, taskUsers, processInfo);
            }
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> processAddClassify(UnifiedProcessInfo processInfo) {
        List list;
        ApiResponse isBuildSuccess = processInfo.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        this.unifiedProcessInfoService.save((Object)processInfo);
        this.updateTaskProcessDetail(processInfo);
        if (this.unifiedTodoProperties.getOpen() && HussarUtils.isNotEmpty((Object)(list = this.iUnifiedTodoTaskInfoService.list((Wrapper)new LambdaQueryWrapper().eq(UnifiedTodoTaskInfo::getProcessInstanceid, (Object)processInfo.getProcInstId()))))) {
            for (UnifiedTodoTaskInfo unifiedTaskInfo : list) {
                logger.info("processAddClassify \u9700\u5ba1\uff1a" + JSON.toJSONString((Object)unifiedTaskInfo));
                List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskInfo.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskInfo.getSystemId()));
                this.pushTaskToOa(unifiedTaskInfo, null, null, null, null, taskUsers, processInfo);
            }
        }
        if (this.unifiedTodoGLDProperties.isOpen()) {
            GlodonMainDataDto requestBody = new GlodonMainDataDto();
            requestBody.setProjectId(processInfo.getDeptId());
            requestBody.setProjectName(processInfo.getDeptName());
            requestBody.setId(String.valueOf(processInfo.getProcInstId()));
            requestBody.setFlowName(processInfo.getProcessName());
            requestBody.setPromoterId(processInfo.getStartUserId());
            requestBody.setPromoterNo(processInfo.getStartUserNumber());
            requestBody.setPromoterName(processInfo.getStartUserName());
            requestBody.setDeleted(Boolean.valueOf(false));
            if (null != processInfo.getStartTime()) {
                requestBody.setPromotionTime(DateUtil.format((Date)processInfo.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            requestBody.setApprovalStatus(Integer.valueOf(processInfo.getProcessState()));
            this.pushGldMain(requestBody);
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> processUpdate(UnifiedProcessInfo processInfo) {
        ApiResponse isBuildSuccess = processInfo.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        this.unifiedProcessInfoService.update((Object)processInfo, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedProcessInfo::getSystemId, (Object)processInfo.getSystemId())).eq(UnifiedProcessInfo::getProcInstId, (Object)processInfo.getProcInstId()));
        return ApiResponse.success();
    }

    public ApiResponse<String> processUpdateClassify(UnifiedProcessInfo processInfo) {
        ApiResponse isBuildSuccess = processInfo.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        UnifiedProcessInfo record = (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)processInfo.getProcInstId()));
        this.unifiedProcessInfoService.update((Object)processInfo, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedProcessInfo::getSystemId, (Object)processInfo.getSystemId())).eq(UnifiedProcessInfo::getProcInstId, (Object)processInfo.getProcInstId()));
        if (HussarUtils.isNotEmpty((Object)processInfo.getProcessState())) {
            if (this.unifiedTodoGLDProperties.isOpen() && null != record && this.isPushGld(processInfo, record)) {
                GlodonMainDataDto requestBody = new GlodonMainDataDto();
                requestBody.setId(String.valueOf(processInfo.getProcInfoId()));
                requestBody.setApprovalStatus(Integer.valueOf(processInfo.getProcessState()));
                requestBody.setPromoterId(processInfo.getStartUserId());
                requestBody.setPromoterNo(processInfo.getStartUserNumber());
                requestBody.setPromoterName(processInfo.getStartUserName());
                requestBody.setDeleted(Boolean.valueOf(false));
                this.pushGldMain(requestBody);
            }
            switch (processInfo.getProcessState()) {
                case "3": {
                    List processInfos = this.unifiedProcessInfoService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedProcessInfo::getSystemId, (Object)processInfo.getSystemId())).eq(UnifiedProcessInfo::getProcInstId, (Object)processInfo.getProcInstId()));
                    ArrayList<UnifiedProcessRectificationInfo> processRectificationInfos = new ArrayList<UnifiedProcessRectificationInfo>();
                    for (UnifiedProcessInfo unifiedProcessInfo : processInfos) {
                        UnifiedProcessRectificationInfo unifiedProcessRectificationInfo = new UnifiedProcessRectificationInfo();
                        BeanUtils.copyProperties((Object)unifiedProcessInfo, (Object)unifiedProcessRectificationInfo);
                        unifiedProcessRectificationInfo.setProcessState("3");
                        processRectificationInfos.add(unifiedProcessRectificationInfo);
                    }
                    this.iUnifiedProcessRectificationService.saveBatch(processRectificationInfos);
                    break;
                }
                case "9": {
                    UnifiedProcessRectificationInfo unifiedProcessRectificationInfo = new UnifiedProcessRectificationInfo();
                    BeanUtils.copyProperties((Object)processInfo, (Object)unifiedProcessRectificationInfo);
                    this.iUnifiedProcessRectificationService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedProcessRectificationInfo::getSystemId, (Object)processInfo.getSystemId())).eq(UnifiedProcessRectificationInfo::getProcInstId, (Object)processInfo.getProcInstId())).set(UnifiedProcessRectificationInfo::getProcessState, (Object)processInfo.getProcessState()));
                    break;
                }
            }
        }
        this.updateTaskProcessDetail(processInfo);
        return ApiResponse.success();
    }

    private void pushGldMain(GlodonMainDataDto requestBody) {
        ArrayList list = Lists.newArrayList();
        list.add(requestBody);
        try {
            String data = JSONObject.toJSONString((Object)list);
            logger.info("\u63a8\u9001\u6d41\u7a0b\u6570\u636e:{}", (Object)data);
            String response = HttpClientUtil.httpPost(this.unifiedTodoGLDProperties.getApproveRecord(), data, this.getHeaders());
            GlodonResponse glodonResponse = (GlodonResponse)JSONObject.parseObject((String)response, GlodonResponse.class);
            if (0 != glodonResponse.getReturnCode()) {
                logger.info("\u63a8\u9001\u6d41\u7a0b\u6570\u636e\u5931\u8d25:{}", (Object)glodonResponse.getThrowable());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u63a8\u9001\u6d41\u7a0b\u6570\u636e\u51fa\u9519:{}", (Object)e.getMessage());
        }
    }

    private void pushGldNode(GlodonNodeDataDto requestBody) {
        ArrayList list = Lists.newArrayList();
        list.add(requestBody);
        try {
            String data = JSONObject.toJSONString((Object)list);
            logger.info("\u63a8\u9001\u8282\u70b9\u6570\u636e:{}", (Object)data);
            String response = HttpClientUtil.httpPost(this.unifiedTodoGLDProperties.getApproveNode(), data, this.getHeaders());
            GlodonResponse glodonResponse = (GlodonResponse)JSONObject.parseObject((String)response, GlodonResponse.class);
            if (0 != glodonResponse.getReturnCode()) {
                logger.info("\u63a8\u9001\u8282\u70b9\u6570\u636e\u5931\u8d25:{}", (Object)glodonResponse.getThrowable());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u63a8\u9001\u8282\u70b9\u6570\u636e\u51fa\u9519:{}", (Object)e.getMessage());
        }
    }

    private Map<String, String> getHeaders() {
        HashMap headers = Maps.newHashMap();
        headers.put("Authorization", "Basic ZDE5Njc4YTQ4YjczZDdhOTM4NTdmNTZiMDA2NTAyZTg6NmRkZmI4ZGEzNw==");
        return headers;
    }

    private boolean isPushGld(UnifiedProcessInfo processInfo, UnifiedProcessInfo record) {
        return !processInfo.getProcessState().equals(record.getProcessState()) && !processInfo.getProcessState().equals(ProcessState.RUNNING.getValue());
    }

    public ApiResponse<String> processDelete(ProcessDeleteDto processInfo) {
        ApiResponse<String> isBuildSuccess = processInfo.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        if (processInfo.isTombstone()) {
            this.unifiedProcessInfoService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedProcessInfo::getSystemId, (Object)processInfo.getSystemId())).in(UnifiedProcessInfo::getProcInstId, Arrays.asList(processInfo.getProcInstId().split(",")))).set(UnifiedProcessInfo::getDeleteFlag, (Object)"1"));
        } else {
            if (processInfo.isCascade() && !(isBuildSuccess = this.taskDelete(new TaskDeleteDto().setSystemId(processInfo.getSystemId()).setProcInstId(processInfo.getProcInstId()))).isSuccess()) {
                return isBuildSuccess;
            }
            this.unifiedProcessInfoService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getSystemId, (Object)processInfo.getSystemId())).in(UnifiedProcessInfo::getProcInstId, Arrays.asList(processInfo.getProcInstId().split(","))));
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> processDeleteClassify(ProcessDeleteDto processInfo) {
        ApiResponse<String> isBuildSuccess = processInfo.buildAllInfo();
        if (!isBuildSuccess.isSuccess()) {
            return isBuildSuccess;
        }
        List procInsList = this.unifiedProcessInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getSystemId, (Object)processInfo.getSystemId())).in(UnifiedProcessInfo::getProcInstId, Arrays.asList(processInfo.getProcInstId().split(","))));
        if (processInfo.isTombstone()) {
            this.unifiedProcessInfoService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedProcessInfo::getSystemId, (Object)processInfo.getSystemId())).in(UnifiedProcessInfo::getProcInstId, Arrays.asList(processInfo.getProcInstId().split(",")))).set(UnifiedProcessInfo::getDeleteFlag, (Object)"1"));
        } else {
            if (processInfo.isCascade()) {
                ArrayList<String> types = new ArrayList<String>();
                types.add("1");
                types.add("2");
                types.add("3");
                types.add("4");
                types.add("5");
                isBuildSuccess = this.taskDeleteClassify(new TaskDeleteDto().setSystemId(processInfo.getSystemId()).setProcInstId(processInfo.getProcInstId()).setTaskTypes(types));
                if (!isBuildSuccess.isSuccess()) {
                    return isBuildSuccess;
                }
            }
            this.unifiedProcessInfoService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getSystemId, (Object)processInfo.getSystemId())).in(UnifiedProcessInfo::getProcInstId, Arrays.asList(processInfo.getProcInstId().split(","))));
        }
        if (this.unifiedTodoGLDProperties.isOpen()) {
            procInsList.forEach(proc -> {
                GlodonMainDataDto mainData = new GlodonMainDataDto();
                mainData.setId(String.valueOf(proc.getProcInfoId()));
                mainData.setDeleted(Boolean.valueOf(true));
                mainData.setApprovalStatus(Integer.valueOf(proc.getProcessState()));
                mainData.setPromoterId(proc.getStartUserId());
                mainData.setPromoterNo(proc.getStartUserNumber());
                mainData.setPromoterName(proc.getStartUserName());
                this.pushGldMain(mainData);
            });
        }
        return ApiResponse.success();
    }

    private List<UnifiedDoneTaskInfo> encapsulationDataDone(UnifiedTaskInfo unifiedTaskInfo, List<UnifiedTaskUser> taskUserList) {
        ArrayList<UnifiedDoneTaskInfo> listResult = new ArrayList<UnifiedDoneTaskInfo>();
        UnifiedDoneTaskInfo unifiedDoneTaskInfo = new UnifiedDoneTaskInfo();
        UnifiedProcessInfo unifiedProcessInfo = (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)unifiedTaskInfo.getProcessInstanceid()));
        unifiedDoneTaskInfo.setTaskId(unifiedTaskInfo.getTaskId());
        unifiedDoneTaskInfo.setSystemId(unifiedTaskInfo.getSystemId());
        unifiedDoneTaskInfo.setGategory(unifiedTaskInfo.getGategory());
        unifiedDoneTaskInfo.setSubject(unifiedTaskInfo.getSubject());
        unifiedDoneTaskInfo.setCreateTime(unifiedTaskInfo.getCreateTime());
        unifiedDoneTaskInfo.setLastTime(unifiedTaskInfo.getLastTime());
        unifiedDoneTaskInfo.setDeadLine(unifiedTaskInfo.getDeadLine());
        unifiedDoneTaskInfo.setCreateUserId(unifiedTaskInfo.getCreateUserId());
        unifiedDoneTaskInfo.setCreateUserName(unifiedTaskInfo.getCreateUserName());
        unifiedDoneTaskInfo.setSendUserId(unifiedTaskInfo.getSendUserId());
        unifiedDoneTaskInfo.setSendUserName(unifiedTaskInfo.getSendUserName());
        unifiedDoneTaskInfo.setWebLinkurl(unifiedTaskInfo.getWebLinkurl());
        unifiedDoneTaskInfo.setMobileLinkurl(unifiedTaskInfo.getMobileLinkurl());
        unifiedDoneTaskInfo.setBusinessId(unifiedTaskInfo.getBusinessid());
        unifiedDoneTaskInfo.setProcessName(unifiedTaskInfo.getProcessName());
        unifiedDoneTaskInfo.setTaskDefinitionkey(unifiedTaskInfo.getTaskDefinitionkey());
        unifiedDoneTaskInfo.setTaskName(unifiedTaskInfo.getTaskName());
        unifiedDoneTaskInfo.setProcessInstanceid(unifiedTaskInfo.getProcessInstanceid());
        unifiedDoneTaskInfo.setProcessDefinitionkey(unifiedTaskInfo.getProcessDefinitionkey());
        unifiedDoneTaskInfo.setTaskStatus(unifiedTaskInfo.getTaskStatus());
        unifiedDoneTaskInfo.setDeadLineConfig(unifiedTaskInfo.getDeadLineConfig());
        unifiedDoneTaskInfo.setPreactFlag(unifiedTaskInfo.getPreactFlag());
        unifiedDoneTaskInfo.setWebUrlProps(unifiedTaskInfo.getWebUrlProps());
        unifiedDoneTaskInfo.setMobileUrlProps(unifiedTaskInfo.getMobileUrlProps());
        if (HussarUtils.isNotEmpty((Object)unifiedProcessInfo)) {
            unifiedDoneTaskInfo.setProcessName(unifiedProcessInfo.getProcessName());
            unifiedDoneTaskInfo.setBusinessId(unifiedProcessInfo.getBusinessId());
            unifiedDoneTaskInfo.setProcDefId(unifiedProcessInfo.getProcDefId());
            unifiedDoneTaskInfo.setStartUserId(unifiedProcessInfo.getStartUserId());
            unifiedDoneTaskInfo.setStartUserName(unifiedProcessInfo.getStartUserName());
            unifiedDoneTaskInfo.setStartUserNumber(unifiedProcessInfo.getStartUserNumber());
            unifiedDoneTaskInfo.setStartTime(unifiedProcessInfo.getStartTime());
            unifiedDoneTaskInfo.setEndTime(unifiedProcessInfo.getEndTime());
            unifiedDoneTaskInfo.setProcessState(unifiedProcessInfo.getProcessState());
            unifiedDoneTaskInfo.setProcessDeptId(unifiedProcessInfo.getDeptId());
            unifiedDoneTaskInfo.setProcessUnitId(unifiedProcessInfo.getUnitId());
            unifiedDoneTaskInfo.setProcessDeptName(unifiedProcessInfo.getDeptName());
            unifiedDoneTaskInfo.setProcessUnitName(unifiedProcessInfo.getUnitName());
            unifiedDoneTaskInfo.setProcessDeleteFlag(unifiedProcessInfo.getDeleteFlag());
            unifiedDoneTaskInfo.setBusinessModelId(unifiedProcessInfo.getBusinessModelId());
            unifiedDoneTaskInfo.setBusinessModelName(unifiedProcessInfo.getBusinessModelName());
            unifiedDoneTaskInfo.setProcessWebLinkUrl(unifiedProcessInfo.getWebLinkurl());
            unifiedDoneTaskInfo.setProcessMobileLinkUrl(unifiedProcessInfo.getMobileLinkurl());
            unifiedDoneTaskInfo.setFormId(unifiedProcessInfo.getFormId());
            unifiedDoneTaskInfo.setRunName(unifiedProcessInfo.getRunName());
            unifiedDoneTaskInfo.setVerSys(unifiedProcessInfo.getVerSys());
            unifiedDoneTaskInfo.setTenantCode(unifiedProcessInfo.getTenantCode());
        }
        if (HussarUtils.isNotEmpty(taskUserList)) {
            for (UnifiedTaskUser unifiedTaskUser : taskUserList) {
                UnifiedDoneTaskInfo unifiedDoneTaskInfoNew = new UnifiedDoneTaskInfo();
                BeanUtils.copyProperties((Object)unifiedDoneTaskInfo, (Object)unifiedDoneTaskInfoNew);
                unifiedDoneTaskInfoNew.setDeptId(unifiedTaskUser.getDeptId());
                unifiedDoneTaskInfoNew.setDeptName(unifiedTaskUser.getDeptName());
                unifiedDoneTaskInfoNew.setUnitId(unifiedTaskUser.getUnitId());
                unifiedDoneTaskInfoNew.setUnitName(unifiedTaskUser.getUnitName());
                unifiedDoneTaskInfoNew.setPostId(unifiedTaskUser.getPostId());
                unifiedDoneTaskInfoNew.setPostName(unifiedTaskUser.getPostName());
                unifiedDoneTaskInfoNew.setUserId(unifiedTaskUser.getUserId());
                unifiedDoneTaskInfoNew.setAssigneeUserName(unifiedTaskUser.getUserName());
                unifiedDoneTaskInfoNew.setAssigneeUserNumber(unifiedTaskUser.getUserNumber());
                unifiedDoneTaskInfoNew.setAssigneeDeptId(unifiedTaskUser.getDeptId());
                unifiedDoneTaskInfoNew.setAssigneeDeptName(unifiedTaskUser.getDeptName());
                unifiedDoneTaskInfoNew.setAssigneeUnitId(unifiedTaskUser.getUnitId());
                unifiedDoneTaskInfoNew.setAssigneeUnitName(unifiedTaskUser.getUnitName());
                unifiedDoneTaskInfoNew.setAssigneeMainDeptId(unifiedTaskUser.getMainDeptId());
                unifiedDoneTaskInfoNew.setAssigneeMainDeptName(unifiedTaskUser.getMainDeptName());
                unifiedDoneTaskInfoNew.setAssigneeMainUnitId(unifiedTaskUser.getMainUnitId());
                unifiedDoneTaskInfoNew.setAssigneeMainUnitName(unifiedTaskUser.getMainUnitName());
                unifiedDoneTaskInfoNew.setMandators(unifiedTaskUser.getMandator());
                unifiedDoneTaskInfoNew.setUserTypes(unifiedTaskUser.getUserType());
                unifiedDoneTaskInfoNew.setCompleteTime(unifiedTaskUser.getCompleteTime());
                unifiedDoneTaskInfoNew.setUserNumber(unifiedTaskUser.getUserNumber());
                listResult.add(unifiedDoneTaskInfoNew);
            }
        } else {
            listResult.add(unifiedDoneTaskInfo);
        }
        if (this.unifiedTodoGLDProperties.isOpen()) {
            listResult.forEach(doneTaskInfo -> {
                GlodonNodeDataDto nodeDataDto = new GlodonNodeDataDto();
                nodeDataDto.setFlowId(unifiedDoneTaskInfo.getProcessInstanceid());
                nodeDataDto.setId(doneTaskInfo.getTaskId());
                if (null != doneTaskInfo.getCompleteTime()) {
                    nodeDataDto.setApproveTime(DateUtil.format((Date)doneTaskInfo.getCompleteTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                nodeDataDto.setApprovalStatus(Integer.valueOf(2));
                nodeDataDto.setDeleted(Boolean.valueOf(false));
                nodeDataDto.setPromoterId(unifiedDoneTaskInfo.getUserId());
                nodeDataDto.setPromoterNo(unifiedDoneTaskInfo.getAssigneeUserNumber());
                nodeDataDto.setPromoterName(unifiedDoneTaskInfo.getAssigneeUserName());
                nodeDataDto.setDeptName(unifiedDoneTaskInfo.getDeptName());
                nodeDataDto.setPostName(unifiedDoneTaskInfo.getPostName());
                nodeDataDto.setJumpUrl(this.unifiedTodoGLDProperties.getToDoList());
                this.pushGldNode(nodeDataDto);
            });
        }
        return listResult;
    }

    private List<UnifiedPendingTaskInfo> encapsulationDataPending(UnifiedTaskInfo unifiedTaskInfo, List<UnifiedTaskUser> taskUserList) {
        ArrayList<UnifiedPendingTaskInfo> listResult = new ArrayList<UnifiedPendingTaskInfo>();
        UnifiedPendingTaskInfo unifiedPendingTaskInfo = new UnifiedPendingTaskInfo();
        UnifiedProcessInfo unifiedProcessInfo = (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)unifiedTaskInfo.getProcessInstanceid()));
        unifiedPendingTaskInfo.setTaskId(unifiedTaskInfo.getTaskId());
        unifiedPendingTaskInfo.setSystemId(unifiedTaskInfo.getSystemId());
        unifiedPendingTaskInfo.setGategory(unifiedTaskInfo.getGategory());
        unifiedPendingTaskInfo.setSubject(unifiedTaskInfo.getSubject());
        unifiedPendingTaskInfo.setCreateTime(unifiedTaskInfo.getCreateTime());
        unifiedPendingTaskInfo.setLastTime(unifiedTaskInfo.getLastTime());
        unifiedPendingTaskInfo.setDeadLine(unifiedTaskInfo.getDeadLine());
        unifiedPendingTaskInfo.setCreateUserId(unifiedTaskInfo.getCreateUserId());
        unifiedPendingTaskInfo.setCreateUserName(unifiedTaskInfo.getCreateUserName());
        unifiedPendingTaskInfo.setSendUserId(unifiedTaskInfo.getSendUserId());
        unifiedPendingTaskInfo.setSendUserName(unifiedTaskInfo.getSendUserName());
        unifiedPendingTaskInfo.setWebLinkurl(unifiedTaskInfo.getWebLinkurl());
        unifiedPendingTaskInfo.setMobileLinkurl(unifiedTaskInfo.getMobileLinkurl());
        unifiedPendingTaskInfo.setBusinessId(unifiedTaskInfo.getBusinessid());
        unifiedPendingTaskInfo.setProcessName(unifiedTaskInfo.getProcessName());
        unifiedPendingTaskInfo.setTaskDefinitionkey(unifiedTaskInfo.getTaskDefinitionkey());
        unifiedPendingTaskInfo.setTaskName(unifiedTaskInfo.getTaskName());
        unifiedPendingTaskInfo.setProcessInstanceid(unifiedTaskInfo.getProcessInstanceid());
        unifiedPendingTaskInfo.setProcessDefinitionkey(unifiedTaskInfo.getProcessDefinitionkey());
        unifiedPendingTaskInfo.setTaskStatus(unifiedTaskInfo.getTaskStatus());
        unifiedPendingTaskInfo.setDeadLineConfig(unifiedTaskInfo.getDeadLineConfig());
        unifiedPendingTaskInfo.setPreactFlag(unifiedTaskInfo.getPreactFlag());
        unifiedPendingTaskInfo.setWebUrlProps(unifiedTaskInfo.getWebUrlProps());
        unifiedPendingTaskInfo.setMobileUrlProps(unifiedTaskInfo.getMobileUrlProps());
        if (HussarUtils.isNotEmpty((Object)unifiedProcessInfo)) {
            unifiedPendingTaskInfo.setProcessName(unifiedProcessInfo.getProcessName());
            unifiedPendingTaskInfo.setBusinessId(unifiedProcessInfo.getBusinessId());
            unifiedPendingTaskInfo.setProcDefId(unifiedProcessInfo.getProcDefId());
            unifiedPendingTaskInfo.setStartUserId(unifiedProcessInfo.getStartUserId());
            unifiedPendingTaskInfo.setStartUserName(unifiedProcessInfo.getStartUserName());
            unifiedPendingTaskInfo.setStartUserNumber(unifiedProcessInfo.getStartUserNumber());
            unifiedPendingTaskInfo.setStartTime(unifiedProcessInfo.getStartTime());
            unifiedPendingTaskInfo.setEndTime(unifiedProcessInfo.getEndTime());
            unifiedPendingTaskInfo.setProcessState(unifiedProcessInfo.getProcessState());
            unifiedPendingTaskInfo.setProcessDeptId(unifiedProcessInfo.getDeptId());
            unifiedPendingTaskInfo.setProcessUnitId(unifiedProcessInfo.getUnitId());
            unifiedPendingTaskInfo.setProcessDeptName(unifiedProcessInfo.getDeptName());
            unifiedPendingTaskInfo.setProcessUnitName(unifiedProcessInfo.getUnitName());
            unifiedPendingTaskInfo.setProcessDeleteFlag(unifiedProcessInfo.getDeleteFlag());
            unifiedPendingTaskInfo.setBusinessModelId(unifiedProcessInfo.getBusinessModelId());
            unifiedPendingTaskInfo.setBusinessModelName(unifiedProcessInfo.getBusinessModelName());
            unifiedPendingTaskInfo.setProcessWebLinkUrl(unifiedProcessInfo.getWebLinkurl());
            unifiedPendingTaskInfo.setProcessMobileLinkUrl(unifiedProcessInfo.getMobileLinkurl());
            unifiedPendingTaskInfo.setFormId(unifiedProcessInfo.getFormId());
            unifiedPendingTaskInfo.setRunName(unifiedProcessInfo.getRunName());
            unifiedPendingTaskInfo.setVerSys(unifiedProcessInfo.getVerSys());
            unifiedPendingTaskInfo.setTenantCode(unifiedProcessInfo.getTenantCode());
        }
        if (HussarUtils.isNotEmpty(taskUserList)) {
            for (UnifiedTaskUser unifiedTaskUser : taskUserList) {
                UnifiedPendingTaskInfo unifiedPendingTaskInfoNew = new UnifiedPendingTaskInfo();
                BeanUtils.copyProperties((Object)unifiedPendingTaskInfo, (Object)unifiedPendingTaskInfoNew);
                unifiedPendingTaskInfoNew.setDeptId(unifiedTaskUser.getDeptId());
                unifiedPendingTaskInfoNew.setDeptName(unifiedTaskUser.getDeptName());
                unifiedPendingTaskInfoNew.setUnitId(unifiedTaskUser.getUnitId());
                unifiedPendingTaskInfoNew.setUnitName(unifiedTaskUser.getUnitName());
                unifiedPendingTaskInfoNew.setPostId(unifiedTaskUser.getPostId());
                unifiedPendingTaskInfoNew.setPostName(unifiedTaskUser.getPostName());
                unifiedPendingTaskInfoNew.setUserId(unifiedTaskUser.getUserId());
                unifiedPendingTaskInfoNew.setMandators(unifiedTaskUser.getMandator());
                unifiedPendingTaskInfoNew.setUserTypes(unifiedTaskUser.getUserType());
                unifiedPendingTaskInfoNew.setCompleteTime(unifiedTaskUser.getCompleteTime());
                unifiedPendingTaskInfoNew.setUserNumber(unifiedTaskUser.getUserNumber());
                listResult.add(unifiedPendingTaskInfoNew);
            }
        } else {
            listResult.add(unifiedPendingTaskInfo);
        }
        return listResult;
    }

    private List<UnifiedReadedTaskInfo> encapsulationDataRead(UnifiedTaskInfo unifiedTaskInfo, List<UnifiedTaskUser> taskUserList) {
        ArrayList<UnifiedReadedTaskInfo> listResult = new ArrayList<UnifiedReadedTaskInfo>();
        UnifiedReadedTaskInfo unifiedReadedTaskInfo = new UnifiedReadedTaskInfo();
        UnifiedProcessInfo unifiedProcessInfo = (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)unifiedTaskInfo.getProcessInstanceid()));
        unifiedReadedTaskInfo.setTaskId(unifiedTaskInfo.getTaskId());
        unifiedReadedTaskInfo.setSystemId(unifiedTaskInfo.getSystemId());
        unifiedReadedTaskInfo.setGategory(unifiedTaskInfo.getGategory());
        unifiedReadedTaskInfo.setSubject(unifiedTaskInfo.getSubject());
        unifiedReadedTaskInfo.setCreateTime(unifiedTaskInfo.getCreateTime());
        unifiedReadedTaskInfo.setLastTime(unifiedTaskInfo.getLastTime());
        unifiedReadedTaskInfo.setDeadLine(unifiedTaskInfo.getDeadLine());
        unifiedReadedTaskInfo.setCreateUserId(unifiedTaskInfo.getCreateUserId());
        unifiedReadedTaskInfo.setCreateUserName(unifiedTaskInfo.getCreateUserName());
        unifiedReadedTaskInfo.setSendUserId(unifiedTaskInfo.getSendUserId());
        unifiedReadedTaskInfo.setSendUserName(unifiedTaskInfo.getSendUserName());
        unifiedReadedTaskInfo.setWebLinkurl(unifiedTaskInfo.getWebLinkurl());
        unifiedReadedTaskInfo.setMobileLinkurl(unifiedTaskInfo.getMobileLinkurl());
        unifiedReadedTaskInfo.setBusinessId(unifiedTaskInfo.getBusinessid());
        unifiedReadedTaskInfo.setProcessName(unifiedTaskInfo.getProcessName());
        unifiedReadedTaskInfo.setTaskDefinitionkey(unifiedTaskInfo.getTaskDefinitionkey());
        unifiedReadedTaskInfo.setTaskName(unifiedTaskInfo.getTaskName());
        unifiedReadedTaskInfo.setProcessInstanceid(unifiedTaskInfo.getProcessInstanceid());
        unifiedReadedTaskInfo.setProcessDefinitionkey(unifiedTaskInfo.getProcessDefinitionkey());
        unifiedReadedTaskInfo.setTaskStatus(unifiedTaskInfo.getTaskStatus());
        unifiedReadedTaskInfo.setDeadLineConfig(unifiedTaskInfo.getDeadLineConfig());
        unifiedReadedTaskInfo.setPreactFlag(unifiedTaskInfo.getPreactFlag());
        unifiedReadedTaskInfo.setWebUrlProps(unifiedTaskInfo.getWebUrlProps());
        unifiedReadedTaskInfo.setMobileUrlProps(unifiedTaskInfo.getMobileUrlProps());
        if (HussarUtils.isNotEmpty((Object)unifiedProcessInfo)) {
            unifiedReadedTaskInfo.setProcessName(unifiedProcessInfo.getProcessName());
            unifiedReadedTaskInfo.setBusinessId(unifiedProcessInfo.getBusinessId());
            unifiedReadedTaskInfo.setProcDefId(unifiedProcessInfo.getProcDefId());
            unifiedReadedTaskInfo.setStartUserId(unifiedProcessInfo.getStartUserId());
            unifiedReadedTaskInfo.setStartUserName(unifiedProcessInfo.getStartUserName());
            unifiedReadedTaskInfo.setStartUserNumber(unifiedProcessInfo.getStartUserNumber());
            unifiedReadedTaskInfo.setStartTime(unifiedProcessInfo.getStartTime());
            unifiedReadedTaskInfo.setEndTime(unifiedProcessInfo.getEndTime());
            unifiedReadedTaskInfo.setProcessState(unifiedProcessInfo.getProcessState());
            unifiedReadedTaskInfo.setProcessDeptId(unifiedProcessInfo.getDeptId());
            unifiedReadedTaskInfo.setProcessUnitId(unifiedProcessInfo.getUnitId());
            unifiedReadedTaskInfo.setProcessDeptName(unifiedProcessInfo.getDeptName());
            unifiedReadedTaskInfo.setProcessUnitName(unifiedProcessInfo.getUnitName());
            unifiedReadedTaskInfo.setProcessDeleteFlag(unifiedProcessInfo.getDeleteFlag());
            unifiedReadedTaskInfo.setBusinessModelId(unifiedProcessInfo.getBusinessModelId());
            unifiedReadedTaskInfo.setBusinessModelName(unifiedProcessInfo.getBusinessModelName());
            unifiedReadedTaskInfo.setProcessWebLinkUrl(unifiedProcessInfo.getWebLinkurl());
            unifiedReadedTaskInfo.setProcessMobileLinkUrl(unifiedProcessInfo.getMobileLinkurl());
            unifiedReadedTaskInfo.setFormId(unifiedProcessInfo.getFormId());
            unifiedReadedTaskInfo.setRunName(unifiedProcessInfo.getRunName());
            unifiedReadedTaskInfo.setVerSys(unifiedProcessInfo.getVerSys());
            unifiedReadedTaskInfo.setTenantCode(unifiedProcessInfo.getTenantCode());
        }
        if (HussarUtils.isNotEmpty(taskUserList)) {
            for (UnifiedTaskUser unifiedTaskUser : taskUserList) {
                UnifiedReadedTaskInfo unifiedReadedTaskInfoNew = new UnifiedReadedTaskInfo();
                BeanUtils.copyProperties((Object)unifiedReadedTaskInfo, (Object)unifiedReadedTaskInfoNew);
                unifiedReadedTaskInfoNew.setDeptId(unifiedTaskUser.getDeptId());
                unifiedReadedTaskInfoNew.setDeptName(unifiedTaskUser.getDeptName());
                unifiedReadedTaskInfoNew.setUnitId(unifiedTaskUser.getUnitId());
                unifiedReadedTaskInfoNew.setUnitName(unifiedTaskUser.getUnitName());
                unifiedReadedTaskInfoNew.setPostId(unifiedTaskUser.getPostId());
                unifiedReadedTaskInfoNew.setPostName(unifiedTaskUser.getPostName());
                unifiedReadedTaskInfoNew.setUserId(unifiedTaskUser.getUserId());
                unifiedReadedTaskInfoNew.setMandators(unifiedTaskUser.getMandator());
                unifiedReadedTaskInfoNew.setUserTypes(unifiedTaskUser.getUserType());
                unifiedReadedTaskInfoNew.setCompleteTime(unifiedTaskUser.getCompleteTime());
                unifiedReadedTaskInfoNew.setUserNumber(unifiedTaskUser.getUserNumber());
                listResult.add(unifiedReadedTaskInfoNew);
            }
        } else {
            listResult.add(unifiedReadedTaskInfo);
        }
        return listResult;
    }

    private List<UnifiedTodoTaskInfo> encapsulationDataTodo(UnifiedTaskInfo unifiedTaskInfo, List<UnifiedTaskUser> taskUserList) {
        ArrayList<UnifiedTodoTaskInfo> listResult = new ArrayList<UnifiedTodoTaskInfo>();
        UnifiedTodoTaskInfo unifiedTodoTaskInfo = new UnifiedTodoTaskInfo();
        UnifiedProcessInfo unifiedProcessInfo = (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)unifiedTaskInfo.getProcessInstanceid()));
        unifiedTodoTaskInfo.setTaskId(unifiedTaskInfo.getTaskId());
        unifiedTodoTaskInfo.setSystemId(unifiedTaskInfo.getSystemId());
        unifiedTodoTaskInfo.setGategory(unifiedTaskInfo.getGategory());
        unifiedTodoTaskInfo.setSubject(unifiedTaskInfo.getSubject());
        unifiedTodoTaskInfo.setCreateTime(unifiedTaskInfo.getCreateTime());
        unifiedTodoTaskInfo.setLastTime(unifiedTaskInfo.getLastTime());
        unifiedTodoTaskInfo.setDeadLine(unifiedTaskInfo.getDeadLine());
        unifiedTodoTaskInfo.setCreateUserId(unifiedTaskInfo.getCreateUserId());
        unifiedTodoTaskInfo.setCreateUserName(unifiedTaskInfo.getCreateUserName());
        unifiedTodoTaskInfo.setSendUserId(unifiedTaskInfo.getSendUserId());
        unifiedTodoTaskInfo.setSendUserName(unifiedTaskInfo.getSendUserName());
        unifiedTodoTaskInfo.setWebLinkurl(unifiedTaskInfo.getWebLinkurl());
        unifiedTodoTaskInfo.setMobileLinkurl(unifiedTaskInfo.getMobileLinkurl());
        unifiedTodoTaskInfo.setBusinessId(unifiedTaskInfo.getBusinessid());
        unifiedTodoTaskInfo.setProcessName(unifiedTaskInfo.getProcessName());
        unifiedTodoTaskInfo.setTaskDefinitionkey(unifiedTaskInfo.getTaskDefinitionkey());
        unifiedTodoTaskInfo.setTaskName(unifiedTaskInfo.getTaskName());
        unifiedTodoTaskInfo.setProcessInstanceid(unifiedTaskInfo.getProcessInstanceid());
        unifiedTodoTaskInfo.setProcessDefinitionkey(unifiedTaskInfo.getProcessDefinitionkey());
        unifiedTodoTaskInfo.setTaskStatus(unifiedTaskInfo.getTaskStatus());
        unifiedTodoTaskInfo.setDeadLineConfig(unifiedTaskInfo.getDeadLineConfig());
        unifiedTodoTaskInfo.setPreactFlag(unifiedTaskInfo.getPreactFlag());
        unifiedTodoTaskInfo.setWebUrlProps(unifiedTaskInfo.getWebUrlProps());
        unifiedTodoTaskInfo.setMobileUrlProps(unifiedTaskInfo.getMobileUrlProps());
        if (HussarUtils.isNotEmpty((Object)unifiedProcessInfo)) {
            unifiedTodoTaskInfo.setProcessName(unifiedProcessInfo.getProcessName());
            unifiedTodoTaskInfo.setBusinessId(unifiedProcessInfo.getBusinessId());
            unifiedTodoTaskInfo.setProcDefId(unifiedProcessInfo.getProcDefId());
            unifiedTodoTaskInfo.setStartUserId(unifiedProcessInfo.getStartUserId());
            unifiedTodoTaskInfo.setStartUserName(unifiedProcessInfo.getStartUserName());
            unifiedTodoTaskInfo.setStartUserNumber(unifiedProcessInfo.getStartUserNumber());
            unifiedTodoTaskInfo.setStartTime(unifiedProcessInfo.getStartTime());
            unifiedTodoTaskInfo.setEndTime(unifiedProcessInfo.getEndTime());
            unifiedTodoTaskInfo.setProcessState(unifiedProcessInfo.getProcessState());
            unifiedTodoTaskInfo.setProcessDeptId(unifiedProcessInfo.getDeptId());
            unifiedTodoTaskInfo.setProcessUnitId(unifiedProcessInfo.getUnitId());
            unifiedTodoTaskInfo.setProcessDeptName(unifiedProcessInfo.getDeptName());
            unifiedTodoTaskInfo.setProcessUnitName(unifiedProcessInfo.getUnitName());
            unifiedTodoTaskInfo.setProcessDeleteFlag(unifiedProcessInfo.getDeleteFlag());
            unifiedTodoTaskInfo.setBusinessModelId(unifiedProcessInfo.getBusinessModelId());
            unifiedTodoTaskInfo.setBusinessModelName(unifiedProcessInfo.getBusinessModelName());
            unifiedTodoTaskInfo.setProcessWebLinkUrl(unifiedProcessInfo.getWebLinkurl());
            unifiedTodoTaskInfo.setProcessMobileLinkUrl(unifiedProcessInfo.getMobileLinkurl());
            unifiedTodoTaskInfo.setFormId(unifiedProcessInfo.getFormId());
            unifiedTodoTaskInfo.setRunName(unifiedProcessInfo.getRunName());
            unifiedTodoTaskInfo.setVerSys(unifiedProcessInfo.getVerSys());
            unifiedTodoTaskInfo.setTenantCode(unifiedProcessInfo.getTenantCode());
        }
        if (HussarUtils.isNotEmpty(taskUserList)) {
            for (UnifiedTaskUser unifiedTaskUser : taskUserList) {
                UnifiedTodoTaskInfo unifiedTodoTaskInfoNew = new UnifiedTodoTaskInfo();
                BeanUtils.copyProperties((Object)unifiedTodoTaskInfo, (Object)unifiedTodoTaskInfoNew);
                unifiedTodoTaskInfoNew.setDeptId(unifiedTaskUser.getDeptId());
                unifiedTodoTaskInfoNew.setDeptName(unifiedTaskUser.getDeptName());
                unifiedTodoTaskInfoNew.setUnitId(unifiedTaskUser.getUnitId());
                unifiedTodoTaskInfoNew.setUnitName(unifiedTaskUser.getUnitName());
                unifiedTodoTaskInfoNew.setPostId(unifiedTaskUser.getPostId());
                unifiedTodoTaskInfoNew.setPostName(unifiedTaskUser.getPostName());
                unifiedTodoTaskInfoNew.setUserId(unifiedTaskUser.getUserId());
                unifiedTodoTaskInfoNew.setAssigneeUserName(unifiedTaskUser.getUserName());
                unifiedTodoTaskInfoNew.setAssigneeUserNumber(unifiedTaskUser.getUserNumber());
                unifiedTodoTaskInfoNew.setAssigneeDeptId(unifiedTaskUser.getDeptId());
                unifiedTodoTaskInfoNew.setAssigneeDeptName(unifiedTaskUser.getDeptName());
                unifiedTodoTaskInfoNew.setAssigneeUnitId(unifiedTaskUser.getUnitId());
                unifiedTodoTaskInfoNew.setAssigneeUnitName(unifiedTaskUser.getUnitName());
                unifiedTodoTaskInfoNew.setAssigneeMainDeptId(unifiedTaskUser.getMainDeptId());
                unifiedTodoTaskInfoNew.setAssigneeMainDeptName(unifiedTaskUser.getMainDeptName());
                unifiedTodoTaskInfoNew.setAssigneeMainUnitId(unifiedTaskUser.getMainUnitId());
                unifiedTodoTaskInfoNew.setAssigneeMainUnitName(unifiedTaskUser.getMainUnitName());
                unifiedTodoTaskInfoNew.setMandators(unifiedTaskUser.getMandator());
                unifiedTodoTaskInfoNew.setUserTypes(unifiedTaskUser.getUserType());
                unifiedTodoTaskInfoNew.setCompleteTime(unifiedTaskUser.getCompleteTime());
                unifiedTodoTaskInfoNew.setUserNumber(unifiedTaskUser.getUserNumber());
                listResult.add(unifiedTodoTaskInfoNew);
            }
        } else {
            listResult.add(unifiedTodoTaskInfo);
        }
        if (this.unifiedTodoGLDProperties.isOpen()) {
            listResult.forEach(todoTaskInfo -> {
                GlodonNodeDataDto requestBody = new GlodonNodeDataDto();
                requestBody.setFlowId(unifiedTaskInfo.getProcessInstanceid());
                requestBody.setId(todoTaskInfo.getTaskId());
                requestBody.setDeleted(Boolean.valueOf(false));
                requestBody.setPromoterId(todoTaskInfo.getUserId());
                requestBody.setPromoterNo(todoTaskInfo.getAssigneeUserNumber());
                requestBody.setPromoterName(todoTaskInfo.getAssigneeUserName());
                requestBody.setDeptName(todoTaskInfo.getDeptName());
                requestBody.setPostName(todoTaskInfo.getPostName());
                requestBody.setJumpUrl(this.unifiedTodoGLDProperties.getToBe());
                if (null != todoTaskInfo.getCompleteTime()) {
                    requestBody.setDeadlineTime(DateUtil.format((Date)todoTaskInfo.getDeadLine(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                if ("1".equals(todoTaskInfo.getTaskStatus())) {
                    requestBody.setApprovalStatus(Integer.valueOf(1));
                } else if ("3".equals(todoTaskInfo.getTaskStatus())) {
                    requestBody.setApprovalStatus(Integer.valueOf(2));
                }
                this.pushGldNode(requestBody);
            });
        }
        return listResult;
    }

    private List<UnifiedUnReadTaskInfo> encapsulationDataUnRead(UnifiedTaskInfo unifiedTaskInfo, List<UnifiedTaskUser> taskUserList) {
        ArrayList<UnifiedUnReadTaskInfo> listResult = new ArrayList<UnifiedUnReadTaskInfo>();
        UnifiedUnReadTaskInfo unifiedUnReadTaskInfo = new UnifiedUnReadTaskInfo();
        UnifiedProcessInfo unifiedProcessInfo = (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)unifiedTaskInfo.getProcessInstanceid()));
        unifiedUnReadTaskInfo.setTaskId(unifiedTaskInfo.getTaskId());
        unifiedUnReadTaskInfo.setSystemId(unifiedTaskInfo.getSystemId());
        unifiedUnReadTaskInfo.setGategory(unifiedTaskInfo.getGategory());
        unifiedUnReadTaskInfo.setSubject(unifiedTaskInfo.getSubject());
        unifiedUnReadTaskInfo.setCreateTime(unifiedTaskInfo.getCreateTime());
        unifiedUnReadTaskInfo.setLastTime(unifiedTaskInfo.getLastTime());
        unifiedUnReadTaskInfo.setDeadLine(unifiedTaskInfo.getDeadLine());
        unifiedUnReadTaskInfo.setCreateUserId(unifiedTaskInfo.getCreateUserId());
        unifiedUnReadTaskInfo.setCreateUserName(unifiedTaskInfo.getCreateUserName());
        unifiedUnReadTaskInfo.setSendUserId(unifiedTaskInfo.getSendUserId());
        unifiedUnReadTaskInfo.setSendUserName(unifiedTaskInfo.getSendUserName());
        unifiedUnReadTaskInfo.setWebLinkurl(unifiedTaskInfo.getWebLinkurl());
        unifiedUnReadTaskInfo.setMobileLinkurl(unifiedTaskInfo.getMobileLinkurl());
        unifiedUnReadTaskInfo.setBusinessId(unifiedTaskInfo.getBusinessid());
        unifiedUnReadTaskInfo.setProcessName(unifiedTaskInfo.getProcessName());
        unifiedUnReadTaskInfo.setTaskDefinitionkey(unifiedTaskInfo.getTaskDefinitionkey());
        unifiedUnReadTaskInfo.setTaskName(unifiedTaskInfo.getTaskName());
        unifiedUnReadTaskInfo.setProcessInstanceid(unifiedTaskInfo.getProcessInstanceid());
        unifiedUnReadTaskInfo.setProcessDefinitionkey(unifiedTaskInfo.getProcessDefinitionkey());
        unifiedUnReadTaskInfo.setTaskStatus(unifiedTaskInfo.getTaskStatus());
        unifiedUnReadTaskInfo.setDeadLineConfig(unifiedTaskInfo.getDeadLineConfig());
        unifiedUnReadTaskInfo.setPreactFlag(unifiedTaskInfo.getPreactFlag());
        unifiedUnReadTaskInfo.setWebUrlProps(unifiedTaskInfo.getWebUrlProps());
        unifiedUnReadTaskInfo.setMobileUrlProps(unifiedTaskInfo.getMobileUrlProps());
        if (HussarUtils.isNotEmpty((Object)unifiedProcessInfo)) {
            unifiedUnReadTaskInfo.setProcessName(unifiedProcessInfo.getProcessName());
            unifiedUnReadTaskInfo.setBusinessId(unifiedProcessInfo.getBusinessId());
            unifiedUnReadTaskInfo.setProcDefId(unifiedProcessInfo.getProcDefId());
            unifiedUnReadTaskInfo.setStartUserId(unifiedProcessInfo.getStartUserId());
            unifiedUnReadTaskInfo.setStartUserName(unifiedProcessInfo.getStartUserName());
            unifiedUnReadTaskInfo.setStartUserNumber(unifiedProcessInfo.getStartUserNumber());
            unifiedUnReadTaskInfo.setStartTime(unifiedProcessInfo.getStartTime());
            unifiedUnReadTaskInfo.setEndTime(unifiedProcessInfo.getEndTime());
            unifiedUnReadTaskInfo.setProcessState(unifiedProcessInfo.getProcessState());
            unifiedUnReadTaskInfo.setProcessDeptId(unifiedProcessInfo.getDeptId());
            unifiedUnReadTaskInfo.setProcessUnitId(unifiedProcessInfo.getUnitId());
            unifiedUnReadTaskInfo.setProcessDeptName(unifiedProcessInfo.getDeptName());
            unifiedUnReadTaskInfo.setProcessUnitName(unifiedProcessInfo.getUnitName());
            unifiedUnReadTaskInfo.setProcessDeleteFlag(unifiedProcessInfo.getDeleteFlag());
            unifiedUnReadTaskInfo.setBusinessModelId(unifiedProcessInfo.getBusinessModelId());
            unifiedUnReadTaskInfo.setBusinessModelName(unifiedProcessInfo.getBusinessModelName());
            unifiedUnReadTaskInfo.setProcessWebLinkUrl(unifiedProcessInfo.getWebLinkurl());
            unifiedUnReadTaskInfo.setProcessMobileLinkUrl(unifiedProcessInfo.getMobileLinkurl());
            unifiedUnReadTaskInfo.setFormId(unifiedProcessInfo.getFormId());
            unifiedUnReadTaskInfo.setRunName(unifiedProcessInfo.getRunName());
            unifiedUnReadTaskInfo.setVerSys(unifiedProcessInfo.getVerSys());
            unifiedUnReadTaskInfo.setTenantCode(unifiedProcessInfo.getTenantCode());
        }
        if (HussarUtils.isNotEmpty(taskUserList)) {
            for (UnifiedTaskUser unifiedTaskUser : taskUserList) {
                UnifiedUnReadTaskInfo unifiedUnReadTaskInfoNew = new UnifiedUnReadTaskInfo();
                BeanUtils.copyProperties((Object)unifiedUnReadTaskInfo, (Object)unifiedUnReadTaskInfoNew);
                unifiedUnReadTaskInfoNew.setDeptId(unifiedTaskUser.getDeptId());
                unifiedUnReadTaskInfoNew.setDeptName(unifiedTaskUser.getDeptName());
                unifiedUnReadTaskInfoNew.setUnitId(unifiedTaskUser.getUnitId());
                unifiedUnReadTaskInfoNew.setUnitName(unifiedTaskUser.getUnitName());
                unifiedUnReadTaskInfoNew.setPostId(unifiedTaskUser.getPostId());
                unifiedUnReadTaskInfoNew.setPostName(unifiedTaskUser.getPostName());
                unifiedUnReadTaskInfoNew.setUserId(unifiedTaskUser.getUserId());
                unifiedUnReadTaskInfoNew.setMandators(unifiedTaskUser.getMandator());
                unifiedUnReadTaskInfoNew.setUserTypes(unifiedTaskUser.getUserType());
                unifiedUnReadTaskInfoNew.setCompleteTime(unifiedTaskUser.getCompleteTime());
                unifiedUnReadTaskInfoNew.setUserNumber(unifiedTaskUser.getUserNumber());
                listResult.add(unifiedUnReadTaskInfoNew);
            }
        } else {
            listResult.add(unifiedUnReadTaskInfo);
        }
        return listResult;
    }

    private void updateTaskProcessDetail(UnifiedProcessInfo processInfo) {
        List unReadTaskInfos;
        List todoTaskInfos;
        List readedTaskInfos;
        List pendingTaskInfos;
        List doneTaskInfos = this.iUnifiedDoneTaskInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)processInfo.getProcInstId()), UnifiedDoneTaskInfo::getProcessInstanceid, (Object)processInfo.getProcInstId())).eq(HussarUtils.isNotEmpty((Object)processInfo.getSystemId()), UnifiedDoneTaskInfo::getSystemId, (Object)processInfo.getSystemId()));
        if (HussarUtils.isNotEmpty((Object)doneTaskInfos)) {
            List<UnifiedDoneTaskInfo> doneUpdateTaskInfos = this.encapsulationDataDones(doneTaskInfos, processInfo);
            this.iUnifiedDoneTaskInfoService.saveOrUpdateBatch(doneUpdateTaskInfos);
        }
        if (HussarUtils.isNotEmpty((Object)(pendingTaskInfos = this.iUnifiedPendingTaskInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)processInfo.getProcInstId()), UnifiedPendingTaskInfo::getProcessInstanceid, (Object)processInfo.getProcInstId())).eq(HussarUtils.isNotEmpty((Object)processInfo.getSystemId()), UnifiedPendingTaskInfo::getSystemId, (Object)processInfo.getSystemId()))))) {
            List<UnifiedPendingTaskInfo> pendingUpdateTaskInfos = this.encapsulationDataPendings(pendingTaskInfos, processInfo);
            this.iUnifiedPendingTaskInfoService.saveOrUpdateBatch(pendingUpdateTaskInfos);
        }
        if (HussarUtils.isNotEmpty((Object)(readedTaskInfos = this.iUnifiedReadedTaskInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)processInfo.getProcInstId()), UnifiedReadedTaskInfo::getProcessInstanceid, (Object)processInfo.getProcInstId())).eq(HussarUtils.isNotEmpty((Object)processInfo.getSystemId()), UnifiedReadedTaskInfo::getSystemId, (Object)processInfo.getSystemId()))))) {
            List<UnifiedReadedTaskInfo> readedUpdateTaskInfos = this.encapsulationDataReads(readedTaskInfos, processInfo);
            this.iUnifiedReadedTaskInfoService.saveOrUpdateBatch(readedUpdateTaskInfos);
        }
        if (HussarUtils.isNotEmpty((Object)(todoTaskInfos = this.iUnifiedTodoTaskInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)processInfo.getProcInstId()), UnifiedTodoTaskInfo::getProcessInstanceid, (Object)processInfo.getProcInstId())).eq(HussarUtils.isNotEmpty((Object)processInfo.getSystemId()), UnifiedTodoTaskInfo::getSystemId, (Object)processInfo.getSystemId()))))) {
            List<UnifiedTodoTaskInfo> todoUpdateTaskInfos = this.encapsulationDataTodos(todoTaskInfos, processInfo);
            this.iUnifiedTodoTaskInfoService.saveOrUpdateBatch(todoUpdateTaskInfos);
        }
        if (HussarUtils.isNotEmpty((Object)(unReadTaskInfos = this.iUnifiedUnReadTaskInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)processInfo.getProcInstId()), UnifiedUnReadTaskInfo::getProcessInstanceid, (Object)processInfo.getProcInstId())).eq(HussarUtils.isNotEmpty((Object)processInfo.getSystemId()), UnifiedUnReadTaskInfo::getSystemId, (Object)processInfo.getSystemId()))))) {
            List<UnifiedUnReadTaskInfo> unReadUpdateTaskInfos = this.encapsulationDataUnReads(unReadTaskInfos, processInfo);
            this.iUnifiedUnReadTaskInfoService.saveOrUpdateBatch(unReadUpdateTaskInfos);
        }
    }

    private List<UnifiedDoneTaskInfo> encapsulationDataDones(List<UnifiedDoneTaskInfo> doneTaskInfos, UnifiedProcessInfo unifiedProcessInfo) {
        for (UnifiedDoneTaskInfo unifiedDoneTaskInfo : doneTaskInfos) {
            if (!HussarUtils.isNotEmpty((Object)unifiedProcessInfo)) continue;
            unifiedDoneTaskInfo.setProcessName(unifiedProcessInfo.getProcessName());
            unifiedDoneTaskInfo.setBusinessId(unifiedProcessInfo.getBusinessId());
            unifiedDoneTaskInfo.setProcDefId(unifiedProcessInfo.getProcDefId());
            unifiedDoneTaskInfo.setStartUserId(unifiedProcessInfo.getStartUserId());
            unifiedDoneTaskInfo.setStartUserName(unifiedProcessInfo.getStartUserName());
            unifiedDoneTaskInfo.setStartUserNumber(unifiedProcessInfo.getStartUserNumber());
            unifiedDoneTaskInfo.setStartTime(unifiedProcessInfo.getStartTime());
            unifiedDoneTaskInfo.setEndTime(unifiedProcessInfo.getEndTime());
            unifiedDoneTaskInfo.setProcessState(unifiedProcessInfo.getProcessState());
            unifiedDoneTaskInfo.setProcessDeptId(unifiedProcessInfo.getDeptId());
            unifiedDoneTaskInfo.setProcessUnitId(unifiedProcessInfo.getUnitId());
            unifiedDoneTaskInfo.setProcessDeptName(unifiedProcessInfo.getDeptName());
            unifiedDoneTaskInfo.setProcessUnitName(unifiedProcessInfo.getUnitName());
            unifiedDoneTaskInfo.setProcessDeleteFlag(unifiedProcessInfo.getDeleteFlag());
            unifiedDoneTaskInfo.setBusinessModelId(unifiedProcessInfo.getBusinessModelId());
            unifiedDoneTaskInfo.setBusinessModelName(unifiedProcessInfo.getBusinessModelName());
            unifiedDoneTaskInfo.setProcessWebLinkUrl(unifiedProcessInfo.getWebLinkurl());
            unifiedDoneTaskInfo.setProcessMobileLinkUrl(unifiedProcessInfo.getMobileLinkurl());
            unifiedDoneTaskInfo.setFormId(unifiedProcessInfo.getFormId());
            unifiedDoneTaskInfo.setRunName(unifiedProcessInfo.getRunName());
            unifiedDoneTaskInfo.setVerSys(unifiedProcessInfo.getVerSys());
            unifiedDoneTaskInfo.setTenantCode(unifiedProcessInfo.getTenantCode());
        }
        return doneTaskInfos;
    }

    private List<UnifiedPendingTaskInfo> encapsulationDataPendings(List<UnifiedPendingTaskInfo> unifiedPendingTaskInfos, UnifiedProcessInfo unifiedProcessInfo) {
        for (UnifiedPendingTaskInfo unifiedPendingTaskInfo : unifiedPendingTaskInfos) {
            if (!HussarUtils.isNotEmpty((Object)unifiedProcessInfo)) continue;
            unifiedPendingTaskInfo.setProcessName(unifiedProcessInfo.getProcessName());
            unifiedPendingTaskInfo.setBusinessId(unifiedProcessInfo.getBusinessId());
            unifiedPendingTaskInfo.setProcDefId(unifiedProcessInfo.getProcDefId());
            unifiedPendingTaskInfo.setStartUserId(unifiedProcessInfo.getStartUserId());
            unifiedPendingTaskInfo.setStartUserName(unifiedProcessInfo.getStartUserName());
            unifiedPendingTaskInfo.setStartUserNumber(unifiedProcessInfo.getStartUserNumber());
            unifiedPendingTaskInfo.setStartTime(unifiedProcessInfo.getStartTime());
            unifiedPendingTaskInfo.setEndTime(unifiedProcessInfo.getEndTime());
            unifiedPendingTaskInfo.setProcessState(unifiedProcessInfo.getProcessState());
            unifiedPendingTaskInfo.setProcessDeptId(unifiedProcessInfo.getDeptId());
            unifiedPendingTaskInfo.setProcessUnitId(unifiedProcessInfo.getUnitId());
            unifiedPendingTaskInfo.setProcessDeptName(unifiedProcessInfo.getDeptName());
            unifiedPendingTaskInfo.setProcessUnitName(unifiedProcessInfo.getUnitName());
            unifiedPendingTaskInfo.setProcessDeleteFlag(unifiedProcessInfo.getDeleteFlag());
            unifiedPendingTaskInfo.setBusinessModelId(unifiedProcessInfo.getBusinessModelId());
            unifiedPendingTaskInfo.setBusinessModelName(unifiedProcessInfo.getBusinessModelName());
            unifiedPendingTaskInfo.setProcessWebLinkUrl(unifiedProcessInfo.getWebLinkurl());
            unifiedPendingTaskInfo.setProcessMobileLinkUrl(unifiedProcessInfo.getMobileLinkurl());
            unifiedPendingTaskInfo.setFormId(unifiedProcessInfo.getFormId());
            unifiedPendingTaskInfo.setRunName(unifiedProcessInfo.getRunName());
            unifiedPendingTaskInfo.setVerSys(unifiedProcessInfo.getVerSys());
            unifiedPendingTaskInfo.setTenantCode(unifiedProcessInfo.getTenantCode());
        }
        return unifiedPendingTaskInfos;
    }

    private List<UnifiedReadedTaskInfo> encapsulationDataReads(List<UnifiedReadedTaskInfo> unifiedReadedTaskInfos, UnifiedProcessInfo unifiedProcessInfo) {
        for (UnifiedReadedTaskInfo unifiedReadedTaskInfo : unifiedReadedTaskInfos) {
            if (!HussarUtils.isNotEmpty((Object)unifiedProcessInfo)) continue;
            unifiedReadedTaskInfo.setProcessName(unifiedProcessInfo.getProcessName());
            unifiedReadedTaskInfo.setBusinessId(unifiedProcessInfo.getBusinessId());
            unifiedReadedTaskInfo.setProcDefId(unifiedProcessInfo.getProcDefId());
            unifiedReadedTaskInfo.setStartUserId(unifiedProcessInfo.getStartUserId());
            unifiedReadedTaskInfo.setStartUserName(unifiedProcessInfo.getStartUserName());
            unifiedReadedTaskInfo.setStartUserNumber(unifiedProcessInfo.getStartUserNumber());
            unifiedReadedTaskInfo.setStartTime(unifiedProcessInfo.getStartTime());
            unifiedReadedTaskInfo.setEndTime(unifiedProcessInfo.getEndTime());
            unifiedReadedTaskInfo.setProcessState(unifiedProcessInfo.getProcessState());
            unifiedReadedTaskInfo.setProcessDeptId(unifiedProcessInfo.getDeptId());
            unifiedReadedTaskInfo.setProcessUnitId(unifiedProcessInfo.getUnitId());
            unifiedReadedTaskInfo.setProcessDeptName(unifiedProcessInfo.getDeptName());
            unifiedReadedTaskInfo.setProcessUnitName(unifiedProcessInfo.getUnitName());
            unifiedReadedTaskInfo.setProcessDeleteFlag(unifiedProcessInfo.getDeleteFlag());
            unifiedReadedTaskInfo.setBusinessModelId(unifiedProcessInfo.getBusinessModelId());
            unifiedReadedTaskInfo.setBusinessModelName(unifiedProcessInfo.getBusinessModelName());
            unifiedReadedTaskInfo.setProcessWebLinkUrl(unifiedProcessInfo.getWebLinkurl());
            unifiedReadedTaskInfo.setProcessMobileLinkUrl(unifiedProcessInfo.getMobileLinkurl());
            unifiedReadedTaskInfo.setFormId(unifiedProcessInfo.getFormId());
            unifiedReadedTaskInfo.setRunName(unifiedProcessInfo.getRunName());
            unifiedReadedTaskInfo.setVerSys(unifiedProcessInfo.getVerSys());
            unifiedReadedTaskInfo.setTenantCode(unifiedProcessInfo.getTenantCode());
        }
        return unifiedReadedTaskInfos;
    }

    private List<UnifiedTodoTaskInfo> encapsulationDataTodos(List<UnifiedTodoTaskInfo> unifiedTodoTaskInfos, UnifiedProcessInfo unifiedProcessInfo) {
        for (UnifiedTodoTaskInfo unifiedTodoTaskInfo : unifiedTodoTaskInfos) {
            if (!HussarUtils.isNotEmpty((Object)unifiedProcessInfo)) continue;
            unifiedTodoTaskInfo.setProcessName(unifiedProcessInfo.getProcessName());
            unifiedTodoTaskInfo.setBusinessId(unifiedProcessInfo.getBusinessId());
            unifiedTodoTaskInfo.setProcDefId(unifiedProcessInfo.getProcDefId());
            unifiedTodoTaskInfo.setStartUserId(unifiedProcessInfo.getStartUserId());
            unifiedTodoTaskInfo.setStartUserName(unifiedProcessInfo.getStartUserName());
            unifiedTodoTaskInfo.setStartUserNumber(unifiedProcessInfo.getStartUserNumber());
            unifiedTodoTaskInfo.setStartTime(unifiedProcessInfo.getStartTime());
            unifiedTodoTaskInfo.setEndTime(unifiedProcessInfo.getEndTime());
            unifiedTodoTaskInfo.setProcessState(unifiedProcessInfo.getProcessState());
            unifiedTodoTaskInfo.setProcessDeptId(unifiedProcessInfo.getDeptId());
            unifiedTodoTaskInfo.setProcessUnitId(unifiedProcessInfo.getUnitId());
            unifiedTodoTaskInfo.setProcessDeptName(unifiedProcessInfo.getDeptName());
            unifiedTodoTaskInfo.setProcessUnitName(unifiedProcessInfo.getUnitName());
            unifiedTodoTaskInfo.setProcessDeleteFlag(unifiedProcessInfo.getDeleteFlag());
            unifiedTodoTaskInfo.setBusinessModelId(unifiedProcessInfo.getBusinessModelId());
            unifiedTodoTaskInfo.setBusinessModelName(unifiedProcessInfo.getBusinessModelName());
            unifiedTodoTaskInfo.setProcessWebLinkUrl(unifiedProcessInfo.getWebLinkurl());
            unifiedTodoTaskInfo.setProcessMobileLinkUrl(unifiedProcessInfo.getMobileLinkurl());
            unifiedTodoTaskInfo.setFormId(unifiedProcessInfo.getFormId());
            unifiedTodoTaskInfo.setRunName(unifiedProcessInfo.getRunName());
            unifiedTodoTaskInfo.setVerSys(unifiedProcessInfo.getVerSys());
            unifiedTodoTaskInfo.setTenantCode(unifiedProcessInfo.getTenantCode());
        }
        return unifiedTodoTaskInfos;
    }

    private List<UnifiedUnReadTaskInfo> encapsulationDataUnReads(List<UnifiedUnReadTaskInfo> unifiedUnReadTaskInfos, UnifiedProcessInfo unifiedProcessInfo) {
        for (UnifiedUnReadTaskInfo unifiedUnReadTaskInfo : unifiedUnReadTaskInfos) {
            if (!HussarUtils.isNotEmpty((Object)unifiedProcessInfo)) continue;
            unifiedUnReadTaskInfo.setProcessName(unifiedProcessInfo.getProcessName());
            unifiedUnReadTaskInfo.setBusinessId(unifiedProcessInfo.getBusinessId());
            unifiedUnReadTaskInfo.setProcDefId(unifiedProcessInfo.getProcDefId());
            unifiedUnReadTaskInfo.setStartUserId(unifiedProcessInfo.getStartUserId());
            unifiedUnReadTaskInfo.setStartUserName(unifiedProcessInfo.getStartUserName());
            unifiedUnReadTaskInfo.setStartUserNumber(unifiedProcessInfo.getStartUserNumber());
            unifiedUnReadTaskInfo.setStartTime(unifiedProcessInfo.getStartTime());
            unifiedUnReadTaskInfo.setEndTime(unifiedProcessInfo.getEndTime());
            unifiedUnReadTaskInfo.setProcessState(unifiedProcessInfo.getProcessState());
            unifiedUnReadTaskInfo.setProcessDeptId(unifiedProcessInfo.getDeptId());
            unifiedUnReadTaskInfo.setProcessUnitId(unifiedProcessInfo.getUnitId());
            unifiedUnReadTaskInfo.setProcessDeptName(unifiedProcessInfo.getDeptName());
            unifiedUnReadTaskInfo.setProcessUnitName(unifiedProcessInfo.getUnitName());
            unifiedUnReadTaskInfo.setProcessDeleteFlag(unifiedProcessInfo.getDeleteFlag());
            unifiedUnReadTaskInfo.setBusinessModelId(unifiedProcessInfo.getBusinessModelId());
            unifiedUnReadTaskInfo.setBusinessModelName(unifiedProcessInfo.getBusinessModelName());
            unifiedUnReadTaskInfo.setProcessWebLinkUrl(unifiedProcessInfo.getWebLinkurl());
            unifiedUnReadTaskInfo.setProcessMobileLinkUrl(unifiedProcessInfo.getMobileLinkurl());
            unifiedUnReadTaskInfo.setFormId(unifiedProcessInfo.getFormId());
            unifiedUnReadTaskInfo.setRunName(unifiedProcessInfo.getRunName());
            unifiedUnReadTaskInfo.setVerSys(unifiedProcessInfo.getVerSys());
            unifiedUnReadTaskInfo.setTenantCode(unifiedProcessInfo.getTenantCode());
        }
        return unifiedUnReadTaskInfos;
    }

    private void addTaskUser(UserAddBatchDto userAddBatchDto) {
        List todoList = this.iUnifiedTodoTaskInfoService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedTodoTaskInfo::getTaskId, (Object)userAddBatchDto.getTaskId())).eq(UnifiedTodoTaskInfo::getSystemId, (Object)userAddBatchDto.getSystemId()));
        List pendingList = this.iUnifiedPendingTaskInfoService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedPendingTaskInfo::getTaskId, (Object)userAddBatchDto.getTaskId())).eq(UnifiedPendingTaskInfo::getSystemId, (Object)userAddBatchDto.getSystemId()));
        List unReadList = this.iUnifiedUnReadTaskInfoService.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedUnReadTaskInfo::getTaskId, (Object)userAddBatchDto.getTaskId())).eq(UnifiedUnReadTaskInfo::getSystemId, (Object)userAddBatchDto.getSystemId()));
        ArrayList<UnifiedTodoTaskInfo> todoListAdd = new ArrayList<UnifiedTodoTaskInfo>();
        ArrayList<UnifiedPendingTaskInfo> pendingListAdd = new ArrayList<UnifiedPendingTaskInfo>();
        ArrayList<UnifiedUnReadTaskInfo> unReadListAdd = new ArrayList<UnifiedUnReadTaskInfo>();
        if (HussarUtils.isNotEmpty((Object)userAddBatchDto.getTaskUsers())) {
            for (UnifiedTaskUser unifiedTaskUser : userAddBatchDto.getTaskUsers()) {
                if (HussarUtils.isNotEmpty((Object)todoList)) {
                    UnifiedTodoTaskInfo unifiedTodoTaskInfo = new UnifiedTodoTaskInfo();
                    BeanUtils.copyProperties(todoList.get(0), (Object)unifiedTodoTaskInfo);
                    unifiedTodoTaskInfo.setDeptId(unifiedTaskUser.getDeptId());
                    unifiedTodoTaskInfo.setDeptName(unifiedTaskUser.getDeptName());
                    unifiedTodoTaskInfo.setUnitId(unifiedTaskUser.getUnitId());
                    unifiedTodoTaskInfo.setUnitName(unifiedTaskUser.getUnitName());
                    unifiedTodoTaskInfo.setPostId(unifiedTaskUser.getPostId());
                    unifiedTodoTaskInfo.setPostName(unifiedTaskUser.getPostName());
                    unifiedTodoTaskInfo.setUserId(unifiedTaskUser.getUserId());
                    unifiedTodoTaskInfo.setAssigneeUserName(unifiedTaskUser.getUserName());
                    unifiedTodoTaskInfo.setAssigneeUserNumber(unifiedTaskUser.getUserNumber());
                    unifiedTodoTaskInfo.setAssigneeDeptId(unifiedTaskUser.getDeptId());
                    unifiedTodoTaskInfo.setAssigneeDeptName(unifiedTaskUser.getDeptName());
                    unifiedTodoTaskInfo.setAssigneeUnitId(unifiedTaskUser.getUnitId());
                    unifiedTodoTaskInfo.setAssigneeUnitName(unifiedTaskUser.getUnitName());
                    unifiedTodoTaskInfo.setAssigneeMainDeptId(unifiedTaskUser.getMainDeptId());
                    unifiedTodoTaskInfo.setAssigneeMainDeptName(unifiedTaskUser.getMainDeptName());
                    unifiedTodoTaskInfo.setAssigneeMainUnitId(unifiedTaskUser.getMainUnitId());
                    unifiedTodoTaskInfo.setAssigneeMainUnitName(unifiedTaskUser.getMainUnitName());
                    unifiedTodoTaskInfo.setMandators(unifiedTaskUser.getMandator());
                    unifiedTodoTaskInfo.setUserTypes(unifiedTaskUser.getUserType());
                    unifiedTodoTaskInfo.setCompleteTime(unifiedTaskUser.getCompleteTime());
                    unifiedTodoTaskInfo.setUserNumber(unifiedTaskUser.getUserNumber());
                    if (this.unifiedTodoGLDProperties.isOpen() && "1".equals(unifiedTodoTaskInfo.getTaskStatus())) {
                        GlodonNodeDataDto requestBody = new GlodonNodeDataDto();
                        requestBody.setFlowId(unifiedTodoTaskInfo.getProcessInstanceid());
                        requestBody.setId(unifiedTodoTaskInfo.getTaskId());
                        requestBody.setPromoterId(unifiedTodoTaskInfo.getUserId());
                        requestBody.setPromoterNo(unifiedTodoTaskInfo.getAssigneeUserNumber());
                        requestBody.setPromoterName(unifiedTodoTaskInfo.getAssigneeUserName());
                        requestBody.setDeptName(unifiedTodoTaskInfo.getDeptName());
                        requestBody.setPostName(unifiedTodoTaskInfo.getPostName());
                        requestBody.setDeleted(Boolean.valueOf(false));
                        requestBody.setJumpUrl(this.unifiedTodoGLDProperties.getToBe());
                        if (null != unifiedTodoTaskInfo.getDeadLine()) {
                            requestBody.setDeadlineTime(DateUtil.format((Date)unifiedTodoTaskInfo.getDeadLine(), (String)"yyyy-MM-dd HH:mm:ss"));
                        }
                        requestBody.setApprovalStatus(Integer.valueOf(1));
                        this.pushGldNode(requestBody);
                    }
                    todoListAdd.add(unifiedTodoTaskInfo);
                    this.iUnifiedTodoTaskInfoService.saveOrUpdateBatch(todoListAdd);
                }
                if (HussarUtils.isNotEmpty((Object)pendingList)) {
                    UnifiedPendingTaskInfo unifiedPendingTaskInfo = new UnifiedPendingTaskInfo();
                    BeanUtils.copyProperties(pendingList.get(0), (Object)unifiedPendingTaskInfo);
                    unifiedPendingTaskInfo.setDeptId(unifiedTaskUser.getDeptId());
                    unifiedPendingTaskInfo.setDeptName(unifiedTaskUser.getDeptName());
                    unifiedPendingTaskInfo.setUnitId(unifiedTaskUser.getUnitId());
                    unifiedPendingTaskInfo.setUnitName(unifiedTaskUser.getUnitName());
                    unifiedPendingTaskInfo.setPostId(unifiedTaskUser.getPostId());
                    unifiedPendingTaskInfo.setPostName(unifiedTaskUser.getPostName());
                    unifiedPendingTaskInfo.setUserId(unifiedTaskUser.getUserId());
                    unifiedPendingTaskInfo.setMandators(unifiedTaskUser.getMandator());
                    unifiedPendingTaskInfo.setUserTypes(unifiedTaskUser.getUserType());
                    unifiedPendingTaskInfo.setCompleteTime(unifiedTaskUser.getCompleteTime());
                    unifiedPendingTaskInfo.setUserNumber(unifiedTaskUser.getUserNumber());
                    pendingListAdd.add(unifiedPendingTaskInfo);
                    this.iUnifiedPendingTaskInfoService.saveOrUpdateBatch(pendingListAdd);
                }
                if (!HussarUtils.isNotEmpty((Object)unReadList)) continue;
                UnifiedUnReadTaskInfo unifiedUnReadTaskInfo = new UnifiedUnReadTaskInfo();
                BeanUtils.copyProperties(unReadList.get(0), (Object)unifiedUnReadTaskInfo);
                unifiedUnReadTaskInfo.setDeptId(unifiedTaskUser.getDeptId());
                unifiedUnReadTaskInfo.setDeptName(unifiedTaskUser.getDeptName());
                unifiedUnReadTaskInfo.setUnitId(unifiedTaskUser.getUnitId());
                unifiedUnReadTaskInfo.setUnitName(unifiedTaskUser.getUnitName());
                unifiedUnReadTaskInfo.setPostId(unifiedTaskUser.getPostId());
                unifiedUnReadTaskInfo.setPostName(unifiedTaskUser.getPostName());
                unifiedUnReadTaskInfo.setUserId(unifiedTaskUser.getUserId());
                unifiedUnReadTaskInfo.setMandators(unifiedTaskUser.getMandator());
                unifiedUnReadTaskInfo.setUserTypes(unifiedTaskUser.getUserType());
                unifiedUnReadTaskInfo.setCompleteTime(unifiedTaskUser.getCompleteTime());
                unifiedUnReadTaskInfo.setUserNumber(unifiedTaskUser.getUserNumber());
                unReadListAdd.add(unifiedUnReadTaskInfo);
                this.iUnifiedUnReadTaskInfoService.saveOrUpdateBatch(unReadListAdd);
            }
        }
    }

    private boolean isComply(int otherQueryCondition, int mark) {
        return (otherQueryCondition & mark) == mark;
    }

    private static /* synthetic */ boolean lambda$userAddBatchClassify$33(UnifiedDoneTaskInfo doneTaskInfo, UnifiedTaskUser t) {
        return t.getTaskId().equals(doneTaskInfo.getTaskId());
    }

    private static /* synthetic */ boolean lambda$userAddBatchClassify$32(UnifiedPendingTaskInfo pendingTaskInfo, UnifiedTaskUser t) {
        return t.getTaskId().equals(pendingTaskInfo.getTaskId());
    }

    private static /* synthetic */ boolean lambda$userAddBatchClassify$31(UnifiedTodoTaskInfo todoTaskInfo, UnifiedTaskUser t) {
        return t.getTaskId().equals(todoTaskInfo.getTaskId());
    }
}

