/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unifiedtodo.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.audit.core.support.dto.AuditLogModel;
import com.jxdinfo.hussar.support.audit.core.util.AuditLogUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.unifiedtodo.config.UnifiedTodoGLDProperties;
import com.jxdinfo.hussar.unifiedtodo.config.UnifiedTodoProperties;
import com.jxdinfo.hussar.unifiedtodo.constant.ProcessState;
import com.jxdinfo.hussar.unifiedtodo.dao.UnifiedToDoMapper;
import com.jxdinfo.hussar.unifiedtodo.dto.TaskNumber;
import com.jxdinfo.hussar.unifiedtodo.dto.UnifiedDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UnifiedParamDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UnifiedTaskQueryDto;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedDoneTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedPendingTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedProcessInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedProcessRectificationInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedReadedTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskUser;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTodoTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedUnReadTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.response.UnifiedResponse;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedDoneTaskInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedPendingTaskInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedProcessInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedProcessRectificationService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedReadedTaskInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskUserService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTodoTaskInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedUnReadTaskInfoService;
import com.jxdinfo.hussar.unifiedtodo.utils.HttpClientUtil;
import com.jxdinfo.hussar.unifiedtodo.vo.UnifiedTaskQueryVo;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTransactional
public class UnifiedServiceImpl
implements IUnifiedService {
    @Autowired
    private IUnifiedTaskInfoService unifiedTaskInfoService;
    @Autowired
    private IUnifiedTaskUserService unifiedTaskUserService;
    @Autowired
    private IUnifiedProcessInfoService unifiedProcessInfoService;
    @Autowired
    private IUnifiedProcessRectificationService unifiedProcessRectificationService;
    @Autowired
    private IUnifiedTodoTaskInfoService unifiedTodoTaskInfoService;
    @Autowired
    private IUnifiedUnReadTaskInfoService unifiedUnReadTaskInfoService;
    @Autowired
    private IUnifiedPendingTaskInfoService unifiedPendingTaskInfoService;
    @Autowired
    private IUnifiedDoneTaskInfoService unifiedDoneTaskInfoService;
    @Autowired
    IUnifiedReadedTaskInfoService unifiedReadedTaskInfoService;
    @Resource
    private UnifiedToDoMapper unifiedToDoMapper;
    @Resource
    private IUnifiedTodoTaskInfoService iUnifiedTodoTaskInfoService;
    @Resource
    private IUnifiedDoneTaskInfoService iUnifiedDoneTaskInfoService;
    @Resource
    private IUnifiedPendingTaskInfoService iUnifiedPendingTaskInfoService;
    @Resource
    private IUnifiedUnReadTaskInfoService iUnifiedUnReadTaskInfoService;
    @Resource
    private IUnifiedReadedTaskInfoService iUnifiedReadedTaskInfoService;
    @Resource
    private ISysUsersService usersService;
    @Resource
    private UnifiedTodoProperties unifiedTodoProperties;
    @Resource
    private UnifiedTodoGLDProperties unifiedTodoGLDProperties;
    private static final Logger logger = LoggerFactory.getLogger(UnifiedServiceImpl.class);
    private static final String MODULE_NAME = "OA-\u6570\u636e\u63a8\u9001";
    private final Consumer<UnifiedParamDto> update = unifiedParamDto -> {
        long start;
        logger.info("\u66f4\u65b0\u7684\u6570\u636e\u5185\u5bb9\uff1a" + JSON.toJSONString((Object)unifiedParamDto));
        UnifiedProcessInfo unifiedProcessInfo = unifiedParamDto.buildProcessInfo();
        UnifiedTaskInfo unifiedTaskInfo = unifiedParamDto.buildTaskInfo();
        UnifiedTaskUser unifiedTaskUser = unifiedParamDto.buildUserInfo();
        if (HussarUtils.isAllEmpty((Object[])new Object[]{unifiedProcessInfo, unifiedTaskInfo, unifiedTaskUser})) {
            return;
        }
        if (unifiedProcessInfo != null) {
            start = System.currentTimeMillis();
            logger.info("\u66f4\u65b0\u6d41\u7a0b\u4fe1\u606f\u5f00\u59cb\uff1a" + start);
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.unifiedProcessInfoService.lambdaUpdate().eq(UnifiedProcessInfo::getSystemId, (Object)unifiedProcessInfo.getSystemId())).eq(UnifiedProcessInfo::getProcInstId, (Object)unifiedProcessInfo.getProcInstId())).update((Object)unifiedProcessInfo);
            ArrayList<UnifiedProcessInfo> unifiedProcessInfos = new ArrayList<UnifiedProcessInfo>();
            unifiedProcessInfos.add(unifiedProcessInfo);
            this.updateTaskInfo(unifiedProcessInfos);
            long end = System.currentTimeMillis();
            logger.info("\u66f4\u65b0\u6d41\u7a0b\u4fe1\u606f\u5f00\u59cb\uff1a" + end);
            logger.info("\u66f4\u65b0\u6d41\u7a0b\u4fe1\u606f\u603b\u65f6\u95f4\uff1a" + (end - start));
        }
        if (unifiedTaskInfo != null) {
            start = System.currentTimeMillis();
            logger.info("\u66f4\u65b0\u4efb\u52a1\u4fe1\u606f\u5f00\u59cb\uff1a" + start);
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.unifiedTaskInfoService.lambdaUpdate().eq(UnifiedTaskInfo::getSystemId, (Object)unifiedTaskInfo.getSystemId())).eq(UnifiedTaskInfo::getTaskId, (Object)unifiedTaskInfo.getTaskId())).update((Object)unifiedTaskInfo);
            this.updateTaskStatus(unifiedTaskInfo, unifiedTaskUser);
            long end = System.currentTimeMillis();
            logger.info("\u66f4\u65b0\u4efb\u52a1\u4fe1\u606f\u5f00\u59cb\uff1a" + end);
            logger.info("\u66f4\u65b0\u6d41\u7a0b\u4fe1\u606f\u603b\u65f6\u95f4\uff1a" + (end - start));
        }
        if (unifiedTaskUser != null) {
            start = System.currentTimeMillis();
            logger.info("\u66f4\u65b0\u4efb\u52a1\u4fe1\u606f\u5f00\u59cb\uff1a" + start);
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.unifiedTaskUserService.lambdaUpdate().eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskUser.getSystemId())).eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskUser.getTaskId())).update((Object)unifiedTaskUser);
            this.updateTaskUsers(unifiedTaskUser);
            long end = System.currentTimeMillis();
            logger.info("\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u5f00\u59cb\uff1a" + end);
            logger.info("\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u603b\u65f6\u95f4\uff1a" + (end - start));
        }
    };

    public UnifiedResponse unifiedPush(UnifiedDto unifiedDto, Long systemId) {
        long start = System.currentTimeMillis();
        logger.info("\u63a5\u6536\u63a8\u9001\u6570\u636e\u5f00\u59cb\uff1a" + start);
        if (systemId == null) {
            return UnifiedResponse.paramFail();
        }
        ArrayList<UnifiedParamDto> add = new ArrayList<UnifiedParamDto>();
        ArrayList<UnifiedParamDto> update = new ArrayList<UnifiedParamDto>();
        ArrayList<UnifiedParamDto> delete = new ArrayList<UnifiedParamDto>();
        for (UnifiedParamDto unifiedParamDto : unifiedDto.getDataList()) {
            unifiedParamDto.systemId(systemId);
            if (UnifiedParamDto.optTypeEnum.ADD.strCode.equals(unifiedParamDto.getOptType())) {
                add.add(unifiedParamDto);
                continue;
            }
            if (UnifiedParamDto.optTypeEnum.UPDATE.strCode.equals(unifiedParamDto.getOptType())) {
                update.add(unifiedParamDto);
                continue;
            }
            if (UnifiedParamDto.optTypeEnum.DELETE.strCode.equals(unifiedParamDto.getOptType())) {
                delete.add(unifiedParamDto);
                continue;
            }
            return UnifiedResponse.paramFail();
        }
        this.addUnified(add);
        this.updateUnified(update);
        this.deleteUnified(delete, systemId);
        if (this.unifiedTodoProperties.getOpen()) {
            this.pushToOa(add, update, systemId.toString());
        }
        if (this.unifiedTodoGLDProperties.isOpen()) {
            this.pushToGld(add, update, this.toString());
        }
        long end = System.currentTimeMillis();
        logger.info("\u63a5\u6536\u63a8\u9001\u6570\u636e\u7ed3\u675f\uff1a" + end);
        logger.info("\u63a5\u6536\u63a8\u9001\u603b\u65f6\u95f4\uff1a" + (end - start));
        return UnifiedResponse.success();
    }

    private void pushToGld(List<UnifiedParamDto> add, List<UnifiedParamDto> update, String systemId) {
        block18: {
            SimpleDateFormat sf;
            ArrayList<UnifiedTaskUser> taskUserList;
            block17: {
                JSONObject jsonObject;
                String resp;
                Iterator resultData;
                HashMap<String, Object> data;
                ArrayList resultList;
                HashMap<String, String> headers;
                ArrayList<UnifiedParamDto> pushList = new ArrayList<UnifiedParamDto>();
                if (HussarUtils.isNotEmpty(update)) {
                    pushList.addAll(update);
                }
                if (HussarUtils.isNotEmpty(add)) {
                    pushList.addAll(add);
                }
                if (HussarUtils.isEmpty(pushList)) {
                    return;
                }
                ArrayList<UnifiedProcessInfo> processInfoList = new ArrayList<UnifiedProcessInfo>();
                ArrayList<UnifiedTaskInfo> taskInfoList = new ArrayList<UnifiedTaskInfo>();
                taskUserList = new ArrayList<UnifiedTaskUser>();
                for (UnifiedParamDto dto : pushList) {
                    UnifiedProcessInfo processInfo = dto.buildProcessInfo();
                    UnifiedTaskInfo taskInfo = dto.buildTaskInfo();
                    UnifiedTaskUser taskUser = dto.buildUserInfo();
                    if (!HussarUtils.isNull((Object)processInfo)) {
                        processInfoList.add(processInfo);
                    }
                    if (!HussarUtils.isNull((Object)taskInfo)) {
                        taskInfoList.add(taskInfo);
                    }
                    if (HussarUtils.isNull((Object)taskUser)) continue;
                    taskUserList.add(taskUser);
                }
                sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                if (HussarUtils.isNotEmpty(processInfoList)) {
                    headers = new HashMap<String, String>();
                    headers.put("Authorization", "Basic ZDE5Njc4YTQ4YjczZDdhOTM4NTdmNTZiMDA2NTAyZTg6NmRkZmI4ZGEzNw==");
                    for (UnifiedProcessInfo processInfo : processInfoList) {
                        resultList = new ArrayList();
                        data = new HashMap<String, Object>();
                        data.put("id", processInfo.getProcInstId());
                        data.put("approvalStatus", Integer.valueOf(this.getProcessStatus(processInfo.getProcessState())));
                        data.put("deleted", "false");
                        if (this.getProcessStatus(processInfo.getProcessState()).equals(ProcessState.RUNNING.getValue())) {
                            data.put("projectId", processInfo.getDeptId());
                            data.put("projectName", processInfo.getDeptName());
                            data.put("flowName", processInfo.getProcessName());
                            data.put("promoterId", processInfo.getStartUserId());
                            data.put("promoterNo", processInfo.getStartUserNumber());
                            data.put("promoterName", processInfo.getStartUserName());
                            data.put("promotionTime", HussarUtils.isNotEmpty((Object)processInfo.getStartTime()) ? sf.format(processInfo.getStartTime()) : "");
                        }
                        resultList.add(data);
                        resultData = JSON.toJSONString(resultList);
                        logger.info("requestParamJsonToGLD:" + (String)((Object)resultData));
                        resp = HttpClientUtil.httpPost(this.unifiedTodoGLDProperties.getApproveRecord(), (String)((Object)resultData), headers);
                        logger.info("responseParamToGLD:" + resp);
                        jsonObject = JSON.parseObject((String)resp);
                        if (!HussarUtils.isNotEmpty((Object)jsonObject.get((Object)"returnCode")) || jsonObject.get((Object)"returnCode").equals("0")) continue;
                        logger.info("\u63a8\u9001\u6d41\u7a0b\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a " + jsonObject.get((Object)"errorString"));
                    }
                }
                if (!HussarUtils.isNotEmpty(taskInfoList)) break block17;
                headers = new HashMap();
                headers.put("Authorization", "Basic ZDE5Njc4YTQ4YjczZDdhOTM4NTdmNTZiMDA2NTAyZTg6NmRkZmI4ZGEzNw==");
                for (UnifiedTaskInfo taskInfo : taskInfoList) {
                    resultList = new ArrayList();
                    data = new HashMap();
                    if ("1".equals(taskInfo.getTaskStatus())) {
                        data.put("flowId", taskInfo.getProcessInstanceid());
                        data.put("id", taskInfo.getTaskId());
                        data.put("name", taskInfo.getTaskName());
                        data.put("deadlineTime", !HussarUtils.isNull((Object)taskInfo.getDeadLine()) ? sf.format(taskInfo.getDeadLine()) : "");
                        data.put("approvalStatus", Integer.valueOf("1"));
                        data.put("approveTime", "");
                        data.put("deleted", "false");
                        data.put("jumpUrl", this.getJumpUrl("1", taskInfo.getTaskId()));
                        if (HussarUtils.isNotEmpty(taskUserList)) {
                            for (UnifiedTaskUser unifiedTaskUser : taskUserList) {
                                if (!unifiedTaskUser.getTaskId().equals(taskInfo.getTaskId())) continue;
                                data.put("promoterId", unifiedTaskUser.getUserId());
                                data.put("promoterNo", unifiedTaskUser.getUserNumber());
                                data.put("promoterName", unifiedTaskUser.getUserName());
                                data.put("deptName", unifiedTaskUser.getDeptName());
                                data.put("postName", unifiedTaskUser.getPostName());
                            }
                        }
                    } else {
                        if (!"3".equals(taskInfo.getTaskStatus())) continue;
                        data.put("flowId", taskInfo.getProcessInstanceid());
                        data.put("id", taskInfo.getTaskId());
                        data.put("approveTime", "");
                        data.put("approvalStatus", "2");
                        data.put("deleted", "false");
                        data.put("jumpUrl", this.getJumpUrl("3", taskInfo.getTaskId()));
                        if (HussarUtils.isNotEmpty(taskUserList)) {
                            for (UnifiedTaskUser unifiedTaskUser : taskUserList) {
                                if (!unifiedTaskUser.getTaskId().equals(taskInfo.getTaskId())) continue;
                                data.put("approveTime", !HussarUtils.isNull((Object)unifiedTaskUser.getCompleteTime()) ? sf.format(unifiedTaskUser.getCompleteTime()) : "");
                            }
                        }
                    }
                    resultList.add(data);
                    resultData = JSON.toJSONString(resultList);
                    logger.info("requestParamJsonToGLD:" + resultData);
                    resp = HttpClientUtil.httpPost(this.unifiedTodoGLDProperties.getApproveNode(), resultData, headers);
                    logger.info("responseParamToGLD:" + resp);
                    jsonObject = JSON.parseObject((String)resp);
                    if (!HussarUtils.isNotEmpty((Object)jsonObject.get((Object)"returnCode")) || jsonObject.get((Object)"returnCode").equals("0")) continue;
                    logger.info("\u63a8\u9001\u8282\u70b9\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a " + jsonObject.get((Object)"errorString"));
                }
                break block18;
            }
            if (!HussarUtils.isNotEmpty(taskUserList)) break block18;
            for (UnifiedTaskUser unifiedTaskUser : taskUserList) {
                ArrayList resultList = new ArrayList();
                HashMap<String, Object> data = new HashMap<String, Object>();
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Authorization", "Basic ZDE5Njc4YTQ4YjczZDdhOTM4NTdmNTZiMDA2NTAyZTg6NmRkZmI4ZGEzNw==");
                UnifiedTaskInfo taskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)unifiedTaskUser.getTaskId())).eq(UnifiedTaskInfo::getSystemId, (Object)systemId));
                if (HussarUtils.isNull((Object)taskInfo)) continue;
                data.put("flowId", taskInfo.getProcessInstanceid());
                data.put("id", taskInfo.getTaskId());
                data.put("name", taskInfo.getTaskName());
                data.put("deadlineTime", !HussarUtils.isNull((Object)taskInfo.getDeadLine()) ? sf.format(taskInfo.getDeadLine()) : "");
                data.put("approvalStatus", Integer.valueOf("1"));
                data.put("approveTime", "");
                data.put("promoterId", unifiedTaskUser.getUserId());
                data.put("promoterNo", unifiedTaskUser.getUserNumber());
                data.put("promoterName", unifiedTaskUser.getUserName());
                data.put("deptName", unifiedTaskUser.getDeptName());
                data.put("postName", unifiedTaskUser.getPostName());
                data.put("jumpUrl", this.getJumpUrl("1", taskInfo.getTaskId()));
                data.put("deleted", "false");
                resultList.add(data);
                String resultData = JSON.toJSONString(resultList);
                logger.info("requestParamJsonToGLD:" + resultData);
                String resp = HttpClientUtil.httpPost(this.unifiedTodoGLDProperties.getApproveNode(), resultData, headers);
                logger.info("responseParamToGLD:" + resp);
                JSONObject jsonObject = JSON.parseObject((String)resp);
                if (!HussarUtils.isNotEmpty((Object)jsonObject.get((Object)"returnCode")) || jsonObject.get((Object)"returnCode").equals("0")) continue;
                logger.info("\u63a8\u9001\u8282\u70b9\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a " + jsonObject.get((Object)"errorString"));
            }
        }
    }

    private String getJumpUrl(String taskStatus, String taskId) {
        if ("1".equals(taskStatus)) {
            return this.unifiedTodoGLDProperties.getToBe() + "%2526taskId=" + taskId;
        }
        if ("3".equals(taskStatus)) {
            return this.unifiedTodoGLDProperties.getToDo() + "?runflowid=" + taskId;
        }
        return "";
    }

    private String getProcessStatus(String processState) {
        if (ProcessState.DONE_RECTIFICATION.getValue().equals(processState)) {
            return ProcessState.RECTIFICATION.getValue();
        }
        return processState;
    }

    private void pushToOa(List<UnifiedParamDto> add, List<UnifiedParamDto> update, String systemId) {
        ArrayList<UnifiedParamDto> pushList = new ArrayList<UnifiedParamDto>();
        if (HussarUtils.isNotEmpty(update)) {
            pushList.addAll(update);
        }
        if (HussarUtils.isNotEmpty(add)) {
            pushList.addAll(add);
        }
        if (HussarUtils.isEmpty(pushList)) {
            return;
        }
        pushList.sort(Comparator.comparing(UnifiedParamDto::getTypeid).reversed());
        logger.info("addList" + add.toString());
        logger.info("updateList" + update.toString());
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (UnifiedParamDto unifiedParamDto : pushList) {
            if ("4".equals(unifiedParamDto.getTypeid()) || "5".equals(unifiedParamDto.getTypeid())) {
                List doneTaskInfoList;
                List pendingTaskInfoList;
                logger.info("unifiedParamDto\u672a\u8bfb/\u5df2\u8bfb" + JSON.toJSONString((Object)unifiedParamDto));
                long count = pushList.stream().filter(u -> u.getUserId().equals(unifiedParamDto.getUserId()) && !u.getApprovalId().equals(unifiedParamDto.getApprovalId())).count();
                if (count > 0L) continue;
                List todoTaskInfoList = this.iUnifiedTodoTaskInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTodoTaskInfo::getProcessInstanceid, (Object)unifiedParamDto.getFlowID())).ne(UnifiedTodoTaskInfo::getTaskId, (Object)unifiedParamDto.getApprovalId()));
                if (CollectionUtil.isNotEmpty((Collection)todoTaskInfoList)) {
                    long countNew;
                    logger.info("todoTaskInfoList\u957f\u5ea6\uff1a" + todoTaskInfoList.size());
                    List todoIdList = todoTaskInfoList.stream().map(UnifiedTodoTaskInfo::getTaskId).collect(Collectors.toList());
                    List todoUserList = this.unifiedTaskUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskUser::getTaskId, todoIdList)).eq(UnifiedTaskUser::getSystemId, (Object)unifiedParamDto.getSystemId()));
                    if (CollectionUtil.isNotEmpty((Collection)todoUserList) && (countNew = todoUserList.stream().filter(u -> u.getUserId().equals(unifiedParamDto.getUserId())).count()) > 0L) continue;
                }
                if (CollectionUtil.isNotEmpty((Collection)(pendingTaskInfoList = this.iUnifiedPendingTaskInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedPendingTaskInfo::getProcessInstanceid, (Object)unifiedParamDto.getFlowID())).ne(UnifiedPendingTaskInfo::getTaskId, (Object)unifiedParamDto.getApprovalId()))))) {
                    long countNew;
                    logger.info("pendingTaskInfoList\u957f\u5ea6\uff1a" + pendingTaskInfoList.size());
                    List pendingIdList = pendingTaskInfoList.stream().map(UnifiedPendingTaskInfo::getTaskId).collect(Collectors.toList());
                    List pendingUserList = this.unifiedTaskUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskUser::getTaskId, pendingIdList)).eq(UnifiedTaskUser::getSystemId, (Object)unifiedParamDto.getSystemId()));
                    if (CollectionUtil.isNotEmpty((Collection)pendingUserList) && (countNew = pendingUserList.stream().filter(u -> u.getUserId().equals(unifiedParamDto.getUserId())).count()) > 0L) continue;
                }
                if (CollectionUtil.isNotEmpty((Collection)(doneTaskInfoList = this.iUnifiedDoneTaskInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedDoneTaskInfo::getProcessInstanceid, (Object)unifiedParamDto.getFlowID())).ne(UnifiedDoneTaskInfo::getTaskId, (Object)unifiedParamDto.getApprovalId()))))) {
                    long countNew;
                    logger.info("doneTaskInfoList\u957f\u5ea6\uff1a" + doneTaskInfoList.size());
                    List doneIdList = doneTaskInfoList.stream().map(UnifiedDoneTaskInfo::getTaskId).collect(Collectors.toList());
                    List doneUserList = this.unifiedTaskUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(UnifiedTaskUser::getTaskId, doneIdList)).eq(UnifiedTaskUser::getSystemId, (Object)unifiedParamDto.getSystemId()));
                    if (CollectionUtil.isNotEmpty((Collection)doneUserList) && (countNew = doneUserList.stream().filter(u -> u.getUserId().equals(unifiedParamDto.getUserId())).count()) > 0L) continue;
                }
            }
            logger.info("unifiedParamDto" + JSON.toJSONString((Object)unifiedParamDto));
            SysUsers sendUser = null;
            if (HussarUtils.isEmpty((Object)unifiedParamDto.getUserId())) continue;
            SysUsers receiver = this.usersService.getUserByOutOriginId(unifiedParamDto.getUserId());
            if (HussarUtils.isNull((Object)receiver)) {
                this.HandlerLog(unifiedParamDto.getRunnerId(), unifiedParamDto.getRunnerName());
                continue;
            }
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("syscode", this.unifiedTodoProperties.getOaThirdCode());
            if (HussarUtils.isEmpty((Object)unifiedParamDto.getFlowIdName())) {
                UnifiedProcessInfo unifiedProcessInfo;
                logger.info("\u6d41\u7a0b\u5b9e\u4f8bid\uff1a" + unifiedParamDto.getFlowID());
                if (HussarUtils.isEmpty((Object)unifiedParamDto.getFlowID())) {
                    String processInstId = "";
                    switch (unifiedParamDto.getTypeid()) {
                        case "1": {
                            UnifiedTodoTaskInfo todoTaskInfo = (UnifiedTodoTaskInfo)this.iUnifiedTodoTaskInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedTodoTaskInfo::getTaskId, (Object)unifiedParamDto.getApprovalId()));
                            if (Objects.isNull(todoTaskInfo)) break;
                            processInstId = todoTaskInfo.getProcessInstanceid();
                            break;
                        }
                        case "2": {
                            UnifiedPendingTaskInfo pendingTaskInfo = (UnifiedPendingTaskInfo)this.iUnifiedPendingTaskInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedPendingTaskInfo::getTaskId, (Object)unifiedParamDto.getApprovalId()));
                            if (Objects.isNull(pendingTaskInfo)) break;
                            processInstId = pendingTaskInfo.getProcessInstanceid();
                            break;
                        }
                        case "3": {
                            UnifiedDoneTaskInfo doneTaskInfo = (UnifiedDoneTaskInfo)this.iUnifiedDoneTaskInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedDoneTaskInfo::getTaskId, (Object)unifiedParamDto.getApprovalId()));
                            if (Objects.isNull(doneTaskInfo)) break;
                            processInstId = doneTaskInfo.getProcessInstanceid();
                            break;
                        }
                        case "4": {
                            UnifiedUnReadTaskInfo unReadTaskInfo = (UnifiedUnReadTaskInfo)this.iUnifiedUnReadTaskInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedUnReadTaskInfo::getTaskId, (Object)unifiedParamDto.getApprovalId()));
                            if (Objects.isNull(unReadTaskInfo)) break;
                            processInstId = unReadTaskInfo.getProcessInstanceid();
                            break;
                        }
                        case "5": {
                            UnifiedReadedTaskInfo readTaskInfo = (UnifiedReadedTaskInfo)this.iUnifiedReadedTaskInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedReadedTaskInfo::getTaskId, (Object)unifiedParamDto.getApprovalId()));
                            if (Objects.isNull(readTaskInfo)) break;
                            processInstId = readTaskInfo.getProcessInstanceid();
                            break;
                        }
                    }
                    unifiedProcessInfo = (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)processInstId));
                    logger.info("\u6d41\u7a0b\u5b9e\u4f8bid\uff1a" + processInstId);
                    data.put("flowid", processInstId);
                } else {
                    data.put("flowid", unifiedParamDto.getFlowID());
                    unifiedProcessInfo = (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)unifiedParamDto.getFlowID()));
                }
                if (!HussarUtils.isNull((Object)unifiedProcessInfo)) {
                    sendUser = this.usersService.getUserByOutOriginId(unifiedProcessInfo.getStartUserId());
                    data.put("requestname", unifiedProcessInfo.getProcessName());
                    data.put("workflowname", unifiedProcessInfo.getProcessName());
                    unifiedParamDto.setFlag4(unifiedProcessInfo.getProcessState());
                }
                if (!"0".equals(unifiedProcessInfo.getProcessState()) && "1".equals(unifiedParamDto.getTypeid())) {
                    unifiedParamDto.setTypeid("3");
                }
            } else {
                data.put("flowid", unifiedParamDto.getFlowID());
                data.put("requestname", unifiedParamDto.getFlowIdName());
                data.put("workflowname", unifiedParamDto.getFlowIdName());
            }
            logger.info("workflowname:" + unifiedParamDto.getFlowIdName());
            data.put("nodename", unifiedParamDto.getKey2());
            data.put("appurl", unifiedParamDto.getParam10());
            String flowState = this.getFlowState(unifiedParamDto, data, systemId);
            if (HussarUtils.isNull((Object)flowState)) continue;
            data.put("isremark", flowState);
            data.put("viewtype", this.getReadState(unifiedParamDto.getTypeid()));
            if (HussarUtils.isNull((Object)sendUser)) continue;
            data.put("creator", sendUser.getUserAccount());
            data.put("createdatetime", HussarUtils.isEmpty((Object)unifiedParamDto.getCreateTime()) ? sf.format(new Date()) : sf.format(Long.valueOf(unifiedParamDto.getCreateTime())));
            data.put("receiver", receiver.getUserAccount());
            data.put("receivedatetime", HussarUtils.isEmpty((Object)unifiedParamDto.getTime1()) ? sf.format(new Date()) : sf.format(Long.valueOf(unifiedParamDto.getTime1())));
            data.put("receivets", String.valueOf(System.currentTimeMillis()));
            try {
                logger.info("requestParam:" + unifiedParamDto.getFlowIdName());
                String resultData = JSON.toJSONString(data);
                logger.info("requestParamJson:" + resultData);
                String resp = HttpClientUtil.httpPost(this.unifiedTodoProperties.getReceiveDataUrl(), resultData, null);
                logger.info("responseParam:" + resp);
                JSONObject jsonObject = JSON.parseObject((String)resp);
                if (!jsonObject.get((Object)"operResult").equals("0")) continue;
                this.HandlerLog(unifiedParamDto.getRunnerId(), unifiedParamDto.getRunnerName());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.HandlerLog(unifiedParamDto.getRunnerId(), unifiedParamDto.getRunnerName());
            }
        }
    }

    private void HandlerLog(String userId, String userName) {
        UserDetails userDetails = new UserDetails();
        AuditLogModel auditLogModel = new AuditLogModel();
        auditLogModel.setModuleName(MODULE_NAME);
        auditLogModel.setEventGrade(AuditEventGrade.SERVICE_LOG_TYPE);
        auditLogModel.setEventType(AuditEventType.EXCEPTION);
        auditLogModel.setEventDesc("\u7528\u6237\u8bbf\u95eeOA-\u6570\u636e\u63a8\u9001");
        userDetails.setUserIdStr(userId);
        userDetails.setUserName(userName);
        auditLogModel.setUserDetails(userDetails);
        AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
    }

    private String getReadState(String readState) {
        if ("4".equals(readState)) {
            return "0";
        }
        if ("5".equals(readState)) {
            return "1";
        }
        return "0";
    }

    private String getFlowState(UnifiedParamDto dto, Map<String, String> data, String systemId) {
        if ("1".equals(dto.getTypeid())) {
            data.put("pcurl", this.unifiedTodoProperties.getToBe() + "%2526taskId=" + dto.getApprovalId());
            logger.info("pcurl:" + data.get("pcurl"));
            return "0";
        }
        if ("3".equals(dto.getTypeid()) && ProcessState.RUNNING.getValue().equals(dto.getFlag4()) || "5".equals(dto.getTypeid())) {
            data.put("pcurl", this.unifiedTodoProperties.getToDo() + "?runflowid=" + dto.getFlowID());
            logger.info("pcurl:" + data.get("pcurl"));
            return "2";
        }
        if ("3".equals(dto.getTypeid())) {
            data.put("pcurl", this.unifiedTodoProperties.getToDo() + "?runflowid=" + dto.getFlowID());
            return "4";
        }
        if ("4".equals(dto.getTypeid())) {
            data.put("pcurl", this.unifiedTodoProperties.getToUnRead() + "%2526taskId=" + dto.getApprovalId());
            logger.info("pcurl:" + data.get("pcurl"));
            return "8";
        }
        return null;
    }

    private void addUnified(List<UnifiedParamDto> unifiedParamDtoList) {
        if (unifiedParamDtoList.isEmpty()) {
            return;
        }
        ArrayList<UnifiedProcessInfo> unifiedProcessInfos = new ArrayList<UnifiedProcessInfo>();
        ArrayList<UnifiedTaskInfo> unifiedTaskInfos = new ArrayList<UnifiedTaskInfo>();
        ArrayList<UnifiedTaskUser> unifiedTaskUsers = new ArrayList<UnifiedTaskUser>();
        ArrayList<UnifiedProcessRectificationInfo> unifiedProcessRectificationInfos = new ArrayList<UnifiedProcessRectificationInfo>();
        for (UnifiedParamDto unifiedParamDto : unifiedParamDtoList) {
            logger.info("\u6dfb\u52a0\u7684\u63a8\u9001\u6570\u636e\uff1a" + JSON.toJSONString((Object)unifiedParamDto));
            UnifiedProcessInfo unifiedProcessInfo = unifiedParamDto.buildProcessInfo();
            UnifiedTaskInfo unifiedTaskInfo = unifiedParamDto.buildTaskInfo();
            UnifiedTaskUser unifiedTaskUser = unifiedParamDto.buildUserInfo();
            if (unifiedProcessInfo != null) {
                UnifiedProcessRectificationInfo unifiedProcessRectificationInfo;
                if (("3".equals(unifiedProcessInfo.getProcessState()) || "9".equals(unifiedProcessInfo.getProcessState())) && (unifiedProcessRectificationInfo = unifiedParamDto.buildProcessRectificationInfo()) != null) {
                    unifiedProcessRectificationInfos.add(unifiedProcessRectificationInfo);
                }
                unifiedProcessInfos.add(unifiedProcessInfo.setDeleteFlag("0"));
            }
            if (unifiedTaskInfo != null) {
                unifiedTaskInfos.add(unifiedTaskInfo);
            }
            if (unifiedTaskUser == null) continue;
            unifiedTaskUsers.add(unifiedTaskUser);
        }
        if (!unifiedProcessInfos.isEmpty()) {
            this.unifiedProcessInfoService.saveBatch(unifiedProcessInfos);
            this.updateTaskInfo(unifiedProcessInfos);
        }
        if (!unifiedTaskInfos.isEmpty()) {
            this.unifiedTaskInfoService.saveBatch(unifiedTaskInfos);
            this.saveBatchTaskInfos(unifiedTaskInfos, unifiedTaskUsers);
        }
        if (!unifiedTaskUsers.isEmpty()) {
            this.unifiedTaskUserService.saveBatch(unifiedTaskUsers);
        }
        if (!unifiedProcessRectificationInfos.isEmpty()) {
            this.unifiedProcessRectificationService.saveBatch(unifiedProcessRectificationInfos);
        }
    }

    private void saveBatchTaskInfos(List<UnifiedTaskInfo> unifiedTaskInfos, List<UnifiedTaskUser> unifiedTaskUsers) {
        ArrayList<UnifiedTodoTaskInfo> unifiedTodoTaskInfos = new ArrayList<UnifiedTodoTaskInfo>();
        ArrayList<UnifiedPendingTaskInfo> unifiedPendingTaskInfos = new ArrayList<UnifiedPendingTaskInfo>();
        ArrayList<UnifiedDoneTaskInfo> unifiedDoneTaskInfos = new ArrayList<UnifiedDoneTaskInfo>();
        ArrayList<UnifiedUnReadTaskInfo> unifiedUnReadTaskInfos = new ArrayList<UnifiedUnReadTaskInfo>();
        ArrayList<UnifiedReadedTaskInfo> unifiedReadedTaskInfos = new ArrayList<UnifiedReadedTaskInfo>();
        block14: for (UnifiedTaskInfo unifiedTaskInfo : unifiedTaskInfos) {
            block7 : switch (unifiedTaskInfo.getTaskStatus()) {
                case "1": {
                    UnifiedProcessInfo unifiedProcessInfo;
                    for (UnifiedTaskUser unifiedTaskUser : unifiedTaskUsers) {
                        if (!unifiedTaskUser.getTaskId().equals(unifiedTaskInfo.getTaskId())) continue;
                        unifiedProcessInfo = (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)unifiedTaskInfo.getProcessInstanceid()));
                        UnifiedTodoTaskInfo unifiedTodoTaskInfo = new UnifiedTodoTaskInfo().buildUnifiedTodoTaskInfo(unifiedProcessInfo, unifiedTaskInfo, unifiedTaskUser);
                        unifiedTodoTaskInfos.add(unifiedTodoTaskInfo);
                        break block7;
                    }
                    continue block14;
                }
                case "2": {
                    UnifiedProcessInfo unifiedProcessInfo;
                    for (UnifiedTaskUser unifiedTaskUser : unifiedTaskUsers) {
                        if (!unifiedTaskUser.getTaskId().equals(unifiedTaskInfo.getTaskId())) continue;
                        unifiedProcessInfo = (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)unifiedTaskInfo.getProcessInstanceid()));
                        UnifiedPendingTaskInfo unifiedPendingTaskInfo = new UnifiedPendingTaskInfo().buildUnifiedPendingTaskInfo(unifiedProcessInfo, unifiedTaskInfo, unifiedTaskUser);
                        unifiedPendingTaskInfos.add(unifiedPendingTaskInfo);
                        break block7;
                    }
                    continue block14;
                }
                case "3": {
                    UnifiedProcessInfo unifiedProcessInfo;
                    for (UnifiedTaskUser unifiedTaskUser : unifiedTaskUsers) {
                        if (!unifiedTaskUser.getTaskId().equals(unifiedTaskInfo.getTaskId())) continue;
                        unifiedProcessInfo = (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)unifiedTaskInfo.getProcessInstanceid()));
                        UnifiedDoneTaskInfo unifiedDoneTaskInfo = new UnifiedDoneTaskInfo().buildUnifiedDoneTaskInfo(unifiedProcessInfo, unifiedTaskInfo, unifiedTaskUser);
                        unifiedDoneTaskInfos.add(unifiedDoneTaskInfo);
                        break block7;
                    }
                    continue block14;
                }
                case "4": {
                    UnifiedProcessInfo unifiedProcessInfo;
                    for (UnifiedTaskUser unifiedTaskUser : unifiedTaskUsers) {
                        if (!unifiedTaskUser.getTaskId().equals(unifiedTaskInfo.getTaskId())) continue;
                        unifiedProcessInfo = (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)unifiedTaskInfo.getProcessInstanceid()));
                        UnifiedUnReadTaskInfo unifiedUnReadTaskInfo = new UnifiedUnReadTaskInfo().buildUnifiedUnReadTaskInfo(unifiedProcessInfo, unifiedTaskInfo, unifiedTaskUser);
                        unifiedUnReadTaskInfos.add(unifiedUnReadTaskInfo);
                        break block7;
                    }
                    continue block14;
                }
                case "5": {
                    UnifiedProcessInfo unifiedProcessInfo;
                    for (UnifiedTaskUser unifiedTaskUser : unifiedTaskUsers) {
                        if (!unifiedTaskUser.getTaskId().equals(unifiedTaskInfo.getTaskId())) continue;
                        unifiedProcessInfo = (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)unifiedTaskInfo.getProcessInstanceid()));
                        UnifiedReadedTaskInfo unifiedReadedTaskInfo = new UnifiedReadedTaskInfo().buildUnifiedReadedTaskInfo(unifiedProcessInfo, unifiedTaskInfo, unifiedTaskUser);
                        unifiedReadedTaskInfos.add(unifiedReadedTaskInfo);
                        break block7;
                    }
                    break;
                }
            }
        }
        if (!unifiedTodoTaskInfos.isEmpty()) {
            this.unifiedTodoTaskInfoService.saveBatch(unifiedTodoTaskInfos);
        }
        if (!unifiedPendingTaskInfos.isEmpty()) {
            this.unifiedPendingTaskInfoService.saveBatch(unifiedPendingTaskInfos);
        }
        if (!unifiedDoneTaskInfos.isEmpty()) {
            this.unifiedDoneTaskInfoService.saveBatch(unifiedDoneTaskInfos);
        }
        if (!unifiedReadedTaskInfos.isEmpty()) {
            logger.info("\u6dfb\u52a0\u5df2\u8bfb\u6570\u636e");
            this.unifiedReadedTaskInfoService.saveBatch(unifiedReadedTaskInfos);
        }
        if (!unifiedUnReadTaskInfos.isEmpty()) {
            this.unifiedUnReadTaskInfoService.saveBatch(unifiedUnReadTaskInfos);
        }
    }

    private void updateTaskInfo(List<UnifiedProcessInfo> unifiedProcessInfos) {
        for (UnifiedProcessInfo unifiedProcessInfo : unifiedProcessInfos) {
            int i;
            List unifiedTodoTaskInfos = this.unifiedTodoTaskInfoService.list((Wrapper)new LambdaQueryWrapper().eq(UnifiedTodoTaskInfo::getProcessInstanceid, (Object)unifiedProcessInfo.getProcInstId()));
            List unifiedPendingTaskInfos = this.unifiedPendingTaskInfoService.list((Wrapper)new LambdaQueryWrapper().eq(UnifiedPendingTaskInfo::getProcessInstanceid, (Object)unifiedProcessInfo.getProcInstId()));
            List unifiedDoneTaskInfos = this.unifiedDoneTaskInfoService.list((Wrapper)new LambdaQueryWrapper().eq(UnifiedDoneTaskInfo::getProcessInstanceid, (Object)unifiedProcessInfo.getProcInstId()));
            List unifiedUnReadTaskInfos = this.unifiedUnReadTaskInfoService.list((Wrapper)new LambdaQueryWrapper().eq(UnifiedUnReadTaskInfo::getProcessInstanceid, (Object)unifiedProcessInfo.getProcInstId()));
            List unifiedReadedTaskInfos = this.unifiedReadedTaskInfoService.list((Wrapper)new LambdaQueryWrapper().eq(UnifiedReadedTaskInfo::getProcessInstanceid, (Object)unifiedProcessInfo.getProcInstId()));
            if (unifiedTodoTaskInfos != null && !unifiedDoneTaskInfos.isEmpty()) {
                for (i = 0; i < unifiedTodoTaskInfos.size(); ++i) {
                    ((UnifiedTodoTaskInfo)unifiedTodoTaskInfos.get(i)).setProcessName(unifiedProcessInfo.getProcessName());
                    ((UnifiedTodoTaskInfo)unifiedTodoTaskInfos.get(i)).setBusinessId(unifiedProcessInfo.getBusinessId());
                    ((UnifiedTodoTaskInfo)unifiedTodoTaskInfos.get(i)).setProcDefId(unifiedProcessInfo.getProcDefId());
                    ((UnifiedTodoTaskInfo)unifiedTodoTaskInfos.get(i)).setStartUserId(unifiedProcessInfo.getStartUserId());
                    ((UnifiedTodoTaskInfo)unifiedTodoTaskInfos.get(i)).setStartUserName(unifiedProcessInfo.getStartUserName());
                    ((UnifiedTodoTaskInfo)unifiedTodoTaskInfos.get(i)).setStartUserNumber(unifiedProcessInfo.getStartUserNumber());
                    ((UnifiedTodoTaskInfo)unifiedTodoTaskInfos.get(i)).setStartTime(unifiedProcessInfo.getStartTime());
                    ((UnifiedTodoTaskInfo)unifiedTodoTaskInfos.get(i)).setEndTime(unifiedProcessInfo.getEndTime());
                    ((UnifiedTodoTaskInfo)unifiedTodoTaskInfos.get(i)).setProcessState(unifiedProcessInfo.getProcessState());
                    ((UnifiedTodoTaskInfo)unifiedTodoTaskInfos.get(i)).setProcessDeptId(unifiedProcessInfo.getDeptId());
                    ((UnifiedTodoTaskInfo)unifiedTodoTaskInfos.get(i)).setProcessUnitId(unifiedProcessInfo.getUnitId());
                    ((UnifiedTodoTaskInfo)unifiedTodoTaskInfos.get(i)).setProcessDeptName(unifiedProcessInfo.getDeptName());
                    ((UnifiedTodoTaskInfo)unifiedTodoTaskInfos.get(i)).setProcessUnitName(unifiedProcessInfo.getUnitName());
                    ((UnifiedTodoTaskInfo)unifiedTodoTaskInfos.get(i)).setProcessDeleteFlag(unifiedProcessInfo.getDeleteFlag());
                    ((UnifiedTodoTaskInfo)unifiedTodoTaskInfos.get(i)).setBusinessModelId(unifiedProcessInfo.getBusinessModelId());
                    ((UnifiedTodoTaskInfo)unifiedTodoTaskInfos.get(i)).setBusinessModelName(unifiedProcessInfo.getBusinessModelName());
                    ((UnifiedTodoTaskInfo)unifiedTodoTaskInfos.get(i)).setProcessWebLinkUrl(unifiedProcessInfo.getWebLinkurl());
                    ((UnifiedTodoTaskInfo)unifiedTodoTaskInfos.get(i)).setProcessMobileLinkUrl(unifiedProcessInfo.getMobileLinkurl());
                    ((UnifiedTodoTaskInfo)unifiedTodoTaskInfos.get(i)).setFormId(unifiedProcessInfo.getFormId());
                    ((UnifiedTodoTaskInfo)unifiedTodoTaskInfos.get(i)).setRunName(unifiedProcessInfo.getRunName());
                    ((UnifiedTodoTaskInfo)unifiedTodoTaskInfos.get(i)).setVerSys(unifiedProcessInfo.getVerSys());
                    ((UnifiedTodoTaskInfo)unifiedTodoTaskInfos.get(i)).setTenantCode(unifiedProcessInfo.getTenantCode());
                }
                this.unifiedTodoTaskInfoService.saveOrUpdateBatch((Collection)unifiedTodoTaskInfos);
            }
            if (unifiedPendingTaskInfos != null && !unifiedPendingTaskInfos.isEmpty()) {
                for (i = 0; i < unifiedPendingTaskInfos.size(); ++i) {
                    ((UnifiedPendingTaskInfo)unifiedPendingTaskInfos.get(i)).setProcessName(unifiedProcessInfo.getProcessName());
                    ((UnifiedPendingTaskInfo)unifiedPendingTaskInfos.get(i)).setBusinessId(unifiedProcessInfo.getBusinessId());
                    ((UnifiedPendingTaskInfo)unifiedPendingTaskInfos.get(i)).setProcDefId(unifiedProcessInfo.getProcDefId());
                    ((UnifiedPendingTaskInfo)unifiedPendingTaskInfos.get(i)).setStartUserId(unifiedProcessInfo.getStartUserId());
                    ((UnifiedPendingTaskInfo)unifiedPendingTaskInfos.get(i)).setStartUserName(unifiedProcessInfo.getStartUserName());
                    ((UnifiedPendingTaskInfo)unifiedPendingTaskInfos.get(i)).setStartUserNumber(unifiedProcessInfo.getStartUserNumber());
                    ((UnifiedPendingTaskInfo)unifiedPendingTaskInfos.get(i)).setStartTime(unifiedProcessInfo.getStartTime());
                    ((UnifiedPendingTaskInfo)unifiedPendingTaskInfos.get(i)).setEndTime(unifiedProcessInfo.getEndTime());
                    ((UnifiedPendingTaskInfo)unifiedPendingTaskInfos.get(i)).setProcessState(unifiedProcessInfo.getProcessState());
                    ((UnifiedPendingTaskInfo)unifiedPendingTaskInfos.get(i)).setProcessDeptId(unifiedProcessInfo.getDeptId());
                    ((UnifiedPendingTaskInfo)unifiedPendingTaskInfos.get(i)).setProcessUnitId(unifiedProcessInfo.getUnitId());
                    ((UnifiedPendingTaskInfo)unifiedPendingTaskInfos.get(i)).setProcessDeptName(unifiedProcessInfo.getDeptName());
                    ((UnifiedPendingTaskInfo)unifiedPendingTaskInfos.get(i)).setProcessUnitName(unifiedProcessInfo.getUnitName());
                    ((UnifiedPendingTaskInfo)unifiedPendingTaskInfos.get(i)).setProcessDeleteFlag(unifiedProcessInfo.getDeleteFlag());
                    ((UnifiedPendingTaskInfo)unifiedPendingTaskInfos.get(i)).setBusinessModelId(unifiedProcessInfo.getBusinessModelId());
                    ((UnifiedPendingTaskInfo)unifiedPendingTaskInfos.get(i)).setBusinessModelName(unifiedProcessInfo.getBusinessModelName());
                    ((UnifiedPendingTaskInfo)unifiedPendingTaskInfos.get(i)).setProcessWebLinkUrl(unifiedProcessInfo.getWebLinkurl());
                    ((UnifiedPendingTaskInfo)unifiedPendingTaskInfos.get(i)).setProcessMobileLinkUrl(unifiedProcessInfo.getMobileLinkurl());
                    ((UnifiedPendingTaskInfo)unifiedPendingTaskInfos.get(i)).setFormId(unifiedProcessInfo.getFormId());
                    ((UnifiedPendingTaskInfo)unifiedPendingTaskInfos.get(i)).setRunName(unifiedProcessInfo.getRunName());
                    ((UnifiedPendingTaskInfo)unifiedPendingTaskInfos.get(i)).setVerSys(unifiedProcessInfo.getVerSys());
                    ((UnifiedPendingTaskInfo)unifiedPendingTaskInfos.get(i)).setTenantCode(unifiedProcessInfo.getTenantCode());
                }
                this.unifiedPendingTaskInfoService.saveOrUpdateBatch((Collection)unifiedPendingTaskInfos);
            }
            if (unifiedDoneTaskInfos != null && !unifiedDoneTaskInfos.isEmpty()) {
                for (i = 0; i < unifiedDoneTaskInfos.size(); ++i) {
                    ((UnifiedDoneTaskInfo)unifiedDoneTaskInfos.get(i)).setProcessName(unifiedProcessInfo.getProcessName());
                    ((UnifiedDoneTaskInfo)unifiedDoneTaskInfos.get(i)).setBusinessId(unifiedProcessInfo.getBusinessId());
                    ((UnifiedDoneTaskInfo)unifiedDoneTaskInfos.get(i)).setProcDefId(unifiedProcessInfo.getProcDefId());
                    ((UnifiedDoneTaskInfo)unifiedDoneTaskInfos.get(i)).setStartUserId(unifiedProcessInfo.getStartUserId());
                    ((UnifiedDoneTaskInfo)unifiedDoneTaskInfos.get(i)).setStartUserName(unifiedProcessInfo.getStartUserName());
                    ((UnifiedDoneTaskInfo)unifiedDoneTaskInfos.get(i)).setStartUserNumber(unifiedProcessInfo.getStartUserNumber());
                    ((UnifiedDoneTaskInfo)unifiedDoneTaskInfos.get(i)).setStartTime(unifiedProcessInfo.getStartTime());
                    ((UnifiedDoneTaskInfo)unifiedDoneTaskInfos.get(i)).setEndTime(unifiedProcessInfo.getEndTime());
                    ((UnifiedDoneTaskInfo)unifiedDoneTaskInfos.get(i)).setProcessState(unifiedProcessInfo.getProcessState());
                    ((UnifiedDoneTaskInfo)unifiedDoneTaskInfos.get(i)).setProcessDeptId(unifiedProcessInfo.getDeptId());
                    ((UnifiedDoneTaskInfo)unifiedDoneTaskInfos.get(i)).setProcessUnitId(unifiedProcessInfo.getUnitId());
                    ((UnifiedDoneTaskInfo)unifiedDoneTaskInfos.get(i)).setProcessDeptName(unifiedProcessInfo.getDeptName());
                    ((UnifiedDoneTaskInfo)unifiedDoneTaskInfos.get(i)).setProcessUnitName(unifiedProcessInfo.getUnitName());
                    ((UnifiedDoneTaskInfo)unifiedDoneTaskInfos.get(i)).setProcessDeleteFlag(unifiedProcessInfo.getDeleteFlag());
                    ((UnifiedDoneTaskInfo)unifiedDoneTaskInfos.get(i)).setBusinessModelId(unifiedProcessInfo.getBusinessModelId());
                    ((UnifiedDoneTaskInfo)unifiedDoneTaskInfos.get(i)).setBusinessModelName(unifiedProcessInfo.getBusinessModelName());
                    ((UnifiedDoneTaskInfo)unifiedDoneTaskInfos.get(i)).setProcessWebLinkUrl(unifiedProcessInfo.getWebLinkurl());
                    ((UnifiedDoneTaskInfo)unifiedDoneTaskInfos.get(i)).setProcessMobileLinkUrl(unifiedProcessInfo.getMobileLinkurl());
                    ((UnifiedDoneTaskInfo)unifiedDoneTaskInfos.get(i)).setFormId(unifiedProcessInfo.getFormId());
                    ((UnifiedDoneTaskInfo)unifiedDoneTaskInfos.get(i)).setRunName(unifiedProcessInfo.getRunName());
                    ((UnifiedDoneTaskInfo)unifiedDoneTaskInfos.get(i)).setVerSys(unifiedProcessInfo.getVerSys());
                    ((UnifiedDoneTaskInfo)unifiedDoneTaskInfos.get(i)).setTenantCode(unifiedProcessInfo.getTenantCode());
                }
                this.unifiedDoneTaskInfoService.saveOrUpdateBatch((Collection)unifiedDoneTaskInfos);
            }
            if (unifiedUnReadTaskInfos != null && !unifiedUnReadTaskInfos.isEmpty()) {
                for (i = 0; i < unifiedUnReadTaskInfos.size(); ++i) {
                    ((UnifiedUnReadTaskInfo)unifiedUnReadTaskInfos.get(i)).setProcessName(unifiedProcessInfo.getProcessName());
                    ((UnifiedUnReadTaskInfo)unifiedUnReadTaskInfos.get(i)).setBusinessId(unifiedProcessInfo.getBusinessId());
                    ((UnifiedUnReadTaskInfo)unifiedUnReadTaskInfos.get(i)).setProcDefId(unifiedProcessInfo.getProcDefId());
                    ((UnifiedUnReadTaskInfo)unifiedUnReadTaskInfos.get(i)).setStartUserId(unifiedProcessInfo.getStartUserId());
                    ((UnifiedUnReadTaskInfo)unifiedUnReadTaskInfos.get(i)).setStartUserName(unifiedProcessInfo.getStartUserName());
                    ((UnifiedUnReadTaskInfo)unifiedUnReadTaskInfos.get(i)).setStartUserNumber(unifiedProcessInfo.getStartUserNumber());
                    ((UnifiedUnReadTaskInfo)unifiedUnReadTaskInfos.get(i)).setStartTime(unifiedProcessInfo.getStartTime());
                    ((UnifiedUnReadTaskInfo)unifiedUnReadTaskInfos.get(i)).setEndTime(unifiedProcessInfo.getEndTime());
                    ((UnifiedUnReadTaskInfo)unifiedUnReadTaskInfos.get(i)).setProcessState(unifiedProcessInfo.getProcessState());
                    ((UnifiedUnReadTaskInfo)unifiedUnReadTaskInfos.get(i)).setProcessDeptId(unifiedProcessInfo.getDeptId());
                    ((UnifiedUnReadTaskInfo)unifiedUnReadTaskInfos.get(i)).setProcessUnitId(unifiedProcessInfo.getUnitId());
                    ((UnifiedUnReadTaskInfo)unifiedUnReadTaskInfos.get(i)).setProcessDeptName(unifiedProcessInfo.getDeptName());
                    ((UnifiedUnReadTaskInfo)unifiedUnReadTaskInfos.get(i)).setProcessUnitName(unifiedProcessInfo.getUnitName());
                    ((UnifiedUnReadTaskInfo)unifiedUnReadTaskInfos.get(i)).setProcessDeleteFlag(unifiedProcessInfo.getDeleteFlag());
                    ((UnifiedUnReadTaskInfo)unifiedUnReadTaskInfos.get(i)).setBusinessModelId(unifiedProcessInfo.getBusinessModelId());
                    ((UnifiedUnReadTaskInfo)unifiedUnReadTaskInfos.get(i)).setBusinessModelName(unifiedProcessInfo.getBusinessModelName());
                    ((UnifiedUnReadTaskInfo)unifiedUnReadTaskInfos.get(i)).setProcessWebLinkUrl(unifiedProcessInfo.getWebLinkurl());
                    ((UnifiedUnReadTaskInfo)unifiedUnReadTaskInfos.get(i)).setProcessMobileLinkUrl(unifiedProcessInfo.getMobileLinkurl());
                    ((UnifiedUnReadTaskInfo)unifiedUnReadTaskInfos.get(i)).setFormId(unifiedProcessInfo.getFormId());
                    ((UnifiedUnReadTaskInfo)unifiedUnReadTaskInfos.get(i)).setRunName(unifiedProcessInfo.getRunName());
                    ((UnifiedUnReadTaskInfo)unifiedUnReadTaskInfos.get(i)).setVerSys(unifiedProcessInfo.getVerSys());
                    ((UnifiedUnReadTaskInfo)unifiedUnReadTaskInfos.get(i)).setTenantCode(unifiedProcessInfo.getTenantCode());
                }
                this.unifiedUnReadTaskInfoService.saveOrUpdateBatch((Collection)unifiedUnReadTaskInfos);
            }
            if (unifiedReadedTaskInfos != null && !unifiedReadedTaskInfos.isEmpty()) {
                for (i = 0; i < unifiedReadedTaskInfos.size(); ++i) {
                    ((UnifiedReadedTaskInfo)unifiedReadedTaskInfos.get(i)).setProcessName(unifiedProcessInfo.getProcessName());
                    ((UnifiedReadedTaskInfo)unifiedReadedTaskInfos.get(i)).setBusinessId(unifiedProcessInfo.getBusinessId());
                    ((UnifiedReadedTaskInfo)unifiedReadedTaskInfos.get(i)).setProcDefId(unifiedProcessInfo.getProcDefId());
                    ((UnifiedReadedTaskInfo)unifiedReadedTaskInfos.get(i)).setStartUserId(unifiedProcessInfo.getStartUserId());
                    ((UnifiedReadedTaskInfo)unifiedReadedTaskInfos.get(i)).setStartUserName(unifiedProcessInfo.getStartUserName());
                    ((UnifiedReadedTaskInfo)unifiedReadedTaskInfos.get(i)).setStartUserNumber(unifiedProcessInfo.getStartUserNumber());
                    ((UnifiedReadedTaskInfo)unifiedReadedTaskInfos.get(i)).setStartTime(unifiedProcessInfo.getStartTime());
                    ((UnifiedReadedTaskInfo)unifiedReadedTaskInfos.get(i)).setEndTime(unifiedProcessInfo.getEndTime());
                    ((UnifiedReadedTaskInfo)unifiedReadedTaskInfos.get(i)).setProcessState(unifiedProcessInfo.getProcessState());
                    ((UnifiedReadedTaskInfo)unifiedReadedTaskInfos.get(i)).setProcessDeptId(unifiedProcessInfo.getDeptId());
                    ((UnifiedReadedTaskInfo)unifiedReadedTaskInfos.get(i)).setProcessUnitId(unifiedProcessInfo.getUnitId());
                    ((UnifiedReadedTaskInfo)unifiedReadedTaskInfos.get(i)).setProcessDeptName(unifiedProcessInfo.getDeptName());
                    ((UnifiedReadedTaskInfo)unifiedReadedTaskInfos.get(i)).setProcessUnitName(unifiedProcessInfo.getUnitName());
                    ((UnifiedReadedTaskInfo)unifiedReadedTaskInfos.get(i)).setProcessDeleteFlag(unifiedProcessInfo.getDeleteFlag());
                    ((UnifiedReadedTaskInfo)unifiedReadedTaskInfos.get(i)).setBusinessModelId(unifiedProcessInfo.getBusinessModelId());
                    ((UnifiedReadedTaskInfo)unifiedReadedTaskInfos.get(i)).setBusinessModelName(unifiedProcessInfo.getBusinessModelName());
                    ((UnifiedReadedTaskInfo)unifiedReadedTaskInfos.get(i)).setProcessWebLinkUrl(unifiedProcessInfo.getWebLinkurl());
                    ((UnifiedReadedTaskInfo)unifiedReadedTaskInfos.get(i)).setProcessMobileLinkUrl(unifiedProcessInfo.getMobileLinkurl());
                    ((UnifiedReadedTaskInfo)unifiedReadedTaskInfos.get(i)).setFormId(unifiedProcessInfo.getFormId());
                    ((UnifiedReadedTaskInfo)unifiedReadedTaskInfos.get(i)).setRunName(unifiedProcessInfo.getRunName());
                    ((UnifiedReadedTaskInfo)unifiedReadedTaskInfos.get(i)).setVerSys(unifiedProcessInfo.getVerSys());
                    ((UnifiedReadedTaskInfo)unifiedReadedTaskInfos.get(i)).setTenantCode(unifiedProcessInfo.getTenantCode());
                }
                this.unifiedReadedTaskInfoService.saveOrUpdateBatch((Collection)unifiedReadedTaskInfos);
            }
            if (unifiedProcessInfo.getProcessState().equals("3")) {
                UnifiedProcessRectificationInfo unifiedProcessRectificationInfo = new UnifiedProcessRectificationInfo().buildUnifiedProcessRectificationInfo(unifiedProcessInfo);
                this.unifiedProcessRectificationService.saveOrUpdate((Object)unifiedProcessRectificationInfo);
                continue;
            }
            if (!unifiedProcessInfo.getProcessState().equals("9")) continue;
            this.unifiedProcessRectificationService.update(null, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UnifiedProcessRectificationInfo::getProcInstId, (Object)unifiedProcessInfo.getProcInstId())).set(UnifiedProcessRectificationInfo::getProcessState, (Object)unifiedProcessInfo.getProcessState()));
        }
    }

    private void updateUnified(List<UnifiedParamDto> unifiedParamDtoList) {
        if (unifiedParamDtoList.isEmpty()) {
            return;
        }
        long start = System.currentTimeMillis();
        logger.info("\u66f4\u65b0\u63a8\u9001\u6570\u636e\u5f00\u59cb\uff1a" + start);
        logger.info("\u66f4\u65b0\u6570\u636e\u957f\u5ea6\uff1a" + unifiedParamDtoList.size());
        unifiedParamDtoList.forEach(this.update);
        long end = System.currentTimeMillis();
        logger.info("\u66f4\u65b0\u63a8\u9001\u6570\u636e\u7ed3\u675f\uff1a" + end);
        logger.info("\u66f4\u65b0\u6570\u636e\u4f7f\u7528\u7684\u65f6\u95f4\u662f\uff1a" + (end - start));
    }

    private void updateTaskUsers(UnifiedTaskUser unifiedTaskUser) {
        UnifiedTaskInfo unifiedTaskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)unifiedTaskUser.getTaskId()));
        if (!HussarUtils.isNull((Object)unifiedTaskInfo)) {
            UnifiedProcessInfo unifiedProcessInfo;
            if ("2".equals(unifiedTaskInfo.getTaskStatus())) {
                unifiedProcessInfo = (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)unifiedTaskInfo.getProcessInstanceid())).eq(UnifiedProcessInfo::getSystemId, (Object)unifiedTaskInfo.getSystemId()));
                UnifiedPendingTaskInfo unifiedPendingTaskInfo = new UnifiedPendingTaskInfo().buildUnifiedPendingTaskInfo(unifiedProcessInfo, unifiedTaskInfo, unifiedTaskUser);
                ((LambdaUpdateChainWrapper)this.iUnifiedPendingTaskInfoService.lambdaUpdate().eq(UnifiedPendingTaskInfo::getTaskId, (Object)unifiedTaskInfo.getTaskId())).update((Object)unifiedPendingTaskInfo);
            }
            if ("1".equals(unifiedTaskInfo.getTaskStatus())) {
                unifiedProcessInfo = (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)unifiedTaskInfo.getProcessInstanceid())).eq(UnifiedProcessInfo::getSystemId, (Object)unifiedTaskInfo.getSystemId()));
                UnifiedTodoTaskInfo unifiedTodoTaskInfo = new UnifiedTodoTaskInfo().buildUnifiedTodoTaskInfo(unifiedProcessInfo, unifiedTaskInfo, unifiedTaskUser);
                ((LambdaUpdateChainWrapper)this.iUnifiedTodoTaskInfoService.lambdaUpdate().eq(UnifiedTodoTaskInfo::getTaskId, (Object)unifiedTaskInfo.getTaskId())).update((Object)unifiedTodoTaskInfo);
            }
        }
    }

    private void updateTaskStatus(UnifiedTaskInfo unifiedTaskInfo, UnifiedTaskUser unifiedTaskUser) {
        ArrayList<UnifiedTaskInfo> unifiedTaskInfos = new ArrayList<UnifiedTaskInfo>();
        ArrayList<UnifiedTaskUser> unifiedTaskUsers = new ArrayList<UnifiedTaskUser>();
        switch (unifiedTaskInfo.getTaskStatus()) {
            case "1": {
                this.unifiedPendingTaskInfoService.remove((Wrapper)new LambdaQueryWrapper().eq(UnifiedPendingTaskInfo::getTaskId, (Object)unifiedTaskInfo.getTaskId()));
                this.unifiedTodoTaskInfoService.remove((Wrapper)new LambdaQueryWrapper().eq(UnifiedTodoTaskInfo::getTaskId, (Object)unifiedTaskInfo.getTaskId()));
                break;
            }
            case "2": {
                return;
            }
            case "4": {
                return;
            }
            case "3": {
                this.unifiedTodoTaskInfoService.remove((Wrapper)new LambdaQueryWrapper().eq(UnifiedTodoTaskInfo::getTaskId, (Object)unifiedTaskInfo.getTaskId()));
                this.unifiedDoneTaskInfoService.remove((Wrapper)new LambdaQueryWrapper().eq(UnifiedDoneTaskInfo::getTaskId, (Object)unifiedTaskInfo.getTaskId()));
                break;
            }
            case "5": {
                UnifiedUnReadTaskInfo unifiedUnReadTaskInfoServiceOne = (UnifiedUnReadTaskInfo)this.unifiedUnReadTaskInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(UnifiedUnReadTaskInfo::getTaskId, (Object)unifiedTaskInfo.getTaskId()));
                logger.info("\u672a\u8bfb\u6570\u636e\uff1a" + JSON.toJSONString((Object)unifiedUnReadTaskInfoServiceOne));
                if (unifiedUnReadTaskInfoServiceOne != null) {
                    String taskId = this.unifiedUnReadTaskInfoService.selectTaskId(unifiedUnReadTaskInfoServiceOne.getTodoId().toString());
                    logger.info("taskId\uff1a" + taskId);
                    if (taskId != null && !taskId.equals("")) {
                        logger.info("\u9501\u8868\u540e\u67e5\u8be2\u5230\u672a\u8bfb\u53ef\u8fdb\u5165\uff1a" + taskId);
                        this.unifiedUnReadTaskInfoService.remove((Wrapper)new LambdaQueryWrapper().eq(UnifiedUnReadTaskInfo::getTodoId, (Object)unifiedUnReadTaskInfoServiceOne.getTodoId()));
                        this.unifiedReadedTaskInfoService.remove((Wrapper)new LambdaQueryWrapper().eq(UnifiedReadedTaskInfo::getTaskId, (Object)unifiedTaskInfo.getTaskId()));
                        break;
                    }
                    logger.info("\u9501\u8868\u540e\u67e5\u8be2\u672a\u8bfb\u4e3a\u7a7a\u8fdb\u5165");
                    return;
                }
                return;
            }
        }
        unifiedTaskInfos.add(unifiedTaskInfo);
        unifiedTaskUsers.add(unifiedTaskUser);
        this.saveBatchTaskInfos(unifiedTaskInfos, unifiedTaskUsers);
    }

    private void deleteUnified(List<UnifiedParamDto> unifiedParamDtoList, Long systemId) {
        if (unifiedParamDtoList.isEmpty()) {
            return;
        }
        if (this.unifiedTodoProperties.getOpen()) {
            List todoTaskInfoList;
            logger.info("\u4fee\u6539\u8282\u70b9\u5ba1\u6279\u4eba\u63a8\u9001\u5f00\u59cb");
            ArrayList unifiedParamDtoListNew = new ArrayList();
            ArrayList<UnifiedParamDto> unifiedParamTodoDtoListNew = new ArrayList<UnifiedParamDto>();
            List taskIds = unifiedParamDtoList.stream().map(UnifiedParamDto::getApprovalId).filter(HussarUtils::isNotEmpty).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(taskIds) && CollectionUtil.isNotEmpty((Collection)(todoTaskInfoList = this.iUnifiedTodoTaskInfoService.list((Wrapper)new LambdaQueryWrapper().in(UnifiedTodoTaskInfo::getTaskId, taskIds))))) {
                logger.info("taskSize:" + todoTaskInfoList.size());
                for (UnifiedParamDto unifiedParamDto : unifiedParamDtoList) {
                    logger.info("deleteTaskInfo:" + JSON.toJSONString((Object)unifiedParamDto));
                    List partList = todoTaskInfoList.stream().filter(t -> t.getTaskId().equals(unifiedParamDto.getApprovalId())).collect(Collectors.toList());
                    if (CollectionUtil.isEmpty(partList)) continue;
                    UnifiedTodoTaskInfo taskInfo = (UnifiedTodoTaskInfo)partList.get(0);
                    List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskUser::getTaskId, (Object)unifiedParamDto.getApprovalId())).eq(UnifiedTaskUser::getSystemId, (Object)systemId));
                    logger.info("taskUserSize:" + taskUsers.size());
                    if (!CollectionUtil.isNotEmpty((Collection)taskUsers)) continue;
                    Iterator iterator = taskUsers.iterator();
                    while (iterator.hasNext()) {
                        UnifiedTaskUser taskUser = (UnifiedTaskUser)iterator.next();
                        UnifiedParamDto dto = new UnifiedParamDto();
                        BeanUtil.copyProperties((Object)unifiedParamDto, (Object)dto);
                        dto.setKey2(taskInfo.getTaskName());
                        dto.setFlowID(taskInfo.getProcessInstanceid());
                        dto.setUserId(taskUser.getUserId());
                        dto.setTypeid("3");
                        logger.info("taskNewInfo:" + JSON.toJSONString((Object)dto));
                        unifiedParamDtoListNew.add(dto);
                    }
                }
                List todoOldTaskInfoList = this.iUnifiedTodoTaskInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTodoTaskInfo::getProcessInstanceid, (Object)((UnifiedTodoTaskInfo)todoTaskInfoList.get(0)).getProcessInstanceid())).notIn(UnifiedTodoTaskInfo::getTaskId, taskIds));
                if (HussarUtils.isNotEmpty((Object)todoOldTaskInfoList)) {
                    for (UnifiedTodoTaskInfo unifiedTodoTaskInfo : todoOldTaskInfoList) {
                        logger.info("taskTodoNewInfo:" + JSON.toJSONString((Object)unifiedTodoTaskInfo));
                        List taskUsers = this.unifiedTaskUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskUser::getTaskId, (Object)unifiedTodoTaskInfo.getTaskId())).eq(UnifiedTaskUser::getSystemId, (Object)systemId));
                        logger.info("taskTodoUserSize:" + taskUsers.size());
                        if (!CollectionUtil.isNotEmpty((Collection)taskUsers)) continue;
                        for (UnifiedTaskUser taskUser : taskUsers) {
                            UnifiedParamDto dto = new UnifiedParamDto();
                            dto.setApprovalId(unifiedTodoTaskInfo.getTaskId());
                            dto.setKey2(unifiedTodoTaskInfo.getTaskName());
                            dto.setParam10(unifiedTodoTaskInfo.getMobileLinkurl());
                            dto.setFlowID(unifiedTodoTaskInfo.getProcessInstanceid());
                            dto.setUserId(taskUser.getUserId());
                            dto.setTypeid(unifiedTodoTaskInfo.getTaskStatus());
                            dto.setCreateTime(HussarUtils.isNull((Object)unifiedTodoTaskInfo.getCreateTime()) ? "" : String.valueOf(unifiedTodoTaskInfo.getCreateTime().getTime()));
                            logger.info("taskTodoNewInfo:" + JSON.toJSONString((Object)dto));
                            unifiedParamTodoDtoListNew.add(dto);
                        }
                    }
                }
            }
            this.pushToOa(unifiedParamDtoListNew, new ArrayList<UnifiedParamDto>(), String.valueOf(systemId));
            this.pushToOa(unifiedParamTodoDtoListNew, new ArrayList<UnifiedParamDto>(), String.valueOf(systemId));
        }
        if (this.unifiedTodoGLDProperties.isOpen()) {
            for (UnifiedParamDto dto : unifiedParamDtoList) {
                JSONObject jsonObject;
                String resp;
                String resultData;
                HashMap<String, Object> data;
                ArrayList resultList;
                String procInstId = dto.procInstId();
                String taskId = dto.taskId();
                if (HussarUtils.isNotEmpty((Object)procInstId)) {
                    UnifiedProcessInfo unifiedProcessInfo = (UnifiedProcessInfo)this.unifiedProcessInfoService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getProcInstId, (Object)procInstId)).eq(UnifiedProcessInfo::getSystemId, (Object)systemId));
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("Authorization", "Basic ZDE5Njc4YTQ4YjczZDdhOTM4NTdmNTZiMDA2NTAyZTg6NmRkZmI4ZGEzNw==");
                    resultList = new ArrayList();
                    data = new HashMap<String, Object>();
                    data.put("id", unifiedProcessInfo.getProcInstId());
                    data.put("approvalStatus", Integer.valueOf(this.getProcessStatus(unifiedProcessInfo.getProcessState())));
                    data.put("deleted", "true");
                    resultList.add(data);
                    resultData = JSON.toJSONString(resultList);
                    logger.info("requestParamJsonToGLD:" + resultData);
                    resp = HttpClientUtil.httpPost(this.unifiedTodoGLDProperties.getApproveRecord(), resultData, hashMap);
                    logger.info("responseParamToGLD:" + resp);
                    jsonObject = JSON.parseObject((String)resp);
                    if (HussarUtils.isNotEmpty((Object)jsonObject.get((Object)"returnCode")) && !jsonObject.get((Object)"returnCode").equals("0")) {
                        logger.info("\u63a8\u9001\u6d41\u7a0b\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a " + jsonObject.get((Object)"errorString"));
                    }
                }
                if (!HussarUtils.isNotEmpty((Object)taskId)) continue;
                UnifiedTaskInfo unifiedTaskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTaskInfo::getTaskId, (Object)taskId)).eq(UnifiedTaskInfo::getSystemId, (Object)systemId));
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("Authorization", "Basic ZDE5Njc4YTQ4YjczZDdhOTM4NTdmNTZiMDA2NTAyZTg6NmRkZmI4ZGEzNw==");
                resultList = new ArrayList();
                data = new HashMap();
                data.put("flowId", unifiedTaskInfo.getProcessInstanceid());
                data.put("id", unifiedTaskInfo.getTaskId());
                data.put("approveTime", "");
                data.put("approvalStatus", "2");
                data.put("deleted", "true");
                data.put("jumpUrl", this.getJumpUrl("3", unifiedTaskInfo.getTaskId()));
                resultList.add(data);
                resultData = JSON.toJSONString(resultList);
                logger.info("requestParamJsonToGLD:" + resultData);
                resp = HttpClientUtil.httpPost(this.unifiedTodoGLDProperties.getApproveNode(), resultData, hashMap);
                logger.info("responseParamToGLD:" + resp);
                jsonObject = JSON.parseObject((String)resp);
                if (!HussarUtils.isNotEmpty((Object)jsonObject.get((Object)"returnCode")) || jsonObject.get((Object)"returnCode").equals("0")) continue;
                logger.info("\u63a8\u9001\u8282\u70b9\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a " + jsonObject.get((Object)"errorString"));
            }
        }
        HashSet<String> procInstIds = new HashSet<String>();
        HashSet<String> taskIds = new HashSet<String>();
        for (UnifiedParamDto unifiedParamDto : unifiedParamDtoList) {
            String procInstId = unifiedParamDto.procInstId();
            String string = unifiedParamDto.taskId();
            if (HussarUtils.isNotEmpty((Object)procInstId)) {
                procInstIds.add(procInstId);
            }
            if (!HussarUtils.isNotEmpty((Object)string)) continue;
            taskIds.add(string);
        }
        if (!HussarUtils.isEmpty(procInstIds)) {
            ((LambdaUpdateChainWrapper)this.unifiedProcessInfoService.lambdaUpdate().in(UnifiedProcessInfo::getProcInstId, procInstIds)).remove();
            ((LambdaUpdateChainWrapper)this.unifiedProcessRectificationService.lambdaUpdate().in(UnifiedProcessRectificationInfo::getProcInstId, procInstIds)).remove();
        }
        if (!HussarUtils.isEmpty(taskIds)) {
            ((LambdaUpdateChainWrapper)this.unifiedTaskInfoService.lambdaUpdate().in(UnifiedTaskInfo::getTaskId, taskIds)).remove();
            ((LambdaUpdateChainWrapper)this.unifiedTaskUserService.lambdaUpdate().in(UnifiedTaskUser::getTaskId, taskIds)).remove();
            ((LambdaUpdateChainWrapper)this.unifiedTodoTaskInfoService.lambdaUpdate().in(UnifiedTodoTaskInfo::getTaskId, taskIds)).remove();
            ((LambdaUpdateChainWrapper)this.unifiedPendingTaskInfoService.lambdaUpdate().in(UnifiedPendingTaskInfo::getTaskId, taskIds)).remove();
            ((LambdaUpdateChainWrapper)this.unifiedDoneTaskInfoService.lambdaUpdate().in(UnifiedDoneTaskInfo::getTaskId, taskIds)).remove();
            ((LambdaUpdateChainWrapper)this.unifiedUnReadTaskInfoService.lambdaUpdate().in(UnifiedUnReadTaskInfo::getTaskId, taskIds)).remove();
            ((LambdaUpdateChainWrapper)this.unifiedReadedTaskInfoService.lambdaUpdate().in(UnifiedReadedTaskInfo::getTaskId, taskIds)).remove();
        }
    }

    public ApiResponse<Page<UnifiedTaskQueryVo>> queryUnifiedTask(Page<UnifiedTaskQueryVo> page, UnifiedTaskQueryDto unifiedTaskQueryDto) {
        if (unifiedTaskQueryDto.isOnlyQueryProcess()) {
            this.unifiedToDoMapper.queryUnifiedProcess(page, unifiedTaskQueryDto);
            if (unifiedTaskQueryDto.isCountDueDays()) {
                Date now = new Date();
                for (UnifiedTaskQueryVo record : page.getRecords()) {
                    LocalDateTime dueTime = record.getDeadLine();
                    if (dueTime == null) continue;
                    long days = (dueTime.toInstant(ZoneOffset.of("+8")).toEpochMilli() - now.getTime()) / 86400000L;
                    record.setNumberOfDaysBeforeTimeout(Long.valueOf(days));
                }
            }
        } else {
            this.unifiedToDoMapper.queryUnifiedTask(page, unifiedTaskQueryDto);
        }
        for (UnifiedTaskQueryVo record : page.getRecords()) {
            if (!HussarUtils.isNotEmpty((Object)record.getProcessState())) continue;
            record.setProcessStateStr(ProcessState.getProcessState((String)record.getProcessState()));
        }
        if (page.getRecords() != null && !page.getRecords().isEmpty()) {
            this.getFormAuth(page.getRecords(), "1");
        }
        return ApiResponse.success(page);
    }

    public ApiResponse<Page<UnifiedTaskQueryVo>> queryDoneCcTask(Page<UnifiedTaskQueryVo> page, UnifiedTaskQueryDto unifiedTaskQueryDto) {
        this.unifiedToDoMapper.queryDoneCcTask(page, unifiedTaskQueryDto);
        for (UnifiedTaskQueryVo record : page.getRecords()) {
            if (!HussarUtils.isNotEmpty((Object)record.getProcessState())) continue;
            record.setProcessStateStr(ProcessState.getProcessState((String)record.getProcessState()));
        }
        if (page.getRecords() != null && !page.getRecords().isEmpty()) {
            this.getFormAuth(page.getRecords(), "0");
        }
        return ApiResponse.success(page);
    }

    public ApiResponse<Page<UnifiedTaskQueryVo>> queryDoneTask(Page<UnifiedTaskQueryVo> page, UnifiedTaskQueryDto unifiedTaskQueryDto) {
        this.unifiedToDoMapper.queryDoneTaskNew(page, unifiedTaskQueryDto);
        for (UnifiedTaskQueryVo record : page.getRecords()) {
            if (!HussarUtils.isNotEmpty((Object)record.getProcessState())) continue;
            record.setProcessStateStr(ProcessState.getProcessState((String)record.getProcessState()));
        }
        if (page.getRecords() != null && !page.getRecords().isEmpty()) {
            this.getFormAuth(page.getRecords(), "0");
        }
        return ApiResponse.success(page);
    }

    public ApiResponse<Page<UnifiedTaskQueryVo>> queryUnifiedTasks(Page<UnifiedTaskQueryVo> page, UnifiedTaskQueryDto unifiedTaskQueryDto) {
        ArrayList<UnifiedTaskQueryVo> unifiedTaskQueryVos = new ArrayList();
        if (unifiedTaskQueryDto.getTaskType().equals("1")) {
            unifiedTaskQueryVos = this.unifiedToDoMapper.queryUnifiedToDoTasks(unifiedTaskQueryDto);
        } else if (unifiedTaskQueryDto.getTaskType().equals("2")) {
            unifiedTaskQueryVos = this.unifiedToDoMapper.queryUnifiedPendingTasks(unifiedTaskQueryDto);
        } else if (unifiedTaskQueryDto.getTaskType().equals("4")) {
            unifiedTaskQueryVos = this.unifiedToDoMapper.queryUnifiedUnReadTasks(unifiedTaskQueryDto);
        }
        if (HussarUtils.isNotEmpty(unifiedTaskQueryVos)) {
            for (UnifiedTaskQueryVo unifiedTaskQueryVo : unifiedTaskQueryVos) {
                if (!HussarUtils.isNull((Object)unifiedTaskQueryVo.getDeadLine())) {
                    long dateLine = Timestamp.valueOf(unifiedTaskQueryVo.getDeadLine()).getTime();
                    long now = System.currentTimeMillis();
                    double housr = (double)(dateLine - now) * 1.0 / 1000.0 / 3600.0;
                    double result = Math.floor(housr);
                    long numberOfDaysBeforeTimeout = Double.valueOf(result).longValue();
                    unifiedTaskQueryVo.setNumberOfDaysBeforeTimeout(Long.valueOf(numberOfDaysBeforeTimeout));
                }
                if (unifiedTaskQueryDto.getTaskType().equals("4")) {
                    this.getFormAuth(unifiedTaskQueryVos, "1");
                    continue;
                }
                this.getFormAuth(unifiedTaskQueryVos, "0");
            }
        }
        return ApiResponse.success((Object)page.setRecords(unifiedTaskQueryVos));
    }

    public ApiResponse<Long> queryUnifiedTaskNumber(UnifiedTaskQueryDto unifiedTaskQueryDto) {
        if (unifiedTaskQueryDto.isOnlyQueryProcess()) {
            return ApiResponse.success((Object)this.unifiedToDoMapper.queryUnifiedProcessNumber(unifiedTaskQueryDto));
        }
        return ApiResponse.success((Object)this.unifiedToDoMapper.queryUnifiedTaskNumber(unifiedTaskQueryDto));
    }

    public ApiResponse<Page<UnifiedTaskQueryVo>> queryUnifiedMyTask(Page<UnifiedTaskQueryVo> page, UnifiedTaskQueryDto unifiedTaskQueryDto) {
        unifiedTaskQueryDto.setStartUserId(unifiedTaskQueryDto.getUserId());
        this.unifiedToDoMapper.queryUnifiedMyTask(page, unifiedTaskQueryDto);
        for (UnifiedTaskQueryVo record : page.getRecords()) {
            if (!HussarUtils.isNotEmpty((Object)record.getProcessState())) continue;
            record.setProcessStateStr(ProcessState.getProcessState((String)record.getProcessState()));
            record.setTaskDefKey("");
        }
        if (page.getRecords() != null && !page.getRecords().isEmpty()) {
            this.getFormAuth(page.getRecords(), "1");
        }
        return ApiResponse.success(page);
    }

    public void getFormAuth(List<UnifiedTaskQueryVo> unifiedTaskQueryVos, String formAuth) {
        for (int i = 0; i < unifiedTaskQueryVos.size(); ++i) {
            String[] type;
            String disabled = "";
            String hidden = "";
            String mobileDisable = "";
            String mobileHidden = "";
            for (String s : type = new String[]{"web", "mobile"}) {
                String[] formAll;
                if (s.equals("web")) {
                    String webUrlProps = "";
                    if (formAuth.equals("0")) {
                        webUrlProps = unifiedTaskQueryVos.get(i).getWebUrlProps();
                    } else if (formAuth.equals("1")) {
                        webUrlProps = unifiedTaskQueryVos.get(i).getProcessWebUrlProps();
                    }
                    if (webUrlProps == null || webUrlProps.equals("")) continue;
                    formAll = webUrlProps.split(";");
                    disabled = formAll[0].replace("[", "").replace("]", "");
                    hidden = formAll[1].replace("[", "").replace("]", "");
                    continue;
                }
                String mobileUrlProps = "";
                if (formAuth.equals("0")) {
                    mobileUrlProps = unifiedTaskQueryVos.get(i).getMobileUrlProps();
                } else if (formAuth.equals("1")) {
                    mobileUrlProps = unifiedTaskQueryVos.get(i).getProcessMobileUrlProps();
                }
                if (mobileUrlProps == null || mobileUrlProps.equals("")) continue;
                formAll = mobileUrlProps.split(";");
                mobileDisable = formAll[1].replace("[", "").replace("]", "");
                mobileHidden = formAll[1].replace("[", "").replace("]", "");
            }
            unifiedTaskQueryVos.get(i).setDisabled(disabled);
            unifiedTaskQueryVos.get(i).setHidden(hidden);
            unifiedTaskQueryVos.get(i).setMobileDisable(mobileDisable);
            unifiedTaskQueryVos.get(i).setMobileHidden(mobileHidden);
        }
    }

    public ApiResponse<Page<UnifiedTaskQueryVo>> queryRectification(Page<UnifiedTaskQueryVo> page, UnifiedTaskQueryDto unifiedTaskQueryDto) {
        List<UnifiedTaskQueryVo> taskQueryVos = this.unifiedToDoMapper.queryRectification(unifiedTaskQueryDto);
        return ApiResponse.success((Object)page.setRecords(taskQueryVos));
    }

    public ApiResponse<Long> queryRectificationNumberExtend(String userId, String processStatus) {
        long count = this.unifiedProcessInfoService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getStartUserId, (Object)userId)).eq(UnifiedProcessInfo::getProcessState, (Object)processStatus));
        return ApiResponse.success((Object)count);
    }

    public ApiResponse<TaskNumber> queryTaskNumber(String userId) {
        TaskNumber taskNumber = new TaskNumber();
        ArrayList<String> processState = new ArrayList<String>();
        processState.add("3");
        processState.add("9");
        taskNumber.setCcTask(Long.valueOf(this.unifiedUnReadTaskInfoService.count((Wrapper)new LambdaQueryWrapper().eq(UnifiedUnReadTaskInfo::getUserId, (Object)userId))));
        taskNumber.setRectificationTask(Long.valueOf(this.unifiedProcessRectificationService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedProcessRectificationInfo::getStartUserId, (Object)userId)).eq(UnifiedProcessRectificationInfo::getProcessState, (Object)"3"))));
        taskNumber.setMyTask(Long.valueOf(this.unifiedProcessInfoService.count((Wrapper)new LambdaQueryWrapper().eq(UnifiedProcessInfo::getStartUserId, (Object)userId))));
        processState.add("2");
        taskNumber.setTodoTask(Long.valueOf(this.unifiedTodoTaskInfoService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedTodoTaskInfo::getUserId, (Object)userId)).notIn(UnifiedTodoTaskInfo::getProcessState, processState))));
        taskNumber.setPendingTask(Long.valueOf(this.unifiedPendingTaskInfoService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UnifiedPendingTaskInfo::getUserId, (Object)userId)).notIn(UnifiedPendingTaskInfo::getProcessState, processState))));
        return ApiResponse.success((Object)taskNumber);
    }
}

