/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unifiedtodo.utils;

import com.jxdinfo.hussar.unifiedtodo.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
    private static final Charset CHARSET = StandardCharsets.UTF_8;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPost(String url, Map<String, String> headers) {
        String content = null;
        CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(url);
        if (StringUtils.isNotEmpty(headers) && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpPost.setHeader(entry.getKey(), entry.getValue());
            }
        }
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = httpResponse.getEntity();
            content = EntityUtils.toString((HttpEntity)entity, (Charset)CHARSET);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpResponse.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPost(String url, String params, Map<String, String> headers) {
        CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Content-type", "application/json");
        if (StringUtils.isNotEmpty(headers) && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpPost.setHeader(entry.getKey(), entry.getValue());
            }
        }
        StringEntity stringEntity = new StringEntity(params, CHARSET);
        httpPost.setEntity((HttpEntity)stringEntity);
        String content = null;
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = httpResponse.getEntity();
            content = EntityUtils.toString((HttpEntity)entity, (Charset)CHARSET);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpResponse.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPostFormMultipart(String url, File file, Map<String, String> headers) {
        CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        if (StringUtils.isNotEmpty(headers) && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpPost.setHeader(entry.getKey(), entry.getValue());
            }
        }
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        entityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        entityBuilder.setCharset(CHARSET);
        entityBuilder.addBinaryBody("file", file);
        httpPost.setEntity(entityBuilder.build());
        String content = null;
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = httpResponse.getEntity();
            content = EntityUtils.toString((HttpEntity)entity, (Charset)CHARSET);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpResponse.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return content;
    }
}

