/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unifiedtodo.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.QueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.unifiedtodo.dao.UnifiedToDoMapper;
import com.jxdinfo.hussar.unifiedtodo.dto.QueryToDoDto;
import com.jxdinfo.hussar.unifiedtodo.dto.SaveToDoDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UpdateTaskUserToDoDto;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedSystemInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskUser;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedSystemInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskUserService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedToDoService;
import com.jxdinfo.hussar.unifiedtodo.vo.ToDoVo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnifiedToDoServiceImpl
implements IUnifiedToDoService {
    @Resource
    private UnifiedToDoMapper unifiedToDoMapper;
    @Autowired
    private IUnifiedSystemInfoService unifiedSystemInfoServiceImpl;
    @Autowired
    private IUnifiedTaskInfoService unifiedTaskInfoServiceImpl;
    @Autowired
    private IUnifiedTaskUserService unifiedTaskUserServiceImpl;
    private static final Logger logger = LoggerFactory.getLogger(UnifiedToDoServiceImpl.class);

    public ApiResponse<Long> getCountTotal(String systemId, String userId, String executeStatus) {
        LambdaQueryWrapper wrapperInfo = new LambdaQueryWrapper();
        LambdaQueryWrapper wrapperUser = new LambdaQueryWrapper();
        wrapperInfo.eq(UnifiedTaskInfo::getSystemId, (Object)Long.parseLong(systemId));
        wrapperUser.eq(UnifiedTaskUser::getSystemId, (Object)Long.parseLong(systemId));
        if (ToolUtil.isNotEmpty((Object)executeStatus)) {
            wrapperUser.eq(UnifiedTaskUser::getExecuteStatus, (Object)executeStatus);
            wrapperInfo.eq(UnifiedTaskInfo::getTaskStatus, (Object)executeStatus);
        }
        if (ToolUtil.isNotEmpty((Object)userId)) {
            wrapperUser.eq(UnifiedTaskUser::getUserId, (Object)userId);
            return ApiResponse.success((Object)this.unifiedTaskUserServiceImpl.count((Wrapper)wrapperUser));
        }
        return ApiResponse.success((Object)this.unifiedTaskInfoServiceImpl.count((Wrapper)wrapperInfo));
    }

    public ApiResponse<String> saveTask(SaveToDoDto saveToDoDto) {
        List executors = saveToDoDto.getExecutors();
        List followers = saveToDoDto.getFollowers();
        String taskStatus = ToolUtil.isNotEmpty((Object)saveToDoDto.getTaskStatus()) ? saveToDoDto.getTaskStatus() : "0";
        saveToDoDto.setTaskStatus(taskStatus);
        this.unifiedTaskInfoServiceImpl.save((Object)saveToDoDto);
        for (UnifiedTaskUser unifiedTaskUser : executors) {
            unifiedTaskUser.setSystemId(saveToDoDto.getSystemId());
            unifiedTaskUser.setTaskId(saveToDoDto.getTaskId());
            unifiedTaskUser.setTodoId(saveToDoDto.getTodoId());
            unifiedTaskUser.setExecuteStatus(taskStatus);
            unifiedTaskUser.setUserType("1");
        }
        if (ToolUtil.isNotEmpty((Object)followers)) {
            for (UnifiedTaskUser unifiedTaskUser : followers) {
                unifiedTaskUser.setSystemId(saveToDoDto.getSystemId());
                unifiedTaskUser.setTaskId(saveToDoDto.getTaskId());
                unifiedTaskUser.setTodoId(saveToDoDto.getTodoId());
                unifiedTaskUser.setExecuteStatus(taskStatus);
                unifiedTaskUser.setUserType("0");
            }
            executors.addAll(followers);
        }
        this.unifiedTaskUserServiceImpl.saveBatch((Collection)executors);
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> updateTask(SaveToDoDto saveToDoDto) {
        saveToDoDto.setLastTime(ToolUtil.isNotEmpty((Object)saveToDoDto.getLastTime()) ? saveToDoDto.getLastTime() : new Date());
        UnifiedTaskInfo s = (UnifiedTaskInfo)((QueryChainWrapper)((QueryChainWrapper)this.unifiedTaskInfoServiceImpl.query().eq((Object)"SYSTEM_ID", (Object)saveToDoDto.getSystemId())).eq((Object)"TASK_ID", (Object)saveToDoDto.getTaskId())).one();
        if (ToolUtil.isEmpty((Object)s)) {
            this.unifiedTaskInfoServiceImpl.save((Object)saveToDoDto);
        } else {
            this.unifiedTaskInfoServiceImpl.updateById((Object)saveToDoDto);
        }
        List executors = saveToDoDto.getExecutors();
        List followers = saveToDoDto.getFollowers();
        if (ToolUtil.isNotEmpty((Object)executors)) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper.eq(UnifiedTaskUser::getSystemId, (Object)saveToDoDto.getSystemId())).eq(UnifiedTaskUser::getTaskId, (Object)saveToDoDto.getTaskId());
            this.unifiedTaskUserServiceImpl.remove((Wrapper)wrapper);
            for (UnifiedTaskUser unifiedTaskUser : executors) {
                unifiedTaskUser.setSystemId(saveToDoDto.getSystemId());
                unifiedTaskUser.setTaskId(saveToDoDto.getTaskId());
                unifiedTaskUser.setTodoId(saveToDoDto.getTodoId());
                unifiedTaskUser.setExecuteStatus("0");
                unifiedTaskUser.setUserType("1");
            }
            if (ToolUtil.isNotEmpty((Object)followers)) {
                for (UnifiedTaskUser unifiedTaskUser : followers) {
                    unifiedTaskUser.setSystemId(saveToDoDto.getSystemId());
                    unifiedTaskUser.setTaskId(saveToDoDto.getTaskId());
                    unifiedTaskUser.setTodoId(saveToDoDto.getTodoId());
                    unifiedTaskUser.setExecuteStatus("0");
                    unifiedTaskUser.setUserType("0");
                }
                executors.addAll(followers);
            }
        }
        this.unifiedTaskUserServiceImpl.saveBatch((Collection)executors);
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<Page<SaveToDoDto>> getListTask(Page<SaveToDoDto> page, QueryToDoDto queryToDoDto) {
        queryToDoDto.setUserId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        Page<SaveToDoDto> saveToDoDtoPage = this.unifiedToDoMapper.queryTaskList(page, queryToDoDto);
        List saveToDoDtoList = saveToDoDtoPage.getRecords();
        for (SaveToDoDto saveToDoDto : saveToDoDtoList) {
            if (!"0".equals(saveToDoDto.getSystemSource()) || saveToDoDto.getMandator() == null) continue;
            saveToDoDto.setWebLinkurl(saveToDoDto.getWebLinkurl().replaceFirst("&taskId=" + saveToDoDto.getTaskId(), "&taskId=" + saveToDoDto.getTaskId() + ":" + saveToDoDto.getMandator()));
        }
        return ApiResponse.success(saveToDoDtoPage);
    }

    public ApiResponse<ToDoVo> getToDoByTaskId(String todoId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(UnifiedTaskInfo::getTodoId, (Object)Long.parseLong(todoId));
        UnifiedTaskInfo unifiedTaskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoServiceImpl.getOne((Wrapper)wrapper);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UnifiedTaskUser::getTodoId, (Object)todoId);
        List users = this.unifiedTaskUserServiceImpl.list((Wrapper)queryWrapper);
        ArrayList<UnifiedTaskUser> executors = new ArrayList<UnifiedTaskUser>();
        ArrayList<UnifiedTaskUser> followers = new ArrayList<UnifiedTaskUser>();
        for (UnifiedTaskUser unifiedTaskUser : users) {
            if ("1".equals(unifiedTaskUser.getUserType())) {
                executors.add(unifiedTaskUser);
                continue;
            }
            followers.add(unifiedTaskUser);
        }
        ToDoVo toDoVo = (ToDoVo)JSON.parseObject((String)JSON.toJSONString((Object)unifiedTaskInfo), ToDoVo.class);
        toDoVo.setExecutors(executors);
        toDoVo.setFollowers(followers);
        LambdaQueryWrapper wrapperSystem = new LambdaQueryWrapper();
        wrapperSystem.eq(UnifiedSystemInfo::getSystemId, (Object)unifiedTaskInfo.getSystemId());
        toDoVo.setSystemAddress(((UnifiedSystemInfo)this.unifiedSystemInfoServiceImpl.getOne((Wrapper)wrapperSystem)).getSystemAddress());
        return ApiResponse.success((Object)toDoVo);
    }

    public ApiResponse<String> deleteTask(String taskIds, String systemId, String processInstId) {
        ArrayList<String> taskId = null;
        if (ToolUtil.isNotEmpty((Object)taskIds)) {
            taskId = new ArrayList<String>(Arrays.asList(taskIds.split(",")));
        }
        LambdaQueryWrapper wrapperInfo = new LambdaQueryWrapper();
        LambdaQueryWrapper wrapperUser = new LambdaQueryWrapper();
        if (ToolUtil.isNotEmpty(taskId)) {
            wrapperInfo.in(UnifiedTaskInfo::getTaskId, taskId);
            wrapperUser.in(UnifiedTaskUser::getTaskId, taskId);
        }
        if (ToolUtil.isNotEmpty((Object)systemId)) {
            wrapperInfo.eq(UnifiedTaskInfo::getSystemId, (Object)Long.parseLong(systemId));
            wrapperUser.eq(UnifiedTaskUser::getSystemId, (Object)Long.parseLong(systemId));
        }
        if (ToolUtil.isNotEmpty((Object)processInstId)) {
            ArrayList<String> processInstIdList = new ArrayList<String>(Arrays.asList(processInstId.split(",")));
            wrapperInfo.in(UnifiedTaskInfo::getProcessInstanceid, processInstIdList);
            LambdaQueryWrapper wrapperInfoByProcessInstId = new LambdaQueryWrapper();
            wrapperInfoByProcessInstId.in(UnifiedTaskInfo::getProcessInstanceid, processInstIdList);
            List list = this.unifiedTaskInfoServiceImpl.list((Wrapper)wrapperInfoByProcessInstId).stream().map(UnifiedTaskInfo::getTodoId).collect(Collectors.toList());
            wrapperUser.in(HussarUtils.isNotEmpty(list), UnifiedTaskUser::getTodoId, list);
        }
        this.unifiedTaskInfoServiceImpl.remove((Wrapper)wrapperInfo);
        this.unifiedTaskUserServiceImpl.remove((Wrapper)wrapperUser);
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> updateTaskStatus(String taskId, String systemId, String processInstId, String taskStatus, String webLinkurl, String mobileLinkurl, String lastTime) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = ToolUtil.isNotEmpty((Object)lastTime) ? formatter.parse(lastTime) : new Date();
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        taskStatus = ToolUtil.isNotEmpty((Object)taskStatus) ? taskStatus : "1";
        LambdaUpdateWrapper wrapperInfo = new LambdaUpdateWrapper();
        if (ToolUtil.isNotEmpty((Object)taskId)) {
            wrapperInfo.eq(UnifiedTaskInfo::getTaskId, (Object)taskId);
        }
        if (ToolUtil.isNotEmpty((Object)systemId)) {
            wrapperInfo.eq(UnifiedTaskInfo::getSystemId, (Object)Long.parseLong(systemId));
        }
        List userByProcessInstId = null;
        if (ToolUtil.isNotEmpty((Object)processInstId)) {
            wrapperInfo.eq(UnifiedTaskInfo::getProcessInstanceid, (Object)processInstId);
            LambdaUpdateWrapper wrapperByProcessInstId = new LambdaUpdateWrapper();
            wrapperByProcessInstId.eq(UnifiedTaskInfo::getProcessInstanceid, (Object)processInstId);
            userByProcessInstId = this.unifiedTaskInfoServiceImpl.list((Wrapper)wrapperByProcessInstId).stream().map(UnifiedTaskInfo::getTodoId).collect(Collectors.toList());
        }
        if (ToolUtil.isNotEmpty((Object)mobileLinkurl)) {
            wrapperInfo.set(UnifiedTaskInfo::getMobileLinkurl, (Object)mobileLinkurl);
        }
        if (ToolUtil.isNotEmpty((Object)webLinkurl)) {
            wrapperInfo.set(UnifiedTaskInfo::getWebLinkurl, (Object)webLinkurl);
        }
        wrapperInfo.set(UnifiedTaskInfo::getTaskStatus, (Object)taskStatus);
        wrapperInfo.set(UnifiedTaskInfo::getLastTime, (Object)date);
        this.unifiedTaskInfoServiceImpl.update((Wrapper)wrapperInfo);
        LambdaUpdateWrapper wrapperUser = new LambdaUpdateWrapper();
        if (ToolUtil.isNotEmpty((Object)systemId)) {
            wrapperUser.eq(UnifiedTaskUser::getSystemId, (Object)Long.parseLong(systemId));
        }
        if (ToolUtil.isNotEmpty((Object)taskId)) {
            wrapperUser.eq(UnifiedTaskUser::getTaskId, (Object)taskId);
        }
        if (ToolUtil.isNotEmpty(userByProcessInstId)) {
            wrapperUser.in(UnifiedTaskUser::getTodoId, userByProcessInstId);
        }
        wrapperUser.set(UnifiedTaskUser::getExecuteStatus, (Object)taskStatus);
        if ("1".equals(taskStatus)) {
            wrapperUser.set(UnifiedTaskUser::getCompleteTime, (Object)date);
        } else {
            wrapperUser.set(UnifiedTaskUser::getCompleteTime, null);
        }
        this.unifiedTaskUserServiceImpl.update((Wrapper)wrapperUser);
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> updateUserStatus(UnifiedTaskUser unifiedTaskUser) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskUser.getSystemId())).eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskUser.getTaskId())).eq(UnifiedTaskUser::getUserId, (Object)unifiedTaskUser.getUserId())).eq(UnifiedTaskUser::getUserType, (Object)unifiedTaskUser.getUserType());
        ((LambdaUpdateWrapper)wrapper.set(UnifiedTaskUser::getExecuteStatus, (Object)unifiedTaskUser.getExecuteStatus())).set(UnifiedTaskUser::getCompleteTime, (Object)(ToolUtil.isNotEmpty((Object)unifiedTaskUser.getCompleteTime()) ? unifiedTaskUser.getCompleteTime() : new Date()));
        this.unifiedTaskUserServiceImpl.update((Wrapper)wrapper);
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> updateTaskUser(String taskId, String systemId, String executeStatus, List<UnifiedTaskUser> executors, List<UnifiedTaskUser> followers) {
        LambdaQueryWrapper wrapperInfo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapperInfo.eq(UnifiedTaskInfo::getSystemId, (Object)Long.parseLong(systemId))).eq(UnifiedTaskInfo::getTaskId, (Object)taskId);
        Long todoId = ((UnifiedTaskInfo)this.unifiedTaskInfoServiceImpl.getOne((Wrapper)wrapperInfo)).getTodoId();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(UnifiedTaskUser::getSystemId, (Object)Long.parseLong(systemId))).eq(UnifiedTaskUser::getTaskId, (Object)taskId)).eq(UnifiedTaskUser::getUserType, (Object)"1");
        this.unifiedTaskUserServiceImpl.remove((Wrapper)wrapper);
        for (UnifiedTaskUser unifiedTaskUser : executors) {
            unifiedTaskUser.setSystemId(Long.valueOf(Long.parseLong(systemId)));
            unifiedTaskUser.setTaskId(taskId);
            unifiedTaskUser.setTodoId(todoId);
            unifiedTaskUser.setExecuteStatus(ToolUtil.isNotEmpty((Object)executeStatus) ? executeStatus : "0");
            unifiedTaskUser.setUserType("1");
        }
        if (followers != null) {
            LambdaQueryWrapper wrapperFollower = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapperFollower.eq(UnifiedTaskUser::getSystemId, (Object)Long.parseLong(systemId))).eq(UnifiedTaskUser::getTaskId, (Object)taskId)).eq(UnifiedTaskUser::getUserType, (Object)"0");
            this.unifiedTaskUserServiceImpl.remove((Wrapper)wrapperFollower);
            for (UnifiedTaskUser unifiedTaskUser : followers) {
                unifiedTaskUser.setSystemId(Long.valueOf(Long.parseLong(systemId)));
                unifiedTaskUser.setTaskId(taskId);
                unifiedTaskUser.setTodoId(todoId);
                unifiedTaskUser.setExecuteStatus(ToolUtil.isNotEmpty((Object)executeStatus) ? executeStatus : "0");
                unifiedTaskUser.setUserType("0");
            }
            executors.addAll(followers);
        }
        this.unifiedTaskUserServiceImpl.saveBatch(executors);
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<IPage<UnifiedSystemInfo>> getListSystem(Page<UnifiedSystemInfo> page, String tenantId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(UnifiedSystemInfo::getTenantId, (Object)tenantId);
        return ApiResponse.success((Object)this.unifiedSystemInfoServiceImpl.page(page, (Wrapper)wrapper));
    }

    public ApiResponse<String> addTaskUser(List<UnifiedTaskUser> unifiedTaskUsers) {
        for (UnifiedTaskUser unifiedTaskUser : unifiedTaskUsers) {
            LambdaQueryWrapper wrapperInfo = new LambdaQueryWrapper();
            wrapperInfo.eq(UnifiedTaskInfo::getSystemId, (Object)unifiedTaskUser.getSystemId());
            wrapperInfo.eq(UnifiedTaskInfo::getTaskId, (Object)unifiedTaskUser.getTaskId());
            unifiedTaskUser.setTodoId(((UnifiedTaskInfo)this.unifiedTaskInfoServiceImpl.getOne((Wrapper)wrapperInfo)).getTodoId());
            unifiedTaskUser.setExecuteStatus(ToolUtil.isNotEmpty((Object)unifiedTaskUser.getExecuteStatus()) ? unifiedTaskUser.getExecuteStatus() : "0");
        }
        this.unifiedTaskUserServiceImpl.saveBatch(unifiedTaskUsers);
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> deleteTaskUser(List<UnifiedTaskUser> unifiedTaskUsers) {
        for (UnifiedTaskUser unifiedTaskUser : unifiedTaskUsers) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskUser.getSystemId())).eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskUser.getTaskId())).eq(UnifiedTaskUser::getUserType, (Object)unifiedTaskUser.getUserType());
            if (ToolUtil.isNotEmpty((Object)unifiedTaskUser.getUserId())) {
                wrapper.eq(UnifiedTaskUser::getUserId, (Object)unifiedTaskUser.getUserId());
            }
            if (HussarUtils.isNotEmpty((Object)unifiedTaskUser.getMandator())) {
                wrapper.eq(UnifiedTaskUser::getMandator, (Object)unifiedTaskUser.getMandator());
            } else if ("".equals(unifiedTaskUser.getMandator())) {
                wrapper.isNull(UnifiedTaskUser::getMandator);
            }
            this.unifiedTaskUserServiceImpl.remove((Wrapper)wrapper);
        }
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> updateTaskUser(String taskId, String systemId, String executeStatus, UpdateTaskUserToDoDto updateTaskUserToDoDto) {
        return this.updateTaskUser(taskId, systemId, executeStatus, updateTaskUserToDoDto.getExecutors(), updateTaskUserToDoDto.getFollowers());
    }

    public ApiResponse<String> transferTaskDeleteTaskUser(List<UnifiedTaskUser> unifiedTaskUsers) {
        for (UnifiedTaskUser unifiedTaskUser : unifiedTaskUsers) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskUser.getSystemId())).eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskUser.getTaskId())).eq(UnifiedTaskUser::getUserType, (Object)unifiedTaskUser.getUserType())).eq(UnifiedTaskUser::getTaskState, (Object)unifiedTaskUser.getTaskState());
            if (ToolUtil.isNotEmpty((Object)unifiedTaskUser.getUserId())) {
                wrapper.eq(UnifiedTaskUser::getUserId, (Object)unifiedTaskUser.getUserId());
            }
            this.unifiedTaskUserServiceImpl.remove((Wrapper)wrapper);
        }
        return ApiResponse.success((Object)"", null);
    }
}

