/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unifiedtodo.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.unifiedtodo.config.ElasticSearchConfig;
import com.jxdinfo.hussar.unifiedtodo.dao.UnifiedToDoMapper;
import com.jxdinfo.hussar.unifiedtodo.dto.AcceptTaskDto;
import com.jxdinfo.hussar.unifiedtodo.dto.DeleteTaskDto;
import com.jxdinfo.hussar.unifiedtodo.dto.QueryToDoDto;
import com.jxdinfo.hussar.unifiedtodo.dto.SaveArchiveDto;
import com.jxdinfo.hussar.unifiedtodo.dto.SaveToDoDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UpdateAllTaskUserDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UpdateTaskStatusDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UpdateTaskUserDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UpdateTaskUserToDoDto;
import com.jxdinfo.hussar.unifiedtodo.dto.startUpOrderDto;
import com.jxdinfo.hussar.unifiedtodo.model.TBpmSendSmsNow;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedProcArchive;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedSystemInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskUser;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskdoneInfo;
import com.jxdinfo.hussar.unifiedtodo.service.ITBpmSendSmsNowService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedProcArchiveService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedSystemInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskUserService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskdoneInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedToDoService;
import com.jxdinfo.hussar.unifiedtodo.util.ESUtils;
import com.jxdinfo.hussar.unifiedtodo.vo.ToDoVo;
import com.jxdinfo.hussar.workflow.unifiedtodatapush.util.UnifiedToDoDataPushProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnifiedToDoServiceImpl
implements IUnifiedToDoService {
    private static Logger logger = LoggerFactory.getLogger(UnifiedToDoServiceImpl.class);
    @Autowired
    private UnifiedToDoMapper unifiedToDoMapper;
    @Autowired
    private IUnifiedSystemInfoService unifiedSystemInfoServiceImpl;
    @Autowired
    private IUnifiedTaskInfoService unifiedTaskInfoServiceImpl;
    @Autowired
    private IUnifiedTaskdoneInfoService unifiedTaskdoneInfoServiceImpl;
    @Autowired
    private IUnifiedTaskUserService unifiedTaskUserServiceImpl;
    @Autowired
    private ElasticSearchConfig elasticSearchConfig;
    @Autowired
    private IUnifiedProcArchiveService unifiedProcArchiveService;
    @Autowired
    private ITBpmSendSmsNowService tBpmSendSmsNowService;
    @Autowired
    private UnifiedToDoDataPushProperties dataPushProperties;

    public ApiResponse<Long> getCountTotal(String systemId, String userId, String executeStatus) {
        return ApiResponse.success();
    }

    public ApiResponse<String> saveTask(SaveToDoDto saveToDoDto) {
        LinkedList<UnifiedTaskInfo> unifiedTaskInfoLinkedList = new LinkedList<UnifiedTaskInfo>();
        try {
            List<String> sendSmsProcessKeys;
            for (String userId : saveToDoDto.getUserId().split(",")) {
                UnifiedTaskInfo taskInfo = saveToDoDto.clone();
                taskInfo.setUserId(userId);
                taskInfo.setCreateTime(ToolUtil.isNotEmpty((Object)taskInfo.getCreateTime()) ? taskInfo.getCreateTime() : new Date());
                unifiedTaskInfoLinkedList.add(taskInfo);
            }
            logger.info("-------------------\u7edf\u4e00\u5f85\u529e{/unifiedtodo/saveTask}\u6b64\u6b21\u63d0\u4ea4\u4fdd\u5b58\u5f85\u529e\uff1a {}\u6761", (Object)unifiedTaskInfoLinkedList.size());
            this.unifiedTaskInfoServiceImpl.saveBatch(unifiedTaskInfoLinkedList);
            if (this.dataPushProperties.isSendSms() && (sendSmsProcessKeys = Arrays.asList(this.dataPushProperties.getSendSmsProcessKey().split(","))).contains(saveToDoDto.getProcessDefinitionkey())) {
                TBpmSendSmsNow tBpmSendSmsNow = new TBpmSendSmsNow();
                tBpmSendSmsNow.setHtNameDes(saveToDoDto.getTaskName());
                tBpmSendSmsNow.setPiid(saveToDoDto.getProcessInstanceid());
                tBpmSendSmsNow.setTkiid(saveToDoDto.getTaskId());
                tBpmSendSmsNow.setHtName(saveToDoDto.getTaskDefinitionkey());
                tBpmSendSmsNow.setCreateTime(ToolUtil.isNotEmpty((Object)saveToDoDto.getCreateTime()) ? saveToDoDto.getCreateTime() : new Date());
                this.tBpmSendSmsNowService.save((Object)tBpmSendSmsNow);
            }
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (this.elasticSearchConfig.isEnableElasticsearch().equals(Boolean.TRUE)) {
            for (UnifiedTaskInfo taskInfo : unifiedTaskInfoLinkedList) {
                ESUtils.saveDoc((String)"sys_unified_task_info", (String)taskInfo.getTodoId().toString(), (Object)taskInfo);
            }
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> updateTask(SaveToDoDto saveToDoDto) {
        String[] userIds;
        for (String userId : userIds = saveToDoDto.getUserId().split(",")) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(UnifiedTaskInfo::getTaskId, (Object)saveToDoDto.getTaskId())).eq(UnifiedTaskInfo::getSystemId, (Object)saveToDoDto.getSystemId())).eq(UnifiedTaskInfo::getUserId, (Object)userId)).eq(UnifiedTaskInfo::getTaskType, (Object)saveToDoDto.getTaskType());
            this.unifiedTaskInfoServiceImpl.update((Object)saveToDoDto, (Wrapper)wrapper);
        }
        return ApiResponse.success();
    }

    public ApiResponse<Page<SaveToDoDto>> getListTask(Page<SaveToDoDto> page, QueryToDoDto queryToDoDto) {
        queryToDoDto.setUserId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        return ApiResponse.success(this.unifiedToDoMapper.queryTaskList(page, queryToDoDto));
    }

    public ApiResponse<ToDoVo> getToDoByTaskId(String todoId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(UnifiedTaskInfo::getTodoId, (Object)Long.parseLong(todoId));
        UnifiedTaskInfo unifiedTaskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoServiceImpl.getOne((Wrapper)wrapper);
        ToDoVo toDoVo = (ToDoVo)JSON.parseObject((String)JSON.toJSONString((Object)unifiedTaskInfo), ToDoVo.class);
        LambdaQueryWrapper wrapperSystem = new LambdaQueryWrapper();
        wrapperSystem.eq(UnifiedSystemInfo::getSystemId, (Object)unifiedTaskInfo.getSystemId());
        toDoVo.setSystemAddress(((UnifiedSystemInfo)this.unifiedSystemInfoServiceImpl.getOne((Wrapper)wrapperSystem)).getSystemAddress());
        return ApiResponse.success();
    }

    public ApiResponse<String> deleteTask(DeleteTaskDto deleteTaskDto) {
        if (ToolUtil.isNotEmpty((Object)deleteTaskDto.getProcessInstanceId())) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper.eq(UnifiedTaskInfo::getSystemId, (Object)deleteTaskDto.getSystemId())).eq(UnifiedTaskInfo::getProcessInstanceid, (Object)deleteTaskDto.getProcessInstanceId());
            this.unifiedTaskInfoServiceImpl.remove((Wrapper)wrapper);
            if (this.elasticSearchConfig.isEnableElasticsearch().booleanValue()) {
                HashMap<String, Object> condition = new HashMap<String, Object>();
                condition.put("systemId", deleteTaskDto.getSystemId());
                condition.put("processInstanceid", deleteTaskDto.getProcessInstanceId());
                ESUtils.deleteByQuery((String)"sys_unified_task_info", condition);
            }
            return ApiResponse.success();
        }
        if (ToolUtil.isNotEmpty((Object)deleteTaskDto.getSubProcessInstanceId())) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper.eq(UnifiedTaskInfo::getSystemId, (Object)deleteTaskDto.getSystemId())).eq(UnifiedTaskInfo::getSubProcessInstanceid, (Object)deleteTaskDto.getSubProcessInstanceId());
            this.unifiedTaskInfoServiceImpl.remove((Wrapper)wrapper);
            if (this.elasticSearchConfig.isEnableElasticsearch().booleanValue()) {
                HashMap<String, Object> condition = new HashMap<String, Object>();
                condition.put("systemId", deleteTaskDto.getSystemId());
                condition.put("subProcessInstanceid", deleteTaskDto.getSubProcessInstanceId());
                ESUtils.deleteByQuery((String)"sys_unified_task_info", condition);
            }
            return ApiResponse.success();
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(UnifiedTaskInfo::getTaskId, (Object)deleteTaskDto.getTaskId())).eq(UnifiedTaskInfo::getSystemId, (Object)deleteTaskDto.getSystemId());
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("taskId", deleteTaskDto.getTaskId());
        condition.put("systemId", deleteTaskDto.getSystemId().toString());
        if (ToolUtil.isNotEmpty((Object)deleteTaskDto.getUserId())) {
            wrapper.in(UnifiedTaskInfo::getUserId, (Collection)deleteTaskDto.getUserId());
            condition.put("userId", deleteTaskDto.getUserId());
        }
        this.unifiedTaskInfoServiceImpl.remove((Wrapper)wrapper);
        if (this.elasticSearchConfig.isEnableElasticsearch().booleanValue()) {
            ESUtils.deleteByQuery((String)"sys_unified_task_info", condition);
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> deleteDoneTask(DeleteTaskDto deleteTaskDto) {
        if (ToolUtil.isNotEmpty((Object)deleteTaskDto.getProcessInstanceId())) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper.eq(UnifiedTaskdoneInfo::getSystemId, (Object)deleteTaskDto.getSystemId())).eq(UnifiedTaskdoneInfo::getProcessInstanceid, (Object)deleteTaskDto.getProcessInstanceId());
            this.unifiedTaskdoneInfoServiceImpl.remove((Wrapper)wrapper);
            if (this.elasticSearchConfig.isEnableElasticsearch().booleanValue()) {
                HashMap<String, Object> condition = new HashMap<String, Object>();
                condition.put("systemId", deleteTaskDto.getSystemId());
                condition.put("processInstanceid", deleteTaskDto.getProcessInstanceId());
                ESUtils.deleteByQuery((String)"sys_unified_taskdone_info", condition);
            }
            return ApiResponse.success();
        }
        if (ToolUtil.isNotEmpty((Object)deleteTaskDto.getSubProcessInstanceId())) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper.eq(UnifiedTaskdoneInfo::getSystemId, (Object)deleteTaskDto.getSystemId())).eq(UnifiedTaskdoneInfo::getSubProcessInstanceid, (Object)deleteTaskDto.getSubProcessInstanceId());
            this.unifiedTaskdoneInfoServiceImpl.remove((Wrapper)wrapper);
            if (this.elasticSearchConfig.isEnableElasticsearch().booleanValue()) {
                HashMap<String, Object> condition = new HashMap<String, Object>();
                condition.put("systemId", deleteTaskDto.getSystemId());
                condition.put("subProcessInstanceid", deleteTaskDto.getSubProcessInstanceId());
                ESUtils.deleteByQuery((String)"sys_unified_taskdone_info", condition);
            }
            return ApiResponse.success();
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(UnifiedTaskdoneInfo::getTaskId, (Object)deleteTaskDto.getTaskId())).eq(UnifiedTaskdoneInfo::getSystemId, (Object)deleteTaskDto.getSystemId());
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("taskId", deleteTaskDto.getTaskId());
        condition.put("systemId", deleteTaskDto.getSystemId().toString());
        if (ToolUtil.isNotEmpty((Object)deleteTaskDto.getUserId())) {
            wrapper.in(UnifiedTaskdoneInfo::getUserId, (Collection)deleteTaskDto.getUserId());
            condition.put("userId", deleteTaskDto.getUserId());
        }
        this.unifiedTaskdoneInfoServiceImpl.remove((Wrapper)wrapper);
        if (this.elasticSearchConfig.isEnableElasticsearch().booleanValue()) {
            ESUtils.deleteByQuery((String)"sys_unified_taskdone_info", condition);
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> updateTaskStatus(UpdateTaskStatusDto updateTaskStatusDto) {
        if ("0".equals(updateTaskStatusDto.getTaskState()) || "1".equals(updateTaskStatusDto.getTaskState())) {
            LambdaQueryWrapper taskDeleteWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)taskDeleteWrapper.eq(UnifiedTaskInfo::getTaskId, (Object)updateTaskStatusDto.getTaskId())).eq(UnifiedTaskInfo::getSystemId, (Object)updateTaskStatusDto.getSystemId());
            this.unifiedTaskInfoServiceImpl.remove((Wrapper)taskDeleteWrapper);
            LambdaQueryWrapper queryParentTaskWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryParentTaskWrapper.eq(UnifiedTaskInfo::getExtra1, (Object)updateTaskStatusDto.getParentTaskId())).eq(UnifiedTaskInfo::getSystemId, (Object)updateTaskStatusDto.getSystemId());
            List fatherTaskList = this.unifiedTaskInfoServiceImpl.list((Wrapper)queryParentTaskWrapper);
            if (fatherTaskList.isEmpty()) {
                LambdaUpdateWrapper updateFatherTaskList = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateFatherTaskList.eq(UnifiedTaskInfo::getTaskId, (Object)updateTaskStatusDto.getParentTaskId())).eq(UnifiedTaskInfo::getSystemId, (Object)updateTaskStatusDto.getSystemId())).eq(UnifiedTaskInfo::getTaskState, (Object)"4")).set(UnifiedTaskInfo::getTaskState, (Object)"8");
                this.unifiedTaskInfoServiceImpl.update((Wrapper)updateFatherTaskList);
            }
            return ApiResponse.success((String)"\u5df2\u5206\u6d3e\u4efb\u52a1\uff0c\u529e\u7406\u6210\u529f");
        }
        UnifiedTaskdoneInfo updateTaskState = new UnifiedTaskdoneInfo();
        updateTaskState.setTaskState("0");
        LambdaQueryWrapper updateTaskStateWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)updateTaskStateWrapper.eq(UnifiedTaskdoneInfo::getProcessInstanceid, (Object)updateTaskStatusDto.getProcessInstanceid())).eq(UnifiedTaskdoneInfo::getUserId, (Object)updateTaskStatusDto.getUserId());
        this.unifiedTaskdoneInfoServiceImpl.update((Object)updateTaskState, (Wrapper)updateTaskStateWrapper);
        this.unifiedTaskdoneInfoServiceImpl.complateTask(updateTaskStatusDto);
        LambdaQueryWrapper taskDeleteWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)taskDeleteWrapper.eq(UnifiedTaskInfo::getTaskId, (Object)updateTaskStatusDto.getTaskId())).eq(UnifiedTaskInfo::getSystemId, (Object)updateTaskStatusDto.getSystemId());
        this.unifiedTaskInfoServiceImpl.remove((Wrapper)taskDeleteWrapper);
        return ApiResponse.success((String)"\u4efb\u52a1\u529e\u7406\u6210\u529f");
    }

    public ApiResponse<String> updateUserStatus(UnifiedTaskUser unifiedTaskUser) {
        return ApiResponse.success();
    }

    public ApiResponse<String> updateTaskUser(UpdateTaskUserDto updateTaskUserDto) {
        if (ToolUtil.isEmpty((Object)updateTaskUserDto.getChangeUserId())) {
            return ApiResponse.fail((String)"\u88ab\u8f6c\u529e\u4eba\u4e3a\u7a7a");
        }
        String[] changeUserIds = updateTaskUserDto.getChangeUserId().split(",");
        if (changeUserIds.length == 1) {
            LambdaUpdateWrapper updateUserWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateUserWrapper.eq(UnifiedTaskInfo::getTaskId, (Object)updateTaskUserDto.getTaskId())).eq(UnifiedTaskInfo::getSystemId, (Object)updateTaskUserDto.getSystemId())).eq(UnifiedTaskInfo::getUserId, (Object)updateTaskUserDto.getUserId())).set(UnifiedTaskInfo::getUserId, (Object)updateTaskUserDto.getChangeUserId());
            boolean update = this.unifiedTaskInfoServiceImpl.update((Wrapper)updateUserWrapper);
            if (update) {
                return ApiResponse.success((String)("\u8f6c\u529e\u6210\u529f\uff0c\u5c06\u4efb\u52a1\u8f6c\u529e\u7ed9" + changeUserIds.length + "\u4eba"));
            }
            return ApiResponse.fail((String)"\u8f6c\u529e\u4eba\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(UnifiedTaskInfo::getTaskId, (Object)updateTaskUserDto.getTaskId())).eq(UnifiedTaskInfo::getSystemId, (Object)updateTaskUserDto.getSystemId())).eq(UnifiedTaskInfo::getUserId, (Object)updateTaskUserDto.getUserId())).eq(UnifiedTaskInfo::getTaskType, (Object)updateTaskUserDto.getTaskType());
        List taskInfoList = this.unifiedTaskInfoServiceImpl.list((Wrapper)wrapper);
        if (ToolUtil.isEmpty((Object)taskInfoList)) {
            return ApiResponse.fail((String)"\u8f6c\u529e\u4eba\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        this.unifiedTaskInfoServiceImpl.remove((Wrapper)wrapper);
        ArrayList<UnifiedTaskInfo> unifiedTaskInfos = new ArrayList<UnifiedTaskInfo>();
        try {
            for (String changeUserId : changeUserIds) {
                UnifiedTaskInfo taskInfo = ((UnifiedTaskInfo)taskInfoList.get(0)).clone();
                taskInfo.setUserId(changeUserId);
                unifiedTaskInfos.add(taskInfo);
            }
            this.unifiedTaskInfoServiceImpl.saveBatch(unifiedTaskInfos);
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return ApiResponse.success((String)("\u8f6c\u529e\u6210\u529f\uff0c\u5c06\u4efb\u52a1\u8f6c\u529e\u7ed9" + changeUserIds.length + "\u4eba"));
    }

    public ApiResponse<IPage<UnifiedSystemInfo>> getListSystem(Page<UnifiedSystemInfo> page, String tenantId) {
        return ApiResponse.success();
    }

    public ApiResponse<String> addTaskUser(UpdateTaskUserDto updateTaskUserDto) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(UnifiedTaskInfo::getTaskId, (Object)updateTaskUserDto.getTaskId())).eq(UnifiedTaskInfo::getSystemId, (Object)updateTaskUserDto.getSystemId());
        UnifiedTaskInfo taskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoServiceImpl.list((Wrapper)wrapper).get(0);
        for (String userId : updateTaskUserDto.getAddUserIds()) {
            taskInfo.setUserId(userId);
            taskInfo.setTaskType(updateTaskUserDto.getTaskType());
            this.unifiedTaskInfoServiceImpl.save((Object)taskInfo);
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> deleteTaskUser(List<UnifiedTaskUser> unifiedTaskUsers) {
        return ApiResponse.success();
    }

    public ApiResponse<String> updateAllTaskUser(UpdateAllTaskUserDto updateAllTaskUserDto) {
        LambdaQueryWrapper deleteWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)deleteWrapper.eq(UnifiedTaskInfo::getTaskId, (Object)updateAllTaskUserDto.getTaskId())).eq(UnifiedTaskInfo::getSystemId, (Object)updateAllTaskUserDto.getSystemId())).eq(UnifiedTaskInfo::getTaskType, (Object)updateAllTaskUserDto.getTaskType());
        List taskInfoList = this.unifiedTaskInfoServiceImpl.list((Wrapper)deleteWrapper);
        if (taskInfoList.size() == 0) {
            return ApiResponse.fail((String)"\u8be5\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        this.unifiedTaskInfoServiceImpl.remove((Wrapper)deleteWrapper);
        if (this.elasticSearchConfig.isEnableElasticsearch().equals(Boolean.TRUE)) {
            for (UnifiedTaskInfo unifiedTaskInfo : taskInfoList) {
                ESUtils.deleteDoc((String)"sys_unified_task_info", (String)unifiedTaskInfo.getTodoId().toString());
            }
        }
        UnifiedTaskInfo taskInfo = (UnifiedTaskInfo)taskInfoList.get(0);
        for (String userId : updateAllTaskUserDto.getChangeUserId()) {
            taskInfo.setTodoId(null);
            taskInfo.setUserId(userId);
            this.unifiedTaskInfoServiceImpl.save((Object)taskInfo);
            if (!this.elasticSearchConfig.isEnableElasticsearch().equals(Boolean.TRUE)) continue;
            ESUtils.saveDoc((String)"sys_unified_task_info", (String)taskInfo.getTodoId().toString(), (Object)taskInfo);
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> acceptTask(AcceptTaskDto acceptTaskDto) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(UnifiedTaskInfo::getTaskId, (Object)acceptTaskDto.getTaskId())).eq(UnifiedTaskInfo::getSystemId, (Object)acceptTaskDto.getSystemId());
        UnifiedTaskInfo taskInfo = new UnifiedTaskInfo();
        taskInfo.setTaskState("9");
        this.unifiedTaskInfoServiceImpl.update((Object)taskInfo, (Wrapper)wrapper);
        wrapper.eq(UnifiedTaskInfo::getUserId, (Object)acceptTaskDto.getAcceptUser());
        if ("0".equals(acceptTaskDto.getTaskState())) {
            taskInfo.setTaskState("1");
            taskInfo.setAcceptTime(ToolUtil.isNotEmpty((Object)acceptTaskDto.getAcceptTime()) ? acceptTaskDto.getAcceptTime() : new Date());
            this.unifiedTaskInfoServiceImpl.update((Object)taskInfo, (Wrapper)wrapper);
            return ApiResponse.success((String)"\u5df2\u5206\u6d3e\u5f85\u529e\uff0c\u53d7\u7406\u6210\u529f");
        }
        taskInfo.setTaskState("8");
        taskInfo.setAcceptTime(ToolUtil.isNotEmpty((Object)acceptTaskDto.getAcceptTime()) ? acceptTaskDto.getAcceptTime() : new Date());
        this.unifiedTaskInfoServiceImpl.update((Object)taskInfo, (Wrapper)wrapper);
        return ApiResponse.success((String)"\u5f85\u529e\u4efb\u52a1\uff0c\u53d7\u7406\u6210\u529f");
    }

    public ApiResponse<String> releaseTask(AcceptTaskDto acceptTaskDto) {
        if ("1".equals(acceptTaskDto.getTaskState())) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(UnifiedTaskInfo::getTaskId, (Object)acceptTaskDto.getTaskId())).eq(UnifiedTaskInfo::getSystemId, (Object)acceptTaskDto.getSystemId())).set(UnifiedTaskInfo::getTaskState, (Object)"0")).set(UnifiedTaskInfo::getAcceptTime, null);
            this.unifiedTaskInfoServiceImpl.update(null, (Wrapper)wrapper);
            return ApiResponse.success((String)"\u5df2\u5206\u6d3e\u4efb\u52a1\uff0c\u91ca\u653e\u6210\u529f");
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(UnifiedTaskInfo::getTaskId, (Object)acceptTaskDto.getTaskId())).eq(UnifiedTaskInfo::getSystemId, (Object)acceptTaskDto.getSystemId())).set(UnifiedTaskInfo::getTaskState, (Object)"2")).set(UnifiedTaskInfo::getAcceptTime, null);
        this.unifiedTaskInfoServiceImpl.update(null, (Wrapper)wrapper);
        return ApiResponse.success((String)"\u4efb\u52a1\u91ca\u653e\u6210\u529f");
    }

    public ApiResponse<String> saveProcArchive(SaveArchiveDto saveArchiveDto) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(UnifiedProcArchive::getPiid, (Object)saveArchiveDto.getPiid());
        List list = this.unifiedProcArchiveService.list((Wrapper)wrapper);
        if (!list.isEmpty()) {
            return ApiResponse.fail((String)"\u8be5\u6d41\u7a0b\u5df2\u5f52\u6863");
        }
        this.unifiedProcArchiveService.save((Object)saveArchiveDto);
        return ApiResponse.success((String)"\u5f52\u6863\u6210\u529f");
    }

    public ApiResponse<String> updateProcArchive(SaveArchiveDto saveArchiveDto) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(UnifiedProcArchive::getPiid, (Object)saveArchiveDto.getPiid());
        this.unifiedProcArchiveService.update((Object)saveArchiveDto, (Wrapper)wrapper);
        return ApiResponse.success((String)"\u5f52\u6863\u4fe1\u606f\uff0c\u4fee\u6539\u6210\u529f");
    }

    public ApiResponse<String> updateTaskUser(String taskId, String systemId, String executeStatus, UpdateTaskUserToDoDto updateTaskUserToDoDto) {
        return null;
    }

    public ApiResponse<String> dispatchTask(SaveToDoDto saveToDoDto) {
        String[] taskIds;
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.eq(UnifiedTaskInfo::getTaskId, (Object)saveToDoDto.getExtra1())).eq(UnifiedTaskInfo::getSystemId, (Object)saveToDoDto.getSystemId())).eq(UnifiedTaskInfo::getTaskState, (Object)"8")).set(UnifiedTaskInfo::getTaskState, (Object)"4");
        boolean update = this.unifiedTaskInfoServiceImpl.update((Wrapper)updateWrapper);
        if (!update) {
            return ApiResponse.fail((String)"\u672a\u627e\u5230\u53ef\u5206\u6d3e\u4efb\u52a1");
        }
        String[] userIds = saveToDoDto.getUserId().split(",");
        if (userIds.length != (taskIds = saveToDoDto.getTaskId().split(",")).length) {
            return ApiResponse.fail((String)"taskId \u548c usrId \u4e2a\u6570\u4e0d\u5339\u914d");
        }
        try {
            ArrayList<UnifiedTaskInfo> taskInfos = new ArrayList<UnifiedTaskInfo>();
            for (int i = 0; i < userIds.length; ++i) {
                UnifiedTaskInfo taskInfo = saveToDoDto.clone();
                taskInfo.setTaskId(taskIds[i]);
                taskInfo.setUserId(userIds[i]);
                taskInfo.setTaskState("0");
                taskInfos.add(taskInfo);
            }
            this.unifiedTaskInfoServiceImpl.saveBatch(taskInfos);
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return ApiResponse.success((String)"\u4efb\u52a1\u5206\u6d3e\u6210\u529f");
    }

    public ApiResponse<String> startUpOrder(startUpOrderDto startUpOrderDto2) {
        UnifiedTaskInfo unifiedTaskInfo = startUpOrderDto2.getUnifiedTaskInfo();
        LinkedList<UnifiedTaskInfo> unifiedTaskInfoLinkedList = new LinkedList<UnifiedTaskInfo>();
        try {
            List<String> sendSmsProcessKeys;
            for (String userId : unifiedTaskInfo.getUserId().split(",")) {
                UnifiedTaskInfo taskInfo = unifiedTaskInfo.clone();
                taskInfo.setUserId(userId);
                taskInfo.setCreateTime(ToolUtil.isNotEmpty((Object)taskInfo.getCreateTime()) ? taskInfo.getCreateTime() : new Date());
                unifiedTaskInfoLinkedList.add(taskInfo);
            }
            logger.info("-------------------\u7edf\u4e00\u5f85\u529e{/unifiedtodo/startProcess}\u6b64\u6b21\u63d0\u4ea4\u4fdd\u5b58\u5f85\u529e\uff1a {}\u6761", (Object)unifiedTaskInfoLinkedList.size());
            this.unifiedTaskInfoServiceImpl.saveBatch(unifiedTaskInfoLinkedList);
            if (this.dataPushProperties.isSendSms() && (sendSmsProcessKeys = Arrays.asList(this.dataPushProperties.getSendSmsProcessKey().split(","))).contains(unifiedTaskInfo.getProcessDefinitionkey())) {
                TBpmSendSmsNow tBpmSendSmsNow = new TBpmSendSmsNow();
                tBpmSendSmsNow.setHtNameDes(unifiedTaskInfo.getTaskName());
                tBpmSendSmsNow.setPiid(unifiedTaskInfo.getProcessInstanceid());
                tBpmSendSmsNow.setTkiid(unifiedTaskInfo.getTaskId());
                tBpmSendSmsNow.setHtName(unifiedTaskInfo.getTaskDefinitionkey());
                tBpmSendSmsNow.setCreateTime(ToolUtil.isNotEmpty((Object)unifiedTaskInfo.getCreateTime()) ? unifiedTaskInfo.getCreateTime() : new Date());
                this.tBpmSendSmsNowService.save((Object)tBpmSendSmsNow);
            }
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        UnifiedProcArchive unifiedProcArchive = startUpOrderDto2.getUnifiedProcArchive();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(UnifiedProcArchive::getPiid, (Object)unifiedProcArchive.getPiid());
        List list = this.unifiedProcArchiveService.list((Wrapper)wrapper);
        if (!list.isEmpty()) {
            return ApiResponse.fail((String)"\u8be5\u6d41\u7a0b\u5df2\u5f52\u6863");
        }
        this.unifiedProcArchiveService.save((Object)unifiedProcArchive);
        return ApiResponse.success();
    }
}

