/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unifiedtodo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.unifiedtodo.dao.UnifiedSystemInfoMapper;
import com.jxdinfo.hussar.unifiedtodo.dao.UnifiedTaskInfoMapper;
import com.jxdinfo.hussar.unifiedtodo.dao.UnifiedTaskUserMapper;
import com.jxdinfo.hussar.unifiedtodo.exception.PublicClientException;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedSystemInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskUser;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedSystemInfoService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnifiedSystemInfoServiceImpl
extends HussarServiceImpl<UnifiedSystemInfoMapper, UnifiedSystemInfo>
implements IUnifiedSystemInfoService {
    @Autowired
    UnifiedSystemInfoMapper unifiedSystemInfoMapper;
    @Autowired
    UnifiedTaskInfoMapper unifiedTaskInfoMapper;
    @Autowired
    UnifiedTaskUserMapper unifiedTaskUserMapper;

    public ApiResponse<Page<UnifiedSystemInfo>> list(Page<UnifiedSystemInfo> page, String systemName) {
        String tenantId = Objects.requireNonNull(BaseSecurityUtil.getUser()).getStringTenantId();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (ToolUtil.isNotEmpty((Object)tenantId)) {
            wrapper.eq(UnifiedSystemInfo::getTenantId, (Object)tenantId);
        }
        if (StringUtils.isNotBlank((CharSequence)systemName)) {
            wrapper.like(UnifiedSystemInfo::getSystemName, (Object)systemName);
        }
        return ApiResponse.success((Object)this.unifiedSystemInfoMapper.selectPage((IPage)page, (Wrapper)wrapper));
    }

    public ApiResponse<String> saveSystem(UnifiedSystemInfo systemInfo) {
        if (HussarUtils.isEmpty((Object)BaseSecurityUtil.getUser())) {
            throw new PublicClientException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(UnifiedSystemInfo::getSystemName, (Object)systemInfo.getSystemName());
        if (this.unifiedSystemInfoMapper.selectOne((Wrapper)wrapper) != null) {
            return ApiResponse.fail((String)"\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u5e94\u7528\u540d\u79f0\u5df2\u5b58\u5728\uff09");
        }
        String tenantId = Objects.requireNonNull(BaseSecurityUtil.getUser()).getStringTenantId();
        systemInfo.setTenantId(tenantId);
        systemInfo.setSystemCipher(IdWorker.get32UUID());
        systemInfo.setCreateTime(new Date());
        String userAccount = BaseSecurityUtil.getUser().getAccount();
        systemInfo.setCreator(userAccount);
        int insert = this.unifiedSystemInfoMapper.insert(systemInfo);
        if (insert != 1) {
            return ApiResponse.fail((String)"\u65b0\u5e94\u7528\u6ce8\u518c\u5931\u8d25");
        }
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> update(UnifiedSystemInfo unifiedSystemInfo) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(UnifiedSystemInfo::getSystemName, (Object)unifiedSystemInfo.getSystemName())).ne(UnifiedSystemInfo::getSystemId, (Object)unifiedSystemInfo.getSystemId());
        UnifiedSystemInfo unifiedSystem = (UnifiedSystemInfo)this.unifiedSystemInfoMapper.selectOne((Wrapper)wrapper);
        if (unifiedSystem != null) {
            return ApiResponse.fail((String)"\u4fee\u6539\u5931\u8d25\uff01\uff08\u8be5\u5e94\u7528\u540d\u79f0\u5df2\u5b58\u5728\uff09");
        }
        int update = this.unifiedSystemInfoMapper.updateById(unifiedSystemInfo);
        if (update != 1) {
            return ApiResponse.fail((String)"\u5e94\u7528\u4fee\u6539\u5931\u8d25");
        }
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<UnifiedSystemInfo> detail(String systemId) {
        UnifiedSystemInfo systemInfo = (UnifiedSystemInfo)this.unifiedSystemInfoMapper.selectById((Serializable)((Object)systemId));
        if (systemInfo == null) {
            return ApiResponse.fail((String)"\u83b7\u53d6\u5e94\u7528\u8be6\u60c5\u5931\u8d25");
        }
        return ApiResponse.success((Object)systemInfo);
    }

    public ApiResponse<String> resetCipher(String systemId) {
        UnifiedSystemInfo systemInfo = (UnifiedSystemInfo)this.unifiedSystemInfoMapper.selectById((Serializable)((Object)systemId));
        systemInfo.setSystemCipher(IdWorker.get32UUID());
        int update = this.unifiedSystemInfoMapper.updateById(systemInfo);
        if (update != 1) {
            return ApiResponse.fail((String)"\u91cd\u7f6e\u79d8\u94a5\u5931\u8d25");
        }
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<?> delete(String systemId) {
        LambdaQueryWrapper taskWrapper = new LambdaQueryWrapper();
        taskWrapper.eq(UnifiedTaskInfo::getSystemId, (Object)Long.parseLong(systemId));
        this.unifiedTaskInfoMapper.delete((Wrapper)taskWrapper);
        LambdaQueryWrapper userMapper = new LambdaQueryWrapper();
        userMapper.eq(UnifiedTaskUser::getSystemId, (Object)Long.parseLong(systemId));
        this.unifiedTaskUserMapper.delete((Wrapper)userMapper);
        int delete = this.unifiedSystemInfoMapper.deleteById((Serializable)((Object)systemId));
        if (delete != 1) {
            return ApiResponse.fail((String)"\u5220\u9664\u5e94\u7528\u5931\u8d25");
        }
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<List<Map<String, Object>>> querySystemNameList() {
        String tenantId = Objects.requireNonNull(BaseSecurityUtil.getUser()).getStringTenantId();
        List<Map<String, Object>> result = this.unifiedSystemInfoMapper.querySystemName(tenantId);
        return ApiResponse.success(result);
    }

    public ApiResponse<String> getSystemNameById(Long systemId) {
        UnifiedSystemInfo unifiedSystemInfo = (UnifiedSystemInfo)this.unifiedSystemInfoMapper.selectById(systemId);
        return ApiResponse.success((Object)unifiedSystemInfo.getSystemName(), (String)ResultCode.SUCCESS.getMessage());
    }
}

