/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unifiedtodo.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.unifiedtodo.config.ElasticSearchConfig;
import com.jxdinfo.hussar.unifiedtodo.dao.UnifiedToDoMapper;
import com.jxdinfo.hussar.unifiedtodo.dto.AcceptTaskDto;
import com.jxdinfo.hussar.unifiedtodo.dto.DeleteTaskDto;
import com.jxdinfo.hussar.unifiedtodo.dto.QueryToDoDto;
import com.jxdinfo.hussar.unifiedtodo.dto.SaveArchiveDto;
import com.jxdinfo.hussar.unifiedtodo.dto.SaveToDoDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UpdateAllTaskUserDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UpdateTaskStatusDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UpdateTaskUserDto;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedProcArchive;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedSystemInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskUser;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskdoneInfo;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedProcArchiveService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedSystemInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskUserService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskdoneInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedToDoService;
import com.jxdinfo.hussar.unifiedtodo.util.ESUtils;
import com.jxdinfo.hussar.unifiedtodo.vo.ToDoVo;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@DSTransactional
public class UnifiedToDoServiceImpl
implements IUnifiedToDoService {
    private static Logger logger = LoggerFactory.getLogger(UnifiedToDoServiceImpl.class);
    @Autowired
    private UnifiedToDoMapper unifiedToDoMapper;
    @Autowired
    private IUnifiedSystemInfoService unifiedSystemInfoServiceImpl;
    @Autowired
    private IUnifiedTaskInfoService unifiedTaskInfoServiceImpl;
    @Autowired
    private IUnifiedTaskdoneInfoService unifiedTaskdoneInfoServiceImpl;
    @Autowired
    private IUnifiedTaskUserService unifiedTaskUserServiceImpl;
    @Autowired
    private ElasticSearchConfig elasticSearchConfig;
    @Autowired
    private IUnifiedProcArchiveService unifiedProcArchiveService;

    public ApiResponse<Long> getCountTotal(String systemId, String userId, String executeStatus) {
        return ApiResponse.success();
    }

    public ApiResponse<String> saveTask(SaveToDoDto saveToDoDto) {
        LinkedList<UnifiedTaskInfo> unifiedTaskInfoLinkedList = new LinkedList<UnifiedTaskInfo>();
        try {
            for (String userId : saveToDoDto.getUserId().split(",")) {
                UnifiedTaskInfo taskInfo = saveToDoDto.clone();
                taskInfo.setUserId(userId);
                unifiedTaskInfoLinkedList.add(taskInfo);
            }
            logger.info("-------------------\u7edf\u4e00\u5f85\u529e{/unifiedtodo/saveTask}\u6b64\u6b21\u63d0\u4ea4\u4fdd\u5b58\u5f85\u529e\uff1a {}\u6761", (Object)unifiedTaskInfoLinkedList.size());
            this.unifiedTaskInfoServiceImpl.saveBatch(unifiedTaskInfoLinkedList);
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (this.elasticSearchConfig.isEnableElasticsearch().equals(Boolean.TRUE)) {
            for (UnifiedTaskInfo taskInfo : unifiedTaskInfoLinkedList) {
                ESUtils.saveDoc((String)"sys_unified_task_info", (String)taskInfo.getTodoId().toString(), (Object)taskInfo);
            }
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> updateTask(SaveToDoDto saveToDoDto) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(UnifiedTaskInfo::getTaskId, (Object)saveToDoDto.getTaskId())).eq(UnifiedTaskInfo::getSystemId, (Object)saveToDoDto.getSystemId())).eq(UnifiedTaskInfo::getUserId, (Object)saveToDoDto.getUserId())).eq(UnifiedTaskInfo::getTaskType, (Object)saveToDoDto.getTaskType());
        this.unifiedTaskInfoServiceImpl.update((Object)saveToDoDto, (Wrapper)wrapper);
        if (this.elasticSearchConfig.isEnableElasticsearch().booleanValue()) {
            List taskInfoList = this.unifiedTaskInfoServiceImpl.list((Wrapper)wrapper);
            for (UnifiedTaskInfo taskInfo : taskInfoList) {
                ESUtils.saveDoc((String)"sys_unified_task_info", (String)saveToDoDto.getTodoId().toString(), (Object)taskInfo);
            }
        }
        return ApiResponse.success();
    }

    public ApiResponse<IPage<SaveToDoDto>> getListTask(Page<SaveToDoDto> page, QueryToDoDto queryToDoDto) {
        queryToDoDto.setUserId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        return ApiResponse.success(this.unifiedToDoMapper.queryTaskList(page, queryToDoDto));
    }

    public ApiResponse<ToDoVo> getToDoByTaskId(String todoId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(UnifiedTaskInfo::getTodoId, (Object)Long.parseLong(todoId));
        UnifiedTaskInfo unifiedTaskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoServiceImpl.getOne((Wrapper)wrapper);
        ToDoVo toDoVo = (ToDoVo)JSON.parseObject((String)JSON.toJSONString((Object)unifiedTaskInfo), ToDoVo.class);
        LambdaQueryWrapper wrapperSystem = new LambdaQueryWrapper();
        wrapperSystem.eq(UnifiedSystemInfo::getSystemId, (Object)unifiedTaskInfo.getSystemId());
        toDoVo.setSystemAddress(((UnifiedSystemInfo)this.unifiedSystemInfoServiceImpl.getOne((Wrapper)wrapperSystem)).getSystemAddress());
        return ApiResponse.success();
    }

    public ApiResponse<String> deleteTask(DeleteTaskDto deleteTaskDto) {
        if (ToolUtil.isNotEmpty((Object)deleteTaskDto.getProcessInstanceId())) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper.eq(UnifiedTaskInfo::getSystemId, (Object)deleteTaskDto.getSystemId())).eq(UnifiedTaskInfo::getProcessInstanceid, (Object)deleteTaskDto.getProcessInstanceId());
            this.unifiedTaskInfoServiceImpl.remove((Wrapper)wrapper);
            if (this.elasticSearchConfig.isEnableElasticsearch().booleanValue()) {
                HashMap<String, Object> condition = new HashMap<String, Object>();
                condition.put("systemId", deleteTaskDto.getSystemId());
                condition.put("processInstanceid", deleteTaskDto.getProcessInstanceId());
                ESUtils.deleteByQuery((String)"sys_unified_task_info", condition);
            }
            return ApiResponse.success();
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(UnifiedTaskInfo::getTaskId, (Object)deleteTaskDto.getTaskId())).eq(UnifiedTaskInfo::getSystemId, (Object)deleteTaskDto.getSystemId());
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("taskId", deleteTaskDto.getTaskId());
        condition.put("systemId", deleteTaskDto.getSystemId().toString());
        if (ToolUtil.isNotEmpty((Object)deleteTaskDto.getUserId())) {
            wrapper.in(UnifiedTaskInfo::getUserId, (Collection)deleteTaskDto.getUserId());
            condition.put("userId", deleteTaskDto.getUserId());
        }
        this.unifiedTaskInfoServiceImpl.remove((Wrapper)wrapper);
        if (this.elasticSearchConfig.isEnableElasticsearch().booleanValue()) {
            ESUtils.deleteByQuery((String)"sys_unified_task_info", condition);
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> deleteDoneTask(DeleteTaskDto deleteTaskDto) {
        if (ToolUtil.isNotEmpty((Object)deleteTaskDto.getProcessInstanceId())) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(UnifiedTaskdoneInfo::getProcessInstanceid, (Object)deleteTaskDto.getProcessInstanceId());
            this.unifiedTaskdoneInfoServiceImpl.remove((Wrapper)wrapper);
            if (this.elasticSearchConfig.isEnableElasticsearch().booleanValue()) {
                HashMap<String, Object> condition = new HashMap<String, Object>();
                condition.put("systemId", deleteTaskDto.getSystemId());
                condition.put("processInstanceid", deleteTaskDto.getProcessInstanceId());
                ESUtils.deleteByQuery((String)"sys_unified_taskdone_info", condition);
            }
            return ApiResponse.success();
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(UnifiedTaskdoneInfo::getTaskId, (Object)deleteTaskDto.getTaskId())).eq(UnifiedTaskdoneInfo::getSystemId, (Object)deleteTaskDto.getSystemId());
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("taskId", deleteTaskDto.getTaskId());
        condition.put("systemId", deleteTaskDto.getSystemId().toString());
        if (ToolUtil.isNotEmpty((Object)deleteTaskDto.getUserId())) {
            wrapper.in(UnifiedTaskdoneInfo::getUserId, (Collection)deleteTaskDto.getUserId());
            condition.put("userId", deleteTaskDto.getUserId());
        }
        this.unifiedTaskdoneInfoServiceImpl.remove((Wrapper)wrapper);
        if (this.elasticSearchConfig.isEnableElasticsearch().booleanValue()) {
            ESUtils.deleteByQuery((String)"sys_unified_taskdone_info", condition);
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> updateTaskStatus(UpdateTaskStatusDto updateTaskStatusDto) {
        LambdaQueryWrapper taskWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)taskWrapper.eq(UnifiedTaskInfo::getTaskId, (Object)updateTaskStatusDto.getTaskId())).eq(UnifiedTaskInfo::getSystemId, (Object)updateTaskStatusDto.getSystemId())).eq(UnifiedTaskInfo::getUserId, (Object)updateTaskStatusDto.getUserId())).eq(UnifiedTaskInfo::getTaskType, (Object)"0");
        List taskInfoList = this.unifiedTaskInfoServiceImpl.list((Wrapper)taskWrapper);
        if (ToolUtil.isEmpty((Object)taskInfoList)) {
            return ApiResponse.fail((String)"\u6b64\u6761\u5f85\u529e\u4e0d\u5b58\u5728");
        }
        UnifiedTaskdoneInfo taskdoneInfo = new UnifiedTaskdoneInfo();
        try {
            BeanUtils.copyProperties(taskInfoList.get(0), (Object)taskdoneInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        taskdoneInfo.setEndTime(ToolUtil.isEmpty((Object)updateTaskStatusDto.getEndTime()) ? new Date() : updateTaskStatusDto.getEndTime());
        taskdoneInfo.setWebLinkurl(ToolUtil.isEmpty((Object)updateTaskStatusDto.getWebLinkUrl()) ? taskdoneInfo.getWebLinkurl() : updateTaskStatusDto.getWebLinkUrl());
        taskdoneInfo.setMobileLinkurl(ToolUtil.isEmpty((Object)updateTaskStatusDto.getMobileLinkUrl()) ? taskdoneInfo.getMobileLinkurl() : updateTaskStatusDto.getMobileLinkUrl());
        this.unifiedTaskdoneInfoServiceImpl.save((Object)taskdoneInfo);
        if (this.elasticSearchConfig.isEnableElasticsearch().booleanValue()) {
            ESUtils.saveDoc((String)"sys_unified_taskdone_info", (String)taskdoneInfo.getTodoId().toString(), (Object)taskdoneInfo);
        }
        LambdaQueryWrapper taskDeleteWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)taskDeleteWrapper.eq(UnifiedTaskInfo::getTaskId, (Object)updateTaskStatusDto.getTaskId())).eq(UnifiedTaskInfo::getSystemId, (Object)updateTaskStatusDto.getSystemId());
        this.unifiedTaskInfoServiceImpl.remove((Wrapper)taskDeleteWrapper);
        if (this.elasticSearchConfig.isEnableElasticsearch().booleanValue()) {
            HashMap<String, Object> condition = new HashMap<String, Object>();
            condition.put("taskId", updateTaskStatusDto.getTaskId());
            condition.put("systemId", updateTaskStatusDto.getSystemId());
            ESUtils.deleteByQuery((String)"sys_unified_task_info", condition);
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> updateUserStatus(UnifiedTaskUser unifiedTaskUser) {
        return ApiResponse.success();
    }

    public ApiResponse<String> updateTaskUser(UpdateTaskUserDto updateTaskUserDto) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(UnifiedTaskInfo::getSystemId, (Object)updateTaskUserDto.getSystemId())).eq(UnifiedTaskInfo::getTaskId, (Object)updateTaskUserDto.getTaskId())).eq(UnifiedTaskInfo::getUserId, (Object)updateTaskUserDto.getUserId())).eq(UnifiedTaskInfo::getTaskType, (Object)updateTaskUserDto.getTaskType());
        UnifiedTaskInfo taskInfo = new UnifiedTaskInfo();
        taskInfo.setUserId(updateTaskUserDto.getChangeUserId());
        List taskInfoList = this.unifiedTaskInfoServiceImpl.list((Wrapper)wrapper);
        this.unifiedTaskInfoServiceImpl.update((Object)taskInfo, (Wrapper)wrapper);
        if (this.elasticSearchConfig.isEnableElasticsearch().equals(Boolean.TRUE)) {
            for (UnifiedTaskInfo task : taskInfoList) {
                task.setUserId(updateTaskUserDto.getChangeUserId());
                ESUtils.saveDoc((String)"sys_unified_task_info", (String)task.getTodoId().toString(), (Object)task);
            }
        }
        return ApiResponse.success();
    }

    public ApiResponse<IPage<UnifiedSystemInfo>> getListSystem(Page<UnifiedSystemInfo> page, String tenantId) {
        return ApiResponse.success();
    }

    public ApiResponse<String> addTaskUser(UpdateTaskUserDto updateTaskUserDto) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(UnifiedTaskInfo::getSystemId, (Object)updateTaskUserDto.getSystemId())).eq(UnifiedTaskInfo::getTaskId, (Object)updateTaskUserDto.getTaskId());
        UnifiedTaskInfo taskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoServiceImpl.list((Wrapper)wrapper).get(0);
        for (String userId : updateTaskUserDto.getAddUserIds()) {
            taskInfo.setUserId(userId);
            taskInfo.setTaskType(updateTaskUserDto.getTaskType());
            this.unifiedTaskInfoServiceImpl.save((Object)taskInfo);
        }
        if (this.elasticSearchConfig.isEnableElasticsearch().equals(Boolean.TRUE)) {
            ESUtils.saveDoc((String)"sys_unified_task_info", (String)taskInfo.getTodoId().toString(), (Object)taskInfo);
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> deleteTaskUser(List<UnifiedTaskUser> unifiedTaskUsers) {
        return ApiResponse.success();
    }

    public ApiResponse<String> updateAllTaskUser(UpdateAllTaskUserDto updateAllTaskUserDto) {
        LambdaQueryWrapper deleteWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)deleteWrapper.eq(UnifiedTaskInfo::getSystemId, (Object)updateAllTaskUserDto.getSystemId())).eq(UnifiedTaskInfo::getTaskId, (Object)updateAllTaskUserDto.getTaskId())).eq(UnifiedTaskInfo::getTaskType, (Object)updateAllTaskUserDto.getTaskType());
        List taskInfoList = this.unifiedTaskInfoServiceImpl.list((Wrapper)deleteWrapper);
        if (taskInfoList.size() == 0) {
            return ApiResponse.fail((String)"\u8be5\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        this.unifiedTaskInfoServiceImpl.remove((Wrapper)deleteWrapper);
        if (this.elasticSearchConfig.isEnableElasticsearch().equals(Boolean.TRUE)) {
            for (UnifiedTaskInfo unifiedTaskInfo : taskInfoList) {
                ESUtils.deleteDoc((String)"sys_unified_task_info", (String)unifiedTaskInfo.getTodoId().toString());
            }
        }
        UnifiedTaskInfo taskInfo = (UnifiedTaskInfo)taskInfoList.get(0);
        for (String userId : updateAllTaskUserDto.getChangeUserId()) {
            taskInfo.setTodoId(null);
            taskInfo.setUserId(userId);
            this.unifiedTaskInfoServiceImpl.save((Object)taskInfo);
            if (!this.elasticSearchConfig.isEnableElasticsearch().equals(Boolean.TRUE)) continue;
            ESUtils.saveDoc((String)"sys_unified_task_info", (String)taskInfo.getTodoId().toString(), (Object)taskInfo);
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> acceptTask(AcceptTaskDto acceptTaskDto) {
        List taskInfoList;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(UnifiedTaskInfo::getSystemId, (Object)acceptTaskDto.getSystemId())).eq(UnifiedTaskInfo::getTaskId, (Object)acceptTaskDto.getTaskId())).eq(UnifiedTaskInfo::getTaskType, (Object)"0");
        UnifiedTaskInfo taskInfo = new UnifiedTaskInfo();
        taskInfo.setTaskState("9");
        this.unifiedTaskInfoServiceImpl.update((Object)taskInfo, (Wrapper)wrapper);
        if (this.elasticSearchConfig.isEnableElasticsearch().equals(Boolean.TRUE)) {
            taskInfoList = this.unifiedTaskInfoServiceImpl.list((Wrapper)wrapper);
            for (UnifiedTaskInfo info : taskInfoList) {
                taskInfo.setTaskState("9");
                ESUtils.saveDoc((String)"sys_unified_task_info", (String)info.getTodoId().toString(), (Object)info);
            }
        }
        wrapper.eq(UnifiedTaskInfo::getUserId, (Object)acceptTaskDto.getAcceptUser());
        taskInfo.setTaskState("8");
        this.unifiedTaskInfoServiceImpl.update((Object)taskInfo, (Wrapper)wrapper);
        if (this.elasticSearchConfig.isEnableElasticsearch().equals(Boolean.TRUE)) {
            taskInfoList = this.unifiedTaskInfoServiceImpl.list((Wrapper)wrapper);
            for (UnifiedTaskInfo info : taskInfoList) {
                taskInfo.setTaskState("8");
                ESUtils.saveDoc((String)"sys_unified_task_info", (String)info.getTodoId().toString(), (Object)info);
            }
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> releaseTask(AcceptTaskDto acceptTaskDto) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(UnifiedTaskInfo::getSystemId, (Object)acceptTaskDto.getSystemId())).eq(UnifiedTaskInfo::getTaskId, (Object)acceptTaskDto.getTaskId())).eq(UnifiedTaskInfo::getTaskType, (Object)"0");
        UnifiedTaskInfo taskInfo = new UnifiedTaskInfo();
        taskInfo.setTaskState("2");
        this.unifiedTaskInfoServiceImpl.update((Object)taskInfo, (Wrapper)wrapper);
        if (this.elasticSearchConfig.isEnableElasticsearch().equals(Boolean.TRUE)) {
            List taskInfoList = this.unifiedTaskInfoServiceImpl.list((Wrapper)wrapper);
            for (UnifiedTaskInfo info : taskInfoList) {
                taskInfo.setTaskState("2");
                ESUtils.saveDoc((String)"sys_unified_task_info", (String)info.getTodoId().toString(), (Object)info);
            }
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> saveProcArchive(SaveArchiveDto saveArchiveDto) {
        this.unifiedProcArchiveService.save((Object)saveArchiveDto);
        return ApiResponse.success();
    }

    public ApiResponse<String> updateProcArchive(SaveArchiveDto saveArchiveDto) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(UnifiedProcArchive::getPiid, (Object)saveArchiveDto.getPiid());
        this.unifiedProcArchiveService.update((Object)saveArchiveDto, (Wrapper)wrapper);
        return ApiResponse.success();
    }
}

