/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unifiedtodo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.unifiedtodo.dao.UnifiedSystemInfoMapper;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedSystemInfo;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedSystemInfoService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnifiedSystemInfoServiceImpl
extends HussarServiceImpl<UnifiedSystemInfoMapper, UnifiedSystemInfo>
implements IUnifiedSystemInfoService {
    @Autowired
    UnifiedSystemInfoMapper unifiedSystemInfoMapper;

    public ApiResponse<IPage<UnifiedSystemInfo>> list(Page<UnifiedSystemInfo> page, String systemName) {
        String tenantId = Objects.requireNonNull(BaseSecurityUtil.getUser()).getTenantId();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (ToolUtil.isNotEmpty((Object)tenantId)) {
            wrapper.eq(UnifiedSystemInfo::getTenantId, (Object)tenantId);
        }
        if (StringUtils.isNotBlank((CharSequence)systemName)) {
            wrapper.like(UnifiedSystemInfo::getSystemName, (Object)systemName);
        }
        return ApiResponse.success((Object)this.unifiedSystemInfoMapper.selectPage((IPage)page, (Wrapper)wrapper));
    }

    public ApiResponse<String> saveSystem(UnifiedSystemInfo systemInfo) {
        String tenantId = Objects.requireNonNull(BaseSecurityUtil.getUser()).getTenantId();
        systemInfo.setTenantId(tenantId);
        systemInfo.setSystemCipher(IdWorker.get32UUID());
        systemInfo.setCreateTime(new Date());
        int insert = this.unifiedSystemInfoMapper.insert(systemInfo);
        if (insert != 1) {
            return ApiResponse.fail((String)"\u65b0\u5e94\u7528\u6ce8\u518c\u5931\u8d25");
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> update(UnifiedSystemInfo unifiedSystemInfo) {
        int update = this.unifiedSystemInfoMapper.updateById(unifiedSystemInfo);
        if (update != 1) {
            return ApiResponse.fail((String)"\u5e94\u7528\u4fee\u6539\u5931\u8d25");
        }
        return ApiResponse.success();
    }

    public ApiResponse<UnifiedSystemInfo> detail(String systemId) {
        UnifiedSystemInfo systemInfo = (UnifiedSystemInfo)this.unifiedSystemInfoMapper.selectById((Serializable)((Object)systemId));
        if (systemInfo == null) {
            return ApiResponse.fail((String)"\u83b7\u53d6\u5e94\u7528\u8be6\u60c5\u5931\u8d25");
        }
        return ApiResponse.success((Object)systemInfo);
    }

    public ApiResponse<String> resetCipher(String systemId) {
        UnifiedSystemInfo systemInfo = (UnifiedSystemInfo)this.unifiedSystemInfoMapper.selectById((Serializable)((Object)systemId));
        systemInfo.setSystemCipher(IdWorker.get32UUID());
        int update = this.unifiedSystemInfoMapper.updateById(systemInfo);
        if (update != 1) {
            return ApiResponse.fail((String)"\u91cd\u7f6e\u79d8\u94a5\u5931\u8d25");
        }
        return ApiResponse.success();
    }

    public ApiResponse<?> delete(String systemId) {
        int delete = this.unifiedSystemInfoMapper.deleteById((Serializable)((Object)systemId));
        if (delete != 1) {
            return ApiResponse.fail((String)"\u5220\u9664\u5e94\u7528\u5931\u8d25");
        }
        return ApiResponse.success();
    }

    public ApiResponse<List<Map<Long, String>>> querySystemNameList() {
        String tenantId = Objects.requireNonNull(BaseSecurityUtil.getUser()).getTenantId();
        List<Map<Long, String>> result = this.unifiedSystemInfoMapper.querySystemName(tenantId);
        return ApiResponse.success(result);
    }
}

