/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unifiedtodo.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.vo.StaffBo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.unifiedtodo.dao.UnifiedSystemInfoMapper;
import com.jxdinfo.hussar.unifiedtodo.dao.UnifiedToDoMapper;
import com.jxdinfo.hussar.unifiedtodo.dto.CountQueryDto;
import com.jxdinfo.hussar.unifiedtodo.dto.QueryToDoDto;
import com.jxdinfo.hussar.unifiedtodo.dto.SaveProcessHtszDto;
import com.jxdinfo.hussar.unifiedtodo.dto.SaveToDoDto;
import com.jxdinfo.hussar.unifiedtodo.dto.SaveToDoHtszDto;
import com.jxdinfo.hussar.unifiedtodo.dto.TransferTaskDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UpdateTaskStatusHtszDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UpdateTaskUserToDoHtszDto;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedCategoryInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedLog;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedStartTask;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedSystemInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskInfo;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskUser;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedCategoryInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedCategoryTypeService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedStartTaskService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedSystemInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskInfoService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedTaskUserService;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedToDoHtszService;
import com.jxdinfo.hussar.unifiedtodo.service.UnifiedLogService;
import com.jxdinfo.hussar.unifiedtodo.vo.CountQueryVo;
import com.jxdinfo.hussar.unifiedtodo.vo.ToDoVo;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class UnifiedToDoHtszServiceImpl
implements IUnifiedToDoHtszService {
    @Resource
    private UnifiedToDoMapper unifiedToDoMapper;
    @Autowired
    private IUnifiedSystemInfoService unifiedSystemInfoServiceImpl;
    @Autowired
    private IUnifiedTaskInfoService unifiedTaskInfoServiceImpl;
    @Autowired
    private IUnifiedTaskUserService unifiedTaskUserServiceImpl;
    @Autowired
    private IUnifiedTaskUserService unifiedTaskUserService;
    @Autowired
    private IUnifiedStartTaskService unifiedStartTaskServiceImpl;
    @Resource
    private IUnifiedCategoryTypeService unifiedCategoryTypeService;
    @Resource
    private IUnifiedCategoryInfoService unifiedCategoryInfoService;
    @Resource
    UnifiedSystemInfoMapper unifiedSystemInfoMapper;
    @Autowired
    private UnifiedLogService unifiedLogService;
    private static final Logger logger = LoggerFactory.getLogger(UnifiedToDoHtszServiceImpl.class);

    public ApiResponse<JSONObject> countAllTotal(String systemId, String userId) {
        return this.countAllTotal(new CountQueryDto(systemId, userId));
    }

    public ApiResponse<JSONObject> countAllTotal(CountQueryDto countQueryDto) {
        boolean isEmptyResult;
        JSONObject jsonObject = new JSONObject();
        boolean bl = isEmptyResult = countQueryDto.getProcessDefinitionKey() != null && countQueryDto.getProcessDefinitionKey().isEmpty();
        if (!isEmptyResult && HussarUtils.isNotEmpty((Object)countQueryDto.getCategoryId())) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(UnifiedCategoryInfo::getCategoryTypeId, (Object)countQueryDto.getCategoryId());
            List list = this.unifiedCategoryInfoService.list((Wrapper)lambdaQueryWrapper);
            List processKeyList = list.stream().map(UnifiedCategoryInfo::getCategoryAttribute).collect(Collectors.toList());
            if (countQueryDto.getProcessDefinitionKey() != null) {
                countQueryDto.getProcessDefinitionKey().retainAll(processKeyList);
            } else {
                countQueryDto.setProcessDefinitionKey(processKeyList);
            }
            isEmptyResult = countQueryDto.getProcessDefinitionKey() != null && countQueryDto.getProcessDefinitionKey().isEmpty();
        }
        ArrayList<String> userIds = new ArrayList<String>();
        userIds.add(countQueryDto.getUserId());
        Map<String, Object> userIdCardsMap = this.getUserIdListByUserIdCars(userIds);
        if (userIdCardsMap.containsKey(countQueryDto.getUserId())) {
            StaffBo bo = (StaffBo)userIdCardsMap.get(countQueryDto.getUserId());
            countQueryDto.setUserId(String.valueOf(bo.getId()));
        }
        if (isEmptyResult) {
            jsonObject.put("todo", (Object)0);
            jsonObject.put("done", (Object)0);
            jsonObject.put("cc", (Object)0);
            jsonObject.put("urge", (Object)0);
            jsonObject.put("start", (Object)0);
            if (countQueryDto.isCountGroupBySystemId()) {
                jsonObject.put("systemCountInfo", new ArrayList());
            }
            return ApiResponse.success((Object)jsonObject);
        }
        if (countQueryDto.isCountGroupBySystemId()) {
            List list = this.unifiedToDoMapper.countAllTotalWithGroup(countQueryDto);
            List startCountList = this.unifiedToDoMapper.countStartTaskWithGroup(countQueryDto);
            HashMap<String, CountQueryVo> map = new HashMap<String, CountQueryVo>();
            for (CountQueryVo countQueryVo : startCountList) {
                map.put(countQueryVo.getSystemId(), countQueryVo);
            }
            CountQueryVo countAll = new CountQueryVo();
            for (CountQueryVo countQueryVo : list) {
                CountQueryVo startCount = (CountQueryVo)map.remove(countQueryVo.getSystemId());
                countAll.setTodo(countAll.getTodo() + countQueryVo.getTodo());
                countAll.setDone(countAll.getDone() + countQueryVo.getDone());
                countAll.setCc(countAll.getCc() + countQueryVo.getCc());
                countAll.setUrge(countAll.getUrge() + countQueryVo.getUrge());
                if (startCount == null) continue;
                countQueryVo.setStarted(startCount.getStarted());
                countAll.setStarted(countAll.getStarted() + countQueryVo.getStarted());
            }
            if (!map.isEmpty()) {
                for (CountQueryVo countQueryVo : map.values()) {
                    countAll.setStarted(countAll.getStarted() + countQueryVo.getStarted());
                    list.add(countQueryVo);
                }
            }
            list.sort(Comparator.comparing(CountQueryVo::getSystemId));
            jsonObject.put("todo", (Object)countAll.getTodo());
            jsonObject.put("done", (Object)countAll.getDone());
            jsonObject.put("cc", (Object)countAll.getCc());
            jsonObject.put("urge", (Object)countAll.getUrge());
            jsonObject.put("start", (Object)countAll.getStarted());
            jsonObject.put("systemCountInfo", (Object)list);
        } else {
            CountQueryVo countQueryVo = this.unifiedToDoMapper.countAllTotal(countQueryDto);
            CountQueryVo startQueryVo = this.unifiedToDoMapper.countStartTask(countQueryDto);
            jsonObject.put("todo", (Object)countQueryVo.getTodo());
            jsonObject.put("done", (Object)countQueryVo.getDone());
            jsonObject.put("cc", (Object)countQueryVo.getCc());
            jsonObject.put("urge", (Object)countQueryVo.getUrge());
            jsonObject.put("start", (Object)startQueryVo.getStarted());
        }
        return ApiResponse.success((Object)jsonObject);
    }

    public ApiResponse<String> saveTask(SaveToDoHtszDto saveToDoDto) {
        UnifiedLog unifiedLog = new UnifiedLog();
        if (HussarUtils.isNotEmpty((Object)saveToDoDto.getLogId())) {
            unifiedLog.setLogId(Long.valueOf(saveToDoDto.getLogId()));
        }
        unifiedLog.setPathName("/unified/unifiedExternal/saveTask");
        unifiedLog.setStartTime(LocalDateTime.now());
        unifiedLog.setParameter(JSON.toJSONString((Object)saveToDoDto, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
        UnifiedSystemInfo systemInfo = (UnifiedSystemInfo)this.unifiedSystemInfoMapper.selectById((Serializable)((Object)saveToDoDto.getSystemId().toString()));
        unifiedLog.setSystemName(systemInfo.getSystemName());
        unifiedLog.setSystemSource(systemInfo.getSystemSource());
        unifiedLog.setSystemId(saveToDoDto.getSystemId());
        try {
            StaffBo bo;
            StaffBo bo2;
            List executors = saveToDoDto.getExecutors();
            List followers = saveToDoDto.getFollowers();
            String taskStatus = ToolUtil.isNotEmpty((Object)saveToDoDto.getTaskStatus()) ? saveToDoDto.getTaskStatus() : "0";
            saveToDoDto.setTaskStatus(taskStatus);
            ArrayList<String> userIds = new ArrayList<String>();
            userIds.add(saveToDoDto.getCreateUserId());
            userIds.add(saveToDoDto.getSendUserId());
            userIds.add(saveToDoDto.getMandator());
            for (UnifiedTaskUser executor : executors) {
                userIds.add(executor.getUserId());
                userIds.add(executor.getMandator());
            }
            for (UnifiedTaskUser follower : followers) {
                userIds.add(follower.getUserId());
                userIds.add(follower.getMandator());
            }
            Map<String, Object> userIdCardsMap = this.getUserIdListByUserIdCars(userIds);
            if (userIdCardsMap.containsKey(saveToDoDto.getCreateUserId())) {
                bo2 = (StaffBo)userIdCardsMap.get(saveToDoDto.getCreateUserId());
                saveToDoDto.setCreateUserId(String.valueOf(bo2.getId()));
                saveToDoDto.setCreateUserName(bo2.getStaffName());
            }
            if (userIdCardsMap.containsKey(saveToDoDto.getSendUserId())) {
                bo2 = (StaffBo)userIdCardsMap.get(saveToDoDto.getSendUserId());
                saveToDoDto.setSendUserId(String.valueOf(bo2.getId()));
                saveToDoDto.setSendUserName(bo2.getStaffName());
            }
            for (UnifiedTaskUser executor : executors) {
                if (userIdCardsMap.containsKey(executor.getUserId())) {
                    bo = (StaffBo)userIdCardsMap.get(executor.getUserId());
                    executor.setUserId(String.valueOf(bo.getId()));
                    executor.setUserName(bo.getStaffName());
                }
                if (!userIdCardsMap.containsKey(executor.getMandator())) continue;
                bo = (StaffBo)userIdCardsMap.get(executor.getMandator());
                executor.setMandator(String.valueOf(bo.getId()));
                executor.setMandatorName(bo.getStaffName());
            }
            for (UnifiedTaskUser follower : followers) {
                if (userIdCardsMap.containsKey(follower.getUserId())) {
                    bo = (StaffBo)userIdCardsMap.get(follower.getUserId());
                    follower.setUserId(String.valueOf(bo.getId()));
                    follower.setUserName(bo.getStaffName());
                }
                if (!userIdCardsMap.containsKey(follower.getMandator())) continue;
                bo = (StaffBo)userIdCardsMap.get(follower.getMandator());
                follower.setMandator(String.valueOf(bo.getId()));
                follower.setMandatorName(bo.getStaffName());
            }
            this.unifiedTaskInfoServiceImpl.save((Object)saveToDoDto);
            for (UnifiedTaskUser unifiedTaskUser : executors) {
                unifiedTaskUser.setSystemId(saveToDoDto.getSystemId());
                unifiedTaskUser.setTaskId(saveToDoDto.getTaskId());
                unifiedTaskUser.setTodoId(saveToDoDto.getTodoId());
                unifiedTaskUser.setExecuteStatus(taskStatus);
                unifiedTaskUser.setUserType("1");
            }
            if (ToolUtil.isNotEmpty((Object)followers)) {
                for (UnifiedTaskUser unifiedTaskUser : followers) {
                    unifiedTaskUser.setSystemId(saveToDoDto.getSystemId());
                    unifiedTaskUser.setTaskId(saveToDoDto.getTaskId());
                    unifiedTaskUser.setTodoId(saveToDoDto.getTodoId());
                    unifiedTaskUser.setExecuteStatus(taskStatus);
                    unifiedTaskUser.setUserType("0");
                }
                executors.addAll(followers);
            }
            this.unifiedTaskUserServiceImpl.saveBatch((Collection)executors);
            unifiedLog.setSuccessState("1");
            unifiedLog.setErrorReason(null);
            this.unifiedLogService.saveOrUpdate((Object)unifiedLog);
            return ApiResponse.success((Object)"", null);
        }
        catch (Exception e) {
            unifiedLog.setSuccessState("0");
            unifiedLog.setErrorReason(e.toString());
            this.unifiedLogService.saveOrUpdate((Object)unifiedLog);
            return ApiResponse.fail((int)1, null, (String)e.toString());
        }
    }

    public ApiResponse<String> updateTask(SaveToDoHtszDto saveToDoDto) {
        UnifiedLog unifiedLog = new UnifiedLog();
        if (HussarUtils.isNotEmpty((Object)saveToDoDto.getLogId())) {
            unifiedLog.setLogId(Long.valueOf(saveToDoDto.getLogId()));
        }
        unifiedLog.setPathName("/unified/unifiedExternal/updateTask");
        unifiedLog.setStartTime(LocalDateTime.now());
        unifiedLog.setParameter(JSON.toJSONString((Object)saveToDoDto, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
        UnifiedSystemInfo systemInfo = (UnifiedSystemInfo)this.unifiedSystemInfoMapper.selectById((Serializable)((Object)saveToDoDto.getSystemId().toString()));
        unifiedLog.setSystemName(systemInfo.getSystemName());
        unifiedLog.setSystemSource(systemInfo.getSystemSource());
        unifiedLog.setSystemId(saveToDoDto.getSystemId());
        try {
            StaffBo bo;
            Object bo2;
            saveToDoDto.setLastTime(ToolUtil.isNotEmpty((Object)saveToDoDto.getLastTime()) ? saveToDoDto.getLastTime() : new Date());
            LambdaQueryWrapper wrapperInfo = new LambdaQueryWrapper();
            if (HussarUtils.isNotEmpty((Object)saveToDoDto.getSystemId())) {
                wrapperInfo.eq(UnifiedTaskInfo::getSystemId, (Object)saveToDoDto.getSystemId());
            }
            wrapperInfo.eq(UnifiedTaskInfo::getTaskId, (Object)saveToDoDto.getTaskId());
            UnifiedTaskInfo s = (UnifiedTaskInfo)this.unifiedTaskInfoServiceImpl.getOne((Wrapper)wrapperInfo);
            List executors = saveToDoDto.getExecutors();
            List followers = saveToDoDto.getFollowers();
            ArrayList<String> userIds = new ArrayList<String>();
            userIds.add(saveToDoDto.getCreateUserId());
            userIds.add(saveToDoDto.getSendUserId());
            userIds.add(saveToDoDto.getMandator());
            for (UnifiedTaskUser executor : executors) {
                userIds.add(executor.getUserId());
                userIds.add(executor.getMandator());
            }
            for (UnifiedTaskUser follower : followers) {
                userIds.add(follower.getUserId());
                userIds.add(follower.getMandator());
            }
            Map<String, Object> userIdCardsMap = this.getUserIdListByUserIdCars(userIds);
            if (userIdCardsMap.containsKey(saveToDoDto.getCreateUserId())) {
                bo2 = (StaffBo)userIdCardsMap.get(saveToDoDto.getCreateUserId());
                saveToDoDto.setCreateUserId(String.valueOf(bo2.getId()));
                saveToDoDto.setCreateUserName(bo2.getStaffName());
            }
            if (userIdCardsMap.containsKey(saveToDoDto.getSendUserId())) {
                bo2 = (StaffBo)userIdCardsMap.get(saveToDoDto.getSendUserId());
                saveToDoDto.setSendUserId(String.valueOf(bo2.getId()));
                saveToDoDto.setSendUserName(bo2.getStaffName());
            }
            for (UnifiedTaskUser executor : executors) {
                if (userIdCardsMap.containsKey(executor.getUserId())) {
                    bo = (StaffBo)userIdCardsMap.get(executor.getUserId());
                    executor.setUserId(String.valueOf(bo.getId()));
                    executor.setUserName(bo.getStaffName());
                }
                if (!userIdCardsMap.containsKey(executor.getMandator())) continue;
                bo = (StaffBo)userIdCardsMap.get(executor.getMandator());
                executor.setMandator(String.valueOf(bo.getId()));
                executor.setMandatorName(bo.getStaffName());
            }
            for (UnifiedTaskUser follower : followers) {
                if (userIdCardsMap.containsKey(follower.getUserId())) {
                    bo = (StaffBo)userIdCardsMap.get(follower.getUserId());
                    follower.setUserId(String.valueOf(bo.getId()));
                    follower.setUserName(bo.getStaffName());
                }
                if (!userIdCardsMap.containsKey(follower.getMandator())) continue;
                bo = (StaffBo)userIdCardsMap.get(follower.getMandator());
                follower.setMandator(String.valueOf(bo.getId()));
                follower.setMandatorName(bo.getStaffName());
            }
            if (ToolUtil.isEmpty((Object)s)) {
                this.unifiedTaskInfoServiceImpl.save((Object)saveToDoDto);
            } else {
                this.unifiedTaskInfoServiceImpl.updateById((Object)saveToDoDto);
            }
            if (ToolUtil.isNotEmpty((Object)executors)) {
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper.eq(UnifiedTaskUser::getSystemId, (Object)saveToDoDto.getSystemId())).eq(UnifiedTaskUser::getTaskId, (Object)saveToDoDto.getTaskId());
                this.unifiedTaskUserServiceImpl.remove((Wrapper)wrapper);
                for (UnifiedTaskUser unifiedTaskUser : executors) {
                    unifiedTaskUser.setSystemId(saveToDoDto.getSystemId());
                    unifiedTaskUser.setTaskId(saveToDoDto.getTaskId());
                    unifiedTaskUser.setTodoId(saveToDoDto.getTodoId());
                    unifiedTaskUser.setExecuteStatus("0");
                    unifiedTaskUser.setUserType("1");
                }
                if (ToolUtil.isNotEmpty((Object)followers)) {
                    for (UnifiedTaskUser unifiedTaskUser : followers) {
                        unifiedTaskUser.setSystemId(saveToDoDto.getSystemId());
                        unifiedTaskUser.setTaskId(saveToDoDto.getTaskId());
                        unifiedTaskUser.setTodoId(saveToDoDto.getTodoId());
                        unifiedTaskUser.setExecuteStatus("0");
                        unifiedTaskUser.setUserType("0");
                    }
                    executors.addAll(followers);
                }
            }
            this.unifiedTaskUserServiceImpl.saveBatch((Collection)executors);
            unifiedLog.setSuccessState("1");
            unifiedLog.setErrorReason(null);
            this.unifiedLogService.saveOrUpdate((Object)unifiedLog);
            return ApiResponse.success((Object)"", null);
        }
        catch (Exception e) {
            unifiedLog.setSuccessState("0");
            unifiedLog.setErrorReason(e.toString());
            this.unifiedLogService.saveOrUpdate((Object)unifiedLog);
            return ApiResponse.fail((int)1, null, (String)e.toString());
        }
    }

    public ApiResponse<Page<SaveToDoDto>> getListTask(Page<SaveToDoDto> page, QueryToDoDto queryToDoDto) {
        Page saveToDoDtoPage;
        boolean isEmptyResult;
        boolean bl = isEmptyResult = queryToDoDto.getProcessDefinitionKey() != null && queryToDoDto.getProcessDefinitionKey().isEmpty();
        if (!isEmptyResult && HussarUtils.isNotEmpty((Object)queryToDoDto.getCategoryId())) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(UnifiedCategoryInfo::getCategoryTypeId, (Object)queryToDoDto.getCategoryId());
            List list = this.unifiedCategoryInfoService.list((Wrapper)lambdaQueryWrapper);
            List processKeyList = list.stream().map(UnifiedCategoryInfo::getCategoryAttribute).collect(Collectors.toList());
            if (queryToDoDto.getProcessDefinitionKey() != null) {
                queryToDoDto.getProcessDefinitionKey().retainAll(processKeyList);
            } else {
                queryToDoDto.setProcessDefinitionKey(processKeyList);
            }
            isEmptyResult = queryToDoDto.getProcessDefinitionKey() != null && queryToDoDto.getProcessDefinitionKey().isEmpty();
        }
        ArrayList<String> userIds = new ArrayList<String>();
        userIds.add(queryToDoDto.getUserId());
        Map<String, Object> userIdCardsMap = this.getUserIdListByUserIdCars(userIds);
        if (userIdCardsMap.containsKey(queryToDoDto.getUserId())) {
            StaffBo bo = (StaffBo)userIdCardsMap.get(queryToDoDto.getUserId());
            queryToDoDto.setUserId(String.valueOf(bo.getId()));
        }
        if (isEmptyResult) {
            Page pageProcess = new Page();
            pageProcess.setCurrent(page.getCurrent());
            pageProcess.setSize(page.getSize());
            pageProcess.setTotal(0L);
            pageProcess.setRecords(new ArrayList());
            return ApiResponse.success((Object)pageProcess);
        }
        if (HussarUtils.isNotEmpty((Object)queryToDoDto.getSubject())) {
            queryToDoDto.setSubject(queryToDoDto.getSubject().replace("%", "\\%").replace("_", "\\_"));
        }
        if (HussarUtils.isNotEmpty((Object)queryToDoDto.getProcessTitle())) {
            queryToDoDto.setProcessTitle(queryToDoDto.getProcessTitle().replace("%", "\\%").replace("_", "\\_"));
        }
        List saveToDoDtoList = new ArrayList();
        if ("3".equals(queryToDoDto.getUserType())) {
            Page pageProcess = new Page();
            pageProcess.setCurrent(page.getCurrent());
            pageProcess.setSize(page.getSize());
            saveToDoDtoPage = this.unifiedToDoMapper.queryProcessList(pageProcess, queryToDoDto);
            saveToDoDtoList = saveToDoDtoPage.getRecords();
        } else {
            saveToDoDtoPage = this.unifiedToDoMapper.queryTaskList(page, queryToDoDto);
            saveToDoDtoList = saveToDoDtoPage.getRecords();
            for (Object saveToDoDto : saveToDoDtoList) {
                if (!"0".equals(saveToDoDto.getSystemSource())) continue;
                if (saveToDoDto.getMandator() != null && saveToDoDto.getWebLinkurl() != null) {
                    saveToDoDto.setWebLinkurl(saveToDoDto.getWebLinkurl().replaceFirst("&taskId=" + saveToDoDto.getTaskId(), "&taskId=" + saveToDoDto.getTaskId() + ":" + saveToDoDto.getMandator()));
                }
                if (saveToDoDto.getCcMoment() == null) continue;
                saveToDoDto.setTaskId(saveToDoDto.getTaskId() + ":" + saveToDoDto.getCcMoment());
            }
        }
        if ("3".equals(queryToDoDto.getUserType())) {
            ArrayList<String> processInstIdList = new ArrayList<String>();
            for (SaveToDoDto saveToDoDto : saveToDoDtoList) {
                if ("1".equals(saveToDoDto.getProcessState())) {
                    saveToDoDto.setCurrentNodeName("\u7ed3\u675f");
                    continue;
                }
                processInstIdList.add(saveToDoDto.getProcessInstanceid());
            }
            if (HussarUtils.isNotEmpty(processInstIdList)) {
                List nodeNameList = this.unifiedToDoMapper.getNodeNames(processInstIdList);
                HashMap<String, Set> nodeMap = new HashMap<String, Set>();
                for (SaveToDoDto saveToDoDtoTemp : nodeNameList) {
                    String procInstId = saveToDoDtoTemp.getProcessInstanceid();
                    Set set = (Set)nodeMap.get(procInstId);
                    set = set == null ? new HashSet() : set;
                    set.add(saveToDoDtoTemp.getTaskName());
                    nodeMap.put(procInstId, set);
                }
                for (SaveToDoDto saveToDoDto : saveToDoDtoList) {
                    Set nodeNames = (Set)nodeMap.get(saveToDoDto.getProcessInstanceid());
                    if (!HussarUtils.isNotEmpty((Object)nodeNames)) continue;
                    saveToDoDto.setCurrentNodeName(String.join((CharSequence)",", nodeNames));
                }
            }
            saveToDoDtoPage.setRecords(saveToDoDtoList);
        }
        return ApiResponse.success((Object)saveToDoDtoPage);
    }

    public ApiResponse<ToDoVo> getToDoByTaskId(String todoId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(UnifiedTaskInfo::getTodoId, (Object)Long.parseLong(todoId));
        UnifiedTaskInfo unifiedTaskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoServiceImpl.getOne((Wrapper)wrapper);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UnifiedTaskUser::getTodoId, (Object)Long.valueOf(todoId));
        List users = this.unifiedTaskUserServiceImpl.list((Wrapper)queryWrapper);
        ArrayList<UnifiedTaskUser> executors = new ArrayList<UnifiedTaskUser>();
        ArrayList<UnifiedTaskUser> followers = new ArrayList<UnifiedTaskUser>();
        for (UnifiedTaskUser unifiedTaskUser : users) {
            if ("1".equals(unifiedTaskUser.getUserType())) {
                executors.add(unifiedTaskUser);
                continue;
            }
            followers.add(unifiedTaskUser);
        }
        ToDoVo toDoVo = (ToDoVo)JSON.parseObject((String)JSON.toJSONString((Object)unifiedTaskInfo), ToDoVo.class);
        toDoVo.setExecutors(executors);
        toDoVo.setFollowers(followers);
        LambdaQueryWrapper wrapperSystem = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)unifiedTaskInfo.getSystemId())) {
            wrapperSystem.eq(UnifiedSystemInfo::getSystemId, (Object)unifiedTaskInfo.getSystemId());
            toDoVo.setSystemAddress(((UnifiedSystemInfo)this.unifiedSystemInfoServiceImpl.getOne((Wrapper)wrapperSystem)).getSystemAddress());
        }
        return ApiResponse.success((Object)toDoVo);
    }

    public ApiResponse<String> deleteTask(String taskIds, String systemId, String processInstId, String logId) {
        UnifiedLog unifiedLog = new UnifiedLog();
        if (HussarUtils.isNotEmpty((Object)logId)) {
            unifiedLog.setLogId(Long.valueOf(logId));
        }
        unifiedLog.setPathName("/unified/unifiedExternal/deleteTask");
        unifiedLog.setStartTime(LocalDateTime.now());
        unifiedLog.setParameter(JSON.toJSONString((Object)new UpdateTaskStatusHtszDto(taskIds, systemId, processInstId, logId), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
        UnifiedSystemInfo systemInfo = (UnifiedSystemInfo)this.unifiedSystemInfoMapper.selectById((Serializable)((Object)systemId));
        unifiedLog.setSystemName(systemInfo.getSystemName());
        unifiedLog.setSystemSource(systemInfo.getSystemSource());
        unifiedLog.setSystemId(systemInfo.getSystemId());
        try {
            if (HussarUtils.isEmpty((Object)taskIds) && HussarUtils.isEmpty((Object)processInstId)) {
                logger.error("\u4efb\u52a1ID\u548c\u6d41\u7a0b\u5b9e\u4f8bID\u5747\u4e3a\u7a7a\u3002");
                return ApiResponse.fail((String)"\u4efb\u52a1ID\u548c\u6d41\u7a0b\u5b9e\u4f8bID\u5747\u4e3a\u7a7a\u3002");
            }
            ArrayList<String> taskId = null;
            if (ToolUtil.isNotEmpty((Object)taskIds)) {
                taskId = new ArrayList<String>(Arrays.asList(taskIds.split(",")));
            }
            LambdaQueryWrapper wrapperInfo = new LambdaQueryWrapper();
            LambdaQueryWrapper wrapperUser = new LambdaQueryWrapper();
            if (ToolUtil.isNotEmpty(taskId)) {
                wrapperInfo.in(UnifiedTaskInfo::getTaskId, taskId);
                wrapperUser.in(UnifiedTaskUser::getTaskId, taskId);
            }
            if (ToolUtil.isNotEmpty((Object)systemId)) {
                wrapperInfo.eq(UnifiedTaskInfo::getSystemId, (Object)Long.parseLong(systemId));
                wrapperUser.eq(UnifiedTaskUser::getSystemId, (Object)Long.parseLong(systemId));
            }
            if (ToolUtil.isNotEmpty((Object)processInstId)) {
                ArrayList<String> processInstIdList = new ArrayList<String>(Arrays.asList(processInstId.split(",")));
                wrapperInfo.in(UnifiedTaskInfo::getProcessInstanceid, processInstIdList);
                LambdaQueryWrapper wrapperInfoByProcessInstId = new LambdaQueryWrapper();
                wrapperInfoByProcessInstId.in(UnifiedTaskInfo::getProcessInstanceid, processInstIdList);
                List list = this.unifiedTaskInfoServiceImpl.list((Wrapper)wrapperInfoByProcessInstId).stream().map(UnifiedTaskInfo::getTodoId).collect(Collectors.toList());
                if (HussarUtils.isEmpty((Object)taskIds) && HussarUtils.isEmpty(list)) {
                    logger.error("\u4efb\u52a1ID\u548c\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u5e94\u7684todoId\u5747\u4e3a\u7a7a\u3002");
                    return ApiResponse.fail((String)"\u4efb\u52a1ID\u548c\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u5e94\u7684todoId\u5747\u4e3a\u7a7a\u3002");
                }
                wrapperUser.in(HussarUtils.isNotEmpty(list), UnifiedTaskUser::getTodoId, list);
            }
            this.unifiedTaskInfoServiceImpl.remove((Wrapper)wrapperInfo);
            this.unifiedTaskUserServiceImpl.remove((Wrapper)wrapperUser);
            unifiedLog.setSuccessState("1");
            unifiedLog.setErrorReason(null);
            this.unifiedLogService.saveOrUpdate((Object)unifiedLog);
            return ApiResponse.success((Object)"", null);
        }
        catch (Exception e) {
            unifiedLog.setSuccessState("0");
            unifiedLog.setErrorReason(e.toString());
            this.unifiedLogService.saveOrUpdate((Object)unifiedLog);
            return ApiResponse.fail((int)1, null, (String)e.toString());
        }
    }

    public ApiResponse<String> updateTaskStatus(String taskId, String systemId, String processInstId, String taskStatus, String webLinkurl, String mobileLinkurl, String lastTime, String logId) {
        UnifiedLog unifiedLog = new UnifiedLog();
        if (HussarUtils.isNotEmpty((Object)logId)) {
            unifiedLog.setLogId(Long.valueOf(logId));
        }
        unifiedLog.setPathName("/unified/unifiedExternal/updateTaskStatus");
        unifiedLog.setStartTime(LocalDateTime.now());
        unifiedLog.setParameter(JSON.toJSONString((Object)new UpdateTaskStatusHtszDto(taskId, systemId, processInstId, taskStatus, webLinkurl, mobileLinkurl, lastTime, logId), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
        UnifiedSystemInfo systemInfo = (UnifiedSystemInfo)this.unifiedSystemInfoMapper.selectById((Serializable)((Object)systemId));
        unifiedLog.setSystemName(systemInfo.getSystemName());
        unifiedLog.setSystemSource(systemInfo.getSystemSource());
        unifiedLog.setSystemId(systemInfo.getSystemId());
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            Date date = null;
            try {
                date = ToolUtil.isNotEmpty((Object)lastTime) ? formatter.parse(lastTime) : new Date();
            }
            catch (ParseException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            taskStatus = ToolUtil.isNotEmpty((Object)taskStatus) ? taskStatus : "1";
            LambdaUpdateWrapper wrapperInfo = new LambdaUpdateWrapper();
            if (ToolUtil.isNotEmpty((Object)taskId)) {
                wrapperInfo.eq(UnifiedTaskInfo::getTaskId, (Object)taskId);
            }
            if (ToolUtil.isNotEmpty((Object)systemId)) {
                wrapperInfo.eq(UnifiedTaskInfo::getSystemId, (Object)Long.parseLong(systemId));
            }
            List userByProcessInstId = null;
            if (ToolUtil.isNotEmpty((Object)processInstId)) {
                wrapperInfo.eq(UnifiedTaskInfo::getProcessInstanceid, (Object)processInstId);
                LambdaUpdateWrapper wrapperByProcessInstId = new LambdaUpdateWrapper();
                wrapperByProcessInstId.eq(UnifiedTaskInfo::getProcessInstanceid, (Object)processInstId);
                userByProcessInstId = this.unifiedTaskInfoServiceImpl.list((Wrapper)wrapperByProcessInstId).stream().map(UnifiedTaskInfo::getTodoId).collect(Collectors.toList());
            }
            if (HussarUtils.isEmpty((Object)taskId) && HussarUtils.isEmpty(userByProcessInstId)) {
                logger.error("\u4efb\u52a1ID\u548c\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u5e94\u7684todoId\u5747\u4e3a\u7a7a\u3002");
                return ApiResponse.fail((String)"\u4efb\u52a1ID\u548c\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u5e94\u7684todoId\u5747\u4e3a\u7a7a\u3002");
            }
            if (ToolUtil.isNotEmpty((Object)mobileLinkurl)) {
                wrapperInfo.set(UnifiedTaskInfo::getMobileLinkurl, (Object)mobileLinkurl);
            }
            if (ToolUtil.isNotEmpty((Object)webLinkurl)) {
                wrapperInfo.set(UnifiedTaskInfo::getWebLinkurl, (Object)webLinkurl);
            }
            wrapperInfo.set(UnifiedTaskInfo::getTaskStatus, (Object)taskStatus);
            wrapperInfo.set(UnifiedTaskInfo::getLastTime, (Object)date);
            this.unifiedTaskInfoServiceImpl.update((Wrapper)wrapperInfo);
            LambdaUpdateWrapper wrapperUser = new LambdaUpdateWrapper();
            if (ToolUtil.isNotEmpty((Object)systemId)) {
                wrapperUser.eq(UnifiedTaskUser::getSystemId, (Object)Long.parseLong(systemId));
            }
            if (ToolUtil.isNotEmpty((Object)taskId)) {
                wrapperUser.eq(UnifiedTaskUser::getTaskId, (Object)taskId);
            }
            if (ToolUtil.isNotEmpty(userByProcessInstId)) {
                wrapperUser.in(UnifiedTaskUser::getTodoId, userByProcessInstId);
            }
            wrapperUser.set(UnifiedTaskUser::getExecuteStatus, (Object)taskStatus);
            if ("1".equals(taskStatus)) {
                wrapperUser.set(UnifiedTaskUser::getCompleteTime, (Object)date);
            } else {
                wrapperUser.set(UnifiedTaskUser::getCompleteTime, null);
            }
            this.unifiedTaskUserServiceImpl.update((Wrapper)wrapperUser);
            unifiedLog.setSuccessState("1");
            unifiedLog.setErrorReason(null);
            this.unifiedLogService.saveOrUpdate((Object)unifiedLog);
            return ApiResponse.success((Object)"", null);
        }
        catch (Exception e) {
            unifiedLog.setSuccessState("0");
            unifiedLog.setErrorReason(e.toString());
            this.unifiedLogService.saveOrUpdate((Object)unifiedLog);
            return ApiResponse.fail((int)1, null, (String)e.toString());
        }
    }

    public ApiResponse<String> updateTaskStatusWithOutFollowers(String taskId, String systemId, String processInstId, String taskStatus, String webLinkurl, String mobileLinkurl, String lastTime, String formId, String logId) {
        UnifiedLog unifiedLog = new UnifiedLog();
        if (HussarUtils.isNotEmpty((Object)logId)) {
            unifiedLog.setLogId(Long.valueOf(logId));
        }
        unifiedLog.setPathName("/unified/unifiedExternal/updateTaskStatusWithOutFollowers");
        unifiedLog.setStartTime(LocalDateTime.now());
        unifiedLog.setParameter(JSON.toJSONString((Object)new UpdateTaskStatusHtszDto(taskId, systemId, processInstId, taskStatus, webLinkurl, mobileLinkurl, lastTime, logId), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
        UnifiedSystemInfo systemInfo = (UnifiedSystemInfo)this.unifiedSystemInfoMapper.selectById((Serializable)((Object)systemId));
        unifiedLog.setSystemName(systemInfo.getSystemName());
        unifiedLog.setSystemSource(systemInfo.getSystemSource());
        unifiedLog.setSystemId(systemInfo.getSystemId());
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            Date date = null;
            try {
                date = ToolUtil.isNotEmpty((Object)lastTime) ? formatter.parse(lastTime) : new Date();
            }
            catch (ParseException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            taskStatus = ToolUtil.isNotEmpty((Object)taskStatus) ? taskStatus : "1";
            LambdaUpdateWrapper wrapperInfo = new LambdaUpdateWrapper();
            if (ToolUtil.isNotEmpty((Object)taskId)) {
                wrapperInfo.eq(UnifiedTaskInfo::getTaskId, (Object)taskId);
            }
            if (ToolUtil.isNotEmpty((Object)systemId)) {
                wrapperInfo.eq(UnifiedTaskInfo::getSystemId, (Object)Long.parseLong(systemId));
            }
            List userByProcessInstId = null;
            if (ToolUtil.isNotEmpty((Object)processInstId)) {
                wrapperInfo.eq(UnifiedTaskInfo::getProcessInstanceid, (Object)processInstId);
                LambdaUpdateWrapper wrapperByProcessInstId = new LambdaUpdateWrapper();
                wrapperByProcessInstId.eq(UnifiedTaskInfo::getProcessInstanceid, (Object)processInstId);
                if ("1".equals(taskStatus)) {
                    wrapperInfo.eq(UnifiedTaskInfo::getTaskStatus, (Object)"0");
                    wrapperByProcessInstId.eq(UnifiedTaskInfo::getTaskStatus, (Object)"0");
                }
                userByProcessInstId = this.unifiedTaskInfoServiceImpl.list((Wrapper)wrapperByProcessInstId).stream().map(UnifiedTaskInfo::getTodoId).collect(Collectors.toList());
            }
            if (HussarUtils.isEmpty((Object)taskId) && HussarUtils.isEmpty(userByProcessInstId)) {
                logger.error("\u4efb\u52a1ID\u548c\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u5e94\u7684todoId\u5747\u4e3a\u7a7a\u3002");
                return ApiResponse.fail((String)"\u4efb\u52a1ID\u548c\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u5e94\u7684todoId\u5747\u4e3a\u7a7a\u3002");
            }
            if (ToolUtil.isNotEmpty((Object)mobileLinkurl)) {
                wrapperInfo.set(UnifiedTaskInfo::getMobileLinkurl, (Object)mobileLinkurl);
            }
            if (ToolUtil.isNotEmpty((Object)webLinkurl)) {
                wrapperInfo.set(UnifiedTaskInfo::getWebLinkurl, (Object)webLinkurl);
            }
            if (HussarUtils.isNotEmpty((Object)formId)) {
                wrapperInfo.set(UnifiedTaskInfo::getFormId, (Object)formId);
            }
            wrapperInfo.set(UnifiedTaskInfo::getTaskStatus, (Object)taskStatus);
            wrapperInfo.set(UnifiedTaskInfo::getLastTime, (Object)date);
            this.unifiedTaskInfoServiceImpl.update((Wrapper)wrapperInfo);
            LambdaUpdateWrapper wrapperUser = new LambdaUpdateWrapper();
            wrapperUser.eq(UnifiedTaskUser::getUserType, (Object)"1");
            if (ToolUtil.isNotEmpty((Object)systemId)) {
                wrapperUser.eq(UnifiedTaskUser::getSystemId, (Object)Long.parseLong(systemId));
            }
            if (ToolUtil.isNotEmpty((Object)taskId)) {
                wrapperUser.eq(UnifiedTaskUser::getTaskId, (Object)taskId);
            }
            if (ToolUtil.isNotEmpty(userByProcessInstId)) {
                wrapperUser.in(UnifiedTaskUser::getTodoId, userByProcessInstId);
            }
            wrapperUser.set(UnifiedTaskUser::getExecuteStatus, (Object)taskStatus);
            if ("1".equals(taskStatus)) {
                wrapperUser.set(UnifiedTaskUser::getCompleteTime, (Object)date);
            } else {
                wrapperUser.set(UnifiedTaskUser::getCompleteTime, null);
            }
            this.unifiedTaskUserServiceImpl.update((Wrapper)wrapperUser);
            unifiedLog.setSuccessState("1");
            unifiedLog.setErrorReason(null);
            this.unifiedLogService.saveOrUpdate((Object)unifiedLog);
            return ApiResponse.success((Object)"", null);
        }
        catch (Exception e) {
            unifiedLog.setSuccessState("0");
            unifiedLog.setErrorReason(e.toString());
            this.unifiedLogService.saveOrUpdate((Object)unifiedLog);
            return ApiResponse.fail((int)1, null, (String)e.toString());
        }
    }

    public ApiResponse<String> updateUserStatus(UnifiedTaskUser unifiedTaskUser) {
        StaffBo bo;
        ArrayList<String> userIds = new ArrayList<String>();
        userIds.add(unifiedTaskUser.getUserId());
        userIds.add(unifiedTaskUser.getMandator());
        Map<String, Object> userIdCardsMap = this.getUserIdListByUserIdCars(userIds);
        if (userIdCardsMap.containsKey(unifiedTaskUser.getUserId())) {
            bo = (StaffBo)userIdCardsMap.get(unifiedTaskUser.getUserId());
            unifiedTaskUser.setUserId(String.valueOf(bo.getId()));
            unifiedTaskUser.setUserName(bo.getStaffName());
        }
        if (userIdCardsMap.containsKey(unifiedTaskUser.getMandator())) {
            bo = (StaffBo)userIdCardsMap.get(unifiedTaskUser.getMandator());
            unifiedTaskUser.setMandator(String.valueOf(bo.getId()));
            unifiedTaskUser.setMandatorName(bo.getStaffName());
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        if (HussarUtils.isNotEmpty((Object)unifiedTaskUser.getSystemId())) {
            wrapper.eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskUser.getSystemId());
        }
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskUser.getTaskId())).eq(UnifiedTaskUser::getUserId, (Object)unifiedTaskUser.getUserId())).eq(UnifiedTaskUser::getUserType, (Object)unifiedTaskUser.getUserType())).eq(HussarUtils.isNotEmpty((Object)unifiedTaskUser.getCcMoment()), UnifiedTaskUser::getCcMoment, (Object)unifiedTaskUser.getCcMoment());
        ((LambdaUpdateWrapper)wrapper.set(UnifiedTaskUser::getExecuteStatus, (Object)unifiedTaskUser.getExecuteStatus())).set(UnifiedTaskUser::getCompleteTime, (Object)(ToolUtil.isNotEmpty((Object)unifiedTaskUser.getCompleteTime()) ? unifiedTaskUser.getCompleteTime() : new Date()));
        this.unifiedTaskUserServiceImpl.update((Wrapper)wrapper);
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> updateTaskUser(String taskId, String systemId, String executeStatus, List<UnifiedTaskUser> executors, List<UnifiedTaskUser> followers, String logId) {
        UnifiedLog unifiedLog = new UnifiedLog();
        if (HussarUtils.isNotEmpty((Object)logId)) {
            unifiedLog.setLogId(Long.valueOf(logId));
        }
        unifiedLog.setPathName("/unified/unifiedExternal/updateTaskUser");
        unifiedLog.setStartTime(LocalDateTime.now());
        unifiedLog.setParameter(JSON.toJSONString((Object)new SaveToDoHtszDto(taskId, Long.valueOf(systemId), executeStatus, executors, followers, logId), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
        UnifiedSystemInfo systemInfo = (UnifiedSystemInfo)this.unifiedSystemInfoMapper.selectById((Serializable)((Object)systemId));
        unifiedLog.setSystemName(systemInfo.getSystemName());
        unifiedLog.setSystemSource(systemInfo.getSystemSource());
        unifiedLog.setSystemId(systemInfo.getSystemId());
        try {
            StaffBo bo;
            ArrayList<String> userIds = new ArrayList<String>();
            for (UnifiedTaskUser unifiedTaskUser : executors) {
                userIds.add(unifiedTaskUser.getUserId());
                userIds.add(unifiedTaskUser.getMandator());
            }
            for (UnifiedTaskUser unifiedTaskUser : followers) {
                userIds.add(unifiedTaskUser.getUserId());
                userIds.add(unifiedTaskUser.getMandator());
            }
            Map<String, Object> userIdCardsMap = this.getUserIdListByUserIdCars(userIds);
            for (UnifiedTaskUser executor : executors) {
                if (userIdCardsMap.containsKey(executor.getUserId())) {
                    bo = (StaffBo)userIdCardsMap.get(executor.getUserId());
                    executor.setUserId(String.valueOf(bo.getId()));
                    executor.setUserName(bo.getStaffName());
                }
                if (!userIdCardsMap.containsKey(executor.getMandator())) continue;
                bo = (StaffBo)userIdCardsMap.get(executor.getMandator());
                executor.setMandator(String.valueOf(bo.getId()));
                executor.setMandatorName(bo.getStaffName());
            }
            for (UnifiedTaskUser follower : followers) {
                if (userIdCardsMap.containsKey(follower.getUserId())) {
                    bo = (StaffBo)userIdCardsMap.get(follower.getUserId());
                    follower.setUserId(String.valueOf(bo.getId()));
                    follower.setUserName(bo.getStaffName());
                }
                if (!userIdCardsMap.containsKey(follower.getMandator())) continue;
                bo = (StaffBo)userIdCardsMap.get(follower.getMandator());
                follower.setMandator(String.valueOf(bo.getId()));
                follower.setMandatorName(bo.getStaffName());
            }
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            if (HussarUtils.isNotEmpty((Object)systemId)) {
                lambdaQueryWrapper.eq(UnifiedTaskInfo::getSystemId, (Object)Long.parseLong(systemId));
            }
            lambdaQueryWrapper.eq(UnifiedTaskInfo::getTaskId, (Object)taskId);
            Long todoId = ((UnifiedTaskInfo)this.unifiedTaskInfoServiceImpl.getOne((Wrapper)lambdaQueryWrapper)).getTodoId();
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            if (HussarUtils.isNotEmpty((Object)systemId)) {
                wrapper.eq(UnifiedTaskUser::getSystemId, (Object)Long.parseLong(systemId));
            }
            ((LambdaQueryWrapper)wrapper.eq(UnifiedTaskUser::getTaskId, (Object)taskId)).eq(UnifiedTaskUser::getUserType, (Object)"1");
            this.unifiedTaskUserServiceImpl.remove((Wrapper)wrapper);
            for (UnifiedTaskUser unifiedTaskUser : executors) {
                unifiedTaskUser.setUnifiedId(null);
                unifiedTaskUser.setSystemId(Long.valueOf(Long.parseLong(systemId)));
                unifiedTaskUser.setTaskId(taskId);
                unifiedTaskUser.setTodoId(todoId);
                unifiedTaskUser.setExecuteStatus(ToolUtil.isNotEmpty((Object)executeStatus) ? executeStatus : "0");
                unifiedTaskUser.setUserType("1");
            }
            if (HussarUtils.isNotEmpty(followers)) {
                LambdaQueryWrapper wrapperFollower = new LambdaQueryWrapper();
                if (HussarUtils.isNotEmpty((Object)systemId)) {
                    wrapperFollower.eq(UnifiedTaskUser::getSystemId, (Object)Long.parseLong(systemId));
                }
                ((LambdaQueryWrapper)wrapperFollower.eq(UnifiedTaskUser::getTaskId, (Object)taskId)).eq(UnifiedTaskUser::getUserType, (Object)"0");
                this.unifiedTaskUserServiceImpl.remove((Wrapper)wrapperFollower);
                for (UnifiedTaskUser unifiedTaskUser : followers) {
                    unifiedTaskUser.setUnifiedId(null);
                    unifiedTaskUser.setSystemId(Long.valueOf(Long.parseLong(systemId)));
                    unifiedTaskUser.setTaskId(taskId);
                    unifiedTaskUser.setTodoId(todoId);
                    unifiedTaskUser.setExecuteStatus(ToolUtil.isNotEmpty((Object)executeStatus) ? executeStatus : "0");
                    unifiedTaskUser.setUserType("0");
                }
                executors.addAll(followers);
            }
            this.unifiedTaskUserServiceImpl.saveBatch(executors);
            unifiedLog.setSuccessState("1");
            unifiedLog.setErrorReason(null);
            this.unifiedLogService.saveOrUpdate((Object)unifiedLog);
            return ApiResponse.success((Object)"", null);
        }
        catch (Exception e) {
            unifiedLog.setSuccessState("0");
            unifiedLog.setErrorReason(e.toString());
            this.unifiedLogService.saveOrUpdate((Object)unifiedLog);
            return ApiResponse.fail((int)1, null, (String)e.toString());
        }
    }

    public ApiResponse<String> updateTaskUser(String taskId, String systemId, String executeStatus, UpdateTaskUserToDoHtszDto updateTaskUserToDoDto) {
        return this.updateTaskUser(taskId, systemId, executeStatus, updateTaskUserToDoDto.getExecutors(), updateTaskUserToDoDto.getFollowers(), updateTaskUserToDoDto.getLogId());
    }

    public ApiResponse<String> addTaskUser(List<UnifiedTaskUser> unifiedTaskUsers) {
        ArrayList<String> userIds = new ArrayList<String>();
        for (UnifiedTaskUser unifiedTaskUser : unifiedTaskUsers) {
            userIds.add(unifiedTaskUser.getUserId());
            userIds.add(unifiedTaskUser.getMandator());
        }
        Map<String, Object> userIdCardsMap = this.getUserIdListByUserIdCars(userIds);
        for (UnifiedTaskUser unifiedTaskUser : unifiedTaskUsers) {
            StaffBo bo;
            if (userIdCardsMap.containsKey(unifiedTaskUser.getUserId())) {
                bo = (StaffBo)userIdCardsMap.get(unifiedTaskUser.getUserId());
                unifiedTaskUser.setUserId(String.valueOf(bo.getId()));
                unifiedTaskUser.setUserName(bo.getStaffName());
            }
            if (!userIdCardsMap.containsKey(unifiedTaskUser.getMandator())) continue;
            bo = (StaffBo)userIdCardsMap.get(unifiedTaskUser.getMandator());
            unifiedTaskUser.setMandator(String.valueOf(bo.getId()));
            unifiedTaskUser.setMandatorName(bo.getStaffName());
        }
        for (UnifiedTaskUser unifiedTaskUser : unifiedTaskUsers) {
            LambdaQueryWrapper wrapperInfo = new LambdaQueryWrapper();
            if (HussarUtils.isNotEmpty((Object)unifiedTaskUser.getSystemId())) {
                wrapperInfo.eq(UnifiedTaskInfo::getSystemId, (Object)unifiedTaskUser.getSystemId());
            }
            wrapperInfo.eq(UnifiedTaskInfo::getTaskId, (Object)unifiedTaskUser.getTaskId());
            UnifiedTaskInfo unifiedTaskInfo = (UnifiedTaskInfo)this.unifiedTaskInfoServiceImpl.getOne((Wrapper)wrapperInfo);
            if (unifiedTaskInfo == null) continue;
            unifiedTaskUser.setTodoId(unifiedTaskInfo.getTodoId());
            unifiedTaskUser.setExecuteStatus(ToolUtil.isNotEmpty((Object)unifiedTaskUser.getExecuteStatus()) ? unifiedTaskUser.getExecuteStatus() : "0");
        }
        this.unifiedTaskUserServiceImpl.saveBatch(unifiedTaskUsers);
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> deleteTaskUser(List<UnifiedTaskUser> unifiedTaskUsers) {
        ArrayList<String> userIds = new ArrayList<String>();
        for (UnifiedTaskUser unifiedTaskUser : unifiedTaskUsers) {
            userIds.add(unifiedTaskUser.getUserId());
            userIds.add(unifiedTaskUser.getMandator());
        }
        Map<String, Object> userIdCardsMap = this.getUserIdListByUserIdCars(userIds);
        for (UnifiedTaskUser unifiedTaskUser : unifiedTaskUsers) {
            StaffBo bo;
            if (userIdCardsMap.containsKey(unifiedTaskUser.getUserId())) {
                bo = (StaffBo)userIdCardsMap.get(unifiedTaskUser.getUserId());
                unifiedTaskUser.setUserId(String.valueOf(bo.getId()));
                unifiedTaskUser.setUserName(bo.getStaffName());
            }
            if (!userIdCardsMap.containsKey(unifiedTaskUser.getMandator())) continue;
            bo = (StaffBo)userIdCardsMap.get(unifiedTaskUser.getMandator());
            unifiedTaskUser.setMandator(String.valueOf(bo.getId()));
            unifiedTaskUser.setMandatorName(bo.getStaffName());
        }
        for (UnifiedTaskUser unifiedTaskUser : unifiedTaskUsers) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            if (HussarUtils.isNotEmpty((Object)unifiedTaskUser.getSystemId())) {
                wrapper.eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskUser.getSystemId());
            }
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskUser.getTaskId())).eq(UnifiedTaskUser::getUserType, (Object)unifiedTaskUser.getUserType())).eq(HussarUtils.isNotEmpty((Object)unifiedTaskUser.getCcMoment()), UnifiedTaskUser::getCcMoment, (Object)unifiedTaskUser.getCcMoment());
            if (ToolUtil.isNotEmpty((Object)unifiedTaskUser.getUserId())) {
                wrapper.eq(UnifiedTaskUser::getUserId, (Object)unifiedTaskUser.getUserId());
            }
            if (HussarUtils.isNotEmpty((Object)unifiedTaskUser.getMandator())) {
                wrapper.eq(UnifiedTaskUser::getMandator, (Object)unifiedTaskUser.getMandator());
            } else if ("".equals(unifiedTaskUser.getMandator())) {
                wrapper.isNull(UnifiedTaskUser::getMandator);
            }
            this.unifiedTaskUserServiceImpl.remove((Wrapper)wrapper);
        }
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> transferTaskDeleteTaskUser(List<UnifiedTaskUser> unifiedTaskUsers) {
        ArrayList<String> userIds = new ArrayList<String>();
        for (UnifiedTaskUser unifiedTaskUser : unifiedTaskUsers) {
            userIds.add(unifiedTaskUser.getUserId());
            userIds.add(unifiedTaskUser.getMandator());
        }
        Map<String, Object> userIdCardsMap = this.getUserIdListByUserIdCars(userIds);
        for (UnifiedTaskUser unifiedTaskUser : unifiedTaskUsers) {
            StaffBo bo;
            if (userIdCardsMap.containsKey(unifiedTaskUser.getUserId())) {
                bo = (StaffBo)userIdCardsMap.get(unifiedTaskUser.getUserId());
                unifiedTaskUser.setUserId(String.valueOf(bo.getId()));
                unifiedTaskUser.setUserName(bo.getStaffName());
            }
            if (!userIdCardsMap.containsKey(unifiedTaskUser.getMandator())) continue;
            bo = (StaffBo)userIdCardsMap.get(unifiedTaskUser.getMandator());
            unifiedTaskUser.setMandator(String.valueOf(bo.getId()));
            unifiedTaskUser.setMandatorName(bo.getStaffName());
        }
        for (UnifiedTaskUser unifiedTaskUser : unifiedTaskUsers) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            if (HussarUtils.isNotEmpty((Object)unifiedTaskUser.getSystemId())) {
                wrapper.eq(UnifiedTaskUser::getSystemId, (Object)unifiedTaskUser.getSystemId());
            }
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(UnifiedTaskUser::getTaskId, (Object)unifiedTaskUser.getTaskId())).eq(UnifiedTaskUser::getUserType, (Object)unifiedTaskUser.getUserType())).eq(UnifiedTaskUser::getTaskState, (Object)unifiedTaskUser.getTaskState());
            if (ToolUtil.isNotEmpty((Object)unifiedTaskUser.getUserId())) {
                wrapper.eq(UnifiedTaskUser::getUserId, (Object)unifiedTaskUser.getUserId());
            }
            this.unifiedTaskUserServiceImpl.remove((Wrapper)wrapper);
        }
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> transferUserTask(TransferTaskDto transferTaskDto) {
        ArrayList<String> userIds = new ArrayList<String>();
        userIds.add(transferTaskDto.getUserId());
        Map<String, Object> userIdCardsMap = this.getUserIdListByUserIdCars(userIds);
        if (userIdCardsMap.containsKey(transferTaskDto.getUserId())) {
            StaffBo bo = (StaffBo)userIdCardsMap.get(transferTaskDto.getUserId());
            transferTaskDto.setUserId(String.valueOf(bo.getId()));
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        if (HussarUtils.isNotEmpty((Object)transferTaskDto.getSystemId())) {
            wrapper.eq(UnifiedTaskUser::getSystemId, (Object)transferTaskDto.getSystemId());
        }
        ((LambdaUpdateWrapper)wrapper.eq(UnifiedTaskUser::getTaskId, (Object)transferTaskDto.getTaskId())).eq(UnifiedTaskUser::getUserType, (Object)"1");
        List unifiedTaskUsers = this.unifiedTaskUserService.list((Wrapper)wrapper);
        if (HussarUtils.isNotEmpty((Object)unifiedTaskUsers)) {
            for (UnifiedTaskUser unifiedTaskUser : unifiedTaskUsers) {
                if ((!HussarUtils.isEmpty((Object)unifiedTaskUser.getMandator()) || !unifiedTaskUser.getUserId().equals(transferTaskDto.getConsignor())) && (!HussarUtils.isNotEmpty((Object)unifiedTaskUser.getMandator()) || !unifiedTaskUser.getMandator().equals(transferTaskDto.getConsignor()))) continue;
                unifiedTaskUser.setUserId(transferTaskDto.getUserId());
                unifiedTaskUser.setMandator(transferTaskDto.getConsignor());
                unifiedTaskUser.setTaskState("2");
                unifiedTaskUser.setUserName((String)transferTaskDto.getMap().get(transferTaskDto.getUserId()));
                unifiedTaskUser.setMandatorName((String)transferTaskDto.getMap().get(transferTaskDto.getConsignor()));
                this.unifiedTaskUserService.updateById((Object)unifiedTaskUser);
            }
        }
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> addUrgeTask(SaveToDoDto saveToDoDto) {
        ArrayList<String> userIds = new ArrayList<String>();
        userIds.add(saveToDoDto.getUrgeUserId());
        Map<String, Object> userIdCardsMap = this.getUserIdListByUserIdCars(userIds);
        if (userIdCardsMap.containsKey(saveToDoDto.getUrgeUserId())) {
            StaffBo bo = (StaffBo)userIdCardsMap.get(saveToDoDto.getUrgeUserId());
            saveToDoDto.setUrgeUserId(String.valueOf(bo.getId()));
            saveToDoDto.setUrgeUserName(bo.getStaffName());
        }
        LambdaUpdateWrapper wrapperInfo = new LambdaUpdateWrapper();
        if (HussarUtils.isAllEmpty((Object[])new Object[]{saveToDoDto.getTaskId(), saveToDoDto.getBusinessid(), saveToDoDto.getProcessInstanceid()})) {
            return ApiResponse.fail((String)"\u53c2\u6570\u4e0d\u53ef\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        if (HussarUtils.isNotEmpty((Object)saveToDoDto.getBusinessid())) {
            wrapperInfo.eq(UnifiedTaskInfo::getBusinessid, (Object)saveToDoDto.getBusinessid());
        }
        if (HussarUtils.isNotEmpty((Object)saveToDoDto.getProcessInstanceid())) {
            wrapperInfo.eq(UnifiedTaskInfo::getProcessInstanceid, (Object)saveToDoDto.getProcessInstanceid());
        }
        if (HussarUtils.isNotEmpty((Object)saveToDoDto.getSystemId())) {
            wrapperInfo.eq(UnifiedTaskInfo::getSystemId, (Object)saveToDoDto.getSystemId());
        }
        wrapperInfo.eq(UnifiedTaskInfo::getTaskStatus, (Object)"0");
        List taskInfoList = this.unifiedTaskInfoServiceImpl.list((Wrapper)wrapperInfo);
        wrapperInfo.set(UnifiedTaskInfo::getUrgeUserId, (Object)saveToDoDto.getUrgeUserId());
        if (HussarUtils.isNotEmpty((Object)saveToDoDto.getUrgeUserName())) {
            wrapperInfo.set(UnifiedTaskInfo::getUrgeUserName, (Object)saveToDoDto.getUrgeUserName());
        }
        this.unifiedTaskInfoServiceImpl.update((Wrapper)wrapperInfo);
        ArrayList<UnifiedTaskUser> unifiedTaskUserList = new ArrayList<UnifiedTaskUser>();
        for (UnifiedTaskInfo unifiedTaskInfo : taskInfoList) {
            String taskId = unifiedTaskInfo.getTaskId();
            LambdaUpdateWrapper taskUserWrapperInfo = new LambdaUpdateWrapper();
            taskUserWrapperInfo.eq(UnifiedTaskUser::getTaskId, (Object)taskId);
            taskUserWrapperInfo.isNull(UnifiedTaskUser::getUrgeStatus);
            taskUserWrapperInfo.eq(UnifiedTaskUser::getUserType, (Object)"1");
            List list = this.unifiedTaskUserServiceImpl.list((Wrapper)taskUserWrapperInfo);
            for (UnifiedTaskUser taskUser : list) {
                UnifiedTaskUser unifiedTaskUser = new UnifiedTaskUser();
                unifiedTaskUser.setTodoId(unifiedTaskInfo.getTodoId());
                unifiedTaskUser.setSystemId(unifiedTaskInfo.getSystemId());
                unifiedTaskUser.setTaskId(unifiedTaskInfo.getTaskId());
                unifiedTaskUser.setUserId(taskUser.getUserId());
                unifiedTaskUser.setExecuteStatus("0");
                unifiedTaskUser.setUserType("1");
                unifiedTaskUser.setUrgeStatus("1");
                unifiedTaskUser.setUrgeTime(saveToDoDto.getUrgeTime());
                unifiedTaskUserList.add(unifiedTaskUser);
            }
        }
        this.unifiedTaskUserServiceImpl.saveBatch(unifiedTaskUserList);
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> addStartProcess(SaveProcessHtszDto saveProcessDto) {
        if (HussarUtils.isNotEmpty((Object)saveProcessDto.getCreateUserId())) {
            ArrayList<String> userIds = new ArrayList<String>();
            userIds.add(saveProcessDto.getCreateUserId());
            Map<String, Object> userIdCardsMap = this.getUserIdListByUserIdCars(userIds);
            if (userIdCardsMap.containsKey(saveProcessDto.getCreateUserId())) {
                StaffBo bo = (StaffBo)userIdCardsMap.get(saveProcessDto.getCreateUserId());
                saveProcessDto.setCreateUserId(String.valueOf(bo.getId()));
                saveProcessDto.setCreateUserName(bo.getStaffName());
            }
        }
        this.unifiedStartTaskServiceImpl.save((Object)saveProcessDto);
        return ApiResponse.success((Object)"", null);
    }

    public ApiResponse<String> updateStartProcess(SaveProcessHtszDto saveProcessDto) {
        UnifiedLog unifiedLog = new UnifiedLog();
        if (HussarUtils.isNotEmpty((Object)saveProcessDto.getLogId())) {
            unifiedLog.setLogId(Long.valueOf(saveProcessDto.getLogId()));
        }
        unifiedLog.setPathName("/unified/unifiedExternal/deleteStartProcess");
        unifiedLog.setStartTime(LocalDateTime.now());
        unifiedLog.setParameter(JSON.toJSONString((Object)saveProcessDto, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
        UnifiedSystemInfo systemInfo = (UnifiedSystemInfo)this.unifiedSystemInfoMapper.selectById((Serializable)saveProcessDto.getSystemId());
        unifiedLog.setSystemName(systemInfo.getSystemName());
        unifiedLog.setSystemSource(systemInfo.getSystemSource());
        unifiedLog.setSystemId(systemInfo.getSystemId());
        try {
            if (HussarUtils.isNotEmpty((Object)saveProcessDto.getCreateUserId())) {
                ArrayList<String> userIds = new ArrayList<String>();
                userIds.add(saveProcessDto.getCreateUserId());
                Map<String, Object> userIdCardsMap = this.getUserIdListByUserIdCars(userIds);
                if (userIdCardsMap.containsKey(saveProcessDto.getCreateUserId())) {
                    StaffBo bo = (StaffBo)userIdCardsMap.get(saveProcessDto.getCreateUserId());
                    saveProcessDto.setCreateUserId(String.valueOf(bo.getId()));
                    saveProcessDto.setCreateUserName(bo.getStaffName());
                }
            }
            String businessId = saveProcessDto.getBusinessId();
            String processInstanceId = saveProcessDto.getProcInstId();
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            if (HussarUtils.isNotEmpty((Object)businessId)) {
                wrapper.eq(UnifiedStartTask::getBusinessId, (Object)businessId);
            }
            if (HussarUtils.isNotEmpty((Object)processInstanceId)) {
                wrapper.eq(UnifiedStartTask::getProcInstId, (Object)processInstanceId);
            }
            wrapper.set(UnifiedStartTask::getEndTime, (Object)saveProcessDto.getEndTime());
            wrapper.set(UnifiedStartTask::getProcessState, (Object)saveProcessDto.getProcessState());
            if (HussarUtils.isNotEmpty((Object)saveProcessDto.getProcessTitle())) {
                wrapper.set(UnifiedStartTask::getProcessTitle, (Object)saveProcessDto.getProcessTitle());
            }
            if (HussarUtils.isNotEmpty((Object)saveProcessDto.getDataDetail())) {
                wrapper.set(UnifiedStartTask::getDataDetail, (Object)saveProcessDto.getDataDetail());
            }
            this.unifiedStartTaskServiceImpl.update((Wrapper)wrapper);
            unifiedLog.setSuccessState("1");
            unifiedLog.setErrorReason(null);
            this.unifiedLogService.saveOrUpdate((Object)unifiedLog);
            return ApiResponse.success((Object)"", null);
        }
        catch (Exception e) {
            unifiedLog.setSuccessState("0");
            unifiedLog.setErrorReason(e.toString());
            this.unifiedLogService.saveOrUpdate((Object)unifiedLog);
            return ApiResponse.fail((String)"\u4fee\u6539\u6d41\u7a0b\u72b6\u6001\u5931\u8d25\uff01");
        }
    }

    public ApiResponse<String> deleteStartProcess(SaveProcessHtszDto saveProcessDto) {
        UnifiedLog unifiedLog = new UnifiedLog();
        if (HussarUtils.isNotEmpty((Object)saveProcessDto.getLogId())) {
            unifiedLog.setLogId(Long.valueOf(saveProcessDto.getLogId()));
        }
        unifiedLog.setPathName("/unified/unifiedExternal/deleteStartProcess");
        unifiedLog.setStartTime(LocalDateTime.now());
        unifiedLog.setParameter(JSON.toJSONString((Object)saveProcessDto, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
        UnifiedSystemInfo systemInfo = (UnifiedSystemInfo)this.unifiedSystemInfoMapper.selectById((Serializable)saveProcessDto.getSystemId());
        unifiedLog.setSystemName(systemInfo.getSystemName());
        unifiedLog.setSystemSource(systemInfo.getSystemSource());
        unifiedLog.setSystemId(systemInfo.getSystemId());
        try {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            if (HussarUtils.isNotEmpty((Object)saveProcessDto.getBusinessId())) {
                wrapper.eq(UnifiedStartTask::getBusinessId, (Object)saveProcessDto.getBusinessId());
            }
            if (HussarUtils.isNotEmpty((Object)saveProcessDto.getProcInstId())) {
                String processInstanceIds = saveProcessDto.getProcInstId();
                List<String> processInstanceIdList = Arrays.asList(processInstanceIds.split(","));
                wrapper.in(UnifiedStartTask::getProcInstId, processInstanceIdList);
            }
            this.unifiedStartTaskServiceImpl.remove((Wrapper)wrapper);
            unifiedLog.setSuccessState("1");
            unifiedLog.setErrorReason(null);
            this.unifiedLogService.saveOrUpdate((Object)unifiedLog);
            return ApiResponse.success((Object)"", null);
        }
        catch (Exception e) {
            unifiedLog.setSuccessState("0");
            unifiedLog.setErrorReason(e.toString());
            this.unifiedLogService.saveOrUpdate((Object)unifiedLog);
            return ApiResponse.fail((String)"\u5220\u9664\u6d41\u7a0b\u5931\u8d25\uff01");
        }
    }

    public ApiResponse<String> updateBusinessInfo(SaveToDoHtszDto saveToDoDto) {
        UnifiedLog unifiedLog = new UnifiedLog();
        if (HussarUtils.isNotEmpty((Object)saveToDoDto.getLogId())) {
            unifiedLog.setLogId(Long.valueOf(saveToDoDto.getLogId()));
        }
        unifiedLog.setPathName("/unified/unifiedExternal/deleteStartProcess");
        unifiedLog.setStartTime(LocalDateTime.now());
        unifiedLog.setParameter(JSON.toJSONString((Object)saveToDoDto, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
        UnifiedSystemInfo systemInfo = (UnifiedSystemInfo)this.unifiedSystemInfoMapper.selectById((Serializable)saveToDoDto.getSystemId());
        unifiedLog.setSystemName(systemInfo.getSystemName());
        unifiedLog.setSystemSource(systemInfo.getSystemSource());
        unifiedLog.setSystemId(systemInfo.getSystemId());
        try {
            StaffBo bo;
            Object bo2;
            List executors = saveToDoDto.getExecutors();
            List followers = saveToDoDto.getFollowers();
            ArrayList<String> userIds = new ArrayList<String>();
            userIds.add(saveToDoDto.getCreateUserId());
            userIds.add(saveToDoDto.getSendUserId());
            userIds.add(saveToDoDto.getMandator());
            for (UnifiedTaskUser executor : executors) {
                userIds.add(executor.getUserId());
                userIds.add(executor.getMandator());
            }
            for (UnifiedTaskUser follower : followers) {
                userIds.add(follower.getUserId());
                userIds.add(follower.getMandator());
            }
            Map<String, Object> userIdCardsMap = this.getUserIdListByUserIdCars(userIds);
            if (userIdCardsMap.containsKey(saveToDoDto.getCreateUserId())) {
                bo2 = (StaffBo)userIdCardsMap.get(saveToDoDto.getCreateUserId());
                saveToDoDto.setCreateUserId(String.valueOf(bo2.getId()));
                saveToDoDto.setCreateUserName(bo2.getStaffName());
            }
            if (userIdCardsMap.containsKey(saveToDoDto.getSendUserId())) {
                bo2 = (StaffBo)userIdCardsMap.get(saveToDoDto.getSendUserId());
                saveToDoDto.setSendUserId(String.valueOf(bo2.getId()));
                saveToDoDto.setSendUserName(bo2.getStaffName());
            }
            for (UnifiedTaskUser executor : executors) {
                if (userIdCardsMap.containsKey(executor.getUserId())) {
                    bo = (StaffBo)userIdCardsMap.get(executor.getUserId());
                    executor.setUserId(String.valueOf(bo.getId()));
                    executor.setUserName(bo.getStaffName());
                }
                if (!userIdCardsMap.containsKey(executor.getMandator())) continue;
                bo = (StaffBo)userIdCardsMap.get(executor.getMandator());
                executor.setMandator(String.valueOf(bo.getId()));
                executor.setMandatorName(bo.getStaffName());
            }
            for (UnifiedTaskUser follower : followers) {
                if (userIdCardsMap.containsKey(follower.getUserId())) {
                    bo = (StaffBo)userIdCardsMap.get(follower.getUserId());
                    follower.setUserId(String.valueOf(bo.getId()));
                    follower.setUserName(bo.getStaffName());
                }
                if (!userIdCardsMap.containsKey(follower.getMandator())) continue;
                bo = (StaffBo)userIdCardsMap.get(follower.getMandator());
                follower.setMandator(String.valueOf(bo.getId()));
                follower.setMandatorName(bo.getStaffName());
            }
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            if (HussarUtils.isNotEmpty((Object)saveToDoDto.getProcessInstanceid())) {
                wrapper.eq(UnifiedTaskInfo::getProcessInstanceid, (Object)saveToDoDto.getProcessInstanceid());
            }
            if (HussarUtils.isNotEmpty((Object)saveToDoDto.getBusinessid())) {
                wrapper.eq(UnifiedTaskInfo::getBusinessid, (Object)saveToDoDto.getBusinessid());
            }
            if (HussarUtils.isNotEmpty((Object)saveToDoDto.getProcessTitle())) {
                wrapper.set(UnifiedTaskInfo::getProcessTitle, (Object)saveToDoDto.getProcessTitle());
            }
            if (HussarUtils.isNotEmpty((Object)saveToDoDto.getDataDetail())) {
                wrapper.set(UnifiedTaskInfo::getDataDetail, (Object)saveToDoDto.getDataDetail());
            }
            this.unifiedTaskInfoServiceImpl.update((Wrapper)wrapper);
            unifiedLog.setSuccessState("1");
            unifiedLog.setErrorReason(null);
            this.unifiedLogService.saveOrUpdate((Object)unifiedLog);
            return ApiResponse.success((Object)"", null);
        }
        catch (Exception e) {
            unifiedLog.setSuccessState("0");
            unifiedLog.setErrorReason(e.toString());
            this.unifiedLogService.saveOrUpdate((Object)unifiedLog);
            return ApiResponse.fail((String)"\u66f4\u65b0\u5931\u8d25\uff01");
        }
    }

    private Map<String, Object> getUserIdListByUserIdCars(List<String> userIdCards) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        if (list != null && !list.isEmpty()) {
            for (StaffBo bo : list) {
                map.put(bo.getIdcard(), bo);
            }
        }
        return map;
    }
}

