/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unifiedtodo.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.unifiedtodo.dto.FeignTaskQueryDto;
import com.jxdinfo.hussar.unifiedtodo.dto.QueryToDoDto;
import com.jxdinfo.hussar.unifiedtodo.dto.SaveToDoDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UpdateTaskStatusDto;
import com.jxdinfo.hussar.unifiedtodo.dto.UpdateTaskUserToDoDto;
import com.jxdinfo.hussar.unifiedtodo.feign.RemoteIUnifiedToDoService;
import com.jxdinfo.hussar.unifiedtodo.model.UnifiedTaskUser;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedToDoService;
import com.jxdinfo.hussar.unifiedtodo.vo.ToDoVo;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteIUnifiedToDoServiceImpl
implements IUnifiedToDoService {
    @Autowired
    private RemoteIUnifiedToDoService remoteIUnifiedToDoService;

    public ApiResponse<Long> getCountTotal(String systemId, String userId, String executeStatus) {
        return this.remoteIUnifiedToDoService.getCountTotal(systemId, userId, executeStatus);
    }

    public ApiResponse<String> saveTask(SaveToDoDto saveToDoDto) {
        return this.remoteIUnifiedToDoService.saveTask(saveToDoDto);
    }

    public ApiResponse<String> updateTask(SaveToDoDto saveToDoDto) {
        return this.remoteIUnifiedToDoService.updateTask(saveToDoDto);
    }

    public ApiResponse<Page<SaveToDoDto>> getListTask(Page<SaveToDoDto> page, QueryToDoDto queryToDoDto) {
        FeignTaskQueryDto feignTaskQueryDto = new FeignTaskQueryDto(queryToDoDto);
        return this.remoteIUnifiedToDoService.getListTask(feignTaskQueryDto);
    }

    public ApiResponse<ToDoVo> getToDoByTaskId(String todoId) {
        return this.remoteIUnifiedToDoService.getTaskDetail(todoId);
    }

    public ApiResponse<String> deleteTask(String taskIds, String systemId, String processInstId) {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("taskIds", taskIds);
        body.put("systemId", systemId);
        body.put("processInstId", processInstId);
        return this.remoteIUnifiedToDoService.deleteTask(body);
    }

    public ApiResponse<String> updateTaskStatus(String taskId, String systemId, String processInstId, String taskStatus, String webLinkurl, String mobileLinkurl, String lastTime) {
        return this.remoteIUnifiedToDoService.updateTaskStatus(new UpdateTaskStatusDto(taskId, systemId, processInstId, taskStatus, webLinkurl, mobileLinkurl, lastTime));
    }

    public ApiResponse<String> updateUserStatus(UnifiedTaskUser unifiedTaskUser) {
        return this.remoteIUnifiedToDoService.updateUserStatus(unifiedTaskUser);
    }

    public ApiResponse<String> updateTaskUser(String taskId, String systemId, String executeStatus, List<UnifiedTaskUser> executors, List<UnifiedTaskUser> followers) {
        UpdateTaskUserToDoDto updateTaskUserToDoDto = new UpdateTaskUserToDoDto();
        updateTaskUserToDoDto.setTaskId(taskId);
        updateTaskUserToDoDto.setSystemId(systemId);
        updateTaskUserToDoDto.setExecuteStatus(executeStatus);
        updateTaskUserToDoDto.setExecutors(executors);
        updateTaskUserToDoDto.setFollowers(followers);
        return this.remoteIUnifiedToDoService.updateTaskUser(taskId, systemId, executeStatus, updateTaskUserToDoDto);
    }

    public ApiResponse<String> updateTaskUser(String taskId, String systemId, String executeStatus, UpdateTaskUserToDoDto updateTaskUserToDoDto) {
        return this.remoteIUnifiedToDoService.updateTaskUser(taskId, systemId, executeStatus, updateTaskUserToDoDto);
    }

    public ApiResponse<String> transferTaskDeleteTaskUser(List<UnifiedTaskUser> unifiedTaskUsers) {
        return this.remoteIUnifiedToDoService.transferTaskDeleteTaskUser(unifiedTaskUsers);
    }

    public ApiResponse<String> addTaskUser(List<UnifiedTaskUser> unifiedTaskUsers) {
        return this.remoteIUnifiedToDoService.addTaskUser(unifiedTaskUsers);
    }

    public ApiResponse<String> deleteTaskUser(List<UnifiedTaskUser> unifiedTaskUsers) {
        return this.remoteIUnifiedToDoService.deleteTaskUser(unifiedTaskUsers);
    }
}

