/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.unifiedAuthentication.intercept;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.authentication.service.SysAuthClientModelService;
import com.jxdinfo.hussar.authorization.post.service.ISysPostService;
import com.jxdinfo.hussar.base.cloud.model.client.SysAuthClientModel;
import com.jxdinfo.hussar.common.exception.ExtendLoginException;
import com.jxdinfo.hussar.encrypt.util.SM2Util;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.DefaultCacheUtil;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityRequest;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityResponse;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import com.jxdinfo.hussar.support.security.plugin.oauth2.customizers.HussarSecurityAuthenticationService;
import com.jxdinfo.hussar.support.security.plugin.oauth2.customizers.HussarSecurityOAuth2InterceptorCustomizers;
import com.jxdinfo.hussar.support.security.plugin.oauth2.customizers.dto.SecurityAuthenticationDto;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Constants;
import com.jxdinfo.hussar.unifiedAuthentication.config.UnifiedAuthenticationProperties;
import com.jxdinfo.hussar.unifiedAuthentication.util.HttpClientUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class UnifiedAuthenticationInterceptor
implements HussarSecurityOAuth2InterceptorCustomizers {
    @Autowired
    private UnifiedAuthenticationProperties unifiedAuthenticationProperties;
    @Resource
    private HussarSecurityAuthenticationService hussarSecurityAuthenticationService;
    @Autowired
    private ISysPostService sysPostService;
    @Autowired
    private SysAuthClientModelService sysAuthClientModelService;
    @Value(value="${sso-login.clientId:''}")
    String clientId;
    @Value(value="${sso-login.clientSecret:''}")
    String clientSecret;
    @Value(value="${sso-login.grantType:''}")
    String grantType;
    @Value(value="${sso-login.redirectUri:''}")
    String redirectUri;
    @Value(value="${sso-login.ssoUrl:''}")
    String ssoUrl;
    @Value(value="${hussar.core.encrypt.enable-pw-encryption: false}")
    boolean enablePwEncryption;
    private static final Logger logger = LoggerFactory.getLogger(UnifiedAuthenticationInterceptor.class);

    public void customize(SecurityRequest securityRequest, SecurityResponse securityResponse) {
        String userName;
        String deptId = securityRequest.getHeader("deptId");
        String postId = securityRequest.getHeader("postId");
        String originDeptId = securityRequest.getHeader("originDeptId");
        String originPostId = securityRequest.getHeader("originPostId");
        String mdmDeptId = securityRequest.getHeader("mdmDeptId");
        String mdmPostId = securityRequest.getHeader("mdmPostId");
        String tokenHeader = securityRequest.getHeader(this.unifiedAuthenticationProperties.getHeaderToken());
        if (HussarUtils.isEmpty((Object)tokenHeader)) {
            return;
        }
        String clientId = securityRequest.getHeader("Client-Id");
        String checkToken = (String)DefaultCacheUtil.get((Object)"checkToken");
        if (HussarUtils.isEmpty((Object)checkToken) || tokenHeader.equals(checkToken)) {
            userName = this.getUserInfo(tokenHeader, securityResponse);
            SysAuthClientModel sysAuthClientModel = (SysAuthClientModel)this.sysAuthClientModelService.getOne((Wrapper)Wrappers.lambdaQuery().eq(SysAuthClientModel::getClientId, (Object)clientId));
            DefaultCacheUtil.put((Object)"checkToken", (Object)tokenHeader, (long)sysAuthClientModel.getAccessTokenValidTime());
            DefaultCacheUtil.put((Object)"userNameToken", (Object)userName, (long)sysAuthClientModel.getAccessTokenValidTime());
        } else {
            userName = (String)DefaultCacheUtil.get((Object)"userNameToken");
        }
        String tokenHeaderValue = (String)DefaultCacheUtil.get((Object)tokenHeader);
        logger.info("\u8fdb\u5165UnifiedAuthenticationImpl");
        if (HussarUtils.isEmpty((Object)tokenHeaderValue)) {
            SecurityAuthenticationDto dto = new SecurityAuthenticationDto();
            dto.setClientId(clientId);
            dto.setUsername(userName);
            if (this.enablePwEncryption) {
                dto.setPassword(this.encrypt("password"));
            } else {
                dto.setPassword("password");
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("loginType", "unifiedAuth");
            paramMap.put("loginCode", tokenHeader);
            dto.setParamsMapExcludeParam(paramMap);
            ApiResponse mapApiResponse = this.hussarSecurityAuthenticationService.securityPassword(dto);
            Map data = (Map)mapApiResponse.getData();
            logger.info("\u83b7\u53d6token\u7684\u8fd4\u56de\u503c\uff1a" + JSON.toJSONString((Object)data));
            if (HussarUtils.isNull((Object)data)) {
                return;
            }
            Object tokenObject = data.get(SecurityOAuth2Constants.Param.access_token);
            if (HussarUtils.isNull(tokenObject)) {
                return;
            }
            String token = String.valueOf(tokenObject);
            DefaultCacheUtil.put((Object)tokenHeader, (Object)token);
            DefaultCacheUtil.put((Object)token, (Object)tokenHeader);
            securityRequest.setHeaderForce("Authorization", String.valueOf(token));
            HussarSecurityUtils.getLoginUserDetails((String)String.valueOf(token));
            this.sysPostService.changePostBy(deptId, postId, originDeptId, originPostId, mdmDeptId, mdmPostId);
        } else {
            Object value = DefaultCacheUtil.get((Object)tokenHeader);
            securityRequest.setHeaderForce("Authorization", String.valueOf(value));
            UserDetails loginUserDetails = HussarSecurityUtils.getLoginUserDetails((String)String.valueOf(value));
            this.sysPostService.changePostBy(deptId, postId, originDeptId, originPostId, mdmDeptId, mdmPostId, loginUserDetails);
        }
    }

    private String getUserInfo(String token, SecurityResponse securityResponse) {
        try {
            String userInfo = HttpClientUtil.sendGet(this.ssoUrl + "profile?access_token=" + token, "");
            if (String.valueOf(401).equals(userInfo)) {
                logger.info("\u7edf\u4e00\u8ba4\u8bc1token\u8fc7\u671f\u5931\u6548");
                securityResponse.setStatus(401);
                throw new Exception();
            }
            JSONObject userObject = (JSONObject)JSONArray.parse((String)userInfo);
            Map attributes = (Map)userObject.get((Object)"attributes");
            Object realName = attributes.get("realName");
            return String.valueOf(realName);
        }
        catch (Exception e) {
            throw new ExtendLoginException("\u8bf7\u6c42\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u63a5\u53e3\u5931\u8d25");
        }
    }

    private String encrypt(String encryptPwd) {
        String pwd;
        try {
            String sm2PriKey = (String)HussarFixedCacheUtil.get((String)"pw_encrypt_cache", (Object)"pw_encrypt_sm2_pub", String.class);
            pwd = SM2Util.encrypt((String)encryptPwd, (String)sm2PriKey);
        }
        catch (Exception var4) {
            throw new HussarException("\u767b\u5f55\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25");
        }
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)pwd), (String)"\u767b\u5f55\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25");
        return pwd;
    }
}

