/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.theme.config.util;

import com.jxdinfo.hussar.platform.core.utils.url.URLDecoder;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Part;
import org.springframework.web.multipart.MultipartFile;

public class FilenameEncodingDetector {
    public static String detectAndFixFilename(MultipartFile file) {
        try {
            String rfc5987Name = FilenameEncodingDetector.extractRfc5987Filename(file);
            if (rfc5987Name != null) {
                return rfc5987Name;
            }
            String originalName = file.getOriginalFilename();
            if (originalName == null) {
                return "";
            }
            if (originalName.matches(".*%[0-9A-Fa-f]{2}.*")) {
                return URLDecoder.decode((String)originalName, (Charset)StandardCharsets.UTF_8);
            }
            if (FilenameEncodingDetector.isValidUtf8(originalName.getBytes(StandardCharsets.ISO_8859_1))) {
                return new String(originalName.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
            }
            String systemDefaultDecoded = new String(originalName.getBytes(StandardCharsets.ISO_8859_1), Charset.defaultCharset());
            if (!systemDefaultDecoded.contains("?")) {
                return systemDefaultDecoded;
            }
            return originalName;
        }
        catch (Exception e) {
            return file.getOriginalFilename();
        }
    }

    private static String extractRfc5987Filename(MultipartFile file) throws Exception {
        Field partField = file.getClass().getDeclaredField("part");
        partField.setAccessible(true);
        Part part = (Part)partField.get(file);
        String disposition = part.getHeader("content-disposition");
        Matcher matcher = Pattern.compile("filename\\*=(?:UTF-8|utf-8)''([^;]+)").matcher(disposition);
        if (matcher.find()) {
            return URLDecoder.decode((String)matcher.group(1), (Charset)StandardCharsets.UTF_8);
        }
        return null;
    }

    private static boolean isValidUtf8(byte[] bytes) {
        try {
            String test = new String(bytes, StandardCharsets.UTF_8);
            return !test.contains("?");
        }
        catch (Exception e) {
            return false;
        }
    }
}

