/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.url.service.feign.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.model.DefaultTenant;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.service.IHussarBaseTenantService;
import com.jxdinfo.hussar.tenant.common.service.IHussarTenantCommonService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantCommonUtil;
import com.jxdinfo.hussar.tenant.url.model.SolitaryurlTenant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@DependsOn(value={"springContextHolder"})
@Service(value="com.jxdinfo.hussar.tenant.url.service.feign.impl.remoteUrlTenantTypeParseServiceImpl")
public class RemoteUrlTenantTypeParseServiceImpl
implements IHussarTenantCommonService {
    @Autowired
    private ISysTenantService tenantService;
    @Autowired
    private IHussarBaseTenantService<SolitaryurlTenant> solitaryurlTenantService;

    public HussarTenantDefinition parse() {
        String tenantCode = TenantCommonUtil.getTenantCodeByUrl();
        if (HussarUtils.isNotBlank((CharSequence)tenantCode)) {
            return this.search(tenantCode);
        }
        return new DefaultTenant();
    }

    private HussarTenantDefinition search(String tenantCode) {
        HussarTenantDefinition tenantByTenantCode = TenantCacheUtil.loadFromCacheByTenantCode((String)tenantCode);
        if (HussarUtils.isEmpty((Object)tenantByTenantCode)) {
            SysTenant tenant = (SysTenant)this.tenantService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenant::getTenantCode, (Object)tenantCode));
            if (HussarUtils.isEmpty((Object)tenant)) {
                throw new BaseException("\u672a\u67e5\u8be2\u5230\u79df\u6237\u7f16\u7801\u4fe1\u606f:" + tenantCode);
            }
            Long tenantId = tenant.getId();
            tenantByTenantCode = this.solitaryurlTenantService.getTenantByTenantId(tenantId);
        }
        return tenantByTenantCode;
    }
}

