/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenantSyncData.service.impl;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.tenantSyncData.dao.TenantSyncDataMapper;
import com.jxdinfo.hussar.tenantSyncData.service.TenantSyncDataService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TenantSyncDataDto;
import com.jxdinfo.hussar.workflow.engine.bpm.tenantsyncdata.model.HussarBpmOrganView;
import com.jxdinfo.hussar.workflow.engine.bpm.tenantsyncdata.model.HussarBpmPostView;
import com.jxdinfo.hussar.workflow.engine.bpm.tenantsyncdata.model.HussarBpmRolesView;
import com.jxdinfo.hussar.workflow.engine.bpm.tenantsyncdata.model.HussarBpmUserPostConcurrentlyView;
import com.jxdinfo.hussar.workflow.engine.bpm.tenantsyncdata.model.HussarBpmUserPostMainView;
import com.jxdinfo.hussar.workflow.engine.bpm.tenantsyncdata.model.HussarBpmUserRoleView;
import com.jxdinfo.hussar.workflow.manage.engine.BpmTenantSyncDataService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TenantSyncDataServiceImpl
implements TenantSyncDataService {
    private static final Logger log = LoggerFactory.getLogger(TenantSyncDataServiceImpl.class);
    @Resource
    private TenantSyncDataMapper tenantSyncDataMapper;
    private int batchSize = 1000;

    public boolean syncHussarBpmOrganViewData() {
        log.info("\u540c\u6b65\u5de5\u4f5c\u6d41\u7ec4\u7ec7\u673a\u6784\u89c6\u56fe\u6570\u636e\u5f00\u59cb");
        boolean flag = true;
        List<HussarBpmOrganView> list = this.tenantSyncDataMapper.getHussarBpmOrganViewDto();
        int totalSize = list.size();
        for (int startIndex = 0; startIndex < totalSize; startIndex += this.batchSize) {
            int endIndex = Math.min(startIndex + this.batchSize, totalSize);
            List<HussarBpmOrganView> dataList = list.subList(startIndex, endIndex);
            TenantSyncDataDto tenantSyncDataDto = new TenantSyncDataDto();
            tenantSyncDataDto.setOrganList(dataList);
            ApiResponse response = BpmTenantSyncDataService.syncHussarBpmOrgan((TenantSyncDataDto)tenantSyncDataDto);
            if (response.getCode() == ResultCode.SUCCESS.getCode()) continue;
            log.error("\u540c\u6b65\u5de5\u4f5c\u6d41\u7ec4\u7ec7\u673a\u6784\u89c6\u56fe\u6570\u636e\u5931\u8d25\uff1a{}", (Object)response.getMsg());
            flag = false;
            break;
        }
        log.info("\u540c\u6b65\u5de5\u4f5c\u6d41\u7ec4\u7ec7\u673a\u6784\u89c6\u56fe\u6570\u636e\u7ed3\u675f");
        return flag;
    }

    public boolean syncHussarBpmPostViewData() {
        log.info("\u540c\u6b65\u5c97\u4f4d\u89c6\u56fe\u6570\u636e\u5f00\u59cb");
        boolean flag = true;
        List<HussarBpmPostView> list = this.tenantSyncDataMapper.getHussarBpmPostViewDto();
        int totalSize = list.size();
        for (int startIndex = 0; startIndex < totalSize; startIndex += this.batchSize) {
            int endIndex = Math.min(startIndex + this.batchSize, totalSize);
            List<HussarBpmPostView> dataList = list.subList(startIndex, endIndex);
            TenantSyncDataDto tenantSyncDataDto = new TenantSyncDataDto();
            tenantSyncDataDto.setPostList(dataList);
            ApiResponse response = BpmTenantSyncDataService.syncHussarBpmPost((TenantSyncDataDto)tenantSyncDataDto);
            if (response.getCode() == ResultCode.SUCCESS.getCode()) continue;
            log.error("\u540c\u6b65\u5c97\u4f4d\u89c6\u56fe\u6570\u636e\u5931\u8d25\uff1a{}", (Object)response.getMsg());
            flag = false;
            break;
        }
        log.info("\u540c\u6b65\u5c97\u4f4d\u89c6\u56fe\u6570\u636e\u7ed3\u675f");
        return flag;
    }

    public boolean syncHussarBpmRolesViewData() {
        log.info("\u540c\u6b65\u5de5\u4f5c\u6d41\u89d2\u8272\u89c6\u56fe\u6570\u636e\u5f00\u59cb");
        boolean flag = true;
        List<HussarBpmRolesView> list = this.tenantSyncDataMapper.getHussarBpmRolesViewDto();
        int totalSize = list.size();
        for (int startIndex = 0; startIndex < totalSize; startIndex += this.batchSize) {
            int endIndex = Math.min(startIndex + this.batchSize, totalSize);
            List<HussarBpmRolesView> dataList = list.subList(startIndex, endIndex);
            TenantSyncDataDto tenantSyncDataDto = new TenantSyncDataDto();
            tenantSyncDataDto.setRolesList(dataList);
            ApiResponse response = BpmTenantSyncDataService.syncHussarBpmRoles((TenantSyncDataDto)tenantSyncDataDto);
            if (response.getCode() == ResultCode.SUCCESS.getCode()) continue;
            log.error("\u540c\u6b65\u5de5\u4f5c\u6d41\u89d2\u8272\u89c6\u56fe\u6570\u636e\u5931\u8d25\uff1a{}", (Object)response.getMsg());
            flag = false;
            break;
        }
        log.info("\u540c\u6b65\u5de5\u4f5c\u6d41\u89d2\u8272\u89c6\u56fe\u6570\u636e\u7ed3\u675f");
        return flag;
    }

    public boolean syncHussarBpmUserPostConcurrentlyViewData() {
        log.info("\u540c\u6b65\u4eba\u5458\u90e8\u95e8\u540c\u6b65\u89c6\u56fe\u6570\u636e\u5f00\u59cb");
        boolean flag = true;
        List<HussarBpmUserPostConcurrentlyView> list = this.tenantSyncDataMapper.getHussarBpmUserPostConcurrentlyViewDto();
        int totalSize = list.size();
        for (int startIndex = 0; startIndex < totalSize; startIndex += this.batchSize) {
            int endIndex = Math.min(startIndex + this.batchSize, totalSize);
            List<HussarBpmUserPostConcurrentlyView> dataList = list.subList(startIndex, endIndex);
            TenantSyncDataDto tenantSyncDataDto = new TenantSyncDataDto();
            tenantSyncDataDto.setUserPostConcurrentlyList(dataList);
            ApiResponse response = BpmTenantSyncDataService.syncHussarBpmUserPostConcurrently((TenantSyncDataDto)tenantSyncDataDto);
            if (response.getCode() == ResultCode.SUCCESS.getCode()) continue;
            log.error("\u540c\u6b65\u4eba\u5458\u90e8\u95e8\u540c\u6b65\u89c6\u56fe\u6570\u636e\u5931\u8d25\uff1a{}", (Object)response.getMsg());
            flag = false;
            break;
        }
        log.info("\u540c\u6b65\u4eba\u5458\u90e8\u95e8\u540c\u6b65\u89c6\u56fe\u6570\u636e\u7ed3\u675f");
        return flag;
    }

    public boolean syncHussarBpmUserPostMainViewData() {
        log.info("\u540c\u6b65\u4eba\u5458\u4e3b\u5c97\u89c6\u56fe\u6570\u636e\u5f00\u59cb");
        boolean flag = true;
        List<HussarBpmUserPostMainView> list = this.tenantSyncDataMapper.getHussarBpmUserPostMainViewDto();
        int totalSize = list.size();
        for (int startIndex = 0; startIndex < totalSize; startIndex += this.batchSize) {
            int endIndex = Math.min(startIndex + this.batchSize, totalSize);
            List<HussarBpmUserPostMainView> dataList = list.subList(startIndex, endIndex);
            TenantSyncDataDto tenantSyncDataDto = new TenantSyncDataDto();
            tenantSyncDataDto.setUserPostMainList(dataList);
            ApiResponse response = BpmTenantSyncDataService.syncHussarBpmUserPostMain((TenantSyncDataDto)tenantSyncDataDto);
            if (response.getCode() == ResultCode.SUCCESS.getCode()) continue;
            log.error("\u540c\u6b65\u4eba\u5458\u4e3b\u5c97\u89c6\u56fe\u6570\u636e\u5931\u8d25\uff1a{}", (Object)response.getMsg());
            flag = false;
            break;
        }
        log.info("\u540c\u6b65\u4eba\u5458\u4e3b\u5c97\u89c6\u56fe\u6570\u636e\u7ed3\u675f");
        return flag;
    }

    public boolean syncHussarBpmUserRoleViewData() {
        log.info("\u540c\u6b65\u5de5\u4f5c\u6d41\u7528\u6237\u89d2\u8272\u89c6\u56fe\u6570\u636e\u5f00\u59cb");
        boolean flag = true;
        List<HussarBpmUserRoleView> list = this.tenantSyncDataMapper.getHussarBpmUserRoleViewDto();
        int totalSize = list.size();
        for (int startIndex = 0; startIndex < totalSize; startIndex += this.batchSize) {
            int endIndex = Math.min(startIndex + this.batchSize, totalSize);
            List<HussarBpmUserRoleView> dataList = list.subList(startIndex, endIndex);
            TenantSyncDataDto tenantSyncDataDto = new TenantSyncDataDto();
            tenantSyncDataDto.setUserRoleList(dataList);
            ApiResponse response = BpmTenantSyncDataService.syncHussarBpmUserRole((TenantSyncDataDto)tenantSyncDataDto);
            if (response.getCode() == ResultCode.SUCCESS.getCode()) continue;
            log.error("\u540c\u6b65\u5de5\u4f5c\u6d41\u7528\u6237\u89d2\u8272\u89c6\u56fe\u6570\u636e\u5931\u8d25\uff1a{}", (Object)response.getMsg());
            flag = false;
            break;
        }
        log.info("\u540c\u6b65\u5de5\u4f5c\u6d41\u7528\u6237\u89d2\u8272\u89c6\u56fe\u6570\u636e\u7ed3\u675f");
        return flag;
    }
}

