/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.runner;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.model.SysTenantLog;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantLogService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.EnvironmentUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.hussar.tenant.runner.tenantStatusCheckServiceRunner")
@Order(value=900003)
public class TenantStatusCheckServiceRunner
implements ApplicationRunner {
    @Autowired
    private ISysTenantLogService sysTenantLogService;
    @Autowired
    private ISysTenantService sysTenantService;

    private void checkUnexpectedInterruption() {
        int pageSize = 50;
        long totalRecord = this.sysTenantService.count((Wrapper)new LambdaQueryWrapper().eq(SysTenant::getTenantStatus, (Object)"3"));
        long totalLog = this.sysTenantLogService.count((Wrapper)new LambdaQueryWrapper().eq(SysTenantLog::getExecStatus, (Object)2));
        boolean isMicroservice = EnvironmentUtil.isMicroService();
        String serviceName = null;
        if (isMicroservice) {
            serviceName = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name");
        }
        if (totalRecord > 0L) {
            Long pageNum = totalRecord % (long)pageSize == 0L ? totalRecord / (long)pageSize : totalRecord / (long)pageSize + 1L;
            int i = 0;
            while ((long)i < pageNum) {
                int currentPage = i + 1;
                Page pageSysTenant = (Page)this.sysTenantService.page((IPage)new Page((long)currentPage, (long)pageSize), (Wrapper)new LambdaQueryWrapper().eq(SysTenant::getTenantStatus, (Object)"3"));
                List list = pageSysTenant.getRecords();
                HashMap<String, SysTenant> tenantMap = new HashMap<String, SysTenant>();
                ArrayList<String> tenantCodeList = new ArrayList<String>();
                for (SysTenant t : list) {
                    tenantMap.put(t.getTenantCode(), t);
                    tenantCodeList.add(t.getTenantCode());
                }
                this.sysTenantLogService.remove((Wrapper)new LambdaQueryWrapper().in(SysTenantLog::getTenantCode, tenantCodeList));
                ArrayList<SysTenantLog> logList = new ArrayList<SysTenantLog>();
                for (String tenantCode : tenantCodeList) {
                    SysTenantLog sysTenantLog = new SysTenantLog();
                    sysTenantLog.setServiceName(serviceName);
                    sysTenantLog.setTenantCode(tenantCode);
                    sysTenantLog.setExecError("\u670d\u52a1\u5668\u610f\u5916\u4e2d\u65ad\uff0c\u8be5\u79df\u6237\u5df2\u65e0\u6cd5\u4f7f\u7528");
                    sysTenantLog.setExecStatus(TenantConstant.UNEXPECTED_INTERRUPTION);
                    sysTenantLog.setMethodDesc("\u670d\u52a1\u5668\u610f\u5916\u4e2d\u65ad\uff0c\u8be5\u79df\u6237\u5df2\u65e0\u6cd5\u4f7f\u7528");
                    sysTenantLog.setCreateTime(LocalDateTime.now());
                    sysTenantLog.setLastTime(LocalDateTime.now());
                    logList.add(sysTenantLog);
                    HussarTenantDefinition hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)tenantCode);
                    if (null == hussarTenantDefinition) continue;
                    hussarTenantDefinition.setTenantStatus("4");
                    TenantCacheUtil.putTenat2Cache((HussarTenantDefinition)hussarTenantDefinition);
                }
                this.sysTenantLogService.saveBatch(logList);
                for (SysTenant sysTenant : list) {
                    sysTenant.setTenantStatus("4");
                }
                this.sysTenantService.updateBatchById((Collection)list);
                ++i;
            }
        }
        if (totalLog > 0L) {
            LambdaUpdateWrapper lambdaUpdateWrapper = new UpdateWrapper().lambda();
            ((LambdaUpdateWrapper)lambdaUpdateWrapper.set(SysTenantLog::getExecStatus, (Object)0)).eq(SysTenantLog::getExecStatus, (Object)2);
            this.sysTenantLogService.update((Object)new SysTenantLog(), (Wrapper)lambdaUpdateWrapper);
        }
    }

    public void run(ApplicationArguments args) throws Exception {
        this.checkUnexpectedInterruption();
    }
}

