/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOfficeBaseService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffBaseService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffBaseService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserBaseService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.service.TenantOrganizationUserService;
import com.jxdinfo.hussar.tenant.common.util.TenantAuthorizationUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTransactional
public class TenantOrganizationUserServiceImpl
implements TenantOrganizationUserService {
    @Autowired
    private ISysUsersService sysUsersService;
    @Autowired
    private ISysStruService sysStruService;
    @Autowired
    private ISysStruUserBaseService sysStruUserBaseService;
    @Autowired
    private ISysUserRoleService sysUserRoleService;
    @Autowired
    private ISysStruStaffBaseService sysStruStaffBaseService;
    @Autowired
    private ISysStaffBaseService sysStaffBaseService;
    @Autowired
    private ISysOrganService sysOrganService;
    @Autowired
    private ISysOfficeBaseService sysOfficeBaseService;
    @Autowired
    private SysStruMapper sysStruMapper;

    @HussarDs(value="#connName")
    @HussarTransactional
    public void removeSyncTenantStruAndUsers(String connName) {
        this.sysStruService.remove(connName, (Wrapper)new LambdaQueryWrapper());
        this.sysOrganService.remove(connName, (Wrapper)new LambdaQueryWrapper());
        this.sysOfficeBaseService.remove(connName, (Wrapper)new LambdaQueryWrapper());
        this.sysStruUserBaseService.remove(connName, (Wrapper)new LambdaQueryWrapper());
        this.sysUsersService.remove(connName, (Wrapper)new LambdaQueryWrapper().ne(SysUsers::getIsSys, (Object)"1"));
        this.sysUserRoleService.remove(connName, (Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getGrantedRole, (Object)1450785135866925064L));
        this.sysStaffBaseService.remove(connName, (Wrapper)new LambdaQueryWrapper());
        this.sysStruStaffBaseService.remove(connName, (Wrapper)new LambdaQueryWrapper());
    }

    @HussarDs(value="#connName")
    @HussarTransactional
    public void syncTenantStruAndUsers(String connName, List<SysStru> sysStruList, List<SysOrgan> sysOrgans, List<SysOffice> sysOffices, List<SysStruUser> sysStruUserList, Collection<Long> userIds, List<SysUsers> sysUsers, List<SysStaff> sysStaffs, List<SysStruStaff> sysStruStaffList) {
        this.sysStruService.saveBatch(connName, sysStruList);
        this.sysOrganService.saveBatch(connName, sysOrgans);
        this.sysOfficeBaseService.saveBatch(connName, sysOffices);
        if (HussarUtils.isNotEmpty(sysStruUserList)) {
            this.sysStruUserBaseService.saveBatch(connName, sysStruUserList);
            this.sysUsersService.saveBatch(connName, sysUsers);
            ArrayList<SysUserRole> sysUserRoles = new ArrayList<SysUserRole>();
            for (Long userId : userIds) {
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(userId);
                sysUserRole.setGrantedRole(Long.valueOf(1450785135866925064L));
                sysUserRole.setAdminOption("1");
                sysUserRoles.add(sysUserRole);
            }
            this.sysUserRoleService.saveBatch(connName, sysUserRoles);
            this.sysStaffBaseService.saveBatch(connName, sysStaffs);
            this.sysStruStaffBaseService.saveBatch(connName, sysStruStaffList);
        }
    }

    @HussarDs(value="#connName")
    @HussarTransactional
    public void initTernaryUserInfo(String connName, List<SysStaff> sysStaffs, List<SysUsers> sysUsers, List<SysUserRole> sysUserRoles) {
        this.sysStaffBaseService.saveBatch(connName, sysStaffs);
        this.sysUsersService.saveBatch(connName, sysUsers);
        this.sysUserRoleService.saveBatch(connName, sysUserRoles);
    }

    @HussarDs(value="#connName")
    @HussarTransactional
    public void updateTernaryUserInfo(String connName, List<SysStaff> sysStaffList, List<SysUsers> sysUsersList) {
        this.sysStaffBaseService.saveOrUpdateBatch(connName, sysStaffList);
        this.sysUsersService.saveOrUpdateBatch(connName, sysUsersList);
    }

    @HussarDs(value="#connName")
    @HussarTransactional
    public void removeTernaryUserInfo(String connName, List<Long> staffIds, List<Long> userIds) {
        this.sysStaffBaseService.removeByIds(connName, staffIds);
        this.sysUsersService.removeByIds(connName, userIds);
        this.sysUserRoleService.remove(connName, (Wrapper)new LambdaQueryWrapper().in(SysUserRole::getUserId, userIds));
    }

    @HussarDs(value="#connName")
    @HussarTransactional
    public void addUserOrStaff(String connName, List<SysUsers> sysUsersAdd, List<SysStruUser> sysStruUsersAdd, List<SysUserRole> sysUserRoles, List<SysStaff> sysStaffsAdd, List<SysStruStaff> sysStruStaffAdd) {
        try {
            this.sysUsersService.saveBatch(connName, sysUsersAdd);
            this.sysStruUserBaseService.saveBatch(connName, sysStruUsersAdd);
            this.sysUserRoleService.saveBatch(connName, sysUserRoles);
            this.sysStaffBaseService.saveBatch(connName, sysStaffsAdd);
            this.sysStruStaffBaseService.saveBatch(connName, sysStruStaffAdd);
        }
        catch (Exception e) {
            throw new BaseException("\u540c\u6b65\u65b0\u589e\u7528\u6237\u6216\u65b0\u589e\u4eba\u5458\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
        }
    }

    @HussarDs(value="#connName")
    @HussarTransactional
    public void updateUserOrStaffDel(String connName, Set<Long> userIdsDel, List<Long> struUsersIdsDel, List<Long> staffIdsDel) {
        try {
            this.sysUsersService.removeByIds(connName, userIdsDel);
            this.sysStruUserBaseService.removeByIds(connName, struUsersIdsDel);
            this.sysUserRoleService.remove(connName, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getGrantedRole, (Object)1450785135866925064L)).in(SysUserRole::getUserId, userIdsDel));
            this.sysStaffBaseService.removeByIds(connName, staffIdsDel);
            this.sysStruStaffBaseService.remove(connName, (Wrapper)new LambdaQueryWrapper().in(SysStruStaff::getStaffId, staffIdsDel));
        }
        catch (Exception e) {
            throw new BaseException("\u540c\u6b65\u4fee\u6539\u7528\u6237\u6216\u4fee\u6539\u4eba\u5458\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
        }
    }

    @HussarDs(value="#connName")
    @HussarTransactional
    public void updateUserOrStaffAdd(String connName, List<SysUsers> sysUsersAdd, List<SysStruUser> sysStruUsersAdd, List<SysUserRole> sysUserRoles, List<SysStaff> sysStaffsAdd, List<SysStruStaff> sysStruStaffAdd) {
        try {
            this.sysUsersService.saveBatch(connName, sysUsersAdd);
            this.sysStruUserBaseService.saveBatch(connName, sysStruUsersAdd);
            this.sysUserRoleService.saveBatch(connName, sysUserRoles);
            this.sysStaffBaseService.saveBatch(connName, sysStaffsAdd);
            this.sysStruStaffBaseService.saveBatch(connName, sysStruStaffAdd);
        }
        catch (Exception e) {
            throw new BaseException("\u540c\u6b65\u4fee\u6539\u7528\u6237\u6216\u4fee\u6539\u4eba\u5458\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
        }
    }

    @HussarDs(value="#connName")
    @HussarTransactional
    public void deleteOrStaffUser(String connName, List<Long> userIds, List<Long> staffIds) {
        try {
            this.sysUsersService.removeByIds(connName, userIds);
            this.sysStruUserBaseService.remove(connName, (Wrapper)new LambdaQueryWrapper().in(SysStruUser::getUserId, userIds));
            this.sysUserRoleService.remove(connName, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getGrantedRole, (Object)1450785135866925064L)).in(SysUserRole::getUserId, userIds));
            this.sysStaffBaseService.removeByIds(connName, staffIds);
            this.sysStruStaffBaseService.remove(connName, (Wrapper)new LambdaQueryWrapper().in(SysStruStaff::getStaffId, staffIds));
        }
        catch (Exception e) {
            throw new BaseException("\u540c\u6b65\u5220\u9664\u7528\u6237\u6216\u5220\u9664\u4eba\u5458\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
        }
    }

    @HussarDs(value="#connName")
    @HussarTransactional
    public void addStru(String connName, List<SysStru> sysStrusAdd, List<SysOrgan> sysOrgansAdd, List<SysOffice> sysOfficesAdd) {
        try {
            this.sysStruService.saveBatch(connName, sysStrusAdd);
            this.sysOrganService.saveBatch(connName, sysOrgansAdd);
            this.sysOfficeBaseService.saveBatch(connName, sysOfficesAdd);
        }
        catch (Exception e) {
            throw new BaseException("\u540c\u6b65\u65b0\u589e\u7ec4\u7ec7\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
        }
    }

    @HussarDs(value="#connName")
    @HussarTransactional
    public void updateStru(String connName, List<SysStru> sysStrus, SysStru sysStru, SysOrgan sysOrgan) {
        try {
            Long struId = sysStru.getId();
            SysStru tenantSysSru = (SysStru)this.sysStruService.getById(connName, (Serializable)struId);
            Long parentId = sysStru.getParentId();
            SysStru parentSysStru = (SysStru)this.sysStruService.getById(connName, (Serializable)parentId);
            if (HussarUtils.isNotEmpty((Object)tenantSysSru)) {
                if (HussarUtils.isNotEmpty((Object)parentSysStru)) {
                    this.sysStruService.updateById(connName, (Object)sysStru);
                    this.sysOrganService.updateById(connName, (Object)sysOrgan);
                } else if (HussarUtils.equals((Object)11L, (Object)tenantSysSru.getParentId())) {
                    sysStru.setParentId(Long.valueOf(11L));
                    this.sysStruService.updateById(connName, (Object)sysStru);
                    this.sysOrganService.updateById(connName, (Object)sysOrgan);
                } else {
                    Set struChild = TenantAuthorizationUtils.getStruChild(sysStrus, Collections.singletonList(struId));
                    this.sysStruService.removeByIds(connName, (Collection)struChild);
                    List organIdAll = sysStrus.parallelStream().filter(item -> struChild.contains(item.getId())).map(SysStru::getOrganId).collect(Collectors.toList());
                    this.sysOrganService.removeByIds(connName, organIdAll);
                    this.sysOfficeBaseService.remove(connName, (Wrapper)new LambdaQueryWrapper().in(SysOffice::getStruId, (Collection)struChild));
                    this.sysStruUserBaseService.remove(connName, (Wrapper)new LambdaQueryWrapper().in(SysStruUser::getStruId, (Collection)struChild));
                    List delUser = this.sysStruMapper.getDelUser();
                    if (HussarUtils.isNotEmpty((Object)delUser)) {
                        List userIds = delUser.parallelStream().map(SysUsers::getId).collect(Collectors.toList());
                        this.sysUsersService.removeByIds(connName, userIds);
                        this.sysUserRoleService.remove(connName, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getGrantedRole, (Object)1450785135866925064L)).in(SysUserRole::getUserId, userIds));
                        List staffIds = delUser.parallelStream().map(SysUsers::getEmployeeId).collect(Collectors.toList());
                        this.sysStaffBaseService.removeByIds(connName, staffIds);
                        this.sysStruStaffBaseService.remove(connName, (Wrapper)new LambdaQueryWrapper().in(SysStruStaff::getStaffId, staffIds));
                    }
                }
            } else if (HussarUtils.isNotEmpty((Object)parentSysStru)) {
                this.sysStruService.save(connName, (Object)sysStru);
                this.sysOrganService.save(connName, (Object)sysOrgan);
                SysOffice sysOffice = new SysOffice();
                sysOffice.setStruId(struId);
                this.sysOfficeBaseService.save(connName, (Object)sysOffice);
                Set struChild = TenantAuthorizationUtils.getStruChild(sysStrus, Collections.singletonList(struId));
                List sysStruUserList = this.sysStruUserBaseService.list("master", (Wrapper)new LambdaQueryWrapper().in(SysStruUser::getStruId, (Collection)struChild));
                Set userIds = sysStruUserList.parallelStream().map(SysStruUser::getUserId).collect(Collectors.toSet());
                List sysUsers = this.sysUsersService.listByIds("master", userIds);
                ArrayList<SysUserRole> sysUserRoles = new ArrayList<SysUserRole>();
                for (SysUsers sysUser : sysUsers) {
                    SysUserRole sysUserRole = new SysUserRole();
                    sysUserRole.setUserId(sysUser.getId());
                    sysUserRole.setGrantedRole(Long.valueOf(1450785135866925064L));
                    sysUserRole.setAdminOption("1");
                    sysUserRoles.add(sysUserRole);
                }
                List staffIds = sysUsers.parallelStream().map(SysUsers::getEmployeeId).collect(Collectors.toList());
                List sysStaffs = this.sysStaffBaseService.listByIds("master", staffIds);
                List sysStruStaffList = this.sysStruStaffBaseService.list("master", (Wrapper)new LambdaQueryWrapper().in(SysStruStaff::getStaffId, staffIds));
                this.sysStruUserBaseService.saveBatch(connName, (Collection)sysStruUserList);
                this.sysUsersService.saveBatch(connName, (Collection)sysUsers);
                this.sysUserRoleService.saveBatch(connName, sysUserRoles);
                this.sysStaffBaseService.saveBatch(connName, (Collection)sysStaffs);
                this.sysStruStaffBaseService.saveBatch(connName, (Collection)sysStruStaffList);
            }
        }
        catch (Exception e) {
            throw new BaseException("\u540c\u6b65\u4fee\u6539\u7ec4\u7ec7\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
        }
    }

    @HussarDs(value="#connName")
    @HussarTransactional
    public void deleteStru(String connName, List<Long> struIds, List<Long> organIds) {
        try {
            this.sysStruService.removeByIds(connName, struIds);
            this.sysOrganService.removeByIds(connName, organIds);
            this.sysOfficeBaseService.remove(connName, (Wrapper)new LambdaQueryWrapper().in(SysOffice::getStruId, struIds));
            this.sysStruUserBaseService.remove(connName, (Wrapper)new LambdaQueryWrapper().in(SysStruUser::getStruId, struIds));
            List delUser = this.sysStruMapper.getDelUser();
            if (HussarUtils.isNotEmpty((Object)delUser)) {
                List userIds = delUser.parallelStream().map(SysUsers::getId).collect(Collectors.toList());
                List staffIds = delUser.parallelStream().map(SysUsers::getEmployeeId).collect(Collectors.toList());
                this.sysUsersService.removeByIds(connName, userIds);
                this.sysUserRoleService.remove(connName, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getGrantedRole, (Object)1450785135866925064L)).in(SysUserRole::getUserId, userIds));
                this.sysStaffBaseService.removeByIds(connName, staffIds);
                this.sysStruStaffBaseService.remove(connName, (Wrapper)new LambdaQueryWrapper().in(SysStruStaff::getStaffId, staffIds));
            }
        }
        catch (Exception e) {
            throw new BaseException("\u540c\u6b65\u5220\u9664\u7ec4\u7ec7\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
        }
    }

    @HussarDs(value="#connName")
    @HussarTransactional
    public void updateStaff(String connName, List<SysStaff> sysStaffs, List<SysStruStaff> sysStruStaffs) {
        try {
            for (SysStaff sysStaff : sysStaffs) {
                Long staffId = sysStaff.getId();
                if (this.sysStaffBaseService.count(connName, (Wrapper)new LambdaQueryWrapper().eq(SysStaff::getId, (Object)staffId)) <= 0L) continue;
                this.sysStaffBaseService.updateById(connName, (Object)sysStaff);
                this.sysStruStaffBaseService.remove(connName, (Wrapper)new LambdaQueryWrapper().eq(SysStruStaff::getStaffId, (Object)staffId));
                SysStruStaff sysStruStaff = sysStruStaffs.parallelStream().filter(item -> HussarUtils.equals((Object)staffId, (Object)item.getStaffId())).findFirst().orElse(new SysStruStaff());
                this.sysStruStaffBaseService.save(connName, (Object)sysStruStaff);
            }
        }
        catch (Exception e) {
            throw new BaseException("\u540c\u6b65\u4fee\u6539\u4eba\u5458\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
        }
    }
}

