/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.runner;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.properties.HussarCacheProperties;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.job.dispatch.api.entity.JobInfoEntity;
import com.jxdinfo.hussar.support.job.dispatch.api.service.JobServiceService;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.model.SysTenantRecord;
import com.jxdinfo.hussar.tenant.common.model.SysTenantSecure;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantRecordService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantSecureService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

@Component(value="com.jxdinfo.hussar.tenant.runner.environmentCheckRunner")
@Order(value=900000)
public class EnvironmentCheckRunner
implements ApplicationRunner {
    @Resource
    private HussarCacheProperties hussarCacheProperties;
    @Resource
    private HussarTenantProperties hussarTenantProperties;
    @Autowired
    private ISysTenantRecordService sysTenantRecordService;
    @Autowired
    private ISysTenantService sysTenantService;
    @Autowired
    private ISysTenantSecureService tenantSecureService;
    @Autowired
    private JobServiceService jobServiceService;
    private static Logger LOGGER = LogManager.getLogger(EnvironmentCheckRunner.class);

    public void run(ApplicationArguments args) throws Exception {
        boolean tenantOpen = this.hussarTenantProperties.isEnabled();
        boolean redisOpen = "redis".equals(this.hussarCacheProperties.getCacheType());
        if (tenantOpen && !redisOpen) {
            throw new BaseException("\u591a\u79df\u6237\u6a21\u5f0f\u5fc5\u987b\u5f00\u542fredis\u7f13\u5b58\u914d\u7f6e");
        }
        TenantCacheUtil.clearTenantCache();
        List list = this.sysTenantRecordService.list();
        ArrayList statusList = Lists.newArrayList((Object[])new String[]{"0"});
        if (HussarUtils.isNotEmpty((Object)list)) {
            ArrayList codes = Lists.newArrayList();
            for (SysTenantRecord record : list) {
                String key;
                String className = record.getTenantClass();
                String param = record.getTenantParams();
                Long tenantId = record.getTenantId();
                SysTenant byId = null;
                try {
                    byId = (SysTenant)this.sysTenantService.getById((Serializable)tenantId);
                }
                catch (Exception e) {
                    LOGGER.error("\u672a\u67e5\u8be2\u5230\u79df\u6237ID\u4e3a" + tenantId + "\u7684\u79df\u6237\u57fa\u7840\u4fe1\u606f");
                }
                if (null == byId) continue;
                String domain = byId.getTenantDomain();
                String tenantCode = byId.getTenantCode();
                String string = key = StringUtils.isNotBlank((CharSequence)domain) ? domain : tenantCode;
                if (!HussarUtils.isNotEmpty((Object)byId) || statusList.contains(byId.getTenantStatus())) continue;
                try {
                    HussarTenantDefinition definition = (HussarTenantDefinition)JSON.parseObject((String)param, (Class)ClassUtils.forName((String)className, (ClassLoader)SpringContextHolder.getApplicationContext().getClassLoader()));
                    definition.setTenantStatus(byId.getTenantStatus());
                    SysTenantSecure one = (SysTenantSecure)this.tenantSecureService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenantSecure::getTenantId, (Object)tenantId));
                    if (HussarUtils.isNotEmpty((Object)one)) {
                        definition.setClientId(one.getClientId());
                        definition.setClientSecret(one.getClientSecret());
                    }
                    definition.setTenantAdminId(byId.getTenantAdminId());
                    HussarFixedCacheUtil.put((String)"tenant_info", (Object)key, (Object)definition);
                    codes.add(definition.getTenantCode());
                }
                catch (ClassNotFoundException e) {
                    throw new BaseException("\u5f53\u524d\u6a21\u5f0f" + this.hussarTenantProperties.getType() + "\u542f\u52a8\u8fc7\u7a0b\u4e2d\u53d1\u751f\u7c7b\u578b" + className + "\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u7f13\u5b58\u548c\u6570\u636e\u5e93\u79df\u6237\u6570\u636e\u4e0e\u914d\u7f6e\u7684\u6a21\u5f0f\u662f\u5426\u5339\u914d\uff01");
                }
            }
            codes.add("0");
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            map.put("tenantCode_notIn", new String[]{String.join((CharSequence)",", codes)});
            List jobList = (List)this.jobServiceService.getJobListApi(map).getData();
            if (HussarUtils.isEmpty((Object)jobList)) {
                return;
            }
            for (JobInfoEntity temp : jobList) {
                if (codes.contains(temp.getTenantCode())) continue;
                this.jobServiceService.disableJobApi(temp.getId());
            }
        }
    }
}

