/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.runner;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.model.SysTenantRegister;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantRegisterService;
import com.jxdinfo.hussar.tenant.common.util.EnvironmentUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.hussar.tenant.runner.initTenantMicroServiceRunner")
@Order(value=900002)
public class InitTenantMicroServiceRunner
implements ApplicationRunner {
    @Autowired
    private Environment environment;
    @Autowired
    private ISysTenantRegisterService tenantRegisterService;

    public void run(ApplicationArguments args) throws Exception {
        boolean microService = EnvironmentUtil.isMicroService();
        if (!microService) {
            return;
        }
        String currentServiceName = this.environment.getProperty("spring.application.name");
        if (HussarUtils.isNotBlank((CharSequence)currentServiceName)) {
            SysTenantRegister sysTenantRegister = (SysTenantRegister)this.tenantRegisterService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenantRegister::getServiceName, (Object)currentServiceName), false);
            if (HussarUtils.isEmpty((Object)sysTenantRegister)) {
                sysTenantRegister = new SysTenantRegister();
            }
            sysTenantRegister.setRegStatus("1");
            sysTenantRegister.setServiceName(currentServiceName);
            sysTenantRegister.setRegName("\u9ed8\u8ba4\u6ce8\u518c\u5fae\u670d\u52a1");
            this.tenantRegisterService.saveOrUpdate((Object)sysTenantRegister);
        }
    }
}

