/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.menu.model.SysMenu;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.EntityUtils;
import com.jxdinfo.hussar.common.utils.ExceptionUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.datasource.factory.StorageFactory;
import com.jxdinfo.hussar.datasource.model.RDBStorageDefinition;
import com.jxdinfo.hussar.datasource.service.IHussarBaseSQLExecutor;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.model.GitDto;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.properties.GitlabProperties;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.util.GitlabUtil;
import com.jxdinfo.hussar.general.common.service.IHussarTenantConfigService;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.iam.client.dto.ClientDto;
import com.jxdinfo.hussar.iam.client.service.IHussarIamClientModelService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.job.dispatch.api.entity.JobInfoEntity;
import com.jxdinfo.hussar.support.job.dispatch.api.service.JobServiceService;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.constant.StepConstants;
import com.jxdinfo.hussar.tenant.common.dto.DesignateDeveloperDto;
import com.jxdinfo.hussar.tenant.common.model.HussarMethod;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.model.SysTenantDatasource;
import com.jxdinfo.hussar.tenant.common.model.SysTenantDeveloper;
import com.jxdinfo.hussar.tenant.common.model.SysTenantLog;
import com.jxdinfo.hussar.tenant.common.model.SysTenantRecord;
import com.jxdinfo.hussar.tenant.common.model.SysTenantRegister;
import com.jxdinfo.hussar.tenant.common.model.SysTenantSecure;
import com.jxdinfo.hussar.tenant.common.model.SysTenantUpgrade;
import com.jxdinfo.hussar.tenant.common.model.TenantPermissionData;
import com.jxdinfo.hussar.tenant.common.service.IAsyncUpdateTenantLogService;
import com.jxdinfo.hussar.tenant.common.service.IHussarBaseTenantService;
import com.jxdinfo.hussar.tenant.common.service.IHussarTenantCommonService;
import com.jxdinfo.hussar.tenant.common.service.IOutSideCreateStorageService;
import com.jxdinfo.hussar.tenant.common.service.IOutSideDeleteDataSourceService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantDataSourceService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantDeveloperService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantLogService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantRecordService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantRegisterService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantSecureService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantUpgradeService;
import com.jxdinfo.hussar.tenant.common.util.EnvironmentUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantLogUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantUtil;
import com.jxdinfo.hussar.validator.service.IHussarValidateService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.core.StringRedisTemplate;

public abstract class AbstractHussarBaseTenantService<T extends HussarTenantDefinition>
implements IHussarBaseTenantService<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractHussarBaseTenantService.class);
    @Value(value="${template-file.template-file-path:/home/tempfile/app-env}")
    private String TEMPLATE_FILE_PATH;
    @Value(value="${template-file.tenantPath:/home/tempfile/app-env/{tenantCode}}")
    private String TENANT_PATH;
    @Value(value="${template-file.template-mobile:/{tenantCode}-mobile}")
    private String TEMPLATE_MOBILE;
    @Value(value="${template-file.template-front:/{tenantCode}-front}")
    private String TEMPLATE_FRONT;
    @Value(value="${template-file.template-back:/{tenantCode}-web}")
    private String TEMPLATE_BACK;
    @Value(value="${template-file.back-start-module:/web-main}")
    private String BACK_START_MODULE;
    @Value(value="${template-file.Monolithic-Architecture:true}")
    private boolean IS_MONOLITHIC_ARCHITECTURE;
    @Autowired
    private IHussarTenantCommonService tenantCommonService;
    @Autowired
    private ISysUsersService sysUsersService;
    @Autowired
    private ISysTenantService tenantService;
    @Autowired
    private ISysUserRoleService sysUserRoleService;
    @Autowired
    private ISysRoleFunctionsService roleFunctionsService;
    @Autowired
    private ISysRolesService sysRolesService;
    @Autowired
    private ISysFunctionsService functionsService;
    @Autowired
    private IHussarIamClientModelService iamClientModelService;
    @Autowired
    private JobServiceService jobServiceService;
    @Autowired
    private ISysTenantSecureService tenantSecureService;
    @Autowired
    private ISysTenantLogService sysTenantLogService;
    @Autowired
    private DynamicDatasourceService dynamicDatasourceService;
    @Autowired
    private ISysResourcesService resourcesService;
    @Autowired
    protected ISysIdtableService sysIdtableService;
    @Autowired
    private IHussarValidateService validateService;
    @Autowired
    private ISysTenantDataSourceService sysTenantDataSourceService;
    @Autowired
    private ISysRoleResourceService roleResourceService;
    @Autowired
    private ISysTenantRecordService tenantRecordService;
    @Autowired
    private IHussarBaseSQLExecutor hussarBaseSQLExecutor;
    @Autowired
    private ISysTenantUpgradeService sysTenantUpgradeService;
    @Autowired
    private IAsyncUpdateTenantLogService asyncUpdateTenantLogService;
    @Autowired
    private ISysTenantRegisterService sysTenantRegisterService;
    @Autowired
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Autowired
    private ISysTenantService sysTenantService;
    @Autowired
    private GitlabProperties gitlabProperties;
    @Autowired
    private ISysTenantDeveloperService tenantDeveloperService;
    @Autowired
    private ISysStruUserService sysStruUserService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    public HussarTenantDefinition getTenantByTenantCode(String tenantCode) {
        return this.tenantService.getTenantByTenantCode(tenantCode);
    }

    public HussarTenantDefinition getTenantByTenantId(Long tenantId) {
        return this.tenantService.getTenantByTenantId(tenantId);
    }

    public HussarTenantDefinition getTenantByDomain(String domain) {
        return this.tenantService.getTenantByDomain(domain);
    }

    public void addTenant(T t) {
        Long tenantId = IdWorker.getId(t);
        t.setTenantId(tenantId);
        t.setTenantStatus("3");
        String tenantCode = t.getTenantCode();
        HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + tenantCode), (Object)"1:\u68c0\u67e5\u9879\u76ee\u914d\u7f6e\u4fe1\u606f");
        this.checkData(t);
        TenantCacheUtil.putTenat2Cache(t);
        TenantCacheUtil.putTenantDataSourceCacheBatch(t);
        SysTenant sysTenant = TenantUtil.convert2SysTenant(t);
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        sysTenant.setUserId(securityUser.getUserId());
        sysTenant.setDeptId(securityUser.getDeptId());
        this.tenantService.save((Object)sysTenant);
        LOGGER.info("\u521b\u5efa\u9879\u76eeSTART{}", (Object)t.getTenantCode());
        Executor hussarBaseTenantExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        hussarBaseTenantExecutor.execute(() -> this.asyncAdd(t));
    }

    public String getAddTenantLogFromCache(String tenantCode) {
        boolean ifExist = HussarCacheUtil.containKey((String)"tenant_state", (Object)("add_tenant_log:" + tenantCode));
        if (ifExist) {
            return (String)HussarCacheUtil.get((String)"tenant_state", (Object)("add_tenant_log:" + tenantCode));
        }
        throw new BaseException("\u7f13\u5b58\u4e0d\u5b58\u5728\uff01");
    }

    public void updateDatabaseConnection(final SysTenantDatasource tenantDatasource, String bootstrapPath) throws IOException {
        Path directory = Paths.get(bootstrapPath, new String[0]);
        try {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    try {
                        String content = new String(Files.readAllBytes(file));
                        String updatedContent = content.replace("${JDBC_URL}", tenantDatasource.getJdbcUrl()).replace("${MYSQL_SERVICE_USER}", tenantDatasource.getUserName()).replace("${MYSQL_SERVICE_PASSWORD}", tenantDatasource.getPassword()).replace("${com.mysql.cj.jdbc.Driver}", tenantDatasource.getDriverClass());
                        if (!content.equals(updatedContent)) {
                            Files.write(file, updatedContent.getBytes(), new OpenOption[0]);
                            System.out.println("Updated file: " + file);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void copyDirectory(Path source, Path target) throws IOException {
        if (!Files.exists(source, new LinkOption[0])) {
            throw new IOException("Source directory does not exist: " + source);
        }
        if (Files.exists(target, new LinkOption[0])) {
            throw new IOException("Target directory already exists: " + target);
        }
        Files.createDirectories(target, new FileAttribute[0]);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(source);){
            for (Path filePath : stream) {
                Path sourceFilePath = source.resolve(filePath.getFileName());
                Path targetFilePath = target.resolve(filePath.getFileName());
                if (Files.isDirectory(sourceFilePath, new LinkOption[0])) {
                    this.copyDirectory(sourceFilePath, targetFilePath);
                    continue;
                }
                Files.copy(sourceFilePath, targetFilePath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        Files.walk(target, new FileVisitOption[0]).forEach(path -> {
            if (path.getFileName().toString().equals("${appCode}")) {
                try {
                    this.deleteDirectoryRecursively((Path)path);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void deleteDirectoryRecursively(Path directoryPath) throws IOException {
        if (!Files.exists(directoryPath, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directoryPath);){
            for (Path entry : stream) {
                if (Files.isDirectory(entry, new LinkOption[0])) {
                    this.deleteDirectoryRecursively(entry);
                    continue;
                }
                Files.delete(entry);
            }
        }
        Files.delete(directoryPath);
    }

    public void deleteTenant(Long tenantId) {
        AssertUtil.isNotNull((Object)tenantId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SysTenant tenant = (SysTenant)this.tenantService.getById((Serializable)tenantId);
        AssertUtil.isNotNull((Object)tenant, (String)"\u672a\u67e5\u8be2\u5230\u9879\u76ee\u4fe1\u606f\uff01");
        String tenantCode = tenant.getTenantCode();
        String connName = tenant.getConnName();
        tenant.setTenantStatus("0");
        this.tenantService.updateById((Object)tenant);
        HussarTenantDefinition hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantId((Long)tenantId);
        if (HussarUtils.isNotEmpty((Object)hussarTenantDefinition)) {
            hussarTenantDefinition.setTenantStatus("0");
            TenantCacheUtil.putTenat2Cache((HussarTenantDefinition)hussarTenantDefinition);
        }
        try {
            LOGGER.info("\u5220\u9664\u9879\u76ee\u5b9a\u65f6\u4efb\u52a1\u4fe1\u606f");
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            map.put("tenantCode_eq", new String[]{tenantCode});
            List joblist = (List)this.jobServiceService.getJobListApi(map).getData();
            if (HussarUtils.isNotEmpty((Object)joblist)) {
                for (JobInfoEntity job : joblist) {
                    this.jobServiceService.physicalDeleteJob(job.getId());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u9879\u76ee\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25\uff1a{}" + e.getMessage());
        }
        try {
            LOGGER.info("\u5220\u9664\u9879\u76ee\u5347\u7ea7\u65e5\u5fd7\u7b49\u4fe1\u606f");
            this.sysTenantLogService.remove((Wrapper)new LambdaQueryWrapper().eq(SysTenantLog::getTenantCode, (Object)tenantCode));
            this.tenantSecureService.remove((Wrapper)new LambdaQueryWrapper().eq(SysTenantSecure::getTenantCode, (Object)tenantCode));
            this.sysTenantUpgradeService.remove((Wrapper)new LambdaQueryWrapper().eq(SysTenantUpgrade::getTenantCode, (Object)tenantCode));
            this.tenantRecordService.remove((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantCode, (Object)tenantCode));
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u9879\u76ee\u5347\u7ea7\u65e5\u5fd7\u5931\u8d25\uff1a{}" + e.getMessage());
        }
        try {
            String currentServiceName;
            List serviceList;
            LOGGER.info("\u5220\u9664\u9879\u76ee\u6570\u636e\u6e90\u4fe1\u606f");
            LambdaQueryWrapper dswrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasource::getConnName, (Object)connName)).eq(SysTenantDatasource::getDatasourceType, (Object)"1");
            SysTenantDatasource dsTemp = (SysTenantDatasource)this.sysTenantDataSourceService.getOne((Wrapper)dswrapper);
            if (HussarUtils.isNotEmpty((Object)dsTemp)) {
                dsTemp.setDelFlag("1");
                this.sysTenantDataSourceService.updateById((Object)dsTemp);
            }
            this.dynamicDatasourceService.removeDynamicDatasource(connName);
            boolean microService = EnvironmentUtil.isMicroService();
            if (microService && HussarUtils.isNotEmpty((Object)(serviceList = this.sysTenantRegisterService.list((Wrapper)new LambdaQueryWrapper().ne(SysTenantRegister::getServiceName, (Object)(currentServiceName = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name"))))))) {
                for (SysTenantRegister temp : serviceList) {
                    ((IOutSideDeleteDataSourceService)SpringContextHolder.getBean(IOutSideDeleteDataSourceService.class)).doDeleteDataSource(connName, temp.getServiceName());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u9879\u76ee\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25\uff1a{}" + e.getMessage());
        }
    }

    private void dealFail(String tenantCode) {
        SysTenant sysTenant = (SysTenant)this.tenantService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenant::getTenantCode, (Object)tenantCode));
        if (HussarUtils.isNotEmpty((Object)sysTenant)) {
            sysTenant.setTenantStatus("4");
            this.tenantService.updateById((Object)sysTenant);
            HussarTenantDefinition definition = TenantCacheUtil.loadFromCacheByTenantCode((String)tenantCode);
            if (HussarUtils.isNotEmpty((Object)definition)) {
                definition.setTenantStatus("4");
                TenantCacheUtil.putTenat2Cache((HussarTenantDefinition)definition);
            }
        }
    }

    public void asyncAdd(T t) {
        GitDto gitDto = new GitDto();
        if (HussarUtils.isEmpty((Object)t.getGitUrl())) {
            String gitUri = this.gitlabProperties.getGitUri();
            t.setGitUrl(gitUri);
        }
        if (HussarUtils.isEmpty((Object)t.getGitToken())) {
            String gitToken = this.gitlabProperties.getAccessToken();
            t.setGitToken(gitToken);
        }
        String connName = t.getConnName();
        String currentServiceName = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name");
        try {
            this.createDb(t);
            LOGGER.info("\u521b\u5efa\u6570\u636e\u6e90{}\u5b8c\u6210", (Object)connName);
            this.stringRedisTemplate.convertAndSend("newDataSource", (Object)("haveNew:" + connName));
        }
        catch (Exception e) {
            this.dynamicDatasourceService.removeDynamicDatasource(connName);
            this.dealFail(t.getTenantCode());
            LOGGER.info("\u521b\u5efa\u6570\u636e\u5b58\u50a8{}\u5931\u8d25", (Object)connName);
            throw e;
        }
        SysTenantLog beforeAddTenantLog = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, Integer.valueOf(StepConstants.BEFORE_ADD_TENANT));
        if (HussarUtils.isEmpty((Object)beforeAddTenantLog)) {
            beforeAddTenantLog = TenantLogUtil.newBeforeAddTenantLog(t);
        }
        try {
            this.beforeAddTenant(t);
            LOGGER.info("\u524d\u7f6e\u64cd\u4f5c\u5b8c\u6210");
            beforeAddTenantLog.setExecStatus(Integer.valueOf(1));
            this.asyncUpdateTenantLogService.tenantlogUpdate(beforeAddTenantLog);
        }
        catch (Exception e) {
            beforeAddTenantLog.setExecStatus(Integer.valueOf(0));
            beforeAddTenantLog.setErrorTimes(Integer.valueOf(beforeAddTenantLog.getErrorTimes() + 1));
            beforeAddTenantLog.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
            this.asyncUpdateTenantLogService.tenantlogUpdate(beforeAddTenantLog);
            HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + t.getTenantCode()), (Object)("0:\u6dfb\u52a0\u9879\u76ee\u4e4b\u524d\u7684\u64cd\u4f5c\u5931\u8d25" + e.getMessage()));
            LOGGER.error("\u6dfb\u52a0\u9879\u76ee\u4e4b\u524d\u7684\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
        }
        SysTenantLog initTenantPermissionLog = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, Integer.valueOf(StepConstants.INIT_TENANT_PERMISSION));
        if (HussarUtils.isEmpty((Object)initTenantPermissionLog)) {
            HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + t.getTenantCode()), (Object)"3:\u914d\u7f6e\u9879\u76ee\u7528\u6237\u3001\u6743\u9650\u7b49\u4fe1\u606f");
            initTenantPermissionLog = TenantLogUtil.newInitTenantPermissionLog(t);
        }
        try {
            this.initTenantPermissionData(connName);
            initTenantPermissionLog.setExecStatus(Integer.valueOf(1));
            this.asyncUpdateTenantLogService.tenantlogUpdate(initTenantPermissionLog);
        }
        catch (Exception e) {
            initTenantPermissionLog.setExecStatus(Integer.valueOf(0));
            initTenantPermissionLog.setErrorTimes(Integer.valueOf(initTenantPermissionLog.getErrorTimes() + 1));
            initTenantPermissionLog.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
            this.asyncUpdateTenantLogService.tenantlogUpdate(initTenantPermissionLog);
            HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + t.getTenantCode()), (Object)("0:\u521d\u59cb\u5316\u9879\u76ee\u6743\u9650\u5931\u8d25" + e.getMessage()));
            LOGGER.error("\u521d\u59cb\u5316\u9879\u76ee\u6743\u9650\u5931\u8d25", (Throwable)e);
        }
        SysTenantLog initTenantAdminLog = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, Integer.valueOf(StepConstants.INIT_TENANT_ADMIN));
        if (HussarUtils.isEmpty((Object)initTenantAdminLog)) {
            initTenantAdminLog = TenantLogUtil.initTenantAdminLog(t);
        }
        try {
            this.initTenantAdmin(connName, t);
            LOGGER.info("\u8bbe\u7f6e\u9879\u76ee\u7ba1\u7406\u5458\u5b8c\u6210");
            initTenantAdminLog.setExecStatus(Integer.valueOf(1));
            this.asyncUpdateTenantLogService.tenantlogUpdate(initTenantAdminLog);
        }
        catch (Exception e) {
            initTenantAdminLog.setExecStatus(Integer.valueOf(0));
            initTenantAdminLog.setErrorTimes(Integer.valueOf(initTenantAdminLog.getErrorTimes() + 1));
            initTenantAdminLog.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
            this.asyncUpdateTenantLogService.tenantlogUpdate(initTenantAdminLog);
            HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + t.getTenantCode()), (Object)("0:\u521d\u59cb\u5316\u9879\u76ee\u7ba1\u7406\u5458\u5931\u8d25" + e.getMessage()));
            LOGGER.error("\u521d\u59cb\u5316\u9879\u76ee\u7ba1\u7406\u5458\u5931\u8d25", (Throwable)e);
        }
        SysTenantLog initTenantAdminRoleLog = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, Integer.valueOf(StepConstants.INIT_TENANT_ROLE));
        if (HussarUtils.isEmpty((Object)initTenantAdminRoleLog)) {
            initTenantAdminRoleLog = TenantLogUtil.newInitTenantAdminRoleLog(t);
        }
        try {
            this.initTenantAdminRole(connName, t.getTenantAdminId());
            LOGGER.info("\u8bbe\u7f6e\u9879\u76ee\u7ba1\u7406\u5458\u89d2\u8272\u5b8c\u6210");
            initTenantAdminRoleLog.setExecStatus(Integer.valueOf(1));
            this.asyncUpdateTenantLogService.tenantlogUpdate(initTenantAdminRoleLog);
        }
        catch (Exception e) {
            initTenantAdminRoleLog.setExecStatus(Integer.valueOf(0));
            initTenantAdminRoleLog.setErrorTimes(Integer.valueOf(initTenantAdminRoleLog.getErrorTimes() + 1));
            initTenantAdminRoleLog.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
            this.asyncUpdateTenantLogService.tenantlogUpdate(initTenantAdminRoleLog);
            HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + t.getTenantCode()), (Object)("0:\u521d\u59cb\u5316\u9879\u76ee\u7ba1\u7406\u5458\u89d2\u8272\u5931\u8d25" + e.getMessage()));
            LOGGER.error("\u521d\u59cb\u5316\u9879\u76ee\u7ba1\u7406\u5458\u89d2\u8272\u5931\u8d25", (Throwable)e);
        }
        SysTenantLog initClientInfoLog = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, Integer.valueOf(StepConstants.INIT_CLIENT_INFO));
        if (HussarUtils.isEmpty((Object)initClientInfoLog)) {
            initClientInfoLog = TenantLogUtil.newInitClientInfoLog(t);
        }
        try {
            this.initClientInfo(connName, (HussarTenantDefinition)t);
            LOGGER.info("\u521d\u59cb\u5316\u9879\u76ee\u5ba2\u6237\u7aef\u8ba4\u8bc1\u4fe1\u606f\u5b8c\u6210");
            initClientInfoLog.setExecStatus(Integer.valueOf(1));
            this.asyncUpdateTenantLogService.tenantlogUpdate(initClientInfoLog);
        }
        catch (Exception e) {
            initClientInfoLog.setExecStatus(Integer.valueOf(0));
            initClientInfoLog.setErrorTimes(Integer.valueOf(initClientInfoLog.getErrorTimes() + 1));
            initClientInfoLog.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
            this.asyncUpdateTenantLogService.tenantlogUpdate(initClientInfoLog);
            HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + t.getTenantCode()), (Object)("0:\u521d\u59cb\u5316\u9879\u76ee\u5ba2\u6237\u7aef\u8ba4\u8bc1\u4fe1\u606f\u5931\u8d25" + e.getMessage()));
            LOGGER.error("\u521d\u59cb\u5316\u9879\u76ee\u5ba2\u6237\u7aef\u8ba4\u8bc1\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        this.initJobInfo(connName, t.getTenantId(), t.getTenantCode());
        LOGGER.info("\u521d\u59cb\u5316\u9879\u76ee\u5b9a\u65f6\u4efb\u52a1\u4fe1\u606f\u5b8c\u6210");
        SysTenantLog saveTenantLog = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, Integer.valueOf(StepConstants.SAVE_TENANT));
        if (HussarUtils.isEmpty((Object)saveTenantLog)) {
            saveTenantLog = TenantLogUtil.newSaveTenantLog(t);
        }
        try {
            this.saveTenant(t);
            LOGGER.info("\u4fdd\u5b58\u9879\u76ee\u57fa\u7840\u4fe1\u606f\u5b8c\u6210");
            saveTenantLog.setExecStatus(Integer.valueOf(1));
            this.asyncUpdateTenantLogService.tenantlogUpdate(saveTenantLog);
        }
        catch (Exception e) {
            saveTenantLog.setExecStatus(Integer.valueOf(0));
            saveTenantLog.setErrorTimes(Integer.valueOf(saveTenantLog.getErrorTimes() + 1));
            saveTenantLog.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
            this.asyncUpdateTenantLogService.tenantlogUpdate(saveTenantLog);
            HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + t.getTenantCode()), (Object)("0:\u4fdd\u5b58\u9879\u76ee\u57fa\u7840\u4fe1\u606f\u5931\u8d25" + e.getMessage()));
            LOGGER.error("\u4fdd\u5b58\u9879\u76ee\u57fa\u7840\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        SysTenantLog afterAddTenantLog = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, Integer.valueOf(StepConstants.AFTER_ADD_TENANT));
        if (HussarUtils.isEmpty((Object)afterAddTenantLog)) {
            afterAddTenantLog = TenantLogUtil.newAfterAddTenantLog(t);
        }
        try {
            this.afterAddTenant(t);
            LOGGER.info("\u540e\u7f6e\u64cd\u4f5c\u5b8c\u6210");
            HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + t.getTenantCode()), (Object)"4:\u9879\u76ee\u521b\u5efa\u5b8c\u6210\uff01");
            afterAddTenantLog.setExecStatus(Integer.valueOf(1));
            this.asyncUpdateTenantLogService.tenantlogUpdate(afterAddTenantLog);
        }
        catch (Exception e) {
            afterAddTenantLog.setExecStatus(Integer.valueOf(0));
            afterAddTenantLog.setErrorTimes(Integer.valueOf(saveTenantLog.getErrorTimes() + 1));
            afterAddTenantLog.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
            this.asyncUpdateTenantLogService.tenantlogUpdate(afterAddTenantLog);
            HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + t.getTenantCode()), (Object)"0:\u6dfb\u52a0\u9879\u76ee\u4e4b\u540e\u7684\u64cd\u4f5c\u5931\u8d25");
            LOGGER.error("\u6dfb\u52a0\u9879\u76ee\u4e4b\u540e\u7684\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
        }
        HussarTenantDefinition hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)t.getTenantCode());
        if (HussarUtils.isNotEmpty((Object)hussarTenantDefinition)) {
            List storagePropertiesList = hussarTenantDefinition.getStoragePropertiesList();
            for (Map temp : storagePropertiesList) {
                String serviceNameTemp = (String)temp.get("serviceName");
                serviceNameTemp = HussarUtils.isBlank((CharSequence)serviceNameTemp) ? "single" : serviceNameTemp;
                Map map = TenantCacheUtil.loadDatasourceFromCache((Long)t.getTenantId(), (String)serviceNameTemp);
                if (HussarUtils.isEmpty((Object)map)) continue;
                temp.putAll(map);
            }
            TenantCacheUtil.putTenat2Cache((HussarTenantDefinition)hussarTenantDefinition);
            SysTenantRecord tenantRecord = (SysTenantRecord)this.tenantRecordService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantCode, (Object)hussarTenantDefinition.getTenantCode()));
            tenantRecord.setTenantParams(JSON.toJSONString((Object)hussarTenantDefinition));
            this.tenantRecordService.updateById((Object)tenantRecord);
        }
        if (!this.IS_MONOLITHIC_ARCHITECTURE) {
            String templateDirBack = this.TEMPLATE_FILE_PATH + this.TEMPLATE_BACK;
            String templateDirFront = this.TEMPLATE_FILE_PATH + this.TEMPLATE_FRONT;
            String templateMobile = this.TEMPLATE_FILE_PATH + this.TEMPLATE_MOBILE;
            Path templatePathBack = Paths.get(templateDirBack, new String[0]);
            Path templatePathFront = Paths.get(templateDirFront, new String[0]);
            Path templatePathMobile = Paths.get(templateMobile, new String[0]);
            String targetDirBack = this.TENANT_PATH + this.TEMPLATE_BACK;
            String targetDirFront = this.TENANT_PATH + this.TEMPLATE_FRONT;
            String targetDirMobile = this.TENANT_PATH + this.TEMPLATE_MOBILE;
            targetDirBack = targetDirBack.replace("{tenantCode}", t.getTenantCode());
            targetDirFront = targetDirFront.replace("{tenantCode}", t.getTenantCode());
            targetDirMobile = targetDirMobile.replace("{tenantCode}", t.getTenantCode());
            Path targetPathBack = Paths.get(targetDirBack, new String[0]);
            Path targetPathFront = Paths.get(targetDirFront, new String[0]);
            Path targetPathMobile = Paths.get(targetDirMobile, new String[0]);
            try {
                Files.createDirectories(targetPathBack.getParent(), new FileAttribute[0]);
                this.copyDirectory(templatePathBack, targetPathBack);
                this.copyDirectory(templatePathFront, targetPathFront);
                this.copyDirectory(templatePathMobile, targetPathMobile);
                String targetDirBackPom1 = targetDirBack + File.separator + "pom.xml";
                String targetDirBackPom2 = targetDirBack + this.BACK_START_MODULE + File.separator + "pom.xml";
                this.replaceTenantCodeInFiles(targetDirBackPom1, "${tenantCode}", t.getTenantCode());
                this.replaceTenantCodeInFiles(targetDirBackPom2, "${tenantCode}", t.getTenantCode());
                String targetDirMobilePackage = targetDirMobile + File.separator + "package.json";
                this.replaceTenantCodeInFiles(targetDirMobilePackage, "{tenantCode}", t.getTenantCode());
                LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
                lambdaQueryWrapper.eq(SysTenantDatasource::getConnName, (Object)connName);
                SysTenantDatasource tenantDatasource = (SysTenantDatasource)this.sysTenantDataSourceService.getOne((Wrapper)lambdaQueryWrapper);
                String bootstrapPath = targetDirBack + this.BACK_START_MODULE + File.separator + "src" + File.separator + "main" + File.separator + "resources" + File.separator + "bootstrap.yml";
                this.updateDatabaseConnection(tenantDatasource, bootstrapPath);
                gitDto.setCommitMsg("\u65b0\u5efa\u9879\u76ee\uff0c\u521b\u5efa\u76ee\u5f55");
                gitDto.setPath(this.TENANT_PATH.replace("{tenantCode}", t.getTenantCode()));
                gitDto.setTenantCode(t.getTenantCode());
                gitDto.setGitUri(t.getGitUrl());
                gitDto.setAccessToken(t.getGitToken());
                GitlabUtil.createProject((GitDto)gitDto);
            }
            catch (IOException e) {
                LOGGER.info("\u9879\u76ee\u63a8\u9001Git\u51fa\u9519:{}", (Object)e.getMessage());
            }
        }
        this.tenantService.updateTenantStatus(t.getTenantCode());
    }

    public void initTenantPermissionData(String connName) {
        ArrayList<Long> tenantResGrade = new ArrayList<Long>();
        tenantResGrade.add(522705027572441088L);
        tenantResGrade.add(523554762252361728L);
        tenantResGrade.add(523555173533229056L);
        tenantResGrade.add(815300265334022144L);
        tenantResGrade.add(815299064513175552L);
        tenantResGrade.add(815298988961177600L);
        tenantResGrade.add(815298745012068352L);
        tenantResGrade.add(686146166286721024L);
        tenantResGrade.add(686146454410240000L);
        tenantResGrade.add(729285380519763968L);
        LambdaQueryWrapper resLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().notIn(SysResources::getId, tenantResGrade);
        List resourcesList = this.resourcesService.list(connName, (Wrapper)resLambdaQueryWrapper);
        if (HussarUtils.isNotEmpty((Object)resourcesList)) {
            this.buildRelationOfResource(connName, resourcesList);
        }
        ArrayList<Long> tenantFuncGrade = new ArrayList<Long>();
        tenantFuncGrade.add(522705551881412608L);
        tenantFuncGrade.add(523555260388876288L);
        tenantFuncGrade.add(523555376986333184L);
        tenantFuncGrade.add(815299398463660032L);
        tenantFuncGrade.add(815299697123270656L);
        tenantFuncGrade.add(815299769068167168L);
        tenantFuncGrade.add(815300362058866688L);
        tenantFuncGrade.add(686147054220877824L);
        tenantFuncGrade.add(686147191273955328L);
        tenantFuncGrade.add(729285499054989312L);
        LambdaQueryWrapper funcLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().notIn(SysFunctions::getId, tenantFuncGrade);
        List functionsList = this.functionsService.list(connName, (Wrapper)funcLambdaQueryWrapper);
        if (HussarUtils.isNotEmpty((Object)functionsList)) {
            this.buildRelationOfFunction(connName, functionsList);
        }
        LOGGER.info("\u521d\u59cb\u5316\u79df\u6237\u6743\u9650\u5b8c\u6210");
    }

    private void buildRelationOfResource(String connName, Collection<SysResources> resourcesList) {
        ArrayList<SysRoleResource> roleResourceList = new ArrayList<SysRoleResource>();
        if (HussarUtils.isNotEmpty(resourcesList)) {
            for (SysResources resources : resourcesList) {
                SysRoleResource roleResource = new SysRoleResource();
                roleResource.setResourceId(resources.getId());
                roleResource.setRoleId(TenantConstant.ADMIN_ROLE);
                roleResource.setRelationSource("2");
                roleResourceList.add(roleResource);
            }
            this.roleResourceService.saveBatch(connName, roleResourceList);
        }
    }

    private void buildRelationOfFunction(String connName, Collection<SysFunctions> functionsList) {
        ArrayList<SysRoleFunctions> roleFunctionsList = new ArrayList<SysRoleFunctions>();
        if (HussarUtils.isNotEmpty(functionsList)) {
            for (SysFunctions function : functionsList) {
                SysRoleFunctions roleFunctions = new SysRoleFunctions();
                roleFunctions.setFunctionId(function.getId());
                roleFunctions.setRoleId(TenantConstant.ADMIN_ROLE);
                roleFunctionsList.add(roleFunctions);
            }
            this.roleFunctionsService.saveBatch(connName, roleFunctionsList);
        }
    }

    public void checkData(T t) {
        String connName;
        T definition = t;
        String tenantCode = definition.getTenantCode();
        long tenantId = definition.getTenantId();
        String validateMsg = this.validateService.validate(definition);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        Optional<SysTenant> anyTenantCode = this.tenantService.list().stream().filter(item -> item.getTenantCode().equalsIgnoreCase(tenantCode)).findAny();
        if (anyTenantCode.isPresent()) {
            HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + tenantCode), (Object)"0:\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u9879\u76ee\u7f16\u7801\u5df2\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01\uff09");
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u9879\u76ee\u7f16\u7801\u5df2\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01\uff09");
        }
        String domain = definition.getTenantDomain();
        if (StringUtils.isNotBlank((CharSequence)domain)) {
            AssertUtil.isTrue((boolean)domain.matches("^((?!-)[A-Za-z0-9-]{1,63}(?<!-)\\.)+[A-Za-z]{2,6}"), (String)"\u975e\u6cd5\u57df\u540d\uff01");
            Optional<SysTenant> anyDomain = this.tenantService.list().stream().filter(item -> item.getTenantDomain().equalsIgnoreCase(domain)).findAny();
            if (anyDomain.isPresent()) {
                HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + tenantCode), (Object)"0:\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u9879\u76ee\u7ed1\u5b9a\u57df\u540d\u5df2\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01\uff09\uff01");
                throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u9879\u76ee\u7ed1\u5b9a\u57df\u540d\u5df2\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01\uff09\uff01");
            }
        }
        if (!HussarUtils.isNotBlank((CharSequence)(connName = definition.getConnName())) && !connName.equalsIgnoreCase("master")) {
            HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + tenantCode), (Object)"0:\u975e\u6cd5\u6570\u636e\u6e90\u540d\u79f0\uff01");
            throw new BaseException("\u975e\u6cd5\u6570\u636e\u6e90\u540d\u79f0\uff01");
        }
        Set allDatasourcesName = this.dynamicDatasourceService.getAllDatasourcesName();
        boolean contains = false;
        if (HussarUtils.isNotEmpty((Object)allDatasourcesName)) {
            for (String dsName : allDatasourcesName) {
                if (!dsName.equalsIgnoreCase(connName)) continue;
                contains = true;
                break;
            }
        }
        if (contains) {
            HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + tenantCode), (Object)"0:\u6570\u636e\u6e90\u540d\u79f0\u91cd\u590d\uff01");
            throw new BaseException("\u6570\u636e\u6e90\u540d\u79f0\u91cd\u590d\uff01");
        }
        Optional<SysTenantDatasource> anyDs = this.sysTenantDataSourceService.list().stream().filter(item -> item.getConnName().equalsIgnoreCase(connName)).findAny();
        if (anyDs.isPresent()) {
            HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + tenantCode), (Object)"0:\u6570\u636e\u6e90\u540d\u79f0\u91cd\u590d\uff01");
            throw new BaseException("\u6570\u636e\u6e90\u540d\u79f0\u91cd\u590d\uff01");
        }
        List storagePropertiesList = definition.getStoragePropertiesList();
        if (!HussarUtils.isNotEmpty((Object)storagePropertiesList)) {
            HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + tenantCode), (Object)"0:\u9879\u76ee\u6570\u636e\u5b58\u50a8\u4fe1\u606f\u4e3a\u7a7a\uff01");
            throw new BaseException("\u9879\u76ee\u6570\u636e\u5b58\u50a8\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        for (Map mapDb : storagePropertiesList) {
            this.checkDb(mapDb);
        }
        this.tenantRecordService.remove((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantCode, (Object)tenantCode));
        SysTenantRecord record = new SysTenantRecord();
        record.setTenantId(Long.valueOf(tenantId));
        record.setConnName(definition.getConnName());
        record.setTenantCode(tenantCode);
        record.setConnName(connName);
        record.setTenantClass(t.getClass().getName());
        record.setTenantParams(JSON.toJSONString(t));
        this.tenantRecordService.save((Object)record);
    }

    private void checkDb(Map<String, Object> storageProperties) {
        String storageType = (String)storageProperties.get("storageType");
        if (!storageType.equals("rdb")) {
            return;
        }
        String json = JSON.toJSONString(storageProperties);
        RDBStorageDefinition definition = (RDBStorageDefinition)JSON.parseObject((String)json, RDBStorageDefinition.class);
        String creation = definition.getCreation();
        if (creation.equals("2")) {
            String jdbcUrl = definition.getJdbcUrl();
            String userName = definition.getUserName();
            String password = definition.getPassword();
            AssertUtil.isTrue((boolean)this.hussarBaseSQLExecutor.checkDbConnection(jdbcUrl, userName, password), (String)"\u9879\u76ee\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff01");
        }
    }

    private void createDb(T t) {
        T definition = t;
        List storagePropertiesList = definition.getStoragePropertiesList();
        boolean isMicroservice = EnvironmentUtil.isMicroService();
        String currentServiceName = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name");
        if (HussarUtils.isNotEmpty((Object)storagePropertiesList)) {
            if (isMicroservice) {
                LOGGER.info("\u5f00\u59cb\u521b\u5efa\u5fae\u670d\u52a1\u6570\u636e\u5b58\u50a8");
                HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + t.getTenantCode()), (Object)"2:\u521d\u59cb\u5316\u9879\u76ee\u6570\u636e\u5e93\uff08\u6570\u636e\u5e93\u521d\u59cb\u5316\u65f6\u95f4\u8f83\u957f\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u51e0\u5206\u949f\uff09");
                ArrayList<Map> storagePropertiesListOther = new ArrayList<Map>();
                Map<String, Object> masterstorageProperties = new HashMap<String, Object>();
                for (Map storageProperties : storagePropertiesList) {
                    String serviceName;
                    String string = serviceName = HussarUtils.isEmpty(storageProperties.get("serviceName")) ? "hussar-web" : (String)storageProperties.get("serviceName");
                    if (HussarUtils.isBlank((CharSequence)serviceName)) {
                        HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + t.getTenantCode()), (Object)"0:\u5fae\u670d\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        throw new BaseException("\u5fae\u670d\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    storageProperties.put("tenantCode", definition.getTenantCode());
                    storageProperties.put("connName", definition.getConnName());
                    if (serviceName.equalsIgnoreCase(currentServiceName)) {
                        masterstorageProperties = storageProperties;
                        continue;
                    }
                    storageProperties.put("caller", currentServiceName);
                    storagePropertiesListOther.add(storageProperties);
                }
                SysTenantLog createDb = this.getSysTenantCreateDbLog(t, currentServiceName, masterstorageProperties);
                try {
                    String storageType = (String)masterstorageProperties.get("storageType");
                    if (HussarUtils.isBlank((CharSequence)storageType)) {
                        storageType = "rdb";
                    }
                    StorageFactory.get((String)storageType).createDatabaseAndInitData(masterstorageProperties);
                    SysTenantRecord recordTemp = (SysTenantRecord)this.tenantRecordService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantCode, (Object)definition.getTenantCode()), false);
                    if (HussarUtils.isNotEmpty((Object)recordTemp)) {
                        recordTemp.setTenantParams(JSON.toJSONString(t));
                        this.tenantRecordService.updateById((Object)recordTemp);
                    }
                    createDb.setExecStatus(Integer.valueOf(1));
                    TenantCacheUtil.putTenantDataSourceCache((Long)t.getTenantId(), masterstorageProperties);
                    this.asyncUpdateTenantLogService.tenantlogUpdate(createDb);
                }
                catch (Exception e) {
                    createDb.setExecStatus(Integer.valueOf(0));
                    createDb.setErrorTimes(Integer.valueOf(createDb.getErrorTimes() + 1));
                    createDb.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
                    this.asyncUpdateTenantLogService.tenantlogUpdate(createDb);
                    HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + t.getTenantCode()), (Object)"0:\u521b\u5efa\u5fae\u670d\u52a1\u6570\u636e\u5b58\u50a8\u51fa\u9519\uff01");
                    throw new BaseException("\u521b\u5efa\u5fae\u670d\u52a1\u6570\u636e\u5b58\u50a8\u51fa\u9519\uff01", (Throwable)e);
                }
                if (HussarUtils.isEmpty(storagePropertiesListOther)) {
                    return;
                }
                IOutSideCreateStorageService outSideCreateStorageService = (IOutSideCreateStorageService)SpringContextHolder.getBean(IOutSideCreateStorageService.class);
                if (outSideCreateStorageService == null) {
                    HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + t.getTenantCode()), (Object)"0:\u83b7\u53d6IOutSideCreateStorageService\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5f15\u5165hussar-tenant-outside\u5305\uff01");
                    throw new BaseException("\u83b7\u53d6IOutSideCreateStorageService\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5f15\u5165hussar-tenant-outside\u5305\uff01");
                }
                int startNo = StepConstants.MICROSERVICE_CREATE_DB_MIN;
                ArrayList<SysTenantLog> serviceLogs = new ArrayList<SysTenantLog>();
                for (Map outSideStorageProperties : storagePropertiesListOther) {
                    String serviceNameTemp = (String)outSideStorageProperties.get("serviceName");
                    SysTenantLog createDbTemp = this.getSysTenantCreateDbLog(t, serviceNameTemp, outSideStorageProperties);
                    createDbTemp.setStepNo(Integer.valueOf(startNo++));
                    serviceLogs.add(createDbTemp);
                }
                this.sysTenantLogService.saveBatch(serviceLogs);
                for (Map outSideStorageProperties : storagePropertiesListOther) {
                    Boolean flag;
                    try {
                        IHussarTenantConfigService hussarTenantConfigService = (IHussarTenantConfigService)SpringContextHolder.getBean(IHussarTenantConfigService.class);
                        flag = hussarTenantConfigService.checkTenant((String)outSideStorageProperties.get("serviceName"));
                    }
                    catch (Exception e) {
                        String serviceName = (String)outSideStorageProperties.get("serviceName");
                        HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + t.getTenantCode()), (Object)"0:\u6821\u9a8c\u5fae\u670d\u52a1{}\u662f\u5426\u5f00\u542f\u591a\u9879\u76ee\u5931\u8d25");
                        LOGGER.error("\u6821\u9a8c\u5fae\u670d\u52a1{}\u662f\u5426\u5f00\u542f\u591a\u9879\u76ee\u5931\u8d25", (Object)serviceName);
                        String tenantCode = definition.getTenantCode();
                        SysTenantLog updateLog = (SysTenantLog)this.sysTenantLogService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantLog::getTenantCode, (Object)tenantCode)).eq(SysTenantLog::getServiceName, (Object)serviceName));
                        if (updateLog == null) {
                            HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + t.getTenantCode()), (Object)("0:\u672a\u67e5\u8be2\u5230\u9879\u76ee\u7f16\u7801\u4e3a" + tenantCode + ",\u5fae\u670d\u52a1\u540d\u79f0\u4e3a" + serviceName + "\u7684\u65e5\u5fd7\u4fe1\u606f\uff01"));
                            throw new BaseException("\u672a\u67e5\u8be2\u5230\u9879\u76ee\u7f16\u7801\u4e3a" + tenantCode + ",\u5fae\u670d\u52a1\u540d\u79f0\u4e3a" + serviceName + "\u7684\u65e5\u5fd7\u4fe1\u606f\uff01");
                        }
                        updateLog.setExecStatus(Integer.valueOf(0));
                        updateLog.setExecError("\u6821\u9a8c\u662f\u5426\u5f00\u542f\u591a\u9879\u76ee\u5931\u8d25");
                        HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + t.getTenantCode()), (Object)"0:\u6821\u9a8c\u662f\u5426\u5f00\u542f\u591a\u9879\u76ee\u5931\u8d25");
                        updateLog.setErrorTimes(Integer.valueOf(updateLog.getErrorTimes() + 1));
                        LOGGER.info("\u9879\u76ee\u7f16\u7801={}\u5fae\u670d\u52a1\u540d\u79f0={}\u6267\u884c\u56de\u8c03\u66f4\u65b0\u65e5\u5fd7\u5b8c\u6bd5", (Object)tenantCode, (Object)serviceName);
                        this.asyncUpdateTenantLogService.tenantlogUpdate(updateLog);
                        continue;
                    }
                    if (flag.booleanValue()) {
                        outSideCreateStorageService.dealCreateStorage(outSideStorageProperties, (String)outSideStorageProperties.get("serviceName"));
                        continue;
                    }
                    String serviceName = (String)outSideStorageProperties.get("serviceName");
                    LOGGER.error("\u5fae\u670d\u52a1{}\u672a\u5f00\u542f\u591a\u9879\u76ee\u6216\u672a\u5f15\u5165\u591a\u9879\u76ee\u4f9d\u8d56", (Object)serviceName);
                    HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + t.getTenantCode()), (Object)("0:\u5fae\u670d\u52a1" + serviceName + "\u672a\u5f00\u542f\u591a\u9879\u76ee\u6216\u672a\u5f15\u5165\u591a\u9879\u76ee\u4f9d\u8d56"));
                    String tenantCode = definition.getTenantCode();
                    SysTenantLog updateLog = (SysTenantLog)this.sysTenantLogService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantLog::getTenantCode, (Object)tenantCode)).eq(SysTenantLog::getServiceName, (Object)serviceName));
                    if (updateLog == null) {
                        HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + t.getTenantCode()), (Object)("0:\u672a\u67e5\u8be2\u5230\u9879\u76ee\u7f16\u7801\u4e3a" + tenantCode + ",\u5fae\u670d\u52a1\u540d\u79f0\u4e3a" + serviceName + "\u7684\u65e5\u5fd7\u4fe1\u606f\uff01"));
                        throw new BaseException("\u672a\u67e5\u8be2\u5230\u9879\u76ee\u7f16\u7801\u4e3a" + tenantCode + ",\u5fae\u670d\u52a1\u540d\u79f0\u4e3a" + serviceName + "\u7684\u65e5\u5fd7\u4fe1\u606f\uff01");
                    }
                    updateLog.setExecStatus(Integer.valueOf(0));
                    updateLog.setExecError("\u672a\u5f00\u542f\u591a\u9879\u76ee\u6216\u672a\u5f15\u5165\u591a\u9879\u76ee\u4f9d\u8d56");
                    updateLog.setErrorTimes(Integer.valueOf(updateLog.getErrorTimes() + 1));
                    HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + t.getTenantCode()), (Object)"0:\u672a\u5f00\u542f\u591a\u9879\u76ee\u6216\u672a\u5f15\u5165\u591a\u9879\u76ee\u4f9d\u8d56");
                    LOGGER.info("\u9879\u76ee\u7f16\u7801={}\u5fae\u670d\u52a1\u540d\u79f0={}\u6267\u884c\u56de\u8c03\u66f4\u65b0\u65e5\u5fd7\u5b8c\u6bd5", (Object)tenantCode, (Object)serviceName);
                    this.asyncUpdateTenantLogService.tenantlogUpdate(updateLog);
                }
            } else {
                LOGGER.info("\u5f00\u59cb\u521b\u5efa\u6570\u636e\u5b58\u50a8");
                HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + t.getTenantCode()), (Object)"2:\u521d\u59cb\u5316\u9879\u76ee\u6570\u636e\u5e93\uff08\u6570\u636e\u5e93\u521d\u59cb\u5316\u65f6\u95f4\u8f83\u957f\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u51e0\u5206\u949f\uff09");
                Map storageProperties = (Map)storagePropertiesList.get(0);
                String storageType = (String)storageProperties.get("storageType");
                storageProperties.put("tenantCode", definition.getTenantCode());
                storageProperties.put("connName", definition.getConnName());
                SysTenantLog createDb = this.getSysTenantCreateDbLog(t, currentServiceName, storageProperties);
                try {
                    StorageFactory.get((String)storageType).createDatabaseAndInitData(storageProperties);
                    SysTenantRecord recordTemp = (SysTenantRecord)this.tenantRecordService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantCode, (Object)definition.getTenantCode()), false);
                    if (HussarUtils.isNotEmpty((Object)recordTemp)) {
                        recordTemp.setTenantParams(JSON.toJSONString(t));
                        this.tenantRecordService.updateById((Object)recordTemp);
                    }
                    createDb.setExecStatus(Integer.valueOf(1));
                    TenantCacheUtil.putTenantDataSourceCache((Long)t.getTenantId(), (Map)storageProperties);
                    this.asyncUpdateTenantLogService.tenantlogUpdate(createDb);
                }
                catch (Exception e) {
                    createDb.setExecStatus(Integer.valueOf(0));
                    createDb.setErrorTimes(Integer.valueOf(createDb.getErrorTimes() + 1));
                    createDb.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
                    this.asyncUpdateTenantLogService.tenantlogUpdate(createDb);
                    HussarCacheUtil.put((String)"tenant_state", (Object)("add_tenant_log:" + t.getTenantCode()), (Object)("0:\u521b\u5efa\u6570\u636e\u5b58\u50a8\u51fa\u9519\uff01" + e.getMessage()));
                    throw new BaseException("\u521b\u5efa\u6570\u636e\u5b58\u50a8\u51fa\u9519\uff01", (Throwable)e);
                }
            }
        }
    }

    @NotNull
    private SysTenantLog getSysTenantCreateDbLog(T t, String currentServiceName, Map<String, Object> masterstorageProperties) {
        SysTenantLog createDb = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, Integer.valueOf(StepConstants.CREATE_DB));
        if (HussarUtils.isEmpty((Object)createDb)) {
            createDb = TenantLogUtil.newCreateDbLog(t.getClass(), (String)t.getTenantCode(), (String)t.getConnName(), (String)currentServiceName, masterstorageProperties);
        }
        return createDb;
    }

    public abstract void saveTenant(T var1);

    private void initTenantAdminRole(String connName, Long userId) {
        SysRoles adminRole = new SysRoles();
        adminRole.setId(TenantConstant.ADMIN_ROLE);
        adminRole.setRolePermission("ADMIN_ROLE");
        adminRole.setRoleName("\u7ba1\u7406\u5458\u89d2\u8272");
        adminRole.setRoleAlias("\u7ba1\u7406\u5458\u89d2\u8272");
        adminRole.setIsSys("1");
        adminRole.setGroupId(Long.valueOf(1450785135866925059L));
        adminRole.setRoleOrder(Integer.valueOf(10));
        this.sysRolesService.save(connName, (Object)adminRole);
        this.sysUserRoleService.saveUserRole(connName, userId);
    }

    public void initClientInfo(String connName, HussarTenantDefinition definition) {
        ClientDto clientDto = new ClientDto();
        long id = IdWorker.getId((Object)clientDto);
        clientDto.setId(Long.valueOf(id));
        clientDto.setClientId(String.valueOf(definition.getTenantId()));
        clientDto.setClientSecret(UUID.randomUUID().toString().replace("-", ""));
        clientDto.setAccessTokenValidTime(1800L);
        definition.setClientId(clientDto.getClientId());
        definition.setClientSecret(clientDto.getClientSecret());
        try {
            this.iamClientModelService.saveClientModels(connName, clientDto);
            SysTenantSecure sysTenantSecure = new SysTenantSecure();
            sysTenantSecure.setTenantId(definition.getTenantId());
            sysTenantSecure.setTenantCode(definition.getTenantCode());
            sysTenantSecure.setClientId(clientDto.getClientId());
            sysTenantSecure.setClientSecret(clientDto.getClientSecret());
            this.tenantSecureService.save((Object)sysTenantSecure);
            SysTenant tenant = TenantUtil.convert2SysTenant(definition);
            this.tenantService.updateById((Object)tenant);
            TenantCacheUtil.putTenat2Cache((HussarTenantDefinition)definition);
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u5ba2\u6237\u7aef\u4fe1\u606f\u51fa\u9519", (Throwable)e);
            throw new BaseException((Throwable)e);
        }
    }

    public void initJobInfo(String connName, Long tenantId, String tenantCode) {
        SysTenantLog initJobInfoLog = null;
        List<JobInfoEntity> tenantJobInfoList = this.getDefaultInitJob(connName, tenantId, tenantCode);
        if (HussarUtils.isNotEmpty(tenantJobInfoList)) {
            try {
                initJobInfoLog = this.newInitJobInfoLog(tenantCode, connName, tenantJobInfoList);
                this.deleteJobByTenantCode(tenantCode);
                ApiResponse booleanApiResponse = this.jobServiceService.saveJobList(tenantJobInfoList);
                if (booleanApiResponse.isSuccess()) {
                    initJobInfoLog.setExecStatus(Integer.valueOf(1));
                    this.asyncUpdateTenantLogService.tenantlogUpdate(initJobInfoLog);
                } else {
                    this.deleteJobByTenantCode(tenantCode);
                    initJobInfoLog.setExecStatus(Integer.valueOf(0));
                    initJobInfoLog.setErrorTimes(Integer.valueOf(1));
                    initJobInfoLog.setExecError("\u521d\u59cb\u5316\u9879\u76ee\u5b9a\u65f6\u4efb\u52a1\u51fa\u9519\uff01");
                    this.asyncUpdateTenantLogService.tenantlogUpdate(initJobInfoLog);
                }
            }
            catch (Exception e) {
                this.deleteJobByTenantCode(tenantCode);
                initJobInfoLog.setExecStatus(Integer.valueOf(0));
                initJobInfoLog.setErrorTimes(Integer.valueOf(1));
                initJobInfoLog.setExecError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
                this.asyncUpdateTenantLogService.tenantlogUpdate(initJobInfoLog);
                LOGGER.error("\u521d\u59cb\u5316\u9879\u76ee\u5b9a\u65f6\u4efb\u52a1\u51fa\u9519\uff01", (Throwable)e);
            }
        }
    }

    private void deleteJobByTenantCode(String tenantCode) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        map.put("tenantCode_eq", new String[]{tenantCode});
        List jobList = (List)this.jobServiceService.getJobListApi(map).getData();
        if (HussarUtils.isEmpty((Object)jobList)) {
            return;
        }
        for (JobInfoEntity temp : jobList) {
            this.jobServiceService.physicalDeleteJob(temp.getId());
        }
    }

    public SysTenantLog newInitJobInfoLog(String tenantCode, String connName, List<JobInfoEntity> tenantJobInfoList) {
        SysTenantLog initJobInfoLog = new SysTenantLog();
        initJobInfoLog.setStepNo(Integer.valueOf(StepConstants.INIT_JOB_INFO));
        initJobInfoLog.setMethodTag("initJobInfo");
        initJobInfoLog.setTenantCode(tenantCode);
        initJobInfoLog.setBeanName("JobServiceService");
        initJobInfoLog.setMethodName("saveBatch");
        initJobInfoLog.setMethodDesc("\u521d\u59cb\u5316\u9879\u76ee\u5b9a\u65f6\u4efb\u52a1");
        initJobInfoLog.setConnName(connName);
        Class[] paramClass = new Class[]{String.class, List.class};
        Object[] paramValues = new Object[]{tenantCode, tenantJobInfoList};
        initJobInfoLog.setMethodParams(JSON.toJSONString((Object)new HussarMethod(List.class, paramClass, paramValues)));
        initJobInfoLog.setExecStatus(Integer.valueOf(2));
        initJobInfoLog.setErrorTimes(Integer.valueOf(0));
        if (EnvironmentUtil.isMicroService()) {
            initJobInfoLog.setServiceName(((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name"));
        }
        return initJobInfoLog;
    }

    public TenantPermissionData subtract(TenantPermissionData a, TenantPermissionData b) {
        TenantPermissionData ret = new TenantPermissionData();
        Collection afunctionModules = a.getFunctionModules();
        Collection afunctions = a.getFunctions();
        Collection aresourceModules = a.getResourceModules();
        Collection aresources = a.getResources();
        Collection amenus = a.getMenus();
        Collection afunctionResources = a.getFunctionResources();
        Collection bfunctionModules = b.getFunctionModules();
        Set bfunctionModuleIds = EntityUtils.toSet((Collection)bfunctionModules, SysFunctionModules::getId);
        Collection bfunctions = b.getFunctions();
        Set bfunctionIds = EntityUtils.toSet((Collection)bfunctions, SysFunctions::getId);
        Collection bresourceModules = b.getResourceModules();
        Set bresourceModuleIds = EntityUtils.toSet((Collection)bresourceModules, SysResourceModules::getId);
        Collection bresources = b.getResources();
        Set bresourceIds = EntityUtils.toSet((Collection)bresources, SysResources::getId);
        Collection bmenus = b.getMenus();
        Set bmenuIds = EntityUtils.toSet((Collection)bmenus, SysMenu::getId);
        Collection bfunctionResources = b.getFunctionResources();
        Set functionModules = afunctionModules.stream().filter(e -> !bfunctionModuleIds.contains(e.getId())).collect(Collectors.toSet());
        Set functions = afunctions.stream().filter(e -> !bfunctionIds.contains(e.getId())).collect(Collectors.toSet());
        Set resourceModules = aresourceModules.stream().filter(e -> !bresourceModuleIds.contains(e.getId())).collect(Collectors.toSet());
        Set resources = aresources.stream().filter(e -> !bresourceIds.contains(e.getId())).collect(Collectors.toSet());
        Set menus = amenus.stream().filter(e -> !bmenuIds.contains(e.getId())).collect(Collectors.toSet());
        HashSet<SysFunctionResources> functionResources = new HashSet<SysFunctionResources>();
        for (SysFunctionResources asysFunctionResources : afunctionResources) {
            for (SysFunctionResources bsysFunctionResources : bfunctionResources) {
                if (asysFunctionResources.getResourceId().equals(bsysFunctionResources.getResourceId()) && asysFunctionResources.getFunctionId().equals(bsysFunctionResources.getFunctionId())) continue;
                functionResources.add(asysFunctionResources);
            }
        }
        ret.setFunctions(functions);
        ret.setFunctionModules(functionModules);
        ret.setResources(resources);
        ret.setResourceModules(resourceModules);
        ret.setMenus(menus);
        ret.setFunctionResources(functionResources);
        return ret;
    }

    public void editTenant(T t) {
        boolean microService;
        String currentServiceName = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name");
        SysTenant tenant = TenantUtil.convert2SysTenant(t);
        LocalDateTime now = LocalDateTime.now();
        if ("1".equals(tenant.getTimeLimit()) && "2".equals(tenant.getTenantStatus()) && tenant.getEndTime().isAfter(now)) {
            tenant.setTenantStatus("1");
            t.setTenantStatus("1");
            ArrayList<String> tenantCodes = new ArrayList<String>();
            tenantCodes.add(tenant.getTenantCode());
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            map.put("tenantCode_in", new String[]{String.join((CharSequence)",", tenantCodes)});
            List jobList = (List)this.jobServiceService.getJobListApi(map).getData();
            if (HussarUtils.isNotEmpty((Object)jobList)) {
                for (JobInfoEntity job : jobList) {
                    try {
                        ((JobServiceService)SpringContextHolder.getBean(JobServiceService.class)).enableJobApi(job.getId());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if ("0".equals(tenant.getTimeLimit()) && "2".equals(tenant.getTenantStatus())) {
            tenant.setTenantStatus("1");
            t.setTenantStatus("1");
        }
        TenantCacheUtil.putTenat2Cache(t);
        this.tenantService.updateById((Object)tenant);
        SysTenantRecord recordTemp = (SysTenantRecord)this.tenantRecordService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantId, (Object)tenant.getId()));
        if (HussarUtils.isNotEmpty((Object)recordTemp)) {
            recordTemp.setTenantParams(JSON.toJSONString(t));
            this.tenantRecordService.updateById((Object)recordTemp);
        }
        if (!(microService = EnvironmentUtil.isMicroService())) {
            return;
        }
        List storagePropertiesList = t.getStoragePropertiesList();
        List sysTenantLogs = this.sysTenantLogService.listByTenantCode(tenant.getTenantCode());
        Set<Object> serviceNames = new HashSet();
        if (HussarUtils.isNotEmpty((Object)sysTenantLogs)) {
            serviceNames = sysTenantLogs.stream().map(SysTenantLog::getServiceName).collect(Collectors.toSet());
        }
        List<Map> storagePropertiesListOther = new ArrayList();
        if (HussarUtils.isNotEmpty(serviceNames)) {
            for (Map storagePropertiesMap : storagePropertiesList) {
                storagePropertiesMap.put("tenantCode", t.getTenantCode());
                storagePropertiesMap.put("connName", t.getConnName());
                storagePropertiesMap.put("caller", currentServiceName);
                String serviceName = (String)storagePropertiesMap.get("serviceName");
                String serviceUsed = (String)storagePropertiesMap.get("inUse");
                if (!serviceNames.contains(serviceName) && HussarUtils.isNotBlank((CharSequence)serviceUsed) && "1".equals(serviceUsed)) {
                    storagePropertiesListOther.add(storagePropertiesMap);
                }
                if (!serviceNames.contains(serviceName) || !HussarUtils.isNotBlank((CharSequence)serviceUsed)) continue;
                storagePropertiesMap.put("inUse", "");
            }
        } else {
            storagePropertiesListOther = storagePropertiesList;
        }
        if (HussarUtils.isNotEmpty(storagePropertiesListOther)) {
            tenant.setTenantStatus("3");
            HussarTenantDefinition hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantId((Long)tenant.getId());
            if (HussarUtils.isNotEmpty((Object)hussarTenantDefinition)) {
                hussarTenantDefinition.setTenantStatus("3");
                TenantCacheUtil.putTenat2Cache((HussarTenantDefinition)hussarTenantDefinition);
            }
            this.tenantService.updateById((Object)tenant);
            Integer maxCreateDbStepNo = this.sysTenantLogService.getMaxCreateDbStepNo(tenant.getTenantCode());
            ArrayList<SysTenantLog> serviceLogs = new ArrayList<SysTenantLog>();
            for (Map outSideStorageProperties : storagePropertiesListOther) {
                outSideStorageProperties.put("caller", ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name"));
                String serviceNameTemp = (String)outSideStorageProperties.get("serviceName");
                SysTenantLog createDbTemp = this.getSysTenantCreateDbLog(t, serviceNameTemp, outSideStorageProperties);
                maxCreateDbStepNo = maxCreateDbStepNo + 1;
                createDbTemp.setStepNo(maxCreateDbStepNo);
                serviceLogs.add(createDbTemp);
            }
            this.sysTenantLogService.saveBatch(serviceLogs);
            IOutSideCreateStorageService outSideCreateStorageService = (IOutSideCreateStorageService)SpringContextHolder.getBean(IOutSideCreateStorageService.class);
            ArrayList storagePropertiesListOtherCopy = new ArrayList(storagePropertiesListOther);
            Executor hussarBaseTenantExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
            hussarBaseTenantExecutor.execute(() -> {
                for (Map outSideStorageProperties : storagePropertiesListOtherCopy) {
                    outSideCreateStorageService.dealCreateStorage(outSideStorageProperties, (String)outSideStorageProperties.get("serviceName"));
                }
            });
        }
    }

    private List<JobInfoEntity> getDefaultInitJob(String connName, Long tenantId, String tenantCode) {
        String readJson = null;
        try {
            Resource resource = SpringContextHolder.getApplicationContext().getResource("classpath:tenantsql/initjob/tenantJob.json");
            readJson = IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
            if (HussarUtils.isNotBlank((CharSequence)readJson)) {
                List tenantJobInfoList = JSON.parseArray((String)readJson, JobInfoEntity.class);
                if (HussarUtils.isNotEmpty((Object)tenantJobInfoList)) {
                    for (JobInfoEntity sysTenantJobInfo : tenantJobInfoList) {
                        sysTenantJobInfo.setTenantCode(tenantCode);
                        sysTenantJobInfo.setDbName(connName);
                    }
                }
                return tenantJobInfoList;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    public void updateTenantStatus() {
        ArrayList status = Lists.newArrayList((Object[])new String[]{"4", "2", "0"});
        List list = this.tenantService.list((Wrapper)new LambdaQueryWrapper().notIn(SysTenant::getTenantStatus, (Collection)status));
        if (HussarUtils.isEmpty((Object)list)) {
            return;
        }
        List tenantCodes = list.stream().map(SysTenant::getTenantCode).collect(Collectors.toList());
        Map<String, List<SysTenantLog>> tenantLogsMap = this.sysTenantLogService.list((Wrapper)new LambdaQueryWrapper().in(SysTenantLog::getTenantCode, tenantCodes)).stream().collect(Collectors.groupingBy(SysTenantLog::getTenantCode));
        for (SysTenant sysTenant : list) {
            String tenantCode = sysTenant.getTenantCode();
            List allLogList = tenantLogsMap.getOrDefault(tenantCode, Collections.emptyList());
            Optional<SysTenantLog> anyAfterAdd = allLogList.stream().filter(item -> Objects.equals(item.getStepNo(), StepConstants.AFTER_ADD_TENANT)).findAny();
            List errorLogList = allLogList.stream().filter(item -> item.getExecStatus().equals(0)).collect(Collectors.toList());
            List executingLogList = allLogList.stream().filter(item -> item.getExecStatus().equals(2)).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(allLogList) && HussarUtils.isEmpty(errorLogList) && HussarUtils.isEmpty(executingLogList) && anyAfterAdd.isPresent()) {
                this.updateTenantStatus(tenantCode, "1");
                LOGGER.info("\u66f4\u65b0\u9879\u76ee{}\u72b6\u6001\u4e3a\u6b63\u5e38", (Object)tenantCode);
                continue;
            }
            if (HussarUtils.isNotEmpty(errorLogList)) {
                this.updateTenantStatus(tenantCode, "4");
                LOGGER.info("\u66f4\u65b0\u9879\u76ee{}\u72b6\u6001\u4e3a\u521b\u5efa\u5931\u8d25", (Object)tenantCode);
                continue;
            }
            if (!HussarUtils.isNotEmpty(executingLogList)) continue;
            this.updateTenantStatus(tenantCode, "3");
            LOGGER.info("\u66f4\u65b0\u9879\u76ee{}\u72b6\u6001\u4e3a\u521b\u5efa\u4e2d", (Object)tenantCode);
        }
    }

    public void updateTenantStatus(String tenantCode, String tenantStatus) {
        SysTenant sysTenant = (SysTenant)this.tenantService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenant::getTenantCode, (Object)tenantCode), false);
        if (HussarUtils.isNotEmpty((Object)sysTenant)) {
            sysTenant.setTenantStatus(tenantStatus);
            this.tenantService.updateById((Object)sysTenant);
            HussarTenantDefinition tenantByTenantCode = this.tenantService.getTenantByTenantCode(tenantCode);
            tenantByTenantCode.setTenantStatus(tenantStatus);
            SysTenantRecord sysTenantRecord = (SysTenantRecord)this.tenantRecordService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantCode, (Object)tenantCode));
            sysTenantRecord.setTenantParams(JSON.toJSONString((Object)tenantByTenantCode));
            this.tenantRecordService.updateById((Object)sysTenantRecord);
            TenantCacheUtil.putTenat2Cache((HussarTenantDefinition)tenantByTenantCode);
        }
    }

    @HussarTransactional
    public void designateDeveloper(DesignateDeveloperDto delegateUserDto) {
        HussarTenantDefinition definition = TenantCacheUtil.loadFromCacheByTenantId((Long)delegateUserDto.getTenantId());
        if (HussarUtils.isEmpty((Object)definition)) {
            definition = this.getTenantByTenantId(delegateUserDto.getTenantId());
        }
        if (HussarUtils.isEmpty((Object)definition)) {
            throw new BaseException("\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5f02\u5e38\uff0c tenantId = " + delegateUserDto.getTenantId());
        }
        if (HussarUtils.isNotEmpty((Object)delegateUserDto.getAddDeveloperIds())) {
            String connName = definition.getConnName();
            List mainUsers = this.sysUsersService.listByIds((Collection)delegateUserDto.getAddDeveloperIds());
            if (HussarUtils.isNotEmpty((Object)mainUsers)) {
                ArrayList addList = new ArrayList();
                ArrayList tenantUsers = new ArrayList();
                ArrayList tenantUserRoles = new ArrayList();
                ArrayList tenantStruUsers = new ArrayList();
                mainUsers.forEach(user -> {
                    SysTenantDeveloper tenantDelegateUser = new SysTenantDeveloper();
                    tenantDelegateUser.setUserId(user.getId());
                    tenantDelegateUser.setTenantId(delegateUserDto.getTenantId());
                    addList.add(tenantDelegateUser);
                    SysUsers sysUsers = new SysUsers();
                    sysUsers.setId(user.getId());
                    sysUsers.setUserName(user.getUserName());
                    sysUsers.setMobile(user.getMobile());
                    sysUsers.setUserAccount(user.getUserAccount());
                    sysUsers.setAccountStatus(UserStatus.OK.getCode());
                    sysUsers.setIsCpublic("0");
                    sysUsers.setTypeProperty("1");
                    sysUsers.setSecurityLevel(Integer.valueOf(3));
                    sysUsers.setMaxSessions(Integer.valueOf(-1));
                    sysUsers.setCorporationId(Long.valueOf(12L));
                    sysUsers.setDepartmentId(Long.valueOf(12L));
                    sysUsers.setIsSys("0");
                    sysUsers.setLoginIpLimit("0");
                    sysUsers.setLoginTimeLimit("0");
                    String encodeSecure = user.getPassword();
                    sysUsers.setPassword(encodeSecure);
                    sysUsers.setAccountStatus(UserStatus.OK.getCode());
                    tenantUsers.add(sysUsers);
                    SysUserRole sysUserRole = new SysUserRole();
                    sysUserRole.setUserId(user.getId());
                    sysUserRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
                    sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                    tenantUserRoles.add(sysUserRole);
                    SysUserRole sysUserRole2 = new SysUserRole();
                    sysUserRole2.setUserId(user.getId());
                    sysUserRole2.setGrantedRole(SysUserAndRole.DEVELOP_ROLE.getValue());
                    sysUserRole2.setAdminOption(UserRoleStatus.OK.getCode());
                    tenantUserRoles.add(sysUserRole2);
                    SysStruUser one = (SysStruUser)this.sysStruUserService.getOne(connName, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruUser::getUserId, (Object)user.getId())).eq(SysStruUser::getStruId, (Object)TenantConstant.TEAM_STRU_ID));
                    if (HussarUtils.isEmpty((Object)one)) {
                        SysStruUser sysStruUser = new SysStruUser();
                        sysStruUser.setStruId(TenantConstant.TEAM_STRU_ID);
                        sysStruUser.setUserId(user.getId());
                        tenantStruUsers.add(sysStruUser);
                    }
                });
                this.tenantDeveloperService.saveBatch(addList);
                this.sysUsersService.saveOrUpdateBatch(definition.getConnName(), tenantUsers);
                this.sysUserRoleService.saveOrUpdateBatch(definition.getConnName(), tenantUserRoles);
                this.sysStruUserService.saveOrUpdateBatch(definition.getConnName(), tenantStruUsers);
            }
        }
        if (HussarUtils.isNotEmpty((Object)delegateUserDto.getRetrieveDeveloperIds())) {
            this.tenantDeveloperService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDeveloper::getTenantId, (Object)delegateUserDto.getTenantId())).in(SysTenantDeveloper::getUserId, (Collection)delegateUserDto.getRetrieveDeveloperIds()));
            List tenantUsers = this.sysUsersService.listByIds(definition.getConnName(), (Collection)delegateUserDto.getRetrieveDeveloperIds());
            if (HussarUtils.isNotEmpty((Object)tenantUsers)) {
                tenantUsers.forEach(user -> user.setAccountStatus(UserStatus.CANCEL.getCode()));
                this.sysUsersService.updateBatchById(definition.getConnName(), (Collection)tenantUsers);
            }
        }
    }

    public Page<SysTenant> developList(Integer current, Integer size, String tenantName) {
        boolean t;
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        List list = this.tenantDeveloperService.list((Wrapper)new LambdaQueryWrapper().eq(SysTenantDeveloper::getUserId, (Object)securityUser.getUserId()));
        if (HussarUtils.isEmpty((Object)list)) {
            return new Page();
        }
        boolean bl = t = tenantName.contains("%") || tenantName.contains("_");
        if (t) {
            tenantName = tenantName.replaceAll("%", "\\\\%").replaceAll("_", "\\\\_");
        }
        List ids = list.stream().map(SysTenantDeveloper::getTenantId).collect(Collectors.toList());
        return (Page)this.tenantService.page((IPage)new Page((long)current.intValue(), (long)size.intValue()), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysTenant::getId, ids)).in(SysTenant::getTenantStatus, new Object[]{"1"})).like(SysTenant::getTenantName, (Object)tenantName)).orderByDesc(HussarBaseEntity::getCreateTime));
    }

    public List<SysUsers> getDevelopers(Long tenantId) {
        List<Object> developers = new ArrayList<SysUsers>();
        List list = this.tenantDeveloperService.list((Wrapper)new LambdaQueryWrapper().eq(SysTenantDeveloper::getTenantId, (Object)tenantId));
        if (HussarUtils.isNotEmpty((Object)list)) {
            List userIds = list.stream().map(SysTenantDeveloper::getUserId).collect(Collectors.toList());
            developers = this.sysUsersService.listByIds(userIds);
        }
        return developers;
    }

    public void replaceTenantCodeInFiles(String directoryPath, final String placeholder, final String tenantCode) {
        Path directory = Paths.get(directoryPath, new String[0]);
        try {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    try {
                        String content = new String(Files.readAllBytes(file));
                        String newContent = content.replace(placeholder, tenantCode);
                        if (!content.equals(newContent)) {
                            Files.write(file, newContent.getBytes(), new OpenOption[0]);
                            System.out.println("Updated file: " + file);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

