/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.tenant.common.dao.SysTenantLogMapper;
import com.jxdinfo.hussar.tenant.common.dto.TenantLogDto;
import com.jxdinfo.hussar.tenant.common.model.SysTenantLog;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantLogService;
import java.util.Comparator;
import java.util.List;
import org.springframework.stereotype.Service;

@HussarDs(value="master")
@Service(value="com.jxdinfo.hussar.tenant.service.impl.sysTenantLogServiceImpl")
public class SysTenantLogServiceImpl
extends HussarBaseServiceImpl<SysTenantLogMapper, SysTenantLog>
implements ISysTenantLogService {
    public Page<SysTenantLog> logList(TenantLogDto tenantLogDto) {
        LambdaQueryWrapper eq;
        Page page = HussarPageUtils.convert((PageInfo)new PageInfo(tenantLogDto.getCurrent(), tenantLogDto.getSize()));
        Page result = (Page)this.page((IPage)page, (Wrapper)(eq = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantLog::getTenantCode, (Object)tenantLogDto.getTenantCode())));
        if (HussarUtils.isNotEmpty((Object)result) && HussarUtils.isNotEmpty((Object)result.getRecords())) {
            result.getRecords().sort(Comparator.comparing(HussarBaseEntity::getCreateTime).thenComparing(SysTenantLog::getStepNo));
        }
        return result;
    }

    public List<SysTenantLog> listByTenantCode(String tenantCode) {
        LambdaQueryWrapper eq = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantLog::getTenantCode, (Object)tenantCode);
        eq.orderByAsc(SysTenantLog::getStepNo);
        return this.list((Wrapper)eq);
    }

    public SysTenantLog getByTenantCodeAndStepNo(String tenantCode, String serviceName, Integer stepNo) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantLog::getTenantCode, (Object)tenantCode);
        if (stepNo != null) {
            wrapper.eq(SysTenantLog::getStepNo, (Object)stepNo);
        }
        if (HussarUtils.isNotBlank((CharSequence)serviceName)) {
            wrapper.eq(SysTenantLog::getServiceName, (Object)serviceName);
        }
        return (SysTenantLog)this.getOne((Wrapper)wrapper, false);
    }

    public Integer getMaxCreateDbStepNo(String tenantCode) {
        return ((SysTenantLogMapper)this.getBaseMapper()).getMaxCreateDbStepNo(tenantCode);
    }
}

