/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import com.jxdinfo.hussar.tenant.common.dto.QueryUpgradeDto;
import com.jxdinfo.hussar.tenant.common.model.SysTenantUpgrade;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantUpgradeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u79df\u6237\u5347\u7ea7"})
@RestController(value="com.jxdinfo.hussar.tenant.common.controller.hussarBaseTenantUpgradeController")
@RequestMapping(value={"/hussarBase/tenant/upgrade"})
public class HussarBaseTenantUpgradeController {
    @Autowired
    private ISysTenantUpgradeService tenantUpgradeService;

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u83b7\u53d6\u79df\u6237\u5347\u7ea7\u5217\u8868", notes="\u83b7\u53d6\u79df\u6237\u5347\u7ea7\u5217\u8868")
    @AuditLog(moduleName="\u79df\u6237\u7ba1\u7406", eventDesc="\u83b7\u53d6\u79df\u6237\u5347\u7ea7\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<SysTenantUpgrade>> list(@ApiParam(value="\u67e5\u8be2\u5347\u7ea7\u4fe1\u606f\u6761\u4ef6") QueryUpgradeDto queryUpgradeDto) {
        return ApiResponse.success((Object)this.tenantUpgradeService.search(queryUpgradeDto));
    }

    @GetMapping(value={"/viewTenantUpgrade"})
    @ApiOperation(value="\u67e5\u770b\u79df\u6237\u5347\u7ea7\u8be6\u60c5", notes="\u67e5\u770b\u79df\u6237\u5347\u7ea7\u8be6\u60c5")
    @AuditLog(moduleName="\u79df\u6237\u7ba1\u7406", eventDesc="\u67e5\u770b\u79df\u6237\u5347\u7ea7\u8be6\u60c5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<String> viewTenantUpgrade(@ApiParam(value="\u5347\u7ea7ID") @RequestParam Long id) {
        return ApiResponse.success((String)this.tenantUpgradeService.viewTenantUpgrade(id));
    }

    @PostMapping(value={"/updateSingle"})
    @CheckPermission(value={"hussarBase:tenant:upgrade:updateSingle"})
    public ApiResponse<String> updateSingle() {
        this.tenantUpgradeService.updateSingle();
        return ApiResponse.success((String)"\u5347\u7ea7\u4e2d\uff01");
    }

    @PostMapping(value={"/updateSingleById"})
    @CheckPermission(value={"hussarBase:tenant:upgrade:updateSingleById"})
    public ApiResponse<String> updateSingleById(@ApiParam(value="\u5347\u7ea7id") @RequestBody Long id) {
        this.tenantUpgradeService.updateSingleById(id);
        return ApiResponse.success((String)"\u5347\u7ea7\u4e2d\uff01");
    }

    @PostMapping(value={"/updateMicroService"})
    @CheckPermission(value={"hussarBase:tenant:upgrade:updateMicroService"})
    public ApiResponse<String> updateMicroService(@ApiParam(value="\u5347\u7ea7\u5fae\u670d\u52a1\u540d") @RequestBody String serviceName) {
        this.tenantUpgradeService.updateMicroService(serviceName);
        return ApiResponse.success((String)("\u5347\u7ea7\u5fae\u670d\u52a1" + serviceName + "\u4e2d\uff01"));
    }

    @PostMapping(value={"/updateMicroServiceById"})
    @CheckPermission(value={"hussarBase:tenant:upgrade:updateMicroServiceById"})
    public ApiResponse<String> updateMicroServiceById(@ApiParam(value="\u5347\u7ea7\u5fae\u670d\u52a1\u540d") @RequestBody Long id) {
        this.tenantUpgradeService.updateMicroServiceById(id);
        return ApiResponse.success((String)"\u5347\u7ea7\u5fae\u670d\u52a1\u4e2d\uff01");
    }
}

