/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.datasource.service.IHussarBaseSQLExecutor;
import com.jxdinfo.hussar.datasource.util.DbUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.tenant.common.dto.DbTestConnectionDto;
import com.jxdinfo.hussar.tenant.common.model.SysTenantDatasource;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantDataSourceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6570\u636e\u5e93\u7c7b\u578b"})
@RestController(value="com.jxdinfo.hussar.tenant.controller.hussarBaseDbTypeController")
@RequestMapping(value={"/hussarBase/tenant"})
public class HussarBaseTenantDbController {
    @Autowired
    private ISysTenantDataSourceService sysTenantDataSourceService;
    @Autowired
    private IHussarBaseSQLExecutor hussarBaseSQLExecutor;

    @GetMapping(value={"/getMasterDbType"})
    @ApiOperation(value="\u83b7\u53d6\u4e3b\u6570\u636e\u5e93\u7c7b\u578b", notes="\u83b7\u53d6\u4e3b\u6570\u636e\u5e93\u7c7b\u578b")
    @AuditLog(moduleName="\u79df\u6237\u7ba1\u7406", eventDesc="\u83b7\u53d6\u4e3b\u6570\u636e\u5e93\u7c7b\u578b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<String> getMasterDbType() {
        LambdaQueryWrapper datasourceWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasource::getConnName, (Object)"master");
        SysTenantDatasource sysTenantDatasource = (SysTenantDatasource)this.sysTenantDataSourceService.getOne((Wrapper)datasourceWrapper, false);
        AssertUtil.isNotNull((Object)sysTenantDatasource, (String)"\u67e5\u8be2\u4e0d\u5230\u4e3b\u6570\u636e\u6e90\u4fe1\u606f");
        String dbType = DbUtil.getDbType((String)sysTenantDatasource.getJdbcUrl());
        return ApiResponse.success((String)dbType);
    }

    @PostMapping(value={"/checkDbConnection"})
    @ApiOperation(value="\u6d4b\u8bd5\u6570\u636e\u5e93\u8fde\u63a5", notes="\u6d4b\u8bd5\u6570\u636e\u5e93\u8fde\u63a5")
    @AuditLog(moduleName="\u79df\u6237\u7ba1\u7406", eventDesc="\u6d4b\u8bd5\u6570\u636e\u5e93\u8fde\u63a5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Boolean> checkDbConnection(@ApiParam(value="\u6d4b\u8bd5\u6570\u636e\u5e93\u8fde\u63a5DTO") @RequestBody DbTestConnectionDto dbTestConnectionDto) {
        return ApiResponse.success((Object)this.hussarBaseSQLExecutor.checkDbConnection(dbTestConnectionDto.getJdbcUrl(), dbTestConnectionDto.getUserName(), dbTestConnectionDto.getPassword()));
    }

    @GetMapping(value={"/getServerInfo"})
    @ApiOperation(value="\u83b7\u53d6\u670d\u52a1\u5668\u4fe1\u606f", notes="\u83b7\u53d6\u670d\u52a1\u5668\u4fe1\u606f")
    @AuditLog(moduleName="\u79df\u6237\u7ba1\u7406", eventDesc="\u83b7\u53d6\u670d\u52a1\u5668\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<String> getServerInfo(@ApiParam(value="\u5f00\u53d1\u4eba\u5458") @RequestBody String devUser, @ApiParam(value="\u79df\u6237\u7f16\u7801") @RequestBody String tCode) {
        return ApiResponse.success((String)"");
    }
}

