/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.HussarReflectionUtils;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.dispatch.api.entity.JobInfoEntity;
import com.jxdinfo.hussar.support.job.dispatch.api.service.JobServiceService;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.constant.StepConstants;
import com.jxdinfo.hussar.tenant.common.model.HussarMethod;
import com.jxdinfo.hussar.tenant.common.model.SysTenantLog;
import com.jxdinfo.hussar.tenant.common.model.SysTenantRecord;
import com.jxdinfo.hussar.tenant.common.model.SysTenantRegister;
import com.jxdinfo.hussar.tenant.common.service.IAsyncUpdateTenantLogService;
import com.jxdinfo.hussar.tenant.common.service.IHussarBaseTenantService;
import com.jxdinfo.hussar.tenant.common.service.IHussarRetryService;
import com.jxdinfo.hussar.tenant.common.service.IOutSideCreateStorageService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantLogService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantRecordService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantRegisterService;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.tenant.service.impl.hussarRetryServiceImpl")
public class HussarRetryServiceImpl
implements IHussarRetryService {
    private static Logger LOGGER = LoggerFactory.getLogger(HussarRetryServiceImpl.class);
    @Autowired
    private ISysTenantLogService sysTenantLogService;
    @Autowired
    private IHussarBaseTenantService hussarBaseTenantService;
    @Autowired
    private JobServiceService jobServiceService;
    @Autowired
    private ISysTenantRecordService tenantRecordService;
    @Autowired
    private IAsyncUpdateTenantLogService asyncUpdateTenantLogService;
    @Autowired
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Autowired
    private ISysTenantRegisterService sysTenantRegisterService;

    @HussarTransactional
    public void replay(String tenantCode) {
        Executor hussarBaseTenantExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        hussarBaseTenantExecutor.execute(() -> this.asyncReplay(tenantCode, null));
    }

    public void replayOne(String tenantCode, Integer stepNo) {
        Executor hussarBaseTenantExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        hussarBaseTenantExecutor.execute(() -> this.asyncReplay(tenantCode, stepNo));
    }

    public Map<String, Object> checkRegisterService(String tenantCode, Integer stepNo) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("checkFlag", true);
        result.put("msg", "");
        if (stepNo == null) {
            return result;
        }
        LambdaQueryWrapper eq = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantLog::getTenantCode, (Object)tenantCode);
        eq.eq(SysTenantLog::getTenantCode, (Object)tenantCode);
        eq.orderByAsc(SysTenantLog::getStepNo);
        List logList = this.sysTenantLogService.list((Wrapper)eq);
        if (HussarUtils.isEmpty((Object)logList)) {
            return result;
        }
        boolean timeFlag = false;
        long timeInterval = 0L;
        ArrayList<SysTenantLog> errorLogList = new ArrayList<SysTenantLog>();
        for (SysTenantLog log : logList) {
            long currentT;
            if (log.getExecStatus().equals(0) && Objects.equals(log.getStepNo(), stepNo)) {
                errorLogList.add(log);
            }
            if (!log.getExecStatus().equals(2) || !Objects.equals(log.getStepNo(), stepNo)) continue;
            LocalDateTime createTime = log.getCreateTime();
            long createT = createTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
            if (createT + 300000L < (currentT = System.currentTimeMillis())) {
                errorLogList.add(log);
                continue;
            }
            timeFlag = true;
            timeInterval = (createT + 300000L - currentT) / 60000L;
            long num = (createT + 300000L - currentT) % 60000L;
            timeInterval = num == 0L ? timeInterval : timeInterval + 1L;
            break;
        }
        if (timeFlag) {
            result.put("checkFlag", false);
            result.put("msg", "\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u8bf7" + timeInterval + "\u5206\u949f\u540e\u91cd\u8bd5");
            return result;
        }
        if (HussarUtils.isEmpty(errorLogList)) {
            return result;
        }
        Map logErrorMap = errorLogList.stream().collect(Collectors.toMap(SysTenantLog::getStepNo, Function.identity()));
        SysTenantLog createDbLog = (SysTenantLog)logErrorMap.get(StepConstants.CREATE_DB);
        if (HussarUtils.isNotEmpty((Object)createDbLog)) {
            return result;
        }
        ArrayList<String> serviceNameList = new ArrayList<String>();
        for (SysTenantLog log : errorLogList) {
            if (log.getStepNo() < StepConstants.MICROSERVICE_CREATE_DB_MIN || log.getStepNo() > StepConstants.MICROSERVICE_CREATE_DB_MAX) continue;
            Object paramValue1 = ((HussarMethod)JSON.parseObject((String)log.getMethodParams(), HussarMethod.class)).getParamValues()[0];
            Map storageProperties = (Map)JSON.parseObject((String)JSON.toJSONString((Object)paramValue1), (TypeReference)new TypeReference<HashMap<String, Object>>(){}, (Feature[])new Feature[0]);
            String serviceName = (String)storageProperties.get("serviceName");
            serviceNameList.add(serviceName);
        }
        if (HussarUtils.isNotEmpty(serviceNameList)) {
            List registers = this.sysTenantRegisterService.list();
            List serviceNames = registers.stream().map(SysTenantRegister::getServiceName).collect(Collectors.toList());
            for (String name : serviceNameList) {
                if (serviceNames.contains(name)) continue;
                result.put("checkFlag", false);
                result.put("msg", "\u5fae\u670d\u52a1\uff1a" + name + "\u672a\u6ce8\u518c");
                return result;
            }
        }
        return result;
    }

    @HussarTransactional
    private void asyncReplay(String tenantCode, Integer stepNo) {
        LambdaQueryWrapper eq = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantLog::getTenantCode, (Object)tenantCode);
        eq.eq(SysTenantLog::getTenantCode, (Object)tenantCode);
        eq.orderByAsc(SysTenantLog::getStepNo);
        List logList = this.sysTenantLogService.list((Wrapper)eq);
        if (HussarUtils.isEmpty((Object)logList)) {
            return;
        }
        List errorLogList = logList.stream().filter(item -> {
            if (stepNo != null) {
                return (item.getExecStatus().equals(0) || item.getExecStatus().equals(2)) && Objects.equals(item.getStepNo(), stepNo);
            }
            return item.getExecStatus().equals(0);
        }).collect(Collectors.toList());
        if (HussarUtils.isEmpty(errorLogList)) {
            return;
        }
        Map logErrorMap = errorLogList.stream().collect(Collectors.toMap(SysTenantLog::getStepNo, Function.identity()));
        SysTenantLog createDbLog = (SysTenantLog)logErrorMap.get(StepConstants.CREATE_DB);
        if (HussarUtils.isNotEmpty((Object)createDbLog)) {
            SysTenantRecord sysTenantRecord = (SysTenantRecord)this.tenantRecordService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantCode, (Object)tenantCode));
            String paramStr = sysTenantRecord.getTenantParams();
            String className = sysTenantRecord.getTenantClass();
            createDbLog.setExecStatus(Integer.valueOf(2));
            this.sysTenantLogService.updateById((Object)createDbLog);
            try {
                this.hussarBaseTenantService.asyncAdd(JSON.parseObject((String)paramStr, Class.forName(className)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            ArrayList<SysTenantLog> remain = new ArrayList<SysTenantLog>();
            ArrayList<Object> storagePropertiesListOther = new ArrayList<Object>();
            ArrayList<SysTenantLog> tenantLogs = new ArrayList<SysTenantLog>();
            for (SysTenantLog log : errorLogList) {
                if (log.getStepNo() >= StepConstants.MICROSERVICE_CREATE_DB_MIN && log.getStepNo() <= StepConstants.MICROSERVICE_CREATE_DB_MAX) {
                    Object paramValue1 = ((HussarMethod)JSON.parseObject((String)log.getMethodParams(), HussarMethod.class)).getParamValues()[0];
                    Map storageProperties = (Map)JSON.parseObject((String)JSON.toJSONString((Object)paramValue1), (TypeReference)new TypeReference<HashMap<String, Object>>(){}, (Feature[])new Feature[0]);
                    storagePropertiesListOther.add(storageProperties);
                    log.setExecStatus(Integer.valueOf(2));
                    tenantLogs.add(log);
                    continue;
                }
                remain.add(log);
            }
            if (HussarUtils.isNotEmpty(tenantLogs)) {
                this.sysTenantLogService.updateBatchById(tenantLogs);
            }
            List registers = this.sysTenantRegisterService.list();
            List serviceNames = registers.stream().map(SysTenantRegister::getServiceName).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(storagePropertiesListOther)) {
                IOutSideCreateStorageService outSideCreateStorageService = (IOutSideCreateStorageService)SpringContextHolder.getBean(IOutSideCreateStorageService.class);
                for (Map map : storagePropertiesListOther) {
                    map.put("caller", ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name"));
                    String serviceName = (String)map.get("serviceName");
                    if (HussarUtils.isNotEmpty((Object)stepNo)) {
                        AssertUtil.isTrue((boolean)serviceNames.contains(serviceName), (String)("\u5fae\u670d\u52a1\uff1a" + serviceName + "\u672a\u6ce8\u518c"));
                    }
                    outSideCreateStorageService.dealCreateStorage(map, serviceName);
                }
            }
            if (HussarUtils.isNotEmpty(remain)) {
                for (SysTenantLog log : remain) {
                    String string = log.getBeanName();
                    String methodName = log.getMethodName();
                    String getMethodParams = log.getMethodParams();
                    HussarMethod hm = (HussarMethod)JSON.parseObject((String)getMethodParams, HussarMethod.class);
                    ArrayList values = Lists.newArrayList();
                    if (Objects.equals(log.getStepNo(), StepConstants.BEFORE_ADD_TENANT) || Objects.equals(log.getStepNo(), StepConstants.AFTER_ADD_TENANT) || Objects.equals(log.getStepNo(), StepConstants.SAVE_TENANT)) {
                        if (hm.getTenantEntiryClass() != null) {
                            for (Object obj : hm.getParamValues()) {
                                if (obj instanceof JSONObject) {
                                    try {
                                        values.add(JSON.parseObject((String)JSON.toJSONString((Object)obj), (Class)hm.getTenantEntiryClass()));
                                    }
                                    catch (Exception e) {
                                        values.add(obj);
                                    }
                                    continue;
                                }
                                values.add(obj);
                            }
                        }
                    } else {
                        values = Lists.newArrayList((Object[])hm.getParamValues());
                    }
                    if (Objects.equals(log.getStepNo(), StepConstants.INIT_JOB_INFO)) {
                        try {
                            log.setExecStatus(Integer.valueOf(2));
                            this.sysTenantLogService.updateById((Object)log);
                            List tenantJobInfoList = (List)JSON.parseObject((String)JSON.toJSONString((Object)hm.getParamValues()[1]), (TypeReference)new TypeReference<ArrayList<JobInfoEntity>>(){}, (Feature[])new Feature[0]);
                            JobInfoEntity jobInfoEntity = new JobInfoEntity();
                            jobInfoEntity.setTenantCode(tenantCode);
                            HashMap<String, String[]> map = new HashMap<String, String[]>();
                            map.put("tenantCode_eq", new String[]{tenantCode});
                            List joblist = (List)this.jobServiceService.getJobListApi(map).getData();
                            if (HussarUtils.isNotEmpty((Object)joblist)) {
                                for (JobInfoEntity job : joblist) {
                                    this.jobServiceService.physicalDeleteJob(job.getId());
                                }
                            }
                            if (HussarUtils.isNotEmpty((Object)tenantJobInfoList)) {
                                this.jobServiceService.saveJobList(tenantJobInfoList);
                            }
                            log.setExecStatus(Integer.valueOf(1));
                            this.asyncUpdateTenantLogService.tenantlogUpdate(log);
                        }
                        catch (Exception e) {
                            LOGGER.error("\u91cd\u8bd5\u9519\u8bef\uff1a", (Throwable)e);
                            log.setErrorTimes(Integer.valueOf(log.getErrorTimes() + 1));
                            this.asyncUpdateTenantLogService.tenantlogUpdate(log);
                        }
                        continue;
                    }
                    try {
                        log.setExecStatus(Integer.valueOf(2));
                        this.sysTenantLogService.updateById((Object)log);
                        HussarReflectionUtils.springInvokeMethod((String)string, (String)methodName, (Class[])hm.getParamClass(), (Object[])values.toArray());
                        log.setExecStatus(Integer.valueOf(1));
                        this.asyncUpdateTenantLogService.tenantlogUpdate(log);
                    }
                    catch (Exception e) {
                        LOGGER.error("\u91cd\u8bd5\u9519\u8bef\uff1a", (Throwable)e);
                        log.setErrorTimes(Integer.valueOf(log.getErrorTimes() + 1));
                        log.setExecStatus(Integer.valueOf(0));
                        this.asyncUpdateTenantLogService.tenantlogUpdate(log);
                    }
                }
            }
        }
    }
}

