/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.jxdinfo.hussar.authentication.service.SysAuthClientModelService;
import com.jxdinfo.hussar.authorization.menu.model.SysMenu;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.base.cloud.model.client.SysAuthClientModel;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.EntityUtils;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.datasource.factory.StorageFactory;
import com.jxdinfo.hussar.datasource.model.RDBStorageDefinition;
import com.jxdinfo.hussar.datasource.service.IHussarBaseSQLExecutor;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.platform.core.utils.DateTimeUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.job.core.enums.TimeExpressionType;
import com.jxdinfo.hussar.support.job.core.exception.JobRuntimeException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.constant.StepConstants;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.model.SysTenantDatasource;
import com.jxdinfo.hussar.tenant.common.model.SysTenantJobInfo;
import com.jxdinfo.hussar.tenant.common.model.SysTenantLog;
import com.jxdinfo.hussar.tenant.common.model.SysTenantRecord;
import com.jxdinfo.hussar.tenant.common.model.SysTenantSecure;
import com.jxdinfo.hussar.tenant.common.model.SysTenantUpgrade;
import com.jxdinfo.hussar.tenant.common.model.TenantPermissionData;
import com.jxdinfo.hussar.tenant.common.service.IHussarBaseTenantService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantDataSourceService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantJobInfoService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantLogService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantRecordService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantSecureService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantUpgradeService;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantLogUtil;
import com.jxdinfo.hussar.tenant.common.util.TenantUtil;
import com.jxdinfo.hussar.validator.service.IHussarValidateService;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.core.util.CronExpression;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.core.RedisTemplate;

public abstract class AbstractHussarBaseTenantService<T extends HussarTenantDefinition>
implements IHussarBaseTenantService<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractHussarBaseTenantService.class);
    @Autowired
    private ISysTenantService tenantService;
    @Autowired
    private ISysUserRoleService sysUserRoleService;
    @Autowired
    private ISysRoleFunctionsService roleFunctionsService;
    @Autowired
    private ISysRolesService sysRolesService;
    @Autowired
    private ISysFunctionsService functionsService;
    @Autowired
    private SysAuthClientModelService sysAuthClientModelService;
    @Autowired
    private ISysTenantJobInfoService sysTenantJobInfoService;
    @Autowired
    private ISysTenantSecureService tenantSecureService;
    @Autowired
    private ISysTenantLogService sysTenantLogService;
    @Autowired
    private DynamicDatasourceService dynamicDatasourceService;
    @Autowired
    private ISysResourcesService resourcesService;
    @Autowired
    protected ISysIdtableService sysIdtableService;
    @Autowired
    private IHussarValidateService validateService;
    @Autowired
    private ISysTenantDataSourceService sysTenantDataSourceService;
    private static ExecutorService executor = (ExecutorService)SpringContextHolder.getBean(ExecutorService.class);
    @Autowired
    private ISysRoleResourceService roleResourceService;
    @Autowired
    private ISysTenantRecordService tenantRecordService;
    @Autowired
    private IHussarBaseSQLExecutor hussarBaseSQLExecutor;
    @Autowired
    private ISysTenantUpgradeService sysTenantUpgradeService;

    private RedisTemplate getRedisTemplate() {
        return (RedisTemplate)SpringContextHolder.getBean((String)"redisTemplate");
    }

    public HussarTenantDefinition getTenantByTenantCode(String tenantCode) {
        return this.tenantService.getTenantByTenantCode(tenantCode);
    }

    public HussarTenantDefinition getTenantByTenantId(Long tenantId) {
        return this.tenantService.getTenantByTenantId(tenantId);
    }

    public HussarTenantDefinition getTenantByDomain(String domain) {
        return this.tenantService.getTenantByDomain(domain);
    }

    @HussarTransactional
    public void addTenant(T t) {
        Long tenantId = IdWorker.getId(t);
        t.setTenantId(tenantId);
        t.setTenantStatus("3");
        this.checkData(t);
        TenantCacheUtil.putTenat2Cache(t);
        SysTenant sysTenant = TenantUtil.convert2SysTenant(t);
        this.tenantService.save((Object)sysTenant);
        LOGGER.info("\u521b\u5efa\u79df\u6237START{}", (Object)t.getTenantCode());
        executor.execute(() -> this.asyncAdd(t));
    }

    @HussarTransactional
    public void deleteTenant(Long tenantId) {
        AssertUtil.isNotNull((Object)tenantId, (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SysTenant tenant = (SysTenant)this.tenantService.getById((Serializable)tenantId);
        AssertUtil.isNotNull((Object)tenant, (String)"\u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f\uff01");
        String connName = tenant.getConnName();
        String tenantCode = tenant.getTenantCode();
        tenant.setTenantStatus("0");
        this.tenantService.updateById((Object)tenant);
        HussarFixedCacheUtil.evict((String)"tenant_info", (Object)tenantId);
        LambdaQueryWrapper dswrapper = new LambdaQueryWrapper();
        dswrapper.eq(SysTenantDatasource::getConnName, (Object)connName);
        SysTenantDatasource removeDs = (SysTenantDatasource)this.sysTenantDataSourceService.getOne((Wrapper)dswrapper, false);
        try {
            if (!HussarUtils.isNull((Object)removeDs)) {
                LOGGER.info("\u5220\u9664\u79df\u6237\u6570\u636e\u6e90\u4fe1\u606f");
                this.removeCache(removeDs.getId(), connName);
                this.sysTenantDataSourceService.removeById((Serializable)removeDs.getId());
                this.dynamicDatasourceService.removeDynamicDatasource(connName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            LOGGER.info("\u5220\u9664\u79df\u6237\u5b9a\u65f6\u4efb\u52a1\u4fe1\u606f");
            LambdaQueryWrapper jobwrapper = new LambdaQueryWrapper();
            jobwrapper.eq(SysTenantJobInfo::getTenantId, (Object)tenantId);
            this.sysTenantJobInfoService.remove((Wrapper)jobwrapper);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            LOGGER.info("\u5220\u9664\u79df\u6237\u5347\u7ea7\u65e5\u5fd7\u7b49\u4fe1\u606f");
            this.sysTenantLogService.remove((Wrapper)new LambdaQueryWrapper().eq(SysTenantLog::getTenantCode, (Object)tenantCode));
            this.tenantSecureService.remove((Wrapper)new LambdaQueryWrapper().eq(SysTenantSecure::getTenantCode, (Object)tenantCode));
            this.sysTenantUpgradeService.remove((Wrapper)new LambdaQueryWrapper().eq(SysTenantUpgrade::getTenantCode, (Object)tenantCode));
            this.tenantRecordService.remove((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantCode, (Object)tenantCode));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void removeCache(Long id, String connName) {
        String CACHE_KEY_PREFIX = "BASE:DATASOURCE:";
        String CACHE_NAME = "base:datasource:all";
        String key_connName = CACHE_KEY_PREFIX + connName;
        String key_dbId = CACHE_KEY_PREFIX + id;
        HussarFixedCacheUtil.evict((String)CACHE_NAME, (Object)key_connName);
        HussarFixedCacheUtil.evict((String)CACHE_NAME, (Object)key_dbId);
    }

    private void dealFail(String tenantCode) {
        SysTenant sysTenant = (SysTenant)this.tenantService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenant::getTenantCode, (Object)tenantCode));
        if (HussarUtils.isNotEmpty((Object)sysTenant)) {
            sysTenant.setTenantStatus("4");
            this.tenantService.updateById((Object)sysTenant);
            HussarTenantDefinition definition = TenantCacheUtil.loadFromCacheByTenantCode((String)tenantCode);
            if (HussarUtils.isNotEmpty((Object)definition)) {
                definition.setTenantStatus("4");
                TenantCacheUtil.putTenat2Cache((HussarTenantDefinition)definition);
            }
        }
    }

    @HussarTransactional
    public void asyncAdd(T t) {
        String connName = t.getConnName();
        String currentServiceName = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name");
        try {
            this.createDb(t);
            LOGGER.info("\u521b\u5efa\u6570\u636e\u6e90{}\u5b8c\u6210", (Object)connName);
        }
        catch (Exception e) {
            this.dynamicDatasourceService.removeDynamicDatasource(connName);
            this.dealFail(t.getTenantCode());
            LOGGER.info("\u521b\u5efa\u6570\u636e\u5b58\u50a8{}\u5931\u8d25", (Object)connName);
            throw e;
        }
        SysTenantLog beforeAddTenantLog = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, Integer.valueOf(StepConstants.BEFORE_ADD_TENANT));
        if (HussarUtils.isEmpty((Object)beforeAddTenantLog)) {
            beforeAddTenantLog = TenantLogUtil.newBeforeAddTenantLog(t);
        }
        try {
            this.beforeAddTenant(t);
            beforeAddTenantLog.setId(Long.valueOf(IdWorker.getId((Object)beforeAddTenantLog)));
            this.getRedisTemplate().convertAndSend("topic_tenantlog_update", (Object)beforeAddTenantLog);
        }
        catch (Exception e) {
            beforeAddTenantLog.setExecStatus(Integer.valueOf(0));
            beforeAddTenantLog.setErrorTimes(Integer.valueOf(beforeAddTenantLog.getErrorTimes() + 1));
            beforeAddTenantLog.setExecError(e.getMessage());
            this.getRedisTemplate().convertAndSend("topic_tenantlog_update", (Object)beforeAddTenantLog);
            LOGGER.error("\u6dfb\u52a0\u79df\u6237\u4e4b\u524d\u7684\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
        }
        SysTenantLog initTenantPermissionLog = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, Integer.valueOf(StepConstants.INIT_TENANT_PERMISSION));
        if (HussarUtils.isEmpty((Object)initTenantPermissionLog)) {
            initTenantPermissionLog = TenantLogUtil.newInitTenantPermissionLog(t);
            initTenantPermissionLog.setId(Long.valueOf(IdWorker.getId((Object)initTenantPermissionLog)));
        }
        try {
            this.initTenantPermissionData(connName);
            this.getRedisTemplate().convertAndSend("topic_tenantlog_update", (Object)initTenantPermissionLog);
        }
        catch (Exception e) {
            initTenantPermissionLog.setExecStatus(Integer.valueOf(0));
            initTenantPermissionLog.setErrorTimes(Integer.valueOf(initTenantPermissionLog.getErrorTimes() + 1));
            initTenantPermissionLog.setExecError(e.getMessage());
            this.getRedisTemplate().convertAndSend("topic_tenantlog_update", (Object)initTenantPermissionLog);
            LOGGER.error("\u521d\u59cb\u5316\u79df\u6237\u6743\u9650\u5931\u8d25", (Throwable)e);
        }
        SysTenantLog initTenantAdminLog = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, Integer.valueOf(StepConstants.INIT_TENANT_ADMIN));
        if (HussarUtils.isEmpty((Object)initTenantAdminLog)) {
            initTenantAdminLog = TenantLogUtil.initTenantAdminLog(t);
            initTenantAdminLog.setId(Long.valueOf(IdWorker.getId((Object)initTenantAdminLog)));
        }
        try {
            this.initTenantAdmin(connName, t);
            LOGGER.info("\u8bbe\u7f6e\u79df\u6237\u7ba1\u7406\u5458\u5b8c\u6210");
            this.getRedisTemplate().convertAndSend("topic_tenantlog_update", (Object)initTenantAdminLog);
        }
        catch (Exception e) {
            initTenantAdminLog.setExecStatus(Integer.valueOf(0));
            initTenantAdminLog.setErrorTimes(Integer.valueOf(initTenantAdminLog.getErrorTimes() + 1));
            initTenantAdminLog.setExecError(e.getMessage());
            this.getRedisTemplate().convertAndSend("topic_tenantlog_update", (Object)initTenantAdminLog);
            LOGGER.error("\u521d\u59cb\u5316\u79df\u6237\u7ba1\u7406\u5458\u5931\u8d25", (Throwable)e);
        }
        SysTenantLog initTenantAdminRoleLog = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, Integer.valueOf(StepConstants.INIT_TENANT_ROLE));
        if (HussarUtils.isEmpty((Object)initTenantAdminRoleLog)) {
            initTenantAdminRoleLog = TenantLogUtil.newInitTenantAdminRoleLog(t);
            initTenantAdminRoleLog.setId(Long.valueOf(IdWorker.getId((Object)initTenantAdminRoleLog)));
        }
        try {
            this.initTenantAdminRole(connName, t.getTenantAdminId());
            LOGGER.info("\u8bbe\u7f6e\u79df\u6237\u7ba1\u7406\u5458\u89d2\u8272\u5b8c\u6210");
            this.getRedisTemplate().convertAndSend("topic_tenantlog_update", (Object)initTenantAdminRoleLog);
        }
        catch (Exception e) {
            initTenantAdminRoleLog.setExecStatus(Integer.valueOf(0));
            initTenantAdminRoleLog.setErrorTimes(Integer.valueOf(initTenantAdminRoleLog.getErrorTimes() + 1));
            initTenantAdminRoleLog.setExecError(e.getMessage());
            this.getRedisTemplate().convertAndSend("topic_tenantlog_update", (Object)initTenantAdminRoleLog);
            LOGGER.error("\u521d\u59cb\u5316\u79df\u6237\u7ba1\u7406\u5458\u89d2\u8272\u5931\u8d25", (Throwable)e);
        }
        SysTenantLog initClientInfoLog = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, Integer.valueOf(StepConstants.INIT_CLIENT_INFO));
        if (HussarUtils.isEmpty((Object)initClientInfoLog)) {
            initClientInfoLog = TenantLogUtil.newInitClientInfoLog(t);
            initClientInfoLog.setId(Long.valueOf(IdWorker.getId((Object)initClientInfoLog)));
        }
        try {
            this.initClientInfo(connName, (HussarTenantDefinition)t);
            LOGGER.info("\u521d\u59cb\u5316\u79df\u6237\u5ba2\u6237\u7aef\u8ba4\u8bc1\u4fe1\u606f\u5b8c\u6210");
            this.getRedisTemplate().convertAndSend("topic_tenantlog_update", (Object)initClientInfoLog);
        }
        catch (Exception e) {
            initClientInfoLog.setExecStatus(Integer.valueOf(0));
            initClientInfoLog.setErrorTimes(Integer.valueOf(initClientInfoLog.getErrorTimes() + 1));
            initClientInfoLog.setExecError(e.getMessage());
            this.getRedisTemplate().convertAndSend("topic_tenantlog_update", (Object)initClientInfoLog);
            LOGGER.error("\u521d\u59cb\u5316\u79df\u6237\u5ba2\u6237\u7aef\u8ba4\u8bc1\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        this.initJobInfo(connName, t.getTenantId(), t.getTenantCode());
        LOGGER.info("\u521d\u59cb\u5316\u79df\u6237\u5b9a\u65f6\u4efb\u52a1\u4fe1\u606f\u5b8c\u6210");
        SysTenantLog saveTenantLog = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, Integer.valueOf(StepConstants.SAVE_TENANT));
        if (HussarUtils.isEmpty((Object)saveTenantLog)) {
            saveTenantLog = TenantLogUtil.newSaveTenantLog(t);
            saveTenantLog.setId(Long.valueOf(IdWorker.getId((Object)saveTenantLog)));
        }
        try {
            this.saveTenant(t);
            LOGGER.info("\u4fdd\u5b58\u79df\u6237\u57fa\u7840\u4fe1\u606f\u5b8c\u6210");
            this.getRedisTemplate().convertAndSend("topic_tenantlog_update", (Object)saveTenantLog);
        }
        catch (Exception e) {
            saveTenantLog.setExecStatus(Integer.valueOf(0));
            saveTenantLog.setErrorTimes(Integer.valueOf(saveTenantLog.getErrorTimes() + 1));
            saveTenantLog.setExecError(e.getMessage());
            this.getRedisTemplate().convertAndSend("topic_tenantlog_update", (Object)saveTenantLog);
            LOGGER.error("\u4fdd\u5b58\u79df\u6237\u57fa\u7840\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        SysTenantLog afterAddTenantLog = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, Integer.valueOf(StepConstants.AFTER_ADD_TENANT));
        if (HussarUtils.isEmpty((Object)afterAddTenantLog)) {
            afterAddTenantLog = TenantLogUtil.newAfterAddTenantLog(t);
            afterAddTenantLog.setId(Long.valueOf(IdWorker.getId((Object)afterAddTenantLog)));
        }
        try {
            this.afterAddTenant(t);
            this.getRedisTemplate().convertAndSend("topic_tenantlog_update", (Object)afterAddTenantLog);
        }
        catch (Exception e) {
            afterAddTenantLog.setExecStatus(Integer.valueOf(0));
            afterAddTenantLog.setErrorTimes(Integer.valueOf(saveTenantLog.getErrorTimes() + 1));
            afterAddTenantLog.setExecError(e.getMessage());
            this.getRedisTemplate().convertAndSend("topic_tenantlog_update", (Object)afterAddTenantLog);
            LOGGER.error("\u6dfb\u52a0\u79df\u6237\u4e4b\u540e\u7684\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
        }
        this.tenantService.updateTenantStatus(t.getTenantCode());
    }

    public void initTenantPermissionData(String connName) {
        List functionsList;
        List resourcesList = this.resourcesService.list(connName);
        if (HussarUtils.isNotEmpty((Object)resourcesList)) {
            this.buildRelationOfResource(connName, resourcesList);
        }
        if (HussarUtils.isNotEmpty((Object)(functionsList = this.functionsService.list(connName)))) {
            this.buildRelationOfFunction(connName, functionsList);
        }
        LOGGER.info("\u521d\u59cb\u5316\u79df\u6237\u6743\u9650\u5b8c\u6210");
    }

    private void buildRelationOfResource(String connName, Collection<SysResources> resourcesList) {
        ArrayList<SysRoleResource> roleResourceList = new ArrayList<SysRoleResource>();
        if (HussarUtils.isNotEmpty(resourcesList)) {
            for (SysResources resources : resourcesList) {
                SysRoleResource roleResource = new SysRoleResource();
                roleResource.setResourceId(resources.getId());
                roleResource.setId(TenantConstant.ADMIN_ROLE);
                roleResource.setRelationSource("2");
                roleResourceList.add(roleResource);
            }
            this.roleResourceService.saveBatch(connName, roleResourceList);
        }
    }

    private void buildRelationOfFunction(String connName, Collection<SysFunctions> functionsList) {
        ArrayList<SysRoleFunctions> roleFunctionsList = new ArrayList<SysRoleFunctions>();
        if (HussarUtils.isNotEmpty(functionsList)) {
            for (SysFunctions function : functionsList) {
                SysRoleFunctions roleFunctions = new SysRoleFunctions();
                roleFunctions.setFunctionId(function.getId());
                roleFunctions.setRoleId(TenantConstant.ADMIN_ROLE);
                roleFunctionsList.add(roleFunctions);
            }
            this.roleFunctionsService.saveBatch(connName, roleFunctionsList);
        }
    }

    public void checkData(T t) {
        String connName;
        T definition = t;
        String tenantCode = definition.getTenantCode();
        long tenantId = IdWorker.getId(t);
        String validateMsg = this.validateService.validate(definition);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        Long count = this.tenantService.count((Wrapper)new LambdaQueryWrapper().eq(SysTenant::getTenantCode, (Object)tenantCode));
        AssertUtil.isFalse((count != null && count > 0L ? 1 : 0) != 0, (String)"\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u79df\u6237\u7f16\u7801\u5df2\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01\uff09");
        String domain = definition.getTenantDomain();
        if (StringUtils.isNotBlank((CharSequence)domain)) {
            AssertUtil.isTrue((boolean)domain.matches("^((?!-)[A-Za-z0-9-]{1,63}(?<!-)\\.)+[A-Za-z]{2,6}"), (String)"\u975e\u6cd5\u57df\u540d\uff01");
            Long countDomain = this.tenantService.count((Wrapper)new LambdaQueryWrapper().eq(SysTenant::getTenantDomain, (Object)domain));
            AssertUtil.isFalse((countDomain != null && countDomain > 0L ? 1 : 0) != 0, (String)"\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u79df\u6237\u7ed1\u5b9a\u57df\u540d\u5df2\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01\uff09\uff01");
        }
        AssertUtil.isTrue((HussarUtils.isNotBlank((CharSequence)(connName = definition.getConnName())) && !connName.equalsIgnoreCase("master") ? 1 : 0) != 0, (String)"\u975e\u6cd5\u6570\u636e\u6e90\u540d\u79f0\uff01");
        AssertUtil.isFalse((boolean)this.dynamicDatasourceService.getAllDatasourcesName().contains(connName), (String)"\u6570\u636e\u6e90\u540d\u79f0\u91cd\u590d\uff01");
        List storagePropertiesList = definition.getStoragePropertiesList();
        AssertUtil.isTrue((boolean)HussarUtils.isNotEmpty((Object)storagePropertiesList), (String)"\u79df\u6237\u6570\u636e\u5b58\u50a8\u4fe1\u606f\u4e3a\u7a7a\uff01");
        for (Map mapDb : storagePropertiesList) {
            this.checkDb(mapDb);
        }
        t.setTenantId(Long.valueOf(tenantId));
        this.tenantRecordService.remove((Wrapper)new LambdaQueryWrapper().eq(SysTenantRecord::getTenantCode, (Object)tenantCode));
        SysTenantRecord record = new SysTenantRecord();
        record.setTenantId(Long.valueOf(tenantId));
        record.setConnName(definition.getConnName());
        record.setTenantCode(tenantCode);
        record.setConnName(connName);
        record.setTenantClass(t.getClass().getName());
        record.setTenantParams(JSON.toJSONString(t));
        this.tenantRecordService.save((Object)record);
    }

    private void checkDb(Map<String, Object> storageProperties) {
        String storageType = (String)storageProperties.get("storageType");
        if (!storageType.equals("rdb")) {
            return;
        }
        String json = JSON.toJSONString(storageProperties);
        RDBStorageDefinition definition = (RDBStorageDefinition)JSON.parseObject((String)json, RDBStorageDefinition.class);
        String creation = definition.getCreation();
        if (creation.equals("2")) {
            String jdbcUrl = definition.getJdbcUrl();
            String userName = definition.getUserName();
            String password = definition.getPassword();
            AssertUtil.isTrue((boolean)this.hussarBaseSQLExecutor.checkDbConnection(jdbcUrl, userName, password), (String)"\u79df\u6237\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff01");
        }
    }

    private void createDb(T t) {
        T definition = t;
        List storagePropertiesList = definition.getStoragePropertiesList();
        boolean isMicroservice = this.isMicroservice(storagePropertiesList);
        String currentServiceName = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name");
        if (HussarUtils.isNotEmpty((Object)storagePropertiesList)) {
            if (isMicroservice) {
                LOGGER.info("\u5f00\u59cb\u521b\u5efa\u5fae\u670d\u52a1\u6570\u636e\u5b58\u50a8");
                ArrayList<Map> storagePropertiesListOther = new ArrayList<Map>();
                Map<String, Object> masterstorageProperties = new HashMap<String, Object>();
                for (Map storageProperties : storagePropertiesList) {
                    String serviceName = (String)storageProperties.get("serviceName");
                    storageProperties.put("tenantCode", definition.getTenantCode());
                    storageProperties.put("connName", definition.getConnName());
                    if (Objects.equals(serviceName, currentServiceName)) {
                        masterstorageProperties = storageProperties;
                        continue;
                    }
                    storagePropertiesListOther.add(storageProperties);
                }
                if (HussarUtils.isNotEmpty(storagePropertiesListOther) && this.getRedisTemplate() != null) {
                    this.getRedisTemplate().convertAndSend("topic_storage_create", storagePropertiesListOther);
                }
                SysTenantLog createDb = this.getSysTenantCreateDbLog(t, currentServiceName, masterstorageProperties);
                try {
                    String storageType = (String)masterstorageProperties.get("storageType");
                    StorageFactory.get((String)storageType).createDatabaseAndInitData(masterstorageProperties);
                    this.getRedisTemplate().convertAndSend("topic_tenantlog_update", (Object)createDb);
                }
                catch (Exception e) {
                    createDb.setExecStatus(Integer.valueOf(0));
                    createDb.setErrorTimes(Integer.valueOf(createDb.getErrorTimes() + 1));
                    createDb.setExecError(e.getMessage());
                    this.getRedisTemplate().convertAndSend("topic_tenantlog_update", (Object)createDb);
                    throw new BaseException("\u521b\u5efa\u5fae\u670d\u52a1\u6570\u636e\u5b58\u50a8\u51fa\u9519\uff01", (Throwable)e);
                }
            }
            LOGGER.info("\u5f00\u59cb\u521b\u5efa\u6570\u636e\u5b58\u50a8");
            Map storageProperties = (Map)storagePropertiesList.get(0);
            String storageType = (String)storageProperties.get("storageType");
            storageProperties.put("tenantCode", definition.getTenantCode());
            storageProperties.put("connName", definition.getConnName());
            SysTenantLog createDb = this.getSysTenantCreateDbLog(t, currentServiceName, storageProperties);
            try {
                StorageFactory.get((String)storageType).createDatabaseAndInitData(storageProperties);
                this.getRedisTemplate().convertAndSend("topic_tenantlog_update", (Object)createDb);
            }
            catch (Exception e) {
                createDb.setExecStatus(Integer.valueOf(0));
                createDb.setErrorTimes(Integer.valueOf(createDb.getErrorTimes() + 1));
                createDb.setExecError(e.getMessage());
                this.getRedisTemplate().convertAndSend("topic_tenantlog_update", (Object)createDb);
                throw new BaseException("\u521b\u5efa\u6570\u636e\u5b58\u50a8\u51fa\u9519\uff01", (Throwable)e);
            }
        }
    }

    @NotNull
    private SysTenantLog getSysTenantCreateDbLog(T t, String currentServiceName, Map<String, Object> masterstorageProperties) {
        SysTenantLog createDb = this.sysTenantLogService.getByTenantCodeAndStepNo(t.getTenantCode(), currentServiceName, Integer.valueOf(StepConstants.CREATE_DB));
        if (HussarUtils.isEmpty((Object)createDb)) {
            createDb = TenantLogUtil.newCreateDbLog(t.getClass(), (String)t.getTenantCode(), (String)t.getConnName(), (String)currentServiceName, masterstorageProperties);
        }
        return createDb;
    }

    private boolean isMicroservice(List<Map<String, Object>> storagePropertiesList) {
        String serviceName;
        return HussarUtils.isNotEmpty(storagePropertiesList) && HussarUtils.isNotBlank((CharSequence)(serviceName = (String)storagePropertiesList.get(0).get("serviceName")));
    }

    public abstract void saveTenant(T var1);

    private void initTenantAdminRole(String connName, Long userId) {
        SysRoles adminRole = new SysRoles();
        adminRole.setId(TenantConstant.ADMIN_ROLE);
        adminRole.setRolePermission("ADMIN_ROLE");
        adminRole.setRoleName("\u7ba1\u7406\u5458\u89d2\u8272");
        adminRole.setRoleAlias("\u7ba1\u7406\u5458\u89d2\u8272");
        adminRole.setIsSys("0");
        adminRole.setGroupId(Long.valueOf(1450785135866925059L));
        adminRole.setRoleOrder(Integer.valueOf(10));
        this.sysRolesService.save(connName, (Object)adminRole);
        this.sysUserRoleService.saveUserRole(connName, userId);
    }

    public void initClientInfo(String connName, HussarTenantDefinition definition) {
        SysAuthClientModel authClientModel = new SysAuthClientModel();
        long id = IdWorker.getId((Object)authClientModel);
        authClientModel.setId(Long.valueOf(id));
        authClientModel.setClientId(String.valueOf(definition.getTenantId()));
        authClientModel.setClientSecret(UUID.randomUUID().toString().replace("-", ""));
        authClientModel.setAuthorizedGrantType("client_credentials");
        authClientModel.setContractScope("server");
        authClientModel.setAllowUrl("*");
        authClientModel.setAccessTokenValidTime(1800L);
        authClientModel.setRefreshTokenValidTime(86400L);
        definition.setClientId(authClientModel.getClientId());
        definition.setClientSecret(authClientModel.getClientSecret());
        try {
            this.sysAuthClientModelService.saveAuthClientModel(connName, authClientModel);
            SysTenantSecure sysTenantSecure = new SysTenantSecure();
            sysTenantSecure.setTenantId(definition.getTenantId());
            sysTenantSecure.setTenantCode(definition.getTenantCode());
            sysTenantSecure.setClientId(authClientModel.getClientId());
            sysTenantSecure.setClientSecret(authClientModel.getClientSecret());
            this.tenantSecureService.save((Object)sysTenantSecure);
            SysTenant tenant = TenantUtil.convert2SysTenant(definition);
            this.tenantService.updateById((Object)tenant);
            TenantCacheUtil.putTenat2Cache((HussarTenantDefinition)definition);
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u5ba2\u6237\u7aef\u4fe1\u606f\u51fa\u9519", (Throwable)e);
            throw new BaseException((Throwable)e);
        }
    }

    public void initJobInfo(String connName, Long tenantId, String tenantCode) {
        SysTenantLog initJobInfoLog = null;
        List<SysTenantJobInfo> tenantJobInfoList = this.getDefaultInitJob(connName, tenantId, tenantCode);
        if (HussarUtils.isNotEmpty(tenantJobInfoList)) {
            try {
                initJobInfoLog = TenantLogUtil.newInitJobInfoLog((String)tenantCode, (String)connName, tenantJobInfoList);
                initJobInfoLog.setId(Long.valueOf(IdWorker.getId((Object)initJobInfoLog)));
                this.sysTenantJobInfoService.saveBatch(tenantJobInfoList);
                this.sysTenantLogService.save((Object)initJobInfoLog);
            }
            catch (Exception e) {
                initJobInfoLog.setExecStatus(Integer.valueOf(0));
                initJobInfoLog.setErrorTimes(Integer.valueOf(1));
                initJobInfoLog.setExecError(e.getMessage());
                this.sysTenantLogService.save((Object)initJobInfoLog);
                this.getRedisTemplate().convertAndSend("topic_tenantlog_update", (Object)initJobInfoLog);
                LOGGER.error("\u521d\u59cb\u5316\u79df\u6237\u5b9a\u65f6\u4efb\u52a1\u51fa\u9519\uff01", (Throwable)e);
            }
        }
    }

    public TenantPermissionData subtract(TenantPermissionData a, TenantPermissionData b) {
        TenantPermissionData ret = new TenantPermissionData();
        Collection afunctionModules = a.getFunctionModules();
        Collection afunctions = a.getFunctions();
        Collection aresourceModules = a.getResourceModules();
        Collection aresources = a.getResources();
        Collection amenus = a.getMenus();
        Collection afunctionResources = a.getFunctionResources();
        Collection bfunctionModules = b.getFunctionModules();
        Set bfunctionModuleIds = EntityUtils.toSet((Collection)bfunctionModules, SysFunctionModules::getId);
        Collection bfunctions = b.getFunctions();
        Set bfunctionIds = EntityUtils.toSet((Collection)bfunctions, SysFunctions::getId);
        Collection bresourceModules = b.getResourceModules();
        Set bresourceModuleIds = EntityUtils.toSet((Collection)bresourceModules, SysResourceModules::getId);
        Collection bresources = b.getResources();
        Set bresourceIds = EntityUtils.toSet((Collection)bresources, SysResources::getId);
        Collection bmenus = b.getMenus();
        Set bmenuIds = EntityUtils.toSet((Collection)bmenus, SysMenu::getId);
        Collection bfunctionResources = b.getFunctionResources();
        Set functionModules = afunctionModules.stream().filter(e -> !bfunctionModuleIds.contains(e.getId())).collect(Collectors.toSet());
        Set functions = afunctions.stream().filter(e -> !bfunctionIds.contains(e.getId())).collect(Collectors.toSet());
        Set resourceModules = aresourceModules.stream().filter(e -> !bresourceModuleIds.contains(e.getId())).collect(Collectors.toSet());
        Set resources = aresources.stream().filter(e -> !bresourceIds.contains(e.getId())).collect(Collectors.toSet());
        Set menus = amenus.stream().filter(e -> !bmenuIds.contains(e.getId())).collect(Collectors.toSet());
        HashSet<SysFunctionResources> functionResources = new HashSet<SysFunctionResources>();
        for (SysFunctionResources asysFunctionResources : afunctionResources) {
            for (SysFunctionResources bsysFunctionResources : bfunctionResources) {
                if (asysFunctionResources.getResourceId().equals(bsysFunctionResources.getResourceId()) && asysFunctionResources.getFunctionId().equals(bsysFunctionResources.getFunctionId())) continue;
                functionResources.add(asysFunctionResources);
            }
        }
        ret.setFunctions(functions);
        ret.setFunctionModules(functionModules);
        ret.setResources(resources);
        ret.setResourceModules(resourceModules);
        ret.setMenus(menus);
        ret.setFunctionResources(functionResources);
        return ret;
    }

    public void editTenant(T t) {
        SysTenant tenant = TenantUtil.convert2SysTenant(t);
        TenantCacheUtil.putTenat2Cache(t);
        this.tenantService.updateById((Object)tenant);
    }

    private List<SysTenantJobInfo> getDefaultInitJob(String connName, Long tenantId, String tenantCode) {
        String readJson = null;
        try {
            Resource resource = SpringContextHolder.getApplicationContext().getResource("classpath:tenantsql/initjob/tenantJob.json");
            readJson = IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
            if (HussarUtils.isNotBlank((CharSequence)readJson)) {
                List tenantJobInfoList = JSON.parseArray((String)readJson, SysTenantJobInfo.class);
                if (HussarUtils.isNotEmpty((Object)tenantJobInfoList)) {
                    for (SysTenantJobInfo sysTenantJobInfo : tenantJobInfoList) {
                        sysTenantJobInfo.setId(Long.valueOf(IdWorker.getId((Object)sysTenantJobInfo)));
                        sysTenantJobInfo.setTenantId(tenantId);
                        sysTenantJobInfo.setTenantCode(tenantCode);
                        sysTenantJobInfo.setDbName(connName);
                        this.calculateNextTriggerTime(sysTenantJobInfo);
                        sysTenantJobInfo.setDelFlag("0");
                    }
                }
                return tenantJobInfoList;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    public void calculateNextTriggerTime(SysTenantJobInfo tenantJobInfo) {
        try {
            Date now = new Date();
            TimeExpressionType timeExpressionType = TimeExpressionType.of((int)tenantJobInfo.getTimeExpressionType());
            if (timeExpressionType == TimeExpressionType.CRON) {
                CronExpression cronExpression = new CronExpression(tenantJobInfo.getTimeExpression());
                Date nextValidTime = cronExpression.getNextValidTimeAfter(now);
                if (nextValidTime == null) {
                    throw new JobRuntimeException("cron expression is out of date: " + tenantJobInfo.getTimeExpression());
                }
                tenantJobInfo.setNextTriggerTime(DateTimeUtil.toDateTime((Instant)nextValidTime.toInstant()));
            } else if (timeExpressionType == TimeExpressionType.API || timeExpressionType == TimeExpressionType.WORKFLOW) {
                tenantJobInfo.setTimeExpression((String)null);
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

