/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.listener;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.constant.StepConstants;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.model.SysTenantLog;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantLogService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.RedisTemplate;

public class TenantlogUpdateListener
implements MessageListener {
    private ISysTenantLogService getSysTenantLogService() {
        return (ISysTenantLogService)SpringContextHolder.getBean(ISysTenantLogService.class);
    }

    private ISysTenantService getSysTenantService() {
        return (ISysTenantService)SpringContextHolder.getBean(ISysTenantService.class);
    }

    public void onMessage(Message message, byte[] bytes) {
        byte[] messageBody = message.getBody();
        SysTenantLog tenantLog = (SysTenantLog)((RedisTemplate)SpringContextHolder.getBean((String)"redisTemplate")).getValueSerializer().deserialize(messageBody);
        this.getSysTenantLogService().saveOrUpdate((Object)tenantLog);
        String tenantCode = tenantLog.getTenantCode();
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantLog::getTenantCode, (Object)tenantCode);
        wrapper.eq(SysTenantLog::getExecStatus, (Object)0);
        Long count = this.getSysTenantLogService().count((Wrapper)wrapper);
        LambdaQueryWrapper tenantWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenant::getTenantCode, (Object)tenantCode);
        SysTenant one = (SysTenant)this.getSysTenantService().getOne((Wrapper)tenantWrapper);
        if (count != null && count > 0L) {
            one.setTenantStatus("4");
        } else {
            LambdaQueryWrapper wrapper2 = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantLog::getTenantCode, (Object)tenantCode)).eq(SysTenantLog::getStepNo, (Object)StepConstants.AFTER_ADD_TENANT);
            SysTenantLog one1 = (SysTenantLog)this.getSysTenantLogService().getOne((Wrapper)wrapper2);
            if (HussarUtils.isNotEmpty((Object)one1)) {
                one.setTenantStatus("1");
            }
        }
        HussarTenantDefinition definition = TenantCacheUtil.loadFromCacheByTenantCode((String)tenantCode);
        definition.setTenantStatus(one.getTenantStatus());
        this.getSysTenantService().updateById((Object)one);
        TenantCacheUtil.putTenat2Cache((HussarTenantDefinition)definition);
    }
}

