/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.config;

import com.jxdinfo.hussar.core.HussarCoreAutoConfiguration;
import com.jxdinfo.hussar.tenant.common.listener.FunctionChangeListener;
import com.jxdinfo.hussar.tenant.common.listener.ResourceChangeListener;
import com.jxdinfo.hussar.tenant.common.listener.TenantlogUpdateListener;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;

@ConditionalOnProperty(prefix="hussar.core.tenant", name={"enabled"}, havingValue="true", matchIfMissing=false)
@Configuration
@ImportAutoConfiguration(value={HussarCoreAutoConfiguration.class})
@ComponentScan(basePackages={"com.jxdinfo.hussar.tenant.common"})
@MapperScan(basePackages={"com.jxdinfo.hussar.tenant.common.dao"})
public class HussarTenantRequestConfig {
    @Bean(value={"com.jxdinfo.hussar.tenant.common.listener.tenantlogUpdateListener"})
    public TenantlogUpdateListener tenantlogUpdateListener() {
        return new TenantlogUpdateListener();
    }

    @Bean(value={"com.jxdinfo.hussar.tenant.common.listener.functionChangeListener"})
    public FunctionChangeListener functionChangeListener() {
        return new FunctionChangeListener();
    }

    @Bean(value={"com.jxdinfo.hussar.tenant.common.listener.resourceChangeListener"})
    public ResourceChangeListener resourceChangeListener() {
        return new ResourceChangeListener();
    }

    @Bean
    public RedisMessageListenerContainer container(RedisConnectionFactory redisConnectionFactory) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(redisConnectionFactory);
        container.addMessageListener((MessageListener)new FunctionChangeListener(), (Topic)new ChannelTopic("topic_function_edit"));
        container.addMessageListener((MessageListener)new ResourceChangeListener(), (Topic)new ChannelTopic("topic_resource_edit"));
        container.addMessageListener((MessageListener)new TenantlogUpdateListener(), (Topic)new ChannelTopic("topic_tenantlog_update"));
        return container;
    }
}

