/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.tenant.common.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.EntityUtils;
import com.jxdinfo.hussar.common.utils.ExceptionUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.datasource.factory.DatabaseFactory;
import com.jxdinfo.hussar.datasource.service.IHussarBaseSQLExecutor;
import com.jxdinfo.hussar.datasource.util.DbUtil;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.tenant.common.dao.SysTenantUpgradeMapper;
import com.jxdinfo.hussar.tenant.common.dto.QueryUpgradeDto;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.model.SysTenantDatasource;
import com.jxdinfo.hussar.tenant.common.model.SysTenantRecord;
import com.jxdinfo.hussar.tenant.common.model.SysTenantUpgrade;
import com.jxdinfo.hussar.tenant.common.model.TenantUpgradeMicroServiceInfo;
import com.jxdinfo.hussar.tenant.common.model.UpgradeMicroServiceModel;
import com.jxdinfo.hussar.tenant.common.service.IOutSideExecutUpgradeService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantDataSourceService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantRecordService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantUpgradeService;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@HussarDs(value="master")
@Service(value="com.jxdinfo.hussar.tenant.service.impl.sysTenantUpgradeServiceImpl")
public class SysTenantUpgradeServiceImpl
extends HussarBaseServiceImpl<SysTenantUpgradeMapper, SysTenantUpgrade>
implements ISysTenantUpgradeService {
    private Logger LOGGER = LoggerFactory.getLogger(SysTenantUpgradeServiceImpl.class);
    @Autowired
    private ISysTenantService sysTenantService;
    @Autowired
    private ISysTenantDataSourceService sysTenantDataSourceService;
    @Autowired
    private IHussarBaseSQLExecutor hussarBaseSQLExecutor;
    @Autowired
    private ISysTenantRecordService sysTenantRecordService;
    private static ExecutorService hussarBaseTenantExecutor = (ExecutorService)SpringContextHolder.getBean(ExecutorService.class);

    public Page<SysTenantUpgrade> search(QueryUpgradeDto queryUpgradeDto) {
        Page page = new Page();
        long size = queryUpgradeDto.getSize();
        long current = queryUpgradeDto.getCurrent();
        String tenantCode = queryUpgradeDto.getTenantCode();
        String serviceName = queryUpgradeDto.getServiceName();
        String updateStatus = queryUpgradeDto.getUpdateStatus();
        page.setSize(size);
        page.setCurrent(current);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)tenantCode)) {
            wrapper.like(SysTenantUpgrade::getTenantCode, (Object)StringUtils.trim((String)tenantCode));
        }
        if (StringUtils.isNotBlank((CharSequence)serviceName)) {
            wrapper.eq(SysTenantUpgrade::getServiceName, (Object)StringUtils.trim((String)serviceName));
        }
        if (StringUtils.isNotBlank((CharSequence)updateStatus)) {
            wrapper.eq(SysTenantUpgrade::getUpdateStatus, (Object)StringUtils.trim((String)updateStatus));
        }
        wrapper.orderByAsc(HussarBaseEntity::getCreateTime);
        Page result = (Page)this.page((IPage)page, (Wrapper)wrapper);
        List records = result.getRecords();
        if (HussarUtils.isNotEmpty((Object)records)) {
            for (SysTenantUpgrade upgrade : records) {
                upgrade.setTenantName(TenantCacheUtil.loadFromCacheByTenantId((Long)upgrade.getTenantId()).getTenantName());
            }
        }
        return result;
    }

    public void updateSingle() {
        this.checkHasTenant();
        this.checkSingle();
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().ne(SysTenant::getTenantStatus, (Object)"0");
        wrapper.orderByAsc(HussarBaseEntity::getCreateTime);
        List list = this.sysTenantService.list((Wrapper)wrapper);
        if (HussarUtils.isNotEmpty((Object)list)) {
            hussarBaseTenantExecutor.execute(() -> this.asyncUpdateSingle(list));
        }
    }

    private void checkSingle() {
        List list = this.list();
        if (HussarUtils.isNotEmpty((Object)list)) {
            Optional<SysTenantUpgrade> any = list.parallelStream().filter(item -> item.getUpdateStatus().equals("0")).findAny();
            if (any.isPresent()) {
                throw new BaseException("\u8bf7\u9996\u5148\u5904\u7406\u5b8c\u4e0a\u6b21\u5347\u7ea7\u5931\u8d25\u7684\u79df\u6237\uff01");
            }
            List ids = EntityUtils.toList((Collection)list, SysTenantUpgrade::getId);
            this.removeByIds(ids);
        }
    }

    private void checkMicroService(String serviceName) {
        LambdaQueryWrapper upgradeWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantUpgrade::getServiceName, (Object)serviceName);
        List list = this.list((Wrapper)upgradeWrapper);
        if (HussarUtils.isNotEmpty((Object)list)) {
            Optional<SysTenantUpgrade> any = list.parallelStream().filter(item -> item.getUpdateStatus().equals("0") && item.getServiceName().equalsIgnoreCase(serviceName)).findAny();
            if (any.isPresent()) {
                throw new BaseException("\u8bf7\u9996\u5148\u5904\u7406\u5b8c\u670d\u52a1" + serviceName + "\u4e0a\u6b21\u5347\u7ea7\u5931\u8d25\u7684\u79df\u6237");
            }
            List ids = EntityUtils.toList((Collection)list, SysTenantUpgrade::getId);
            this.removeByIds(ids);
        }
    }

    public void updateSingleById(Long id) {
        SysTenantUpgrade sysTenantUpgrade = (SysTenantUpgrade)this.getById(id);
        AssertUtil.isNotNull((Object)sysTenantUpgrade, (String)"\u672a\u67e5\u8be2\u5230\u79df\u6237\u5347\u7ea7\u4fe1\u606f\uff01");
        Long tenantId = sysTenantUpgrade.getTenantId();
        SysTenant tenant = (SysTenant)this.sysTenantService.getById((Serializable)tenantId);
        hussarBaseTenantExecutor.execute(() -> this.asyncUpdateSingleOne(sysTenantUpgrade, tenant));
    }

    public String viewTenantUpgrade(Long id) {
        SysTenantUpgrade upgrade = (SysTenantUpgrade)this.getById(id);
        if (HussarUtils.isNotEmpty((Object)upgrade)) {
            return upgrade.getUpdateError();
        }
        return null;
    }

    public void updateMicroServiceById(Long id) {
        SysTenantUpgrade upgrade = (SysTenantUpgrade)this.getById(id);
        AssertUtil.isNotNull((Object)upgrade, (String)"\u672a\u67e5\u8be2\u76f8\u5e94\u7684\u79df\u6237\u5347\u7ea7\u8bb0\u5f55\u4fe1\u606f\uff01");
        String serviceName = upgrade.getServiceName();
        String tenantCode = upgrade.getTenantCode();
        this.updateMicroService(serviceName, tenantCode);
    }

    private void updateMicroService(String serviceName, String tenantCode) {
        String currentServiceName = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name");
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().ne(SysTenant::getTenantStatus, (Object)"0");
        if (HussarUtils.isNotBlank((CharSequence)tenantCode)) {
            wrapper.eq(SysTenant::getTenantCode, (Object)tenantCode);
        }
        wrapper.orderByAsc(HussarBaseEntity::getCreateTime);
        List list = this.sysTenantService.list((Wrapper)wrapper);
        AssertUtil.isNotEmpty((Collection)list, (String)("\u672a\u67e5\u8be2\u5230\u79df\u6237\u7f16\u7801\u4e3a" + tenantCode + "\u7684\u79df\u6237\u4fe1\u606f\uff01"));
        if (HussarUtils.isEmpty((Object)list)) {
            return;
        }
        List<SysTenantUpgrade> upgradeList = new ArrayList();
        if (HussarUtils.isBlank((CharSequence)tenantCode)) {
            for (SysTenant sysTenant : list) {
                SysTenantUpgrade upgrade = new SysTenantUpgrade();
                upgrade.setUpdateStatus("2");
                upgrade.setConnName(sysTenant.getConnName());
                upgrade.setServiceName(serviceName);
                upgrade.setTenantCode(sysTenant.getTenantCode());
                upgrade.setTenantId(sysTenant.getId());
                upgrade.setTenantName(sysTenant.getTenantName());
                upgradeList.add(upgrade);
            }
            this.saveBatch(upgradeList);
        } else {
            LambdaQueryWrapper wrapperQuery = new LambdaQueryWrapper();
            wrapperQuery.eq(SysTenantUpgrade::getServiceName, (Object)serviceName);
            if (HussarUtils.isNotBlank((CharSequence)tenantCode)) {
                wrapperQuery.eq(SysTenantUpgrade::getTenantCode, (Object)tenantCode);
            }
            upgradeList = this.list((Wrapper)wrapperQuery);
        }
        if (Objects.equals(serviceName, currentServiceName)) {
            if (HussarUtils.isNotEmpty((Object)list)) {
                hussarBaseTenantExecutor.execute(() -> {
                    for (SysTenant tenant : list) {
                        this.asyncUpdateMicroServiceOne(currentServiceName, tenant);
                    }
                });
            }
        } else {
            UpgradeMicroServiceModel upgradeMicroServiceModel = new UpgradeMicroServiceModel();
            upgradeMicroServiceModel.setServiceName(serviceName);
            upgradeMicroServiceModel.setCaller(currentServiceName);
            ArrayList<TenantUpgradeMicroServiceInfo> detail = new ArrayList<TenantUpgradeMicroServiceInfo>();
            List tenantCodes = EntityUtils.toList((Collection)list, SysTenant::getTenantCode);
            List records = this.sysTenantRecordService.list((Wrapper)new LambdaQueryWrapper().in(SysTenantRecord::getTenantCode, (Collection)tenantCodes));
            Map recordMap = EntityUtils.toMap((Collection)records, SysTenantRecord::getTenantCode);
            for (SysTenantUpgrade upgrade : upgradeList) {
                TenantUpgradeMicroServiceInfo info = new TenantUpgradeMicroServiceInfo();
                info.setTenantCode(upgrade.getTenantCode());
                info.setConnName(upgrade.getConnName());
                JSONArray jsonArray = (JSONArray)JSON.parseObject((String)((SysTenantRecord)recordMap.get(upgrade.getTenantCode())).getTenantParams()).get((Object)"storagePropertiesList");
                for (Object object : jsonArray) {
                    String jdbcUrl = ((JSONObject)object).getString("jdbcUrl");
                    if (!HussarUtils.isNotBlank((CharSequence)jdbcUrl)) continue;
                    info.setDbType(DbUtil.getDbType((String)jdbcUrl));
                }
                detail.add(info);
            }
            if (HussarUtils.isEmpty((Object)records)) {
                return;
            }
            upgradeMicroServiceModel.setTenantUpgradeMicroServiceInfoList(detail);
            IOutSideExecutUpgradeService outSideExecutUpgradeService = (IOutSideExecutUpgradeService)SpringContextHolder.getBean(IOutSideExecutUpgradeService.class);
            outSideExecutUpgradeService.executUpgrade(upgradeMicroServiceModel, serviceName);
        }
    }

    public void updateMicroService(String serviceName) {
        this.checkMicroService(serviceName);
        this.updateMicroService(serviceName, null);
    }

    private void asyncUpdateMicroServiceOne(String serviceName, SysTenant tenant) {
        String connName = tenant.getConnName();
        SysTenantUpgrade sysTenantUpgrade = (SysTenantUpgrade)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantUpgrade::getTenantCode, (Object)tenant.getTenantCode())).eq(SysTenantUpgrade::getServiceName, (Object)serviceName));
        LambdaQueryWrapper datasourceWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasource::getConnName, (Object)connName);
        new LambdaQueryWrapper().eq(SysTenantDatasource::getConnName, (Object)connName);
        SysTenantDatasource sysTenantDatasource = (SysTenantDatasource)this.sysTenantDataSourceService.getOne((Wrapper)datasourceWrapper, false);
        if (HussarUtils.isNotEmpty((Object)sysTenantDatasource)) {
            String dbUrl = sysTenantDatasource.getJdbcUrl();
            String dbType = DbUtil.getDbType((String)dbUrl);
            try {
                String path = "tenantsql/upgrade/" + dbType;
                Object[] upgradeExecuteSQLScripts = DatabaseFactory.get((String)dbType).getUpgradeExecuteSQLScripts();
                if (HussarUtils.isNotEmpty((Object[])upgradeExecuteSQLScripts)) {
                    for (Object resource : upgradeExecuteSQLScripts) {
                        String updateScript = IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
                        boolean check = StringUtils.isNotBlank((CharSequence)updateScript);
                        if (check) continue;
                        throw new Exception("\u8bf7\u68c0\u67e5classpath:" + path + "\u8def\u5f84\u4e0b\u5347\u7ea7\u811a\u672c\u662f\u5426\u6b63\u786e");
                    }
                } else {
                    throw new Exception("\u8bf7\u68c0\u67e5classpath:" + path + "\u8def\u5f84\u4e0b\u5347\u7ea7\u811a\u672c\u662f\u5426\u6b63\u786e");
                }
                this.hussarBaseSQLExecutor.execSqlFile(connName, (Resource[])upgradeExecuteSQLScripts);
                sysTenantUpgrade.setUpdateStatus("1");
            }
            catch (Exception e) {
                sysTenantUpgrade.setUpdateStatus("0");
                sysTenantUpgrade.setUpdateError(e.getMessage());
                this.LOGGER.error("\u5347\u7ea7\u670d\u52a1\u3010" + serviceName + "\u3011- \u79df\u6237\uff1a" + tenant.getTenantCode() + "\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
                e.printStackTrace();
            }
            this.saveOrUpdate((BaseEntity)sysTenantUpgrade);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncUpdateSingleOne(SysTenantUpgrade sysTenantUpgrade, SysTenant tenant) {
        block8: {
            String connName = tenant.getConnName();
            sysTenantUpgrade.setTenantCode(tenant.getTenantCode());
            sysTenantUpgrade.setTenantId(tenant.getId());
            sysTenantUpgrade.setConnName(connName);
            sysTenantUpgrade.setServiceName("");
            LambdaQueryWrapper datasourceWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantDatasource::getConnName, (Object)connName);
            new LambdaQueryWrapper().eq(SysTenantDatasource::getConnName, (Object)connName);
            SysTenantDatasource sysTenantDatasource = (SysTenantDatasource)this.sysTenantDataSourceService.getOne((Wrapper)datasourceWrapper, false);
            if (HussarUtils.isNotEmpty((Object)sysTenantDatasource)) {
                String dbUrl = sysTenantDatasource.getJdbcUrl();
                String dbType = DbUtil.getDbType((String)dbUrl);
                try {
                    String path = "tenantsql/upgrade/" + dbType;
                    Object[] upgradeExecuteSQLScripts = DatabaseFactory.get((String)dbType).getUpgradeExecuteSQLScripts();
                    if (HussarUtils.isNotEmpty((Object[])upgradeExecuteSQLScripts)) {
                        for (Object resource : upgradeExecuteSQLScripts) {
                            String updateScript = IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
                            boolean check = StringUtils.isNotBlank((CharSequence)updateScript);
                            if (check) continue;
                            throw new Exception("\u8bf7\u68c0\u67e5classpath:" + path + "\u8def\u5f84\u4e0b\u5347\u7ea7\u811a\u672c\u662f\u5426\u6b63\u786e");
                        }
                        this.hussarBaseSQLExecutor.execSqlFile(connName, (Resource[])upgradeExecuteSQLScripts);
                        sysTenantUpgrade.setUpdateStatus("1");
                        break block8;
                    }
                    throw new Exception("\u8bf7\u68c0\u67e5classpath:" + path + "\u8def\u5f84\u4e0b\u5347\u7ea7\u811a\u672c\u662f\u5426\u6b63\u786e");
                }
                catch (Exception e) {
                    sysTenantUpgrade.setUpdateStatus("0");
                    sysTenantUpgrade.setUpdateError(ExceptionUtil.getExceptionAllinformation((Throwable)e));
                    this.LOGGER.error("\u5347\u7ea7" + tenant.getTenantCode() + "\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
                    e.printStackTrace();
                }
                finally {
                    this.saveOrUpdate((BaseEntity)sysTenantUpgrade);
                }
            }
        }
    }

    private void asyncUpdateSingle(List<SysTenant> list) {
        for (SysTenant tenant : list) {
            SysTenantUpgrade sysTenantUpgrade = new SysTenantUpgrade();
            this.asyncUpdateSingleOne(sysTenantUpgrade, tenant);
        }
    }

    private void checkHasTenant() {
        List list = this.sysTenantService.list((Wrapper)new LambdaQueryWrapper().ne(SysTenant::getTenantStatus, (Object)"0"));
        if (HussarUtils.isEmpty((Object)list)) {
            throw new BaseException("\u672a\u67e5\u8be2\u5230\u79df\u6237\uff01");
        }
    }
}

